<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class acc_perkiraan extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_acc_perkiraan');				
	}

	public function index(){
		if(!fcek_hak_akses('.AP0.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['per_page'] = 15;
		$data['request_from'] = 'list';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/acc_perkiraan/v_acc_perkiraan_list', $data);
		$this->load->view('v_footer');			
	}

	public function acc_perkiraan_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_perkiraan');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['acc_perkiraan_list'] = $this->m_acc_perkiraan->get_acc_perkiraan_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['acc_perkiraan_list']);
		}
		else {
			$pagination['total_list'] = $this->m_acc_perkiraan->get_acc_perkiraan_list($arr_filter, true);	
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['acc_perkiraan_list'] = $this->load->view('data_master/acc_perkiraan/v_acc_perkiraan_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}
	
	public function acc_perkiraan_new(){	
		if(!fcek_hak_akses('.AP1.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/acc_perkiraan/v_acc_perkiraan_form',$data);
		$this->load->view('v_footer');			
	}

	public function acc_perkiraan_view($msap_no = null){
		if(!fcek_hak_akses('.AP0.')) {
			redirect('forbidden');
		}

		if (is_null($msap_no) || count($this->m_acc_perkiraan->get_acc_perkiraan($msap_no)) <= 0) {
			redirect('acc_perkiraan');
			return;
		}
		$data = array();
		$data['action'] = 'view';				
		$data['acc_perkiraan'] = $this->m_acc_perkiraan->get_acc_perkiraan($msap_no);	
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/acc_perkiraan/v_acc_perkiraan_form',$data);
		$this->load->view('v_footer');														
	}

	public function acc_perkiraan_new_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_perkiraan');

		$result = array();					 
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{			
			if($this->m_acc_perkiraan->get_acc_perkiraannm(null, fhapus_kutip($this->input->post('msap_nm'))) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Account perkiraan name already exists');
				echo json_encode($result);			
			}else{							
				$data = array();			
				$data['msap_no'] = $this->m_acc_perkiraan->acc_perkiraan_kode_auto($this->input->post('msas_no'));
				$data['msap_nm'] = fhapus_kutip($this->input->post('msap_nm'));							
				$data['msap_listmscb'] = (($this->input->post('msap_listmscb') != '') ? ".". implode('.', $this->input->post('msap_listmscb')). "." : '');				
				$data['msap_aktif'] = 1; //(($this->input->post('msap_aktif') == 'on') ? 1 : 0);			
				$data['msap_lsupd'] = date('Y-m-d H:i:s');
				$data['msap_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_acc_perkiraan->acc_perkiraan_new_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');
					$result['response'] = 'sukses';				
		  	 		$result['msap_no'] = $data['msap_no'];	      	 		
		  	 		echo json_encode($result);
				}			
			}	
		}				        
	}

	public function acc_perkiraan_edit_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_perkiraan');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{
			$data_status['msap_listmscb'] = (($this->input->post('msap_listmscb') != '') ? ".". implode('.', $this->input->post('msap_listmscb')). "." : '');			
			$data_status['msas_no'] = $this->input->post('msas_no');
			if(fcek_status($data_status)){
				$result['response'] = 'gagal';
				$result['error_message'] = array('fail'=>'Can not save [OFF] status');
				echo json_encode($result);		     	
			}else if($this->m_acc_perkiraan->get_acc_perkiraannm($this->input->post('msas_no'). '.'. $this->input->post('msap_no'), fhapus_kutip($this->input->post('msap_nm'))) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Account Perkiraan name already exists');
				echo json_encode($result);			
			}else{			     	
				$data = array();
				$data['msap_no'] = $data_status['msas_no']. ".".$this->input->post('msap_no');
				$data['msap_nm'] = fhapus_kutip($this->input->post('msap_nm'));			
				$data['msap_listmscb'] = $data_status['msap_listmscb'];				
				//$data['msap_aktif'] = (($this->input->post('msap_aktif') == 'on') ? 1 : 0);			
				$data['msap_lsupd'] = date('Y-m-d H:i:s');
				$data['msap_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_acc_perkiraan->acc_perkiraan_edit_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');			
					$result['response'] = 'sukses';				
		  	 		$result['msap_no'] = $data['msap_no'];			
		  	 		echo json_encode($result);
				}				
			}	
		}				        
	}	

	public function acc_perkiraan_aktif_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_perkiraan');

		$data['msap_no'] = $this->input->post('msap_no');
		$data['msap_aktif'] = $this->input->post('msap_aktif');

		if($this->m_acc_perkiraan->acc_perkiraan_aktif_simpan($data)){
			$this->session->set_userdata('alert_sukses','sukses');			
			$result['response'] = 'sukses';				
  	 		$result['msap_no'] = $data['msap_no'];			
  	 		echo json_encode($result);
		}
	}

	public function get_acc_perkiraan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_perkiraan');

		echo json_encode($this->m_acc_perkiraan->get_all_acc_perkiraan());			
	}

	public function acc_perkiraan_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_perkiraan');

		$data = array();
		$data['per_page'] = 13;
		$data['request_from'] = $this->input->post('request_from');
		$data['msag_jenis'] = $this->input->post('msag_jenis');
		
		$respon = array();
		$respon['popup'] = $this->load->view('data_master/acc_perkiraan/v_acc_perkiraan_popup',$data,true);	
		echo json_encode($respon);		
	}

	public function acc_perkiraan_autocomplete(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_perkiraan');
			
		$keyword = $this->input->post('query');
		$input_name = $this->input->post('input_name');		
		$data_acc_perkiraan = $this->m_acc_perkiraan->get_acc_perkiraan_autocomplete($input_name, $keyword);
		foreach ($data_acc_perkiraan as $key => $value) {
			$data_acc_perkiraan[$key]['value'] = $value[$input_name];			
		}
		$data_acc_perkiraan['suggestions'] = $data_acc_perkiraan;
		echo json_encode($data_acc_perkiraan);
	}

	public function acc_perkiraan_autocomplete_k(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_perkiraan');

		$keyword = $this->input->post('query');
		if (strpos($keyword, '-') !== FALSE) {
			$keyword = substr($keyword, 0, 11);
		}		
		$data_acc_perkiraan = $this->m_acc_perkiraan->get_acc_perkiraan_autocomplete_k($keyword);
		foreach ($data_acc_perkiraan as $key => $value) {
			$data_acc_perkiraan[$key]['value'] = $value['msap_nm'];			
		}
		$data_acc_perkiraan['suggestions'] = $data_acc_perkiraan;
		echo json_encode($data_acc_perkiraan);
	}


	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'msas_no',
		                'label' => 'Account Sub ID',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        ),	        
		        array(
		                'field' => 'msap_nm',
		                'label' => 'Account Perkiraan Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'msap_listmscb[]',
		                'label' => 'Area',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )

		);
		return $config;
	}	

}