<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class apv_pr extends MY_Controller {
	private $data = array();

	function __construct(){
		parent::__construct();
		$this->load->model('purchase/m_apv_pr');
		$this->load->model('purchase/m_purchase_request');
		$this->load->model('setting/m_user_log');
		error_reporting(E_ALL ^ (E_NOTICE));		
	}

	public function index(){
		if(!fcek_hak_akses('.BB0.')) {
			redirect('forbidden');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('purchase/apv_pr/v_apv_pr_list', $data);
		$this->load->view('v_footer');			
	}

	public function apv_pr_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'apv_pr');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');		
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['apv_pr_list'] = $this->m_apv_pr->get_apv_pr_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['apv_pr_list']);
		}
		else {
			$pagination['total_list'] = $this->m_apv_pr->get_apv_pr_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['apv_pr_list'] = $this->load->view('purchase/apv_pr/v_apv_pr_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}


	public function apv_pr_print(){
		$this->load->library('java_bridge');
		$appr_no = $this->input->get('appr_no');
		$paper_size = $this->input->get('paper_size');

		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];

		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}
		

		if($paper_size == 'A5'){
			$path = APPPATH.'prints\purchase\apv_pr\p_apv_pr_A5.jrxml';
		}elseif($paper_size == 'A4') {
			$path = APPPATH.'prints\purchase\apv_pr\p_apv_pr_A4.jrxml';
		}		
		$params = new Java("java.util.HashMap");
		$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
		$params->put("P_APPR_NO",new Java('java.lang.String', $appr_no));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$this->java_bridge->print_data($path, $params);
	}

	public function apvpr_detail_list(){		
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'apv_pr');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');		
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['apvpr_detail_list'] = $this->m_apv_pr->apvpr_detail_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['apvpr_detail_list']);
		}
		else {
			$pagination['total_list'] = $this->m_apv_pr->apvpr_detail_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['apvpr_detail_list'] = $this->load->view('purchase/apv_pr/v_apvpr_detail_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function get_apvpr_detail(){									
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'apv_pr');
		
		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			

		echo json_encode($this->m_apv_pr->get_apvpr_detail($arr_filter));
	}

	public function apv_pr_new($trpr_no = null){	
		if(!fcek_hak_akses('.BB1.')) {
			redirect('forbidden');
		}

		$data = array();
		if(is_null($trpr_no)){			
			$data['action'] = 'new';			
		}else{			
			$data['action'] = 'new_import';			
			$data['trpr_no'] = $trpr_no;
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('purchase/apv_pr/v_apv_pr_form',$data);
		$this->load->view('v_footer');		
	}

	public function apv_pr_view($appr_no){	
		if(!fcek_hak_akses('.BB0.')) {
			redirect('forbidden');
		}

		if (is_null($appr_no) || !$this->m_apv_pr->cek_appr_no_exists($appr_no)) {
			redirect('apv_pr');
			return;
		}
		//$data['trpr_no'] = "";

		$data = array();
						
		$data = $this->m_apv_pr->get_apv_pr($appr_no);
		// $data['detail_lm'] = json_encode($data['detail']);
		unset($_SESSION['detail_lm']);
		$this->session->set_userdata('detail_lm',$data['detail']);
		
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		$data['action'] = 'view';
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('purchase/apv_pr/v_apv_pr_form',$data);
		$this->load->view('v_footer');		
	}

	public function apv_pr_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'apv_pr');
		$vok = true;

		// set data transaksi
		if($vok){										
			$this->data['action'] = $this->input->post('action');			

			if($this->data['action'] == 'NEW'){
				$appr_mscb_no = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$appr_tgl = $this->input->post('appr_tgl');
				$bulan = substr($appr_tgl, 5, 2);			
				$tahun = substr($appr_tgl, 2, 2);			
				$appr_kode_depan = $appr_mscb_no."AP".$tahun.$bulan;
				$this->data['header']['appr_no'] = $this->m_apv_pr->apv_pr_kode_auto($appr_kode_depan);
				$this->data['header']['appr_tgl'] = $appr_tgl;
				$this->data['header']['appr_mscb_no'] = $appr_mscb_no;			
				$this->data['header']['appr_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['header']['appr_void'] = 0;
			}

			if($this->data['action'] != 'NEW'){
				$this->data['header']['appr_no'] = $this->input->post('appr_no');				
				// $this->data['detail_lm'] = $this->input->post('detail_lm');
			}
			
			$this->data['header']['appr_catatan'] = fhapus_kutip($this->input->post('appr_catatan'));
			$this->data['header']['appr_tag'] = fhapus_kutip($this->input->post('appr_tag'));						
			$this->data['header']['appr_lsupd'] = date('Y-m-d H:i:s');
			$this->data['header']['appr_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];

			if($this->data['action'] == 'EDIT' || $this->data['action'] == 'VOID'){
				$this->data['userlog']['msul_tgl'] = date('Y-m-d H:i:s');
				$this->data['userlog']['msul_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['userlog']['msul_catatan'] = substr(trim('['.$this->data['action']. '] APV.PR '. $this->data['header']['appr_no']. ' '. fhapus_kutip($this->input->post('appr_tag')). ' '. fhapus_kutip($this->input->post('appr_catatan'))), 0, 250);
			}
					
			$dappr = $this->input->post('dappr');
						
			if(count($dappr) > 0){
				foreach ($dappr as $key => $value) {				
					for ($i=0; $i < count($dappr[$key]); $i++) {											
						if($dappr['dappr_mspd_no'][$i] != ''){
							$this->data['detail'][$i]['dappr_no'] = $this->data['header']['appr_no'];
							if($key == 'dappr_qtyreq' || $key == 'dappr_qtyapv'){
								$this->data['detail'][$i][$key] = ftodouble($value[$i]);
							}else{
								$this->data['detail'][$i][$key] = $value[$i];
							}									
						}					
					}
				}
			}			
		}				

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);				
			}
		}	
		
		// simpan data
		if($vok){						
			$vresult = $this->m_apv_pr->apv_pr_simpan($this->data);
			if($vresult == 0){				
				$vok = false;
				$msg = array('error'=>'Error query');				
			}
		}			

		// berhasil simpan data
		if($vok){												
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';				
  	 		$result['appr_no'] = $this->data['header']['appr_no'];      	 		
		}				        

		// gagal simpan data
		if(!$vok){									
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;							
		}		

		echo json_encode($result);		        
	}

	public function apvpr_detail_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'apv_pr');

		$data = array();		
		$data['tipe_trans'] = $this->input->post('tipe_trans');		
		$data['mssp_no'] = $this->input->post('mssp_no');		
		
		$respon = array();
		$respon['popup'] = $this->load->view('purchase/apv_pr/v_apvpr_detail_popup',$data,true);	
		echo json_encode($respon);		
	}

	private function cek_valid_data_trans($menu, $data){
			// keterangan :
			// $menu = NEW | EDIT | VOID

			$msg = '';
			$hsl = true;			

			// cek produk required
			if($hsl){				
				if(!isset($data['detail'])){
					$hsl = false;					
					$msg = 'Please select product';					
				}
			}			
			
			// utk pengecekan cekint
			// Valid = CekInt tidak berubah
			if($hsl && ($menu == 'NEW' || $menu == 'EDIT' || $menu == 'VOID')){
				if(isset($data['detail'])){
					foreach ($data['detail'] as $key => $value) {						
						if($this->m_purchase_request->get_purchase_request_cekint($data['detail'][$key]['dappr_dtpr_no'],
																			$data['detail'][$key]['dappr_dtpr_seq'],
																			$data['detail'][$key]['dtpr_cekint']) == false){							
							$hsl = false;
							$msg = 'Data have been changed by another user. Please Refresh the page';
							break;		
						}
					}						
				}	
			}

			if ($hsl && ($menu == 'EDIT' || $menu == 'VOID')) {
				$data['detail_lm'] = $this->session->userdata('detail_lm');
				if(isset($data['detail_lm'])){
					foreach ($data['detail_lm'] as $key => $value) {						
						if($this->m_purchase_request->get_purchase_request_cekint($data['detail_lm'][$key]['dappr_dtpr_no'],
																			$data['detail_lm'][$key]['dappr_dtpr_seq'],
																			$data['detail_lm'][$key]['dtpr_cekint']) == false ||
							$this->m_apv_pr->get_apv_pr_cekint($data['detail_lm'][$key]['dappr_no'],
																$data['detail_lm'][$key]['dappr_seq'],
																$data['detail_lm'][$key]['dappr_cekint']) == false){		
							$hsl = false;
							$msg = 'Data have been changed by another user. Please Refresh the page';
							break;		
						}							
					}									
				}
				unset($_SESSION['po_detail_lm']);	
			}

			// Update cekint
			if($hsl && ($menu == 'NEW' || $menu == 'EDIT' || $menu == 'VOID')){
				if(isset($data['detail'])){
					foreach ($data['detail'] as $key => $value) {												
							$this->m_purchase_request->set_purchase_request_cekint($data['detail'][$key]['dappr_dtpr_no'],
																					$data['detail'][$key]['dappr_dtpr_seq']);						
						unset($this->data['detail'][$key]['dtpr_cekint']);
					}						
				}	
			}

			if ($hsl && ($menu == 'EDIT' || $menu == 'VOID')) {
				$data['detail_lm'] = $this->session->userdata('detail_lm');
				if(isset($data['detail_lm'])){
					foreach ($data['detail_lm'] as $key => $value) {												
						$this->m_purchase_request->set_purchase_request_cekint($data['detail_lm'][$key]['dappr_dtpr_no'],
																				$data['detail_lm'][$key]['dappr_dtpr_seq']);
						$this->m_apv_pr->set_apv_pr_cekint($data['detail_lm'][$key]['dappr_no'],
															$data['detail_lm'][$key]['dappr_seq']);						
					}	
				}
				unset($_SESSION['po_detail_lm']);									
			}
			return array('valid'=>$hsl, 'msg'=>$msg);
	}

}	