<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class costcenter extends MY_Controller {	
	private $data = array();

	function __construct(){
		parent::__construct();	
		$this->load->model('data_master/m_costcenter');				
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function index(){			
		// cek hak akses		
		if(!fcek_hak_akses('.AU0.')){				
			exit('Cannot access this page.');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/costcenter/v_costcenter_list', $data);
		$this->load->view('v_footer');			
	}

	public function costcenter_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'costcenter');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['costcenter_list'] = $this->m_costcenter->get_costcenter_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['costcenter_list']);
		}
		else {
			$pagination['total_list'] = $this->m_costcenter->get_costcenter_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['costcenter_list'] = $this->load->view('data_master/costcenter/v_costcenter_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function costcenter_new()
	{
		// cek hak akses		
		if(!fcek_hak_akses('.AU1.')){				
			exit('Cannot access this page.');
		}		
		
		$data['action'] = 'NEW';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/costcenter/v_costcenter_form',$data);
		$this->load->view('v_footer');		
	}

	public function costcenter_view()
	{
		// cek hak akses		
		if(!fcek_hak_akses('.AU1.')){				
			exit('Cannot access this page.');
		}
		
		$mscc_no = $this->input->get('mscc_no');
		$data = $this->m_costcenter->get_costcenter($mscc_no);								
		$data['action'] = 'VIEW';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/costcenter/v_costcenter_form',$data);
		$this->load->view('v_footer');			
	}

	public function costcenter_simpan()
	{
		// Proteksi supaya tidak bisa di akses dari URL 		
		if(!$this->input->is_ajax_request()) {
		   exit('No direct script access allowed');
		}

		$vok = true;
		$msg = '';

		// set data
		if($vok){
			$data = array();
			$data['action'] = $this->input->post('action');												
			$data['ms']['mscc_no'] = $this->input->post('mscc_no');																			
			$data['ms']['mscc_nm'] = fhapus_kutip($this->input->post('mscc_nm'));	
			$data['ms']['mscc_catatan'] = fhapus_kutip($this->input->post('mscc_catatan'));	
			$data['ms']['mscc_listmscb'] = (($this->input->post('mscc_listmscb') != '') ? ".". implode('.', $this->input->post('mscc_listmscb')). "." : '');
			$data['ms']['mscc_lsupd'] = date('Y-m-d H:i:s');
			$data['ms']['mscc_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];												
		}

		// cek form validation
		if($vok){
			$this->form_validation->set_rules($this->config_validation());
			if($this->form_validation->run() == FALSE){
				$vok = false;				
				$msg = $this->form_validation->error_array();
			}
		}

		// cek valid data
		if($vok) {
			$hasil_cek = $this->cek_valid_data($data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error_message'=>$hasil_cek['msg']);				
			}
		}

		// Simpan data
		if($vok){
			$vresult = $this->m_costcenter->costcenter_simpan($data);			
			if($vresult == 0){
				$vok = false;				
				$msg = array('error_message' => 'Error Query');
			}
		}		
		
		// Berhasil simpan data
		if($vok){
			$this->session->set_userdata('response','sukses');
			$result['response'] = 'sukses';
  	 		$result['mscc_no'] = $data['ms']['mscc_no'];
		}
				
		// Gagal simpan data							
		if(!$vok){
			$result['response'] = 'gagal';  	 		
  	 		$result['error_message'] = $msg;	  	 		
		}	

		echo json_encode($result);
	}		

	public function select_costcenter_fromtrju(){
		// Proteksi supaya tidak bisa di akses dari URL 		
		if(!$this->input->is_ajax_request()) {
		   exit('No direct script access allowed');
		}
			
		$data['keyword'] = $this->input->get('search');		
		$data['trju_no'] = $this->input->get('trju_no');		
		$data_costcenter = $this->m_costcenter->get_costcenter_fromtrju($data);

		foreach ($data_costcenter as $key => $value) {
			$data_costcenter[$key]['id'] = $value['mscc_no'];			
			$data_costcenter[$key]['text'] = $value['mscc_nm'];			
		}
		
		$data['results'] = $data_costcenter;
		echo json_encode($data);
	}

	private function config_validation(){
		$config = array(		        
					array(
			                'field' => 'mscc_listmscb[]',
			                'label' => 'Area',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Please input %s. <br>',			                        
			                )
			        ),
			        array(
			                'field' => 'mscc_no',
			                'label' => 'Cost Center #',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Please input %s. <br>',			                        
			                )
			        ),
			        array(
			                'field' => 'mscc_nm',
			                'label' => 'Cost Center Name',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Please input %s. <br>',			                        
			                )
			        )			          
		);		

		return $config;
	}

	private function cek_valid_data($data){
		$vok = true;
		$msg = '';
		
		if($data['action'] == 'NEW'){			
			// cek ID Cost Center tidak boleh sama saat buat baru
			if($vok && $this->m_costcenter->is_mscc_no_exists($data['ms']['mscc_no'])){				
				$vok = false;
				$msg = 'Cost Center # already exists.';				
			}

			// cek nama Cost Center tidak boleh sama saat buat baru
			if($vok && $this->m_costcenter->is_mscc_nm_exists($data['ms']['mscc_nm'])){				
				$vok = false;
				$msg = 'Cost Center Name already exists.';				
			}
		}
		
		if($data['action'] == 'EDIT'){
			// cek nama Cost Center tidak boleh sama saat edit
			if($vok && $this->m_costcenter->is_mscc_nm_exists($data['ms']['mscc_nm'], $data['ms']['mscc_no'])){
				$vok = false;
				$msg = 'Cost Center Name already exists.';				
			}		
		}			

		return array('valid'=>$vok, 'msg'=>$msg);
	}

}