<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class currency_rates extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('setting/m_currency_rates');	
	}

	public function index(){
		if(!fcek_hak_akses('.FA0.')) {
			redirect('forbidden');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		$data['currency_rates'] = $this->m_currency_rates->get_currency_rates();
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('setting/v_currency_rates_form', $data);
		$this->load->view('v_footer');			
	}

	public function currency_rates_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'forbidden');

		$currency_rates = fhapus_kutip(ftodouble($this->input->post('simr_no')));

		if($currency_rates < 0){
			$result['response'] = 'gagal';
			$result['error_message'] = array('error'=>'Currency rates must be => 0');
			echo json_encode($result);
			return;
		}
		
		$vresult = $this->m_currency_rates->set_currency_rates($currency_rates);

		if($vresult == 1){			
			$result['response'] = 'sukses';				  	 	
			$result['simr_doub'] = $currency_rates;
  	 		echo json_encode($result);
		}else{
			$result['response'] = 'gagal';
			$result['error_message'] = array('error'=>'Error query');
			echo json_encode($result);
		}

	}

}