<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class goods_transformation extends MY_Controller {
	private $data = array();
	private $vok = true;

	function __construct(){
		parent::__construct();
		$this->load->model('stok_kontrol/m_goods_transformation');				
		$this->load->model('stok_kontrol/m_stok');
		$this->load->model('finance_and_acc/m_jurnal');
		$this->load->model('data_master/m_kategori');
		$this->load->model('setting/m_setting');
		$this->load->model('data_master/m_gudang');
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function index($tipe_trans = null){		

		if($tipe_trans == null || $tipe_trans == 'F' || $tipe_trans == 'f') {
			if(!fcek_hak_akses('.HB7.')){
				redirect('forbidden');
			}

			$tipe_trans = 'F';
		} else {
			if(!fcek_hak_akses('.HB8.')){
				redirect('forbidden');
			}

			if(($this->session->userdata('svlogin') == 'C') && ($tipe_trans == 'C' || $tipe_trans == 'c')) {
				$tipe_trans = 'C';
			} else {
				redirect('goods_transformation');
			}
		}
		// if($tipe_trans != null){			
		// 	if($this->session->userdata('svlogin') == 'C' && $tipe_trans != 'F' && $tipe_trans != 'C' ||
		// 		$this->session->userdata('svlogin') == 'F' && $tipe_trans != null && $tipe_trans != 'F'){				
		// 		redirect('goods_transformation');
		// 	}
		// }

		$data = array();
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		// $data['tipe_trans']	= ($tipe_trans == null || $tipe_trans == 'F') ? 'F' : 'C';
		$data['tipe_trans']	= $tipe_trans;
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('stok_kontrol/goods_transformation/v_goods_transformation_list',$data);
		$this->load->view('v_footer');			
	}

	public function goods_transformation_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'goods_transformation');
		
		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['goods_transformation_list'] = $this->m_goods_transformation->get_goods_transformation_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['goods_transformation_list']);
		}
		else {
			$pagination['total_list'] = $this->m_goods_transformation->get_goods_transformation_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['goods_transformation_list'] = $this->load->view('stok_kontrol/goods_transformation/v_goods_transformation_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}	

	public function goods_transformation_new($tipe_trans = null){	
		if(!fcek_hak_akses('.DE1.')) {
			redirect('forbidden');
		}

		if($tipe_trans == null || $tipe_trans == 'F' || $tipe_trans == 'f') {
			$tipe_trans = 'F';
		} else {
			if(($this->session->userdata('svlogin') == 'C') && ($tipe_trans == 'C' || $tipe_trans == 'c')) {
				$tipe_trans = 'C';
			} else {
				redirect('goods_transformation');
			}
		}

		// if($tipe_trans != null){			
		// 	if($this->session->userdata('svlogin') == 'C' && $tipe_trans != 'F' && $tipe_trans != 'C' ||
		// 		$this->session->userdata('svlogin') == 'F' && $tipe_trans != null && $tipe_trans != 'F'){				
		// 		redirect('goods_transformation');
		// 	}
		// }

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		// $data['tipe_trans']	= ($tipe_trans == null || $tipe_trans == 'F') ? 'F' : 'C';
		$data['tipe_trans']	= $tipe_trans;
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('stok_kontrol/goods_transformation/v_goods_transformation_form',$data);
		$this->load->view('v_footer');		
	}

	public function goods_transformation_view($trts_no){	
		if(!fcek_hak_akses('.DE0.')) {
			redirect('forbidden');
		}

		if (is_null($trts_no) || !$this->m_goods_transformation->get_goods_transformation($trts_no)) {
			redirect('goods_transformation');
			return;
		}
		$data = array();				
		$data = $this->m_goods_transformation->get_goods_transformation($trts_no);			

		$trju_no = $this->m_jurnal->get_jurnalid($trts_no.'GT');
		if($trju_no != false){			
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_no);			
			$data['jurnal_h'] = $data_jurnal['jurnal_h'];
			$data['jurnal_d'] = $data_jurnal['jurnal_d'];			
		}
			
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		$data['action'] = 'view';
		$data['tipe_trans']	= $data['header']['trts_fin'];
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('stok_kontrol/goods_transformation/v_goods_transformation_form',$data);
		$this->load->view('v_footer');		
	}

	public function goods_transformation_print(){
		$this->load->library('java_bridge');
		$trts_no = $this->input->get('trts_no');
		$paper_size = $this->input->get('paper_size');

		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];

		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}

		if($paper_size == 'A5'){
			$path = APPPATH.'prints\stok_kontrol\goods_transformation\p_goods_transformation_A5.jrxml';					
		}elseif($paper_size == 'A4') {
			$path = APPPATH.'prints\stok_kontrol\goods_transformation\p_goods_transformation_A4.jrxml';					
		}		
		$params = new Java("java.util.HashMap");			
		$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
		$params->put("P_TRTS_NO",new Java('java.lang.String', $trts_no));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$this->java_bridge->print_data($path, $params);
	}

	public function goods_transformation_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'goods_transformation');		
		$this->form_validation->set_rules($this->config_validation());		
		$vok = true;

		// set data
		if($vok) {			
			$this->data['action'] = $this->input->post('action');
			$this->data['trts_cekint'] = $this->input->post('trts_cekint');

			if($this->data['action'] == 'NEW'){			
				$trts_mscb_no = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$trts_tgl = $this->input->post('trts_tgl');
				$bulan = substr($trts_tgl, 5, 2);			
				$tahun = substr($trts_tgl, 2, 2);			
				$separator = ($this->input->post('trts_fin') == 'F') ? '-' : '_';
				$trts_kode_depan = $trts_mscb_no."GT".$tahun.$bulan.$separator;
				$this->data['header']['trts_no'] = $this->m_goods_transformation->goods_transformation_kode_auto($trts_kode_depan);
				$this->data['header']['trts_mscb_no'] = $trts_mscb_no;
				$this->data['header']['trts_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['header']['trts_tgl'] = $trts_tgl;
				$this->data['header']['trts_void'] = 0;			
				$this->data['header']['trts_fin'] = $this->input->post('trts_fin');
				$this->data['header']['trts_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trts_fin') == 'C') ? 'A' : 'R';			
			}

			if($this->data['action'] != 'NEW'){
				$this->data['header']['trts_no'] = $this->input->post('trts_no');	
			}
			
			$this->data['header']['trts_msgd_no'] = $this->input->post('trts_msgd_no');			
			$this->data['header']['trts_catatan'] = fhapus_kutip($this->input->post('trts_catatan'));
			$this->data['header']['trts_tag'] = fhapus_kutip($this->input->post('trts_tag'));						
			$this->data['header']['trts_lsupd'] = date('Y-m-d H:i:s');
			$this->data['header']['trts_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];												

			if($this->data['action'] == 'EDIT' || $this->data['action'] == 'VOID'){
				$this->data['userlog']['msul_tgl'] = date('Y-m-d H:i:s');
				$this->data['userlog']['msul_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['userlog']['msul_catatan'] = substr(trim('['.$this->data['action']. '] GOODS.TFM '. $this->data['header']['trts_no']. ' '.fhapus_kutip($this->input->post('trts_tag')). ' '. fhapus_kutip($this->input->post('trts_catatan'))), 0, 250);
			}

			$dtts = $this->input->post('dtts');					
			
			if(isset($dtts)){
				foreach ($dtts as $key => $value) {
					for ($i=0; $i < count($dtts[$key]); $i++) { 																
						if($dtts['dtts_mspd_no'][$i] != ''){
							$this->data['detail_prod'][$i]['dtts_no'] = $this->data['header']['trts_no'];
							if($key == 'dtts_qty' || $key == 'dtts_hpp'){
								$this->data['detail_prod'][$i][$key] = ftodouble($value[$i]);														
							}else{
								$this->data['detail_prod'][$i][$key] = $value[$i];
							}						
						}					
					}
				}
			}

			$dttsap = $this->input->post('dttsap');				
			
			if(isset($dttsap)){
				foreach ($dttsap as $key => $value) {
					for ($i=0; $i < count($dttsap[$key]); $i++){					
						if($dttsap['dttsap_msap_no'][$i] != ''){
							$this->data['detail_acc'][$i]['dttsap_no'] = $this->data['header']['trts_no'];
							if($key == 'dttsap_total'){
								$this->data['detail_acc'][$i][$key] = ftodouble($value[$i]);
							}else{
								$this->data['detail_acc'][$i][$key] = $value[$i];
							}												
						}
					}
				}												
			}
		}			

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;				
				$msg = $this->form_validation->error_array();								
			}
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal($this->data);			
		}

		// cek valid data jurnal				
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_jurnal($this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}

		// simpan data
		if ($vok) {		
			$vresult = $this->m_goods_transformation->goods_transformation_simpan($this->data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}		
		}			

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['trts_no'] = $this->data['header']['trts_no'];
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);									       
	}

	private function set_data_jurnal($data){		
		// set jurnal
		//VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV			
			//Set header jurnal
			//--------------------------------------------------------------------------------				
			if($data['action'] == 'NEW'){
				$trju_tgl = $data['header']['trts_tgl'];
				$trju_tipe = 'A';
				$bulan = substr($trju_tgl, 5, 2);			
				$tahun = substr($trju_tgl, 2, 2);			
				$separator = ($this->input->post('trts_fin') == 'F') ? '-' : '_';
				$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;
				$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);
				$data['jurnal_h']['trju_refno'] = $data['header']['trts_no'].'GT';
				$data['jurnal_h']['trju_reftipe'] = 'GT';
				$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$data['jurnal_h']['trju_tgl'] = $trju_tgl;
				$data['jurnal_h']['trju_tipe'] = $trju_tipe;				
				$data['jurnal_h']['trju_void'] = 0;
				$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trts_fin') == 'C') ? 'A' : 'R';
				$data['jurnal_h']['trju_fin'] = $this->input->post('trts_fin');
			}

			if($data['action'] != 'NEW'){
				$data['jurnal_h']['trju_no'] = $this->input->post('trju_no');
			}
			
			$gudang = $this->m_gudang->get_gudang($data['header']['trts_msgd_no']);
			$trju_catatan = $data['header']['trts_tag']. ' '.$data['header']['trts_no'].'/'.$gudang['msgd_no'].' - '.$gudang['msgd_nm'];
			$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));
			$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
			$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];			
			//----------------------------------------------------------------------------------								
			
			// Set account
			//-----------------------------------------------------------------------------------				
			$arr_acc_debet = array();
			$arr_acc_kredit = array();				
			$array = array();
			if(isset($data['detail_prod']) || isset($data['detail_acc'])){								
				if(isset($data['detail_prod'])){
					foreach ($data['detail_prod'] as $key => $value) {	
						$mskt_no = substr($data['detail_prod'][$key]['dtts_mspd_no'], 0, 1);									 						 					 		
					 	$saldo = round((ftodouble($data['detail_prod'][$key]['dtts_hpp']) * ftodouble($data['detail_prod'][$key]['dtts_qty'])), 4);
				 		// Account Inventory (Debet)
				 		if($data['detail_prod'][$key]['dtts_jenis'] == 'R'){				 		
							$array['dtju_msap_no'] = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
							$array['dtju_debet'] = $saldo;
							$array['dtju_kredit'] = 0;
							array_push($arr_acc_debet, $array);
						}

						// Account Inventory (Kredit)
				 		if($data['detail_prod'][$key]['dtts_jenis'] == 'F'){				 		
							$array['dtju_msap_no'] = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
							$array['dtju_debet'] = 0;
							$array['dtju_kredit'] = $saldo;
							array_push($arr_acc_kredit, $array);
						}																		
					}
				}

				if(isset($data['detail_acc'])){												
					foreach ($data['detail_acc'] as $key => $value) {				 					 	
					 	$saldo = ftodouble($data['detail_acc'][$key]['dttsap_total']);
				 		// Account (Debet)
				 		if($data['detail_acc'][$key]['dttsap_jenis'] == 'R'){				 		
							$array['dtju_msap_no'] = $data['detail_acc'][$key]['dttsap_msap_no'];
							$array['dtju_debet'] = $saldo;
							$array['dtju_kredit'] = 0;
							array_push($arr_acc_debet, $array);
						}

						// Account (Kredit)
				 		if($data['detail_acc'][$key]['dttsap_jenis'] == 'F'){				 		
							$array['dtju_msap_no'] = $data['detail_acc'][$key]['dttsap_msap_no'];
							$array['dtju_debet'] = 0;
							$array['dtju_kredit'] = $saldo;
							array_push($arr_acc_kredit, $array);
						}																		
					}							
				}												
				$this->data['jurnal_d'] = array_merge($arr_acc_debet, $arr_acc_kredit);
			}								
			//--------------------------------------------------------------------------------
			$this->data['jurnal_h'] = $data['jurnal_h'];			
		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^		
	}

	private function cek_valid_data_jurnal($data){		
		$msg = '';
		$hsl = true;

		//cek akun perkiraan di master kategori harus diisi
		if($hsl){
			if(isset($data['detail_prod'])){
				foreach ($data['detail_prod'] as $key => $value) {
					$mskt_no = substr($data['detail_prod'][$key]['dtts_mspd_no'], 0, 1);					
					if(!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv')){
						$hsl = false;						
						$msg = 'There is an account not yet filled in Category Master';						
					}								
				}
			}
		}

		return array('valid'=>$hsl, 'msg'=>$msg);
	}

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'trts_msgd_no',
		                'label' => 'Warehouse',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )
		);
		return $config;
	}

	public function cek_valid_data_trans($menu, $data){
			// keterangan :
			// $menu = NEW | EDIT | VOID

			$msg = '';
			$hsl = true;
			$tgl_cls_jurnal = $this->m_setting->get_setting('simr_char1','tcj', 1);

			if($hsl && ($menu == 'NEW' || $menu == 'EDIT' || $menu == 'VOID')){
				// transaksi tidak bisa di buat/edit/void jika tgl/bln jurnal sudah di closing
				$tgl_trans = $this->input->post('trts_tgl');
				$tahun = substr($tgl_trans, 0, 4);
				$bulan = substr($tgl_trans, 5, 2);	
				$tgl_trans = (int)$tahun.$bulan;

				if($hsl && $tgl_trans <= $tgl_cls_jurnal){
					$hsl = false;					
					$msg = 'Can not create new/edit/void transaction if journal transaction date is closed. Please choose another date.';					
				}
			}

			// Transaksi yang sudah di rekonsiliasi tidak bisa di edit/void/cancel
			if($hsl && ($menu == 'EDIT' || $menu == 'VOID')){			
				if($this->m_app->is_recon_exists($data['header']['trts_no'].'GT')){
					$hsl = false;
					$msg = 'Transactions cannot be changed. Journal already in reconciliation';
				}
			}

			// cek produk harus diisi						
			if($hsl){				
				if(!isset($data['detail_prod'])){
					$hsl = false;					
					$msg = 'Please select produk';					
				}
			}

			// cek akun perkiraan harus diisi						
			// if($hsl){				
			// 	if(!isset($data['detail_acc'])){
			// 		$hsl = false;					
			// 		$msg = 'Please select account';					
			// 	}
			// }

			// cek total harus sama
			if($hsl){		
				if(ftodouble($this->input->post('trts_totalfrom')) != ftodouble($this->input->post('trts_totalresult')) ||
					ftodouble($this->input->post('trts_totalfrom')) == '' || ftodouble($this->input->post('trts_totalfrom')) == ''){
					$hsl = false;					
					$msg = 'Total must be the same';					
				}
			}	

			// utk pengecekan cekint Goods Transformation, 
			// Valid = CekInt tidak berubah
			if ($hsl && $menu != 'NEW') {
				if($this->m_goods_transformation->get_goods_transformation_cekint($data['header']['trts_no'], $data['trts_cekint']) == false){
					$hsl = false;
					$msg = 'Data have been changed by another user. Please Refresh the page';
				}else{
					$this->m_goods_transformation->set_goods_transformation_cekint($data['header']['trts_no']);
				}
			}
			
			return array('valid'=>$hsl, 'msg'=>$msg);
	}	
	
}