<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class gudang extends MY_Controller {

	function __construct(){
		parent::__construct();		
		$this->load->model('data_master/m_gudang');
	}

	public function index(){		
		if(!fcek_hak_akses('.AI0.')) {
			redirect('forbidden');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/gudang/v_gudang_list', $data);
		$this->load->view('v_footer');			
	}

	public function gudang_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'gudang');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['gudang_list'] = $this->m_gudang->get_gudang_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['gudang_list']);
		}
		else {
			$pagination['total_list'] = $this->m_gudang->get_gudang_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['gudang_list'] = $this->load->view('data_master/gudang/v_gudang_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}	

	public function gudang_new(){	
		if(!fcek_hak_akses('.AI1.')) {
			redirect('forbidden');
		}		

		if($this->m_gudang->gudang_count_all() >= 30){			
			$this->session->set_userdata('alert_gagal','gagal');
			redirect('gudang');
		}else{
			$data = array();
			$data['action'] = 'new';
			$data['key'] = uniqid();
			$data['hash_key'] = fenkripsi($data['key']);
			if($this->session->userdata('svlogin') == 'F'){
				$this->load->view('v_navigation_f');
			}else{
				$this->load->view('v_navigation');
			}
			$this->load->view('data_master/gudang/v_gudang_form',$data);
			$this->load->view('v_footer');		
		}
	}

	public function gudang_view($msgd_no){	
		if(!fcek_hak_akses('.AI0.')) {
			redirect('forbidden');
		}

		if (is_null($msgd_no) || count($this->m_gudang->get_gudang($msgd_no)) <= 0) {
			redirect('gudang');
			return;
		}
		$data = array();
		$data['action'] = 'view';		
		$data['gudang'] = $this->m_gudang->get_gudang($msgd_no);
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/gudang/v_gudang_form',$data);
		$this->load->view('v_footer');		
	}

	public function gudang_new_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'gudang');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{								
			if($this->m_gudang->get_gudangnm(null,$this->input->post('msgd_nm')) != 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('error' => 'Gudang Name already exists');
				echo json_encode($result);
			}else{	
				$data = array();				
				$data['msgd_no'] = $this->m_gudang->gudang_kode_auto();
				$data['msgd_nm'] = fhapus_kutip($this->input->post('msgd_nm'));							
				$data['msgd_avl'] = $this->input->post('msgd_avl');
				$data['msgd_listmscb'] = $this->input->post('msgd_listmscb');
				$data['msgd_catatan'] = fhapus_kutip($this->input->post('msgd_catatan'));
				$data['msgd_alamat'] = fhapus_kutip($this->input->post('msgd_alamat'));
				$data['msgd_kota'] = fhapus_kutip($this->input->post('msgd_kota'));
				$data['msgd_pic'] = fhapus_kutip($this->input->post('msgd_pic'));
				$data['msgd_telp'] = fhapus_kutip($this->input->post('msgd_telp'));
				$data['msgd_email'] = fhapus_kutip($this->input->post('msgd_email'));
				$data['msgd_aktif'] = 1; //(($this->input->post('msgd_aktif') == 'on') ? 1 : 0);			
				$data['msgd_lsupd'] = date('Y-m-d H:i:s');
				$data['msgd_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_gudang->gudang_new_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');
					$result['response'] = 'sukses';				
		  	 		$result['msgd_no'] = $data['msgd_no'];	      	 		
		  	 		echo json_encode($result);
				}			
			}	
				
		}				        
	}

	public function gudang_edit_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'gudang');
					
		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{
			$data_status['msgd_listmscb'] = $this->input->post('msgd_listmscb');
			if(fcek_status($data_status)){
				$result['response'] = 'gagal';
				$result['error_message'] = array('fail'=>'Can not save [OFF] status');
				echo json_encode($result);		     	
			}else if($this->m_gudang->get_gudangnm($this->input->post('msgd_no'),fhapus_kutip($this->input->post('msgd_nm'))) != 0){
					$result['response'] = 'gagal';
					$result['error_message'] = array('error' => 'Gudang Name already exists');
					echo json_encode($result);
			}else{	
				$data = array();		     		
				$data['msgd_no'] = $this->input->post('msgd_no');
				$data['msgd_nm'] = fhapus_kutip($this->input->post('msgd_nm'));			
				$data['msgd_avl'] = $this->input->post('msgd_avl');
				$data['msgd_listmscb'] = $this->input->post('msgd_listmscb');
				$data['msgd_catatan'] = fhapus_kutip($this->input->post('msgd_catatan'));
				$data['msgd_alamat'] = fhapus_kutip($this->input->post('msgd_alamat'));
				$data['msgd_kota'] = fhapus_kutip($this->input->post('msgd_kota'));
				$data['msgd_pic'] = fhapus_kutip($this->input->post('msgd_pic'));
				$data['msgd_telp'] = fhapus_kutip($this->input->post('msgd_telp'));
				$data['msgd_email'] = fhapus_kutip($this->input->post('msgd_email'));
				//$data['msgd_aktif'] = (($this->input->post('msgd_aktif') == 'on') ? 1 : 0);			
				$data['msgd_lsupd'] = date('Y-m-d H:i:s');
				$data['msgd_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_gudang->gudang_edit_simpan($data)){	
					$this->session->set_userdata('alert_sukses','sukses');		
					$result['response'] = 'sukses';				
		  	 		$result['msgd_no'] = $data['msgd_no'];			
		  	 		echo json_encode($result);
				}				
			}				
		}				        
	}

	public function get_gudang(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'gudang');

		echo json_encode($this->m_gudang->get_all_gudang());				
	}

	public function gudang_aktif_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'gudang');

		$data['msgd_no'] = $this->input->post('msgd_no');
		$data['msgd_aktif'] = $this->input->post('msgd_aktif');

		if($this->m_gudang->gudang_aktif_simpan($data)){
			$this->session->set_userdata('alert_sukses','sukses');			
			$result['response'] = 'sukses';				
  	 		$result['msgd_no'] = $data['msgd_no'];			
  	 		echo json_encode($result);
		}
	}

	private function config_validation(){
		$config = array(		        
		        array(
		                'field' => 'msgd_nm',
		                'label' => 'Warehouse Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'msgd_listmscb[]',
		                'label' => 'Area',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )

		);
		return $config;
	}

}