<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class inventory extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('stok_kontrol/m_inventory');				
	}

	public function index(){			
		if(!fcek_hak_akses('.DA0.')) {
			redirect('forbidden');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('stok_kontrol/inventory/v_inventory_list', $data);
		$this->load->view('v_footer');			
	}

	public function inventory_list(){							
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'inventory');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');	
		$arr_filter['menu']	= 'INV_LIST';		
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');
		if(isset($arr_filter['inv_needtoorderitem'])){
			$arr_filter['inv_needtoorderitem'] = 'need_to_order_item';
		}
		$arr_option_filter = $this->input->post('arr_option_filter');
		
		$data['inventory_list'] = $this->m_inventory->get_inventory_list($arr_filter, $arr_option_filter, false, $per_page, $offset, $fn, $sort);					

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;				

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['inventory_list']);
		}
		else {
			$pagination['total_list'] = $this->m_inventory->get_inventory_list($arr_filter, $arr_option_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['inventory_list'] = $this->load->view('stok_kontrol/inventory/v_inventory_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function needtoorderitem_list(){							
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'inventory');

		$data = array();
		$result = array();
		$pagination = array();

		$per_page = $this->input->post('per_page');
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');
		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		if(isset($arr_filter['inv_needtoorderitem'])){
			$arr_filter['inv_needtoorderitem'] = 'need_to_order_item';
		}
		$arr_option_filter = $this->input->post('arr_option_filter');
		
		$data['inventory_list'] = $this->m_inventory->get_needtoorderitem_list($arr_filter, $arr_option_filter, false, $per_page, $offset, $fn, $sort);		

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;
				
		$pagination['total_list'] = $this->m_inventory->get_needtoorderitem_list($arr_filter, $arr_option_filter, true);		
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['needtoorderitem_list'] = $this->load->view('stok_kontrol/inventory/v_inventory_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];		
		
		echo json_encode($result);
	}		

}