<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class inventory_perarea extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('stok_kontrol/m_inventory_perarea');				
	}

	public function index(){			
		if(!fcek_hak_akses('.DF0.')) {
			redirect('forbidden');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('stok_kontrol/inventory_perarea/v_inventory_perarea_list', $data);
		$this->load->view('v_footer');			
	}

	public function inventory_perarea_list(){							
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'inventory_perarea');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		
		$arr_option_filter = $this->input->post('arr_option_filter');			

		$data['inventory_perarea_list'] = $this->m_inventory_perarea->get_inventory_perarea_list($arr_filter, $arr_option_filter, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['inventory_perarea_list']);
		}
		else {
			$pagination['total_list'] = $this->m_inventory_perarea->get_inventory_perarea_list($arr_filter, $arr_option_filter, $per_page, $offset, $fn, $sort, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['inventory_perarea_list'] = $this->load->view('stok_kontrol/inventory_perarea/v_inventory_perarea_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	// public function coba(){
	// 	var_dump($this->m_inventory_perarea->get_inventory_perarea_list(array(), array(), 15, 0, 'mspd_no', 'DESC'));		
	// }

}