<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class jenis_bayar extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_jenis_bayar');				
	}

	public function index(){
		if(!fcek_hak_akses('.AM0.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/jenis_bayar/v_jenis_bayar_list',$data);
		$this->load->view('v_footer');			
	}

	public function jenis_bayar_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'jenis_bayar');
		
		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['jenis_bayar_list'] = $this->m_jenis_bayar->get_jenis_bayar_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;			

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['jenis_bayar_list']);
		}
		else {
			$pagination['total_list'] = $this->m_jenis_bayar->get_jenis_bayar_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['jenis_bayar_list'] = $this->load->view('data_master/jenis_bayar/v_jenis_bayar_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}	

	public function jenis_bayar_new(){			
		if(!fcek_hak_akses('.AM1.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/jenis_bayar/v_jenis_bayar_form',$data);
		$this->load->view('v_footer');		
	}

	public function jenis_bayar_view($msjb_no){
		if(!fcek_hak_akses('.AM0.')) {
			redirect('forbidden');
		}

		if (is_null($msjb_no) || count($this->m_jenis_bayar->get_jenis_bayar($msjb_no)) <= 0) {
			redirect('jenis_bayar');
			return;
		}	
		$data = array();
		$data['action'] = 'view';				
		$data['jenis_bayar'] = $this->m_jenis_bayar->get_jenis_bayar($msjb_no);
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);	
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/jenis_bayar/v_jenis_bayar_form',$data);
		$this->load->view('v_footer');		
	}
	
	public function jenis_bayar_new_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'jenis_bayar');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{
			if($this->m_jenis_bayar->get_jenis_bayarname(null,$this->input->post('msjb_nm')) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('error' => 'Name already exists');
				echo json_encode($result);
			}else{			
				$data = array();										
				$data['msjb_no'] = $this->m_jenis_bayar->jenis_bayar_kode_auto();
				$data['msjb_nm'] = fhapus_kutip($this->input->post('msjb_nm'));
				$data['msjb_trans'] = $this->input->post('msjb_trans');
				$data['msjb_tipe'] = $this->input->post('msjb_tipe');
				$data['msjb_listmscb'] = (($this->input->post('msjb_listmscb') != '') ? ".". implode('.', $this->input->post('msjb_listmscb')). "." : '');
				$data['msjb_catatan'] = fhapus_kutip($this->input->post('msjb_catatan'));
				$data['msjb_msap_no'] = $this->input->post('msjb_msap_no');
				$data['msjb_aktif'] = 1; //(($this->input->post('msjb_aktif') == 'on') ? 1 : 0);			
				$data['msjb_lsupd'] = date('Y-m-d H:i:s');
				$data['msjb_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_jenis_bayar->jenis_bayar_new_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');
					$result['response'] = 'sukses';				
	      	 		$result['msjb_no'] = $data['msjb_no'];			
	      	 		echo json_encode($result);
				}
			}
		}				        
	}

	public function jenis_bayar_edit_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'jenis_bayar');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{			
			$data_status['msjb_listmscb'] = (($this->input->post('msjb_listmscb') != '') ? ".". implode('.', $this->input->post('msjb_listmscb')). "." : '');
			if($this->m_jenis_bayar->get_jenis_bayarname($this->input->post('msjb_no'), $this->input->post('msjb_nm')) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('msus_nm' => 'Name already exists');
				echo json_encode($result);				
	         }else if(fcek_status($data_status)){	         			
				$result['response'] = 'gagal';
				$result['error_message'] = array('fail'=>'Can not save [OFF] status');
				echo json_encode($result);		     	
	     	}else{
					$data = array();
					$data['msjb_no'] = $this->input->post('msjb_no');
					$data['msjb_nm'] = fhapus_kutip($this->input->post('msjb_nm'));		
					$data['msjb_trans'] = $this->input->post('msjb_trans');
					$data['msjb_tipe'] = $this->input->post('msjb_tipe');
					$data['msjb_listmscb'] = $data_status['msjb_listmscb'];
					$data['msjb_catatan'] = fhapus_kutip($this->input->post('msjb_catatan'));
					$data['msjb_msap_no'] = $this->input->post('msjb_msap_no');
					// $data['msjb_aktif'] = (($this->input->post('msjb_aktif') == 'on') ? 1 : 0);			
					$data['msjb_lsupd'] = date('Y-m-d H:i:s');
					$data['msjb_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
										
					if($this->m_jenis_bayar->jenis_bayar_edit_simpan($data)){
						$this->session->set_userdata('alert_sukses','sukses');			
						$result['response'] = 'sukses';				
		      	 		$result['msjb_no'] = $data['msjb_no'];			
		      	 		echo json_encode($result);
					}				
			}		
		}				        
	}

	public function get_jenis_bayar(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'jenis_bayar');
							
		echo json_encode($this->m_jenis_bayar->get_all_jenis_bayar());				
	}

	public function jenis_bayar_aktif_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'jenis_bayar');

		$data['msjb_no'] = $this->input->post('msjb_no');
		$data['msjb_aktif'] = $this->input->post('msjb_aktif');

		if($this->m_jenis_bayar->jenis_bayar_aktif_simpan($data)){
			$this->session->set_userdata('alert_sukses','sukses');			
			$result['response'] = 'sukses';				
  	 		$result['msjb_no'] = $data['msjb_no'];			
  	 		echo json_encode($result);
		}
	}	


	private function config_validation(){
		$config = array(		        		        		        
		        array(
		                'field' => 'msjb_nm',
		                'label' => 'Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'msjb_trans',
		                'label' => 'Transaction',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        ),
		        array(
		                'field' => 'msjb_listmscb[]',
		                'label' => 'Area',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        ),
		        array(
		                'field' => 'msjb_msap_no',
		                'label' => 'Akun Perkiraan',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )

		);
		return $config;
	}


}