<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class kategori extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_kategori');				
	}

	public function index(){			
		if(!fcek_hak_akses('.AD0.')) {
			redirect('forbidden');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/kategori/v_kategori_list', $data);
		$this->load->view('v_footer');			
	}

	public function kategori_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'kategori');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['kategori_list'] = $this->m_kategori->get_kategori_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['kategori_list']);
		}
		else {
			$pagination['total_list'] = $this->m_kategori->get_kategori_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['kategori_list'] = $this->load->view('data_master/kategori/v_kategori_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}
	
	public function kategori_new(){			
		if(!fcek_hak_akses('.AD1.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/kategori/v_kategori_form',$data);
		$this->load->view('v_footer');		
	}

	public function kategori_view($mskt_no){
		if(!fcek_hak_akses('.AD0.')) {
			redirect('forbidden');
		}

		if (is_null($mskt_no) || count($this->m_kategori->get_kategori($mskt_no)) <= 0) {
			redirect('kategori');
			return;
		}	
		$data = array();
		$data['action'] = 'view';				
		$data['kategori'] = $this->m_kategori->get_kategori($mskt_no);
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);	
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/kategori/v_kategori_form',$data);
		$this->load->view('v_footer');		
	}

	public function kategori_new_simpan(){	
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'kategori');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{		
			if($this->m_kategori->get_kategorino($this->input->post('mskt_no')) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('mskt_no' => 'Category ID: '.$this->input->post('mskt_no').' is already registered. Please input Category ID.');
				echo json_encode($result);	
			}else if($this->m_kategori->get_kategoriname(null, fhapus_kutip($this->input->post('mskt_nm'))) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Category name already exists');
				echo json_encode($result);			
			}else{			
				$data = array();				
				$data['mskt_no'] = $this->input->post('mskt_no');
				$data['mskt_nm'] = fhapus_kutip($this->input->post('mskt_nm'));											
				$data['mskt_listmscb'] = (($this->input->post('mskt_listmscb') != '') ? ".". implode('.', $this->input->post('mskt_listmscb')). "." : '');
				$data['mskt_statusinv'] = $this->input->post('mskt_statusinv');							
				$data['mskt_showinspk'] = $this->input->post('mskt_showinspk');
				$data['mskt_discagen1'] = ftodouble($this->input->post('mskt_discagen1'));
				$data['mskt_discagen2'] = ftodouble($this->input->post('mskt_discagen2'));			
				$data['mskt_discagen3'] = ftodouble($this->input->post('mskt_discagen3'));		
				$data['mskt_discnonagen1'] = ftodouble($this->input->post('mskt_discnonagen1'));
				$data['mskt_discnonagen2'] = ftodouble($this->input->post('mskt_discnonagen2'));	
				$data['mskt_discnonagen3'] = ftodouble($this->input->post('mskt_discnonagen3'));
				$data['mskt_msap_no_inv'] = ($this->input->post('mskt_msap_no_inv') != '') ? substr($this->input->post('mskt_msap_no_inv'), 0, 11) : '';
				$data['mskt_msap_no_pjr'] = ($this->input->post('mskt_msap_no_pjr') != '') ? substr($this->input->post('mskt_msap_no_pjr'), 0, 11) : '';
				$data['mskt_msap_no_pja'] = ($this->input->post('mskt_msap_no_pja') != '') ? substr($this->input->post('mskt_msap_no_pja'), 0, 11) : '';
				$data['mskt_msap_no_hpa'] = ($this->input->post('mskt_msap_no_hpa') != '') ? substr($this->input->post('mskt_msap_no_hpa'), 0, 11) : '';
				$data['mskt_msap_no_hpr'] = ($this->input->post('mskt_msap_no_hpr') != '') ? substr($this->input->post('mskt_msap_no_hpr'), 0, 11) : '';
				$data['mskt_msap_no_srr'] = ($this->input->post('mskt_msap_no_srr') != '') ? substr($this->input->post('mskt_msap_no_srr'), 0, 11) : '';
				$data['mskt_msap_no_sra'] = ($this->input->post('mskt_msap_no_sra') != '') ? substr($this->input->post('mskt_msap_no_sra'), 0, 11) : '';
				$data['mskt_msap_no_spr'] = ($this->input->post('mskt_msap_no_spr') != '') ? substr($this->input->post('mskt_msap_no_spr'), 0, 11) : '';
				$data['mskt_msap_no_spa'] = ($this->input->post('mskt_msap_no_spa') != '') ? substr($this->input->post('mskt_msap_no_spa'), 0, 11) : '';
				$data['mskt_catatan'] = fhapus_kutip($this->input->post('mskt_catatan'));
				$data['mskt_aktif'] = 1; //(($this->input->post('mskt_aktif') == 'on') ? 1 : 0);
				$data['mskt_lsupd'] = date('Y-m-d H:i:s');
				$data['mskt_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_kategori->kategori_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');
					$result['response'] = 'sukses';				
		  	 		$result['mskt_no'] = $data['mskt_no'];	      	 		
		  	 		echo json_encode($result);
				}			
			}	
		}				        
	}

	public function kategori_edit_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'kategori');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{
			$data_status['mskt_listmscb'] = (($this->input->post('mskt_listmscb') != '') ? ".". implode('.', $this->input->post('mskt_listmscb')). "." : '');			
			if(fcek_status($data_status)){
					$result['response'] = 'gagal';
					$result['error_message'] = array('fail'=>'Can not save [OFF] status');
					echo json_encode($result);		     	
			}else if($this->m_kategori->get_kategoriname($this->input->post('mskt_no'), fhapus_kutip($this->input->post('mskt_nm'))) > 0){
					$result['response'] = 'gagal';
					$result['error_message'] = array('error'=>'Category name already exists');
					echo json_encode($result);			
			}else{
					$data = array();		     		
					$data['mskt_no'] = $this->input->post('mskt_no');
					$data['mskt_nm'] = fhapus_kutip($this->input->post('mskt_nm'));			
					$data['mskt_listmscb'] = $data_status['mskt_listmscb'];
					//$data['mskt_statusinv'] = $this->input->post('mskt_statusinv');
					$data['mskt_showinspk'] = $this->input->post('mskt_showinspk');
					$data['mskt_discagen1'] = ftodouble($this->input->post('mskt_discagen1'));
					$data['mskt_discagen2'] = ftodouble($this->input->post('mskt_discagen2'));		
					$data['mskt_discagen3'] = ftodouble($this->input->post('mskt_discagen3'));	
					$data['mskt_discnonagen1'] = ftodouble($this->input->post('mskt_discnonagen1'));
					$data['mskt_discnonagen2'] = ftodouble($this->input->post('mskt_discnonagen2'));
					$data['mskt_discnonagen3'] = ftodouble($this->input->post('mskt_discnonagen3'));
					$data['mskt_msap_no_inv'] = ($this->input->post('mskt_msap_no_inv') != '') ? substr($this->input->post('mskt_msap_no_inv'), 0, 11) : '';
					$data['mskt_msap_no_pjr'] = ($this->input->post('mskt_msap_no_pjr') != '') ? substr($this->input->post('mskt_msap_no_pjr'), 0, 11) : '';
					$data['mskt_msap_no_pja'] = ($this->input->post('mskt_msap_no_pja') != '') ? substr($this->input->post('mskt_msap_no_pja'), 0, 11) : '';
					$data['mskt_msap_no_hpa'] = ($this->input->post('mskt_msap_no_hpa') != '') ? substr($this->input->post('mskt_msap_no_hpa'), 0, 11) : '';
					$data['mskt_msap_no_hpr'] = ($this->input->post('mskt_msap_no_hpr') != '') ? substr($this->input->post('mskt_msap_no_hpr'), 0, 11) : '';
					$data['mskt_msap_no_srr'] = ($this->input->post('mskt_msap_no_srr') != '') ? substr($this->input->post('mskt_msap_no_srr'), 0, 11) : '';
					$data['mskt_msap_no_sra'] = ($this->input->post('mskt_msap_no_sra') != '') ? substr($this->input->post('mskt_msap_no_sra'), 0, 11) : '';
					$data['mskt_msap_no_spr'] = ($this->input->post('mskt_msap_no_spr') != '') ? substr($this->input->post('mskt_msap_no_spr'), 0, 11) : '';
					$data['mskt_msap_no_spa'] = ($this->input->post('mskt_msap_no_spa') != '') ? substr($this->input->post('mskt_msap_no_spa'), 0, 11) : '';
					$data['mskt_catatan'] = fhapus_kutip($this->input->post('mskt_catatan'));
					//$data['mskt_aktif'] = (($this->input->post('mskt_aktif') == 'on') ? 1 : 0);			
					$data['mskt_lsupd'] = date('Y-m-d H:i:s');
					$data['mskt_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
										
					if($this->m_kategori->kategori_edit_simpan($data)){	
						$this->session->set_userdata('alert_sukses','sukses');		
						$result['response'] = 'sukses';				
			  	 		$result['mskt_no'] = $data['mskt_no'];			
			  	 		echo json_encode($result);
					}				
			}	
		}				        
	}

	public function get_kategori(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'kategori');
						
		echo json_encode($this->m_kategori->get_all_kategori());				
	}

	public function get_kategori_byid(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'kategori');

		$mskt_no = $this->input->post('mskt_no');
						
		echo json_encode($this->m_kategori->get_kategori($mskt_no));				
	}

	public function kategori_aktif_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'kategori');

		$data['mskt_no'] = $this->input->post('mskt_no');
		$data['mskt_aktif'] = $this->input->post('mskt_aktif');

		if($this->m_kategori->kategori_aktif_simpan($data)){
			$this->session->set_userdata('alert_sukses','sukses');			
			$result['response'] = 'sukses';				
  	 		$result['mskt_no'] = $data['mskt_no'];			
  	 		echo json_encode($result);
		}
	}

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'mskt_no',
		                'label' => 'Category ID',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),		        
		        array(
		                'field' => 'mskt_nm',
		                'label' => 'Category Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mskt_discnonagen1',
		                'label' => 'Discount Reatail',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mskt_discnonagen2',
		                'label' => 'Discount Reatail',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mskt_discnonagen3',
		                'label' => 'Discount Reatail',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mskt_discagen1',
		                'label' => 'Discount Agen',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mskt_discagen2',
		                'label' => 'Discount Agen',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mskt_discagen3',
		                'label' => 'Discount Agen',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mskt_listmscb[]',
		                'label' => 'Area',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )

		);
		return $config;
	}
	

}