<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class login extends CI_Controller {	

	function __construct(){
		parent::__construct();
		unset($_SESSION['backup_data']);	
		$this->session->set_userdata('svlogin','F');
		$this->load->model('m_simrel');
		$this->load->model('data_master/m_user');		
		$this->load->helper('security');		
		$this->load->model('reporting/m_reporting');
		$this->load->model('sales/m_sales_order');
		$this->load->model('setting/m_setting');
		error_reporting(E_ALL ^ (E_NOTICE | E_WARNING));
	}			

	public function index()
	{							
		if($this->session->userdata('rand')){
			$this->m_reporting->delete_datatemp_bayrand($this->session->userdata('rand'));
			unset($_SESSION['rand']);
		}

		$this->session->sess_destroy();				

		// [CATATAN]
		// Coba dipertimbangkan agi lapakah perlu cek CONS_SIMREL_APPVER atau tidak??

		// Setiap kali melakukan update yang merubah format database, maka :
		// 1. Ubah nilai constant CONS_SIMREL_DBVER di constant.php
		// 2. Tambahkan fungsi perubahan database pada m_simrel.php -> fauto_revisi();

		$sn = $this->input->post('autorev_sn');
		$key = $this->input->post('autorev_kn');		
		$no_revisi = $this->m_simrel->fget_norevisi();
		$sn1 = substr($sn, 1, 2);
		$sn2 = substr($sn, 6, 2);
		$sn3 = substr($sn, 11, 2);
		$sn = $sn1 + $sn2 + $sn3;
		$sn = strval($sn);
		
		if($no_revisi == 0 && !$sn){			
			$data['no_revisi'] = $no_revisi;
			$data['error'] = '';
			$this->load->view('v_popup_confirm_initautorev', $data);
			return;
		}

		if($no_revisi == 0 && $sn != $key){
			$data['no_revisi'] = $no_revisi;
			$data['error'] = 'Key number is not valid.';
			$this->load->view('v_popup_confirm_initautorev', $data);
			return;	
		}

		// if($no_revisi > 0 && $no_revisi < CONS_SIMREL_DBVER && !$sn){			
		// 	$data['no_revisi'] = $no_revisi;
		// 	$data['error'] = '';
		// 	$this->load->view('v_popup_confirm_autorev', $data);
		// 	return;
		// }				

		// if($no_revisi > 0 && $sn != $key && $no_revisi < CONS_SIMREL_DBVER){
		// 	$data['no_revisi'] = $no_revisi;
		// 	$data['error'] = 'Key number is not valid.';
		// 	$this->load->view('v_popup_confirm_autorev', $data);
		// 	return;	
		// }
		
		if(($no_revisi == 0 && $sn === $key) || ($no_revisi > 0 && $no_revisi < CONS_SIMREL_DBVER)){
			echo "<script>alert('System akan merevisi database') </script>";
			$no_revisi = $this->m_simrel->fauto_revisi($no_revisi);		 				

			if($no_revisi != CONS_SIMREL_DBVER){			
				echo "<script>alert('Revisi database tidak valid [ERROR CODE #" . $no_revisi. "]')</script>";
				return;
			}
		}		

		$this->autoproses();	
		$this->load->view('v_login');											
		
	}			

	public function user_login() {		
		$data = array();		
		$msus_nm = $this->input->post('msus_nm');
		$msus_pswd = do_hash($this->input->post('msus_pswd'),'md5');		
		$msus_data = $this->m_user->get_user_aktif($msus_nm,$msus_pswd);		
		
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){		
			$data['error_message'] = 'Please input User Name or Password';
			$this->load->view('v_login',$data);
		}else{			
			if(count($msus_data) > 0 && $msus_data[0]['msus_aktif'] == 1){			
				$this->session->set_userdata('user_aktif',$msus_data[0]);
				// $this->set_session_userdata();
				redirect(base_url('home'));
			}else{
				$data['error_message'] = 'Name and password do not match';
				$this->load->view('v_login',$data);
			}
		}	
	}

	private function autoproses(){		
		// Get last closing so
		$last_close = $this->m_setting->get_setting('simr_char1', 'aup', 1);
		$last_close = ($last_close == '') ? 0 : $last_close;				
		$date = date('Y-m-d H:i:s');
		$curr_date = substr($date, 0, 10);
		$curr_time = substr($date, 11);

		// Cek apkah autoproses sudah di jalankan
		if(strtotime($last_close) < strtotime($curr_date)){							
			// proses closing so
			$result = $this->m_sales_order->sales_order_lockso($curr_date, null);

			if($result == 1){
				// update last closing so
				$this->m_setting->set_last_close_so($curr_date, $curr_time);
			}			
		}
	}

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'msus_nm',
		                'label' => 'User Name',
		                'rules' => 'required'		                
		        ),		        
		        array(
		                'field' => 'msus_pswd',
		                'label' => 'Password',
		                'rules' => 'required'		                
		        )
		);
		return $config;
	}
		
}
