<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class merk extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_merk');					
	}

	public function index(){			
		if(!fcek_hak_akses('.AG0.')) {
			redirect('forbidden');
		}
		$data = array();
		$data['per_page'] = 15;
		$data['request_from'] = 'list';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/merk/v_merk_list', $data);
		$this->load->view('v_footer');			
	}

	public function merk_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'merk');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			

		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['merk_list'] = $this->m_merk->get_merk_list($arr_filter, false, $per_page, $offset, $fn, $sort);
		$data['request_from'] = $this->input->post('request_from');

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['merk_list']);
		}
		else {
			$pagination['total_list'] = $this->m_merk->get_merk_list($arr_filter, true);		
		}

		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['merk_list'] = $this->load->view('data_master/merk/v_merk_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);				
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}
	
	public function merk_new(){			
		if(!fcek_hak_akses('.AG1.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/merk/v_merk_form',$data);
		$this->load->view('v_footer');		
	}

	public function merk_view($msmr_no){
		if(!fcek_hak_akses('.AG0.')) {
			redirect('forbidden');
		}

		if (is_null($msmr_no) || count($this->m_merk->get_merk($msmr_no)) <= 0) {
			redirect('merk');
			return;
		}	
		$data = array();
		$data['action'] = 'view';				
		$data['merk'] = $this->m_merk->get_merk($msmr_no);
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);	
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/merk/v_merk_form',$data);
		$this->load->view('v_footer');		
	}

	public function merk_new_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'merk');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{		
			if($this->m_merk->get_merkno($this->input->post('msmr_no')) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('msmr_no' => 'Brand ID: '.$this->input->post('msmr_no').' is already registered. Please input Brand ID.');
				echo json_encode($result);	
			}else if($this->m_merk->get_merknm(null, fhapus_kutip($this->input->post('msmr_nm'))) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Brand name already exists');
				echo json_encode($result);							
			}else{											
				$data = array();
				$data['msmr_no'] = $this->input->post('msmr_no');
				$data['msmr_nm'] = fhapus_kutip($this->input->post('msmr_nm'));
				$data['msmr_listmscb'] = (($this->input->post('msmr_listmscb') != '') ? ".". implode('.', $this->input->post('msmr_listmscb')). "." : '');
				$data['msmr_catatan'] = fhapus_kutip($this->input->post('msmr_catatan'));
				$data['msmr_aktif'] = 1; //(($this->input->post('msmr_aktif') == 'on') ? 1 : 0);			
				$data['msmr_lsupd'] = date('Y-m-d H:i:s');
				$data['msmr_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_merk->merk_new_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');
					$result['response'] = 'sukses';				
		  	 		$result['msmr_no'] = $data['msmr_no'];	      	 		
		  	 		echo json_encode($result);
				}			
			}	
		}				        
	}

	public function merk_edit_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'merk');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{
			$data_status['msmr_listmscb'] = (($this->input->post('msmr_listmscb') != '') ? ".". implode('.', $this->input->post('msmr_listmscb')). "." : '');			
			if(fcek_status($data_status)){
				$result['response'] = 'gagal';
				$result['error_message'] = array('fail'=>'Can not save [OFF] status');
				echo json_encode($result);		     	
			}else if($this->m_merk->get_merknm($this->input->post('msmr_no'), fhapus_kutip($this->input->post('msmr_nm'))) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Brand name already exists');
				echo json_encode($result);							
			}else{						     	
				$data = array();	
				$data['msmr_no'] = $this->input->post('msmr_no');
				$data['msmr_nm'] = fhapus_kutip($this->input->post('msmr_nm'));			
				$data['msmr_listmscb'] = $data_status['msmr_listmscb'];
				$data['msmr_catatan'] = fhapus_kutip($this->input->post('msmr_catatan'));
				//$data['msmr_aktif'] = (($this->input->post('msmr_aktif') == 'on') ? 1 : 0);			
				$data['msmr_lsupd'] = date('Y-m-d H:i:s');
				$data['msmr_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_merk->merk_edit_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');			
					$result['response'] = 'sukses';				
		  	 		$result['msmr_no'] = $data['msmr_no'];			
		  	 		echo json_encode($result);
				}				
			}	
		}				        
	}

	public function get_merk(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'merk');
						
		echo json_encode($this->m_merk->get_all_merk());				
	}

	public function merk_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'merk');

		$data = array();
		$data['per_page'] = 13;
		$data['request_from'] = 'popup';

		$respon = array();
		$respon['popup'] = $this->load->view('data_master/merk/v_merk_popup',$data,true);	
		echo json_encode($respon);		
	}

	public function merk_aktif_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'merk');

		$data['msmr_no'] = $this->input->post('msmr_no');
		$data['msmr_aktif'] = $this->input->post('msmr_aktif');

		if($this->m_merk->merk_aktif_simpan($data)){
			$this->session->set_userdata('alert_sukses','sukses');			
			$result['response'] = 'sukses';				
  	 		$result['msmr_no'] = $data['msmr_no'];			
  	 		echo json_encode($result);
		}
	}	

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'msmr_no',
		                'label' => 'Brand ID',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),		        
		        array(
		                'field' => 'msmr_nm',
		                'label' => 'Brand Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'msmr_listmscb[]',
		                'label' => 'Area',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )

		);
		return $config;
	}

}