<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class metode_penyusutan extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_metode_penyusutan');					
	}

	public function index(){			
		if(!fcek_hak_akses('.AR0.')) {
			redirect('forbidden');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/metode_penyusutan/v_metode_penyusutan_list', $data);
		$this->load->view('v_footer');			
	}

	public function metode_penyusutan_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'metode_penyusutan');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');	
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');			

		$data['metode_penyusutan_list'] = $this->m_metode_penyusutan->get_metode_penyusutan_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['metode_penyusutan_list']);
		}
		else {
			$pagination['total_list'] = $this->m_metode_penyusutan->get_metode_penyusutan_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['metode_penyusutan_list'] = $this->load->view('data_master/metode_penyusutan/v_metode_penyusutan_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}
	
	public function metode_penyusutan_new(){			
		if(!fcek_hak_akses('.AR1.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/metode_penyusutan/v_metode_penyusutan_form',$data);
		$this->load->view('v_footer');		
	}

	public function metode_penyusutan_view($msmp_no){
		if(!fcek_hak_akses('.AR0.')) {
			redirect('forbidden');
		}

		if (is_null($msmp_no) || count($this->m_metode_penyusutan->get_metode_penyusutan($msmp_no)) <= 0) {
			redirect('metode_penyusutan');
			return;
		}	
		$data = array();
		$data['action'] = 'view';				
		$data['metode_penyusutan'] = $this->m_metode_penyusutan->get_metode_penyusutan($msmp_no);
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);	
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/metode_penyusutan/v_metode_penyusutan_form',$data);
		$this->load->view('v_footer');		
	}

	public function metode_penyusutan_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'metode_penyusutan');		
		$this->form_validation->set_rules($this->config_validation());
		$vok = true;		

		if($vok){
			$data = array();
			$data['action'] = $this->input->post('action');

			if($data['action'] == 'NEW'){
				$data['ms']['msmp_no'] = $this->m_metode_penyusutan->metode_penyusutan_kode_auto();
			}

			if($data['action'] != 'NEW'){
				$data['ms']['msmp_no'] = $this->input->post('msmp_no');
			}

			$data['ms']['msmp_nm'] = fhapus_kutip($this->input->post('msmp_nm'));
			$data['ms']['msmp_listmscb'] = (($this->input->post('msmp_listmscb') != '') ? ".". implode('.', $this->input->post('msmp_listmscb')). "." : '');
			$data['ms']['msmp_catatan'] = fhapus_kutip($this->input->post('msmp_catatan'));
			$data['ms']['msmp_metode'] = fhapus_kutip($this->input->post('msmp_metode'));
			$data['ms']['msmp_umur'] = fhapus_kutip($this->input->post('msmp_umur'));
			$data['ms']['msmp_tarif'] = fhapus_kutip(ftodouble($this->input->post('msmp_tarif')));
			$data['ms']['msmp_aktif'] = fhapus_kutip($this->input->post('msmp_aktif'));
			$data['ms']['msmp_lsupd'] = date('Y-m-d H:i:s');
			$data['ms']['msmp_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];

		}				        

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;				
				$msg = $this->form_validation->error_array();
			}
		}

		// cek valid data master
		if($vok){
			$hasil_cek = $this->cek_valid_data_master($data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);				
			}
		}

		// Simpan data
		if($vok){
			$vresult = $this->m_metode_penyusutan->metode_penyusutan_simpan($data);
			if($vresult == 0){
				$vok = false;				
				$msg = array('error' => 'Error Query');
			}
		}
		
		// Berhasil simpan data
		if($vok){
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['msmp_no'] = $data['ms']['msmp_no'];
		}
				
		// Gagal simpan data							
		if(!$vok){
			$result['response'] = 'gagal';  	 		
  	 		$result['error_message'] = $msg;			  	 		
		}	

		echo json_encode($result);		
	}

	private function cek_valid_data_master($data){
		$msg = '';
		$hsl = true;

		// cek tidak bisa menyimpan da yg status [OFF]
		if($hsl){			
			$data_status['msmp_listmscb'] = (($this->input->post('msmp_listmscb') != '') ? ".". implode('.', $this->input->post('msmp_listmscb')). "." : '');			
			if(fcek_status($data_status)){
				$hsl = false;
				$msg = 'Can not save [OFF] status';				   	
			}
		}		
		
		return array('valid'=>$hsl, 'msg'=>$msg);
	}	
	

	public function get_metode_penyusutan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'metode_penyusutan');
						
		echo json_encode($this->m_metode_penyusutan->get_all_metode_penyusutan());				
	}	

	private function config_validation(){
		$config = array(		        
				        array(
				                'field' => 'msmp_nm',
				                'label' => 'Name',
				                'rules' => 'required',
				                'errors' => array(
				                        'required' => ' Please input %s. '
				                )
				        ),
				        array(
				                'field' => 'msmp_listmscb[]',
				                'label' => 'Area',
				                'rules' => 'required',
				                'errors' => array(
				                        'required' => ' Please select %s. '
				                )
				        )

				);
		return $config;
	}

}