<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class mutasi extends MY_Controller {
	private $data = array();	

	function __construct(){
		parent::__construct();
		$this->load->model('stok_kontrol/m_mutasi');
		$this->load->model('stok_kontrol/m_stok');	
		$this->load->model('data_master/m_produk');
		$this->load->model('data_master/m_kategori');
		$this->load->model('setting/m_setting_account');
		$this->load->model('finance_and_acc/m_jurnal');
		$this->load->model('data_master/m_gudang');	
		$this->load->model('setting/m_setting');		
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function index($tipe_trans = null){		

		if($tipe_trans == null || $tipe_trans == 'F' || $tipe_trans == 'f') {
			if(!fcek_hak_akses('.HB7.')){
				redirect('forbidden');
			}

			$tipe_trans = 'F';
		} else {
			if(!fcek_hak_akses('.HB8.')){
				redirect('forbidden');
			}

			if(($this->session->userdata('svlogin') == 'C') && ($tipe_trans == 'C' || $tipe_trans == 'c')) {
				$tipe_trans = 'C';
			} else {
				redirect('mutasi');
			}
		}
		// if($tipe_trans != null){			
		// 	if($this->session->userdata('svlogin') == 'C' && $tipe_trans != 'F' && $tipe_trans != 'C' ||
		// 		$this->session->userdata('svlogin') == 'F' && $tipe_trans != null && $tipe_trans != 'F'){				
		// 		redirect('mutasi');
		// 	}
		// }

		$data = array();
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		// $data['tipe_trans']	= ($tipe_trans == null || $tipe_trans == 'F') ? 'F' : 'C';
		$data['tipe_trans']	= $tipe_trans;
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$data['mskt'] = json_encode($this->m_kategori->get_all_kategori());
		$this->load->view('stok_kontrol/mutasi/v_mutasi_list',$data);
		$this->load->view('v_footer');			
	}

	public function mutasi_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'mutasi');
		
		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();
		$arr_filter = $this->input->post('arr_filter');
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['mutasi_list'] = $this->m_mutasi->get_mutasi_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['mutasi_list']);
		}
		else {
			$pagination['total_list'] = $this->m_mutasi->get_mutasi_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['mutasi_list'] = $this->load->view('stok_kontrol/mutasi/v_mutasi_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}	

	public function mutasi_new($tipe_trans = null){	
		if(!fcek_hak_akses('.DC1.')) {
			redirect('forbidden');
		}

		if($tipe_trans == null || $tipe_trans == 'F' || $tipe_trans == 'f') {
			$tipe_trans = 'F';
		} else {
			if(($this->session->userdata('svlogin') == 'C') && ($tipe_trans == 'C' || $tipe_trans == 'c')) {
				$tipe_trans = 'C';
			} else {
				redirect('mutasi');
			}
		}

		// if($tipe_trans != null){			
		// 	if($this->session->userdata('svlogin') == 'C' && $tipe_trans != 'F' && $tipe_trans != 'C' ||
		// 		$this->session->userdata('svlogin') == 'F' && $tipe_trans != null && $tipe_trans != 'F'){				
		// 		redirect('mutasi');
		// 	}
		// }

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		// $data['tipe_trans']	= ($tipe_trans == null || $tipe_trans == 'F') ? 'F' : 'C';
		$data['tipe_trans']	= $tipe_trans;
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('stok_kontrol/mutasi/v_mutasi_form',$data);
		$this->load->view('v_footer');		
	}

	public function mutasi_view($trmt_no){			
		if(!fcek_hak_akses('.DC0.')) {
			redirect('forbidden');
		}

		if (is_null($trmt_no) || !$this->m_mutasi->get_mutasi($trmt_no)) {
			redirect('mutasi');
			return;
		}

		$data = array();				
		$data = $this->m_mutasi->get_mutasi($trmt_no);			

		$trju_no1 = $this->m_jurnal->get_jurnalid($trmt_no.'MD');
		if($trju_no1 != false){			
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_no1);			
			$data['jurnal_md_h'] = $data_jurnal['jurnal_h'];
			$data['jurnal_md_d'] = $data_jurnal['jurnal_d'];			
		}

		$trju_no2 = $this->m_jurnal->get_jurnalid($trmt_no.'MR');
		if($trju_no2 != false){			
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_no2);			
			$data['jurnal_mr_h'] = $data_jurnal['jurnal_h'];
			$data['jurnal_mr_d'] = $data_jurnal['jurnal_d'];			
		}
			
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		$data['action'] = 'view';
		$data['tipe_trans']	= $data['header']['trmt_fin'];
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('stok_kontrol/mutasi/v_mutasi_form',$data);
		$this->load->view('v_footer');		
	}

	public function mutasi_print(){
		$this->load->library('java_bridge');
		$trmt_no = $this->input->get('trmt_no');
		$paper_size = $this->input->get('paper_size');

		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];

		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}


		if($paper_size == 'A5'){
			$path = APPPATH.'prints\stok_kontrol\mutasi\p_mutasi_A5.jrxml';					
		}elseif($paper_size == 'A4') {
			$path = APPPATH.'prints\stok_kontrol\mutasi\p_mutasi_A4.jrxml';					
		}		
		$params = new Java("java.util.HashMap");			
		$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
		$params->put("P_TRMT_NO",new Java('java.lang.String', $trmt_no));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$this->java_bridge->print_data($path, $params);
	}

	public function mutasi_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');	
		fcek_direct_access($key, $hash_key, 'mutasi');		
		$this->form_validation->set_rules($this->config_validation());
		$vok = true;
		$msg;

		// set data
		if($vok){					
			$this->data['action'] = $this->input->post('action');
			$this->data['trmt_cekint'] = $this->input->post('trmt_cekint');
			$this->data['header']['trmt_lsupd'] = date('Y-m-d H:i:s');
			$this->data['header']['trmt_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
			$this->data['header']['trmt_msgd_no1'] = $this->input->post('trmt_msgd_no1');
			$this->data['header']['trmt_msgd_no2'] = $this->input->post('trmt_msgd_no2');
			$this->data['header']['trmt_tag'] = fhapus_kutip($this->input->post('trmt_tag'));

			if($this->data['action'] == 'NEW'){
				$trmt_mscb_no = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$trmt_tgl = $this->input->post('trmt_tgl');
				$bulan = substr($trmt_tgl, 5, 2);			
				$tahun = substr($trmt_tgl, 2, 2);	
				$separator = ($this->input->post('trmt_fin') == 'F') ? '-' : '_';		
				$trmt_kode_depan = $trmt_mscb_no."MT".$tahun.$bulan.$separator; 			
				$this->data['header']['trmt_no'] = $this->m_mutasi->mutasi_kode_auto($trmt_kode_depan);							
				$this->data['header']['trmt_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['header']['trmt_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$this->data['header']['trmt_tgl'] = $trmt_tgl;
				$this->data['header']['trmt_void'] = 0;			
				$this->data['header']['trmt_fin'] = $this->input->post('trmt_fin');
				$this->data['header']['trmt_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trmt_fin') == 'C') ? 'A' : 'W';
			}

			if($this->data['action'] != 'NEW'){
				$this->data['header']['trmt_no'] = $this->input->post('trmt_no');
			}	

			if($this->data['action'] == 'NEW' || $this->data['action'] == 'EDIT'){
				$this->data['header']['trmt_mscb_no1'] = substr($this->input->post('trmt_mscb_no1'), 0, 1);
				$this->data['header']['trmt_mscb_no2'] = substr($this->input->post('trmt_mscb_no2'), 0, 1);				
				$this->data['header']['trmt_catatan'] = fhapus_kutip($this->input->post('trmt_catatan'));				
			}

			if($this->data['action'] == 'NEW' || $this->data['action'] == 'EDIT' || $this->data['action'] == 'DELIVERYNOW'){
				$this->data['header']['trmt_ekspedisi'] = $this->input->post('trmt_ekspedisi');	
				$this->data['header']['trmt_noekspedisi'] = $this->input->post('trmt_noekspedisi');
			}

			if($this->data['action'] == 'DELIVERYNOW'){
				$this->data['header']['trmt_tglkirim'] = $this->input->post('trmt_tglkirim');
				$this->data['header']['trmt_usrkirim'] = $this->session->userdata('user_aktif')['msus_no'];
			}

			if($this->data['action'] == 'CANCEL_DELIVERYNOW'){
				$this->data['header']['trmt_tglkirim'] = '';
				$this->data['header']['trmt_usrkirim'] = '';
			}
			
			if($this->data['action'] == 'RECEIVE_GOODS'){
				$this->data['header']['trmt_tglterima'] = $this->input->post('trmt_tglterima');
				$this->data['header']['trmt_usrterima'] = $this->session->userdata('user_aktif')['msus_no'];
			}

			if($this->data['action'] == 'CANCEL_RECEIVE_GOODS'){
				$this->data['header']['trmt_tglterima'] = '';
				$this->data['header']['trmt_usrterima'] = '';
			}

			if($this->data['action'] == 'STCOPY'){				
				$this->data['header']['trmt_stcopy'] = ($this->input->post('trmt_stcopy') == 'R') ? 'X' : 'R';
			}

			if($this->data['action'] == 'EDIT' || $this->data['action'] == 'VOID'){
				$this->data['userlog']['msul_tgl'] = date('Y-m-d H:i:s');
				$this->data['userlog']['msul_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['userlog']['msul_catatan'] = substr(trim('['.$this->data['action']. '] MTS '. $this->data['header']['trmt_no']. ' GD FROM:'. $this->m_gudang->get_nama_gudang($this->input->post('trmt_msgd_no1')). ' GD TO:'. $this->m_gudang->get_nama_gudang($this->input->post('trmt_msgd_no2')). ' '. fhapus_kutip($this->input->post('trspk_tag')). ' '. fhapus_kutip($this->input->post('trmt_catatan'))), 0, 250);
			}	
											
			$dtmt = $this->input->post('dtmt');								
			
			if(count($dtmt) > 0){
				foreach ($dtmt as $key => $value) {
					for ($i=0; $i < count($dtmt[$key]); $i++) {							
						if($dtmt['dtmt_mspd_no'][$i] != ''){							
							$this->data['detail'][$i]['dtmt_no'] = $this->data['header']['trmt_no'];
							if($key == 'dtmt_qtyout' || $key == 'dtmt_qtyin'){
								$this->data['detail'][$i][$key] = ftodouble($value[$i]);			
							}else{
								$this->data['detail'][$i][$key] = $value[$i];
							}		

							if($this->data['action'] == 'DELIVERYNOW'){
						 		if($key == 'dtmt_mspd_no'){
									$this->data['detail'][$i]['dtmt_hpp'] = $this->m_produk->get_hpp($dtmt['dtmt_mspd_no'][$i]);
								}
							}

							if($this->data['action'] == 'CANCEL_DELIVERYNOW'){
						 		if($key == 'dtmt_mspd_no'){
									$this->data['detail'][$i]['dtmt_hpp'] = 0;
								}
							}

							if($this->data['action'] == 'RECEIVE_GOODS' || $this->data['action'] == 'CANCEL_RECEIVE_GOODS'){
						 		if($key == 'dtmt_mspd_no'){
									$this->data['detail'][$i]['dtmt_hpp'] = $this->m_mutasi->get_dtmt_hpp($this->data['header']['trmt_no'], $dtmt['dtmt_seq'][$i]);
								}
							}

							if($this->data['action'] == 'RECEIVE_GOODS'){						 		
								if($key == 'dtmt_stapv'){
									if($dtmt['dtmt_qtyout'][$i] == $dtmt['dtmt_qtyin'][$i]){	
										$this->data['detail'][$i]['dtmt_stapv'] = 'Y';
									}else{
										$this->data['detail'][$i]['dtmt_stapv'] = 'N';
									}
								}
							}

							if($this->data['action'] == 'CANCEL_RECEIVE_GOODS'){
							 	if($key == 'dtmt_qtyin'){
										$this->data['detail'][$i]['dtmt_qtyin'] = 0;
								}
								if($key == 'dtmt_stapv'){
									$this->data['detail'][$i]['dtmt_stapv'] = 'N';
								}
							}
						}
					}
				}
			}										
		}					

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;				
				$msg = $this->form_validation->error_array();								
			}
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}		

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal($this->data);			
		}

		// cek valid data jurnal				
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_jurnal($this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}

		// simpan data
		if ($vok) {		
			$vresult = $this->m_mutasi->mutasi_simpan($this->data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}		
		}			

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['trmt_no'] = $this->data['header']['trmt_no'];
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);		      
	}	

	public function approval_mutasi_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'mutasi');
		$vok = true;
		
		// set data
		if($vok){
			$data['action'] = $this->input->post('action');
			$data['header']['apmt_no'] = $this->input->post('apmt_no');
			$data['header']['apmt_seq'] = $this->input->post('apmt_seq');
			$data['header']['apmt_msus_no'] = substr($this->input->post('apmt_msus_no'), 0, 4);
			$data['header']['apmt_mscb_no'] = substr($this->input->post('apmt_mscb_no'), 0, 1);		
			$data['header']['apmt_tgl'] = $this->input->post('apmt_tgl');		
			$data['header']['apmt_catatan'] = fhapus_kutip($this->input->post('apmt_catatan'));
			$data['header']['apmt_tag'] = fhapus_kutip($this->input->post('apmt_tag'));
			$data['header']['trmt_no'] = $this->input->post('trmt_no');
			$data['trmt_cekint'] = $this->input->post('trmt_cekint');	
		}	

		// cek data valid
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans('APPROVAL', $data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}			

		// simpan data
		if($vok){
			$vresult = $this->m_mutasi->approval_mutasi_simpan($data);

			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');
				$result['response'] = 'sukses';				
	  	 		$result['apmt_no'] = $data['header']['apmt_no'];
	  	 		echo json_encode($result);			
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}							        
		}	
	}

	public function approval_mutasi_cancel(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'mutasi');

		$vok = true;

		// set data
		if($vok){
			$data['action'] = $this->input->post('action');
			$data['header']['apmt_no'] = $this->input->post('apmt_no');
			$data['header']['apmt_seq'] = $this->input->post('apmt_seq');		
			$data['header']['trmt_no'] = $this->input->post('apmt_no');
			$data['trmt_stcopy'] = $this->input->post('trmt_stcopy');
			$data['trmt_cekint'] = $this->input->post('trmt_cekint');
		}	

		// cek data valid
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans('CANCEL_APPROVAL', $data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}			

		// cancel mutasi
		if($vok){
			$vresult = $this->m_mutasi->approval_mutasi_cancel($data);

			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');
				$result['response'] = 'sukses';				
	  	 		$result['apmt_no'] = $data['header']['apmt_no'];
	  	 		echo json_encode($result);
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}								        
		}	
	}

	public function mutasi_edit_ekspedisi(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'mutasi');

		$vok = true;

		// set data
		if($vok){
			$data['trmt_cekint'] = $this->input->post('trmt_cekint');			
			$data['header']['trmt_no'] = $this->input->post('trmt_no');
			$data['header']['trmt_ekspedisi'] = $this->input->post('trmt_ekspedisi');
			$data['header']['trmt_noekspedisi'] = $this->input->post('trmt_noekspedisi');
		}

		// cek data valid
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans('EDIT_EKSPEDISI', $data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}	

		// void data
		if($vok){
			$vresult = $this->m_mutasi->mutasi_edit_ekspedisi($data);

			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');				
				$result['response'] = 'sukses';
      	 		$result['trmt_no'] = $data['header']['trmt_no'];
      	 		echo json_encode($result);			      	 	
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}
		}	
	}

	public function get_approval_mutasi(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'mutasi');

		echo json_encode($this->m_mutasi->get_approval_mutasi($this->input->post('apmt_no'), $this->input->post('apmt_seq')));
	}

	private function set_data_jurnal($data){		
		if($data['action'] == 'DELIVERYNOW' && isset($data['detail']) || $data['action'] == 'RECEIVE_GOODS' && isset($data['detail'])){
			$gudang_from = $this->m_gudang->get_gudang($this->input->post('trmt_msgd_no1'));
			$gudang_to = $this->m_gudang->get_gudang($this->input->post('trmt_msgd_no2'));

			//Header jurnal
			if($data['action'] == 'DELIVERYNOW'){
				$trju_tgl = $data['header']['trmt_tglkirim'];
			}

			if($data['action'] == 'RECEIVE_GOODS'){
				$trju_tgl = $data['header']['trmt_tglterima'];
			}	

			$trju_tipe = 'A';
			$bulan = substr($trju_tgl, 5, 2);			
			$tahun = substr($trju_tgl, 2, 2);			
			$separator = ($this->input->post('trmt_fin') == 'F') ? '-' : '_';
			$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;
			$trju_catatan = $data['header']['trmt_tag'].' '.$data['header']['trmt_no'].'/From '.$gudang_from['msgd_no'].' - '.$gudang_from['msgd_nm'].'/To '.$gudang_to['msgd_no'].' - '.$gudang_to['msgd_nm'];

			if($data['action'] == 'DELIVERYNOW'){
				$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$data['jurnal_h']['trju_refno'] = $data['header']['trmt_no'].'MD';			
				$data['jurnal_h']['trju_reftipe'] = 'MD';		
			}

			if($data['action'] == 'RECEIVE_GOODS'){
				$data['jurnal_h']['trju_msus_no'] = $this->input->post('trmt_msus_no');
				$data['jurnal_h']['trju_mscb_no'] = $this->input->post('trmt_mscb_no');
				$data['jurnal_h']['trju_refno'] = $data['header']['trmt_no'].'MR';			
				$data['jurnal_h']['trju_reftipe'] = 'MR';
			}

			$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);										
			$data['jurnal_h']['trju_tgl'] = $trju_tgl;
			$data['jurnal_h']['trju_tipe'] = $trju_tipe;				
			$data['jurnal_h']['trju_void'] = 0;			
			$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
			$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];																				
			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trmt_fin') == 'C') ? 'A' : 'R';
			$data['jurnal_h']['trju_fin'] = $this->input->post('trmt_fin');
			$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));

			// Set account
			if(isset($data['detail'])){
				$data['jurnal_d'] = array();
				$array = array();								
				foreach ($data['detail'] as $key => $value) {						
		 			$mskt_no = substr($data['detail'][$key]['dtmt_mspd_no'], 0, 1);
			 		// Set account delivery now
			 		if($data['action'] == 'DELIVERYNOW'){
				 		// Account WIP Mutasi (Debet) dan Inventory (Kredit)
				 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv				 						 			
						 	$saldo = round((ftodouble($data['detail'][$key]['dtmt_hpp']) * ftodouble($data['detail'][$key]['dtmt_qtyout'])), 4);
							
							// Account WIP Mutasi (Debet)
							$acc = $this->m_setting_account->get_setting_account_byid('MWIP');
							$array['dtju_msap_no'] = $acc['mssa_msap_no'];
							$array['dtju_debet'] = $saldo;
							$array['dtju_kredit'] = 0;
							array_push($data['jurnal_d'], $array);

							// Account Inventory (Kredit)														
						 	$array['dtju_msap_no'] = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
					 		$array['dtju_debet'] = 0;
					 		$array['dtju_kredit'] = $saldo;
					 		array_push($data['jurnal_d'], $array);
				 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^				 							 							 				
					}

				 	// Set account penerimaan barang
				 	if($data['action'] == 'RECEIVE_GOODS'){				 								 	
					 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv					 			
					 			$saldo_out = round((ftodouble($data['detail'][$key]['dtmt_hpp']) * ftodouble($data['detail'][$key]['dtmt_qtyout'])), 4);
					 			$saldo_in = round((ftodouble($data['detail'][$key]['dtmt_hpp']) * ftodouble($data['detail'][$key]['dtmt_qtyin'])), 4);
							 	$saldo_selisih = $saldo_out - $saldo_in;
							 	// $selisih = round((ftodouble($data['detail'][$key]['dtmt_hpp']) * (ftodouble($data['detail'][$key]['dtmt_qtyout']) - ftodouble($data['detail'][$key]['dtmt_qtyin']))), 4);
							 	
							 	// Account Inventory (Debet)														
							 	$array['dtju_msap_no'] = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
						 		$array['dtju_debet'] = $saldo_in;
						 		$array['dtju_kredit'] = 0;
						 		array_push($data['jurnal_d'], $array);

								if($saldo_selisih != 0){
									// Account rugi selisih mutasi (Debet)
									if($saldo_selisih > 0){
										$acc = $this->m_setting_account->get_setting_account_byid('MTRS');
										$array['dtju_msap_no'] = $acc['mssa_msap_no'];
										$array['dtju_debet'] = $saldo_selisih;
										$array['dtju_kredit'] = 0;
										array_push($data['jurnal_d'], $array);
									}
								}

								// WIP mutasi (Kredit)					
								$acc = $this->m_setting_account->get_setting_account_byid('MWIP');			
							 	$array['dtju_msap_no'] = $acc['mssa_msap_no'];
						 		$array['dtju_debet'] = 0;
						 		$array['dtju_kredit'] = $saldo_out;
						 		array_push($data['jurnal_d'], $array);

						 		if($saldo_selisih != 0){
									// Account rugi selisih mutasi (Kredit)
									if($saldo_selisih < 0){
										$acc = $this->m_setting_account->get_setting_account_byid('MTRS');
										$array['dtju_msap_no'] = $acc['mssa_msap_no'];
										$array['dtju_debet'] = 0;
										$array['dtju_kredit'] = $saldo_selisih * -1; 
										array_push($data['jurnal_d'], $array);
									}
								}
					 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^									
					}	
					if(count($data['jurnal_d']) > 0){
						$this->data['jurnal_d'] = $data['jurnal_d'];					
					}
				}			
			}				
			$this->data['jurnal_h'] = $data['jurnal_h'];
		}

		if($data['action'] == 'CANCEL_DELIVERYNOW'){
			$this->data['jurnal_h']['trju_no'] = $this->input->post('trju_no1');
		}

		if($data['action'] == 'CANCEL_RECEIVE_GOODS'){
			$this->data['jurnal_h']['trju_no'] = $this->input->post('trju_no2');
		}
	}

	private function cek_valid_data_jurnal($data){		
		$msg = '';
		$hsl = true;

		// cek setting account harus diisi
		if($hsl){
			if(!$this->m_setting_account->get_setting_account_byid('MWIP') ||
				!$this->m_setting_account->get_setting_account_byid('MTRS')){
				$hsl = false;				
				$msg = 'There is an account that has not been set';				
			}						
		}

		//cek akun perkiraan di master kategori harus diisi
		if($hsl){
			if(isset($data['detail'])){
				foreach ($data['detail'] as $key => $value) {
					$mskt_no = substr($data['detail'][$key]['dtmt_mspd_no'], 0, 1);					
					if(!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv')){
						$hsl = false;						
						$msg = 'There is an account not yet filled in Category Master';						
					}								
				}
			}
		}

		return array('valid'=>$hsl, 'msg'=>$msg);
	}

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'trmt_mscb_no1',
		                'label' => 'Area from',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        ),
		        array(
		                'field' => 'trmt_msgd_no1',
		                'label' => 'Warehouse from',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        ),
		        array(
		                'field' => 'trmt_msgd_no2',
		                'label' => 'Warehouse to',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        ),
		        array(
		                'field' => 'trmt_mscb_no2',
		                'label' => 'Area to',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        ),
		);
		return $config;
	}

	private function cek_valid_data_trans($menu, $data){
			// keterangan :
			// $menu = NEW | EDIT | VOID 

			$msg = '';
			$hsl = true;
			$tgl_cls_jurnal = $this->m_setting->get_setting('simr_char1','tcj', 1);

			if($menu == 'DELIVERYNOW' || $menu == 'RECEIVE_GOODS' || $menu == 'CANCEL_DELIVERYNOW' || $menu == 'CANCEL_RECEIVE_GOODS'){
				// cek jika tgl/bln jurnal sudah diclosing maka transaksi tidak bisa di create/edit/void
				if($menu == 'DELIVERYNOW' || $menu == 'CANCEL_DELIVERYNOW'){
					$tgl_trans = $this->input->post('trmt_tglkirim');
				}else if($menu == 'RECEIVE_GOODS' || $menu == 'CANCEL_RECEIVE_GOODS'){
					$tgl_trans = $this->input->post('trmt_tglterima');
				}

				$tahun = substr($tgl_trans, 0, 4);
				$bulan = substr($tgl_trans, 5, 2);	
				$tgl_trans = (int)$tahun.$bulan;				

				if($hsl && ($tgl_trans <= $tgl_cls_jurnal)){
					$hsl = false;
					$msg = 'Can not create new/edit/void transaction if journal transaction date is closed. Please choose another date.';
				}
			}

			if($menu == 'CANCEL_DELIVERYNOW' || $menu == 'CANCEL_RECEIVE_GOODS'){
				// transaksi tidak bisa di cancel jika jurnal sudah di closing
				if($menu == 'CANCEL_DELIVERYNOW'){					
					$is_recon_exists = $this->m_app->is_recon_exists($data['header']['trmt_no'].'MD');
				}

				if($menu == 'CANCEL_RECEIVE_GOODS'){					
					$is_recon_exists = $this->m_app->is_recon_exists($data['header']['trmt_no'].'MR');
				}				

				// Transaksi yang sudah di rekonsiliasi tidak bisa di edit/void/cancel
				if($hsl && $is_recon_exists){
					$hsl = false;
					$msg = 'Transactions cannot be changed. Journal already in reconciliation';
				}
			}
			
			// cek gudang tidak boleh sama			
			if($hsl && ($data['action'] == 'NEW' || $data['action'] == 'EDIT' || $data['action'] == 'DELIVERYNOW')){
				if($this->input->post('trmt_msgd_no1') == $this->input->post('trmt_msgd_no2')){
					$hsl = false;					
					$msg = 'Warehouse origin may not be the same as the destination';					
				}
			}

			// cek produk harus dipilih
			if($hsl && ($data['action'] == 'NEW' || $data['action'] == 'EDIT' || $data['action'] == 'DELIVERYNOW')){
				if(!isset($this->data['detail'])){
					$hsl = false;					
					$msg = 'Please select product';					
				}	
			}

			// cek tidak boleh di cancel receive goods kalo status copy-nya (X)
			if($hsl && $data['action'] == 'CANCEL_APPROVAL'){
				if($data['trmt_stcopy'] == 'X'){
					$hsl = false;					
					$msg = 'Transaction cannot be cancelled. Please change status exclude (X) first';					
				}	
			}

			// cek expedition
			// if($hsl){
			// 	if($this->data['action'] == 'DELIVERYNOW' &&
			// 		$this->input->post('trmt_ekspedisi') == '' &&
			// 		$this->input->post('trmt_noekspedisi') == ''){
			// 			$hsl = false;						
			// 			$msg = 'Pleas input expedition and expedition number';						
			// 	}
			// }			

			// utk pengecekan dtmt_qtyout dan dtmt_qtyin Mutasi
			// Valid = Stok setelah mutasi tidak boleh minus
			if ($hsl) {
				if(isset($data['detail'])){
					foreach ($data['detail'] as $key => $value) {						
						if($data['action'] == 'NEW' || $data['action'] == 'EDIT' || $data['action'] == 'DELIVERYNOW'){
							$dtmt_qtyout = $data['detail'][$key]['dtmt_qtyout'];						
							$stok = $this->m_stok->get_stok($data['detail'][$key]['dtmt_mspd_no'],$data['header']['trmt_msgd_no1']);

							if ($dtmt_qtyout <= 0){
								$hsl = false;
								$msg = 'Qty out cannot <= 0';
								break;
							}

							if($this->session->userdata('svlogin') != 'F'){
								if (($stok - $dtmt_qtyout) < 0){
									$hsl = false;
									$msg = 'Stock Insufficient'.
									       '<br>Product: ' . $data['detail'][$key]['dtmt_mspd_no'].
									       '<br>Warehouse: ' . $data['header']['trmt_msgd_no1'].
									       '<br>Stock: ' . $stok;							       
									break;
								}
							}
						}

						if($data['action'] == 'RECEIVE_GOODS'){
							$dtmt_qtyin = $data['detail'][$key]['dtmt_qtyin'];							

							if ($dtmt_qtyin < 0){
								$hsl = false;
								$msg = 'Qty in cannot < 0';
								break;
							}			
						}					
					}
				}	
			}

			// utk pengecekan cekint Mutasi, 
			// Valid = CekInt tidak berubah
			if ($hsl && $menu != 'NEW') {
				if($this->m_mutasi->get_mutasi_cekint($data['header']['trmt_no'], $data['trmt_cekint']) == false){
					$hsl = false;
					$msg = 'Data have been changed by another user. Please Refresh the page';
				}else{
					$this->m_mutasi->set_mutasi_cekint($data['header']['trmt_no']);
				}
			}

			return array('valid'=>$hsl, 'msg'=>$msg);
	}


}	