<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class paket_produk extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_paket_produk');				
		$this->load->model('setting/m_currency_rates');	
	}

	public function index(){
		if(!fcek_hak_akses('.AQ0.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['per_page'] = 15;
		$data['request_from'] = 'list';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/paket_produk/v_paket_produk_list', $data);
		$this->load->view('v_footer');			
	}

	public function paket_produk_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'paket_produk');

		$data = array();
		$result = array();
		$pagination = array();

		$per_page = $this->input->post('per_page');
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');
		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			

		$data['paket_produk_list'] = $this->m_paket_produk->get_paket_produk_list($arr_filter, false, $per_page, $offset, $fn, $sort);
		$data['request_from'] = $this->input->post('request_from');

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['paket_produk_list']);
		}
		else {
			$pagination['total_list'] = $this->m_paket_produk->get_paket_produk_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['paket_produk_list'] = $this->load->view('data_master/paket_produk/v_paket_produk_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function paket_produk_new(){			
		if(!fcek_hak_akses('.AQ1.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		$data['kurs'] = $this->m_currency_rates->get_currency_rates();		
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/paket_produk/v_paket_produk_form',$data);
		$this->load->view('v_footer');		
	}

	public function paket_produk_view($mspp_no){	
		if(!fcek_hak_akses('.AQ0.')) {
			redirect('forbidden');
		}

		if (is_null($mspp_no) || !$this->m_paket_produk->get_paket_produk($mspp_no)) {
			redirect('paket_produk');
			return;
		}

		$data = array();		
		$data = $this->m_paket_produk->get_paket_produk($mspp_no);				
		$data['kurs'] = $this->m_currency_rates->get_currency_rates();
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		$data['action'] = 'view';		
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/paket_produk/v_paket_produk_form',$data);
		$this->load->view('v_footer');		
	}

	public function paket_produk_new_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'paket_produk');						

		$result = array();	
		$this->form_validation->set_rules($this->config_validation());

		$vok = true;

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = $this->form_validation->error_array();
				echo json_encode($result);
				return;
			}
		}		

		//cek id tidak harus unik
		if($vok){
			if($this->m_paket_produk->get_paket_produkno($this->input->post('mspp_no')) > 0){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error' => 'Package #: '.$this->input->post('mspp_no').' is already registered.');
				echo json_encode($result);
				return;
			}
		}

		// cek tidak boleh memilih produk yang sama lebih dari satu
		if($vok){
			$mdpp = $this->input->post('mdpp');									

			if(isset($mdpp)){
				if(count(array_unique($mdpp['mdpp_mspd_no'])) != count($mdpp['mdpp_mspd_no'])){
					$vok = false;
					$result['response'] = 'gagal';			
					$result['error_message'] = array('error'=>'Can not choose the same product more than one.');
					echo json_encode($result);
					return;
				}
			}			
		}

		// set data
		if($vok){										
			$data = array();				
			$data['header']['mspp_no'] = fhapus_kutip($this->input->post('mspp_no'));
			$data['header']['mspp_nm'] = fhapus_kutip($this->input->post('mspp_nm'));
			$data['header']['mspp_total'] = ftodouble($this->input->post('mdpp_total'));
			$data['header']['mspp_listmscb'] = (($this->input->post('mspp_listmscb') != '') ? ".". implode('.', $this->input->post('mspp_listmscb')). "." : '');
			$data['header']['mspp_tag'] = fhapus_kutip($this->input->post('mspp_tag'));
			$data['header']['mspp_catatan'] = fhapus_kutip($this->input->post('mspp_catatan'));
			$data['header']['mspp_aktif'] = 1;			
			$data['header']['mspp_lsupd'] = date('Y-m-d H:i:s');
			$data['header']['mspp_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];

			$mdpp = $this->input->post('mdpp');									

			foreach ($mdpp as $key => $value1) {
				foreach ($mdpp[$key] as $idx => $value2) {					
					if ($mdpp['mdpp_mspd_no'][$idx] != '') {
						$data['detail'][$idx]['mdpp_no'] = $data['header']['mspp_no'];
						if($key == 'mdpp_mspd_no' || $key == 'mdpp_curr'){
							$data['detail'][$idx][$key] = $value2;
						}else{							
							$data['detail'][$idx][$key] = ftodouble($value2);							
						}
					}
				}				
			}		
		}	
		
		// simpan data
		if($vok){	
			$vresult = $this->m_paket_produk->paket_produk_new_simpan($data);
			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');
				$result['response'] = 'sukses';				
      	 		$result['mspp_no'] = $data['header']['mspp_no'];
      	 		echo json_encode($result);
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}
		}				        
	}

	public function paket_produk_edit_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'paket_produk');						

		$result = array();	
		$this->form_validation->set_rules($this->config_validation());

		$vok = true;

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = $this->form_validation->error_array();
				echo json_encode($result);
				return;
			}
		}

		// cek tidak boleh memilih produk yang sama lebih dari satu
		if($vok){
			$mdpp = $this->input->post('mdpp');									

			if(isset($mdpp)){
				if(count(array_unique($mdpp['mdpp_mspd_no'])) != count($mdpp['mdpp_mspd_no'])){
					$vok = false;
					$result['response'] = 'gagal';			
					$result['error_message'] = array('error'=>'Can not choose the same product more than one.');
					echo json_encode($result);
					return;
				}
			}			
		}

		// set data
		if($vok){										
			$data = array();				
			$data['header']['mspp_no'] = fhapus_kutip($this->input->post('mspp_no'));
			$data['header']['mspp_nm'] = fhapus_kutip($this->input->post('mspp_nm'));
			$data['header']['mspp_total'] = ftodouble($this->input->post('mdpp_total'));
			$data['header']['mspp_listmscb'] = (($this->input->post('mspp_listmscb') != '') ? ".". implode('.', $this->input->post('mspp_listmscb')). "." : '');
			$data['header']['mspp_tag'] = fhapus_kutip($this->input->post('mspp_tag'));
			$data['header']['mspp_catatan'] = fhapus_kutip($this->input->post('mspp_catatan'));			
			$data['header']['mspp_lsupd'] = date('Y-m-d H:i:s');
			$data['header']['mspp_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];

			$mdpp = $this->input->post('mdpp');									

			foreach ($mdpp as $key => $value1) {
				foreach ($mdpp[$key] as $idx => $value2) {					
					if ($mdpp['mdpp_mspd_no'][$idx] != '') {
						$data['detail'][$idx]['mdpp_no'] = $data['header']['mspp_no'];
						if($key == 'mdpp_mspd_no' || $key == 'mdpp_curr'){
							$data['detail'][$idx][$key] = $value2;
						}else{							
							$data['detail'][$idx][$key] = ftodouble($value2);							
						}
					}
				}				
			}		
		}	
		
		// simpan data
		if($vok){	
			$vresult = $this->m_paket_produk->paket_produk_edit_simpan($data);
			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');
				$result['response'] = 'sukses';				
      	 		$result['mspp_no'] = $data['header']['mspp_no'];
      	 		echo json_encode($result);
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}
		}				        
	}

	public function paket_produk_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'paket_produk');

		$data = array();
		$data['per_page'] = 13;
		$data['request_from'] = 'popup';
		
		$respon = array();
		$respon['popup'] = $this->load->view('data_master/paket_produk/v_paket_produk_popup',$data,true);	
		echo json_encode($respon);		
	}

	public function paket_produk_item(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'paket_produk');		
		$data = $this->m_paket_produk->get_paket_produk($this->input->post('mdpp_no'));
		$data['produk_item'] = $data['detail'];

		echo json_encode($data['produk_item']);
	}

	public function paket_produk_aktif_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'cabang');

		$data['mspp_no'] = $this->input->post('mspp_no');
		$data['mspp_aktif'] = $this->input->post('mspp_aktif');

		if($this->m_paket_produk->paket_produk_aktif_simpan($data)){
			$this->session->set_userdata('alert_sukses','sukses');			
			$result['response'] = 'sukses';				
  	 		$result['mspp_no'] = $data['mspp_no'];			
  	 		echo json_encode($result);
		}
	}	

	private function config_validation(){
		$config = array(
				array(
		                'field' => 'mspp_listmscb[]',
		                'label' => 'Area',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mspp_no',
		                'label' => 'Package #',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'mspp_nm',
		                'label' => 'Package Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        )
		);
		return $config;
	}
}