<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class po_payment extends MY_Controller {
	private $data = array();

	function __construct(){
		parent::__construct();
		$this->load->model('finance_and_acc/m_po_payment');
		$this->load->model('purchase/m_purchase_order');		
		$this->load->model('purchase/m_purchase_return');		
		$this->load->model('purchase/m_incoming_delivery');		
		$this->load->model('setting/m_currency_rates');
		$this->load->model('finance_and_acc/m_jurnal');
		$this->load->model('data_master/m_acc_perkiraan');
		$this->load->model('setting/m_setting_account');
		$this->load->model('setting/m_setting');		
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function index(){			
		if(!fcek_hak_akses('.ED0.')) {
			redirect('forbidden');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/po_payment/v_po_payment_list', $data);
		$this->load->view('v_footer');			
	}

	public function po_payment_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'po_payment');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['po_payment_list'] = $this->m_po_payment->get_po_payment_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['po_payment_list']);
		}
		else {
			$pagination['total_list'] = $this->m_po_payment->get_po_payment_list($arr_filter, true);		
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['po_payment_list'] = $this->load->view('finance_and_acc/po_payment/v_po_payment_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}
	
	public function po_payment_new($trpo_no = null){	
		if(!fcek_hak_akses('.ED1.')) {
			redirect('forbidden');
		}

		$data = array();
		if(is_null($trpo_no)){			
			$data['action'] = 'new';
		}else{
			$data = $this->m_purchase_order->get_purchase_order($trpo_no);
			if(count($data) <= 0) {
				redirect('purchase_order');
				return;
			}else{				
				$data['incoming_delivery'] = $this->m_incoming_delivery->get_incoming_delivery_bypoid($trpo_no);								
				$data['action'] = 'new_import';
			}				
		}
				
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		$data['kurs'] = $this->m_currency_rates->get_currency_rates();
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/po_payment/v_po_payment_form',$data);
		$this->load->view('v_footer');		
	}

	public function po_payment_view($pbpo_no){			
		if(!fcek_hak_akses('.ED0.')) {
			redirect('forbidden');
		}

		$data = array();						
		$pbpo = $this->m_po_payment->get_po_payment($pbpo_no);

		if (is_null($pbpo_no) || count($pbpo) <= 0) {
			redirect('po_payment');
			return;
		}
		
		$data['header'] = $pbpo[0];
		$data['detail'] = $pbpo;

		$trju_no = $this->m_jurnal->get_jurnalid($pbpo_no.'PP');
		if($trju_no != false){
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_no);			
			$data['jurnal_h'] = $data_jurnal['jurnal_h'];
			$data['jurnal_d'] = $data_jurnal['jurnal_d'];				
		}

		$data['kurs'] = $this->m_currency_rates->get_currency_rates();
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		$data['action'] = 'view';
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/po_payment/v_po_payment_form',$data);
		$this->load->view('v_footer');		
	}

	public function po_payment_print(){
		$this->load->library('java_bridge');
		$pbpo_no = $this->input->get('pbpo_no');
		$paper_size = $this->input->get('paper_size');

		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];
		

		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}

		if($paper_size == 'A5'){
			$path = APPPATH.'prints\purchase\po_payment\p_po_payment_A5.jrxml';
		}elseif($paper_size == 'A4') {
			$path = APPPATH.'prints\purchase\po_payment\p_po_payment_A4.jrxml';
		}		
		$params = new Java("java.util.HashMap");
		$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
		$params->put("P_PBPO_NO",new Java('java.lang.String', $pbpo_no));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$this->java_bridge->print_data($path, $params);
	}	

	public function po_payment_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'po_payment');		
		$this->form_validation->set_rules($this->config_validation());
		$vok = true;
		$msg;
		
		// set data transaksi
		if($vok){
				$this->data['action'] = $this->input->post('action');
				$this->data['msjb_tipe'] = ($this->input->post('pbpo_jenis') == 'O') ? substr($this->input->post('pbpo_msjb_no'), 0, 1) : '';
				$this->data['trpo_cekint'] = $this->input->post('trpo_cekint');				
				$this->data['trpt_cekint'] = $this->input->post('trpt_cekint');	
				$this->data['pbpo_total_bayar'] = $this->input->post('pbpo_total');
				$this->data['msjb_tipe'] = substr($this->input->post('pbpo_msjb_no'), 0, 1);
				$this->data['msjb_tipe_lama'] = $this->input->post('msjb_tipe_lama');
				$this->data['pbpo_trpt_no_lama'] = $this->input->post('pbpo_trpt_no_lama');

				if($this->data['action'] == 'NEW'){
					$this->data['header']['pbpo_no'] = $this->m_po_payment->po_payment_kode_auto($this->input->post('pbpo_no')); 
					$this->data['header']['pbpo_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];									
					$this->data['header']['pbpo_tgl'] = $this->input->post('pbpo_tgl');
					$this->data['header']['pbpo_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
					$this->data['header']['pbpo_void'] = 0;			
				}

				if($this->data['action'] != 'NEW'){
					$this->data['header']['pbpo_no'] = $this->input->post('pbpo_no'). '-' . $this->input->post('pbpo_seqno');
				}				

				$this->data['header']['pbpo_msjb_no'] = ($this->input->post('pbpo_jenis') == 'O') ? substr($this->input->post('pbpo_msjb_no'), 1) : '';
				$this->data['header']['pbpo_jenis'] = $this->input->post('pbpo_jenis');
				$this->data['header']['pbpo_bayardp'] = $this->input->post('pbpo_bayardp');
				$this->data['header']['pbpo_trpt_no'] = $this->input->post('pbpo_trpt_no');				
				$this->data['header']['pbpo_kurs'] = ftodouble($this->input->post('pbpo_kurs'));
				$this->data['header']['pbpo_tglcair'] = $this->input->post('pbpo_tglcair');		
				$this->data['header']['pbpo_tag'] = fhapus_kutip($this->input->post('pbpo_tag'));
				$this->data['header']['pbpo_catatan'] = fhapus_kutip($this->input->post('pbpo_catatan'));							
				$this->data['header']['pbpo_lsupd'] = date('Y-m-d H:i:s');
				$this->data['header']['pbpo_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];							

				if($this->data['action'] == 'EDIT' || $this->data['action'] == 'VOID'){
					$this->data['userlog']['msul_tgl'] = date('Y-m-d H:i:s');
					$this->data['userlog']['msul_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
					$this->data['userlog']['msul_catatan'] = substr(trim('['.$this->data['action']. '] PBY.PO '. $this->data['header']['pbpo_no']. ' SUPP:'. substr($this->input->post('pbpo_mssp_no'), 9). ' '. fhapus_kutip($this->input->post('pbpo_tag')). ' '. fhapus_kutip($this->input->post('pbpo_catatan'))), 0, 250);
				}

				$pbpo = $this->input->post('pbpo');

				if(count($pbpo) > 0){
					foreach ($pbpo as $key => $value) {
						for ($i=0; $i < count($pbpo[$key]); $i++) {
							if($this->data['action'] == 'NEW'){
								if($pbpo['pbpo_jlhbayar'][$i] > 0){														
									if($key == 'pbpo_jlhbayar' || $key == 'pbpo_sisabayar'){
										$this->data['detail'][$i][$key] = ftodouble($value[$i]);										
									}else{								
										$this->data['detail'][$i][$key] = $value[$i];											
									}		
								}
							}
							if($this->data['action'] == 'EDIT' || $this->data['action'] == 'VOID'){
								if($key == 'pbpo_jlhbayar' || $key == 'pbpo_sisabayar'){
									$this->data['detail'][$i][$key] = ftodouble($value[$i]);
								}else{								
									$this->data['detail'][$i][$key] = $value[$i];											
								}
							}
						}
					}
				}																												
		}

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;				
				$msg = $this->form_validation->error_array();				
			}
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);				
			}
		}

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal($this->data);			
		}

		// cek valid data jurnal				
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_jurnal($this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}		
		
		// simpan data
		if($vok){							
			$vresult = $this->m_po_payment->po_payment_simpan($this->data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}			
		}				        		

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['pbpo_no'] = $this->data['header']['pbpo_no'];      	 		  	 		
		}	

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);
	}

	// private function set_data_jurnal($data){
	// 	//Header jurnal
	// 	if($data['action'] == 'NEW'){			
	// 		$trju_tgl = $data['header']['pbpo_tgl'];
	// 		$trju_tipe = 'A';
	// 		$bulan = substr($trju_tgl, 5, 2);			
	// 		$tahun = substr($trju_tgl, 2, 2);
	// 		$separator = ($this->input->post('trpo_fin') == 'F') ? '-' : '_';		
	// 		$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;
	// 		$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);							
	// 		$data['jurnal_h']['trju_tgl'] = $trju_tgl;
	// 		$data['jurnal_h']['trju_tipe'] = $trju_tipe;				
	// 		$data['jurnal_h']['trju_refno'] = $data['header']['pbpo_no'].'PP';
	// 		$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
	// 		$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
	// 		$data['jurnal_h']['trju_void'] = 0;			
	// 		$data['jurnal_h']['trju_reftipe'] = 'PP';
	// 		$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trpo_fin') == 'C') ? 'A' : 'R';
	// 		$data['jurnal_h']['trju_fin'] = $this->input->post('trpo_fin');
	// 	}

	// 	if($data['action'] != 'NEW'){
	// 		$data['jurnal_h']['trju_no'] = $this->input->post('trju_no');
	// 	}

	// 	$trju_catatan = $data['header']['pbpo_tag'].' '.$data['header']['pbpo_no'].'/'.substr($this->input->post('pbpo_mssp_no'), 0, 6). ' - '. substr($this->input->post('pbpo_mssp_no'), 9);
	// 	$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));
	// 	$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
	// 	$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];		

	// 	// Set account														
 // 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
	// 		if(isset($data['detail'])){								
	// 			$temp_pbpo = $this->input->post('temp_pbpo');
	// 			$data['jurnal_d'] = array();
	// 			$array = array();
	// 			foreach ($data['detail'] as $key => $value) {
	// 				$mssp = substr($this->input->post('pbpo_mssp_no'), 0, 1);					
	// 				$saldo_faktur = round(ftodouble($data['detail'][$key]['pbpo_jlhbayar']) * ftodouble($temp_pbpo['trid_kurs'][$key]), 4);
	// 				$saldo_pbyr = round(ftodouble($data['detail'][$key]['pbpo_jlhbayar']) * ftodouble($data['header']['pbpo_kurs']), 4);					

	// 				// set array selisih kurs
	// 				// ___________________________________________________________________
	// 					$acc = $this->m_setting_account->get_setting_account_byid('SLHK');
	// 					$array_selisih_kurs['dtju_msap_no'] = $acc['mssa_msap_no'];

	// 					// cek syarat account selisih
	// 					if($saldo_pbyr > $saldo_faktur){						
	// 						$array_selisih_kurs['dtju_debet'] = $saldo_pbyr - $saldo_faktur;
	// 						$array_selisih_kurs['dtju_kredit'] = 0;
	// 					}elseif($saldo_faktur > $saldo_pbyr){						
	// 						$array_selisih_kurs['dtju_debet'] = 0;
	// 						$array_selisih_kurs['dtju_kredit'] = $saldo_faktur - $saldo_pbyr;
	// 					}					
	// 				// ___________________________________________________________________
					

	// 				if($data['header']['pbpo_bayardp'] == 'T' && $data['header']['pbpo_jenis'] == 'O'){																		
	// 			 		// Account Hutang Lokal / Import (Debet)				 		
	// 			 		if($mssp == 'L'){
	// 				 		$acc = $this->m_setting_account->get_setting_account_byid('HUTL');
	// 				 	} else {
	// 				 		$acc = $this->m_setting_account->get_setting_account_byid('HUTI');
	// 				 	}
	// 					$array['dtju_msap_no'] = $acc['mssa_msap_no'];
	// 					$array['dtju_debet'] = $saldo_faktur;
	// 					$array['dtju_kredit'] = 0;
	// 					array_push($data['jurnal_d'], $array);		

	// 					// Account Selisih kurs jika saldo kredit > saldo debet
	// 					if($saldo_pbyr > $saldo_faktur){							
	// 						array_push($data['jurnal_d'], $array_selisih_kurs);		
	// 					}

	// 					// Account Pembayaran (Kredit)						
	// 				 	$array['dtju_msap_no'] = $this->m_acc_perkiraan->get_msjb_msap_no(substr($this->input->post('pbpo_msjb_no'), 1));
	// 			 		$array['dtju_debet'] = 0;
	// 			 		$array['dtju_kredit'] = $saldo_pbyr;
	// 			 		array_push($data['jurnal_d'], $array);							

	// 			 		// Account Selisih kurs jika saldo debet > saldo kredit
	// 					if($saldo_faktur > $saldo_pbyr){
	// 						array_push($data['jurnal_d'], $array_selisih_kurs);	
	// 					}
	// 				}

	// 				if($data['header']['pbpo_bayardp'] == 'D' && $data['header']['pbpo_jenis'] == 'O'){																															
	// 			 		// Account Pembayaran DP (Debet)
	// 			 		$acc = $this->m_setting_account->get_setting_account_byid('PPDP');
	// 					$array['dtju_msap_no'] = $acc['mssa_msap_no'];
	// 					$array['dtju_debet'] = $saldo_pbyr;
	// 					$array['dtju_kredit'] = 0;
	// 					array_push($data['jurnal_d'], $array);																		

	// 					// Account Pembayaran (Kredit)
	// 				 	$array['dtju_msap_no'] = $this->m_acc_perkiraan->get_msjb_msap_no(substr($this->input->post('pbpo_msjb_no'), 1));
	// 			 		$array['dtju_debet'] = 0;
	// 			 		$array['dtju_kredit'] = $saldo_pbyr;
	// 			 		array_push($data['jurnal_d'], $array);	
	// 				}

	// 				if($data['header']['pbpo_bayardp'] == 'T' && $data['header']['pbpo_jenis'] == 'D'){						
	// 			 		// Account Hutang Lokal / Import (Debet)
	// 			 		if($mssp == 'L'){
	// 				 		$acc = $this->m_setting_account->get_setting_account_byid('HUTL');
	// 				 	} else {
	// 				 		$acc = $this->m_setting_account->get_setting_account_byid('HUTI');
	// 				 	}
	// 					$array['dtju_msap_no'] = $acc['mssa_msap_no'];
	// 					$array['dtju_debet'] = $saldo_faktur;
	// 					$array['dtju_kredit'] = 0;
	// 					array_push($data['jurnal_d'], $array);

	// 					// Account Selisih kurs jika saldo kredit > saldo debet
	// 					if($saldo_pbyr > $saldo_faktur){							
	// 						array_push($data['jurnal_d'], $array_selisih_kurs);		
	// 					}

	// 					// Account Pembayaran DP (Kredit)
	// 					$acc = $this->m_setting_account->get_setting_account_byid('PPDP');
	// 				 	$array['dtju_msap_no'] = $acc['mssa_msap_no'];
	// 			 		$array['dtju_debet'] = 0;
	// 			 		$array['dtju_kredit'] = $saldo_pbyr;
	// 			 		array_push($data['jurnal_d'], $array);	

	// 			 		// Account Selisih kurs jika saldo debet > saldo kredit
	// 					if($saldo_faktur > $saldo_pbyr){
	// 						array_push($data['jurnal_d'], $array_selisih_kurs);	
	// 					}						
	// 				}

	// 				if(($data['header']['pbpo_bayardp'] == 'C' || $data['header']['pbpo_bayardp'] == 'B') && $data['header']['pbpo_jenis'] == 'D'){
	// 			 		// Account Adjustment DP PO (Debet)
	// 			 		$acc = $this->m_setting_account->get_setting_account_byid('APPO');
	// 					$array['dtju_msap_no'] = $acc['mssa_msap_no'];
	// 					$array['dtju_debet'] = $saldo_pbyr;
	// 					$array['dtju_kredit'] = 0;
	// 					array_push($data['jurnal_d'], $array);

	// 					// Account Pembayaran DP (Kredit)
	// 					$acc = $this->m_setting_account->get_setting_account_byid('PPDP');
	// 				 	$array['dtju_msap_no'] = $acc['mssa_msap_no'];
	// 			 		$array['dtju_debet'] = 0;
	// 			 		$array['dtju_kredit'] = $saldo_pbyr;
	// 			 		array_push($data['jurnal_d'], $array);							
	// 				}					
	// 			}	
	// 			$this->data['jurnal_d'] = $data['jurnal_d'];			
	// 		}	
 // 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^				 																								
	// 	$this->data['jurnal_h'] = $data['jurnal_h'];

	// }

	private function set_data_jurnal($data){
		//Header jurnal
		if($data['action'] == 'NEW'){			
			$trju_tgl = $data['header']['pbpo_tgl'];
			$trju_tipe = 'A';
			$bulan = substr($trju_tgl, 5, 2);			
			$tahun = substr($trju_tgl, 2, 2);
			$separator = ($this->input->post('trpo_fin') == 'F') ? '-' : '_';		
			$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;
			$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);							
			$data['jurnal_h']['trju_tgl'] = $trju_tgl;
			$data['jurnal_h']['trju_tipe'] = $trju_tipe;				
			$data['jurnal_h']['trju_refno'] = $data['header']['pbpo_no'].'PP';
			$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
			$data['jurnal_h']['trju_void'] = 0;			
			$data['jurnal_h']['trju_reftipe'] = 'PP';
			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trpo_fin') == 'C') ? 'A' : 'R';
			$data['jurnal_h']['trju_fin'] = $this->input->post('trpo_fin');
		}

		if($data['action'] != 'NEW'){
			$data['jurnal_h']['trju_no'] = $this->input->post('trju_no');
		}

		$trju_catatan = $data['header']['pbpo_tag'].' '.$data['header']['pbpo_no'].'/'.substr($this->input->post('pbpo_mssp_no'), 0, 6). ' - '. substr($this->input->post('pbpo_mssp_no'), 9);
		$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));
		$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
		$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];		

		// Set account														
 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
			if(isset($data['detail'])){								
				$temp_pbpo = $this->input->post('temp_pbpo');
				$data['jurnal_d'] = array();
				$array = array();

				$mssp = substr($this->input->post('pbpo_mssp_no'), 0, 1);

				foreach ($data['detail'] as $key => $value) {

					// PEMBAYARAN UNTUK FAKTUR ==========================================================
					if($data['header']['pbpo_bayardp'] == 'T') {
							
						// DEBET ------------------------------------------------------------------------
						// AKUN DEBET : Cek Supplier Import / Lokal
						if($mssp == 'L'){
					 		$acc = $this->m_setting_account->get_setting_account_byid('HUTL');
					 		$acc_no = $acc['mssa_msap_no'];
					 	} else {
					 		$acc = $this->m_setting_account->get_setting_account_byid('HUTI');
					 		$acc_no = $acc['mssa_msap_no'];
					 	}

					 	// SALDO DEBET : Jlh_pbyr * Kurs Faktur
					 	$saldo_d = round(ftodouble($data['detail'][$key]['pbpo_jlhbayar']) * ftodouble($temp_pbpo['trid_kurs'][$key]), 4);
					 	$saldo_k = 0;

					 	$nett_kurs_d = $saldo_d;

					 	// SET ARRAY DETAIL JURNAL :
						$array['dtju_msap_no'] = $acc_no;
						$array['dtju_debet'] = $saldo_d;
						$array['dtju_kredit'] = $saldo_k;
						array_push($data['jurnal_d'], $array);		

						// KREDIT ------------------------------------------------------------------------
						// AKUN KREDIT : Cek Berasal dari potong DP atau bukan
						if ($data['header']['pbpo_jenis'] == 'O') {
                        	$acc_no = $this->m_acc_perkiraan->get_msjb_msap_no(substr($this->input->post('pbpo_msjb_no'), 1));
						} else if($data['header']['pbpo_jenis'] == 'D'){
							$acc = $this->m_setting_account->get_setting_account_byid('PPDP');
					 	    $acc_no = $acc['mssa_msap_no'];
						}

						// SALDO KREDIT : Jlh_pbyr * Kurs Bayar
					 	$saldo_d = 0;
					 	$saldo_k = round(ftodouble($data['detail'][$key]['pbpo_jlhbayar']) * ftodouble($data['header']['pbpo_kurs']), 4);

					 	$nett_kurs_k = $saldo_k;

					 	// SET ARRAY DETAIL JURNAL :
						$array['dtju_msap_no'] = $acc_no;
						$array['dtju_debet'] = $saldo_d;
						$array['dtju_kredit'] = $saldo_k;
						array_push($data['jurnal_d'], $array);

						// SELISIH KURS --------------------------------------------------------------------
						if ($nett_kurs_d != $nett_kurs_k) {
							// AKUN :
							$acc = $this->m_setting_account->get_setting_account_byid('SLHK');
							$acc_no = $acc['mssa_msap_no'];

							// SALDO D / K :
							if ($nett_kurs_d > $nett_kurs_k) {
								$saldo_d = 0;
								$saldo_k = $nett_kurs_d - $nett_kurs_k;
							} else {
								$saldo_d = $nett_kurs_k - $nett_kurs_d;
								$saldo_k = 0;
							}

							// SET ARRAY DETAIL JURNAL :
							$array['dtju_msap_no'] = $acc_no;
							$array['dtju_debet'] = $saldo_d;
							$array['dtju_kredit'] = $saldo_k;
							array_push($data['jurnal_d'], $array);
						}
					}
					// PEMBAYARAN UNTUK DP ==============================================================
					elseif($data['header']['pbpo_bayardp'] == 'D') {
						// DEBET ------------------------------------------------------------------------
						// AKUN DEBET : 
						$acc = $this->m_setting_account->get_setting_account_byid('PPDP');
						$acc_no = $acc['mssa_msap_no'];

						// SALDO DEBET : Jlh_pbyr * Kurs Bayar
					 	$saldo_d = round(ftodouble($data['detail'][$key]['pbpo_jlhbayar']) * ftodouble($data['header']['pbpo_kurs']), 4);
					 	$saldo_k = 0;

					 	// SET ARRAY DETAIL JURNAL :
						$array['dtju_msap_no'] = $acc_no;
						$array['dtju_debet'] = $saldo_d;
						$array['dtju_kredit'] = $saldo_k;
						array_push($data['jurnal_d'], $array);

						// KREDIT ------------------------------------------------------------------------
						// AKUN KREDIT : 
						$acc_no = $this->m_acc_perkiraan->get_msjb_msap_no(substr($this->input->post('pbpo_msjb_no'), 1));

						// SALDO KREDIT : Jlh_pbyr * Kurs Bayar
					 	$saldo_d = 0;
					 	$saldo_k = round(ftodouble($data['detail'][$key]['pbpo_jlhbayar']) * ftodouble($data['header']['pbpo_kurs']), 4);

					 	// SET ARRAY DETAIL JURNAL :
						$array['dtju_msap_no'] = $acc_no;
						$array['dtju_debet'] = $saldo_d;
						$array['dtju_kredit'] = $saldo_k;
						array_push($data['jurnal_d'], $array);						
					}
					// PEMBAYARAN UNTUK ADJUSTMENT DP ==============================================================
					else { // untuk sisanya: $data['header']['pbpo_bayardp'] == 'C' OR 'B'

						// DEBET ------------------------------------------------------------------------
						// AKUN DEBET : 
						$acc = $this->m_setting_account->get_setting_account_byid('APPO');
						$acc_no = $acc['mssa_msap_no'];

						// SALDO DEBET : Jlh_pbyr * Kurs Bayar
					 	$saldo_d = round(ftodouble($data['detail'][$key]['pbpo_jlhbayar']) * ftodouble($data['header']['pbpo_kurs']), 4);
					 	$saldo_k = 0;

					 	// SET ARRAY DETAIL JURNAL :
						$array['dtju_msap_no'] = $acc_no;
						$array['dtju_debet'] = $saldo_d;
						$array['dtju_kredit'] = $saldo_k;
						array_push($data['jurnal_d'], $array);

						// KREDIT ------------------------------------------------------------------------
						// AKUN KREDIT : 
						$acc = $this->m_setting_account->get_setting_account_byid('PPDP');
						$acc_no = $acc['mssa_msap_no'];						

						// SALDO KREDIT : Jlh_pbyr * Kurs Bayar
					 	$saldo_d = 0;
					 	$saldo_k = round(ftodouble($data['detail'][$key]['pbpo_jlhbayar']) * ftodouble($data['header']['pbpo_kurs']), 4);

					 	// SET ARRAY DETAIL JURNAL :
						$array['dtju_msap_no'] = $acc_no;
						$array['dtju_debet'] = $saldo_d;
						$array['dtju_kredit'] = $saldo_k;
						array_push($data['jurnal_d'], $array);						
					}
				}	
				$this->data['jurnal_d'] = $data['jurnal_d'];			
			}	
 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^				 																								
		$this->data['jurnal_h'] = $data['jurnal_h'];

	}

	private function cek_valid_data_jurnal($data){
		$msg = '';
		$hsl = true;

		// cek setting account harus diisi
		if($hsl){
			if(!$this->m_setting_account->get_setting_account_byid('HUTL') ||
				!$this->m_setting_account->get_setting_account_byid('HUTI') ||
				!$this->m_setting_account->get_setting_account_byid('PPDP') ||
				!$this->m_setting_account->get_setting_account_byid('SLHK') ||
				!$this->m_setting_account->get_setting_account_byid('APPO')){
				$hsl = false;				
				$msg = 'There is an account that has not been set';
			}				
		}		

		return array('valid'=>$hsl, 'msg'=>$msg);
	}

	private function config_validation(){
		$config = array(		        
		        array(
		                'field' => 'pbpo_amount',
		                'label' => 'Amount',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        )
		);
		return $config;
	}

	private function cek_valid_data_trans($menu, $data){
		// keterangan :
		// $menu = NEW | EDIT | VOID

		$msg = '';
		$hsl = true;
		$tgl_cls_jurnal = $this->m_setting->get_setting('simr_char1','tcj', 1);

		if($hsl && ($menu == 'NEW' || $menu == 'EDIT' || $menu == 'VOID')){
			// transaksi tidak bisa di buat/edit/void jika tgl transaksi/jurnal sudah di closing
			$tgl_trans = $this->input->post('pbpo_tgl');
			$tahun = substr($tgl_trans, 0, 4);
			$bulan = substr($tgl_trans, 5, 2);	
			$tgl_trans = (int)$tahun.$bulan;

			if($hsl && $tgl_trans <= $tgl_cls_jurnal){
				$hsl = false;
				$msg = 'Can not create new/edit/void transaction if journal transaction date is closed. Please choose another date.';
			}
		}

		// Transaksi yang sudah di rekonsiliasi tidak bisa di edit/void/cancel
		if($hsl && ($menu == 'EDIT' || $menu == 'VOID')){				
			if($this->m_app->is_recon_exists($data['header']['pbpo_no'].'PP')){
				$hsl = false;
				$msg = 'Transactions cannot be changed. Journal already in reconciliation';
			}
		}

		if($data['action'] == 'NEW' || $data['action'] == 'EDIT'){

			// cek payment type (required jika potong DP = 'N')
			if($hsl){
				if($this->input->post('pbpo_jenis') == 'O' && $this->input->post('pbpo_msjb_no') == ''){				
					$hsl = false;					
					$msg = 'Please select payment type';					                
				}
			}			

			// Purchase Return # (required jika msjb_tipe = 'R')
			if($hsl){
				$msjb_tipe = substr($this->input->post('pbpo_msjb_no'), 0, 1);
				if($msjb_tipe == 'R' && $this->input->post('pbpo_trpt_no') == ''){
					$hsl = false;
					$msg = 'Please select Purchase Return #';
				}
			}	

			// cek amount (harus <= sisa bayar)
			if($hsl){			
				$trpo_sisa_bayar = fhapus_kutip(ftodouble($this->input->post('trpo_sisa_bayar')));
				if($this->input->post('pbpo_jenis') == 'O'){
					$pbpo_amount = fhapus_kutip(ftodouble($this->input->post('pbpo_amount')));				
					if($pbpo_amount > $trpo_sisa_bayar || $pbpo_amount <= 0){
						$hsl = false;					
						$msg = 'Amount must be > 0 and <= remaining value.';					
					}
				}					
			}
			
			// cek jika sisa pembayaran = 0 dan sisa DP > 0 maka cara bayar harus dari potong DP
			if($vok){	
				$trpo_sisa_bayar = fhapus_kutip(ftodouble($this->input->post('trpo_sisa_bayar')));		
				if($this->input->post('pbpo_jenis') == 'O' && $trpo_sisa_bayar <= 0){
					$hsl = false;				
					$msg = 'Payment method must be from DP';				
				}			
			}

			// cek potong dp (harus lebih kecil dari sisa dp)
			if($hsl){
				if($this->input->post('pbpo_jenis') == 'D'){														
					$pbpo_amount = fhapus_kutip(ftodouble($this->input->post('pbpo_amount')));
					$trpo_sisadp = fhapus_kutip(ftodouble($this->input->post('trpo_sisadp')));
					if($pbpo_amount > $trpo_sisadp){
						$hsl = false;					
						$msg = 'Amount must be > 0 and <= DP.';					
					}
				}	
			}

			// cek pembayaran detail/faktur (harus <= sisa bayar)		
			if($hsl){
				if(isset($data['detail']) && $this->input->post('pbpo_bayardp') == 'T'){
					foreach ($data['detail'] as $key => $value) {										
						$pbpo_jlhbayar = fhapus_kutip(ftodouble($data['detail'][$key]['pbpo_jlhbayar']));
						$pbpo_sisabayar = fhapus_kutip(ftodouble($data['detail'][$key]['pbpo_sisabayar']));
						if($pbpo_jlhbayar > $pbpo_sisabayar || $pbpo_jlhbayar < 0){
							$hsl = false;					
							$msg = 'Amount faktur must be <= remaining value.';					
							break;
						}
					}
				}
			}

			// cek total bayar (harus sama dengan nilai amount)
			if($hsl){															
				$pbpo_amount = fhapus_kutip(ftodouble($this->input->post('pbpo_amount')));
				$pbpo_total_bayar = fhapus_kutip(ftodouble($this->input->post('pbpo_total_bayar')));
				if($pbpo_amount != $pbpo_total_bayar){
					$hsl = false;				
					$msg = 'Amount and total should be the same';				
				}
			}	

			//cek apakah DP digunakan oleh transaksi lain?
			if($hsl && $data['action'] == 'EDIT'){				
				$pbpo_amount = fhapus_kutip(ftodouble($this->input->post('pbpo_amount')));
				$pbpo_jlhbayar_lama = fhapus_kutip(ftodouble($this->input->post('pbpo_jlhbayar_lama')));
				if($this->input->post('pbpo_bayardp') == 'D'){								
					if($this->input->post('cal_dpused') > 0 && $pbpo_amount != $pbpo_jlhbayar_lama){				
						$hsl = false;					
						$msg = 'Amount cannot be edit. DP has used by another transaction.';
	                }
				}				
			}

			//cek jika PO sudah di lock maka tidak boleh bayar DP
			if($hsl){								
				if($this->input->post('pbpo_bayardp') == 'D' && $this->input->post('trpo_lock') == 'Y'){								
					$hsl = false;					
					$msg = 'PO is locked. Cannot pay for DP';
				}				
			}
		}

		// tidak bisa di void jika DP sudah digunakan oleh transaksi lain
		if($hsl && $data['action'] == 'VOID'){			
			if($this->input->post('pbpo_bayardp') == 'D'){								
				if($this->input->post('cal_dpused') > 0){				
					$hsl = false;					
					$msg = 'This transaction cannot be void. DP has used by another transaction.';
                }
			}			
		}

		// utk pengecekan cekint, 
		// Valid = CekInt tidak berubah
		if($hsl){
			if($this->m_purchase_order->get_purchase_order_cekint(substr($data['header']['pbpo_no'], 0, 12), $data['trpo_cekint']) == false){
				$hsl = false;
				$msg = 'Data have been changed by another user. Please Refresh the page';
			}else{
				$this->m_purchase_order->set_purchase_order_cekint(substr($data['header']['pbpo_no'], 0, 12));
			}
		}

		if ($hsl) {
			if(isset($data['detail']) && $data['header']['pbpo_bayardp'] == 'T'){
				foreach ($data['detail'] as $key => $value){
					if($this->m_incoming_delivery->get_incoming_delivery_cekint($value['pbpo_refno'], $value['trid_cekint']) == false){
						$hsl = false;
						$msg = 'Data have been changed by another user. Please Refresh the page';
						break;
					}else{
						$this->m_incoming_delivery->set_incoming_delivery_cekint($value['pbpo_refno']);
					}
				}
			}
		}

		if ($hsl) {
			if($data['msjb_tipe'] == 'R'){
				if($this->m_purchase_return->get_purchase_return_cekint($data['header']['pbpo_trpt_no'], $data['trpt_cekint']) == false){
					$hsl = false;
					$msg = 'Data have been changed by another user. Please Refresh the page';
				}else{
					$this->m_purchase_return->set_purchase_return_cekint($data['header']['pbpo_trpt_no']);
				}
			}
		}							

		if ($hsl && $data['action'] != 'NEW') {
			if(isset($data['detail'])){
				foreach ($data['detail'] as $key => $value){
					if($this->m_po_payment->get_po_payment_cekint($data['header']['pbpo_no'], $value['pbpo_seq'], $value['pbpo_cekint']) == false){
						$hsl = false;
						$msg = 'Data have been changed by another user. Please Refresh the page';
						break;
					}else{
						$this->m_po_payment->set_po_payment_cekint($data['header']['pbpo_no'], $value['pbpo_seq']);
					}
				}
			}
		}

		return array('valid'=>$hsl, 'msg'=>$msg);
	}	

}