<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class purchase_return extends MY_Controller {
	private $data = array();		

	function __construct(){
		parent::__construct();		
		$this->load->model('purchase/m_purchase_return');				
		$this->load->model('purchase/m_purchase_order');
		$this->load->model('setting/m_currency_rates');				
		$this->load->model('data_master/m_produk');
		$this->load->model('stok_kontrol/m_stok');
		$this->load->model('setting/m_setting_account');
		$this->load->model('data_master/m_kategori');
		$this->load->model('finance_and_acc/m_jurnal');
		$this->load->model('setting/m_setting');	
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function index(){			
		if(!fcek_hak_akses('.BE0.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['per_page'] = 15;
		$data['request_from'] = 'list';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('purchase/purchase_return/v_purchase_return_list', $data);
		$this->load->view('v_footer');			
	}

	public function purchase_return_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'purchase_return');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['purchase_return_list'] = $this->m_purchase_return->get_purchase_return_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['purchase_return_list']);
		}
		else {
			$pagination['total_list'] = $this->m_purchase_return->get_purchase_return_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['purchase_return_list'] = $this->load->view('purchase/purchase_return/v_purchase_return_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function purchase_return_new($trpo_no = null){	
		if(!fcek_hak_akses('.BE1.')) {
			redirect('forbidden');
		}

		$data = array();
		if(is_null($trpo_no)){		
			$data['action'] = 'new';			
		}else{
			$data = $this->m_purchase_order->get_purchase_order($trpo_no);				

			if(count($data) <= 0) {
				redirect('purchase_order');
				return;
			}else{				
				$data['action'] = 'new_import';
			}				
		}
				
		$data['kurs'] = $this->m_currency_rates->get_currency_rates();
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('purchase/purchase_return/v_purchase_return_form',$data);
		$this->load->view('v_footer');		
	}

	public function purchase_return_view($trpt_no){	
		if(!fcek_hak_akses('.BE0.')) {
			redirect('forbidden');
		}

		if (is_null($trpt_no) || !$this->m_purchase_return->get_purchase_return($trpt_no)) {
			redirect('purchase_return');
			return;
		}
		$data = array();				
		$data = $this->m_purchase_return->get_purchase_return($trpt_no);
		$data['kurs'] = $this->m_currency_rates->get_currency_rates();

		$trju_no = $this->m_jurnal->get_jurnalid($trpt_no.'PR');
		if($trju_no != false){
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_no);			
			$data['jurnal_h'] = $data_jurnal['jurnal_h'];
			$data['jurnal_d'] = $data_jurnal['jurnal_d'];				
		}
		
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		$data['action'] = 'view';
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('purchase/purchase_return/v_purchase_return_form',$data);
		$this->load->view('v_footer');
	}


	public function purchase_return_print(){
		$this->load->library('java_bridge');
		$trpt_no = $this->input->get('trpt_no');
		$paper_size = $this->input->get('paper_size');

		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];
		

		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}

		if($paper_size == 'A5'){
			$path = APPPATH.'prints\purchase\purchase_return\p_purchase_return_A5.jrxml';
		}elseif($paper_size == 'A4') {
			$path = APPPATH.'prints\purchase\purchase_return\p_purchase_return_A4.jrxml';
		}	
			
		$params = new Java("java.util.HashMap");
		$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
		$params->put("P_TRPT_NO",new Java('java.lang.String', $trpt_no));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$this->java_bridge->print_data($path, $params);
	}	

	public function purchase_return_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'purchase_return');		
		$this->form_validation->set_rules($this->config_validation());		
		$vok = true;

		// set data
		if($vok){												
			$this->data['trpt_cekint'] = $this->input->post('trpt_cekint');						
			$this->data['trpo_no'] = $this->input->post('trpo_no');
			$this->data['trpo_cekint'] = $this->input->post('trpo_cekint');						
			$this->data['action'] = $this->input->post('action');							
			$this->data['trpt_jenis'] = $this->input->post('trpt_jenis');
			$this->data['trpt_mssp_no'] = substr($this->input->post('trpt_mssp_no'), 0, 1);
			$this->data['header']['trpt_msgd_no'] = $this->input->post('trpt_msgd_no');
			$this->data['header']['trpt_lsupd'] = date('Y-m-d H:i:s');
			$this->data['header']['trpt_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];

			if($this->data['action'] == 'NEW'){
				$trpo_no = $this->input->post('trpo_no');
				$this->data['header']['trpt_no'] = $this->m_purchase_return->purchase_return_kode_auto($trpo_no);			
				$this->data['header']['trpt_tgl'] = $this->input->post('trpt_tgl');
				$this->data['header']['trpt_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];	
				$this->data['header']['trpt_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];				
				$this->data['header']['trpt_curr'] = $this->input->post('trpt_curr');
				$this->data['header']['trpt_void'] = 0;							
			}

			if($this->data['action'] != 'NEW'){
				$this->data['header']['trpt_no'] = $this->input->post('trpt_no');				
			}

			// if($this->data['action'] == 'NEW' || (fcek_hak_akses('.BE9.') && $this->data['action'] == 'EDIT')){
				$this->data['header']['trpt_kurs'] = ftodouble($this->input->post('trpt_kurs'));
				$this->data['header']['trpt_total'] = ftodouble($this->input->post('trpt_total'));
				$this->data['header']['trpt_jenis'] = $this->input->post('trpt_jenis');							
			// }

			// if($this->data['action'] == 'NEW' || $this->data['action'] == 'EDIT'){				
				$this->data['header']['trpt_mssp_no'] = substr($this->input->post('trpt_mssp_no'), 0, 6);				
				$this->data['header']['trpt_jenis'] = $this->input->post('trpt_jenis');
				$this->data['header']['trpt_catatan'] = fhapus_kutip($this->input->post('trpt_catatan'));
				$this->data['header']['trpt_tag'] = fhapus_kutip($this->input->post('trpt_tag'));							
			// }

			if($this->data['action'] == 'CONF_EXIT_GOODS'){
				$this->data['header']['trpt_tglkeluar'] = $this->input->post('trpt_tglkeluar');				
			}
			
			if($this->data['action'] == 'CANCEL_EXIT_GOODS'){
				$this->data['header']['trpt_tglkeluar'] = '';
			}

			if($this->data['action'] == 'EDIT' || $this->data['action'] == 'VOID'){
				$this->data['userlog']['msul_tgl'] = date('Y-m-d H:i:s');
				$this->data['userlog']['msul_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['userlog']['msul_catatan'] = substr(trim('['.$this->data['action']. '] PURC.RET '. $this->data['header']['trpt_no']. ' SUPP:'. substr($this->input->post('trpt_mssp_no'), 9). ' '. fhapus_kutip($this->input->post('trpt_tag')). ' '. fhapus_kutip($this->input->post('trpt_catatan'))), 0, 250);
			}			
									
			$dtpt = $this->input->post('dtpt');
						
			foreach ($dtpt as $key => $value) {
				for ($i=0; $i < count($dtpt[$key]); $i++) {																									
					if($dtpt['dtpt_qtyretur'][$i] != 0){							
						$this->data['detail'][$i]['dtpt_no'] = $this->data['header']['trpt_no'];
						if($key == 'dtpt_seq' || $key == 'dtpt_mspd_no'){
							$this->data['detail'][$i][$key] = $dtpt[$key][$i];
						}else{
						 	$this->data['detail'][$i][$key] = ftodouble($dtpt[$key][$i]);
						}												

						if($this->data['action'] == 'CONF_EXIT_GOODS'){
					 		if($key == 'dtpt_mspd_no'){
								$this->data['detail'][$i]['dtpt_hpp'] = $this->m_produk->get_hpp($dtpt['dtpt_mspd_no'][$i]);
							}
						}

						if($this->data['action'] == 'CANCEL_EXIT_GOODS'){
					 		if($key == 'dtpt_mspd_no'){
								$this->data['detail'][$i]['dtpt_hpp'] = 0;
							}
						}
					}																	
				} 								
			}		
		}					

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = $this->form_validation->error_array();
				echo json_encode($result);
			}
		}						

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>$hasil_cek['msg']);
				echo json_encode($result);
			}
		}	

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal($this->data);			
		}

		// cek valid data jurnal
		if($vok){						
			if ($vok) {
				$hasil_cek = $this->cek_valid_data_jurnal($this->data['action'], $this->data);
				if($hasil_cek['valid'] == false){
					$vok = false;
					$result['response'] = 'gagal';
					$result['error_message'] = array('error'=>$hasil_cek['msg']);
					echo json_encode($result);
				}
			}
		}		

		// simpan data
		if($vok){
			$vresult = $this->m_purchase_return->purchase_return_simpan($this->data);

			if($vresult == 1){
				$this->session->set_userdata('alert_sukses','sukses');
				$result['response'] = 'sukses';				
      	 		$result['trpt_no'] = $this->data['header']['trpt_no'];
      	 		echo json_encode($result);
			}else{
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Error query');
				echo json_encode($result);
			}
		}				        
	}
	
	private function set_data_jurnal($data){
		if($data['action'] == 'CONF_EXIT_GOODS'){
			//Header jurnal
			$trju_tgl = $data['header']['trpt_tglkeluar'];
			$trju_tipe = 'A';
			$bulan = substr($trju_tgl, 5, 2);			
			$tahun = substr($trju_tgl, 2, 2);
			$separator = ($this->input->post('trpo_fin') == 'F') ? '-' : '_';
			$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;
			$trju_catatan = $data['header']['trpt_tag'].' '.$data['header']['trpt_no'].'/'.substr($this->input->post('trpt_mssp_no'), 0, 6). ' - '. substr($this->input->post('trpt_mssp_no'), 9);
			$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);							
			$data['jurnal_h']['trju_refno'] = $data['header']['trpt_no'].'PR';
			$data['jurnal_h']['trju_reftipe'] = 'PR';
			$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
			$data['jurnal_h']['trju_tgl'] = $trju_tgl;
			$data['jurnal_h']['trju_tipe'] = $trju_tipe;				
			$data['jurnal_h']['trju_void'] = 0;			
			$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
			$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trpo_fin') == 'C') ? 'A' : 'R';
			$data['jurnal_h']['trju_fin'] = $this->input->post('trpo_fin');
			$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));

			// Set account			
			if(isset($data['detail'])){			
				$data['jurnal_d'] = array();
				$array = array();				
				foreach ($data['detail'] as $key => $value) {						 		
					// Account Retur Cash / Voucher (Debet) dan Account Inventory, PPN Masukan dan Selisih Retur
			 		//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
			 			$mskt_no = substr($data['detail'][$key]['dtpt_mspd_no'], 0, 1);
					 	$nett_po = round((ftodouble($data['detail'][$key]['dtpt_nett']) * ftodouble($data['detail'][$key]['dtpt_qtyretur'])), 4);
					 	$hpp = round((ftodouble($data['detail'][$key]['dtpt_hpp']) * ftodouble($data['detail'][$key]['dtpt_qtyretur'])), 4);
					 	// $bftax = ftodouble($data['detail'][$key]['dtpt_bftaxrp']) * ftodouble($data['detail'][$key]['dtpt_qtyretur']);
					 	// $bftax = (ftodouble($data['detail'][$key]['dtpt_taxrp']) > 0) ? round(($hpp / 1.1), 4) : $hpp;
					 	// $tax = $hpp - $bftax;

						$tax = ftodouble($data['detail'][$key]['dtpt_taxrp']) * ftodouble($data['detail'][$key]['dtpt_qtyretur']);
						//$bftax = $hpp - $tax;
						
				 		// Account Retur Cash / Voucher (Debet)
				 		if($data['trpt_mssp_no'] == 'I' && $data['trpt_jenis'] == 'C'){	
							$acc = $this->m_setting_account->get_setting_account_byid('PRCI');						
				 		}elseif ($data['trpt_mssp_no'] == 'L' && $data['trpt_jenis'] == 'C') {
				 			$acc = $this->m_setting_account->get_setting_account_byid('PRCL');			 			
				 		}elseif ($data['trpt_mssp_no'] == 'I' && $data['trpt_jenis'] == 'V') {			 			
							$acc = $this->m_setting_account->get_setting_account_byid('PRVI');
				 		}elseif ($data['trpt_mssp_no'] == 'L' && $data['trpt_jenis'] == 'V') {
				 			$acc = $this->m_setting_account->get_setting_account_byid('PRVL');
				 		}			 		

						$array['dtju_msap_no'] = $acc['mssa_msap_no'];
						$array['dtju_debet'] = $nett_po;
						$array['dtju_kredit'] = 0;
						array_push($data['jurnal_d'], $array);

						// Account Inventory (Kredit)						
						$array['dtju_msap_no'] = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
						$array['dtju_debet'] = 0;
						// $array['dtju_kredit'] = $bftax;
						$array['dtju_kredit'] = $hpp;
						array_push($data['jurnal_d'], $array);

						// Account PPN Masukan (Kredit)
						$acc = $this->m_setting_account->get_setting_account_byid('PPNM');
					 	$array['dtju_msap_no'] = $acc['mssa_msap_no'];
				 		$array['dtju_debet'] = 0;
				 		$array['dtju_kredit'] = $tax;
				 		array_push($data['jurnal_d'], $array);

						// Account Selisih Retur (Kredit)
						if($data['trpt_mssp_no'] == 'I'){	
							$acc = $this->m_setting_account->get_setting_account_byid('PRSI');						
				 		}elseif ($data['trpt_mssp_no'] == 'L') {
				 			$acc = $this->m_setting_account->get_setting_account_byid('PRSL');			 			
				 		}			 		

						$array['dtju_msap_no'] = $acc['mssa_msap_no'];
						$array['dtju_debet'] = 0;
						// $array['dtju_kredit'] = $nett_po - ($bftax + $tax);
						$array['dtju_kredit'] = $nett_po - ($hpp + $tax);
						array_push($data['jurnal_d'], $array);
			 		//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^				
				}			
				$this->data['jurnal_d'] = $data['jurnal_d'];
			}
			$this->data['jurnal_h'] = $data['jurnal_h'];
		}

		if($data['action'] == 'CANCEL_EXIT_GOODS'){
			$this->data['jurnal_h']['trju_no'] = $this->input->post('trju_no');
		}
	}

	private function cek_valid_data_jurnal($data){				
		$msg = '';
		$hsl = true;

		// cek setting account harus diisi
		if($hsl){
			if(!$this->m_setting_account->get_setting_account_byid('PRCI') ||
				!$this->m_setting_account->get_setting_account_byid('PRCL') ||
				!$this->m_setting_account->get_setting_account_byid('PRVI') ||
				!$this->m_setting_account->get_setting_account_byid('PRVL') ||
				!$this->m_setting_account->get_setting_account_byid('PRSI') ||
				!$this->m_setting_account->get_setting_account_byid('PRSL') ||
				!$this->m_setting_account->get_setting_account_byid('PPNM')){
					$hsl = false;				
					$msg = 'There is an account that has not been set';				
			}		
		}	

		// cek akun perkiraan di master kategori harus diisi
		if($hsl){
			if(isset($data['detail'])){
				foreach ($data['detail'] as $key => $value) {
					$mskt_no = substr($data['detail'][$key]['dtpt_mspd_no'], 0, 1);					
					if(!$this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv')){
						$hsl = false;
						$msg = 'There is an account not yet filled in Category Master';
					}								
				}
			}
		}

		return array('valid'=>$hsl, 'msg'=>$msg);
	}

	public function purchase_return_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_retur');

		$data = array();
		$data['per_page'] = 13;
		$data['request_from'] = 'popup';

		$respon = array();
		$respon['popup'] = $this->load->view('purchase/purchase_return/v_purchase_return_popup',$data,true);
		echo json_encode($respon);		
	}

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'trpt_msgd_no',
		                'label' => 'warehouse',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )
		);
		return $config;
	}	

	private function cek_valid_data_trans($menu, $data){
			// keterangan :
			// $menu = NEW | EDIT | VOID

			$msg = '';
			$hsl = true;
			$qty_valid = false;
			$qty_cek = true;
			$tgl_cls_jurnal = $this->m_setting->get_setting('simr_char1','tcj', 1);

			if($menu == 'CONF_EXIT_GOODS' || $menu == 'CANCEL_EXIT_GOODS'){
				if($hsl){
					// transaksi tidak bisa di buat/edit/void jika tgl transaksi/jurnal sudah di closing
					$tgl_trans = $this->input->post('trpt_tglkeluar');				

					$tahun = substr($tgl_trans, 0, 4);
					$bulan = substr($tgl_trans, 5, 2);	
					$tgl_trans = (int)$tahun.$bulan;	

					if($hsl && $tgl_trans <= $tgl_cls_jurnal){
						$hsl = false;
						$msg = 'Can not create new/edit/void transaction if journal transaction date is closed. Please choose another date.';
					}
				}
			}

			if($menu == 'CANCEL_EXIT_GOODS'){				
				// Transaksi yang sudah di rekonsiliasi tidak bisa di edit/void/cancel
				if($hsl && $this->m_app->is_recon_exists($data['header']['trpt_no'].'PR')){
					$hsl = false;
					$msg = 'Transactions cannot be changed. Journal already in reconciliation';
				}
			}

			// cek gudang harus diisi
			if($hsl){
				if($this->input->post('trpt_tglkeluar') != '0000-00-00' && $this->input->post('trpt_msgd_no') == ''){
					$hsl = false;					
					$msg = 'Please select warehouse';
				}
			}

			// cek dtpt_qtyretur tidak boleh > stok			
			if($hsl){					
				if(isset($data['detail'])){
					foreach ($data['detail'] as $key => $value){
						$qtyupdate = ftodouble($data['detail'][$key]['dtpt_qtyretur']);
						$stok = $this->m_stok->get_stok($data['detail'][$key]['dtpt_mspd_no'],$data['header']['trpt_msgd_no']);

						if($menu == 'CONF_EXIT_GOODS'){
							if($this->session->userdata('svlogin') != 'F'){
								if($qtyupdate > $stok){
									$hsl = false;
									$msg = 'Insufficient stock. Stock cannot be minus.';
									break;
								}
							}
						}

						if($qty_cek){
							if ($qtyupdate > 0){
								$qty_cek = false;
								$qty_valid = true;																
							}														
						}				
					}
				}
			}

			// cek qty retur harus di isi (minimal satu produk)
			if($hsl){
				if ($qty_valid == false){
					$hsl = false;
					$msg = 'Please input qty return.';
				}																		
			}
			
			// utk pengecekan cekint
			// Valid = CekInt tidak berubah			
			if ($hsl && $menu == 'NEW') {
				if($this->m_purchase_order->get_purchase_order_cekint(substr($data['header']['trpt_no'], 0, 12), $data['trpo_cekint']) == false){
					$hsl = false;
					$msg = 'Data have been changed by another user. Please Refresh the page';
				}else{
					$this->m_purchase_order->set_purchase_order_cekint(substr($data['header']['trpt_no'], 0, 12));
				}				
			}			

			if ($hsl && $menu != 'NEW') {
				if($this->m_purchase_return->get_purchase_return_cekint($data['header']['trpt_no'], $data['trpt_cekint']) == false){
					$hsl = false;
					$msg = 'Data have been changed by another user. Please Refresh the page';
				}else{
					$this->m_purchase_return->set_purchase_return_cekint($data['header']['trpt_no']);
				}
			}							

			return array('valid'=>$hsl, 'msg'=>$msg);
	}
}	