<?php 
defined('BASEPATH') OR exit('No direct script access allowed');


class reporting extends MY_Controller{

	function __construct(){
		parent::__construct();
		$this->load->model('reporting/m_reporting');
		$this->load->model('setting/m_setting');
		$this->load->model('stok_kontrol/m_inventory');
		$this->load->model('data_master/m_cabang');	
		$this->load->model('setting/m_setting_efaktur');	
		$this->load->library('jasper');
		$this->load->library('java_bridge');
		$this->load->library('Excel');
		PHPExcel_Cell::setValueBinder(new PHPExcel_Cell_AdvancedValueBinder());
	}

	public function index(){
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		} 
		// var_dump($data); die();
		$this->load->view('reporting/v_reporting', $data);
		$this->load->view('v_footer');			
	}

	public function lp_so(){
		if(fcek_hak_akses('.HA1.')) {
			//cek status akses area
			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

			$data['judul_laporan'] = $this->input->get('judul_laporan');
			$data['lp_trso_tgl'] = $this->input->get('lp_trso_tgl');
			$data['lp_trso_tgl_dari'] = $this->input->get('lp_trso_tgl_dari');
			$data['lp_trso_tgl_sampai'] = $this->input->get('lp_trso_tgl_sampai');		
			$data['lp_trso_tglestkirim_dari'] = $this->input->get('lp_trso_tglestkirim_dari');
			$data['lp_trso_tglestkirim_sampai'] = $this->input->get('lp_trso_tglestkirim_sampai');
			$data['lp_mskt'] = $this->input->get('lp_mskt');
			$data['lp_mskt_no'] = substr($this->input->get('lp_mskt_no'),0,1);				
			$data['lp_msfm'] = $this->input->get('lp_msfm');
			$data['lp_msfm_no'] = $this->input->get('lp_msfm_no');		
			$data['lp_msmd'] = $this->input->get('lp_msmd');
			$data['lp_msmd_no'] = $this->input->get('lp_msmd_no');		
			$data['lp_mscs'] = $this->input->get('lp_mscs');		
			$data['lp_mscs_no'] = substr($this->input->get('lp_mscs_no'), 0, 6);
			$data['lp_mscs_nm'] = substr($this->input->get('lp_mscs_no'), 9);		
			$data['lp_mssl'] = $this->input->get('lp_mssl');
			$data['mssl_no'] = explode(":", $this->input->get('lp_mssl_no'));
			$data['lp_mssl_no'] = trim($data['mssl_no'][0]);
			$data['lp_pbystatus'] = $this->input->get('lp_sopbystatus');
			$data['lp_sodlvstatus'] = $this->input->get('lp_sodlvstatus');
			$data['lp_topstatus'] = $this->input->get('lp_topstatus');
			$data['lp_mspd'] = $this->input->get('lp_mspd');
			$data['lp_mspd_no_sel'] = substr($this->input->get('lp_mspd_no_sel'), 0, 9);
			$data['lp_mspd_no_con'] = $this->input->get('lp_mspd_no_con');
			$data['lp_mspd_nm_con'] = $this->input->get('lp_mspd_nm_con');
			$data['lp_wip_so'] = $this->input->get('lp_wip_so');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
			$detail = "";
			
			$path = APPPATH.'reports\so_reports';

			if($data['judul_laporan'] == 'lp_so_list'){			
				$path .= '\lp_so_list_detail.jrxml';
				$detail ="N";
				}

			if($data['judul_laporan'] == 'lp_so_list_withdetail'){
				$path .= '\lp_so_list_detail.jrxml';
				$detail ="Y";		
				}
			
			if($data['judul_laporan'] == 'lp_wip_so'){
				$path .= '\lp_wip_so.jrxml';			
			}

			$result = $this->m_reporting->get_lp_sales_query($data);
			

			// Update query string yang ada di xml file
			$xml = new DOMDocument();
			$xml->load($path);
			$nodes = $xml->getElementsByTagName('queryString') ;				
			$xml->getElementsByTagName("queryString")->item(0)->nodeValue = "";
			$xml->getElementsByTagName("queryString")->item(0)->appendChild($xml->createCDATASection($result['query']));		   		   
			$xml->save($path);

			// Set parameter yang akan di kirim ke file xml
			$params = new Java("java.util.HashMap");							
			$params->put("detail", new Java('java.lang.String', $detail));
			$params->put("vtrso_tgldari", new Java('java.lang.String', $result['param']['vtrso_tgldari']));
			$params->put("vtrso_tglsampai", new Java('java.lang.String', $result['param']['vtrso_tglsampai']));
			$params->put("vtrso_mscs_no", new Java('java.lang.String', $result['param']['vtrso_mscs_no']));
			$params->put("vtrso_mscs_nm", new Java('java.lang.String', $result['param']['vtrso_mscs_nm']));
			$params->put("vtrso_mssl_no", new Java('java.lang.String', $result['param']['vtrso_mssl_no']));
			$params->put("vtrso_mssl_nm", new Java('java.lang.String', $result['param']['vtrso_mssl_nm']));
			$params->put("vtrso_tglestkirimdari", new Java('java.lang.String', $result['param']['vtrso_tglestkirimdari']));
			$params->put("vtrso_tglestkirimsampai", new Java('java.lang.String', $result['param']['vtrso_tglestkirimsampai']));
			$params->put("top_status", new Java('java.lang.String', $result['param']['top_status']));
			$params->put("sodlv_status", new Java('java.lang.String', $result['param']['lp_sodlvstatus']));
			
			// print out report di browser
			$this->java_bridge->print_data($path, $params);	
		}
	}

	public function lp_so_excel(){
		if(fcek_hak_akses('.HA1.')) {
			//cek status akses area
			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

			$data['judul_laporan'] = $this->input->get('judul_laporan');
			$data['lp_trso_tgl'] = $this->input->get('lp_trso_tgl');
			$data['lp_trso_tgl_dari'] = $this->input->get('lp_trso_tgl_dari');
			$data['lp_trso_tgl_sampai'] = $this->input->get('lp_trso_tgl_sampai');		
			$data['lp_trso_tglestkirim_dari'] = $this->input->get('lp_trso_tglestkirim_dari');
			$data['lp_trso_tglestkirim_sampai'] = $this->input->get('lp_trso_tglestkirim_sampai');
			$data['lp_mskt'] = $this->input->get('lp_mskt');
			$data['lp_mskt_no'] = substr($this->input->get('lp_mskt_no'),0,1);				
			$data['lp_msfm'] = $this->input->get('lp_msfm');
			$data['lp_msfm_no'] = $this->input->get('lp_msfm_no');		
			$data['lp_msmd'] = $this->input->get('lp_msmd');
			$data['lp_msmd_no'] = $this->input->get('lp_msmd_no');		
			$data['lp_mscs'] = $this->input->get('lp_mscs');		
			$data['lp_mscs_no'] = substr($this->input->get('lp_mscs_no'), 0, 6);
			$data['lp_mscs_nm'] = substr($this->input->get('lp_mscs_no'), 9);		
			$data['lp_mssl'] = $this->input->get('lp_mssl');
			$data['mssl_no'] = explode(":", $this->input->get('lp_mssl_no'));
			$data['lp_mssl_no'] = trim($data['mssl_no'][0]);
			$data['lp_pbystatus'] = $this->input->get('lp_sopbystatus');
			$data['lp_sodlvstatus'] = $this->input->get('lp_sodlvstatus');
			$data['lp_topstatus'] = $this->input->get('lp_topstatus');
			$data['lp_mspd'] = $this->input->get('lp_mspd');
			$data['lp_mspd_no_sel'] = substr($this->input->get('lp_mspd_no_sel'), 0, 9);
			$data['lp_mspd_no_con'] = $this->input->get('lp_mspd_no_con');
			$data['lp_mspd_nm_con'] = $this->input->get('lp_mspd_nm_con');
			$data['lp_wip_so'] = $this->input->get('lp_wip_so');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
			

			$result = $this->m_reporting->get_lp_sales_query($data);
			$judullaporan = $data['judul_laporan'];
			
			$object = new PHPExcel();
			$object->setActiveSheetIndex(0);
			$styleArray = array(
	   					'font'  => array(
	        			'bold' => true,
	        			'size'  => 14,
	        			'name' => 'Verdana'
	    				));

			$column = 0;
			$row = 0;
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "SO LIST REPORT")
			->getStyle()->applyFromArray($styleArray);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Tgl SO : ".$result['param']['vtrso_tgldari']." - ".$result['param']['vtrso_tglsampai']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Tgl Estimasi Kirim : ".$result['param']['vtrso_tglestkirimdari']." - ".$result['param']['vtrso_tglestkirimsampai']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Sales : ".$result['param']['vtrso_mssl_no']." - ".$result['param']['vtrso_mssl_nm']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Customer : ".$result['param']['vtrso_mscs_no']." - ".$result['param']['vtrso_mscs_nm']);
			
			$row+=2;
			$table_colums = array('TANGGAL', 'NO SO', 'KODE CUSTOMER', 'NAMA CUSTOMER', 'PO CUSTOMER',  'KODE SALES', 'NAMA SALES', 'CATATAN',
								 'TOTAL', 'TERBAYAR', 'LUNAS',	'SD', 'PRODUK ID', 'NAMA PRODUK', 'QTY SO', 'QTY KIRIM', 'QTY SD', 'QTY BELUM TERKIRIM',
								);		
			
			if ($judullaporan == 'lp_so_list_excel_admin') {
				array_push($table_colums,"PRICELIST", "BEFORE TAX");
			}

			array_push($table_colums,'HARGA SATUAN', 'TOTAL');

			if ($judullaporan == 'lp_so_list_excel_admin') {
				array_push($table_colums,"DISKON %");
			}
							
			foreach ($table_colums as $field) {
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
				$column += 1;
			}

			// Jika laporan ini diakses dari admin report
			// ---------------------------------------------------
			$printallcol = false;

			if ($judullaporan == 'lp_so_list_excel_admin') {
				$printallcol = true;
			}
			// ---------------------------------------------------
		
			$data = $this->db->query($result['query']);
			$data = $data->result_array();		
			
			$row += 1;
			$no_prev="";

			foreach ($data as $key => $value) {	
				if($value['trso_terbayar'] >= $value['trso_total']){
					$settled ="Y";
				} else $settled ="N";

				if($value['totalblmsd'] > 0 ){
					$complete_sd = "N";
				} else $complete_sd = "Y";

				$col = 0;

				//print header tr_so
				if($no_prev != $value['dtso_no'] || $printallcol){	
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trso_tgl']); $col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['dtso_no']); $col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['mscs_no']); $col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['mscs_nm']); $col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trso_pocust']); $col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['mssl_no']); $col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['mssl_nm']); $col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trso_catatan']); $col++;
					// $object->getActiveSheet()->getStyle("H")->getNumberFormat()->setFormatCode('#,##0,00'); 
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trso_total']); $col++;
					// $object->getActiveSheet()->getStyle("I")->getNumberFormat()->setFormatCode('#,##0,00'); 
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trso_terbayar']); $col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $settled); $col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $complete_sd); $col++;
					$no_prev = $value['dtso_no'];
				} else {
					$col = 12;
				}

				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['dtso_mspd_no']); $col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['mspd_nm']); $col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['dtso_qty']); $col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['dtso_qtykirim']); $col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['dtso_qtysd']); $col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['dtso_qty']-$value['dtso_qtykirim']); $col++;
				// $object->getActiveSheet()->getStyle("R")->getNumberFormat()->setFormatCode('#,##0,00');
				
				if ($judullaporan == 'lp_so_list_excel_admin') {
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['dtso_pricelist']); $col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['dtso_bftax']); $col++;
				}
				
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['dtso_nett']); $col++;
				// $object->getActiveSheet()->getStyle("S")->getNumberFormat()->setFormatCode('#,##0,00');
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['dtso_nett']*$value['dtso_qty']); $col++;
				
				if ($judullaporan == 'lp_so_list_excel_admin') {
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, ($value['dtso_pricelist'] == 0) ? 0 : (($value['dtso_pricelist'] - $value['dtso_nett']) / $value['dtso_pricelist']) * 100); $col++;
				}
				
				$row += 1;
			}
	      
	        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
	        //if you want to save it as .xls Excel 2007 format
	        $filename='SO LIST.xls'; //save our workbook as this file name
	        // ob_end_clean();
	        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
	        header('Content-Type: application/vnd.ms-excel'); //mime type
	        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	        header('Cache-Control: max-age=0'); //no cache 
	        //force user to download the Excel file without writing it to server's HD
	        $objWriter->save('php://output');
		}
	}

	public function lp_so_top_dlv(){
		if(fcek_hak_akses('.HA7.')) {
			//cek status akses area
			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

			// delete tmp table by rand
			if($this->session->userdata('rand')){
				$this->m_reporting->delete_datatemp_bayrand_tstd($this->session->userdata('rand'));
				unset($_SESSION['rand']);
			}

			$this->session->set_userdata('rand',rand());
			$data['tstd_idlap'] = $this->session->userdata('rand');
			$data['judul_laporan'] = $this->input->get('judul_laporan');
			$data['lp_trso_tgl'] = $this->input->get('lp_trso_tgl');
			$data['lp_trso_tgl_dari'] = trim($this->input->get('lp_trso_tgl_dari'));
			$data['lp_trso_tgl_sampai'] = trim($this->input->get('lp_trso_tgl_sampai'));		
			$data['lp_trso_tglestkirim_dari'] =trim($this->input->get('lp_trso_tglestkirim_dari'));
			$data['lp_trso_tglestkirim_sampai'] = trim($this->input->get('lp_trso_tglestkirim_sampai'));
			$data['lp_mscs'] = $this->input->get('lp_mscs');		
			$data['lp_mscs_no'] = substr($this->input->get('lp_mscs_no'), 0, 6);
			$data['lp_mscs_nm'] = substr($this->input->get('lp_mscs_no'), 9);		
			$data['lp_mssl'] = $this->input->get('lp_mssl');
			$data['mssl_no'] = explode(":", $this->input->get('lp_mssl_no'));
			$data['lp_mssl_no'] = trim($data['mssl_no'][0]);
			$data['lp_pbystatus'] = $this->input->get('lp_sopbystatus');
			$data['lp_sodlvstatus'] = $this->input->get('lp_sodlvstatus');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
			
			$result = $this->m_reporting->get_tmp_so_top_dlv($data);
			// echo "<pre>"; print_r($result['query']); die();
			
			$path = APPPATH.'reports\finance_reports\lp_so_top_dlv.jrxml';

			// Update query string yang ada di xml file
			$xml = new DOMDocument();
			$xml->load($path);
			$nodes = $xml->getElementsByTagName('queryString') ;				
			$xml->getElementsByTagName("queryString")->item(0)->nodeValue = "";
			$xml->getElementsByTagName("queryString")->item(0)->appendChild($xml->createCDATASection($result['query']));		   		   
			$xml->save($path);

			// Set parameter yang akan di kirim ke file xml
			$params = new Java("java.util.HashMap");							
			$params->put("tgl_dari", new Java('java.lang.String', $result['param']['tgl_dari']));
			$params->put("tgl_sampai", new Java('java.lang.String', $result['param']['tgl_sampai']));
			$params->put("sodlv_status", new Java('java.lang.String', $result['param']['lp_sodlvstatus']));
			$params->put("paymentstatus", new Java('java.lang.String', $result['param']['lp_pbystatus']));
			$params->put("mscs_no", new Java('java.lang.String', $result['param']['mscs_no']));
			$params->put("mscs_nm", new Java('java.lang.String', $result['param']['mscs_nm']));
			$params->put("cabang", new Java('java.lang.String', $data['mscb_listmscb']));
			$params->put("fin", new Java('java.lang.String', $data['lp_trju_fin']));
			$params->put("mssl_no", new Java('java.lang.String', $result['param']['mssl_no']));
			$params->put("mssl_nm", new Java('java.lang.String', $result['param']['mssl_nm']));
			
			// print out report di browser
			$this->java_bridge->print_data($path, $params);	
			
			// delete tmp table by rand
	        if($this->session->userdata('rand')){
				$this->m_reporting->delete_datatemp_bayrand_tstd($this->session->userdata('rand'));
				unset($_SESSION['rand']);
			}

		}
	}

	public function lp_so_top_dlv_excel(){		
		if(fcek_hak_akses('.HA7.')) {
			//cek status akses area
			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

			// delete tmp table by rand
			if($this->session->userdata('rand')){
				$this->m_reporting->delete_datatemp_bayrand_tstd($this->session->userdata('rand'));
				unset($_SESSION['rand']);
			}

			$this->session->set_userdata('rand',rand());
			$data['tstd_idlap'] = $this->session->userdata('rand');
			$data['judul_laporan'] = $this->input->get('judul_laporan');
			$data['lp_trso_tgl'] = $this->input->get('lp_trso_tgl');
			$data['lp_trso_tgl_dari'] = $this->input->get('lp_trso_tgl_dari');
			$data['lp_trso_tgl_sampai'] = $this->input->get('lp_trso_tgl_sampai');		
			$data['lp_trso_tglestkirim_dari'] = $this->input->get('lp_trso_tglestkirim_dari');
			$data['lp_trso_tglestkirim_sampai'] = $this->input->get('lp_trso_tglestkirim_sampai');
			$data['lp_mscs'] = $this->input->get('lp_mscs');		
			$data['lp_mscs_no'] = substr($this->input->get('lp_mscs_no'), 0, 6);
			$data['lp_mscs_nm'] = substr($this->input->get('lp_mscs_no'), 9);		
			$data['lp_mssl'] = $this->input->get('lp_mssl');
			$data['mssl_no'] = explode(":", $this->input->get('lp_mssl_no'));
			$data['lp_mssl_no'] = trim($data['mssl_no'][0]);
			$data['lp_pbystatus'] = $this->input->get('lp_sopbystatus');
			$data['lp_sodlvstatus'] = $this->input->get('lp_sodlvstatus');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
			
			// echo "<pre>"; print_r($data); die();

			$result = $this->m_reporting->get_tmp_so_top_dlv($data);
			
			
			$object = new PHPExcel();
			$object->setActiveSheetIndex(0);
			$styleArray = array(
	   					'font'  => array(
	        			'bold' => true,
	        			'size'  => 14,
	        			'name' => 'Verdana'
	    				));

			$column = 0;
			$row = 0;
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "SO : TOP-DELIVERY-PAYMENT")
			->getStyle()->applyFromArray($styleArray);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Tgl SO : ".$result['param']['tgl_dari']." - ".$result['param']['tgl_sampai']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Customer : ".$result['param']['mscs_no']." - ".$result['param']['mscs_nm']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Payment Status : ".$result['param']['lp_pbystatus']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Sales : ".$result['param']['mssl_no']." - ".$result['param']['mssl_nm']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Delivery Status : ".$result['param']['lp_sodlvstatus']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Cabang : ".$data['mscb_listmscb']);
			

			$row+=2;
			$table_colums = array('TANGGAL', 'NO SO', 'KODE CUSTOMER', 'NAMA CUSTOMER', 'KODE SALES', 'NAMA SALES', 'CATATAN',
								 'TOTAL', 'TERBAYAR', '[TOP]TGL JATUH TEMPO', '[TOP]TOTAL', '[TOP]CATATAN','[TOP]STATUS',
								 '[DLV]TGL BUAT', '[DLV]TGL DLV', '[DLV]TGL CONFIRM', '[DLV]STATUS', '[DLV]CATATAN','[DLV]TOTAL', '[DLV]TERBAYAR', '[DLV]SISA BAYAR',
								 '[PBY]TGL PBY', '[PBY]TGL CAIR', '[PBY]JUMLAH BAYAR','[PBY]TUJUAN PEMBAYARAN','[PBY]NO SO/FAKTUR',
								 '[PBY]JENIS PEMBAYARAN','[PBY]CATATAN');		
			foreach ($table_colums as $field) {
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
				$column += 1;
			}

			// get data
			$data = $this->db->query($result['query']);
			$data = $data->result_array();		
			

			$row += 1;

			$no_prev="";
			foreach ($data as $key => $value) {	
			//print header tr_so
			if($no_prev != $value['trso_no']){	
				$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['trso_tgl']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['trso_no']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['trso_mscs_no']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['mscs_nm']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $value['trso_mssl_no']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['mssl_nm']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $value['trso_catatan']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $value['trso_total']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $value['trso_terbayar']);
				$no_prev = $value['trso_no'];
			}
				$object->getActiveSheet()->setCellValueByColumnAndRow(9, $row, $value['tstd_ref_t_tgljatuhtempo']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(10, $row, $value['tstd_ref_t_value']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(11, $row, $value['tstd_ref_t_cttn']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(12, $row, $value['tstd_ref_t_status']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(13, $row, $value['tstd_ref_d_tgl']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(14, $row, $value['tstd_ref_d_tglkirim']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(15, $row, $value['tstd_ref_d_tglbalik']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(16, $row, $value['tstd_ref_d_status']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(17, $row, $value['tstd_ref_d_catatan']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(18, $row, $value['tstd_ref_d_total']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(19, $row, $value['tstd_ref_d_terbayar']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(20, $row, $value['tstd_ref_d_total']-$value['tstd_ref_d_terbayar']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(21, $row, $value['tstd_ref_p_tgl']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(22, $row, $value['tstd_ref_p_tglcair']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(23, $row, $value['tstd_ref_p_jlhbayar']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(24, $row, $value['tstd_ref_p_payfor']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(25, $row, $value['tstd_ref_p_refno']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(26, $row, $value['tstd_ref_p_paidfrom']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(27, $row, $value['tstd_ref_p_catatan']);
				$row += 1;
			}
	      
	        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
	        //if you want to save it as .xls Excel 2007 format
	        // ob_end_clean();
	        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
	        $filename='SO TOP DLV PBY.xls'; //save our workbook as this file name
	        header('Content-Type: application/vnd.ms-excel'); //mime type
	        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	        header('Cache-Control: max-age=0'); //no cache 
	        //force user to download the Excel file without writing it to server's HD
	        $objWriter->save('php://output');

	        // delete tmp table by rand
	        if($this->session->userdata('rand')){
				$this->m_reporting->delete_datatemp_bayrand_tstd($this->session->userdata('rand'));
				unset($_SESSION['rand']);
			}

		}
	}

	public function lp_penj_bersih(){
	if(fcek_hak_akses('.HA8.')) {
		if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}


		if($this->session->userdata('rand')){
			$this->m_reporting->delete_datatemp_bayrand_tsdh($this->session->userdata('rand'));
			unset($_SESSION['rand']);
		}

			$this->session->set_userdata('rand',rand());
			$data['tsdh_idlap'] = $this->session->userdata('rand');
			$data['lp_trsd_tgl'] = $this->input->get('lp_trsd_tgl');
			$data['lp_trsd_tgl_dari'] = trim($this->input->get('lp_trsd_tgl_dari'));
			$data['lp_trsd_tgl_sampai'] = trim($this->input->get('lp_trsd_tgl_sampai'));		
			$data['lp_trsd_tglkirim_dari'] = trim($this->input->get('lp_trsd_tglkirim_dari'));
			$data['lp_trsd_tglkirim_sampai'] = trim($this->input->get('lp_trsd_tglkirim_sampai'));	
			$data['lp_trsd_tglconf_dari'] = trim($this->input->get('lp_trsd_tglconfirm_dari'));	
			$data['lp_trsd_tglconf_sampai'] = trim($this->input->get('lp_trsd_tglconfirm_sampai'));		
			$data['lp_mskt'] = $this->input->get('lp_mskt');
			$data['lp_mskt_no'] = substr($this->input->get('lp_mskt_no'), 0, 1);
			$data['lp_mskt_nm'] = substr($this->input->get('lp_mskt_no'), 4);
			$data['lp_msfm'] = $this->input->get('lp_msfm');
			$data['lp_msfm_no'] = substr($this->input->get('lp_msfm_no'), 0,3);
			$data['lp_msfm_nm'] = substr($this->input->get('lp_msfm_no'), 6);
			$data['lp_msmd'] = $this->input->get('lp_msmd');
			$data['lp_msmd_no'] = substr($this->input->get('lp_msmd_no'), 0,6);
			$data['lp_msmd_nm'] = substr($this->input->get('lp_msmd_no'), 9);
			$data['lp_mspd'] = $this->input->get('lp_mspd');
			$data['lp_mspd_no_sel'] = substr($this->input->get('lp_mspd_no_sel'), 0, 9);
			$data['lp_mspd_nm'] = substr($this->input->get('lp_mspd_no_sel'), 12);	
			$data['lp_mspd_nm_con'] = $this->input->get('lp_mspd_nm_con');
			$data['lp_mscs'] = $this->input->get('lp_mscs');		
			$data['lp_mscs_no'] = substr($this->input->get('lp_mscs_no'), 0, 6);
			$data['lp_mscs_nm'] = substr($this->input->get('lp_mscs_no'), 9);		
			$data['lp_mssl'] = $this->input->get('lp_mssl');
			$data['lp_mssl_no'] = explode(":", $this->input->get('lp_mssl_no'));
			$data['mssl_no'] = trim($data['lp_mssl_no'][0]);
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
			$data['sumberdata'] = $this->input->get('lp_sumberdata_penj');
			$data['lp_sd_dlv_status'] = $this->input->get('lp_sd_dlv_status');
			$data['lp_sd_conf_status'] = $this->input->get('lp_sd_confirm_status');


		$result = $this->m_reporting->lap_tmp_sales_dlv_hpp($data);

		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);
		$styleArray = array(
   					'font'  => array(
        			'bold' => true,
        			'size'  => 14,
        			'name' => 'Verdana'
    				));

		$column = 0;
		$row = 0;
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "RINCIAN PENJUALAN BERSIH DAN RETUR BARANG PER PELANGGAN")
		->getStyle()->applyFromArray($styleArray);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Periode  ".$result['param']['periode']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Kategori : ".$result['param']['mskt_no']." - ".$result['param']['mskt_nm']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Customer : ".$result['param']['mscs_no']." - ".$result['param']['mscs_nm']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Famili : ".$result['param']['msfm_no']." - ".$result['param']['msfm_nm']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Sales : ".$result['param']['mssl_no']." - ".$result['param']['mssl_nm']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Model : ".$result['param']['msmd_no']." - ".$result['param']['msmd_nm']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Produk : ".$result['param']['mspd_no']." - ".$result['param']['mspd_nm']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Cabang : ".$data['mscb_listmscb']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Data Fin : ".$result['param']['trju_fin']);
		
		$row+=2;
		$table_colums = array('ID PRODUK', 'NAMA PRODUK', 'KODE CUSTOMER', 'NAMA CUSTOMER', 'JENIS TRANSAKSI', 'NO SALES DELIVERY/RETUR', 'TGL SALES DELIVERY/RETUR',
							 'KODE SALES', 'NAMA SALES', 'QTY',	'NILAI PENJUALAN SEBELUM PAJAK', 'HPP', 'TOTAL PENJUALAN SEBELUM PAJAK', 'TOTAL HPP', 'LABA KOTOR');		
		foreach ($table_colums as $field) {
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
			$column += 1;
		}
	
		$data = $this->db->query($result['query']);
		$data = $data->result_array();
		
		$row += 1;
		
		foreach ($data as $key => $value) {			
			$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['tsdh_mspd_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['mspd_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['tsdh_mscs_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['mscs_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $value['tsdh_jnstran']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['tsdh_notran']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $value['tsdh_tgltran']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $value['tsdh_mssl_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $value['mssl_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(9, $row, $value['tsdh_qty']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(10, $row, $value['tsdh_bftax']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(11, $row, $value['tsdh_hpp']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(12, $row, ($value['tsdh_bftax']*$value['tsdh_qty']));
			$object->getActiveSheet()->setCellValueByColumnAndRow(13, $row, ($value['tsdh_hpp']*$value['tsdh_qty']));
			$object->getActiveSheet()->setCellValueByColumnAndRow(14, $row, ($value['tsdh_bftax']-$value['tsdh_hpp']));
			$row += 1;
		}
      
        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
        //if you want to save it as .xls Excel 2007 format
        // ob_end_clean();
        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
        $filename='Penjualan Bersih.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache 
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');

        // delete data tsdh
        if($this->session->userdata('rand')){
			$this->m_reporting->delete_datatemp_bayrand_tsdh($this->session->userdata('rand'));
			unset($_SESSION['rand']);
			}
		}
	}

	public function lp_faktur_penj(){
	if(fcek_hak_akses('.HA1.')) {
		if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			$data['judul_laporan'] = $this->input->get('judul_laporan');
			$data['lp_trsd_tgl'] = trim($this->input->get('lp_trsd_tgl'));
			$data['lp_trsd_tgl_dari'] = trim($this->input->get('lp_trsd_tgl_dari'));
			$data['lp_trsd_tgl_sampai'] = trim($this->input->get('lp_trsd_tgl_sampai'));		
			$data['lp_trsd_tglkirim_dari'] = trim($this->input->get('lp_trsd_tglkirim_dari'));
			$data['lp_trsd_tglkirim_sampai'] = trim($this->input->get('lp_trsd_tglkirim_sampai'));	
			$data['lp_trsd_tglconf_dari'] = trim($this->input->get('lp_trsd_tglconfirm_dari'));	
			$data['lp_trsd_tglconf_sampai'] = trim($this->input->get('lp_trsd_tglconfirm_sampai'));		
			$data['lp_mscs'] = $this->input->get('lp_mscs');		
			$data['lp_mscs_no'] = substr($this->input->get('lp_mscs_no'), 0, 6);
			$data['lp_mscs_nm'] = substr($this->input->get('lp_mscs_no'), 9);		
			$data['lp_mssl'] = $this->input->get('lp_mssl');
			$mssl_no = explode(":", $this->input->get('lp_mssl_no'));
			$data['lp_mssl_no'] = trim($mssl_no[0]);
			$data['lp_sd_dlv_status'] = $this->input->get('lp_sd_dlv_status');
			$data['lp_sd_conf_status'] = $this->input->get('lp_sd_confirm_status');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
			$data['lp_msgd'] = $this->input->get('lp_msgd');
			$data['lp_msgd_no'] = $this->input->get('lp_msgd_no');
			 
		//result query dari model
		$result = $this->m_reporting->get_lp_faktur_penj($data);
		
		
		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);

		$styleArray = array(
   					'font'  => array(
        			'bold' => true,
        			'size'  => 14,
        			'name' => 'Verdana'
    				));

		$column = 0;
		$row = 0;
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "RINGKASAN FAKTUR PENJUALAN DAN RETUR")
		->getStyle()->applyFromArray($styleArray);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Search By  ".$result['param']['periode']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Cabang : ".$data['mscb_listmscb']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Customer : ".$result['param']['mscs']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Delivery Status : ".$result['param']['dlv_status']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Sales : ".$result['param']['mssl']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Confirm Dlv Status : ".$result['param']['conf_status']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Data Fin : ".$result['param']['trju_fin']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Gudang : ".$result['param']['msgd_no']);
		
		$row+=2;
		$table_colums = array('Sales Delivery No', 'Created Date', 'Delivery Date', 'Confirm Date', 'PO Customer No', 
							'Customer ID', 'Customer Name', 'Customer Type','Faktur Date', 'No. Faktur', 'Faktur Amount', 'Total DPP', 'Paid', 
							'Retur Total', 'Retur DPP', 'Sales', 'Delivery Notes');		
		foreach ($table_colums as $field) {
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
			$column += 1;
		}

		$data = $this->db->query($result['query']);
		$data = $data->result_array();

		$row += 1; 
		foreach ($data as $key => $value) {	
			if($value['trsd_tglkirim'] == "0000-00-00"){
				$value['trsd_tglkirim'] ="";
			}else 
				$value['trsd_tglkirim'] = $value['trsd_tglkirim'];

			if($value['trsd_tglbalik'] == "0000-00-00"){
				$value['trsd_tglbalik'] ="";
			}else
				$value['trsd_tglbalik'] = $value['trsd_tglbalik'];


			$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['trsd_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['trsd_tgl']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['trsd_tglkirim']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['trsd_tglbalik']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $value['trso_pocust']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['trsd_mscs_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $value['mscs_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $value['mscs_jenis']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $value['trsd_fakturtgl']);
			$object->getActiveSheet()->setCellValueExplicitByColumnAndRow(9, $row, $value['trsd_fakturno']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(10, $row, $value['trsd_total']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(11, $row, $value['dpp']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(12, $row, $value['trsd_terbayar']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(13, $row, $value['trsr_total']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(14, $row, $value['retur_dpp']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(15, $row, $value['mssl_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(16, $row, $value['trsd_catatan']);
			$row += 1;
		}
      
        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
        //if you want to save it as .xls Excel 2007 format
        // ob_end_clean();
        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
        $filename='Faktur.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache 
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');
		}
	}

	public function lp_ringkasan_harga_jual_produk(){
	if(fcek_hak_akses('.HA1.')) {
		if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			$data['judul_laporan'] = $this->input->get('judul_laporan');
			$data['lp_trsd_tgl'] = trim($this->input->get('lp_trsd_tgl'));
			$data['lp_trsd_tgl_dari'] = trim($this->input->get('lp_trsd_tgl_dari'));
			$data['lp_trsd_tgl_sampai'] = trim($this->input->get('lp_trsd_tgl_sampai'));		
			$data['lp_trsd_tglkirim_dari'] = trim($this->input->get('lp_trsd_tglkirim_dari'));
			$data['lp_trsd_tglkirim_sampai'] = trim($this->input->get('lp_trsd_tglkirim_sampai'));	
			$data['lp_trsd_tglconf_dari'] = trim($this->input->get('lp_trsd_tglconfirm_dari'));	
			$data['lp_trsd_tglconf_sampai'] = trim($this->input->get('lp_trsd_tglconfirm_sampai'));		
			$data['lp_mscs'] = $this->input->get('lp_mscs');		
			$data['lp_mscs_no'] = substr($this->input->get('lp_mscs_no'), 0, 6);
			$data['lp_mscs_nm'] = substr($this->input->get('lp_mscs_no'), 9);		
			$data['lp_mssl'] = $this->input->get('lp_mssl');
			$mssl_no = explode(":", $this->input->get('lp_mssl_no'));
			$data['lp_mssl_no'] = trim($mssl_no[0]);
			$data['lp_sd_dlv_status'] = $this->input->get('lp_sd_dlv_status');
			$data['lp_sd_conf_status'] = $this->input->get('lp_sd_confirm_status');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
			$data['lp_msgd'] = $this->input->get('lp_msgd');
			$data['lp_msgd_no'] = $this->input->get('lp_msgd_no');
			 
		//result query dari model
		$result = $this->m_reporting->get_lp_ringkasan_harga_jual_produk($data);
		
		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);

		$styleArray = array(
   					'font'  => array(
        			'bold' => true,
        			'size'  => 14,
        			'name' => 'Verdana'
    				));

		$column = 0;
		$row = 0;
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "RINGKASAN HARGA JUAL PRODUK")
		->getStyle()->applyFromArray($styleArray);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Search By  ".$result['param']['periode']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Cabang : ".$data['mscb_listmscb']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Customer : ".$result['param']['mscs']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Delivery Status : ".$result['param']['dlv_status']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Sales : ".$result['param']['mssl']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Confirm Dlv Status : ".$result['param']['conf_status']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Data Fin : ".$result['param']['trju_fin']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Gudang : ".$result['param']['msgd_no']);
		
		$row+=2;
		$table_colums = array('SALES DELIVERY NO', 'CREATED DATE', 'DELIVERY DATE', 'CONFIRM DATE', 'PO CUSTOMER', 
							'CUST ID', 'CUSTOMER NAME', 'CUSTOMER TYPE', 'PRODUCK ID#', 'PRODUK NAME', 'QTY', 
							'PRICE / UNIT', 'SALES', 'DELIVERY NOTE');		
		foreach ($table_colums as $field) {
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
			$column += 1;
		}

		$data = $this->db->query($result['query']);
		$data = $data->result_array();
		
		$row += 1; 
		foreach ($data as $key => $value) {	
			if($value['trsd_tglkirim'] == "0000-00-00"){
				$value['trsd_tglkirim'] ="";
			}else 
				$value['trsd_tglkirim'] = $value['trsd_tglkirim'];

			if($value['trsd_tglbalik'] == "0000-00-00"){
				$value['trsd_tglbalik'] ="";
			}else
				$value['trsd_tglbalik'] = $value['trsd_tglbalik'];


			$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['dtsd_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['trsd_tgl']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['trsd_tglkirim']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['trsd_tglbalik']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $value['trso_pocust']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['trsd_mscs_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $value['mscs_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $value['mscs_jenis']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $value['dtsd_mspd_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(9, $row, $value['mspd_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(10, $row, $value['qty']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(11, $row, $value['dtsd_bftax']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(12, $row, $value['mssl_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(13, $row, $value['trsd_catatan']);
			$row += 1;
		}
      
        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
        //if you want to save it as .xls Excel 2007 format
        // ob_end_clean();
        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
        $filename='ringkasan harga jual produk.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache 
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');
		}
	}

	public function lp_purchase_return(){
		if(fcek_hak_akses('.HA1.')) {
			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			$data['judul_laporan'] = $this->input->get('judul_laporan');
			$data['lp_trpt_tgl'] = trim($this->input->get('lp_trpt_tgl'));
			$data['lp_trpt_tgl_dari'] = trim($this->input->get('lp_trpt_tgl_dari'));
			$data['lp_trpt_tgl_sampai'] = trim($this->input->get('lp_trpt_tgl_sampai'));		
			$data['lp_trpt_tglEG_dari'] = trim($this->input->get('lp_trpt_tglEG_dari'));
			$data['lp_trpt_tglEG_sampai'] = trim($this->input->get('lp_trpt_tglEG_sampai'));	
			$data['lp_mssp'] = $this->input->get('lp_mssp');		
			$data['lp_mssp_no'] = substr($this->input->get('lp_mssp_no'), 0, 6);
			$data['lp_mssp_nm'] = substr($this->input->get('lp_mssp_no'), 9);		
			$data['lp_trpt_EGstatus'] = $this->input->get('lp_trpt_EGstatus');
			$data['lp_trpt_returtype'] = $this->input->get('lp_trpt_returtype');
			$data['lp_trpt_voucherstatus'] = $this->input->get('lp_trpt_voucherstatus');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_fin'] = $this->input->get('lp_trju_fin');
		
			$query = 'SELECT trpt_no, trpt_tgl, trpt_tglkeluar, trpt_mssp_no, mssp_nm, mssp_jenis, trpt_total,
						ROUND((SELECT SUM(dtpt_bftaxrp * dtpt_qtyretur) FROM dt_purcret WHERE dtpt_no = trpt_no), 4) AS total_dpp,
						IF(trpt_jenis ="V","Voucher","Cashback") as jenis,
						trpt_pbpo_no, trpt_catatan
					FROM tr_purcret
					LEFT JOIN tr_po ON trpo_no = SUBSTRING(trpt_no, 1,12)
					LEFT JOIN ms_supplier ON mssp_no = trpt_mssp_no
					where trpt_void=0 and POSITION(trpt_mscb_no in "'.$data['mscb_listmscb'].'")';


			//filter by tanggal create
			if ($data['lp_trpt_tgl'] == 'lp_trpt_tglsel') {
				$query .= ' and trpt_tgl between "'.$data['lp_trpt_tgl_dari'].'" and "'.$data['lp_trpt_tgl_sampai'].'"';
				$periode = 'Created Date : '.$data['lp_trpt_tgl_dari'].' s/d '.$data['lp_trpt_tgl_sampai'].'';
			}

			//filter by tanggal confirm EG
			if ($data['lp_trpt_tgl'] == 'lp_trpt_tglEG') {
				$query .= ' and trpt_tglkeluar between "'.$data['lp_trpt_tglEG_dari'].'" and "'.$data['lp_trpt_tglEG_sampai'].'"';
				$periode = 'Exit Goods Date : '.$data['lp_trpt_tglEG_dari'].' s/d '.$data['lp_trpt_tglEG_sampai'].'';
			}
			
			//filter by EG status
			$EG_status = '';
			if ($data['lp_trpt_EGstatus'] != 'all'){
				if($data['lp_trpt_EGstatus'] == 1 ){
					$query .= ' and trpt_tglkeluar > 0';
					$EG_status = "Confirmed Exit Goods";
				} else if ($data['lp_trpt_EGstatus'] == 2){
					$query .= ' and trpt_tglkeluar = 0';
					$EG_status = "Unconfirm Exit Goods";
				}
			} else {
				$EG_status ="ALL";
			}
			
			//filter by retur type
			$retur_type = '';
			if ($data['lp_trpt_returtype'] != 'all'){
				if($data['lp_trpt_returtype'] == 1 ){
					$query .= ' and trpt_jenis ="C"';
					$retur_type = "Cashback";
				} else if ($data['lp_trpt_returtype'] == 2){
					$query .= ' and trpt_jenis ="V"';
					$retur_type = "Voucher Retur";
				}
			} else {
				$retur_type ="ALL";
			}

			//filter by voucher status
			$voucher_status = '';
			if ($data['lp_trpt_voucherstatus'] != 'all'){
				if($data['lp_trpt_voucherstatus'] == 1 ){
					$query .= ' and trpt_pbpo_no != ""';
					$voucher_status = "Voucher Settled";
				} else if ($data['lp_trpt_voucherstatus'] == 2){
					$query .= ' and trpt_pbpo_no = ""';
					$voucher_status = "Available Retur Voucher";
				}
			} else {
				$voucher_status ="ALL";
			}

			// filter by mssp (supplier)
			$mssp = '';
			if($data['lp_mssp'] != 'ALL'){
				if ($data['lp_mssp'] == 'lp_mssp_lokal') {
					$mssp ='Lokal';
					$query .= ' and mssp_jenis="L"';
				} else if ($data['lp_mssp'] == 'lp_mssp_import') {
					$mssp ='Import';
					$query .= ' and mssp_jenis="I"';
				} else if ($data['lp_mssp'] == 'lp_mssp_sel'){
					$query .= ' and mssp_no = "'. $data['lp_mssp_no']. '"';
					$mssp = $data['lp_mssp_nm'];
				} else {
					$mssp ='ALL';	
				}
			} else {
				$mssp ='ALL';
			}

			//filter mspd_fin/commercial
			$trju_fin = '';
			if($data['lp_fin'] != 'lp_trju_fin_all'){
				$query .= ' AND trpo_fin = "'.$data['lp_fin'].'"';
				$trju_fin = $data['lp_fin'];
			} else {
				$trju_fin = 'ALL';
			}

			$query .= ' GROUP BY trpt_no';
			$query .= ' ORDER BY trpt_no, trpt_tgl ASC';
			
			$object = new PHPExcel();
			$object->setActiveSheetIndex(0);

			$styleArray = array(
						'font'  => array(
						'bold' => true,
						'size'  => 14,
						'name' => 'Verdana'
						));

			$column = 0;
			$row = 0;
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "PURCHASE RETURN")
			->getStyle()->applyFromArray($styleArray);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Search By  ".$periode);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Cabang : ".$data['mscb_listmscb']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, "Voucher Status : ".$voucher_status);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Supplier : ".$mssp);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Exit Goods Status : ".$EG_status);
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, "Tipe Jurnal : ".$trju_fin);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Retur Type : ".$retur_type);
			
			$row+=2;
			$table_colums = array('RETUR NO', 'CREATED DATE', 'EXIT GOODS DATE', 'SUPPLIER ID', 'SUPPLIER NAME', 'SUPPLIER TYPE', 
				'TOTAL RETUR', 'TOTAL DPP', 'RETUR TYPE', 'VOUCHER USED', 'RETUR NOTES');		
			foreach ($table_colums as $field) {
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
				$column += 1;
			}

			$data = $this->db->query($query);
			$data = $data->result_array();		

			$row += 1;
		
			foreach ($data as $key => $value) {		
				if($value['trpt_tglkeluar'] == "0000-00-00"){
					$value['trpt_tglkeluar'] ="";
				} else {
					$value['trpt_tglkeluar'] = $value['trpt_tglkeluar'];
				}
				
				$col = 0;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trpt_no']); $col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trpt_tgl']); $col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trpt_tglkeluar']); $col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trpt_mssp_no']); $col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['mssp_nm']); $col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['mssp_jenis']); $col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trpt_total']); $col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['total_dpp']); $col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['jenis']); $col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trpt_pbpo_no']); $col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trpt_catatan']); $col++;
				$row += 1;
			}
		
			//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
			//if you want to save it as .xls Excel 2007 format
			// ob_end_clean();
			$objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
			$filename='Purchase Return.xls'; //save our workbook as this file name
			header('Content-Type: application/vnd.ms-excel'); //mime type
			header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
			header('Cache-Control: max-age=0'); //no cache 
			//force user to download the Excel file without writing it to server's HD
			$objWriter->save('php://output');
		}
	}

	public function lp_sales_retur(){
		if(fcek_hak_akses('.HA1.')) {
			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			$data['judul_laporan'] = $this->input->get('judul_laporan');
			$data['lp_trsr_tgl'] = trim($this->input->get('lp_trsr_tgl'));
			$data['lp_trsr_tgl_dari'] = trim($this->input->get('lp_trsr_tgl_dari'));
			$data['lp_trsr_tgl_sampai'] = trim($this->input->get('lp_trsr_tgl_sampai'));		
			$data['lp_trsr_tglRG_dari'] = trim($this->input->get('lp_trsr_tglRG_dari'));
			$data['lp_trsr_tglRG_sampai'] = trim($this->input->get('lp_trsr_tglRG_sampai'));	
			$data['lp_mscs'] = $this->input->get('lp_mscs');		
			$data['lp_mscs_no'] = substr($this->input->get('lp_mscs_no'), 0, 6);
			$data['lp_mscs_nm'] = substr($this->input->get('lp_mscs_no'), 9);		
			$data['lp_mssl'] = $this->input->get('lp_mssl');
			$mssl_no = explode(":", $this->input->get('lp_mssl_no'));
			$data['lp_mssl_no'] = trim($mssl_no[0]);
			$data['lp_trsr_RGstatus'] = $this->input->get('lp_trsr_RGstatus');
			$data['lp_trsr_returtype'] = $this->input->get('lp_trsr_returtype');
			$data['lp_trsr_voucherstatus'] = $this->input->get('lp_trsr_voucherstatus');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_fin'] = $this->input->get('lp_trju_fin');

		
			$query = 'select trsr_no, trsr_tgl, trsr_tglterima, trso_pocust, trsr_mscs_no, mscs_nm, mscs_jenis, trsr_total,
						ROUND((SELECT SUM(dtsr_bftax * dtsr_qtyretur) FROM dt_salesret WHERE dtsr_no = trsr_no),4) AS dpp,
						IF(trsr_jenis ="V","Voucher","Cashback") as jenis,
						trsr_pbso_no, trsr_catatan, mssl_nm 
					FROM tr_salesret
					LEFT JOIN tr_so ON trso_no = SUBSTRING(trsr_no, 1,12)
					LEFT JOIN ms_customer ON mscs_no = trsr_mscs_no
					LEFT JOIN ms_sales on mssl_no = trso_mssl_no
					where trsr_void=0 and POSITION(trsr_mscb_no in "'.$data['mscb_listmscb'].'")';

			//filter by tanggal create
			if ($data['lp_trsr_tgl'] == 'lp_trsr_tglsel') {
				$query .= ' and trsr_tgl between "'.$data['lp_trsr_tgl_dari'].'" and "'.$data['lp_trsr_tgl_sampai'].'"';
				$periode = 'Created Date : '.$data['lp_trsr_tgl_dari'].' s/d '.$data['lp_trsr_tgl_sampai'].'';
			}

			//filter by tanggal confirm RG
			if ($data['lp_trsr_tgl'] == 'lp_trsr_tglRG') {
				$query .= ' and trsr_tglterima between "'.$data['lp_trsr_tglRG_dari'].'" and "'.$data['lp_trsr_tglRG_sampai'].'"';
				$periode = 'Receive Goods Date : '.$data['lp_trsr_tglRG_dari'].' s/d '.$data['lp_trsr_tglRG_sampai'].'';
			}
			
			//filter by RG status
			if ($data['lp_trsr_RGstatus'] != 'all'){
				if($data['lp_trsr_RGstatus'] == 1 ){
					$query .= ' and trsr_tglterima > 0';
					$RG_status = "RG Confirmed";
				} else if ($data['lp_trsr_RGstatus'] == 2){
					$query .= ' and trsr_tglterima = 0';
					$RG_status = "Unconfirm Retur";
				}
			} else {
				$RG_status ="ALL";
			}
			
			//filter by retur type
			if ($data['lp_trsr_returtype'] != 'all'){
				if($data['lp_trsr_returtype'] == 1 ){
					$query .= ' and trsr_jenis ="C"';
					$retur_type = "Cashback";
				} else if ($data['lp_trsr_returtype'] == 2){
					$query .= ' and trsr_jenis ="V"';
					$retur_type = "Voucher Retur";
				}
			} else {
				$retur_type ="ALL";
			}

			//filter by voucher status
			if ($data['lp_trsr_voucherstatus'] != 'all'){
				if($data['lp_trsr_voucherstatus'] == 1 ){
					$query .= ' and trsr_pbso_no != ""';
					$voucher_status = "Voucher Settled";
				} else if ($data['lp_trsr_voucherstatus'] == 2){
					$query .= ' and trsr_pbso_no = ""';
					$voucher_status = "Available Retur Voucher";
				}
			} else {
				$voucher_status ="ALL";
			}

			// filter by mscs (customer)
			if($data['lp_mscs'] != 'lp_mscs_all'){
				if ($data['lp_mscs'] == 'lp_mscs_r') {
					$query .= ' and mscs_jenis="R"';
					$mscs = 'Retail';
				} else if ($data['lp_mscs'] == 'lp_mscs_a') {
					$query .= ' and mscs_jenis="A"';
					$mscs = 'Agen';
				} else if ($data['lp_mscs'] == 'lp_mscs_sel'){
					$query .= ' and mscs_no = "'. $data['lp_mscs_no']. '"';
					$mscs = $data['lp_mscs_nm'];
				} 
			} else {
				$mscs ='ALL';
			}

			// filter by mssl (sales)
			if($data['lp_mssl'] != 'lp_mssl_all'){
				if ($data['lp_mssl'] == 'lp_mssl_sls') {
					$query .= ' and mssl_divisi="S"';
					$mssl = 'Salesman';
				} else if ($data['lp_mssl'] == 'lp_mssl_tkn') {
					$query .= ' and mssl_divisi="T"';
					$mssl = 'Teknisi';
				} else if ($data['lp_mssl'] == 'lp_mssl_sel'){
					$query .= ' and mssl_no = "'. $data['lp_mssl_no']. '"';
					$mssl = $data['lp_mssl_no'];
				} 
			} else {
					$mssl ='ALL';
				}

			//filter mspd_fin/commercial
			if($data['lp_fin'] != 'lp_trju_fin_all'){
				$query .= ' AND trso_fin = "'.$data['lp_fin'].'"';
				$trju_fin = $data['lp_fin'];
			} else {
				$trju_fin = 'ALL';
			}

			$query .= ' ORDER BY trsr_no, trsr_tgl ASC';
			
			$object = new PHPExcel();
			$object->setActiveSheetIndex(0);

			$styleArray = array(
						'font'  => array(
						'bold' => true,
						'size'  => 14,
						'name' => 'Verdana'
						));

			$column = 0;
			$row = 0;
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "SALES RETUR")
			->getStyle()->applyFromArray($styleArray);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Search By  ".$periode);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Cabang : ".$data['mscb_listmscb']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, "Voucher Status : ".$voucher_status);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Customer : ".$mscs);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "RG Status : ".$RG_status);
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, "Tipe Jurnal : ".$trju_fin);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Sales : ".$mssl);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Retur Type : ".$retur_type);
			
			$row+=2;
			$table_colums = array('RETUR NO', 'CREATED DATE', 'RECEIVED GOODS DATE', 'CUSTOMER PO NO', 'CUSTOMER ID', 'CUSTOMER NAME', 'CUSTOMER TYPE', 
				'TOTAL RETUR', 'TOTAL DPP', 'RETUR TYPE', 'VOUCHER USED', 'SALES', 'RETUR NOTES');		
			foreach ($table_colums as $field) {
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
				$column += 1;
			}

			$data = $this->db->query($query);
			$data = $data->result_array();		

			$row += 1;
		
			foreach ($data as $key => $value) {		
				if($value['trsr_tglterima'] == "0000-00-00"){
					$value['trsr_tglterima'] ="";
				} else
					$value['trsr_tglterima'] = $value['trsr_tglterima'];

				$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['trsr_no']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['trsr_tgl']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['trsr_tglterima']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['trso_pocust']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $value['trsr_mscs_no']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['mscs_nm']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $value['mscs_jenis']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $value['trsr_total']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $value['dpp']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(9, $row, $value['jenis']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(10, $row, $value['trsr_pbso_no']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(11, $row, $value['mssl_nm']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(12, $row, $value['trsr_catatan']);
				$row += 1;
			}
		
			//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
			//if you want to save it as .xls Excel 2007 format
			// ob_end_clean();
			$objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
			$filename='Sales Retur.xls'; //save our workbook as this file name
			header('Content-Type: application/vnd.ms-excel'); //mime type
			header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
			header('Cache-Control: max-age=0'); //no cache 
			//force user to download the Excel file without writing it to server's HD
			$objWriter->save('php://output');
		}
	}


	public function lp_penerimaan_pbso(){		
	if(fcek_hak_akses('.HA1.')) {
		if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			$data['judul_laporan'] = $this->input->get('judul_laporan');
			$data['lp_pbso_tgl'] = trim($this->input->get('lp_pbso_tgl'));
			$data['lp_pbso_tgl_dari'] = trim($this->input->get('lp_pbso_tgl_dari'));
			$data['lp_pbso_tgl_sampai'] = trim($this->input->get('lp_pbso_tgl_sampai'));		
			$data['lp_pbso_tglcair_dari'] = trim($this->input->get('lp_pbso_tglcair_dari'));
			$data['lp_pbso_tglcair_sampai'] = trim($this->input->get('lp_pbso_tglcair_sampai'));	
			$data['lp_mscs'] = $this->input->get('lp_mscs');		
			$data['lp_mscs_no'] = substr($this->input->get('lp_mscs_no'), 0, 6);
			$data['lp_mscs_nm'] = substr($this->input->get('lp_mscs_no'), 9);		
			$data['lp_pbso_paidfrom'] = $this->input->get('lp_pbso_paidfrom');
			$data['lp_pbso_payfor'] = $this->input->get('lp_pbso_payfor');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_fin'] = $this->input->get('lp_trju_fin');
			$data['lp_msjb'] = $this->input->get('lp_msjb');
			$msjb_no = explode(":", $this->input->get('lp_msjb_no'));
			$data['lp_msjb_no'] = trim($msjb_no[0]);

		$query = 'select trso_mscs_no, mscs_nm, pbso_no, pbso_tglterima, pbso_tglcair, pbso_catatan, pbso_tag, msjb_nm,
					pbso_refno, trso_tgl, trsd_tglkirim, pbso_jlhbayar, pbso_jenis, pbso_bayardp, pbso_trsr_no, ifnull(trsd_total,0) trsd_total
				FROM pby_so
				LEFT JOIN tr_so ON trso_no = substring(pbso_no,1,12)
				LEFT JOIN ms_customer ON trso_mscs_no = mscs_no
				LEFT JOIN ms_jnspbyr ON msjb_no = pbso_msjb_no
				LEFT JOIN tr_sales_dlv ON pbso_refno = trsd_no
				WHERE pbso_void=0 and POSITION(pbso_mscb_no in "'.$data['mscb_listmscb'].'")';

		//filter by tanggal create
		if ($data['lp_pbso_tgl'] == 'lp_pbso_tglsel') {
			$query .= ' and pbso_tglterima between "'.$data['lp_pbso_tgl_dari'].'" and "'.$data['lp_pbso_tgl_sampai'].'"';
			$periode = 'Created Date : '.$data['lp_pbso_tgl_dari'].' s/d '.$data['lp_pbso_tgl_sampai'].'';
		}

		//filter by tanggal cair
		if ($data['lp_pbso_tgl'] == 'lp_pbso_tglcair') {
			$query .= ' and pbso_tglcair between "'.$data['lp_pbso_tglcair_dari'].'" and "'.$data['lp_pbso_tglcair_sampai'].'"';
			$periode = 'Tanggal Cair : '.$data['lp_pbso_tglcair_dari'].' s/d '.$data['lp_pbso_tglcair_sampai'].'';
		}
		
		//filter by paid from
		if ($data['lp_pbso_paidfrom'] != 'all'){
			if($data['lp_pbso_paidfrom'] == 1 ){
				$query .= ' and pbso_jenis = "D"';
				$paidfrom = "Potong DP";
			} else if ($data['lp_pbso_paidfrom'] == 2){
				$query .= ' and pbso_jenis = "G"';
				$paidfrom = "Giro Masuk";
			}else if ($data['lp_pbso_paidfrom'] == 3){
				$query .= ' and pbso_jenis = "T"';
				$paidfrom = "Transfer Masuk";
			}else if ($data['lp_pbso_paidfrom'] == 4){
				$query .= ' and pbso_jenis = "O"';
				$paidfrom = "Other";
			}
		} else {
			$paidfrom ="ALL";
		}
		
		//filter by pay for
		if ($data['lp_pbso_payfor'] != 'all'){
			if($data['lp_pbso_payfor'] == 1 ){
				$query .= ' and pbso_bayardp ="D"';
				$payfor = "DP";
			} else if ($data['lp_pbso_payfor'] == 2){
				$query .= ' and pbso_bayardp ="T"';
				$payfor = "Sales Delivery Transaction";
			} else if ($data['lp_pbso_payfor'] == 3){
				$query .= ' and pbso_bayardp ="C"';
				$payfor = "Adjusment DP";
			}
		} else {
			$payfor ="ALL";
		}

		// filter by mscs (customer)
		if($data['lp_mscs'] != 'lp_mscs_all'){
			if ($data['lp_mscs'] == 'lp_mscs_r') {
				$query .= ' and mscs_jenis="R"';
				$mscs = 'Retail';
			} else if ($data['lp_mscs'] == 'lp_mscs_a') {
				$query .= ' and mscs_jenis="A"';
				$mscs = 'Agen';
			} else if ($data['lp_mscs'] == 'lp_mscs_sel'){
				$query .= ' and mscs_no = "'. $data['lp_mscs_no']. '"';
				$mscs = $data['lp_mscs_nm'];
			} 
		} else {
				$mscs ='ALL';
				}

		//filter by jenis bayar
		if($data['lp_msjb'] != "lp_msjb_all"){
			$query .= ' and pbso_msjb_no = '.$data['lp_msjb_no'];
			$jenis_bayar = trim($msjb_no[1]);
		} else {
			$jenis_bayar = 'ALL';
		}

		//filter mspd_fin/commercial
		if($data['lp_fin'] != 'lp_trju_fin_all'){
			$query .= ' AND trso_fin = "'.$data['lp_fin'].'"';
			$trju_fin = $data['lp_fin'];
		} else {
			$trju_fin = 'ALL';
		}

		$query .= ' ORDER BY pbso_tglterima, trso_mscs_no ASC';
		
		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);

		$styleArray = array(
   					'font'  => array(
        			'bold' => true,
        			'size'  => 14,
        			'name' => 'Verdana'
    				));

		$column = 0;
		$row = 0;
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "PENERIMAAN PEMBAYARAN PENJUALAN")
		->getStyle()->applyFromArray($styleArray);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Search By  ".$periode);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Cabang : ".$data['mscb_listmscb']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, "Jenis Bayar : ".$jenis_bayar);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Customer : ".$mscs);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Paid From : ".$paidfrom);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Tipe Data Jurnal : ".$trju_fin);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Pay For : ".$payfor);
		
		$row+=2;
		$table_colums = array('ID CUSTOMER', 'NAMA CUSTOMER', 'ID SO PAYMENT', 'TANGGAL TERIMA PEMBAYARAN', 'TANGGAL CAIR PEMBAYARAN', 'CATATAN PEMBAYARAN',
							 'TAG PEMBAYARAN', 'JENIS PEMBAYARAN', 'NO SO/FAKTUR', 'TGL SO/FAKTUR', 'PEMBAYARAN SO/DP', 'PEMBAYARAN FAKTUR', 'NO REF RETUR', 'KETERANGAN', 'TOTAL INVOICE');		
		foreach ($table_colums as $field) {
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
			$column += 1;
		}
		
		$data = $this->db->query($query);
		$data = $data->result_array();

		$row += 1;		
	
		foreach ($data as $key => $value) {			
			if($value['pbso_bayardp'] =="D"){
				$a = $value['pbso_jlhbayar'];
				$b = 0;
				$c = "Bayar DP";
				$d = $value['trso_tgl'];
			} else if ($value['pbso_bayardp'] =="C"){
				$a = -1*$value['pbso_jlhbayar'];
				$b = 0;
				$c = "Adjusment DP";
				$d = $value['trso_tgl'];
			} else {
				if($value['pbso_bayardp'] == "T"){
					$b = $value['pbso_jlhbayar'];
					$c = "Bayar Faktur";
					if($value['pbso_jenis'] == "D"){
						$a=-1*$value['pbso_jlhbayar'];
					}else {
						$a =0;
					}
					$d = $value['trsd_tglkirim'];
				}
			}
			$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['trso_mscs_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['mscs_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['pbso_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['pbso_tglterima']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $value['pbso_tglcair']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['pbso_catatan']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $value['pbso_tag']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $value['msjb_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $value['pbso_refno']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(9, $row, $d);
			$object->getActiveSheet()->setCellValueByColumnAndRow(10, $row, $a);
			$object->getActiveSheet()->setCellValueByColumnAndRow(11, $row, $b);
			$object->getActiveSheet()->setCellValueByColumnAndRow(12, $row, $value['pbso_trsr_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(13, $row, $c);
			$object->getActiveSheet()->setCellValueByColumnAndRow(14, $row, $value['trsd_total']);
			$row += 1;
		}
 
        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
        //if you want to save it as .xls Excel 2007 format
        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
        $filename='Pembayaran SO.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache 
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');
		}
	}

	public function print_faktur_negara(){
		if(fcek_hak_akses('.HA1.')) {
			if($this->session->userdata('rand')){
				$this->m_reporting->delete_datatemp_bayrand_tfng($this->session->userdata('rand'));
				unset($_SESSION['rand']);
			}									

			$this->session->set_userdata('rand',rand());
			$data['tfng_idlap'] = $this->session->userdata('rand');
			$data['sales_dlv'] = $this->input->get("dtsd_no[]");
			$data['spk'] = $this->input->get("trspk_no[]");
			$data['tgl_faktur'] = trim($this->input->get("tgl_faktur"));
			$data['no_invoice'] = $this->input->get('no_invoice');
			$data['no_po'] = $this->input->get('no_po');
			$data['no_faktur'] = $this->input->get("no_faktur");
			$data['mscs_faktur'] = substr($this->input->get("mscs_faktur"),9);
			$data['alamat_faktur'] = $this->input->get("alamat_faktur");
			$data['top_faktur'] = $this->input->get("top_faktur");
			$err_msg = "";
			
			if((!empty($data['sales_dlv']) || !empty($data['spk'])) && !empty($data['tgl_faktur']) && !empty($data['no_invoice'])
				&& !empty($data['mscs_faktur']) && !empty($data['alamat_faktur']) && $data['top_faktur'] != ""){

				$result = $this->m_reporting->print_faktur_negara($data);

				$logo = $this->session->userdata('user_aktif')['mscb_logo'];
				$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
				$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
				$line2 = $this->session->userdata('user_aktif')['mscb_line2'];

				if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
					die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
				}

				$path = APPPATH.'reports\so_reports\print_faktur_negara.jrxml';

				// Update query string yang ada di xml file
				$xml = new DOMDocument();
				$xml->load($path);
				$nodes = $xml->getElementsByTagName('queryString') ;				
				$xml->getElementsByTagName("queryString")->item(0)->nodeValue = "";
				$xml->getElementsByTagName("queryString")->item(0)->appendChild($xml->createCDATASection($result));		   		   
				$xml->save($path);


				$params = new Java("java.util.HashMap");
				$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
				$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
				$params->put("alamat_area",new Java('java.lang.String', $line1));
				$params->put("telp_area",new Java('java.lang.String', $line2));
				$params->put("tgl_faktur",new Java('java.lang.String', $data['tgl_faktur']));
				$params->put("no_faktur",new Java('java.lang.String', $data['no_invoice']));
				$params->put("no_po",new Java('java.lang.String', $data['no_po']));
				$params->put("mscs_nm",new Java('java.lang.String', $data['mscs_faktur']));
				$params->put("mscs_almt",new Java('java.lang.String', $data['alamat_faktur']));
				$params->put("top_faktur",new Java('java.lang.String', $data['top_faktur']));				

				if($this->java_bridge->print_data($path, $params)){
					for($i=0; $i<count($data['sales_dlv']); $i++){
						$this->db->where('trsd_no', $data['sales_dlv'][$i]);
						$this->db->update('tr_sales_dlv', array('trsd_fakturno' => $data['no_faktur'], 'trsd_fakturtgl' => $data['tgl_faktur']));					
					}

					for($i=0; $i<count($data['spk']); $i++){
						$this->db->where('trspk_no', $data['spk'][$i]);
						$this->db->update('tr_spk', array('trspk_fakturno' => $data['no_faktur'], 'trspk_fakturtgl' => $data['tgl_faktur']));					
					}
				}

			}else{
				if(empty($data['tgl_faktur'])){
					$err_msg .= " <br>Please Input Tanggal Faktur";
				}
				if(empty($data['no_invoice'])){
					$err_msg .= " <br>Please Input Nomor Invoice";
				}
				if(empty($data['mscs_faktur'])){
					$err_msg .= " <br>Please Input Customer";
				}
				if(empty($data['alamat_faktur'])){
					$err_msg .= " <br>Please Input Alamat Customer";
				}
				if($data['top_faktur'] == ""){
					$err_msg .= " <br>Please Input TOP Faktur";
				}
				
				die("Data Validation : ".$err_msg);

			}

			if($this->session->userdata('rand')){
				$this->m_reporting->delete_datatemp_bayrand_tfng($this->session->userdata('rand'));
				unset($_SESSION['rand']);
			}		

		}
	}

	//==========================================================================================================
	//============== CSV eFaktur berikut ini sudah disesuaikan untuk program DJP 3.2 (April 2022) ==============
	//==========================================================================================================
	public function print_faktur_negara_csv(){
		if(fcek_hak_akses('.HA1.')) {
			if($this->session->userdata('rand')){
				$this->m_reporting->delete_datatemp_bayrand_tfng($this->session->userdata('rand'));
				unset($_SESSION['rand']);
			}									

			$this->session->set_userdata('rand',rand());
			$data['tfng_idlap'] = $this->session->userdata('rand');
			$data['sales_dlv'] = $this->input->get("dtsd_no[]");
			$data['spk'] = $this->input->get("trspk_no[]");
			$data['tgl_faktur'] = trim($this->input->get("tgl_faktur"));
			$data['no_invoice'] = $this->input->get('no_invoice');
			$data['no_po'] = $this->input->get('no_po');
			$data['no_faktur'] = $this->input->get("no_faktur");
			$data['mscs_faktur'] = substr($this->input->get("mscs_faktur"),9);
			$data['mscs_npwp'] = $this->input->get("mscs_npwp");
			$data['alamat_faktur'] = $this->input->get("alamat_faktur");
			$data['top_faktur'] = $this->input->get("top_faktur");
			$err_msg = "";

			if((!empty($data['sales_dlv']) || !empty($data['spk'])) && !empty($data['tgl_faktur']) && !empty($data['no_faktur'])
				&& !empty($data['mscs_faktur']) && !empty($data['alamat_faktur'])
				&& !empty($data['mscs_npwp']) && !empty($data['no_invoice'])){
				
				// === CREATE CSV FILE ======================================================================================================
				

				$filename = 'eFaktur '. $data['no_invoice'] . '.csv';
				$myfile = fopen($filename,'w');

				$OutLine = '"FK","KD_JENIS_TRANSAKSI","FG_PENGGANTI","NOMOR_FAKTUR","MASA_PAJAK","TAHUN_PAJAK","TANGGAL_FAKTUR"';
				$OutLine = $OutLine . ',"NPWP","NAMA","ALAMAT_LENGKAP","JUMLAH_DPP","JUMLAH_PPN","JUMLAH_PPNBM","ID_KETERANGAN_TAMBAHAN"';
				$OutLine = $OutLine . ',"FG_UANG_MUKA","UANG_MUKA_DPP","UANG_MUKA_PPN","UANG_MUKA_PPNBM","REFERENSI","KODE_DOKUMEN_PENDUKUNG"';
				$OutLine = $OutLine . "\n";
				fwrite($myfile, $OutLine);

				$OutLine = '"LT","NPWP","NAMA","JALAN","BLOK","NOMOR","RT","RW","KECAMATAN","KELURAHAN","KABUPATEN","PROPINSI"';
				$OutLine = $OutLine . ',"KODE_POS","NOMOR_TELEPON"';
				$OutLine = $OutLine . "\n";
				fwrite($myfile, $OutLine);

				$OutLine = '"OF","KODE_OBJEK","NAMA","HARGA_SATUAN","JUMLAH_BARANG","HARGA_TOTAL","DISKON","DPP","PPN","TARIF_PPNBM","PPNBM"';
				$OutLine = $OutLine . "\n";
				fwrite($myfile, $OutLine);
		
				// CALCULATE TOTAL DPP dan PPN dari detail ========================================
				$dpp_total = 0; $ppn_total=0;
				// get data detail from model (database)--------------------------------------------------------------------
				$query = $this->m_reporting->print_faktur_negara($data);
				$detail = $this->db->query($query)->result_array();
				foreach ($detail as $key => $value) {
					$dpp_total += round($value['total']);
					$ppn_total += round($value['tottax']);		
				}
				// END - CALCULATE TOTAL DPP dan PPN dari detail ==================================


				// ============================================ Tulis bagian FK ============================================
				$OutLine = '"FK","01","0","'.  $data['no_faktur'] .'","'. substr($data['tgl_faktur'],5,2) .'","'. substr($data['tgl_faktur'],0,4) .'"';
				$OutLine = $OutLine . ',"'. date('d/m/Y',strtotime($data['tgl_faktur'])) .'"';
				$OutLine = $OutLine . ',"'. preg_replace('/[^a-zA-Z0-9]/', '', $data['mscs_npwp']) .'"';
				$OutLine = $OutLine . ',"'. $data['mscs_faktur'] .'"';
				$OutLine = $OutLine . ',"'. preg_replace( '/\r|\n/', ' ', $data['alamat_faktur']) .'"';
				$OutLine = $OutLine . ',"'. $dpp_total .'"';
				$OutLine = $OutLine . ',"'. $ppn_total .'"';
				$OutLine = $OutLine . ',"0","","0","0","0","0","'. $data['no_invoice'] .'",';
				$OutLine = $OutLine . "\n";
				fwrite($myfile, $OutLine);


				// ============================================ Tulis bagian FAPR ============================================
				$fapr = $this->m_setting_efaktur->get_setting_efaktur();
				$OutLine = '"FAPR","'.$fapr['fapr_compname'].'","'.$fapr['fapr_address'].'","","","",';
				$OutLine = $OutLine . "\n";
				fwrite($myfile, $OutLine);


				// ============================================ Tulis bagian OF ============================================
				// get data detail from model (database)--------------------------------------------------------------------
				// $query = $this->m_reporting->print_faktur_negara($data);
				// $detail = $this->db->query($query)->result_array();
				foreach ($detail as $key => $value) {
					$OutLine = '"OF","'. $value['tfng_mspd_no'] .'","'. $value['mspd_nm'] .'"';
					$OutLine = $OutLine . ',"'. round($value['total']/$value['qty'], 2) .'"';
					$OutLine = $OutLine . ',"'. $value['qty'] .'"';
					$OutLine = $OutLine . ',"'. round($value['total']) .'"';
					$OutLine = $OutLine . ',"0"';
					$OutLine = $OutLine . ',"'. round($value['total']) .'"';
					$OutLine = $OutLine . ',"'. round($value['tottax']) .'"';
					$OutLine = $OutLine . ',"0","0.00"';
					$OutLine = $OutLine . "\n";
					fwrite($myfile, $OutLine);
				}

				// Close and Save File to local ----------------------------------------------------------------------------
				fclose($myfile);

				header('Content-Description: File Transfer');
				header('Content-Disposition: attachment; filename='.basename($filename));
				header('Expires: 0');
				header('Cache-Control: must-revalidate');
				header('Pragma: public');
				header('Content-Length: ' . filesize($filename));
				header("Content-Type: text/plain");
				readfile($filename);

				// Update Status No Faktur masing-masing transaksi ---------------------------------------------------------
		        for($i=0; $i<count($data['sales_dlv']); $i++){
					$this->db->where('trsd_no', $data['sales_dlv'][$i]);
					$this->db->update('tr_sales_dlv', array('trsd_fakturno' => $data['no_faktur'], 'trsd_fakturtgl' => $data['tgl_faktur']));					
				}

				for($i=0; $i<count($data['spk']); $i++){
					$this->db->where('trspk_no', $data['spk'][$i]);
					$this->db->update('tr_spk', array('trspk_fakturno' => $data['no_faktur'], 'trspk_fakturtgl' => $data['tgl_faktur']));					
				}

			}else{
				if(empty($data['tgl_faktur'])){
					$err_msg .= " <br>Please Input Tanggal Faktur";
				}
				if(empty($data['no_invoice'])){
					$err_msg .= " <br>Please Input Nomor Invoice";
				}
				if(empty($data['no_faktur'])){
					$err_msg .= " <br>Please Input Nomor Faktur Negara";
				}
				if(empty($data['mscs_faktur'])){
					$err_msg .= " <br>Please Input Customer";
				}
				if(empty($data['mscs_npwp'])){
					$err_msg .= " <br>Please Input NPWP Customer";
				}
				if(empty($data['alamat_faktur'])){
					$err_msg .= " <br>Please Input Alamat Customer";
				}
				
				die("Data Validation : ".$err_msg);
			}

		if($this->session->userdata('rand')){
			$this->m_reporting->delete_datatemp_bayrand_tfng($this->session->userdata('rand'));
			unset($_SESSION['rand']);
		}		

		}

	}

	// public function print_faktur_negara_csv(){
	// 	if(fcek_hak_akses('.HA1.')) {
	// 		if($this->session->userdata('rand')){
	// 			$this->m_reporting->delete_datatemp_bayrand_tfng($this->session->userdata('rand'));
	// 			unset($_SESSION['rand']);
	// 		}									

	// 		$this->session->set_userdata('rand',rand());
	// 		$data['tfng_idlap'] = $this->session->userdata('rand');
	// 		$data['sales_dlv'] = $this->input->get("dtsd_no[]");
	// 		$data['spk'] = $this->input->get("trspk_no[]");
	// 		$data['tgl_faktur'] = trim($this->input->get("tgl_faktur"));
	// 		$data['no_invoice'] = $this->input->get('no_invoice');
	// 		$data['no_po'] = $this->input->get('no_po');
	// 		$data['no_faktur'] = $this->input->get("no_faktur");
	// 		$data['mscs_faktur'] = substr($this->input->get("mscs_faktur"),9);
	// 		$data['mscs_npwp'] = $this->input->get("mscs_npwp");
	// 		$data['alamat_faktur'] = $this->input->get("alamat_faktur");
	// 		$data['top_faktur'] = $this->input->get("top_faktur");
	// 		$err_msg = "";

	// 		if((!empty($data['sales_dlv']) || !empty($data['spk'])) && !empty($data['tgl_faktur']) && !empty($data['no_faktur'])
	// 			&& !empty($data['mscs_faktur']) && !empty($data['alamat_faktur'])
	// 			&& !empty($data['mscs_npwp']) && !empty($data['no_invoice'])){
				
	// 			// === CREATE CSV FILE ======================================================================================================
	// 			$this->load->library('Excel');
	// 			PHPExcel_Cell::setValueBinder(new PHPExcel_Cell_AdvancedValueBinder());
	// 			$object = new PHPExcel();
	// 			$object->setActiveSheetIndex(0);

	// 			$column = 0;
	// 			$row = 0;

	// 			// --- Header csv first line ----------------------------------------------------------------------------------------
	// 			$row+=1; $col = -1;
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "FK");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KD_JENIS_TRANSAKSI");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "FG_PENGGANTI");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NOMOR_FAKTUR");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "MASA_PAJAK");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "TAHUN_PAJAK");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "TANGGAL_FAKTUR");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NPWP");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NAMA");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "ALAMAT_LENGKAP");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "JUMLAH_DPP");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "JUMLAH_PPN");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "JUMLAH_PPNBM");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "ID_KETERANGAN_TAMBAHAN");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "FG_UANG_MUKA");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "UANG_MUKA_DPP");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "UANG_MUKA_PPN");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "UANG_MUKA_PPNBM");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "REFERENSI");
	// 			// --- END Header csv first line ------------------------------------------------------------------------------------

	// 			// --- Header csv second line ---------------------------------------------------------------------------------------
	// 			$row+=1; $col = -1;
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "LT");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NPWP");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NAMA");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "JALAN");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "BLOK");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NOMOR");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "RT");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "RW");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KECAMATAN");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KELURAHAN");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KABUPATEN");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "PROPINSI");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KODE_POS");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NOMOR_TELEPON");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
	// 			// --- END Header csv second line ------------------------------------------------------------------------------------

	// 			// --- Header csv third line ---------------------------------------------------------------------------------------
	// 			$row+=1; $col = -1;
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "OF");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KODE_OBJEK");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NAMA");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "HARGA_SATUAN");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "JUMLAH_BARANG");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "HARGA_TOTAL");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "DISKON");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "DPP");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "PPN");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "TARIF_PPNBM");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "PPNBM");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
	// 			// --- END Header csv third line ------------------------------------------------------------------------------------

	// 			$query = $this->m_reporting->print_faktur_negara($data);
	// 			$detail = $this->db->query($query)->result_array();
	// 			// echo "<pre>"; print_r($detail); die();
	// 			$col = -1; $baris=5; $dpp_total = 0; $ppn_total=0;
	// 			foreach ($detail as $key => $value) {
	// 				// --- Detail Produk -------------------------------------------------------------------------------------------------
	// 				$sheet = 'E'.$baris;
	// 				$col = -1;
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "OF");
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, $value['tfng_mspd_no']);
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, $value['mspd_nm']);
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, round($value['total']/$value['qty'], 2));
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, $value['qty'])
	// 									->getStyle($sheet)->getNumberFormat()->setFormatCode("#,##0.0");
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, $value['total']);
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "0");
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, $value['total']);
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris,round($value['tottax']));
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "0");
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "0");
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
	// 				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $baris, "");
	// 				$baris+=1;
	// 				$dpp_total += $value['total'];
	// 				$ppn_total += round($value['tottax']);
	// 				// --- END Detail Produk ------ ------------------------------------------------------------------------------------
	// 			}

	// 			$row =4; $col = -1;
	// 			// ---  first line data----------------------------------------------------------------------------------------
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "FK");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "01");
	// 						$object->getActiveSheet()->getStyle('B4')->getNumberFormat()->setFormatCode('00');
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "0");
	// 			$col += 1; $object->getActiveSheet()->setCellValueExplicit('D4', $data['no_faktur'], PHPExcel_Cell_DataType::TYPE_STRING);
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, substr($data['tgl_faktur'],5,2));
	// 			$object->getActiveSheet()->getStyle('E4')->getNumberFormat()->setFormatCode('00');
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, substr($data['tgl_faktur'],0,4));
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $data['tgl_faktur']);
	// 					   $object->getActiveSheet()->getStyle('G4')->getNumberFormat()->setFormatCode('dd/mm/yyyy');
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, preg_replace('/[^a-zA-Z0-9]/', '',$data['mscs_npwp']));
	// 					   $object->getActiveSheet()->getStyle('H4')->getNumberFormat()->setFormatCode('000000000000000');
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $data['mscs_faktur']);
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, preg_replace( '/\r|\n/', ' ', $data['alamat_faktur']));
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $dpp_total);
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $ppn_total);
	// 			// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, round($data['dpp_total']));
	// 			// $col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, round($data['ppn_total']));
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "0");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "");
	// 			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $data['no_invoice']);
	// 			// --- END Header csv first line ------------------------------------------------------------------------------------

	// 			$objWriter = PHPExcel_IOFactory::createWriter($object, 'csv');
	// 			$objWriter->setPreCalculateFormulas(true);
	// 	        $filename='eFaktur.csv'; //save our workbook as this file name
	// 	        header('Content-Type: application/vnd.csv'); //mime type
	// 	        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	// 	        header('Cache-Control: max-age=0'); //no cache 
	// 	        //force user to download the Excel file without writing it to server's HD
	// 	        $objWriter->save('php://output');

	// 	        for($i=0; $i<count($data['sales_dlv']); $i++){
	// 				$this->db->where('trsd_no', $data['sales_dlv'][$i]);
	// 				$this->db->update('tr_sales_dlv', array('trsd_fakturno' => $data['no_faktur'], 'trsd_fakturtgl' => $data['tgl_faktur']));					
	// 			}

	// 			for($i=0; $i<count($data['spk']); $i++){
	// 				$this->db->where('trspk_no', $data['spk'][$i]);
	// 				$this->db->update('tr_spk', array('trspk_fakturno' => $data['no_faktur'], 'trspk_fakturtgl' => $data['tgl_faktur']));					
	// 			}

	// 		}else{
	// 			if(empty($data['tgl_faktur'])){
	// 				$err_msg .= " <br>Please Input Tanggal Faktur";
	// 			}
	// 			if(empty($data['no_invoice'])){
	// 				$err_msg .= " <br>Please Input Nomor Invoice";
	// 			}
	// 			if(empty($data['no_faktur'])){
	// 				$err_msg .= " <br>Please Input Nomor Faktur Negara";
	// 			}
	// 			if(empty($data['mscs_faktur'])){
	// 				$err_msg .= " <br>Please Input Customer";
	// 			}
	// 			if(empty($data['mscs_npwp'])){
	// 				$err_msg .= " <br>Please Input NPWP Customer";
	// 			}
	// 			if(empty($data['alamat_faktur'])){
	// 				$err_msg .= " <br>Please Input Alamat Customer";
	// 			}
				
	// 			die("Data Validation : ".$err_msg);
	// 		}

	// 	if($this->session->userdata('rand')){
	// 		$this->m_reporting->delete_datatemp_bayrand_tfng($this->session->userdata('rand'));
	// 		unset($_SESSION['rand']);
	// 	}		

	// 	}

	// }

	public function lp_spk(){
		if(fcek_hak_akses('.HA9.')) {
			//cek status akses area

			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

			// if($this->session->userdata('rand')){
			// 	$this->m_reporting->delete_datatemp_bayrand_tls($this->session->userdata('rand'));
			// 	unset($_SESSION['rand']);
			// }

			// $this->session->set_userdata('rand',rand());
			$data['tls_idlap'] = rand(); // $this->session->userdata('rand');
			$data['judul_laporan'] = $this->input->get('judul_laporan');
			$data['lp_trspk_tgl'] = $this->input->get('lp_trspk_tgl');	
			$data['lp_trspk_tgl_dari'] = trim($this->input->get('lp_trspk_tgl_dari'));
			$data['lp_trspk_tgl_sampai'] = trim($this->input->get('lp_trspk_tgl_sampai'));
			$data['lp_trspk_tglfinish_dari'] = trim($this->input->get('lp_trspk_tglfinish_dari'));
			$data['lp_trspk_tglfinish_sampai'] = trim($this->input->get('lp_trspk_tglfinish_sampai'));
			$data['lp_mspd'] = $this->input->get('lp_mspd');
			$data['lp_mspd_no_sel'] = substr($this->input->get('lp_mspd_no_sel'), 0, 9);
			$data['lp_mspd_nm'] = substr($this->input->get('lp_mspd_no_sel'), 12);	
			$data['lp_mspd_nm_con'] = $this->input->get('lp_mspd_nm_con');	
			$data['lp_mscs'] = $this->input->get('lp_mscs');		
			$data['lp_mscs_no'] = substr($this->input->get('lp_mscs_no'), 0, 6);
			$data['lp_mscs_nm'] = substr($this->input->get('lp_mscs_no'), 9);	
			$data['lp_mssl_sel'] = $this->input->get('lp_mssl');
			$data['mssl'] = explode(":", $this->input->get('lp_mssl_no'));
			$data['mssl_no'] = trim($data['mssl'][0]);
			$data['lp_servicetype'] = $this->input->get('lp_servicetype');
			$data['lp_finishstatus'] = $this->input->get('lp_finishstatus');
			$data['sp_warranty'] = $this->input->get('sp_warranty');
			$data['svc_warranty'] = $this->input->get('svc_warranty');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
			$data['lp_paymentstatus'] = $this->input->get('lp_paymentstatus');
			$data['lp_sn'] = $this->input->get('lp_sn');
			$data['lp_sn_no'] = $this->input->get('lp_sn_no');
			
			$path = APPPATH.'reports\spk_reports\lp_spk.jrxml';
			if($data['judul_laporan'] == "lp_spk_sn"){
				$path = APPPATH.'reports\spk_reports\lp_spk_sn.jrxml';
			}else if ($data['judul_laporan'] == "lp_spk_sn_by_sd"){
				$path = APPPATH.'reports\spk_reports\lp_spk_sn_by_sd.jrxml';
			}
			

			$this->m_reporting->inserto_tmp_lap_spk($data);					
			
			// string query hasil filter
			$result = $this->m_reporting->get_lp_spk($data);
			// echo "<pre>"; print_r($result['query']); die();

			// Update query string yang ada di xml file
			$xml = new DOMDocument();
			$xml->load($path);
			$nodes = $xml->getElementsByTagName('queryString') ;				
			$xml->getElementsByTagName("queryString")->item(0)->nodeValue = "";
			$xml->getElementsByTagName("queryString")->item(0)->appendChild($xml->createCDATASection($result['query']));		   		   
			$xml->save($path);

			// Set parameter yang akan di kirim ke file xml
			$params = new Java("java.util.HashMap");							
			$params->put("tgl_dari", new Java('java.lang.String', $result['param']['tgl_dari']));
			$params->put("tgl_sampai", new Java('java.lang.String', $result['param']['tgl_sampai']));
			$params->put("servicetype", new Java('java.lang.String', $result['param']['servicetype']));
			$params->put("paymentstatus", new Java('java.lang.String', $result['param']['lp_paymentstatus']));
			$params->put("finishstatus", new Java('java.lang.String', $result['param']['finishstatus']));
			$params->put("sp_warranty", new Java('java.lang.String', $result['param']['sp_warranty']));
			$params->put("svc_warranty", new Java('java.lang.String', $result['param']['svc_warranty']));
			$params->put("mscs_no", new Java('java.lang.String', $result['param']['mscs_no']));
			$params->put("mscs_nm", new Java('java.lang.String', $result['param']['mscs_nm']));
			$params->put("cabang", new Java('java.lang.String', $data['mscb_listmscb']));
			$params->put("fin", new Java('java.lang.String', $data['lp_trju_fin']));
			$params->put("mssl_no", new Java('java.lang.String', $result['param']['mssl_no']));
			$params->put("mssl_nm", new Java('java.lang.String', $result['param']['mssl_nm']));
			$params->put("mspd_no", new Java('java.lang.String', $result['param']['mspd_no']));
			$params->put("mspd_nm", new Java('java.lang.String', $result['param']['mspd_nm']));
			
			// print out report di browser
			$this->java_bridge->print_data($path, $params);	

			$tls_idlap = $data['tls_idlap'];
			
			// delete data temp
			$this->m_reporting->delete_datatemp_bayrand_tls($tls_idlap);

			// if($this->session->userdata('rand')){
			// 	$this->m_reporting->delete_datatemp_bayrand_tls($this->session->userdata('rand'));
			// 	unset($_SESSION['rand']);
			// }
		}
	}

	public function lp_spk_excel(){
		if(fcek_hak_akses('.HA9.')) {
			//cek status akses area

			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

			// if($this->session->userdata('rand')){
			// 	$this->m_reporting->delete_datatemp_bayrand_tls($this->session->userdata('rand'));
			// 	unset($_SESSION['rand']);
			// }

			// $this->session->set_userdata('rand',rand());
			$data['tls_idlap'] = rand(); // $this->session->userdata('rand');
			$data['judul_laporan'] = $this->input->get('judul_laporan');
			$data['lp_trspk_tgl'] = $this->input->get('lp_trspk_tgl');	
			$data['lp_trspk_tgl_dari'] = trim($this->input->get('lp_trspk_tgl_dari'));
			$data['lp_trspk_tgl_sampai'] = trim($this->input->get('lp_trspk_tgl_sampai'));
			$data['lp_trspk_tglfinish_dari'] = trim($this->input->get('lp_trspk_tglfinish_dari'));
			$data['lp_trspk_tglfinish_sampai'] = trim($this->input->get('lp_trspk_tglfinish_sampai'));
			$data['lp_mspd'] = $this->input->get('lp_mspd');
			$data['lp_mspd_no_sel'] = substr($this->input->get('lp_mspd_no_sel'), 0, 9);
			$data['lp_mspd_nm'] = substr($this->input->get('lp_mspd_no_sel'), 12);	
			$data['lp_mspd_nm_con'] = $this->input->get('lp_mspd_nm_con');	
			$data['lp_mscs'] = $this->input->get('lp_mscs');		
			$data['lp_mscs_no'] = substr($this->input->get('lp_mscs_no'), 0, 6);
			$data['lp_mscs_nm'] = substr($this->input->get('lp_mscs_no'), 9);		
			$data['lp_mssl_sel'] = $this->input->get('lp_mssl');
			$data['mssl'] = explode(":", $this->input->get('lp_mssl_no'));
			$data['mssl_no'] = trim($data['mssl'][0]);
			$data['lp_servicetype'] = $this->input->get('lp_servicetype');
			$data['lp_finishstatus'] = $this->input->get('lp_finishstatus');
			$data['sp_warranty'] = $this->input->get('sp_warranty');
			$data['svc_warranty'] = $this->input->get('svc_warranty');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
			$data['lp_paymentstatus'] = $this->input->get('lp_paymentstatus');
			// echo "<pre>";print_r($data);die();
			$lap="";
			if($data['judul_laporan'] == "lp_spk_hpp_excel"){
				$lap = "lp_spk_hpp_excel";
			}else $lap=$data['judul_laporan'];

			$path = APPPATH.'reports\spk_reports\lp_spk.jrxml';
			$this->m_reporting->inserto_tmp_lap_spk($data);					
			
			// string query hasil filter
			$result = $this->m_reporting->get_lp_spk($data);

			PHPExcel_Cell::setValueBinder(new PHPExcel_Cell_AdvancedValueBinder());
			$object = new PHPExcel();
			$object->setActiveSheetIndex(0);

			$styleArray = array(
	   					 'font'  => array('bold' => true, 'size'  => 14,'name' => 'Verdana'));

			$col = 0; $row = 0;
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "LIST SPK")
			->getStyle()->applyFromArray($styleArray); 
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "Cabang : ".$data['mscb_listmscb']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Customer : ".$result['param']['mscs_no']." - ".$result['param']['mscs_nm']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "Tgl SPK : ".$result['param']['tgl_dari']." - ".$result['param']['tgl_sampai']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Sales : ".$result['param']['mssl_no']." - ".$result['param']['mssl_nm']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "Tgl Finish : ".$result['param']['tgl_dari']." - ".$result['param']['tgl_sampai']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Produk : ".$result['param']['mspd_no']." - ".$result['param']['mspd_nm']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "Sparepart Warranty : ".$result['param']['sp_warranty']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Service Type: ".$result['param']['servicetype']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "Service Warranty : ".$result['param']['svc_warranty']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Finish Status : ".$result['param']['finishstatus']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "Payment Status : ".$result['param']['lp_paymentstatus']);
			
			// Column Header ==============================================================================================
			$row+=2; $col -=1;
			$col +=	1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "TGL SPK");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NO SPK");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "USER PEMBUAT SPK");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "TGL FINISH");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KODE CUSTOMER");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NAMA CUSTOMER");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "TIPE SERVICE");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "BIAYA");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "SPRT WARRANTY");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "SVC WARRANTY");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "GUDANG");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KODE PRODUK");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NAMA PRODUK");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "SERIAL NUMBER");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "KELUHAN");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "CATATAN");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "[VISIT] TGL VISIT DARI");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "[VISIT] TGL VISIT SAMPAI");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "[VISIT] KODE TEKNISI");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "[VISIT] NAMA TEKNISI");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "[VISIT] CATATAN VISIT");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "[VISIT] KESIMPULAN");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "[S/P] KODE SPAREPART");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "[S/P] NAMA SPAREPART");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "[S/P] QTY");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "[S/P] HARGA UNIT");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "[S/P] TOTAL");
			if($lap=="lp_spk_hpp_excel"){
				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "[S/P] HPP");
				$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "[S/P] LABA KOTOR");
			}
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "[A/P] KODE AKUN");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "[A/P] NAMA AKUN");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "[A/P] TOTAL");
			// End Column Header ====================================================================================================

			$tls_idlap = $data['tls_idlap'];
			
			$data = $this->db->query($result['query']);
			$data = $data->result_array();	
			// echo "<pre>"; print_r($data); die();

			// delete data temp
			$this->m_reporting->delete_datatemp_bayrand_tls($tls_idlap);

	        $row += 1; $col =-1;
	        $no_prev = "";
			foreach ($data as $key => $value) {	
				// jika tanggal 0000-00-00 maka blank
				if($value['trspk_tglselesai'] == "0000-00-00") {
					$value['trspk_tglselesai'] ="";
				} else $value['trspk_tglselesai'] = $value['trspk_tglselesai'];

				if ($value['tls_ref_v_tglvisitfrom'] == "0000-00-00") {
					$value['tls_ref_v_tglvisitfrom']="";	
				} else $value['tls_ref_v_tglvisitfrom'] = $value['tls_ref_v_tglvisitfrom'];
				
				if ($value['tls_ref_v_tglvisituntil'] == "0000-00-00"){
					$value['tls_ref_v_tglvisituntil']="";
				} else $value['tls_ref_v_tglvisituntil'] = $value['tls_ref_v_tglvisitfrom'];
				// end 

			if ($no_prev != $value['trspk_no']){
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_tgl']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_no']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_msus_no'] . ' - ' . $value['msus_nm']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_tglselesai']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_mscs_no']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['mscs_nm']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_jnsservis']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_biayaservis']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_garansisp']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_garansijasa']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['msgd_nm']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_mspd_no']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['mspd_nm']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_noserial']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_keluhan']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_catatan']);
				$no_prev = $value['trspk_no'];
			}

				$col =15; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['tls_ref_v_tglvisitfrom']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['tls_ref_v_tglvisituntil']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['tls_ref_v_mssl_no']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['tls_ref_v_mssl_nm']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['tls_ref_v_catatan'])->getColumnDimension('S')->setWidth(45);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['tls_ref_v_kesimpulan'])->getColumnDimension('T')->setWidth(45);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['tls_ref_s_mspd_no']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['tls_ref_s_mspd_nm']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['tls_ref_s_qty']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['tls_ref_s_nett']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, ($value['tls_ref_s_nett']*$value['tls_ref_s_qty']));
				if($lap=="lp_spk_hpp_excel"){
					$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['tls_ref_s_hpp']);
					$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['tls_ref_s_nett']-$value['tls_ref_s_hpp']);
				}
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['tls_ref_a_msap_no']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['tls_ref_a_msap_nm']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['tls_ref_a_total']);
				$row += 1; $col =-1; 
			}
	        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
	        //if you want to save it as .xls Excel 2007 format
	        // ob_end_clean();
	        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
	        $filename='list SPK.xls'; //save our workbook as this file name
	        header('Content-Type: application/vnd.ms-excel'); //mime type
	        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	        header('Cache-Control: max-age=0'); //no cache 
	        //force user to download the Excel file without writing it to server's HD
	        $objWriter->save('php://output');
			
			// if($this->session->userdata('rand')){
			// 	$this->m_reporting->delete_datatemp_bayrand_tls($this->session->userdata('rand'));
			// 	unset($_SESSION['rand']);
			// }
		}
	}

	public function lp_spk_ringkasan(){
		if(fcek_hak_akses('.HA9.')) {
			//cek status akses area

			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

			// if($this->session->userdata('rand')){
			// 	$this->m_reporting->delete_datatemp_bayrand_tls($this->session->userdata('rand'));
			// 	unset($_SESSION['rand']);
			// }

			// $this->session->set_userdata('rand',rand());
			$data['tls_idlap'] = rand(); // $this->session->userdata('rand');
			$data['judul_laporan'] = $this->input->get('judul_laporan');
			$data['lp_trspk_tgl'] = $this->input->get('lp_trspk_tgl');	
			$data['lp_trspk_tgl_dari'] = trim($this->input->get('lp_trspk_tgl_dari'));
			$data['lp_trspk_tgl_sampai'] = trim($this->input->get('lp_trspk_tgl_sampai'));
			$data['lp_trspk_tglfinish_dari'] = trim($this->input->get('lp_trspk_tglfinish_dari'));
			$data['lp_trspk_tglfinish_sampai'] = trim($this->input->get('lp_trspk_tglfinish_sampai'));
			$data['lp_mscs'] = $this->input->get('lp_mscs');		
			$data['lp_mscs_no'] = substr($this->input->get('lp_mscs_no'), 0, 6);
			$data['lp_mscs_nm'] = substr($this->input->get('lp_mscs_no'), 9);		
			$data['lp_servicetype'] = $this->input->get('lp_servicetype');
			$data['lp_finishstatus'] = $this->input->get('lp_finishstatus');
			$data['sp_warranty'] = $this->input->get('sp_warranty');
			$data['svc_warranty'] = $this->input->get('svc_warranty');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_paymentstatus'] = $this->input->get('lp_paymentstatus');
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
			$data['lp_mssl_sel'] ="";


			$this->m_reporting->inserto_tmp_lap_spk($data);	

			$result = $this->m_reporting->get_lp_spk_ringkasan($data);
			// echo "<pre>"; print_r($result); die();
			PHPExcel_Cell::setValueBinder(new PHPExcel_Cell_AdvancedValueBinder());
			$object = new PHPExcel();
			$object->setActiveSheetIndex(0);

			$styleArray = array(
	   					 'font'  => array('bold' => true, 'size'  => 14,'name' => 'Verdana'));

			$col = 0; $row = 0;
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "SPK RINGKASAN")
			->getStyle()->applyFromArray($styleArray); 
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "Search by ".$result['param']['tgl']." : ".$result['param']['tgl_dari']." - ".$result['param']['tgl_sampai']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "Cabang : ".$data['mscb_listmscb']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, "Service Warranty : ".$result['param']['svc_warranty']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "Sparepart Warranty : ".$result['param']['sp_warranty']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, "Service Type: ".$result['param']['servicetype']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "Service Type : ".$result['param']['servicetype']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, "Finish Status : ".$result['param']['finishstatus']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "Payment Status : ".$result['param']['lp_paymentstatus']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, "F/C : ".$result['param']['trju_fin']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "Customer : ".$result['param']['mscs_no']." - ".$result['param']['mscs_nm']);
			
			// Column Header ==============================================================================================
			$row+=2; $col -=1;
			$col +=	1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "SPK NO");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "CREATED DATE");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "CREATED BY");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "FINISH DATE");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "SP WARRANTY");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "SERVICE WARRANTY");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "CUSTOMER ID");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "CUSTOMER NAME");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "FAKTUR DATE");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NO. FAKTUR");	
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "SPK AMOUNT");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "PAID");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "OUTSTANDING SPK");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NAMA TEKNISI");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NOTE");
			// End Column Header ====================================================================================================
			
			$tls_idlap = $data['tls_idlap'];

			$data = $this->db->query($result['query']);
			$data = $data->result_array();	
			// echo "<pre>"; print_r($data); die();

			// delete data temp
			$this->m_reporting->delete_datatemp_bayrand_tls($tls_idlap);

	        $row += 1; $col =-1;
	        $no_prev = "";
			foreach ($data as $key => $value) {	
				// jika tanggal 0000-00-00 maka blank
				if($value['trspk_tglselesai'] == "0000-00-00") {
					$value['trspk_tglselesai'] ="";
				} else $value['trspk_tglselesai'] = $value['trspk_tglselesai'];
				// end 

				$trspk_fakturtgl = ($value['trspk_fakturtgl'] == '0000-00-00')? '' : $value['trspk_fakturtgl'];

				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_no']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_tgl']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_msus_no'] . ' - ' . $value['msus_nm']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_tglselesai']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_garansisp']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_garansijasa']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_mscs_no']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['mscs_nm']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $trspk_fakturtgl);
				$col +=1; $object->getActiveSheet()->setCellValueExplicitByColumnAndRow($col, $row, $value['trspk_fakturno']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['total']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['paid']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['total']-$value['paid']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['tls_ref_v_mssl_nm']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_catatan']);
				$row += 1; $col =-1; 
			}
	        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
	        //if you want to save it as .xls Excel 2007 format
	        // ob_end_clean();
	        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
	        $filename='Ringkasan SPK.xls'; //save our workbook as this file name
	        header('Content-Type: application/vnd.ms-excel'); //mime type
	        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	        header('Cache-Control: max-age=0'); //no cache 
	        //force user to download the Excel file without writing it to server's HD
	        $objWriter->save('php://output');
			
			// if($this->session->userdata('rand')){
			// 	$this->m_reporting->delete_datatemp_bayrand_tls($this->session->userdata('rand'));
			// 	unset($_SESSION['rand']);
			// }

		}
	}

	public function lp_spk_payment(){
		if(fcek_hak_akses('.HA9.')) {
			//cek status akses area

			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

			$data['judul_laporan'] = $this->input->get('judul_laporan');
			$data['lp_pbspk_tgl'] = $this->input->get('lp_pbspk_tgl');
			$data['lp_pbspk_tgl_dari'] = trim($this->input->get('lp_pbspk_tgl_dari'));
			$data['lp_pbspk_tgl_sampai'] = trim($this->input->get('lp_pbspk_tgl_sampai'));		
			$data['lp_pbspk_cair_tgl_dari'] = trim($this->input->get('lp_pbspk_cair_tgl_dari'));
			$data['lp_pbspk_cair_tgl_sampai'] = trim($this->input->get('lp_pbspk_cair_tgl_sampai'));	
			$data['lp_mscs'] = $this->input->get('lp_mscs');		
			$data['lp_mscs_no'] = substr($this->input->get('lp_mscs_no'), 0, 6);
			$data['lp_mscs_nm'] = substr($this->input->get('lp_mscs_no'), 9);		
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_fin'] = $this->input->get('lp_trju_fin');
			$data['lp_msjb'] = $this->input->get('lp_msjb');
			$data['msjb_no'] = explode(":", $this->input->get('lp_msjb_no'));
			$data['lp_msjb_no'] = trim($data['msjb_no'][0]);
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
			
			$result = $this->m_reporting->get_lp_spk_payment($data);
			

			$object = new PHPExcel();
			$object->setActiveSheetIndex(0);

			$styleArray = array(
	   					 'font'  => array('bold' => true, 'size'  => 14,'name' => 'Verdana'));

			$col = 0; $row = 0;
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "PENERIMAAN PEMBAYARAN SPK")
			->getStyle()->applyFromArray($styleArray); 
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "Search by ".$result['param']['tgl']." : ".$result['param']['tgl_dari']." - ".$result['param']['tgl_sampai']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "Cabang : ".$data['mscb_listmscb']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "F/C : ".$result['param']['trju_fin']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "Jenis Pembayaran : ".$result['param']['jenis_bayar']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Customer : ".$result['param']['mscs_no']." - ".$result['param']['mscs_nm']);
			
			// Column Header ==============================================================================================
			$row+=2; $col -=1;
			$col +=	1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "CUSTOMER ID");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "CUSTOMER NAME");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "ID SPK PAYMENT");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "TANGGAL TERIMA");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "TANGGAL CAIR");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NOTES");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "JENIS PEMBAYARAN");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "NO SPK");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "TGL SPK");
			$col += 1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, "TOTAL PEMBAYARAN");
			// End Column Header ====================================================================================================
			
			$data = $this->db->query($result['query']);
			$data = $data->result_array();	
			// echo "<pre>"; print_r($data); die();

	        $row += 1; $col =-1;
			foreach ($data as $key => $value) {	
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_mscs_no']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['mscs_nm']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['pbspk_no']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['pbspk_tglterima']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['pbspk_tglcair']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['pbspk_catatan']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['msjb_nm']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_no']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trspk_tgl']);
				$col +=1; $object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['pbspk_jlhbayar']);
				$row += 1; $col =-1; 
			}
	        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
	        //if you want to save it as .xls Excel 2007 format
	        // ob_end_clean();
	        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
	        $filename='Pembayaran SPK.xls'; //save our workbook as this file name
	        header('Content-Type: application/vnd.ms-excel'); //mime type
	        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	        header('Cache-Control: max-age=0'); //no cache 
	        //force user to download the Excel file without writing it to server's HD
	        $objWriter->save('php://output');

		}
	}

	public function lp_po(){
		if(fcek_hak_akses('.HA2.')) {
			//cek status akses area

			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

			$data['judul_laporan'] = $this->input->get('judul_laporan');		
			$data['lp_trpo_tgl_dari'] = trim($this->input->get('lp_trpo_tgl_dari'));
			$data['lp_trpo_tgl_sampai'] = trim($this->input->get('lp_trpo_tgl_sampai'));
			$data['lp_mskt'] = $this->input->get('lp_mskt');
			$data['lp_mskt_no'] = substr($this->input->get('lp_mskt_no'), 0, 1);
			$data['lp_mskt_nm'] = substr($this->input->get('lp_mskt_no'), 4);
			$data['lp_msfm'] = $this->input->get('lp_msfm');
			$data['lp_msfm_no'] = substr($this->input->get('lp_msfm_no'), 0,3);
			$data['lp_msfm_nm'] = substr($this->input->get('lp_msfm_no'), 6);
			$data['lp_msmd'] = $this->input->get('lp_msmd');
			$data['lp_msmd_no'] = substr($this->input->get('lp_msmd_no'), 0,6);
			$data['lp_msmd_nm'] = substr($this->input->get('lp_msmd_no'), 9);
			$data['lp_mspd'] = $this->input->get('lp_mspd');
			$data['lp_mspd_no_sel'] = substr($this->input->get('lp_mspd_no_sel'), 0, 9);
			$data['lp_mspd_nm'] = substr($this->input->get('lp_mspd_no_sel'), 12);	
			$data['lp_mspd_nm_con'] = $this->input->get('lp_mspd_nm_con');	
			$data['lp_mssp'] = $this->input->get('lp_mssp');
			$data['lp_mssp_no'] = substr($this->input->get('lp_mssp_no'), 0, 6);
			$data['lp_mssp_nm'] = $this->input->get('lp_mssp_no');
			$data['lp_pobystatus'] = $this->input->get('lp_pobystatus');
			$data['lp_dlvstatus'] = $this->input->get('lp_podlvstatus');
			$data['lp_lockstatus'] = $this->input->get('lp_polockstatus');
			$data['lp_po_final'] = $this->input->get('lp_po_final');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');


			$path = APPPATH.'reports\po_reports'; 

			if($data['judul_laporan'] == 'lp_wip_po'){
				$path .= '\lp_wip_po.jrxml';
			}

			if($data['judul_laporan'] == 'lp_po_list'){
				$path .= '\po_list.jrxml';
			}

			// string query hasil filter
			$result = $this->m_reporting->get_lp_po($data);	


			// Update query string yang ada di xml file
			$xml = new DOMDocument();
			$xml->load($path);
			$nodes = $xml->getElementsByTagName('queryString') ;				
			$xml->getElementsByTagName("queryString")->item(0)->nodeValue = "";
			$xml->getElementsByTagName("queryString")->item(0)->appendChild($xml->createCDATASection($result['query']));		   		   
			$xml->save($path);

			// Set parameter yang akan di kirim ke file xml
			$params = new Java("java.util.HashMap");							
			$params->put("tgl_dari", new Java('java.lang.String', $result['param']['vtrpo_tgldari']));
			$params->put("tgl_sampai", new Java('java.lang.String', $result['param']['vtrpo_tglsampai']));
			$params->put("postatus", new Java('java.lang.String', $result['param']['trpostatus']));
			$params->put("podlvstatus", new Java('java.lang.String', $result['param']['trpodlvstatus']));
			$params->put("polockstatus", new Java('java.lang.String', $result['param']['trpolockstatus']));
			$params->put("mskt_no", new Java('java.lang.String', $result['param']['vtrpo_mskt_no']));
			$params->put("mskt_nm", new Java('java.lang.String', $result['param']['vtrpo_mskt_nm']));
			$params->put("msfm_no", new Java('java.lang.String', $result['param']['vtrpo_msfm_no']));
			$params->put("msfm_nm", new Java('java.lang.String', $result['param']['vtrpo_msfm_nm']));
			$params->put("msmd_no", new Java('java.lang.String', $result['param']['vtrpo_msmd_no']));
			$params->put("msmd_nm", new Java('java.lang.String', $result['param']['vtrpo_msmd_nm']));
			$params->put("mspd_no", new Java('java.lang.String', $result['param']['vtrpo_mspd_no']));
			$params->put("mspd_nm", new Java('java.lang.String', $result['param']['vtrpo_mspd_nm']));
			$params->put("mssp_jenis", new Java('java.lang.String', $result['param']['vtrpo_mssp_jenis']));
			$params->put("mssp_nm", new Java('java.lang.String', $result['param']['vtrpo_mssp_nm']));
			$params->put("cabang", new Java('java.lang.String', $result['param']['vtrpo_mscb']));
			$params->put("fin", new Java('java.lang.String',  $result['param']['trju_fin']));
			$params->put("final", new Java('java.lang.String',  $result['param']['lp_po_final']));

			// print out report di browser
			$this->java_bridge->print_data($path, $params);	
		}
	}

	public function lp_po_excel(){
		if(fcek_hak_akses('.HA2.')) {
			//cek status akses area

			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

			$data['judul_laporan'] = $this->input->get('judul_laporan');		
			$data['lp_trpo_tgl_dari'] = $this->input->get('lp_trpo_tgl_dari');
			$data['lp_trpo_tgl_sampai'] = $this->input->get('lp_trpo_tgl_sampai');
			$data['lp_mskt'] = $this->input->get('lp_mskt');
			$data['lp_mskt_no'] = substr($this->input->get('lp_mskt_no'), 0, 1);
			$data['lp_mskt_nm'] = substr($this->input->get('lp_mskt_no'), 4);
			$data['lp_msfm'] = $this->input->get('lp_msfm');
			$data['lp_msfm_no'] = substr($this->input->get('lp_msfm_no'), 0,3);
			$data['lp_msfm_nm'] = substr($this->input->get('lp_msfm_no'), 6);
			$data['lp_msmd'] = $this->input->get('lp_msmd');
			$data['lp_msmd_no'] = substr($this->input->get('lp_msmd_no'), 0,6);
			$data['lp_msmd_nm'] = substr($this->input->get('lp_msmd_no'), 9);
			$data['lp_mspd'] = $this->input->get('lp_mspd');
			$data['lp_mspd_no_sel'] = substr($this->input->get('lp_mspd_no_sel'), 0, 9);
			$data['lp_mspd_nm'] = substr($this->input->get('lp_mspd_no_sel'), 12);	
			$data['lp_mspd_nm_con'] = $this->input->get('lp_mspd_nm_con');	
			$data['lp_mssp'] = $this->input->get('lp_mssp');
			$data['lp_mssp_no'] = substr($this->input->get('lp_mssp_no'), 0, 6);
			$data['lp_mssp_nm'] = $this->input->get('lp_mssp_no');
			$data['lp_pobystatus'] = $this->input->get('lp_pobystatus');
			$data['lp_dlvstatus'] = $this->input->get('lp_podlvstatus');
			$data['lp_lockstatus'] = $this->input->get('lp_polockstatus');
			$data['lp_po_final'] = $this->input->get('lp_po_final');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');

			// string query hasil filter
			$result = $this->m_reporting->get_lp_po($data);	
			// echo "<pre>"; print_r($result); die();


			// PHPExcel_Cell::setValueBinder(new PHPExcel_Cell_AdvancedValueBinder());
			$object = new PHPExcel();
			$object->setActiveSheetIndex(0);
			$styleArray = array(
	   					'font'  => array(
	        			'bold' => true,
	        			'size'  => 14,
	        			'name' => 'Verdana'
	    				));

			$column = 0;
			$row = 0;
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "PO LIST REPORT")
			->getStyle()->applyFromArray($styleArray);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Tgl PO  ".$result['param']['vtrpo_tgldari']." - ".$result['param']['vtrpo_tglsampai']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Kategori Produk  ".$result['param']['vtrpo_mskt_no']." - ".$result['param']['vtrpo_mskt_nm']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "PO Status : ".$result['param']['trpostatus']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Famili Produk  ".$result['param']['vtrpo_msfm_no']." - ".$result['param']['vtrpo_msfm_nm']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Incoming Delivery : ".$result['param']['trpodlvstatus']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Model Produk  ".$result['param']['vtrpo_msmd_no']." - ".$result['param']['vtrpo_msmd_nm']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "PO Payment : ".$result['param']['trpolockstatus']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Produk  ".$result['param']['vtrpo_mspd_no']." - ".$result['param']['vtrpo_mspd_nm']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Finalize Status : ".$result['param']['lp_po_final']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Supplier  ".$result['param']['vtrpo_mssp_jenis']." - ".$result['param']['vtrpo_mssp_nm']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Cabang : ".$result['param']['vtrpo_mscb']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Jenis Trans  ".$result['param']['trju_fin']);
			
			$row+=2;
			$table_colums = array('TANGGAL', 'NO PO', 'KODE SUPPLIER', 'NAMA SUPPLIER', 'CURR', 'TOTAL PO', 'TERBAYAR', 'CATATAN',
								 'PRODUK ID', 'NAMA PRODUK', 'QTY PO', 'QTY INC DLV',
								 'HARGA SATUAN', 'TOTAL');		
			foreach ($table_colums as $field) {
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
				$column += 1;
			}
		
			$data = $this->db->query($result['query']);
			$data = $data->result_array();		
			
			$row += 1;

			$no_prev="";
			foreach ($data as $key => $value) {	
			//print header tr_po
			if($no_prev != $value['dtpo_no']){	
				$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['trpo_tgl']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['dtpo_no']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['mssp_no']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['mssp_nm']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $value['trpo_curr']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['trpo_total']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $value['trpo_terbayar']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $value['trpo_catatan']);
			$no_prev = $value['dtpo_no'];
			}
				$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $value['dtpo_mspd_no']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(9, $row, $value['mspd_nm']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(10, $row, $value['dtpo_qty']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(11, $row, $value['dtpo_qtyterima']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(12, $row, $value['dtpo_nett']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(13, $row, $value['dtpo_nett']*$value['dtpo_qtyterima']);
				$row += 1;
			}
	      
	        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
	        //if you want to save it as .xls Excel 2007 format
	        // ob_end_clean();
	        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
	        $filename='PO LIST.xls'; //save our workbook as this file name
	        header('Content-Type: application/vnd.ms-excel'); //mime type
	        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	        header('Cache-Control: max-age=0'); //no cache 
	        //force user to download the Excel file without writing it to server's HD
	        $objWriter->save('php://output');
		}
	}

	public function lp_po_final(){
		if(fcek_hak_akses('.HA2.')) {
			//cek status akses area

			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

			$data['judul_laporan'] = $this->input->get('judul_laporan');		
			$data['lp_trpo_tgl_dari'] = $this->input->get('lp_tgldari');
			$data['lp_trpo_tgl_sampai'] = $this->input->get('lp_tglsampai');
			$data['lp_mssp'] = $this->input->get('lp_mssp');
			$data['lp_mssp_no'] = substr($this->input->get('lp_mssp_no'), 0, 6);
			$data['lp_mssp_nm'] = $this->input->get('lp_mssp_no');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');

			$path = APPPATH.'reports\po_reports\po_final.jrxml'; 

			// string query hasil filter
			$result = $this->m_reporting->get_lp_po_final($data);	

			// Update query string yang ada di xml file
			$xml = new DOMDocument();
			$xml->load($path);
			$nodes = $xml->getElementsByTagName('queryString') ;				
			$xml->getElementsByTagName("queryString")->item(0)->nodeValue = "";
			$xml->getElementsByTagName("queryString")->item(0)->appendChild($xml->createCDATASection($result['query']));		   		   
			$xml->save($path);

			// Set parameter yang akan di kirim ke file xml
			$params = new Java("java.util.HashMap");							
			$params->put("tgl_dari", new Java('java.lang.String', $result['param']['vtrpo_tgldari']));
			$params->put("tgl_sampai", new Java('java.lang.String', $result['param']['vtrpo_tglsampai']));
			$params->put("mssp_nm", new Java('java.lang.String', $result['param']['vtrpo_mssp_nm']));
			$params->put("cabang", new Java('java.lang.String', $result['param']['vtrpo_mscb']));
			$params->put("fin", new Java('java.lang.String', $result['param']['trju_fin']));

			// print out report di browser
			$this->java_bridge->print_data($path, $params);	
		}
	}
	
	public function lp_pr(){
		if(fcek_hak_akses('.HA2.')) {
			//cek status akses area
			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			$data['judul_laporan'] = $this->input->get('judul_laporan');		
			$data['lp_trpr_tgl_dari'] = trim($this->input->get('lp_trpr_tgl_dari')).' 00:00:00';
			$data['lp_trpr_tgl_sampai'] = trim($this->input->get('lp_trpr_tgl_sampai')).' 23:59:59';		
			$data['lp_mskt'] = $this->input->get('lp_mskt');
			$data['lp_mskt_no'] = substr($this->input->get('lp_mskt_no'), 0, 1);
			$data['lp_mskt_nm'] = substr($this->input->get('lp_mskt_no'), 4);
			$data['lp_msfm'] = $this->input->get('lp_msfm');
			$data['lp_msfm_no'] = substr($this->input->get('lp_msfm_no'), 0,3);
			$data['lp_msfm_nm'] = substr($this->input->get('lp_msfm_no'), 6);
			$data['lp_msmd'] = $this->input->get('lp_msmd');
			$data['lp_msmd_no'] = substr($this->input->get('lp_msmd_no'), 0,6);
			$data['lp_msmd_nm'] = substr($this->input->get('lp_msmd_no'), 9);
			$data['lp_mspd'] = $this->input->get('lp_mspd');
			$data['lp_mspd_no_sel'] = substr($this->input->get('lp_mspd_no_sel'), 0, 9);
			$data['lp_mspd_nm'] = substr($this->input->get('lp_mspd_no_sel'), 12);	
			$data['lp_mspd_nm_con'] = $this->input->get('lp_mspd_nm_con');		
			$data['lp_mssp'] = $this->input->get('lp_mssp');
			$data['lp_mssp_no'] = substr($this->input->get('lp_mssp_no'), 0, 6);
			$data['lp_mssp_nm'] = $this->input->get('lp_mssp_no');
			$data['lp_trprbystatus'] = $this->input->get('lp_trprbystatus');
			$data['lp_trprbypostatus'] = $this->input->get('lp_trprbypostatus');
			$data['lp_trpr_sortby'] = $this->input->get('lp_trpr_sortby');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');

			$path = APPPATH.'reports\pr_reports';

			if($data['judul_laporan'] == 'lp_pr_status'){	
				$path .= '\lp_pr_status.jrxml';
			}
			
			// string query hasil filter
			$result = $this->m_reporting->get_lp_pr($data);
			
					// Update query string yang ada di xml file
			$xml = new DOMDocument();
			$xml->load($path);
			$nodes = $xml->getElementsByTagName('queryString') ;				
			$xml->getElementsByTagName("queryString")->item(0)->nodeValue = "";
			$xml->getElementsByTagName("queryString")->item(0)->appendChild($xml->createCDATASection($result['query']));		   		   
			$xml->save($path);


			// Set parameter yang akan di kirim ke fele xml
			$params = new Java("java.util.HashMap");							
			$params->put("tgl_dari", new Java('java.lang.String', $result['param']['vtrpr_tgldari']));
			$params->put("tgl_sampai", new Java('java.lang.String', $result['param']['vtrpr_tglsampai']));
			$params->put("status_apv", new Java('java.lang.String', $result['param']['trprstatus']));
			$params->put("status_po", new Java('java.lang.String', $result['param']['trprbypostatus']));
			$params->put("mskt_no", new Java('java.lang.String', $result['param']['vtrpr_mskt_no']));
			$params->put("mskt_nm", new Java('java.lang.String', $result['param']['vtrpr_mskt_nm']));
			$params->put("msfm_no", new Java('java.lang.String', $result['param']['vtrpr_msfm_no']));
			$params->put("msfm_nm", new Java('java.lang.String', $result['param']['vtrpr_msfm_nm']));
			$params->put("msmd_no", new Java('java.lang.String', $result['param']['vtrpr_msmd_no']));
			$params->put("msmd_nm", new Java('java.lang.String', $result['param']['vtrpr_msmd_nm']));
			$params->put("mspd_no", new Java('java.lang.String', $result['param']['vtrpr_mspd_no']));
			$params->put("mspd_nm", new Java('java.lang.String', $result['param']['vtrpr_mspd_nm']));
			$params->put("mssp_jenis", new Java('java.lang.String', $result['param']['mssp_jenis']));
			$params->put("mssp_nm", new Java('java.lang.String', $result['param']['mssp_nm']));
			$params->put("cabang", new Java('java.lang.String', $result['param']['vtrpr_mscb']));

			// print out report di browser
			$this->java_bridge->print_data($path, $params);
		}
	}

	public function need_order(){
		if(fcek_hak_akses('.HA2.')) {
			$data['lp_mskt'] = $this->input->get('lp_mskt');
			$data['lp_mskt_no'] = substr($this->input->get('lp_mskt_no'), 0, 1);
			$data['lp_mskt_nm'] = substr($this->input->get('lp_mskt_no'), 4);
			$data['lp_msfm'] = $this->input->get('lp_msfm');
			$data['lp_msfm_no'] = substr($this->input->get('lp_msfm_no'), 0,3);
			$data['lp_msfm_nm'] = substr($this->input->get('lp_msfm_no'), 6);
			$data['lp_msmd'] = $this->input->get('lp_msmd');
			$data['lp_msmd_no'] = substr($this->input->get('lp_msmd_no'), 0,6);
			$data['lp_msmd_nm'] = substr($this->input->get('lp_msmd_no'), 9);
			$data['lp_mspd'] = $this->input->get('lp_mspd');
			$data['lp_mspd_no_sel'] = substr($this->input->get('lp_mspd_no_sel'), 0, 9);
			$data['lp_mspd_nm'] = substr($this->input->get('lp_mspd_no_sel'), 12);	
			$data['lp_mspd_nm_con'] = $this->input->get('lp_mspd_nm_con');		
			$data['lp_mssp'] = $this->input->get('lp_mssp');
			$data['lp_mssp_no'] = substr($this->input->get('lp_mssp_no'), 0, 6);
			$data['lp_mssp_nm'] = $this->input->get('lp_mssp_no');
			$data['lp_msmr'] = $this->input->get('lp_msmr');
			$msmr = explode("-", $this->input->get('lp_msmr_no'));
			$msmr_no = trim($msmr[0]);
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
			$data['lp_mspd_paket'] = $this->input->get('lp_mspd_paket');
			
			$arr_filter = array();
			//filter mspd no					);
			if($data['lp_mspd'] != 'lp_mspd_all'){
				if($data['lp_mspd'] == 'lp_mspd_sel'){
					$arr_filter['mspd_no'] = $data['lp_mspd_no_sel'];
					$p_mspd_no = $data['lp_mspd_no_sel'];
				} else if ($data['lp_mspd'] == 'lp_mspd_con'){
					$arr_filter['mspd_nm'] = $data['lp_mspd_nm_con'];
					$p_mspd_no = $data['lp_mspd_nm_con'];
				} 
			} else {
					$p_mspd_no = 'ALL';
				}

			//filter mskt no					);
			if($data['lp_mskt'] != 'lp_mskt_all'){
				$arr_filter['mskt_no'] = $data['lp_mskt_no'];
				$p_mskt_no = $data['lp_mskt_no'];
			} else {
				$p_mskt_no = 'ALL';
			}

			//filter msfm no					);
			if($data['lp_msfm'] != 'lp_msfm_all'){
				$arr_filter['msfm_no'] = $data['lp_msfm_no'];
				$p_msfm_no = $data['lp_msfm_no'];
			} else {
				$p_msfm_no = 'ALL';
			}

			//filter msmd no					);
			if($data['lp_msmd'] != 'lp_msmd_all'){
				$arr_filter['msmd_no'] = $data['lp_msmd_no'];
				$p_msmd_no = $data['lp_msmd_no'];
			} else {
				$p_msmd_no = 'ALL';
			}

			//filter msmr no					);
			if($data['lp_msmr'] != 'lp_msmr_all'){
				$arr_filter['msmr_no'] = $msmr_no;
				$p_msmr_no = $msmr_no;
			} else {
				$p_msmr_no = 'ALL';
			}

			// filter by mssp (supplier)
			if($data['lp_mssp'] != 'lp_mssp_all'){
				if ($data['lp_mssp'] == 'lp_mssp_lokal') {
					$arr_filter['mssp_jenis'] = substr(($data['lp_mssp_no']),0,1);
					$p_mssp_no = 'Lokal';
				} else if ($data['lp_mssp'] == 'lp_mssp_import') {
					$arr_filter['mssp_jenis'] = substr(($data['lp_mssp_no']),0,1);
					$p_mssp_no = 'Import';
				} else {
					($data['lp_mssp'] == 'lp_mssp_sel');
					$arr_filter['mssp_no'] = $data['lp_mssp_no'];
					$p_mssp_no = $data['lp_mssp_nm'];
				} 
			} else {
					$p_mssp_no ='ALL';
				}

			//filter package product 
			if($data['lp_mspd_paket'] != 'lp_mspd_paket_all'){
				$arr_filter['mspd_paket'] = $data['lp_mspd_paket'];
				$p_mspd_paket = $data['lp_mspd_paket'];
			} else {
				$p_mspd_paket = 'ALL';
			}

			//filter mspd_fin/commercial
			if($data['lp_trju_fin'] != 'lp_trju_fin_all'){
				$arr_filter['mspd_fin'] = $data['lp_trju_fin'];
				$p_trju_fin = $data['lp_trju_fin'];
			} else {
				$p_trju_fin = 'ALL';
			}

			//get query from model inventory
			$q = $this->m_inventory->get_needtoorderitem_list($arr_filter, array(),false,0,0, 'mspd_no', 'ASC');

			
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);

				$styleArray = array(
		   					 'font'  => array(
		        			'bold' => true,
		        			'size'  => 14,
		        			'name' => 'Verdana'
		    				));

				$column = 0;
				$row = 0;
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "NEED TO ORDER ITEM")
				->getStyle()->applyFromArray($styleArray); 
				//parameter filter
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Kategori : ".$p_mskt_no);
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Family : ".$p_msfm_no);
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Model : ".$p_msmd_no);
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Produk : ".$p_mspd_no);
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Supplier : ".$p_mssp_no);
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Merk : ".$p_msmr_no);
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "product package : ".$p_mspd_paket);
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Fin/Co : ".$p_trju_fin);
			 
				$row+=2;
				$column=-1;
				foreach ($q[0] as $judul => $vjudul) {
					$column+=1;
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $judul);
				}

				
				foreach ($q as $key => $value) {			
					$row+=1;
					$column=-1;

					foreach ($q[0] as $judul => $vjudul) {
						$column+=1;
						$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $value[$judul]);
					}
				}
		
			//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
	        //if you want to save it as .xls Excel 2007 format
			// ob_end_clean();
	        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
	        $filename='list_needtoorder.xls'; //save our workbook as this file name
	        header('Content-Type: application/vnd.ms-excel'); //mime type
	        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	        header('Cache-Control: max-age=0'); //no cache 
	        //force user to download the Excel file without writing it to server's HD
	        $objWriter->save('php://output');	
		}
	}

	public function lp_mutasi(){
		if(fcek_hak_akses('.HA3.')) {
			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

			$data['judul_laporan'] = $this->input->get('judul_laporan');
			$data['lp_trmt_tgl_dari'] = $this->input->get('lp_tgldari').' 00:00:00';
			$data['lp_trmt_tgl_sampai'] = $this->input->get('lp_tglsampai').' 23:59:59';
			$data['lp_trmt_tglkirim_dari'] = $this->input->get('lp_trmt_tglkirim_dari').' 00:00:00';
			$data['lp_trmt_tglkirim_sampai'] = $this->input->get('lp_trmt_tglkirim_sampai').' 23:59:59';
			$data['lp_trmt_tglterima_dari'] = $this->input->get('lp_trmt_tglterima_dari').' 00:00:00';
			$data['lp_trmt_tglterima_sampai'] = $this->input->get('lp_trmt_tglterima_sampai').' 23:59:59';
			$data['lp_mutasi'] = $this->input->get('lp_mutasi');
			$data['lp_mskt'] = $this->input->get('lp_mskt');
			$data['lp_mskt_no'] = substr($this->input->get('lp_mskt_no'), 0, 1);
			$data['lp_mskt_nm'] = substr($this->input->get('lp_mskt_no'), 4);
			$data['lp_msfm'] = $this->input->get('lp_msfm');
			$data['lp_msfm_no'] = substr($this->input->get('lp_msfm_no'), 0,3);
			$data['lp_msfm_nm'] = substr($this->input->get('lp_msfm_no'), 6);
			$data['lp_msmd'] = $this->input->get('lp_msmd');
			$data['lp_msmd_no'] = substr($this->input->get('lp_msmd_no'), 0,6);
			$data['lp_msmd_nm'] = substr($this->input->get('lp_msmd_no'), 9);
			$data['lp_mspd'] = $this->input->get('lp_mspd');
			$data['lp_mspd_no_sel'] = substr($this->input->get('lp_mspd_no_sel'), 0, 9);
			$data['lp_mspd_nm'] = substr($this->input->get('lp_mspd_no_sel'), 12);	
			$data['lp_mspd_nm_con'] = $this->input->get('lp_mspd_nm_con');		
			$data['lp_trmt_msgd'] = $this->input->get('lp_trmt_msgd');
			$data['lp_trmt_msgd_no1'] = $this->input->get('lp_trmt_msgd_no1');
			$data['lp_trmt_msgd_no2'] = $this->input->get('lp_trmt_msgd_no2');	
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			
			$path = APPPATH.'reports\mutasi_reports';

			if($data['judul_laporan'] == 'lp_mutasi_list_detail'){	
				$path .= '\lp_mutasibyid_list.jrxml';
			}

			// string query hasil filter
			$result = $this->m_reporting->get_lp_mutasi_query($data);
			
			// Update query string yang ada di xml file
			$xml = new DOMDocument();
			$xml->load($path);
			$nodes = $xml->getElementsByTagName('queryString') ;				
			$xml->getElementsByTagName("queryString")->item(0)->nodeValue = "";
			$xml->getElementsByTagName("queryString")->item(0)->appendChild($xml->createCDATASection($result['query']));		   		   
			$xml->save($path);

			// Set parameter yang akan di kirim ke file xml
			$params = new Java("java.util.HashMap");						
			$params->put("periode",new Java('java.lang.String', $result['param']['vtrmt_tgldari']));
			$params->put("periode_akhir",new Java('java.lang.String', $result['param']['vtrmt_tglsampai']));
			$params->put("tglkirimdari",new Java('java.lang.String', $result['param']['vtrmt_tglkirimdari']));		
			$params->put("tglkirimsampai",new Java('java.lang.String', $result['param']['vtrmt_tglkirimsampai']));
			$params->put("tglterimadari",new Java('java.lang.String', $result['param']['vtrmt_tglterimadari']));		
			$params->put("tglterimasampai",new Java('java.lang.String', $result['param']['vtrmt_tglterimasampai']));
			$params->put("mskt_no", new Java('java.lang.String', $result['param']['vtrmt_mskt_no']));
			$params->put("mskt_nm", new Java('java.lang.String', $result['param']['vtrmt_mskt_nm']));
			$params->put("msfm_no", new Java('java.lang.String', $result['param']['vtrmt_msfm_no']));
			$params->put("msfm_nm", new Java('java.lang.String', $result['param']['vtrmt_msfm_nm']));
			$params->put("msmd_no", new Java('java.lang.String', $result['param']['vtrmt_msmd_no']));
			$params->put("msmd_nm", new Java('java.lang.String', $result['param']['vtrmt_msmd_nm']));
			$params->put("mspd_no", new Java('java.lang.String', $result['param']['vtrmt_mspd_no']));
			$params->put("mspd_nm", new Java('java.lang.String', $result['param']['vtrmt_mspd_nm']));
			$params->put("trmt_inout", new Java('java.lang.String', $result['param']['vtrmt_inout']));
			$params->put("cabang", new Java('java.lang.String', $result['param']['vtrmt_mscb']));

			// print out report di browser
			$this->java_bridge->print_data($path, $params);	
		}
	}

	public function lp_list_produk(){
	if(fcek_hak_akses('.HA3.|.HA6.')) {
		if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

		$data['judul_laporan'] = $this->input->get('judul_laporan');
		$data['lp_mskt'] = $this->input->get('lp_mskt');
		$data['lp_mskt_no'] = substr($this->input->get('lp_mskt_no'), 0, 1);
		$data['lp_mskt_nm'] = substr($this->input->get('lp_mskt_no'), 4);
		$data['lp_msfm'] = $this->input->get('lp_msfm');
		$data['lp_msfm_no'] = substr($this->input->get('lp_msfm_no'), 0,3);
		$data['lp_msfm_nm'] = substr($this->input->get('lp_msfm_no'), 6);
		$data['lp_msmd'] = $this->input->get('lp_msmd');
		$data['lp_msmd_no'] = substr($this->input->get('lp_msmd_no'), 0,6);
		$data['lp_msmd_nm'] = substr($this->input->get('lp_msmd_no'), 9);
		$data['lp_mspd'] = $this->input->get('lp_mspd');
		$data['lp_mspd_no_sel'] = substr($this->input->get('lp_mspd_no_sel'), 0, 9);
		$data['lp_mspd_nm'] = substr($this->input->get('lp_mspd_no_sel'), 12);	
		$data['lp_mspd_nm_con'] = $this->input->get('lp_mspd_nm_con');		
		$data['lp_mssp'] = $this->input->get('lp_mssp');
		$data['lp_mssp_no'] = substr($this->input->get('lp_mssp_no'), 0, 6);
		$data['lp_mssp_nm'] = $this->input->get('lp_mssp_no');			
		$data['lp_fin'] = $this->input->get('lp_trju_fin');
		$data['lp_msmr'] = $this->input->get('lp_msmr');
		$msmr = explode("-", $this->input->get('lp_msmr_no'));
		$msmr_no = trim($msmr[0]);
		$data['lp_mspd_paket'] = $this->input->get('lp_mspd_paket');
		$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
		$data['mspd_aktif'] = $this->input->get('mspd_aktif');

		if($data['judul_laporan'] == "lp_list_produk_harga"){
			$show_harga = "Y";
		} else $show_harga = "N";

		$query = 'Select mspd.*, mskt_nm, msfm_nm, msmd_nm, msmr_nm, mskt_statusinv, mssp_nm, mskt_showinspk
					FROM ms_produk mspd
					LEFT JOIN ms_kategori on mskt_no = substring(mspd_no,1,1)
					LEFT JOIN ms_famili on msfm_no = SUBSTRING(mspd_no,1,3)
					LEFT JOIN ms_model on msmd_no = SUBSTRING(mspd_no,1,6)
					LEFT JOIN ms_merk ON msmr_no = mspd_msmr_no
					LEFT JOIN ms_supplier on mssp_no = mspd_mssp_no					
					WHERE (mspd_no != "") ';
		
		if(count($this->input->get('mscb_listmscb'))>0){
			$tempquery = ' AND (';
			foreach($this->input->get('mscb_listmscb') as $key => $value){
				$tempquery .= 'mspd_listmscb like "%.'.$value.'.%"';
				if($key + 1 < count($this->input->get('mscb_listmscb'))){
					$tempquery .= ' OR ';
				}
			}
			$tempquery .= ') ';

			// var_dump($tempquery); die();
		}

		//filter by mskt_no
		if($data['lp_mskt'] != 'lp_mskt_all'){
			$query .= ' and SUBSTRING(mspd.mspd_no,1,1)="'.$data['lp_mskt_no'].'"';
			$mskt_no = $data['lp_mskt_no'];
			$mskt_nm = $data['lp_mskt_nm'];
			} else{
				$mskt_no = 'ALL';
				$mskt_nm = 'ALL';
			}

		// filter by msfm_no
		if($data['lp_msfm'] != 'lp_msfm_all'){
			$query .= ' and SUBSTRING(mspd.mspd_no,1,3)="'.$data['lp_msfm_no'].'"';
			$msfm_no = $data['lp_msfm_no'];
			$msfm_nm = $data['lp_msfm_nm'];
			} else {
				$msfm_no = 'ALL';
				$msfm_nm = 'ALL';
			}

		// filter by msmd_no
		if($data['lp_msmd'] != 'lp_msmd_all'){
			$query .= ' and SUBSTRING(mspd.mspd_no,1,6)="'. $data['lp_msmd_no']. '"';
			$msmd_no = $data['lp_msmd_no'];
			$msmd_nm = $data['lp_msmd_nm'];
			} else {
				$msmd_no = 'ALL';
				$msmd_nm = 'ALL';
			}

		// filter by mspd_no
		if($data['lp_mspd'] != 'lp_mspd_all'){
			if ($data['lp_mspd'] == 'lp_mspd_sel') {
				$query .= ' and mspd.mspd_no = "'. $data['lp_mspd_no_sel']. '"';
				$mspd_no = $data['lp_mspd_no_sel'];
				$mspd_nm = $data['lp_mspd_nm'];	
			} elseif ($data['lp_mspd'] == 'lp_mspd_con'){
				$query .= ' and mspd.mspd_nm LIKE "%'. $data['lp_mspd_nm_con']. '%"';
				$mspd_no = $data['lp_mspd_nm_con'];
				$mspd_nm = $data['lp_mspd_nm_con'];
			}
		} else{
			$mspd_no = 'ALL';
			$mspd_nm = 'ALL';
		}

		//filter msmr no					);
			if($data['lp_msmr'] != 'lp_msmr_all'){
				$query .= ' and mspd.mspd_msmr_no = "'.$msmr_no.'"';
				$msmr_no = $msmr_no;
			} else {
				$msmr_no = 'ALL';
			}
		
		// filter by mssp (supplier)
		if($data['lp_mssp'] != 'lp_mssp_all'){
			if ($data['lp_mssp'] == 'lp_mssp_lokal') {
				$query .= ' and mssp_jenis="L"';
				$mssp_no = 'Lokal';
				$mssp_nm ='';
			} else if ($data['lp_mssp'] == 'lp_mssp_import') {
				$query .= ' and mssp_jenis="I"';
				$mssp_no = 'Import';
				$mssp_nm ='';
			} else if ($data['lp_mssp'] == 'lp_mssp_sel'){
				$query .= ' and mssp_no = "'. $data['lp_mssp_no']. '"';
				$mssp_no = '';
				$mssp_nm = $data['lp_mssp_nm'];
			} 
		} else {
				$mssp_no ='ALL';
				$mssp_nm ='ALL';	
			}
		
		//filter Paket produk
		if($data['lp_mspd_paket'] != 'lp_mspd_paket_all'){
			$query .= ' AND mspd.mspd_paket = "'.$data['lp_mspd_paket'].'"';
			$mspd_paket = $data['lp_mspd_paket'];
		} else {
			$mspd_paket = 'ALL';
		}

		//filter mspd_fin/commercial
		if($data['lp_fin'] != 'lp_trju_fin_all'){
			$query .= ' AND mspd.mspd_fin = "'.$data['lp_fin'].'"';
			$trju_fin = $data['lp_fin'];
		} else {
			$trju_fin = 'ALL';
		}

		//filter mspd aktif/non aktif
		if($data['mspd_aktif'] != 'mspd_aktif_all'){
			if($data['mspd_aktif'] == 1){
				$query .= ' and mspd.mspd_aktif=1';
				$mspd_aktif = "Aktif";
			}elseif ($data['mspd_aktif']==0) {
				$query .= ' and mspd_aktif=0';
				$mspd_aktif = "Non-Aktif";
			}
		} else {
			$mspd_aktif = 'ALL';
		}

		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);

		$styleArray = array(
   					 'font'  => array(
        			'bold' => true,
        			'size'  => 14,
        			'name' => 'Verdana'
    				));

		$column = 0;
		$row = 0;
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "LIST PRODUK")
		->getStyle()->applyFromArray($styleArray); 
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Cabang : ".$data['mscb_listmscb']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Kategori : ".$mskt_no." - ".$mskt_nm);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Supplier : ".$mssp_no." - ".$mssp_nm);
		$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Family : ".$msfm_no." - ".$msfm_nm);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Merk : ".$msmr_no);
		$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Model : ".$msmd_no." - ".$msmd_nm);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Product package : ".$mspd_paket);
		$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Produk : ".$mspd_no." - ".$mspd_nm);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Jenis Data Jurnal : ".$trju_fin);
		$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Produk Aktif: ".$mspd_aktif);
		
		$row+=2;
		if($show_harga == "Y"){
			$table_colums = array('Produk', 'Kategori', 'Family', 'Model', 'Nama Produk', 'Brand', 'Supplier', 'Currency',
									'HPP','Price List', 'Fin', 'Invetoriable', 'Show in SPK', 'Package', 'ROP', 'Unit Scale',
									'Dimention', 'Weight', 'Serial Number', 'S/P Warranty', 'Service Warranty', 'Tag', 'Area', 'Active', 'Catatan');
		} else{
			$table_colums = array('Produk', 'Kategori', 'Family', 'Model', 'Nama Produk', 'Brand', 'Supplier', 'Currency',
								'','', 'Fin', 'Invetoriable', 'Show in SPK', 'Package', 'ROP', 'Unit Scale',
								'Dimention', 'Weight', 'Serial Number', 'S/P Warranty', 'Service Warranty', 'Tag', 'Area', 'Active', 'Catatan');
		}
		foreach ($table_colums as $field) {
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
			$column += 1;
		}

		$data = $this->db->query($query);
		$data = $data->result_array();		

		$row += 1;

		foreach ($data as $key => $value) {			
			$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['mspd_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['mskt_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['msfm_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['msmd_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $value['mspd_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['msmr_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $value['mssp_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $value['mspd_curr']);
			if ($show_harga =="Y"){
				$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $value['mspd_hpp']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(9, $row, $value['mspd_pricelist']);
			}
			$object->getActiveSheet()->setCellValueByColumnAndRow(10, $row, $value['mspd_fin']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(11, $row, $value['mskt_statusinv']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(12, $row, $value['mskt_showinspk']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(13, $row, $value['mspd_paket']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(14, $row, $value['mspd_rop']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(15, $row, $value['mspd_satuan']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(16, $row, $value['mspd_dimensi']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(17, $row, $value['mspd_berat']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(18, $row, $value['mspd_reqserialno']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(19, $row, $value['mspd_garansisp']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(20, $row, $value['mspd_garansijasa']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(21, $row, $value['mspd_tag']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(22, $row, $value['mspd_listmscb']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(23, $row, $value['mspd_aktif']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(24, $row, $value['mspd_catatan']);
			$row += 1;
		}
      
        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
        //if you want to save it as .xls Excel 2007 format
        // ob_end_clean();
        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
        $filename='list_produk.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache 
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');
		}
	}

	public function lp_kartustok(){
	if(fcek_hak_akses('.HA3.|.HA6.')) {
		if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

		if($this->session->userdata('rand')){
			$this->m_reporting->delete_datatemp_bayrand($this->session->userdata('rand'));
			unset($_SESSION['rand']);
		}

		$this->session->set_userdata('rand',rand());
		$data['tmplks_idlap'] = $this->session->userdata('rand');
		$data['judul_laporan'] = $this->input->get('judul_laporan');
		$data['tmplks_mspd_no'] = substr($this->input->get('lp_mspd_no_sel'), 0, 9);
		$data['tmplks_tgldari'] = trim($this->input->get('lp_tgldari'));
		$data['tmplks_tglsampai'] = trim($this->input->get('lp_tglsampai'));
		$data['tmplks_msgd'] = $this->input->get('lp_msgd');
		$data['tmplks_msgd_no'] = $this->input->get('lp_msgd_no');
		$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
		$show_harga="";
		// echo "<pre>"; print_r($data); die();

		if($data['judul_laporan'] == "lp_kartustok"){
			$show_harga = "N";
		}elseif ($data['judul_laporan'] == "lp_kartustok_harga") {
			$show_harga = "Y";
		}else $show_harga = "N";
			
		
		$path = APPPATH.'reports\mutasi_reports\lp_kartustok.jrxml';

		$this->m_reporting->insertto_tmp_lap_kartustock($data);					
		$result = $this->m_reporting->get_lp_kartustok_query($data);				
		// die($result['query']);
		// Update query string yang ada di xml file
			$xml = new DOMDocument();
			$xml->load($path);
			$nodes = $xml->getElementsByTagName('queryString') ;				
			$xml->getElementsByTagName("queryString")->item(0)->nodeValue = "";
			$xml->getElementsByTagName("queryString")->item(0)->appendChild($xml->createCDATASection($result['query']));		   		   
			$xml->save($path);

			// Set parameter yang akan di kirim ke file xml
			$params = new Java("java.util.HashMap");						
			$params->put("tmplks_tgldari",new Java('java.lang.String', $result['param']['tmplks_tgldari']));
			$params->put("tmplks_tglsampai",new Java('java.lang.String', $result['param']['tmplks_tglsampai']));
			$params->put("tmplks_msgd_no",new Java('java.lang.String', $result['param']['tmplks_msgd_no']));		
			$params->put("tmplks_mscb_nm",new Java('java.lang.String', $result['param']['tmplks_mscb_nm']));
			$params->put("stok_awal",new Java('java.lang.Double', $result['param']['stok_awal']));		
			$params->put("show_harga",new Java('java.lang.String', $show_harga));	
			// echo "<pre>"; print_r($result); die();
			// print out report di browser
			$this->java_bridge->print_data($path, $params);	

		if($this->session->userdata('rand')){
			$this->m_reporting->delete_datatemp_bayrand($this->session->userdata('rand'));
			unset($_SESSION['rand']);
			}
		}
	}

	public function lp_kartustok_excel(){
	if(fcek_hak_akses('.HA3.|.HA6.')) {
		if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

		if($this->session->userdata('rand')){
			$this->m_reporting->delete_datatemp_bayrand($this->session->userdata('rand'));
			unset($_SESSION['rand']);
		}

		$this->session->set_userdata('rand',rand());
		$data['tmplks_idlap'] = $this->session->userdata('rand');
		$data['judul_laporan'] = $this->input->get('judul_laporan');
		$data['tmplks_mspd_no'] = substr($this->input->get('lp_mspd_no_sel'), 0, 9);
		$data['tmplks_tgldari'] = $this->input->get('lp_tgldari');
		$data['tmplks_tglsampai'] = $this->input->get('lp_tglsampai');
		$data['tmplks_msgd'] = $this->input->get('lp_msgd');
		$data['tmplks_msgd_no'] = $this->input->get('lp_msgd_no');
		$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
		$show_harga="";
		// echo "<pre>"; print_r($data); die();

		if($data['judul_laporan'] == "lp_kartustok"){
			$show_harga = "N";
		}elseif ($data['judul_laporan'] == "lp_kartustok_harga") {
			$show_harga = "Y";
		}else $show_harga = "N";

		$this->m_reporting->delete_datatemp_bayrand($this->session->userdata('rand'));
		$this->m_reporting->insertto_tmp_lap_kartustock($data);					
		$result = $this->m_reporting->get_lp_kartustok_query($data);				
		// die($result['query']);

		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);

		$styleArray = array(
   					'font'  => array(
        			'bold' => true,
        			'size'  => 14,
        			'name' => 'Verdana'
    				));

		$column = 0;
		$row = 0;
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "LAPORAN KARTU STOK")
		->getStyle()->applyFromArray($styleArray);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Produk : ".$data['tmplks_mspd_no']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, "Cabang : ".$data['mscb_listmscb']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Tanggal ".$result['param']['tmplks_tgldari']." s/d ".$result['param']['tmplks_tglsampai']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, "Gudang : ".$result['param']['tmplks_msgd_no']);
		$row +=2;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Stok Awal : ".$result['param']['stok_awal']);
		
		$row+=2;
		if($show_harga =="Y"){
			$table_colums = array('TANGGAL', 'TRANSAKSI', 'HARGA', 'GUDANG', 'QTY IN', 'QTY OUT');	
			} else {
				$table_colums = array('TANGGAL', 'TRANSAKSI', '', 'GUDANG', 'QTY IN', 'QTY OUT');	
			
			}	
		foreach ($table_colums as $field) {
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
			$column += 1;
		}

		$data = $this->db->query($result['query']);
		$data = $data->result_array();
		// echo "<pre>"; print_r($data); die();		

		$row += 1;	
		foreach ($data as $key => $value) {	
		// die($value["tmplks_tgl"]);		
			$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['tmplks_tgl']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['tmplks_ket']);
			if($show_harga == "Y"){
				$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['tmplks_harga']);
			}
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['msgd_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $value['tmplks_qtyin']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['tmplks_qtyout']);
			$row += 1;
		}

      
        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
        //if you want to save it as .xls Excel 2007 format
        // ob_end_clean();
        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
        $filename='kartu stok.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache 
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');

        //delete data pada tmp_lap_kartustok
        if($this->session->userdata('rand')){
			$this->m_reporting->delete_datatemp_bayrand($this->session->userdata('rand'));
			unset($_SESSION['rand']);
			}
		}
	}

	public function lp_inventory_list(){
		if(fcek_hak_akses('.HA3.|.HA6.')) {
			$data['judul'] = $this->input->get('judul_laporan');
			$data['lp_mskt'] = $this->input->get('lp_mskt');
			$data['lp_mskt_no'] = substr($this->input->get('lp_mskt_no'), 0, 1);
			$data['lp_mskt_nm'] = substr($this->input->get('lp_mskt_no'), 4);
			$data['lp_msfm'] = $this->input->get('lp_msfm');
			$data['lp_msfm_no'] = substr($this->input->get('lp_msfm_no'), 0,3);
			$data['lp_msfm_nm'] = substr($this->input->get('lp_msfm_no'), 6);
			$data['lp_msmd'] = $this->input->get('lp_msmd');
			$data['lp_msmd_no'] = substr($this->input->get('lp_msmd_no'), 0,6);
			$data['lp_msmd_nm'] = substr($this->input->get('lp_msmd_no'), 9);
			$data['lp_mspd'] = $this->input->get('lp_mspd');
			$data['lp_mspd_no_sel'] = substr($this->input->get('lp_mspd_no_sel'), 0, 9);
			$data['lp_mspd_nm'] = substr($this->input->get('lp_mspd_no_sel'), 12);	
			$data['lp_mspd_nm_con'] = $this->input->get('lp_mspd_nm_con');		
			$data['lp_msmr'] = $this->input->get('lp_msmr');
			$msmr = explode("-", $this->input->get('lp_msmr_no'));
			$msmr_no = trim($msmr[0]);
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
			$data['lp_mspd_paket'] = $this->input->get('lp_mspd_paket');
			$data['mspd_aktif'] = $this->input->get('mspd_aktif');
			
			$arr_filter = array('nlimit' => 0,);
			if($data['judul'] == "lp_inventory_list"){
				$arr_filter['menu']	= 'INV_REPORT';
				$title = "INVENTORY LIST";
			}else{
				$arr_filter['menu']	= 'INV_REPORT_ADMIN';
				$title = "INVENTORY LIST (DENGAN HPP & PRICELIST)";
			}
			
			//filter produk aktif/non aktif
			if($data['mspd_aktif'] != 'mspd_aktif_all'){
				if($data['mspd_aktif'] == 1){
					$arr_filter['mspd_aktif'] = $data['mspd_aktif'];
					$p_mspd_aktif = "Aktif";
				} else if ($data['mspd_aktif'] == 0){
					$arr_filter['mspd_aktif'] = $data['mspd_aktif'];
					$p_mspd_aktif = "Non-Aktif";
				} 
			} else {
					$p_mspd_aktif = 'ALL';
				}

			//filter mspd no					);
			if($data['lp_mspd'] != 'lp_mspd_all'){
				if($data['lp_mspd'] == 'lp_mspd_sel'){
					$arr_filter['mspd_no'] = $data['lp_mspd_no_sel'];
					$p_mspd_no = $data['lp_mspd_no_sel'];
				} else if ($data['lp_mspd'] == 'lp_mspd_con'){
					$arr_filter['mspd_nm'] = $data['lp_mspd_nm_con'];
					$p_mspd_no = $data['lp_mspd_nm_con'];
				} 
			} else {
					$p_mspd_no = 'ALL';
				}

			//filter mskt no					);
			if($data['lp_mskt'] != 'lp_mskt_all'){
				$arr_filter['mskt_no'] = $data['lp_mskt_no'];
				$p_mskt_no = $data['lp_mskt_no'];
			} else {
				$p_mskt_no = 'ALL';
			}

			//filter msfm no					);
			if($data['lp_msfm'] != 'lp_msfm_all'){
				$arr_filter['msfm_no'] = $data['lp_msfm_no'];
				$p_msfm_no = $data['lp_msfm_no'];
			} else {
				$p_msfm_no = 'ALL';
			}

			//filter msmd no					);
			if($data['lp_msmd'] != 'lp_msmd_all'){
				$arr_filter['msmd_no'] = $data['lp_msmd_no'];
				$p_msmd_no = $data['lp_msmd_no'];
			} else {
				$p_msmd_no = 'ALL';
			}

			//filter msmr no					);
			if($data['lp_msmr'] != 'lp_msmr_all'){
				$arr_filter['msmr_no'] = $msmr_no;
				$p_msmr_no = $msmr_no;
			} else {
				$p_msmr_no = 'ALL';
			}

			//filter mspd_fin/commercial
			if($data['lp_trju_fin'] != 'lp_trju_fin_all'){
				$arr_filter['mspd_fin'] = $data['lp_trju_fin'];
				$p_trju_fin = $data['lp_trju_fin'];
			} else {
				$p_trju_fin = 'ALL';
			}

			//get query from model inventory
			$q = $this->m_inventory->get_inventory_list($arr_filter, array(),false,0,0, 'mspd_no', 'ASC');
			
			$object = new PHPExcel();
			$object->setActiveSheetIndex(0);

				$styleArray = array(
		   					 'font'  => array(
		        			'bold' => true,
		        			'size'  => 14,
		        			'name' => 'Verdana'
		    				));

				$column = 0;
				$row = 0;
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $title)
				->getStyle()->applyFromArray($styleArray); 
				//parameter filter
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Kategori : ".$p_mskt_no);
				$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, "Merk : ".$p_msmr_no);
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Family : ".$p_msfm_no);
				// $object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, "product package : ".$p_mspd_paket);
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Model : ".$p_msmd_no);
				$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, "Fin/Co : ".$p_trju_fin);
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Produk : ".$p_mspd_no);
				$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, "Produk Aktif: ".$p_mspd_aktif);
			 
				$row+=2;
				$column=-1;

				foreach ($q[0] as $judul => $vjudul) {
					$judul = explode("|", $judul);
					
					$column+=1;
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $judul[1]);
				}
				
				
				foreach ($q as $key => $value) {			
					$row+=1;
					$column=-1;

					foreach ($q[0] as $judul => $vjudul) {			
						$column+=1;
						$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $value[$judul]);
					}
				}
			 
			//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
	        //if you want to save it as .xls Excel 2007 format
			// ob_end_clean();
	        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
	        $filename='inventory_list.xls'; //save our workbook as this file name
	        header('Content-Type: application/vnd.ms-excel'); //mime type
	        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	        header('Cache-Control: max-age=0'); //no cache 
	        //force user to download the Excel file without writing it to server's HD
	        $objWriter->save('php://output');
		}
	}

	public function lp_inventory_list_stok(){
		if(fcek_hak_akses('.HA3.|.HA6.')) {
			$data['judul'] = $this->input->get('judul_laporan');
			$data['lp_mskt'] = $this->input->get('lp_mskt');
			$data['lp_mskt_no'] = substr($this->input->get('lp_mskt_no'), 0, 1);
			$data['lp_mskt_nm'] = substr($this->input->get('lp_mskt_no'), 4);
			$data['lp_msfm'] = $this->input->get('lp_msfm');
			$data['lp_msfm_no'] = substr($this->input->get('lp_msfm_no'), 0,3);
			$data['lp_msfm_nm'] = substr($this->input->get('lp_msfm_no'), 6);
			$data['lp_msmd'] = $this->input->get('lp_msmd');
			$data['lp_msmd_no'] = substr($this->input->get('lp_msmd_no'), 0,6);
			$data['lp_msmd_nm'] = substr($this->input->get('lp_msmd_no'), 9);
			$data['lp_mspd'] = $this->input->get('lp_mspd');
			$data['lp_mspd_no_sel'] = substr($this->input->get('lp_mspd_no_sel'), 0, 9);
			$data['lp_mspd_nm'] = substr($this->input->get('lp_mspd_no_sel'), 12);	
			$data['lp_mspd_nm_con'] = $this->input->get('lp_mspd_nm_con');		
			$data['lp_msmr'] = $this->input->get('lp_msmr');
			$msmr = explode("-", $this->input->get('lp_msmr_no'));
			$msmr_no = trim($msmr[0]);
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
			$data['lp_mspd_paket'] = $this->input->get('lp_mspd_paket');
			$data['mspd_aktif'] = $this->input->get('mspd_aktif');
			
			$arr_filter = array();
			if($data['judul'] == "lp_inventory_list"){
				$arr_filter['menu']	= 'INV_REPORT';
				$title = "INVENTORY LIST";
			}else{
				$arr_filter['menu']	= 'INV_REPORT_ADMIN';
				$title = "INVENTORY LIST (DENGAN HPP & PRICELIST)";
			}
			
			//filter produk aktif/non aktif
			if($data['mspd_aktif'] != 'mspd_aktif_all'){
				if($data['mspd_aktif'] == 1){
					$arr_filter['mspd_aktif'] = $data['mspd_aktif'];
					$p_mspd_aktif = "Aktif";
				} else if ($data['mspd_aktif'] == 0){
					$arr_filter['mspd_aktif'] = $data['mspd_aktif'];
					$p_mspd_aktif = "Non-Aktif";
				} 
			} else {
					$p_mspd_aktif = 'ALL';
				}

			//filter mspd no					);
			if($data['lp_mspd'] != 'lp_mspd_all'){
				if($data['lp_mspd'] == 'lp_mspd_sel'){
					$arr_filter['mspd_no'] = $data['lp_mspd_no_sel'];
					$p_mspd_no = $data['lp_mspd_no_sel'];
				} else if ($data['lp_mspd'] == 'lp_mspd_con'){
					$arr_filter['mspd_nm'] = $data['lp_mspd_nm_con'];
					$p_mspd_no = $data['lp_mspd_nm_con'];
				} 
			} else {
					$p_mspd_no = 'ALL';
				}

			//filter mskt no					);
			if($data['lp_mskt'] != 'lp_mskt_all'){
				$arr_filter['mskt_no'] = $data['lp_mskt_no'];
				$p_mskt_no = $data['lp_mskt_no'];
			} else {
				$p_mskt_no = 'ALL';
			}

			//filter msfm no					);
			if($data['lp_msfm'] != 'lp_msfm_all'){
				$arr_filter['msfm_no'] = $data['lp_msfm_no'];
				$p_msfm_no = $data['lp_msfm_no'];
			} else {
				$p_msfm_no = 'ALL';
			}

			//filter msmd no					);
			if($data['lp_msmd'] != 'lp_msmd_all'){
				$arr_filter['msmd_no'] = $data['lp_msmd_no'];
				$p_msmd_no = $data['lp_msmd_no'];
			} else {
				$p_msmd_no = 'ALL';
			}

			//filter msmr no					);
			if($data['lp_msmr'] != 'lp_msmr_all'){
				$arr_filter['msmr_no'] = $msmr_no;
				$p_msmr_no = $msmr_no;
			} else {
				$p_msmr_no = 'ALL';
			}

			//filter mspd_fin/commercial
			if($data['lp_trju_fin'] != 'lp_trju_fin_all'){
				$arr_filter['mspd_fin'] = $data['lp_trju_fin'];
				$p_trju_fin = $data['lp_trju_fin'];
			} else {
				$p_trju_fin = 'ALL';
			}

			//get query from model inventory
			$q = $this->m_inventory->get_inventory_list_report($arr_filter);
			
			$object = new PHPExcel();
			$object->setActiveSheetIndex(0);

				$styleArray = array(
		   					 'font'  => array(
		        			'bold' => true,
		        			'size'  => 14,
		        			'name' => 'Verdana'
		    				));

				$column = 0;
				$row = 0;
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $title)
				->getStyle()->applyFromArray($styleArray); 
				//parameter filter
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Kategori : ".$p_mskt_no);
				$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, "Merk : ".$p_msmr_no);
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Family : ".$p_msfm_no);
				// $object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, "product package : ".$p_mspd_paket);
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Model : ".$p_msmd_no);
				$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, "Fin/Co : ".$p_trju_fin);
				$row+=1;
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Produk : ".$p_mspd_no);
				$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, "Produk Aktif: ".$p_mspd_aktif);
			 
				$row+=2;
				$column=-1;

				foreach ($q[0] as $judul => $vjudul) {
					$judul = explode("|", $judul);
					
					$column+=1;
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $judul[1]);
				}
				
				
				foreach ($q as $key => $value) {			
					$row+=1;
					$column=-1;

					foreach ($q[0] as $judul => $vjudul) {			
						$column+=1;
						$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $value[$judul]);
					}
				}
			 
			//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
	        //if you want to save it as .xls Excel 2007 format
			// ob_end_clean();
	        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
	        $filename='inventory_list.xls'; //save our workbook as this file name
	        header('Content-Type: application/vnd.ms-excel'); //mime type
	        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	        header('Cache-Control: max-age=0'); //no cache 
	        //force user to download the Excel file without writing it to server's HD
	        $objWriter->save('php://output');
		}
	}

	public function lp_jurnal(){
	if(fcek_hak_akses('.HA4.')) {

		if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

		$data['lp_trju_tgldari'] = $this->input->get('lp_tgldari');
		$data['lp_trju_tglsampai'] = $this->input->get('lp_tglsampai');
		$data['lp_trju_tipe'] = $this->input->get('lp_trju_tipe');	
		$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
		$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');


		//search by tipe jurnal auto/manual sebagai parameter
		if($data['lp_trju_tipe'] == 'lp_trju_tipe_all'){
			$tipe_jurnal = 'ALL';
		} elseif ($data['lp_trju_tipe'] == 'A'){
			$tipe_jurnal = 'Automatic';
		} else 
			$tipe_jurnal = 'Manual';
		//end//

		//search by tipe data jurnal fin/com sebagai parameter
		if($data['lp_trju_fin'] == 'C'){
			$data_jurnal = "Commercial";
		} elseif ($data['lp_trju_fin'] == 'F') {
			$data_jurnal = "Finance";
		} else {
			$data_jurnal = "ALL";
		}
		//end//

		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);

		$styleArray = array(
   					 'font'  => array(
        			'bold' => true,
        			'size'  => 14,
        			'name' => 'Verdana'
    				));


		$column = 0;
		$row = 0;
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Laporan Jurnal")
		->getStyle()->applyFromArray($styleArray); 
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Cabang : ".$data['mscb_listmscb']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "periode : ".$data['lp_trju_tgldari']." s/d ".$data['lp_trju_tglsampai']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Jenis Jurnal : ".$tipe_jurnal);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Jenis Data Jurnal : ".$data_jurnal);
		
		$row+=2;
		$table_colums = array('Jurnal # ', 'Tgl Jurnal', 'Keterangan', 'Akun Perkiraan #', 'Nama Akun Perkiraan', 'Debet', 'Kredit', 'Keterangan Detail');		
		foreach ($table_colums as $field) {
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
			$column += 1;
		}

		$query = 'Select dtju.*, trju.*, msap_nm
					FROM dt_jurnal dtju
					LEFT JOIN tr_jurnal trju ON trju.trju_no = dtju.dtju_no
					LEFT JOIN ms_accper msap ON msap.msap_no = dtju.dtju_msap_no
					WHERE POSITION(trju_mscb_no in "'.$data['mscb_listmscb'].'")
					AND trju_tgl BETWEEN "'.$data['lp_trju_tgldari'].' 00:00:00" AND "'.$data['lp_trju_tglsampai'].' 23:59:59"';
		
		if($data['lp_trju_tipe'] != 'lp_trju_tipe_all'){
			$query .= "AND trju.trju_tipe = '". $data['lp_trju_tipe']."' ";
		}


		if($data['lp_trju_fin'] != 'lp_trju_fin_all'){
			$query .= ' AND trju.trju_fin = "'. $data['lp_trju_fin'].'"';
		}

		$query .= ' ORDER BY trju_tgl, trju_no';
		
		$data = $this->db->query($query);
		$data = $data->result_array();

		$row += 1;

		$no_prev = "";
		foreach ($data as $key => $value) {	
		if($no_prev != $value['trju_no']){		
			$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['trju_no']);
			$no_prev = $value['trju_no'];
		}
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['trju_tgl']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['trju_catatan']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['dtju_msap_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $value['msap_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['dtju_debet']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $value['dtju_kredit']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $value['dtju_catatan']);
			$row += 1;
		}
      
        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
        //if you want to save it as .xls Excel 2007 format
        // ob_end_clean();
        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
        $filename='laporan_jurnal.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache 
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');
		}
	}

	public function lp_rekonsile(){
		if(fcek_hak_akses('.HA4.')) {

			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

			$data['lp_tgldari'] = $this->input->get('lp_tgldari');
			$data['lp_tglsampai'] = $this->input->get('lp_tglsampai');
			$data['lp_trju_tipe'] = $this->input->get('lp_trju_tipe');	
			$data['lp_msap'] = $this->input->get('lp_msap');
			$data['lp_msap_no'] = substr($this->input->get('lp_msap_no'), 0, 11);
			$data['lp_msap_nm'] = substr($this->input->get('lp_msap_no'), 14);
			$data['rekon'] = $this->input->get('rekon');
			$data['ref'] = $this->input->get('idref_rekon');
			$data['cttn'] = $this->input->get('cttn_rekon');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');

			$path = APPPATH.'reports\accounting_reports\lp_rekonsile.jrxml';
			
			// string query hasil filter
			$result = $this->m_reporting->get_lp_rekonsile($data);
			
			// Update query string yang ada di xml file
			$xml = new DOMDocument();
			$xml->load($path);
			$nodes = $xml->getElementsByTagName('queryString') ;				
			$xml->getElementsByTagName("queryString")->item(0)->nodeValue = "";
			$xml->getElementsByTagName("queryString")->item(0)->appendChild($xml->createCDATASection($result['query']));		   		   
			$xml->save($path);


			// Set parameter yang akan di kirim ke fele xml
			$params = new Java("java.util.HashMap");
			$params->put("lp_tgldari", new Java('java.lang.String', $data['lp_tgldari']));
			$params->put("lp_tglsampai", new Java('java.lang.String', $data['lp_tglsampai']));							
			$params->put("msap_no", new Java('java.lang.String', $result['param']['msap_no']));
			$params->put("msap_nm", new Java('java.lang.String', $result['param']['msap_nm']));
			$params->put("tipe_jurnal", new Java('java.lang.String', $result['param']['tipe']));
			$params->put("sts_rekon", new Java('java.lang.String', $result['param']['rekon']));
			

			// print out report di browser
			$this->java_bridge->print_data($path, $params);
		}
	}

	public function lp_rekonsile_excel(){
		if(fcek_hak_akses('.HA4.')) {

			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

			$data['lp_tgldari'] = $this->input->get('lp_tgldari');
			$data['lp_tglsampai'] = $this->input->get('lp_tglsampai');
			$data['lp_trju_tipe'] = $this->input->get('lp_trju_tipe');	
			$data['lp_msap'] = $this->input->get('lp_msap');
			$data['lp_msap_no'] = substr($this->input->get('lp_msap_no'), 0, 11);
			$data['lp_msap_nm'] = substr($this->input->get('lp_msap_no'), 14);
			$data['rekon'] = $this->input->get('rekon');
			$data['ref'] = $this->input->get('idref_rekon');
			$data['cttn'] = $this->input->get('cttn_rekon');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');

			// string query hasil filter
			$result = $this->m_reporting->get_lp_rekonsile($data);

			$object = new PHPExcel();
			$object->setActiveSheetIndex(0);
			$styleArray = array('font'  => array('bold' => true,'size'  => 14,'name' => 'Verdana'));

			$column = 0; $row=0;
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column,$row,"LAPORAN REKONSILIASI")
			->getStyle()->applyFromArray($styleArray);
			//parameter 
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column,$row,'Periode : '.$data['lp_tgldari']." s/d ".$data['lp_tglsampai']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5,$row,'Tipe Jurnal : '.$result['param']['tipe']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column,$row,'Akun Perkiraan : '.$result['param']['msap_no']." - ".$result['param']['msap_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5,$row,'Status Rekon : '.$result['param']['rekon']);

			$row+=2; $column=0;
			$table_colums = array('TANGGAL', 'TIPE', 'JENIS REFERENSI', 'NO REFERENSI', 'CATATAN', 'DEBET', 'KREDIT', 'REKON');
			foreach ($table_colums as $field) {
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
				$column += 1;
	 		}
			
			$data = $this->db->query($result['query']);
			$data = $data->result_array();		
			
			$row+=1;

			foreach ($data as $key => $value) {			
				$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['trju_tgl']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['trju_tipe']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['trju_reftipe']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['trju_refno']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $value['dtju_catatan']." ".$value['trju_catatan']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['dtju_debet']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $value['dtju_kredit']);
				$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $value['dtju_cek']);
				$row += 1;
			}
	      	//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
	        //if you want to save it as .xls Excel 2007 format
			// ob_end_clean();
	        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
	        $filename='rekonsiliasi.xls'; //save our workbook as this file name
	        header('Content-Type: application/vnd.ms-excel'); //mime type
	        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	        header('Cache-Control: max-age=0'); //no cache 
	        //force user to download the Excel file without writing it to server's HD
	        $objWriter->save('php://output');

		}
	}

	public function lp_buku_besar(){
		if(fcek_hak_akses('.HA4.')) {

			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}
				
			$data['judul_laporan'] = $this->input->get('judul_laporan');		
			$data['lp_tgldari'] = trim($this->input->get('lp_tgldari')).' 00:00:00';
			$data['lp_tglsampai'] = trim($this->input->get('lp_tglsampai')).' 23:59:59';
			$data['lp_trju_tipe'] = $this->input->get('lp_trju_tipe');	
			$data['lp_msap'] = $this->input->get('lp_msap');
			$data['lp_msag_no'] = substr($this->input->get('lp_msag_no'), 0, 2);
			$data['lp_msag_nm'] = substr($this->input->get('lp_msag_no'), 5);
			$data['lp_msas_no'] = substr($this->input->get('lp_msas_no'), 0, 5);
			$data['lp_msas_nm'] = substr($this->input->get('lp_msas_no'), 8);
			$data['lp_msap_no'] = substr($this->input->get('lp_msap_no'), 0, 11);
			$data['lp_msap_nm'] = substr($this->input->get('lp_msap_no'), 14);
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');

			$path = APPPATH.'reports\accounting_reports';

			if($data['judul_laporan'] == 'lp_buku_besar'){	
				$path .= '\lp_buku_besar.jrxml';
			}
			
			// string query hasil filter
			$result = $this->m_reporting->get_lp_buku_besar($data);
			
			// Update query string yang ada di xml file
			$xml = new DOMDocument();
			$xml->load($path);
			$nodes = $xml->getElementsByTagName('queryString') ;				
			$xml->getElementsByTagName("queryString")->item(0)->nodeValue = "";
			$xml->getElementsByTagName("queryString")->item(0)->appendChild($xml->createCDATASection($result['query']));		   		   
			$xml->save($path);


			// Set parameter yang akan di kirim ke fele xml
			$params = new Java("java.util.HashMap");							
			$params->put("tgl_dari", new Java('java.lang.String', $result['param']['tgldari']));
			$params->put("tgl_sampai", new Java('java.lang.String', $result['param']['tglsampai']));
			$params->put("cabang", new Java('java.lang.String', $result['param']['cabang']));
			$params->put("tipe", new Java('java.lang.String', $result['param']['tipe']));
			$params->put("data_jurnal", new Java('java.lang.String', $result['param']['data_jurnal']));
			$params->put("msag_no", new Java('java.lang.String', $result['param']['msag_no']));
			$params->put("group", new Java('java.lang.String', $result['param']['group']));
			$params->put("msas_no", new Java('java.lang.String', $result['param']['msas_no']));
			$params->put("subgroup", new Java('java.lang.String', $result['param']['subgroup']));
			$params->put("msap_no", new Java('java.lang.String', $result['param']['msap_no']));
			$params->put("akunperkiraan", new Java('java.lang.String', $result['param']['akunperkiraan']));

			// print out report di browser
			$this->java_bridge->print_data($path, $params);
		}
	}

	public function lp_buku_besar_excel(){
	if(fcek_hak_akses('.HA4.')) {
		
		if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

		$data['lp_tgldari'] = trim($this->input->get('lp_tgldari')).' 00:00:00';
		$tgldari = substr($this->input->get('lp_tgldari'),8,2).'/'
								.substr($this->input->get('lp_tgldari'),5,2).'/'
								.substr($this->input->get('lp_tgldari'),2,2);
		$data['lp_tglsampai'] = trim($this->input->get('lp_tglsampai')).' 23:59:59';
		$tglsampai = substr($this->input->get('lp_tglsampai'),8,2).'/'
								.substr($this->input->get('lp_tglsampai'),5,2).'/'
								.substr($this->input->get('lp_tglsampai'),2,2);
		$data['lp_trju_tipe'] = $this->input->get('lp_trju_tipe');	
		$data['lp_msap'] = $this->input->get('lp_msap');
		$data['lp_msag_no'] = substr($this->input->get('lp_msag_no'), 0, 2);
		$data['lp_msag_nm'] = substr($this->input->get('lp_msag_no'), 5);
		$data['lp_msas_no'] = substr($this->input->get('lp_msas_no'), 0, 5);
		$data['lp_msas_nm'] = substr($this->input->get('lp_msas_no'), 8);
		$data['lp_msap_no'] = substr($this->input->get('lp_msap_no'), 0, 11);
		$data['lp_msap_nm'] = substr($this->input->get('lp_msap_no'), 14);
		$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
		$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');		
		$title = 'LAPORAN BUKU BESAR';
		
		// string query hasil filter
		$result = $this->m_reporting->get_lp_buku_besar($data);
		
		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);
		$styleArray = array(
   					 'font'  => array(
        			'bold' => true,
        			'size'  => 14,
        			'name' => 'Verdana'
    				));

		$column = 0;
		$row=0;
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column,$row,$title)
		->getStyle()->applyFromArray($styleArray);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column,$row,'Cabang : '.$data['mscb_listmscb']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(5,$row,'By Group : '.$result['param']['msag_no']." - ".$result['param']['group']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column,$row,'Periode : '.$tgldari.' s/d '.$tglsampai);
		$object->getActiveSheet()->setCellValueByColumnAndRow(5,$row,'By Sub Group : '.$result['param']['msas_no']." - ".$result['param']['subgroup']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column,$row,'Jenis Jurnal : '.$result['param']['tipe']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(5,$row,'By Akun Perkiraan : '.$result['param']['msap_no']." - ".$result['param']['akunperkiraan']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column,$row,'Data Jurnal : '.$result['param']['data_jurnal']);


		$row+=2;
		$column=0;
		$table_colums = array('No Group', 'Nama Group', 'No Sub Group', 'Nama Sub Group', 'No Akun Perkiraan', 'Nama Akun Perkiraan', 'Tgl Jurnal', 'No Jurnal', 'Referensi', 'Catatan Header', 'Catatan Detail', 'Debet', 'Kredit');
		foreach ($table_colums as $field) {
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
			$column += 1;
 		}
		
		$data = $this->db->query($result['query']);
		$data = $data->result_array();		
		
		$row+=1;

		foreach ($data as $key => $value) {			
			$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['msag_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['msag_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['msas_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['msas_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $value['msap_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['msap_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $value['trju_tgl']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $value['dtju_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $value['reftipe']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(9, $row, $value['trju_catatan']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(10, $row, $value['dtju_catatan']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(11, $row, $value['dtju_debet']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(12, $row, $value['dtju_kredit']);
			$row += 1;
		}
      	//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
        //if you want to save it as .xls Excel 2007 format
        // ob_end_clean();
        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
        $filename='buku_besar.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache 
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');
		}
	}


	public function lp_rugi_laba(){
	if(fcek_hak_akses('.HA5.')) {	

		$data['judul_laporan'] = $this->input->get('judul_laporan');
		$data['bulan'] = $this->input->get('monthpicker');
		$data['tahun'] = $this->input->get('yearpicker');
		$data['show_data_nol'] = $this->input->get('show_data_nol');
		$data['opsi_cabang'] = $this->input->get('opsi_cabang');
		$data['cabang'] = $this->input->get('v_mscb_no');
		$tgl_cls_jurnal = $this->m_setting->get_setting('simr_char1','tcj', 1);

		if($data['opsi_cabang'] == 'all'){
			$cabang = 'ALL';
		}else{
			$cabang = $this->m_cabang->get_mscb_nm($data['cabang']);
		}		

		if (($data['tahun'].$data['bulan']) <= $tgl_cls_jurnal){
			$status = "CLOSING";
		}else 
			$status = "BELUM CLOSING";

		$path = APPPATH.'reports\accounting_reports\lp_rugilaba_detail.jrxml';

		if($data['judul_laporan'] == 'lp_rugi_laba'){	
			$show_detail="N";
		} else {
			$show_detail ="Y";
		}
		
		// string query hasil filter
		$result = $this->m_reporting->get_lp_rugi_laba($data);
		
		// Update query string yang ada di xml file
		$xml = new DOMDocument();
		$xml->load($path);
		$nodes = $xml->getElementsByTagName('queryString') ;				
		$xml->getElementsByTagName("queryString")->item(0)->nodeValue = "";
		$xml->getElementsByTagName("queryString")->item(0)->appendChild($xml->createCDATASection($result['query']));		   		   
		$xml->save($path);


		// Set parameter yang akan di kirim ke file xml
		$params = new Java("java.util.HashMap");							
		$params->put("bulan", new Java('java.lang.String', $result['param']['bulan']));
		$params->put("tahun", new Java('java.lang.String', $result['param']['tahun']));
		$params->put("status", new Java('java.lang.String', $status));
		$params->put("cabang", new Java('java.lang.String', $cabang));
		$params->put("show_detail", new Java('java.lang.String', $show_detail));

		// print out report di browser
		$this->java_bridge->print_data($path, $params);
		}
	}

	public function lp_rugi_laba_excel(){
	if(fcek_hak_akses('.HA5.')) {
		$data['bulan'] = $this->input->get('monthpicker');
		$data['tahun'] = $this->input->get('yearpicker');
		$data['show_data_nol'] = $this->input->get('show_data_nol');
		$data['opsi_cabang'] = $this->input->get('opsi_cabang');
		$data['cabang'] = $this->input->get('v_mscb_no');
		$title = 'LAPORAN RUGI LABA';

		// string query hasil filter
		$result = $this->m_reporting->get_lp_rugi_laba($data);
		
		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);
		$styleArray = array('font' => array('bold' => true,'size' => 14, 'name' => 'Verdana'));

		$column = 0;
		$row=0;
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column,$row,$title)
		->getStyle()->applyFromArray($styleArray);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column,$row,'Periode : '.$result['param']['bulan'].' '.$result['param']['tahun']);


		$row+=2;
		$column=0;
		$table_colums = array('Jenis', 'No Sub Group', 'Nama Sub Group', 'No Akun Perkiraan', 'Nama Akun Perkiraan', 'Cost Center', 'Saldo');
		foreach ($table_colums as $field) {
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
			$column += 1;
 		}
		

		$data = $this->db->query($result['query']);
		$data = $data->result_array();
		// echo "<pre>"; print_r($data); die();	
		
		$row+=1;
		$hsag_kelompok ="";
		foreach ($data as $key => $value) {	
			if($value['hsag_kelompok'] == "101"){
				$hsag_kelompok = "Pendapatan";
			}else if ($value['hsag_kelompok'] == "102"){
				$hsag_kelompok = "Harga Pokok Penjualan";
			} else $hsag_kelompok = "Biaya Pengeluaran";
			$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $hsag_kelompok);
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['hsas_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['hsas_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['hsap_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $value['hsap_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['hscc_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $value['saldo']);
			$row += 1;
		}

        //if you want to save it as .xls Excel 2007 format
        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
        $filename='Rugi Laba.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache 
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');
		}
	}

	public function lp_neraca(){
	if(fcek_hak_akses('.HA5.')) {
		$data['judul_laporan'] = $this->input->get('judul_laporan');
		$data['bulan'] = $this->input->get('monthpicker');
		$data['tahun'] = $this->input->get('yearpicker');
		$data['show_data_nol'] = $this->input->get('show_data_nol');
		$data['opsi_cabang'] = $this->input->get('opsi_cabang');
		$data['cabang'] = $this->input->get('v_mscb_no');
		$tgl_cls_jurnal = $this->m_setting->get_setting('simr_char1','tcj', 1);

		if($data['opsi_cabang'] == 'all'){
			$cabang = 'ALL';
		}else{
			$cabang = $this->m_cabang->get_mscb_nm($data['cabang']);
		}		

		if (($data['tahun']."0".$data['bulan']) <= $tgl_cls_jurnal){
			$status = "CLOSING";
		}else 
			$status = "BELUM CLOSING";

		$path = APPPATH.'reports\accounting_reports\lp_nrc.jrxml';

		if($data['judul_laporan'] == 'lp_neraca'){	
			// $path .= '\lp_nrc.jrxml';
			$show_detail="N";
		} elseif ($data['judul_laporan'] == 'lp_neraca_detail') {
			// $path .= '\lp_nrc.jrxml';
			$show_detail="Y";
		}
		
		// string query hasil filter
		$result = $this->m_reporting->get_neraca($data);
		
		// Update query string yang ada di xml file
		$xml = new DOMDocument();
		$xml->load($path);
		$nodes = $xml->getElementsByTagName('queryString') ;				
		$xml->getElementsByTagName("queryString")->item(0)->nodeValue = "";
		$xml->getElementsByTagName("queryString")->item(0)->appendChild($xml->createCDATASection($result['query']));		   		   
		$xml->save($path);
		//die('stop');
		// Set parameter yang akan di kirim ke file xml
		$params = new Java("java.util.HashMap");							
		$params->put("bulan", new Java('java.lang.String', $result['param']['bulan']));
		$params->put("tahun", new Java('java.lang.String', $result['param']['tahun']));
		$params->put("status", new Java('java.lang.String', $status));
		$params->put("cabang", new Java('java.lang.String', $cabang));
		$params->put("show_detail", new Java('java.lang.String', $show_detail));
		
		// print out report di browser
		$this->java_bridge->print_data($path, $params);
		}
	}

	public function lp_neraca_excel(){
	if(fcek_hak_akses('.HA5.')) {
		$data['bulan'] = $this->input->get('monthpicker');
		$data['tahun'] = $this->input->get('yearpicker');
		$data['show_data_nol'] = $this->input->get('show_data_nol');
		$data['opsi_cabang'] = $this->input->get('opsi_cabang');
		$data['cabang'] = $this->input->get('v_mscb_no');
		$title = 'LAPORAN NERACA';

		// string query hasil filter
		$result = $this->m_reporting->get_neraca($data);

		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);
		$styleArray = array(
   					 'font'  => array(
        			'bold' => true,
        			'size'  => 14,
        			'name' => 'Verdana'
    				));

		$column = 0;
		$row=0;
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column,$row,$title)
		->getStyle()->applyFromArray($styleArray);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column,$row,'Periode : '.$result['param']['bulan'].' '.$result['param']['tahun']);


		$row+=2;
		$column=0;
		$table_colums = array('Neraca', 'No Sub Group', 'Nama Sub Group', 'No Akun Perkiraan', 'Nama Akun Perkiraan', 'Cost Center', 'Saldo');
		foreach ($table_colums as $field) {
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
			$column += 1;
 		}
		
 		$data = $this->db->query($result['query']);
		$data = $data->result_array();		
		
		$row+=1;
		$hsag_kelompok = "";
		foreach ($data as $key => $value) {	
		if($value['hsag_kelompok'] == 1){
				$hsag_kelompok = "Aktiva";
			}else if ($value['hsag_kelompok'] == 2){
				$hsag_kelompok = "Passiva";
			} else $hsag_kelompok = "Modal";

			$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $hsag_kelompok);
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['hsas_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['hsas_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['hsap_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $value['hsap_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['hscc_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $value['saldo']);
			$row += 1;
		}

      	//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
        //if you want to save it as .xls Excel 2007 format
        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
        $filename='Neraca.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache 
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');
		}
	}

	public function lp_auth_user(){
	if(fcek_hak_akses('.HA6.')) {
		if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

		$data['lp_tgldari'] = trim($this->input->get('lp_tgldari'));
		$data['lp_tglsampai'] = trim($this->input->get('lp_tglsampai'));
		$data['lp_keyword1'] = $this->input->get('lp_keyword1');
		$data['lp_keyword2'] = $this->input->get('lp_keyword2');
		$data['lp_keyword3'] = $this->input->get('lp_keyword3');
		$data['lp_msus'] = $this->input->get('lp_msus');
		$data['lp_msus_no'] = $this->input->get('lp_msus_no');
		$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
		
		$query = 'select l.*, msus_nm
				FROM ms_userlog l
				LEFT JOIN ms_user on l.msul_msus_no = msus_no
				WHERE l.msul_tgl BETWEEN "'.$data['lp_tgldari'].'" and "'.$data['lp_tglsampai'].'"
				and msul_catatan like "%'.$data['lp_keyword1'].'%" and msul_catatan like "%'.$data['lp_keyword2'].'%"
				and msul_catatan like "%'.$data['lp_keyword3'].'%"
				and POSITION(msus_mscb_no in "'.$data['mscb_listmscb'].'")';
		
		//filter by msus no
		if($data['lp_msus'] != 'lp_msus_all' ){
			$query .= ' and msus_no = substring("'.$data['lp_msus_no'].'",1,4)';
			$msus = $data['lp_msus_no'];
		} else {
			$msus ='ALL';
		}

		$query .= ' ORDER BY msus_no, msul_tgl';
		// die($query);
		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);

		$styleArray = array(
   					 'font'  => array(
        			'bold' => true,
        			'size'  => 14,
        			'name' => 'Verdana'
    				));

		$column = 0;
		$row = 0;
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "LIST AUTHORIZED USER")
		->getStyle()->applyFromArray($styleArray); 
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Cabang : ".$data['mscb_listmscb']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, "Tanggal : ".$data['lp_tgldari']."-".$data['lp_tglsampai']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "User : ".$msus);	
		
		$row+=2;
		$table_colums = array('TANGGAL PERIODE', 'USER ID', 'USERNAME', 'CATATAN');

		foreach ($table_colums as $field) {
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
			$column += 1;
		}

		$data = $this->db->query($query);
		$data = $data->result_array();		
		$row += 1;

		foreach ($data as $key => $value) {			
			$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['msul_tgl']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['msul_msus_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['msus_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['msul_catatan']);
			$row += 1;
		}

		//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
        //if you want to save it as .xls Excel 2007 format
        // ob_end_clean();
        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
        $filename='Authorized Log.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache 
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');
		}
	}

	public function lp_cust_list(){
	if(fcek_hak_akses('.HA6.')) {
		if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

		$data['lp_mscs'] = $this->input->get('lp_mscs');		
		$data['lp_mscs_no'] = substr($this->input->get('lp_mscs_no'), 0, 6);
		$data['lp_mscs_nm'] = substr($this->input->get('lp_mscs_no'), 9);
		$data['lp_mscs_aktif'] = $this->input->get('lp_mscs_aktif');
		$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
		
		$query = 'select c.*, ifnull((SELECT max(trso_tgl) from tr_so where trso_mscs_no = c.mscs_no ),"") as last_trso_tgl,
					ifnull(mscsda_kirim_jln,"") as mscsda_jln, ifnull(mscsda_kirim_kota,"") as mscsda_kota, ifnull(mscsda_kirim_provinsi,"") as mscsda_prov
				FROM ms_customer c
				LEFT JOIN ms_cust_dlvyadd ON mscsda_no = c.mscs_no
				where ';
		
		// filter by mscs_no (customer)
		if($data['lp_mscs'] != 'lp_mscs_all'){
			if ($data['lp_mscs'] == 'lp_mscs_r') {
				$query .= ' mscs_jenis="R"';
				$mscs = 'Retail';
			} else if ($data['lp_mscs'] == 'lp_mscs_a') {
				$query .= ' mscs_jenis="A"';
				$mscs = 'Agen';
			} else if ($data['lp_mscs'] == 'lp_mscs_sel'){
				$query .= ' mscs_no = "'. $data['lp_mscs_no']. '"';
				$mscs = $data['lp_mscs_nm'];
			} 
		} else {
				$query .= ' mscs_no != ""';
				$mscs ='ALL';
				}

		// filter by mscs_aktif (customer)
		if($data['lp_mscs_aktif'] != 'lp_mscs_aktif_all'){
			if ($data['lp_mscs_aktif'] == 'Y') {
				$query .= ' and mscs_aktif=1';
				$mscs_aktif = 'Aktif';
			} else if ($data['lp_mscs_aktif'] == 'N') {
				$query .= ' and mscs_aktif=0';
				$mscs_aktif = 'Non-Aktif';
			}
		} else {
				$mscs_aktif ='ALL';
				}

		$query .= ' ORDER by c.mscs_no, mscsda_seq';
	
		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);

		$styleArray = array(
   					 'font'  => array(
        			'bold' => true,
        			'size'  => 14,
        			'name' => 'Verdana'
    				));

		$column = 0;
		$row = 0;
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "LIST CUSTOMER")
		->getStyle()->applyFromArray($styleArray); 
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Cabang : ".$data['mscb_listmscb']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Customer : ".$mscs);
		$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, "Customer Aktif : ".$mscs_aktif);
		
		$row+=2;
		$table_colums = array('ID', 'NAME', 'JENIS', 'CABANG', 'AKTIF', 'TOP', 'TAG', 'PPN', 'TELP', 'EMAIL', 'CONTACT PERSON', 
			'OFFICE ADDRESS', 'CITY', 'PROVINCE', 'NOTES', 'NO HANDPHONE', 'NO FAX', 'NPWP', 'AGEN CLASSIFICATION', 
			'DELIVERY ADDRESS', 'CITY', 'PROVINCE', 'LAST ORDER DATE');

		foreach ($table_colums as $field) {
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
			$column += 1;
		}

		$data = $this->db->query($query);
		$data = $data->result_array();		

		$row += 1;

		foreach ($data as $key => $value) {			
			$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['mscs_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['mscs_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['mscs_jenis']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['mscs_listmscb']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $mscs_aktif);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['mscs_top']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $value['mscs_tag']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $value['mscs_ppn']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $value['mscs_telp'], PHPExcel_Cell_DataType::TYPE_STRING);
			$object->getActiveSheet()->setCellValueByColumnAndRow(9, $row, $value['mscs_email']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(10, $row, $value['mscs_cp'], PHPExcel_Cell_DataType::TYPE_STRING);
			$object->getActiveSheet()->setCellValueByColumnAndRow(11, $row, $value['mscs_almt_jln']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(12, $row, $value['mscs_almt_kota']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(13, $row, $value['mscs_almt_provinsi']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(14, $row, $value['mscs_catatan']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(15, $row, $value['mscs_hp'], PHPExcel_Cell_DataType::TYPE_STRING);
			$object->getActiveSheet()->setCellValueByColumnAndRow(16, $row, $value['mscs_fax'], PHPExcel_Cell_DataType::TYPE_STRING);
			$object->getActiveSheet()->setCellValueByColumnAndRow(17, $row, $value['mscs_npwp'], PHPExcel_Cell_DataType::TYPE_STRING);
			$object->getActiveSheet()->setCellValueByColumnAndRow(18, $row, $value['mscs_klas']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(19, $row, $value['mscsda_jln']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(20, $row, $value['mscsda_kota']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(21, $row, $value['mscsda_prov']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(22, $row, $value['last_trso_tgl']);
			$row += 1;
		}
      
        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
        //if you want to save it as .xls Excel 2007 format
        // ob_end_clean();
        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
        $filename='list_customer.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache 
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');
		}
	}

	public function lp_insertto_tmp_lap_mutasi_hutang_cust_pdf(){	
		if(fcek_hak_akses('.HA7.')) {
			//cek status akses area

			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

			if($this->session->userdata('rand')){
				$this->m_reporting->delete_datatemp_bayrand_thc($this->session->userdata('rand'));
				unset($_SESSION['rand']);
				}

			$this->session->set_userdata('rand',rand());
			$thc_idlap = $this->session->userdata('rand');
			$lp_mscs_sel = $this->input->get('lp_mscs');
			$tgl_dari = trim($this->input->get('lp_tgldari').' 00:00:00');
			$tgl_sampai = trim($this->input->get('lp_tglsampai').' 23:59:59');

			
			$path = APPPATH.'reports\finance_reports\lp_hutang_cust.jrxml'; 

			// filter by mscs (customer)
		 	if ($lp_mscs_sel == 'lp_mscs_sel'){
				$mscs_no = substr($this->input->get('lp_mscs_no'),0,6);
				$mscs_nm = substr($this->input->get('lp_mscs_no'),8);
			} else {
				$mscs_no =' ';
				$mscs_nm =' ';
				}

			// string query hasil filter
			$result = $this->m_reporting->insertto_tmp_lap_mutasi_hutang_cust($thc_idlap, $mscs_no, $tgl_dari, $tgl_sampai);

			// Update query string yang ada di xml file
			$xml = new DOMDocument();
			$xml->load($path);
			$nodes = $xml->getElementsByTagName('queryString') ;				
			$xml->getElementsByTagName("queryString")->item(0)->nodeValue = "";
			$xml->getElementsByTagName("queryString")->item(0)->appendChild($xml->createCDATASection($result['query']));		   		   
			$xml->save($path);

			// Set parameter yang akan di kirim ke file xml
			$params = new Java("java.util.HashMap");							
			$params->put("mscs_no", new Java('java.lang.String', $mscs_no));
			$params->put("mscs_nm", new Java('java.lang.String', $mscs_nm));
			$params->put("periode", new Java('java.lang.String', $tgl_dari));
			$params->put("periode_akhir", new Java('java.lang.String', $tgl_sampai));

			// print out report di browser
			$this->java_bridge->print_data($path, $params);	

			if($this->session->userdata('rand')){
				$this->m_reporting->delete_datatemp_bayrand_thc($this->session->userdata('rand'));
				unset($_SESSION['rand']);
				}
		}
	}

	public function lp_insertto_tmp_lap_mutasi_hutang_cust(){
		if(fcek_hak_akses('.HA7.')) {
			//cek status akses area

			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}
	
		if($this->session->userdata('rand')){
			$this->m_reporting->delete_datatemp_bayrand_thc($this->session->userdata('rand'));
			unset($_SESSION['rand']);
		}

		$this->session->set_userdata('rand',rand());
		$thc_idlap = $this->session->userdata('rand');
		$lp_mscs_sel = $this->input->get('lp_mscs');
		$tgl_dari = trim($this->input->get('lp_tgldari').' 00:00:00');
		$tgl_sampai = trim($this->input->get('lp_tglsampai').'23:59:59');
		
		// filter by mscs (customer)
		 if ($lp_mscs_sel == 'lp_mscs_sel'){
				$mscs_no = substr($this->input->get('lp_mscs_no'),0,6);
				$mscs_nm = substr($this->input->get('lp_mscs_no'),8);
			} else {
				$mscs_no =' ';
				$mscs_nm =' ';
				}

		$result = $this->m_reporting->insertto_tmp_lap_mutasi_hutang_cust($thc_idlap, $mscs_no, $tgl_dari, $tgl_sampai);    	
		
		//create lap dalam excel ==================================================================
		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);

		$styleArray = array(
   					 'font'  => array(
        			'bold' => true,
        			'size'  => 14,
        			'name' => 'Verdana'
    				));

		$column = 0;
		$row = 0;
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "MUTASI HUTANG CUSTOMER")
		->getStyle()->applyFromArray($styleArray); 
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Customer : ".$mscs_no." ".$mscs_nm);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Periode : ".$tgl_dari." - ".$tgl_sampai);
		
		$row+=2;
		$table_colums = array('TGL TRANSAKSI', 'KETERANGAN', 'DP/VOUCHER RETUR', 'PIUTANG', 'SALDO');

		foreach ($table_colums as $field) {
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
			$column += 1;
		}

		$data = $this->db->query($result['query']);	
		$data = $data->result_array();

		$row += 1;
		$saldo = 0;
		foreach ($data as $key => $value) {	
			$saldo += $value['thc_value'];

			$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['thc_tgltran']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['thc_jnstran']." ".$value['thc_kettran']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['thc_dp']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['thc_value']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $saldo);
			$row += 1;
		}
      
        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
        //if you want to save it as .xls Excel 2007 format
        // ob_end_clean();
        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
        $filename='hutang cust.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache 
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');

        //delete data on table temp thc
        if($this->session->userdata('rand')){
				$this->m_reporting->delete_datatemp_bayrand_thc($this->session->userdata('rand'));
				unset($_SESSION['rand']);
				}

		}
	}

	public function lp_top_cust(){
		if(fcek_hak_akses('.HA7.')) {
			//cek status akses area

			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}
	
		if($this->session->userdata('rand')){
			$this->m_reporting->delete_datatemp_bayrand_tltc($this->session->userdata('rand'));
			unset($_SESSION['rand']);
		}

		$this->session->set_userdata('rand',rand());
		$data['judul_laporan'] = $this->input->get('judul_laporan');
		$data['tltc_idlap'] = $this->session->userdata('rand');
		$data['lp_mscs_sel'] = $this->input->get('lp_mscs');
		$data['mscs_no'] = substr($this->input->get('lp_mscs_no'),0,6);
		$data['mscs_nm'] = substr($this->input->get('lp_mscs_no'),9);
		$data['lp_mssl_sel'] = $this->input->get('lp_mssl');
		$mssl = explode(":", $this->input->get('lp_mssl_no'));
		$data['mssl_no'] = trim($mssl[0]);
		$data['tgl_dari'] = trim($this->input->get('lp_top_cust_tgl_dari').' 00:00:00');
		$data['tgl_sampai'] = trim($this->input->get('lp_top_cust_tgl_sampai').' 23:59:59');
		$data['sumberdata'] =  $this->input->get('lp_sumberdata');
		$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
		$data['lp_statuslunas'] = $this->input->get('lp_statuslunas_cust');
		// echo "<pre>"; print_r($data); die();
		
		//resutl query
		if($data['judul_laporan'] == "lp_top_cust"){	
			$result = $this->m_reporting->lap_tmp_lap_top_cust($data); 
		}else{
			$result = $this->m_reporting->lap_tmp_lap_top_cust_new($data); 
		}
		
		// create lap dalam excel ==================================================================
		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);

		$styleArray = array(
   					 'font'  => array(
        			'bold' => true,
        			'size'  => 14,
        			'name' => 'Verdana'
    				));

		$column = 0;
		$row = 0;
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "LAPORAN TOP CUSTOMER")
		->getStyle()->applyFromArray($styleArray); 
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Periode : ".$data['tgl_dari']." - ".$data['tgl_sampai']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Customer : ".$result['param']['mscs_no']." - ".$result['param']['mscs_nm']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Sales : ".$result['param']['mssl_no']." - ".$result['param']['mssl_nm']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Status Pembayaran : ".$result['param']['lp_statuslunas']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Cabang : ".$data['mscb_listmscb']);
		
		
		// START COLUMN HEADER //
		$row+=2;
		$table_colums = array('TGL JATUH TEMPO TOP', 'TOP VALUE', 'TOP CATATAN', 'TGL TRANSAKSI SO/SPK', 'NO SO/SPK', 'NO PO CUST', 
								'KODE CUSTOMER', 'NAMA CUSTOMER', 'KODE SALES',	'NAMA SALES', 'NILAI SO/SPK', 
								'TERBAYAR','STATUS LUNAS', 'SO/SPK CATATAN', 'SO/SPK TAG');

		foreach ($table_colums as $field) {
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
			$column += 1;
		}
		//END COLUMN HEADER
		
		
		$data = $this->db->query($result['query']);	
		$data = $data->result_array();
	
		
		$row += 1;
		foreach ($data as $key => $value) {	
			$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['tltc_tgl_jatuhtempo']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['tltc_value']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['tltc_catatan_top']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['tltc_tgltran']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $value['tltc_notran']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['tltc_pocust']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $value['tltc_mscs_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $value['mscs_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $value['tltc_mssl_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(9, $row, $value['mssl_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(10, $row, $value['tltc_total']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(11, $row, $value['tltc_terbayar']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(12, $row, $value['status_lunas']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(13, $row, $value['tltc_catatan_tran']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(14, $row, $value['tltc_tag']);
			$row += 1;
		}
        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
        //if you want to save it as .xls Excel 2007 format
        // ob_end_clean();
        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
        $filename='Top cust.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache 
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');

        // delete data on table tmp tltc
        if($this->session->userdata('rand')){
			$this->m_reporting->delete_datatemp_bayrand_tltc($this->session->userdata('rand'));
			unset($_SESSION['rand']);
			}
		}
	}

	public function lp_top_supplier(){
		if(fcek_hak_akses('.HA7.')) {
			//cek status akses area

			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}
			}

		$data['tgl_dari'] = trim($this->input->get('lp_top_tgl_dari'));
		$data['tgl_sampai'] = trim($this->input->get('lp_top_tgl_sampai'));
		$data['lp_mssp'] = $this->input->get('lp_mssp');
		$data['lp_mssp_no'] = substr($this->input->get('lp_mssp_no'), 0, 6);
		$data['lp_mssp_nm'] = $this->input->get('lp_mssp_no');
		$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
		$data['lp_statuslunas'] = $this->input->get('lp_statuslunas');
		$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');

		$result = $this->m_reporting->get_lp_top_supplier($data);
		
		// create lap dalam excel ==================================================================
		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);

		$styleArray = array(
   					 'font'  => array(
        			'bold' => true,
        			'size'  => 14,
        			'name' => 'Verdana'
    				));

		$column = 0;
		$row = 0;
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "LAPORAN TOP SUPPLIER")
		->getStyle()->applyFromArray($styleArray); 
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Periode : ".$data['tgl_dari']." - ".$data['tgl_sampai']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Supplier : ".$result['param']['mssp_jenis']." - ".$result['param']['mssp_nm']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Cabang : ".$data['mscb_listmscb']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Status Pembayaran : ".$result['param']['trpostatus']);		
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Tipe Jurnal : ".$data['lp_trju_fin']);
		
		// START COLUMN HEADER //
		$row+=2;
		$table_colums = array('TGL JATUH TEMPO TOP', 'TOP VALUE', 'TOP CATATAN', 'TGL TRANSAKSI PO', 'NO PO',
								'KODE SUPPLIER', 'NAMA SUPPLIER','CURRENCY', 'NILAI PO', 'SISA BAYAR','STATUS LUNAS', 
								'PO CATATAN', 'PO TAG');

		foreach ($table_colums as $field) {
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
			$column += 1;
		}
		//END COLUMN HEADER
		// echo "<pre>";
		// print_r($result['query']); die();
		
		$data = $this->db->query($result['query']);	
		$data = $data->result_array();
		
		$row += 1;
		foreach ($data as $key => $value) {	
			$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['tppo_tgljatuhtempo']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['tppo_value']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['tppo_cttn']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['trpo_tgl']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $value['trpo_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['trpo_mssp_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $value['mssp_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $value['trpo_curr']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $value['trpo_total']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(9, $row, $value['sisabayar']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(10, $row, $value['status_lunas']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(11, $row, $value['trpo_catatan']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(12, $row, $value['trpo_tag']);
			$row += 1;
		}
        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
        //if you want to save it as .xls Excel 2007 format
        // ob_end_clean();
        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
        $filename='Top Supplier.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache 
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');
		}
	}

	public function lp_incdlv_with_detpbyr(){
		if(fcek_hak_akses('.HA7.')) {
			if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}
	
			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}
	
			$data['judul_laporan'] = $this->input->get('judul_laporan');
			$data['lp_trid_tgl'] = trim($this->input->get('lp_trid_tgl'));
			$data['lp_trid_tgl_dari'] = trim($this->input->get('lp_trid_tgl_dari'));
			$data['lp_trid_tgl_sampai'] = trim($this->input->get('lp_trid_tgl_sampai'));		
			$data['lp_trid_tglterima_dari'] = trim($this->input->get('lp_trid_tglterima_dari'));
			$data['lp_trid_tglterima_sampai'] = trim($this->input->get('lp_trid_tglterima_sampai'));	
			$data['lp_mssp'] = $this->input->get('lp_mssp');		
			$data['lp_mssp_no'] = substr($this->input->get('lp_mssp_no'), 0, 6);
			$data['lp_mssp_nm'] = substr($this->input->get('lp_mssp_no'), 9);		
			$data['lp_id_receive_status'] = $this->input->get('lp_id_receive_status');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
			$data['lp_msgd'] = $this->input->get('lp_msgd');
			$data['lp_msgd_no'] = $this->input->get('lp_msgd_no');

			//result query dari model
			$result = $this->m_reporting->get_lp_incdlv_with_detpbyr($data);
			
			$object = new PHPExcel();
			$object->setActiveSheetIndex(0);
	
			$styleArray = array(
						'font'  => array(
						'bold' => true,
						'size'  => 14,
						'name' => 'Verdana'
						));
	
			$column = 0;
			$row = 0;
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "INCOMING DELIVERY DENGAN DETAIL PEMBAYARAN")
			->getStyle()->applyFromArray($styleArray);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Search By  ".$result['param']['periode']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Cabang : ".$data['mscb_listmscb']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Supplier : ".$result['param']['mssp']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Receive Status : ".$result['param']['receive_status']);
			$row+=1;
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Data Fin : ".$result['param']['trju_fin']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Gudang : ".$result['param']['msgd_no']);
			
			$row+=2;
			$table_colums = array('Incoming Delivery No', 'Created Date', 'Receive Date', 'Supplier ID', 'Supplier Name', 'Supplier Type', 
				'Currency', 'Kurs', 'Amount (RP/USD)', 'Total DDP (RP/USD)', 'Paid (RP/USD)', 'PIB Total', 'PIB Paid', 'PIB Adjustment', 'PIB Paid Date', 'Shipping Fee Total', 'Shipping Fee Paid', 'Shipping Fee Adjustment', 'Shipping Fee Paid Date',
				'Payment Date', 'Tanggal Cair', 'Payment Type', 'Payment From', 'Payment Currency', 'Payment Kurs', 'Amount (RP/USD)', 'Payment Notes', 
				'Incoming Delivery Notes');		
			foreach ($table_colums as $field) {
				$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
				$column += 1;
			}
	
			$data = $this->db->query($result['query']);
			$data = $data->result_array();		
	
			$no_prev = "";
			$row += 1;		
			foreach ($data as $key => $value) {
				if($value['trid_tglterima'] == "0000-00-00"){
					$value['trid_tglterima'] ="";
				}else { 
					$value['trid_tglterima'] = $value['trid_tglterima'];
				}

				$col = 0;
				if($no_prev != $value['trid_no']){
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trid_no']);$col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trid_tgl']);$col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trid_tglterima']);$col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trid_mssp_no']);$col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['mssp_nm']);$col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['mssp_jenis']);$col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trpo_curr']);$col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trid_kurs']);$col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trid_total']);$col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['dpp']);$col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['terbayar']);$col++;

					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trid_totalbea']);$col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['terbayar_beamasuk']);$col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['adj_beamasuk']);$col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['pbidbm_tglbayar']);$col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trid_totalbiayakirim']);$col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['terbayar_shipping_fee']);$col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['adj_shipping_fee']);$col++;
					$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['pbidbk_tglbayar']);$col++;

					$no_prev=$value['trid_no'];
				} else {
					$col = 19;
				}

				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['pbpo_tgl']);$col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['pbpo_tglcair']);$col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['msjb_nm']);$col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['payment_from']);$col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trpo_curr']);$col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['pbpo_kurs']);$col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['pbpo_jlhbayar']);$col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['pbpo_catatan']);$col++;
				$object->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $value['trid_catatan']);$col++;
				$row += 1;
			}
		
			//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
			//if you want to save it as .xls Excel 2007 format
			// ob_end_clean();
			$objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
			$filename='INCOMING DELIVERY DENGAN DETAIL PEMBAYARAN.xls'; //save our workbook as this file name
			header('Content-Type: application/vnd.ms-excel'); //mime type
			header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
			header('Cache-Control: max-age=0'); //no cache 
			//force user to download the Excel file without writing it to server's HD
			$objWriter->save('php://output');
		}
	}

	public function lp_faktur_penj_det(){
	if(fcek_hak_akses('.HA7.')) {
		if(count($this->input->get('mscb_listmscb')) > 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N'){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			if(count($this->input->get('mscb_listmscb')) == 1){
				if($this->session->userdata('user_aktif')['msus_allcabang'] == 'N' && $this->session->userdata('user_aktif')['msus_mscb_no'] != $this->input->get('mscb_listmscb')[0]){
					echo "Periksa pada filter Cabang, Anda hanya memiliki akses cabang ".$this->session->userdata('user_aktif')['msus_mscb_no'];
					die();
				}	
			}

			$data['judul_laporan'] = $this->input->get('judul_laporan');
			$data['lp_trsd_tgl'] = trim($this->input->get('lp_trsd_tgl'));
			$data['lp_trsd_tgl_dari'] = trim($this->input->get('lp_trsd_tgl_dari'));
			$data['lp_trsd_tgl_sampai'] = trim($this->input->get('lp_trsd_tgl_sampai'));		
			$data['lp_trsd_tglkirim_dari'] = trim($this->input->get('lp_trsd_tglkirim_dari'));
			$data['lp_trsd_tglkirim_sampai'] = trim($this->input->get('lp_trsd_tglkirim_sampai'));	
			$data['lp_trsd_tglconf_dari'] = trim($this->input->get('lp_trsd_tglconfirm_dari'));	
			$data['lp_trsd_tglconf_sampai'] = trim($this->input->get('lp_trsd_tglconfirm_sampai'));		
			$data['lp_mscs'] = $this->input->get('lp_mscs');		
			$data['lp_mscs_no'] = substr($this->input->get('lp_mscs_no'), 0, 6);
			$data['lp_mscs_nm'] = substr($this->input->get('lp_mscs_no'), 9);		
			$data['lp_mssl'] = $this->input->get('lp_mssl');
			$mssl_no = explode(":", $this->input->get('lp_mssl_no'));
			$data['lp_mssl_no'] = trim($mssl_no[0]);
			$data['lp_sd_dlv_status'] = $this->input->get('lp_sd_dlv_status');
			$data['lp_sd_conf_status'] = $this->input->get('lp_sd_confirm_status');
			$data['mscb_listmscb'] = (($this->input->get('mscb_listmscb') != '') ? ".". implode('.', $this->input->get('mscb_listmscb')). "." : '');
			$data['lp_trju_fin'] = $this->input->get('lp_trju_fin');
			$data['lp_msgd'] = $this->input->get('lp_msgd');
			$data['lp_msgd_no'] = $this->input->get('lp_msgd_no');

			//result query dari model
		$result = $this->m_reporting->get_lp_faktur_penj($data);
		
		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);

		$styleArray = array(
   					'font'  => array(
        			'bold' => true,
        			'size'  => 14,
        			'name' => 'Verdana'
    				));

		$column = 0;
		$row = 0;
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "RINGKASAN FAKTUR PENJUALAN DENGAN DETAIL PEMBAYARAN")
		->getStyle()->applyFromArray($styleArray);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Search By  ".$result['param']['periode']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Cabang : ".$data['mscb_listmscb']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Customer : ".$result['param']['mscs']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Delivery Status : ".$result['param']['dlv_status']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Sales : ".$result['param']['mssl']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Confirm Dlv Status : ".$result['param']['conf_status']);
		$row+=1;
		$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, "Data Fin : ".$result['param']['trju_fin']);
		$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, "Gudang : ".$result['param']['msgd_no']);
		
		$row+=2;
		$table_colums = array('Sales Delivery No', 'Created Date', 'Delivery Date', 'Confirm Date', 'PO Customer No', 'Customer ID', 'Customer Name', 'Customer Type', 
			'Faktur Amount', 'Total DDP', 'Paid', 'Payment Received Date', 'Tanggal Cair', 'Payment Type', 'Amount', 'Payment Notes', 
			'Retur Total', 'Sales', 'Delivery Notes');		
		foreach ($table_colums as $field) {
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $field);
			$column += 1;
		}

		$data = $this->db->query($result['query']);
		$data = $data->result_array();		

		$no_prev = "";
		$row += 1;		
		foreach ($data as $key => $value) {
			if($value['trsd_tglkirim'] == "0000-00-00"){
				$value['trsd_tglkirim'] ="";
			}else 
				$value['trsd_tglkirim'] = $value['trsd_tglkirim'];

			if($value['trsd_tglbalik'] == "0000-00-00"){
				$value['trsd_tglbalik'] ="";
			}else
				$value['trsd_tglbalik'] = $value['trsd_tglbalik'];

		if($no_prev != $value['trsd_no']){
			$object->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $value['trsd_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $value['trsd_tgl']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $value['trsd_tglkirim']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $value['trsd_tglbalik']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $value['trso_pocust']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $value['trsd_mscs_no']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $value['mscs_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $value['mscs_jenis']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $value['trsd_total']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(9, $row, $value['dpp']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(10, $row, $value['trsd_terbayar']);
			$no_prev=$value['trsd_no'];
		}
			$object->getActiveSheet()->setCellValueByColumnAndRow(11, $row, $value['pbso_tglterima']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(12, $row, $value['pbso_tglcair']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(13, $row, $value['msjb_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(14, $row, $value['pbso_jlhbayar']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(15, $row, $value['pbso_catatan']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(16, $row, $value['trsr_total']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(17, $row, $value['mssl_nm']);
			$object->getActiveSheet()->setCellValueByColumnAndRow(18, $row, $value['trsd_catatan']);
			$row += 1;
		}
      
        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel5' (and adjust the filename extension, also the header mime type)
        //if you want to save it as .xls Excel 2007 format
        // ob_end_clean();
        $objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
        $filename='Faktur Detail.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache 
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');
		}
	}


	private function show_report($path, $query, $param = array()){
		$xml = new DOMDocument();
		$xml->load($path);
		$nodes = $xml->getElementsByTagName('queryString') ;
		if ($nodes->length > 0) {			
		   $xml->getElementsByTagName("queryString")->item(0)->nodeValue = "";
		   $xml->getElementsByTagName("queryString")->item(0)->appendChild($xml->createCDATASection($query));		   		   
		   $xml->save($path);
		   $this->jasper->execute($path, $param);
		   // ob_end_clean();
		}else{
			echo 'Nodes query not found.';
		}
	}

	public function barcode(){									
		$path = APPPATH.'libraries/jasper/reports/report3.jrxml';		
		$this->show_report($path, 'select * from tr_so');
	}

	public function lp_trans_jurnal_hpp(){
		$data['periode_bulan'] = $this->input->get('monthpicker');
		$data['periode_tahun'] = $this->input->get('yearpicker');
		$data['opsi_cabang'] = $this->input->get('opsi_cabang');
		$data['cabang'] = $this->input->get('v_mscb_no');
		$data['random_number'] = rand(0, 10000);	
		$months = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Augustus', 'September', 'Oktober', 'November', 'Desember'];				

		$result = $this->m_reporting->get_trans_jurnal_hpp($data);		

		if(count($result) <= 0){
			exit('Tidak ada hasil');
		}
		
		/* INSTANCE OBJEK EXCEL
		-------------------------*/
		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);

		$styleArray = array(
			'font'  => array(
		 	'bold' => true,
		 	'size'  => 14,
		 	'name' => 'Verdana'
		));

		/* TULIS JUDUL LAPORAN
		-----------------------*/
		$column = 0;
		$row = 1;
		$object->getActiveSheet()
		->setCellValueByColumnAndRow($column, $row, "LAPORAN TRANSAKSI YANG MENJURNAL HPP")
		->getStyle()->applyFromArray($styleArray);

		/* TULIS INFO PERIODE
		----------------------*/		
		$row = 2;
		$idx_month = $data['periode_bulan'] - 1;
		
		$object->getActiveSheet()
		->setCellValueByColumnAndRow($column, $row, "Periode :  ". $months[$idx_month]. " ". $data['periode_tahun']);
		

		/* TULIS JUDUL KOLOM
		----------------------*/		
		$arr_title = array('tmptjh_trju_no' 	=> 'No. Jurnal',
							'tmptjh_trju_tgl' 	=> 'Tgl Jurnal',
							'tmptjh_trans_no' 	=> 'No. Transaksi',
							'tmptjh_mspd_no' 	=> 'No. Produk',
							'mspd_nm' 			=> 'Nama Produk',
							'tmptjh_qty' 		=> 'Qty',
							'tmptjh_hpp' 		=> 'HPP',
							'total_hpp' 		=> 'Total HPP',
							'tmptjh_catatan' 	=> 'Catatan');		

		$column = 0;
		$row = 3;
		foreach ($arr_title as $key => $val) {			
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $val);			
			$column += 1;
		}		
	
		/* TULIS DATA PERBARIS
		-----------------------*/		
		$row = 4;
		if(count($result) > 0){
			foreach($result as $idx => $data){
				$column = 0;
				foreach ($arr_title as $key => $val) {			
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, $row, $data[$key]);			
					$column += 1;
				}		
				$row += 1;
			}
		}
		
		/* HASIL OUTPUT LAPORAN EXCEL
		------------------------------*/
		$objWriter = PHPExcel_IOFactory::createWriter($object, 'Excel5');
        $filename='lp_trans_jurnal_hpp.xls';
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="'.$filename.'"');
        header('Cache-Control: max-age=0');        
        $objWriter->save('php://output');
	}
}