<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class sales_inquery extends MY_Controller {
	private $data = array();

	function __construct(){
		parent::__construct();
		$this->load->model('sales/m_sales_inquery');
		$this->load->model('data_master/m_produk');
		$this->load->model('setting/m_currency_rates');
		$this->load->model('data_master/m_user');		
		$this->load->helper('security');		
	}

	public function index($tipe_trans = null){
		
		if($tipe_trans == null || $tipe_trans == 'F' || $tipe_trans == 'f') {
			if(!fcek_hak_akses('.HB7.')){
				redirect('forbidden');
			}

			$tipe_trans = 'F';
		} else {
			if(!fcek_hak_akses('.HB8.')){
				redirect('forbidden');
			}

			if(($this->session->userdata('svlogin') == 'C') && ($tipe_trans == 'C' || $tipe_trans == 'c')) {
				$tipe_trans = 'C';
			} else {
				redirect('sales_inquery');
			}
		}
		
		$data = array();
		$data['per_page'] = 15;
		$data['request_from'] = 'list';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		// $data['tipe_trans']	= ($tipe_trans == null || $tipe_trans == 'F') ? '' : 'C';
		$data['tipe_trans']	= $tipe_trans;
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('sales/sales_inquery/v_sales_inquery_list', $data);
		$this->load->view('v_footer');			
	}

	public function sales_inquery_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_inquery');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['sales_inquery_list'] = $this->m_sales_inquery->get_sales_inquery_list($arr_filter, false, $per_page, $offset, $fn, $sort);
		$data['request_from'] = $this->input->post('request_from');

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['sales_inquery_list']);
		}
		else {
			$pagination['total_list'] = $this->m_sales_inquery->get_sales_inquery_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['sales_inquery_list'] = $this->load->view('sales/sales_inquery/v_sales_inquery_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}
	
	public function sales_inquery_new($tipe_trans = null){	
		if(!fcek_hak_akses('.CA1.')) {
			redirect('forbidden');
		}

		if($tipe_trans == null || $tipe_trans == 'F' || $tipe_trans == 'f') {
			$tipe_trans = 'F';
		} else {
			if(($this->session->userdata('svlogin') == 'C') && ($tipe_trans == 'C' || $tipe_trans == 'c')) {
				$tipe_trans = 'C';
			} else {
				redirect('sales_inquery');
			}
		}

		// if($tipe_trans != null){			
		// 	if($this->session->userdata('svlogin') == 'C' && $tipe_trans != 'F' && $tipe_trans != 'C' ||
		// 		$this->session->userdata('svlogin') == 'F' && $tipe_trans != null && $tipe_trans != 'F'){				
		// 		redirect('sales_inquery');
		// 	}
		// }

		$data = array();
		$data['action'] = 'new';
		$data['kurs'] = $this->m_currency_rates->get_currency_rates();		
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		// $data['tipe_trans']	= ($tipe_trans == null || $tipe_trans == 'F') ? '' : 'C';
		$data['tipe_trans']	= $tipe_trans;
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('sales/sales_inquery/v_sales_inquery_form',$data);
		$this->load->view('v_footer');		
	}

	public function sales_inquery_view($trsi_no){	
		if(!fcek_hak_akses('.CA0.')) {
			redirect('forbidden');
		}

		if (is_null($trsi_no) || !$this->m_sales_inquery->get_sales_inquery($trsi_no)) {
			redirect('sales_inquery');
			return;
		}
		$data = array();				
		$data = $this->m_sales_inquery->get_sales_inquery($trsi_no);			
		$data['kurs'] = $this->m_currency_rates->get_currency_rates();		
			
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		$data['action'] = 'view';
		$data['tipe_trans']	= $data['header']['trsi_fin'];
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('sales/sales_inquery/v_sales_inquery_form',$data);
		$this->load->view('v_footer');		
	}


	public function sales_inquery_print(){
		$this->load->library('java_bridge');
		$trsi_no = $this->input->get('trsi_no');
		$paper_size = $this->input->get('paper_size');

		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];
		

		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}

		if($paper_size == 'A5'){
			$path = APPPATH.'prints\sales\sales_inquery\p_sales_inquery_A5.jrxml';
		}elseif($paper_size == 'A4') {
			$path = APPPATH.'prints\sales\sales_inquery\p_sales_inquery_A4.jrxml';
		}
				
		$params = new Java("java.util.HashMap");
		$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
		$params->put("P_TRSI_NO",new Java('java.lang.String', $trsi_no));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$this->java_bridge->print_data($path, $params);
	}

	public function sales_inquery_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_inquery');		
		$this->form_validation->set_rules($this->config_validation());
		$vok = true;
		$error_apv = false;

		// set data transaksi
		if($vok){
			$this->data['trsi_cekint'] = $this->input->post('trsi_cekint');
			$this->data['action'] = $this->input->post('action');

			if($this->data['action'] == 'NEW'){
				$trsi_mscb_no = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$trsi_tgl = $this->input->post('trsi_tgl');
				$bulan = substr($trsi_tgl, 5, 2);			
				$tahun = substr($trsi_tgl, 2, 2);			
				$separator = ($this->input->post('trsi_fin') == 'F') ? '-' : '_';
				$trsi_kode_depan = $trsi_mscb_no."SI".$tahun.$bulan.$separator;
				$this->data['header']['trsi_no'] = $this->m_sales_inquery->sales_inquery_kode_auto($trsi_kode_depan);
				$this->data['header']['trsi_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['header']['trsi_mscb_no'] = $trsi_mscb_no;
				$this->data['header']['trsi_tgl'] = $trsi_tgl;
				$this->data['header']['trsi_void'] = 0;
				$this->data['header']['trsi_fin'] = $this->input->post('trsi_fin');
				$this->data['header']['trsi_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('trsi_fin') == 'C') ? 'A' : 'R';
			}

			if($this->data['action'] != 'NEW'){
				$this->data['header']['trsi_no'] = $this->input->post('trsi_no');
			}

			if($this->data['action'] == 'STCOPY'){				
				$this->data['header']['trsi_stcopy'] = ($this->input->post('trsi_stcopy') == 'R') ? 'X' : 'R';
			}
				
			$this->data['header']['trsi_mssl_no'] = $this->input->post('trsi_mssl_no');
			$this->data['header']['trsi_statusppn'] = 'Y';
			$this->data['header']['trsi_mscs_no'] = substr($this->input->post('trsi_mscs_no'), 0, 6);			
			$this->data['header']['trsi_alamatkirim'] = fhapus_kutip($this->input->post('trsi_alamatkirim'));
			$this->data['header']['trsi_cp'] = fhapus_kutip($this->input->post('trsi_cp'));
			$this->data['header']['trsi_kurs'] = ftodouble($this->input->post('trsi_kurs'));
			$this->data['header']['trsi_pocust'] = fhapus_kutip($this->input->post('trsi_pocust')); 			
			$this->data['header']['trsi_total'] = ftodouble($this->input->post('trsi_total'));
			$this->data['header']['trsi_catatan'] = fhapus_kutip($this->input->post('trsi_catatan'));
			$this->data['header']['trsi_tag'] = fhapus_kutip($this->input->post('trsi_tag'));						
			$this->data['header']['trsi_lsupd'] = date('Y-m-d H:i:s');
			$this->data['header']['trsi_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
			$this->data['header']['trsi_top'] = fhapus_kutip($this->input->post('trsi_top'));
			$this->data['header']['trsi_tglexp'] = fhapus_kutip($this->input->post('trsi_tglexp'));

			$ul_idx = 0;

			if($this->data['action'] == 'EDIT' || $this->data['action'] == 'VOID'){
				$this->data['userlog'][$ul_idx]['msul_tgl'] = $this->data['header']['trsi_lsupd'];
				$this->data['userlog'][$ul_idx]['msul_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['userlog'][$ul_idx]['msul_catatan'] = substr(trim('['.$this->data['action']. '] SLS.INQ '. $this->data['header']['trsi_no']. ' CUST:'. substr($this->input->post('trsi_mscs_no'), 9). ' '. fhapus_kutip($this->input->post('trsi_tag')). ' '. fhapus_kutip($this->input->post('trsi_catatan'))), 0, 250);
			}

			$dtsi = $this->input->post('dtsi');			
			$temp_dtsi = $this->input->post('temp_dtsi');			

			foreach ($dtsi as $key => $value) {
				for ($i=0; $i < count($dtsi[$key]); $i++) { 					
					if ($dtsi['dtsi_mspd_no'][$i] != '') {	
						$this->data['detail'][$i]['dtsi_no'] = $this->data['header']['trsi_no'];					
						if($key == 'dtsi_mspd_no' || $key == 'dtsi_seq' || $key == 'dtsi_seqpaket' || $key == 'dtsi_statuspaket' || $key == 'dtsi_mdpp_no'){
							$this->data['detail'][$i][$key] = $value[$i];
						}elseif($key == 'dtsi_msus_no') {
							$this->data['detail'][$i][$key] = $value[$i];
							if($dtsi['dtsi_msus_no'][$i] != ''){								
								$ul_idx += 1; 
								$this->data['userlog'][$ul_idx]['msul_tgl'] = $this->data['header']['trsi_lsupd'];
								$this->data['userlog'][$ul_idx]['msul_msus_no'] = $dtsi['dtsi_msus_no'][$i];
								$this->data['userlog'][$ul_idx]['msul_catatan'] = substr(trim('[APV.HRG.SI] '.$this->data['header']['trsi_no']. ' MIN Rp '. $dtsi['dtsi_minprice'][$i]. ' DI APPROVE Rp '.  $dtsi['dtsi_nett'][$i]. ' PRODUK: '. $dtsi['dtsi_mspd_no'][$i]. ' - '. $temp_dtsi['mspd_nm'][$i]), 0, 250);
							}
						}else{
							$this->data['detail'][$i][$key] = ftodouble($value[$i]);							
						}						
					}					
				}
			}								
		}				

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;				
				$msg = $this->form_validation->error_array();				
			}
		}

		// cek valid data transaksi
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_trans($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
				$error_apv = $hasil_cek['error_apv'];
			}
		}			
		

		// simpan data
		if($vok){							
			$vresult = $this->m_sales_inquery->sales_inquery_simpan($this->data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}			
		}

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';				
  	 		$result['trsi_no'] = $this->data['header']['trsi_no'];
		}	

		// gagal simpan data
		if (!$vok) {
			if($error_apv == true){
				$result['response'] = 'perlu_acc';				
			}else{
				$result['response'] = 'gagal';					
			}
			$result['error_message'] = $msg;
		}	

		echo json_encode($result);			        
	}

	public function sales_inquery_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_inquery');

		$data = array();
		$data['per_page'] = 13;
		$data['request_from'] = 'popup';
		$data['tipe_trans'] = $this->input->post('tipe_trans');

		$respon = array();
		$respon['popup'] = $this->load->view('sales/sales_inquery/v_sales_inquery_popup',$data,true);	
		echo json_encode($respon);		
	}

	public function approve_underminprice(){		
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'sales_inquery');

		$vok = true;
		$msg = '';		

		if($this->input->post('jenis_otorisasi') == 'K'){			
			$key_otorisasi = $this->input->post('key_otorisasi');
			$user_otorisasi = $this->input->post('user_otorisasi');
			$kode_otorisasi = $this->input->post('kode_otorisasi');
			$kode_otorisasi_gen = fkode_otorisasi_gen($user_otorisasi, $key_otorisasi);
			$msus_data = $this->m_user->get_user_byotoritas($user_otorisasi,'.CA7.');

			if($vok && $user_otorisasi == ''){
				$vok = false;
				$msg = 'Please input user otorisasi';
			}			

			if($vok && $kode_otorisasi != $kode_otorisasi_gen){
				$vok = false;
				$msg = 'User Otorisasi or Kode Otorisasi is invalid';
			}

			if($vok && count($msus_data) <= 0){
				$vok = false;
				$msg = 'User Otorisasi does not have permissions';
			}
		}

		if($this->input->post('jenis_otorisasi') == 'L'){
			$msus_nm = $this->input->post('msus_nm');
			$msus_pswd = do_hash($this->input->post('msus_pswd'),'md5');		
			$msus_data = $this->m_user->get_user_aktif($msus_nm,$msus_pswd);

			if($vok && $msus_nm == ''){
				$vok = false;
				$msg = 'Please input username';
			}

			if($vok && $this->input->post('msus_pswd') == ''){
				$vok = false;
				$msg = 'Please input password';
			}

			if($vok && count($msus_data) <= 0){
				$vok = false;
				$msg = 'Userame and password do not match or User is not allowed';
			}

			if($vok && preg_match("/(.CA7.)/i", $msus_data[0]['msug_hakakses']) == false){
				$vok = false;
				$msg = 'User does not have permissions';
			}
		}		

		if($vok){
			$result['response'] = "sukses";			
			$result['msus_no'] = $msus_data[0]['msus_no'];
		}else{								
			$result['response'] = "gagal";			
			$result['error_message'] = $msg;		
			$result['mt_rand'] = mt_rand(100000, 999999);		
		}

		echo json_encode($result);		
	}

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'trsi_mscs_no',
		                'label' => 'Customer',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        ),
		        array(
		                'field' => 'trsi_mssl_no',
		                'label' => 'Sales',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )
		);
		return $config;
	}

	public function cek_valid_data_trans($menu, $data){
			// keterangan :
			// $menu = NEW | EDIT | VOID			

			$msg = '';
			$hsl = true;
			$error_apv = false;

			// cek produk harus dipilih
			if($hsl){
				if(!isset($this->data['detail'])){
					$hsl = false;					
					$msg = 'Please select product';					
				}	
			}

			// cek harga bftax tidak boleh dibawah harga minimum (hasil hitungan (pricelist - % 1, 2 dan 3) di ms_kategori)
			if($hsl){
				if($menu == 'NEW' || $menu == 'EDIT'){
					$msg .= 'The price of the following products is less than the minimum price. To continue the process, please input approval:';
					if(isset($data['detail'])){
						foreach ($data['detail'] as $key => $value) {
							if (($data['detail'][$key]['dtsi_mdpp_no'] == '') || ($data['detail'][$key]['dtsi_mdpp_no'] != '' && $data['detail'][$key]['dtsi_statuspaket'] == 'P')) {
								// $dtsi_bftax = fhapus_kutip(ftodouble($data['detail'][$key]['dtsi_bftax']));
								$dtsi_nett = fhapus_kutip(ftodouble($data['detail'][$key]['dtsi_nett']));
								$dtsi_minprice = fhapus_kutip(ftodouble($data['detail'][$key]['dtsi_minprice']));
								if($dtsi_nett < $dtsi_minprice && $data['detail'][$key]['dtsi_msus_no'] == ""){								
									$msg .= ' <br/> - Product ID: '.$data['detail'][$key]['dtsi_mspd_no'];
									$hsl = false;													
									$error_apv = true;
								}
							}

							unset($this->data['detail'][$key]['dtsi_minprice']);
							unset($this->data['detail'][$key]['dtsi_msus_no']);							
						}					
					}				
				}
			}

			// cek produk mesin tidak boleh > 1
			if($hsl){
				if($menu == 'NEW' || $menu == 'EDIT'){					
					if(isset($data['detail'])){
						foreach ($data['detail'] as $key => $value) {							
							if ($data['detail'][$key]['mspd_reqserialno'] == 'Y' && $data['detail'][$key]['dtsi_qty'] > 1) {
								$hsl = false;																					
								$msg = 'Machine products can not be more than one';
							}							
							unset($this->data['detail'][$key]['mspd_reqserialno']);
						}					
					}				
				}
			}
					
			// utk pengecekan cekint Sales Inquery, 
			// Valid = CekInt tidak berubah			
			if ($hsl && (($menu == 'EDIT') || ($menu == 'VOID'))) {
				if($this->m_sales_inquery->get_sales_inquery_cekint($data['header']['trsi_no'], $data['trsi_cekint']) == false){
					$hsl = false;
					$msg = 'Data have been changed by another user. Please Refresh the page';
				}else{
					$this->m_sales_inquery->set_sales_inquery_cekint($data['header']['trsi_no']);
				}			
			}

			return array('valid'=>$hsl, 'msg'=>$msg, 'error_apv' => $error_apv);
	}	

}