<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class transfer_keluar extends MY_Controller {	
	private $data = array();

	function __construct(){
		parent::__construct();	
		$this->load->model('finance_and_acc/m_transfer_keluar');	
		$this->load->model('purchase/m_incoming_delivery');
		$this->load->model('finance_and_acc/m_po_payment');
		$this->load->model('finance_and_acc/m_jurnal');		
		$this->load->model('setting/m_setting_account');			
		$this->load->model('setting/m_currency_rates');
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function index(){			
		// cek hak akses		
		if(!fcek_hak_akses('.EJ0.')){				
			exit('Cannot access this page.');
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/transfer_keluar/v_transfer_keluar_list', $data);
		$this->load->view('v_footer');			
	}

	public function transfer_keluar_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'transfer_keluar');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['transfer_keluar_list'] = $this->m_transfer_keluar->get_transfer_keluar_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['transfer_keluar_list']);
		}
		else {
			$pagination['total_list'] = $this->m_transfer_keluar->get_transfer_keluar_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['transfer_keluar_list'] = $this->load->view('finance_and_acc/transfer_keluar/v_transfer_keluar_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}

	public function transfer_keluar_new()
	{
		// cek hak akses		
		if(!fcek_hak_akses('.EJ1.')){				
			exit('Cannot access this page.');
		}		
		
		$data['action'] = 'NEW';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		$data['kurs'] = $this->m_currency_rates->get_currency_rates();
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/transfer_keluar/v_transfer_keluar_form',$data);
		$this->load->view('v_footer');		
	}

	public function transfer_keluar_view()
	{
		// cek hak akses		
		if(!fcek_hak_akses('.EJ1.')){				
			exit('Cannot access this page.');
		}
		
		$trfk_no = $this->input->get('trfk_no');
		$data = $this->m_transfer_keluar->get_transfer_keluar($trfk_no);
		$data['pbpo'] = $this->m_po_payment->get_po_payment_bytrfkno($trfk_no);		
		
		$data['action'] = 'VIEW';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		$data['kurs'] = $this->m_currency_rates->get_currency_rates();
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('finance_and_acc/transfer_keluar/v_transfer_keluar_form',$data);
		$this->load->view('v_footer');			
	}

	public function transfer_keluar_simpan()
	{
		// Proteksi supaya tidak bisa di akses dari URL 		
		if(!$this->input->is_ajax_request()) {
		   exit('No direct script access allowed');
		}

		$vok = true;
		$msg = '';

		// set data
		if($vok){
			$data = array();
			$data['action'] = $this->input->post('action');									
			$data['trfk_cekint'] = $this->input->post('trfk_cekint');
			$trfk_tgltransfer = $this->input->post('trfk_tgltransfer');

			if($data['action'] == 'NEW'){
				$bulan = substr($trfk_tgltransfer, 5, 2);
				$tahun = substr($trfk_tgltransfer, 2, 2);
				$kode_depan = "TFK".$tahun.$bulan.'-';
				$data['tr']['trfk_no'] = $this->m_transfer_keluar->transfer_keluar_kode_auto($kode_depan);    
				$data['tr']['trfk_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$data['tr']['trfk_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$data['tr']['trfk_void'] = 0;
				$data['tr']['trfk_nprint'] = 0;
			}

			if($data['action'] != 'NEW'){
				$data['tr']['trfk_no'] = fhapus_kutip($this->input->post('trfk_no'));
			}

			$data['tr']['trfk_tgltransfer'] = $trfk_tgltransfer;
			$data['tr']['trfk_curr'] = $this->input->post('trfk_curr');
			$data['tr']['trfk_kurs'] = ftodouble($this->input->post('trfk_kurs'));
			$data['tr']['trfk_mssp_no'] = ($this->input->post('trfk_mssp_no') == '') ? '' : str_replace("-", "", fhapus_kutip(substr($this->input->post('trfk_mssp_no'), 0, 6))); 			
			$data['tr']['trfk_msap_no_tfk'] = fhapus_kutip($this->input->post('trfk_msap_no_tfk'));
			$data['tr']['trfk_msap_no_slh'] = fhapus_kutip($this->input->post('trfk_msap_no_slh'));
			$data['tr']['trfk_total'] = ftodouble($this->input->post('trfk_total'));
			$data['tr']['trfk_used'] = ftodouble($this->input->post('trfk_used'));
			$data['tr']['trfk_catatan'] = fhapus_kutip($this->input->post('trfk_catatan'));			
			$data['tr']['trfk_tag'] = fhapus_kutip($this->input->post('trfk_tag'));							
			$data['tr']['trfk_lsupd'] = date('Y-m-d H:i:s');
			$data['tr']['trfk_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];	

			$pbyr = $this->input->post('pbyr');

			if(isset($pbyr)){																
				foreach ($pbyr['jlhbayar'] as $key => $value) {
					if ($pbyr['jlhbayar'][$key] != '') {							
						$data['pbpo'][$key]['pbpo_no'] = $this->m_po_payment->po_payment_kode_auto(substr($pbyr['refno'][$key], 0, 12));
						$data['pbpo'][$key]['pbpo_seq'] = 1;
						$data['pbpo'][$key]['pbpo_refno'] = $pbyr['refno'][$key];
						$data['pbpo'][$key]['pbpo_msjb_no'] = 0;
						$data['pbpo'][$key]['pbpo_jenis'] = 'T';
						$data['pbpo'][$key]['pbpo_bayardp'] = 'T';
						$data['pbpo'][$key]['pbpo_jlhbayar'] = ftodouble($pbyr['jlhbayar'][$key]);
						$data['pbpo'][$key]['pbpo_catatan'] = '';
						$data['pbpo'][$key]['pbpo_tgl'] = $pbyr['tglbyr'][$key]. ' '. date('H:i:s');
						$data['pbpo'][$key]['pbpo_tglcair'] = $pbyr['tglbyr'][$key];
						$data['pbpo'][$key]['pbpo_void'] = 0;
						$data['pbpo'][$key]['pbpo_cekint'] = 1;
						$data['pbpo'][$key]['pbpo_lsupd'] = date('Y-m-d H:i:s');
						$data['pbpo'][$key]['pbpo_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
						$data['pbpo'][$key]['pbpo_nprint'] = 0;
						$data['pbpo'][$key]['pbpo_tag'] = '';
						$data['pbpo'][$key]['pbpo_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
						$data['pbpo'][$key]['pbpo_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no']; 
						$data['pbpo'][$key]['pbpo_trpt_no'] = '';
						$data['pbpo'][$key]['pbpo_kurs'] = $data['tr']['trfk_kurs'];
						$data['pbpo'][$key]['pbpo_refnopbyr'] = $data['tr']['trfk_no'];						
					}					
				}
			}													
		}

		// cek form validation
		if($vok){
			$this->form_validation->set_rules($this->config_validation());
			if($this->form_validation->run() == FALSE){
				$vok = false;				
				$msg = $this->form_validation->error_array();
			}
		}

		// cek valid data transaksi
		if($vok) {
			$hasil_cek = $this->cek_valid_data_trans($data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error_message'=>$hasil_cek['msg']);				
			}
		}

		// Simpan data
		if($vok){
			$vresult = $this->m_transfer_keluar->transfer_keluar_simpan($data);			
			if($vresult == 0){
				$vok = false;				
				$msg = array('error_message' => 'Error Query');
			}
		}		
		
		// Berhasil simpan data
		if($vok){
			$this->session->set_userdata('response','sukses');
			$result['response'] = 'sukses';
  	 		$result['trfk_no'] = $data['tr']['trfk_no'];
		}
				
		// Gagal simpan data							
		if(!$vok){
			$result['response'] = 'gagal';  	 		
  	 		$result['error_message'] = $msg;	  	 		
		}	

		echo json_encode($result);
	}	

	private function config_validation(){
		$config = array(		        			        			        
					array(
			                'field' => 'trfk_mssp_no',
			                'label' => 'Supplier',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Silakan input %s. <br>',			                        
			                )
			        ),
			        array(
			                'field' => 'trfk_msap_no_tfk',
			                'label' => 'Akun Bank',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Silakan input %s. <br>',			                        
			                )
			        ),
			        array(
			                'field' => 'trfk_total',
			                'label' => 'Total Transfer Masuk',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Silakan input %s. <br>',			                        
			                )
			        ),
			        array(
			                'field' => 'trfk_kurs',
			                'label' => 'Kurs',
			                'rules' => 'required',
			                'errors' => array(
			                        'required' => ' Silakan input %s. <br>',			                        
			                )
			        )   
		);		

		return $config;
	}

	private function cek_valid_data_trans($data){
		$vok = true;
		$msg = '';
		$pbyr = $this->input->post('pbyr');

		if($data['action'] == 'NEW' || $data['action'] == 'EDIT'){						
			// cek pembayaran harus diinput
			if($vok && !isset($data['pbpo'])){
				$vok = false;
				$msg = 'Please input payment.';	
			}

			// cek total bayar tidak boleh > total transfer
			if($vok && ftodouble($this->input->post('totalbyr')) > ftodouble($this->input->post('totaltrasfer'))){
				$vok = false;
				$msg = 'Total bayar tidak boleh > total transfer.';	
			}

			// akun bank in transit harus disetting
			if($vok && !$this->m_setting_account->get_setting_account_byid('BINT')){
				$vok = false;				
				$msg = 'Akun Bank In Transit belum di setting <br>';
				$msg .= 'Cek di menu Setting >> Trans Account';
			}

			if(isset($data['pbpo'])){
				foreach ($data['pbpo'] as $key => $value) {				
					if($vok && ftodouble($data['pbpo'][$key]['pbpo_jlhbayar']) > ftodouble($pbyr['sisabayar'][$key])){
						$vok = false;
						$msg = 'Jumlah bayar tidak boleh > dari sisa bayar.<br>';
						$msg .= 'No. Trans: '. $pbyr['refno'][$key];
						break;
					}					

					// utk pengecekan trid_cekint, 
					// Valid = CekInt tidak berubah
					if($vok){
						if($this->m_incoming_delivery->get_incoming_delivery_cekint($pbyr['refno'][$key], $pbyr['cekint'][$key]) == false){
							$vok = false;
							$msg = 'Data have been changed by another user. Please Refresh the page<br>';								
							$msg .= 'No. Trans: '. $pbyr['refno'][$key].'<br>';
							break;
						}
					}
				}				
			}			
		}			

		// utk pengecekan cekint, 
		// Valid = CekInt tidak berubah
		if ($vok && $data['action'] != 'NEW') {
			if($this->m_transfer_keluar->cek_exists_cekint($data['tr']['trfk_no'], $data['trfk_cekint']) == false){
				$vok = false;
				$msg = 'Data have been changed by another user. Please Refresh the page';
			}else{
				$this->m_transfer_keluar->set_transfer_keluar_cekint($data['tr']['trfk_no']);
			}
		}				

		return array('valid'=>$vok, 'msg'=>$msg);
	}

}