<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class user extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_user');		
		$this->load->helper('security');		
	}

	public function index(){			
		if(!fcek_hak_akses('.AK0.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['per_page'] = 15;
		$data['request_from'] = 'list';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/user/v_user_list', $data);
		$this->load->view('v_footer');			
	}

	public function user_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'user');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['user_list'] = $this->m_user->get_user_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['user_list']);
		}
		else {
			$pagination['total_list'] = $this->m_user->get_user_list($arr_filter, true);		
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['user_list'] = $this->load->view('data_master/user/v_user_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}
	
	public function user_new(){	
		if(!fcek_hak_akses('.AK1.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/user/v_user_form',$data);
		$this->load->view('v_footer');		
	}

	public function user_view($msus_no){	
		if(!fcek_hak_akses('.AK0.')) {
			redirect('forbidden');
		}

		if (is_null($msus_no) || count($this->m_user->get_user($msus_no)) <= 0) {
			redirect('user');
			return;
		}
		$data = array();
		$data['action'] = 'view';		
		$data['user'] = $this->m_user->get_user($msus_no);		
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);	
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/user/v_user_form',$data);
		$this->load->view('v_footer');		
	}

	public function user_new_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'user');

		$result = array();	
		$this->form_validation->set_rules($this->config_new_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{
			if($this->m_user->get_username(null,$this->input->post('msus_nm')) != 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('msus_nm' => 'User Name already exists');					   				
				echo json_encode($result);	
			}else{									
				$data = array();
				$data['msus_no'] = $this->m_user->user_kode_auto();
				$data['msus_allcabang'] = $this->input->post('msus_allcabang');
				$data['msus_nm'] = fhapus_kutip($this->input->post('msus_nm'));				
				$data['msus_pswd'] = do_hash($this->input->post('msus_pswd'),'md5');
				$data['msus_msug_no'] = $this->input->post('msus_msug_no');			
				$data['msus_mscb_no'] = $this->input->post('msus_mscb_no');
				$data['msus_catatan'] = fhapus_kutip($this->input->post('msus_catatan'));
				$data['msus_aktif'] = 1; //(($this->input->post('msus_aktif') == 'on') ? 1 : 0);						
				$data['msus_lsupd'] = date('Y-m-d H:i:s');
				$data['msus_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_user->user_new_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');
					$result['response'] = 'sukses';				
	      	 		$result['msus_no'] = $data['msus_no'];	      	 		
	      	 		echo json_encode($result);
				}
			}
		}
      
	}

	public function user_edit_simpan(){					
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'user');

		$result = array();	
		$this->form_validation->set_rules($this->config_edit_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{
			$data_status['msus_msug_no'] = $this->input->post('msus_msug_no');
			$data_status['msus_mscb_no'] = $this->input->post('msus_mscb_no');
			if($this->m_user->get_username($this->input->post('msus_no'), $this->input->post('msus_nm')) != 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('msus_nm' => 'User Name already exists');
				echo json_encode($result);				
	         }else if(fcek_status($data_status)){
	         	$result['response'] = 'gagal';
				$result['error_message'] = array('fail'=>'Can not save [OFF] status');
				echo json_encode($result);	
	         }else{	         	
	         	$data = array();
				$data['msus_no'] = $this->input->post('msus_no');
				$data['msus_allcabang'] = $this->input->post('msus_allcabang');
				$data['msus_nm'] = fhapus_kutip($this->input->post('msus_nm'));

				if($this->input->post('msus_pswd') != ''){
					$data['msus_pswd'] = do_hash($this->input->post('msus_pswd'),'md5');				
				}

				$data['msus_msug_no'] = $this->input->post('msus_msug_no');			
				$data['msus_mscb_no'] = $this->input->post('msus_mscb_no');
				$data['msus_catatan'] = fhapus_kutip($this->input->post('msus_catatan'));
				//$data['msus_aktif'] = (($this->input->post('msus_aktif') == 'on') ? 1 : 0);						
				$data['msus_lsupd'] = date('Y-m-d H:i:s');
				$data['msus_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_user->user_edit_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');			
					$result['response'] = 'sukses';				
	      	 		$result['msus_no'] = $data['msus_no'];			
	      	 		echo json_encode($result);
				}
			}	
		}				        
	}	

	public function user_changepassword_simpan(){
		$this->form_validation->set_rules($this->config_changepassword_validation());
		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{		
			$data = array();
			$data['msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['msus_pswd'] = do_hash($this->input->post('new_password'),'md5');
			if($this->m_user->user_edit_simpan($data)){
				$result['response'] = 'sukses';			
				echo json_encode($result);			
			}			
		}
	}

	public function get_user(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'user');

		echo json_encode($this->m_user->get_all_user());				
	}

	public function user_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'user');

		$data = array();
		$data['per_page'] = 13;
		$data['request_from'] = 'popup';

		$respon = array();
		$respon['popup'] = $this->load->view('data_master/user/v_user_popup',$data,true);	
		echo json_encode($respon);		
	}

	private function config_new_validation(){
		$config = array(
		        array(
		                'field' => 'msus_nm',
		                'label' => 'User Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),		        
		        array(
		                'field' => 'msus_msug_no',
		                'label' => 'User Group',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input a valid %s. '
		                )
		        ),
		        array(
		                'field' => 'msus_mscb_no',
		                'label' => 'Area',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        ),
		        array(
		                'field' => 'msus_pswd',
		                'label' => 'Password',
		                'rules' => 'alpha_numeric|required',
		                'errors' => array(
		                        'alpha_numeric' => ' Please input alpha numeric %s. ',
		                        'required' => ' Please input %s. '
		                )
		        )
		);
		return $config;
	}

	private function config_edit_validation(){
		$config = array(
		        array(
		                'field' => 'msus_nm',
		                'label' => 'User Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),		        
		        array(
		                'field' => 'msus_msug_no',
		                'label' => 'User Group',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input a valid %s. '
		                )
		        ),
		        array(
		                'field' => 'msus_mscb_no',
		                'label' => 'Area',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )
		);
		return $config;
	}

	public function user_aktif_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');

		if (!$key || !$hash_key){
			redirect('user');
  	 		return;
		}

		if ($hash_key != fenkripsi($key)){
			redirect('user');
  	 		return;
		}

		$data['msus_no'] = $this->input->post('msus_no');
		$data['msus_aktif'] = $this->input->post('msus_aktif');

		if($this->m_user->user_aktif_simpan($data)){
			$this->session->set_userdata('alert_sukses','sukses');			
			$result['response'] = 'sukses';				
  	 		$result['msus_no'] = $data['msus_no'];			
  	 		echo json_encode($result);
		}
	}	

	public function cek_otorisasi_approval(){						
		$vok = true;
		$msg = 'User Otorisasi does not have permissions';		

		if($this->input->post('jenis_otorisasi') == 'K'){			
			$key_otorisasi = $this->input->post('key_otorisasi');
			$user_otorisasi = $this->input->post('user_otorisasi');
			$kode_otorisasi = $this->input->post('kode_otorisasi');
			$kode_otorisasi_gen = fkode_otorisasi_gen($user_otorisasi, $key_otorisasi);
			$msus_data = $this->m_user->get_user_byotoritas($user_otorisasi,'.CB9.');

			if($vok && $user_otorisasi == ''){
				$vok = false;
				$msg = 'Please input user otorisasi';
			}			

			if($vok && $kode_otorisasi != $kode_otorisasi_gen){
				$vok = false;
				$msg = 'User Otorisasi or Kode Otorisasi is invalid';
			}

			if($vok && count($msus_data) <= 0){
				$vok = false;				
			}
		}		

		if($this->input->post('jenis_otorisasi') == 'L'){
			$msus_nm = $this->input->post('msus_nm');
			$msus_pswd = do_hash($this->input->post('msus_pswd'),'md5');		
			$msus_data = $this->m_user->get_user_aktif($msus_nm,$msus_pswd);			

			if($vok && count($msus_data) > 0){
				if(preg_match("/(.CB9.)/i", $msus_data[0]['msug_hakakses']) == false){
					$vok = false;
				}				
			}else{
				$vok = false;				
			}	
		}		

		if($vok){
			$result['response'] = "sukses";						
		}else{								
			$result['response'] = "gagal";			
			$result['error_message'] = $msg;
			$result['mt_rand'] = mt_rand(100000, 999999);		
		}

		echo json_encode($result);
	}

	private function config_changepassword_validation(){
		$config = array(
		        array(
		                'field' => 'new_password',
		                'label' => 'New Password',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),		        
		        array(
		                'field' => 'confirm_password',
		                'label' => 'Confirm Password',
		                'rules' => 'required|matches[new_password]',
		                'errors' => array(
		                        'required' => ' Please input %s. ',
		                        'matches' => ' Password and Confirm Password not match. '		                          
		                )
		        )
		);
		return $config;
	}
	

}