<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_acc_group extends MY_Model {

	public function get_acc_group_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'msag_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];	

		$this->db->select('*');
		$this->db->from('ms_accgrp');		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}	
	}

	/*public function acc_group_count($arr_filter){		
		$this->db->select('*');
		$this->db->from('ms_accgrp');		
		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$query = $this->db->get();
		return $query->num_rows();				
	}	*/

	public function get_acc_group($msag_no){		
		$this->db->select('*');
		$this->db->from('ms_accgrp');		
		$this->db->where('msag_no',$msag_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}

	public function get_acc_groupno($msag_no){		
		$this->db->select('msag_no');
		$this->db->from('ms_accgrp');		
		$this->db->where('msag_no',$msag_no);		
		$query = $this->db->get();						
		return $query->num_rows();
	}

	public function get_all_acc_group(){				
		$query = $this->db->get('ms_accgrp');
		return $query->result_array(); 					
	}

	public function get_acc_groupname($msag_no, $msag_nm){
		$this->db->select('*');
		$this->db->from('ms_accgrp');
		if($msag_no === null){
			$this->db->where('msag_nm',$msag_nm);
		}else{
			$this->db->where('msag_no !=',$msag_no);
			$this->db->where('msag_nm',$msag_nm);
		}						
		$query = $this->db->get();						
		return $query->num_rows();
	}	

	public function acc_group_simpan($data){						
		try{			
			$this->db->insert('ms_accgrp',$data);			
			if($this->db->affected_rows() > 0){
				return true;			 					
			} 								
		}catch (Exception $e) {
			return false;
		}		
	}

	public function acc_group_edit_simpan($data){						
		try{
			$this->db->where('msag_no', $data['msag_no']);
			$this->db->update('ms_accgrp', $data);
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	

	public function acc_group_aktif_simpan($data){						
		try{
			$msag_aktif = ($data['msag_aktif'] == 0) ? 1 : 0;
			$this->db->where(array('msag_no' => $data['msag_no']));
			$this->db->update('ms_accgrp', array('msag_aktif' => $msag_aktif));
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}

	public function get_acc_group_autocomplete($keyword){		
		$this->db->select('*');
		$this->db->from('ms_accgrp');				
		$this->db->like('msag_no', $keyword);
		$this->db->or_like('msag_nm', $keyword);
		$this->db->like('msag_listmscb', $this->session->userdata('user_aktif')['msus_mscb_no']);
		$this->db->like('msag_aktif', 1);				
		$query = $this->db->get();
		return $query->result_array();				
	}	


	
}
