<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_acc_perkiraan extends MY_Model {

	public function get_acc_perkiraan_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'msap_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];	

		$this->db->select('*');
		$this->db->from('ms_accper');
		$this->db->join('ms_accsub', 'ms_accsub.msas_no = SUBSTRING(ms_accper.msap_no,1,5)','left');
		$this->db->join('ms_accgrp', 'ms_accgrp.msag_no = SUBSTRING(ms_accper.msap_no,1,2)','left');

		$query_string = '';

		// filter berdasarkan
		//1. A = ALL
		//2. N = NOT INCLUDE SPECIAL ACCOUNT
		//2. S = HANYA SPECIAL ACCOUNT

		if(isset($arr_filter['filter_spesialacc'])){
			if($arr_filter['filter_spesialacc'] == 'N'){	
				$query_string .= ' msap_no NOT IN(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode IN("LBRG", "LBTB")) ';
			}if($arr_filter['filter_spesialacc'] == 'S'){	
				$query_string .= ' msap_no IN(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode IN("LBRG", "LBTB")) ';
			}

			unset($arr_filter['filter_spesialacc']);
		}

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}

		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}	
	}

	public function get_acc_perkiraan($msap_no){		
		$this->db->select('*');
		$this->db->from('ms_accper');		
		$this->db->where('msap_no',$msap_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}	

	public function get_all_acc_perkiraan(){				
		$query = $this->db->get('ms_accper');
		return $query->result_array(); 					
	}

	public function acc_perkiraan_kode_auto($msas_no){
		$this->db->select_max("msap_no");
		$this->db->like("msap_no", $msas_no, "after");
		$query = $this->db->get("ms_accper");
		if ($query->num_rows() == 0){
			return $msmd_no. ".00001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['msap_no'];
			$nomor = ((int) substr($kode, 6)) + 1;
			return $msas_no. '.'. sprintf("%'.05d", $nomor);
		}
	}

	public function get_acc_perkiraannm($msap_no, $msap_nm){
		$this->db->select('*');
		$this->db->from('ms_accper');
		if($msap_no === null){
			$this->db->where('msap_nm',$msap_nm);
		}else{
			$this->db->where('msap_no !=',$msap_no);
			$this->db->where('msap_nm',$msap_nm);
		}						
		$query = $this->db->get();						
		return $query->num_rows();
	}

	public function get_acc_perkiraan_autocomplete($input_name, $keyword){
		$this->db->select('*');
		$this->db->from('ms_accper');		
		$this->db->like($input_name, $keyword);
		$this->db->like('msap_listmscb', $this->session->userdata('user_aktif')['msus_mscb_no']);
		$this->db->where(array('msap_aktif' => 1));				

		$query = $this->db->get();
		return $query->result_array();				
	}

	public function get_acc_perkiraan_autocomplete_k($keyword){		
		$this->db->select('*');
		$this->db->from('ms_accper');				
		$this->db->like('msap_no', $keyword);
		$this->db->or_like('msap_nm', $keyword);
		$this->db->like('msap_listmscb', $this->session->userdata('user_aktif')['msus_mscb_no']);
		$this->db->like('msap_aktif', 1);				
		$query = $this->db->get();
		return $query->result_array();				
	}

	public function acc_perkiraan_new_simpan($data){						
		try{			
			$this->db->insert('ms_accper',$data);			
			if($this->db->affected_rows() > 0){
				return true;			 					
			} 								
		}catch (Exception $e) {
			return false;
		}		
	}

	public function acc_perkiraan_edit_simpan($data){						
		try{
			$this->db->where('msap_no', $data['msap_no']);
			$this->db->update('ms_accper', $data);
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	

	public function acc_perkiraan_aktif_simpan($data){						
		try{
			$msap_aktif = ($data['msap_aktif'] == 0) ? 1 : 0;
			$this->db->where(array('msap_no' => $data['msap_no']));
			$this->db->update('ms_accper', array('msap_aktif' => $msap_aktif));
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	

	public function get_msjb_msap_no($msjb_no){
		$this->db->select('msjb_msap_no');
		$this->db->from('ms_jnspbyr');
		$this->db->where('msjb_no', $msjb_no);
		$query = $this->db->get();
		$result = $query->result_array();
		return $result[0]['msjb_msap_no'];
	}	
	
}
