<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_customer extends MY_Model {

	public function get_customer_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'mscs_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];		

		$this->db->select('*, IFNULL((SELECT mscsda_kirim_jln FROM ms_cust_dlvyadd WHERE mscsda_no = mscs_no LIMIT 1), "") AS mscsda_kirim_jln,
								IFNULL((SELECT mscsda_kirim_kota FROM ms_cust_dlvyadd WHERE mscsda_no = mscs_no LIMIT 1), "") AS mscsda_kirim_kota,
								IFNULL((SELECT mscsda_kirim_provinsi FROM ms_cust_dlvyadd WHERE mscsda_no = mscs_no LIMIT 1), "") AS mscsda_kirim_provinsi');
		$this->db->from('ms_customer');		


		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		

		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}

		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}	
	}

	public function get_customer_dalist($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'mscsda_no', $sort = 'DESC'){
		if(!$is_count){
			$this->db->limit($per_page, $offset);		
		}	
		$this->db->select('*');
		$this->db->from('ms_cust_dlvyadd');
		$this->db->join('ms_customer', 'mscs_no = mscsda_no','left');
		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}	
	}

	public function get_customer_nalist($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'mscsna_no', $sort = 'DESC'){
		if(!$is_count){
			$this->db->limit($per_page, $offset);		
		}	
		$this->db->select('*');
		$this->db->from('ms_cust_npwpadd');
		$this->db->join('ms_customer', 'mscs_no = mscsna_no','left');
		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}	
	}

	/*public function customer_count($arr_filter){		
		$this->db->select('*');
		$this->db->from('ms_customer');		
		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$query = $this->db->get();
		return $query->num_rows();				
	}*/

	public function get_customer($mscs_no){		
		$this->db->select('*');
		$this->db->from('ms_customer');		
		$this->db->where('mscs_no',$mscs_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		$data['customer'] = $result[0];

		//Get delivery address berdasarkan mscsda_no	
		$query = $this->db->get_where('ms_cust_dlvyadd', array('mscsda_no' => $mscs_no));
		if($query->num_rows() > 0){
			$data['mscsda'] = $query->result_array();
		}

		//Get npwp address berdasarkan mscsna_no	
		$query = $this->db->get_where('ms_cust_npwpadd', array('mscsna_no' => $mscs_no));
		if($query->num_rows() > 0){
			$data['mscsna'] = $query->result_array();
		}

		return $data;

	}

	// public function get_customername($mscs_nm){		
	// 	$this->db->select('mscs_nm');
	// 	$this->db->from('ms_customer');		
	// 	$this->db->where('mscs_nm',$mscs_nm);		
	// 	$query = $this->db->get();						
	// 	return $query->num_rows();
	// }

	public function get_customername($mscs_no, $mscs_nm){		
		$this->db->select('*');
		$this->db->from('ms_customer');
		if($mscs_no === null){
			$this->db->where('mscs_nm',$mscs_nm);
		}else{
			$this->db->where('mscs_no !=',$mscs_no);
			$this->db->where('mscs_nm',$mscs_nm);
		}						
		$query = $this->db->get();						
		return $query->num_rows();
	}

	public function get_all_customer(){				
		$query = $this->db->get('ms_customer');
		return $query->result_array(); 					
	}	

	public function get_customer_autocomplete($keyword){		
		$this->db->select('*');
		$this->db->from('ms_customer');				
		$this->db->like('mscs_no', $keyword);
		$this->db->or_like('mscs_nm', $keyword);
		$this->db->like('mscs_listmscb', $this->session->userdata('user_aktif')['msus_mscb_no']);
		$this->db->like('mscs_aktif', 1);				
		$query = $this->db->get();
		return $query->result_array();				
	}	

	public function customer_kode_auto($mscs_jenis){
		$this->db->select_max("mscs_no");
		$this->db->like("mscs_no", $mscs_jenis, "after");
		$query = $this->db->get("ms_customer");
		if ($query->num_rows() == 0){
			return $mscs_jenis. "00001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['mscs_no'];
			$nomor = ((int) substr($kode, 1)) + 1;
			return $mscs_jenis. sprintf("%'.05d", $nomor);
		}
	}

	public function customer_new_simpan($data){						
		try{								

			//Insert data ms_cust_dlvyadd
			if(isset($data['mscsda'])){
				for ($i=0; $i < count($data['mscsda']); $i++) {										
				    $this->db->insert('ms_cust_dlvyadd',$data['mscsda'][$i]);		
				}			
			}

			unset($data['mscsda']);

			//Insert data ms_cust_npwpadd
			if(isset($data['mscsna'])){
				for ($i=0; $i < count($data['mscsna']); $i++) {										
				    $this->db->insert('ms_cust_npwpadd',$data['mscsna'][$i]);		
				}			
			}

			unset($data['mscsna']);

			$this->db->insert('ms_customer',$data);

			if($this->db->affected_rows() > 0){
				return true;			 					
			} 								
		}catch (Exception $e) {
			return false;
		}		
	}

	public function customer_edit_simpan($data){						
		try{

			//Delete data lama ms_cust_dlvyadd
			$this->db->delete('ms_cust_dlvyadd', array('mscsda_no' => $data['mscs_no']));

			//Insert data ms_cust_dlvyadd
			if(isset($data['mscsda'])){
				for ($i=0; $i < count($data['mscsda']); $i++) {										
				    $this->db->insert('ms_cust_dlvyadd',$data['mscsda'][$i]);		
				}			
			}

			unset($data['mscsda']);			


			//Delete data lama ms_cust_npwpadd
			$this->db->delete('ms_cust_npwpadd', array('mscsna_no' => $data['mscs_no']));

			//Insert data ms_cust_npwpadd
			if(isset($data['mscsna'])){
				for ($i=0; $i < count($data['mscsna']); $i++) {										
				    $this->db->insert('ms_cust_npwpadd',$data['mscsna'][$i]);		
				}			
			}

			unset($data['mscsna']);			

			//Update ms_customer
			$this->db->where('mscs_no', $data['mscs_no']);
			$this->db->update('ms_customer', $data);

			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	

	public function customer_aktif_simpan($data){						
		try{
			$mscs_aktif = ($data['mscs_aktif'] == 0) ? 1 : 0;
			$this->db->where(array('mscs_no' => $data['mscs_no']));
			$this->db->update('ms_customer', array('mscs_aktif' => $mscs_aktif));
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}			
}
