<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_famili extends MY_Model {

	public function get_famili_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'msfm_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];
		
		$this->db->select('*');
		$this->db->from('ms_famili');		
		$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(ms_famili.msfm_no,1,1)','left');		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}	
	}	

	/*public function famili_count($arr_filter){		
		$this->db->select('*');
		$this->db->from('ms_famili');		
		$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(ms_famili.msfm_no,1,1)','left');
		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$query = $this->db->get();
		return $query->num_rows();				
	}*/

	public function get_famili($msfm_no){		
		$this->db->select('*');
		$this->db->from('ms_famili');		
		$this->db->where('msfm_no',$msfm_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}

	public function get_familino($msfm_no){		
		$this->db->select('msfm_no');
		$this->db->from('ms_famili');		
		$this->db->where('msfm_no',$msfm_no);		
		$query = $this->db->get();						
		return $query->num_rows();
	}

	public function get_all_famili(){				
		$query = $this->db->get('ms_famili');
		return $query->result_array(); 					
	}

	public function get_familinm($msfm_no, $msfm_nm){
		$this->db->select('*');
		$this->db->from('ms_famili');
		if($msfm_no === null){
			$this->db->where('msfm_nm',$msfm_nm);
		}else{
			$this->db->where('msfm_no !=',$msfm_no);
			$this->db->where('msfm_nm',$msfm_nm);
		}						
		$query = $this->db->get();						
		return $query->num_rows();
	}	

	public function famili_new_simpan($data){						
		try{			
			$this->db->insert('ms_famili',$data);			
			if($this->db->affected_rows() > 0){
				return true;			 					
			} 								
		}catch (Exception $e) {
			return false;
		}		
	}

	public function famili_edit_simpan($data){						
		try{
			$this->db->where('msfm_no', $data['msfm_no']);
			$this->db->update('ms_famili', $data);
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	

	public function famili_aktif_simpan($data){						
		try{
			$msfm_aktif = ($data['msfm_aktif'] == 0) ? 1 : 0;
			$this->db->where(array('msfm_no' => $data['msfm_no']));
			$this->db->update('ms_famili', array('msfm_aktif' => $msfm_aktif));
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}		
	
}
