<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_jenis_bayar extends MY_Model {

	public function get_jenis_bayar_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'msjb_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('*');
		$this->db->from('ms_jnspbyr');		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}	
	}

	/*public function jenis_bayar_count($arr_filter){		
		$this->db->select('*');
		$this->db->from('ms_jnspbyr');		
		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$query = $this->db->get();
		return $query->num_rows();				
	}*/

	public function get_jenis_bayar($msjb_no){		
		$this->db->select('*');
		$this->db->from('ms_jnspbyr');		
		$this->db->where('msjb_no',$msjb_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}

	public function get_all_jenis_bayar(){				
		$query = $this->db->get('ms_jnspbyr');
		return $query->result_array(); 					
	}

	public function get_jenis_bayarname($msjb_no, $msjb_nm){		
		$this->db->select('*');
		$this->db->from('ms_jnspbyr');
		if($msjb_no === null){
			$this->db->where('msjb_nm',$msjb_nm);
		}else{
			$this->db->where('msjb_no !=',$msjb_no);
			$this->db->where('msjb_nm',$msjb_nm);
		}						
		$query = $this->db->get();						
		return $query->num_rows();
	}	

	public function jenis_bayar_kode_auto(){
		$this->db->select_max("msjb_no");
		$query = $this->db->get("ms_jnspbyr");
		if ($query->num_rows() == 0){
			return "1";
		}else {
			$result = $query->result_array();
			$nomor = $result[0]['msjb_no'] + 1;			
			return $nomor;
		}
	}

	public function jenis_bayar_new_simpan($data){						
		try{			
			$this->db->insert('ms_jnspbyr',$data);			
			if($this->db->affected_rows() > 0){
				return true;			 					
			} 								
		}catch (Exception $e) {
			return false;
		}		
	}

	public function jenis_bayar_edit_simpan($data){						
		try{
			$this->db->where('msjb_no', $data['msjb_no']);
			$this->db->update('ms_jnspbyr', $data);
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}

	public function jenis_bayar_aktif_simpan($data){						
		try{
			$msjb_aktif = ($data['msjb_aktif'] == 0) ? 1 : 0;
			$this->db->where(array('msjb_no' => $data['msjb_no']));
			$this->db->update('ms_jnspbyr', array('msjb_aktif' => $msjb_aktif));
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}		
	
}
