<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_kategori extends MY_Model {

	public function get_kategori_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'mskt_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];	
		
		$this->db->select('*');
		$this->db->from('ms_kategori');		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}

		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}	
	}

	/*public function kategori_count($arr_filter){		
		$this->db->select('*');
		$this->db->from('ms_kategori');		
		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$query = $this->db->get();
		return $query->num_rows();				
	}*/	

	public function get_kategori($mskt_no){
		$this->db->select('*, a.msap_nm AS msap_pjr_nm,
								b.msap_nm AS msap_pja_nm,
								c.msap_nm AS msap_hpr_nm,
								d.msap_nm AS msap_hpa_nm,
								e.msap_nm AS msap_inv_nm,
								f.msap_nm AS msap_srr_nm,
								g.msap_nm AS msap_sra_nm,
								h.msap_nm AS msap_spr_nm,
								i.msap_nm AS msap_spa_nm
								');
		$this->db->from('ms_kategori');		
		$this->db->join('ms_accper AS a','a.msap_no=ms_kategori.mskt_msap_no_pjr','left');		
		$this->db->join('ms_accper AS b','b.msap_no=ms_kategori.mskt_msap_no_pja','left');		
		$this->db->join('ms_accper AS c','c.msap_no=ms_kategori.mskt_msap_no_hpr','left');		
		$this->db->join('ms_accper AS d','d.msap_no=ms_kategori.mskt_msap_no_hpa','left');		
		$this->db->join('ms_accper AS e','e.msap_no=ms_kategori.mskt_msap_no_inv','left');		
		$this->db->join('ms_accper AS f','f.msap_no=ms_kategori.mskt_msap_no_srr','left');		
		$this->db->join('ms_accper AS g','g.msap_no=ms_kategori.mskt_msap_no_sra','left');		
		$this->db->join('ms_accper AS h','h.msap_no=ms_kategori.mskt_msap_no_spr','left');		
		$this->db->join('ms_accper AS i','i.msap_no=ms_kategori.mskt_msap_no_spa','left');		
		$this->db->where('mskt_no',$mskt_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}

	public function get_kategorino($mskt_no){		
		$this->db->select('mskt_no');
		$this->db->from('ms_kategori');		
		$this->db->where('mskt_no',$mskt_no);		
		$query = $this->db->get();						
		return $query->num_rows();
	}

	public function get_all_kategori(){				
		$query = $this->db->get('ms_kategori');
		return $query->result_array(); 					
	}

	public function get_kategoriname($mskt_no, $mskt_nm){
		$this->db->select('*');
		$this->db->from('ms_kategori');
		if($mskt_no === null){
			$this->db->where('mskt_nm',$mskt_nm);
		}else{
			$this->db->where('mskt_no !=',$mskt_no);
			$this->db->where('mskt_nm',$mskt_nm);
		}						
		$query = $this->db->get();						
		return $query->num_rows();
	}	

	public function kategori_simpan($data){						
		try{			
			$this->db->insert('ms_kategori',$data);			
			if($this->db->affected_rows() > 0){
				return true;			 					
			} 								
		}catch (Exception $e) {
			return false;
		}		
	}

	public function kategori_edit_simpan($data){						
		try{
			$this->db->where('mskt_no', $data['mskt_no']);
			$this->db->update('ms_kategori', $data);
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	

	public function kategori_aktif_simpan($data){						
		try{
			$mskt_aktif = ($data['mskt_aktif'] == 0) ? 1 : 0;
			$this->db->where(array('mskt_no' => $data['mskt_no']));
			$this->db->update('ms_kategori', array('mskt_aktif' => $mskt_aktif));
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	

	public function get_kategori_settacc($mskt_no, $field_name){		
		$this->db->select($field_name);
		$this->db->from('ms_kategori');		
		$this->db->where('mskt_no',$mskt_no);		
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result[0][$field_name];
		}else{
			return false;
		}
		
	}

	public function get_mskt_statusinv($mskt_no){
		$query = $this->db->get_where('ms_kategori', array('mskt_no' => $mskt_no));
		$result = $query->result_array();
		return $result[0]['mskt_statusinv'];
	}
	
}
