<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_merk extends MY_Model {

	public function get_merk_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'msmr_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('*');
		$this->db->from('ms_merk');		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}

		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	/*public function merk_count($arr_filter){		
		$this->db->select('*');
		$this->db->from('ms_merk');		
		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$query = $this->db->get();
		return $query->num_rows();				
	}	*/

	public function get_merk($msmr_no){		
		$this->db->select('*');
		$this->db->from('ms_merk');		
		$this->db->where('msmr_no',$msmr_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}

	public function get_merkno($msmr_no){		
		$this->db->select('msmr_no');
		$this->db->from('ms_merk');		
		$this->db->where('msmr_no',$msmr_no);		
		$query = $this->db->get();						
		return $query->num_rows();
	}

	public function get_all_merk(){				
		$query = $this->db->get('ms_merk');
		return $query->result_array(); 					
	}

	public function get_merknm($msmr_no, $msmr_nm){
		$this->db->select('*');
		$this->db->from('ms_merk');
		if($msmr_no === null){
			$this->db->where('msmr_nm',$msmr_nm);
		}else{
			$this->db->where('msmr_no !=',$msmr_no);
			$this->db->where('msmr_nm',$msmr_nm);
		}						
		$query = $this->db->get();						
		return $query->num_rows();
	}	

	public function merk_new_simpan($data){						
		try{			
			$this->db->insert('ms_merk',$data);			
			if($this->db->affected_rows() > 0){
				return true;			 					
			} 								
		}catch (Exception $e) {
			return false;
		}		
	}

	public function merk_edit_simpan($data){						
		try{
			$this->db->where('msmr_no', $data['msmr_no']);
			$this->db->update('ms_merk', $data);
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	

	public function merk_aktif_simpan($data){						
		try{
			$msmr_aktif = ($data['msmr_aktif'] == 0) ? 1 : 0;
			$this->db->where(array('msmr_no' => $data['msmr_no']));
			$this->db->update('ms_merk', array('msmr_aktif' => $msmr_aktif));
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	
	
}
