<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_metode_penyusutan extends MY_Model {

	public function get_metode_penyusutan_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'msmp_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];	

		$this->db->select('*');
		$this->db->from('ms_mtd_penyusutan');		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_metode_penyusutan($msmp_no){		
		$this->db->select('*');
		$this->db->from('ms_mtd_penyusutan');		
		$this->db->where('msmp_no',$msmp_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}
	
	public function metode_penyusutan_kode_auto(){
		$this->db->select_max("msmp_no");		
		$query = $this->db->get("ms_mtd_penyusutan");
		if ($query->num_rows() == 0){
			return "01";
		}else {
			$result = $query->result_array();
			$last_no = $result[0]['msmp_no'];
			$nomor = $last_no + 1;
			return sprintf("%'.02d", $nomor);
		}
	}	

	public function get_all_metode_penyusutan(){				
		$query = $this->db->get('ms_mtd_penyusutan');
		return $query->result_array(); 					
	}	

	public function metode_penyusutan_simpan($data){						
		try{		
			if($data['action'] == 'NEW'){
				$this->db->insert('ms_mtd_penyusutan',$data['ms']);						
			}

			if($data['action'] == 'EDIT'){
				$this->db->where('msmp_no', $data['ms']['msmp_no']);
				$this->db->update('ms_mtd_penyusutan', $data['ms']);
			}

			if($data['action'] == 'LOCK'){
				$msmp_aktif = ($data['ms']['msmp_aktif'] == 0) ? 1 : 0;
				$this->db->where(array('msmp_no' => $data['ms']['msmp_no']));
				$this->db->update('ms_mtd_penyusutan', array('msmp_aktif' => $msmp_aktif));
			}

			return 1;
		}catch (Exception $e) {
			return 0;
		}		
	}
	
}
