<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_paket_produk extends MY_Model {

	public function get_paket_produk_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'mspp_no', $sort = 'DESC'){
		if(!$is_count){
			$this->db->limit($per_page, $offset);		
		}
		$this->db->select('*');
		$this->db->from('ms_paket_prod');				

		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_paket_produk($mspp_no){
		$data = array();
		
		//Get paket produk header berdasarkan mspp_no	
		$this->db->select("*");
		$this->db->from('ms_paket_prod');		
		$this->db->where('mspp_no',$mspp_no);
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$result = $query->result_array();	
			$data['header'] = $result[0];
		}		
		
		//Get paket produk detail berdasarkan mspp_no	
		$this->db->select("*");
		$this->db->from('md_paket_prod');
		$this->db->join('ms_produk', 'ms_produk.mspd_no = md_paket_prod.mdpp_mspd_no','left');
		$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(ms_produk.mspd_no,1,1)','left');
		$this->db->where('mdpp_no',$mspp_no);
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail'] = $detail;
		}
		if(count($data) > 0){
			return $data;
		}else{
			return false;
		}
	}		

	public function get_paket_produkno($mspp_no){		
		$this->db->select('mspp_no');
		$this->db->from('ms_paket_prod');		
		$this->db->where('mspp_no',$mspp_no);		
		$query = $this->db->get();						
		return $query->num_rows();
	}

	public function paket_produk_new_simpan($data){						
		try {						

			//Insert data header paket produk
			$this->db->insert('ms_paket_prod',$data['header']);

			//Insert data detail paket produk
			if(isset($data['detail'])){
				for ($i=0; $i < count($data['detail']) ; $i++) {
				    $this->db->insert('md_paket_prod',$data['detail'][$i]);	
				}			
			}
				
			return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function paket_produk_edit_simpan($data){						
		try {	
				//Update data header
				$this->db->where('mspp_no', $data['header']['mspp_no']);
				$this->db->update('ms_paket_prod', $data['header']);

				//Delete data lama
				$this->db->delete('md_paket_prod', array('mdpp_no' => $data['header']['mspp_no']));
				
				//Insert data baru
				if(isset($data['detail'])){
					for ($i=0; $i < count($data['detail']) ; $i++) {									
					   $this->db->insert('md_paket_prod',$data['detail'][$i]);
					}
				}											
			return 1;	
			
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function paket_produk_aktif_simpan($data){						
		try{
			$mspp_aktif = ($data['mspp_aktif'] == 0) ? 1 : 0;
			$this->db->where(array('mspp_no' => $data['mspp_no']));
			$this->db->update('ms_paket_prod', array('mspp_aktif' => $mspp_aktif));
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}

}