<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_tipe_aktivatetap extends MY_Model {

	public function get_tipe_aktivatetap_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'msta_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];		

		$this->db->select('a.*, b.msmp_nm');
		$this->db->from('ms_tipe_asset a');		
		$this->db->join('ms_mtd_penyusutan b', 'b.msmp_no = a.msta_msmp_no','left');		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_tipe_aktivatetap($msta_no){
		$this->db->select('a.*, b.msmp_metode, b.msmp_umur, b.msmp_tarif');
		$this->db->from('ms_tipe_asset a');		
		$this->db->join('ms_mtd_penyusutan b', 'b.msmp_no = a.msta_msmp_no','left');
		$this->db->where('msta_no',$msta_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}
	
	public function tipe_aktivatetap_kode_auto(){
		$this->db->select_max("msta_no");		
		$query = $this->db->get("ms_tipe_asset");
		if ($query->num_rows() == 0){
			return "01";
		}else {
			$result = $query->result_array();
			$last_no = $result[0]['msta_no'];
			$nomor = $last_no + 1;
			return sprintf("%'.02d", $nomor);
		}
	}	

	public function get_all_tipe_aktivatetap(){				
		$this->db->select('a.*, b.msmp_metode, b.msmp_umur, b.msmp_tarif');
		$this->db->from('ms_tipe_asset a');		
		$this->db->join('ms_mtd_penyusutan b', 'b.msmp_no = a.msta_msmp_no','left');		
		$query = $this->db->get();						
		return $query->result_array(); 					
	}	

	public function tipe_aktivatetap_simpan($data){						
		try{		
			if($data['action'] == 'NEW'){
				$this->db->insert('ms_tipe_asset',$data['ms']);						
			}

			if($data['action'] == 'EDIT'){
				$this->db->where('msta_no', $data['ms']['msta_no']);
				$this->db->update('ms_tipe_asset', $data['ms']);
			}

			if($data['action'] == 'LOCK'){
				$msta_aktif = ($data['ms']['msta_aktif'] == 0) ? 1 : 0;
				$this->db->where(array('msta_no' => $data['ms']['msta_no']));
				$this->db->update('ms_tipe_asset', array('msta_aktif' => $msta_aktif));
			}

			return 1;
		}catch (Exception $e) {
			return 0;
		}		
	}
	
}
