<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_user extends MY_Model {	
	public function get_user_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'msus_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];	

		$this->db->select('*');
		$this->db->from('ms_user');
		$this->db->join('ms_usergroup', 'ms_user.msus_msug_no = ms_usergroup.msug_no','inner');
		$this->db->join('ms_cabang', 'ms_user.msus_mscb_no = ms_cabang.mscb_no','inner');
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	/*public function user_count($arr_filter){		
		$this->db->select('*');
		$this->db->from('ms_user');
		$this->db->join('ms_usergroup', 'ms_user.msus_msug_no = ms_usergroup.msug_no','inner');
		$this->db->join('ms_cabang', 'ms_user.msus_mscb_no = ms_cabang.mscb_no','inner');
		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$query = $this->db->get();
		return $query->num_rows();				
	}*/

	public function get_user($msus_no){		
		$this->db->select('*');
		$this->db->from('ms_user');
		$this->db->join('ms_usergroup', 'ms_user.msus_msug_no = ms_usergroup.msug_no','inner');
		$this->db->join('ms_cabang', 'ms_user.msus_mscb_no = ms_cabang.mscb_no','inner');
		$this->db->where('msus_no',$msus_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}

	public function get_username($msus_no, $msus_nm){		
		$this->db->select('*');
		$this->db->from('ms_user');
		if($msus_no === null){
			$this->db->where('msus_nm',$msus_nm);
		}else{
			$this->db->where('msus_no !=',$msus_no);
			$this->db->where('msus_nm',$msus_nm);
		}						
		$query = $this->db->get();						
		return $query->num_rows();
	}

	public function get_all_user(){				
		$query = $this->db->get('ms_user');
		return $query->result_array(); 					
	}	

	public function get_user_aktif($msus_nm, $msus_pswd){		
		$field_user_aktif = 'ms_user.msus_no,'
				 			.'ms_user.msus_nm,'
				 			.'ms_user.msus_mscb_no,'
				 			.'ms_user.msus_allcabang,'
				 			.'ms_user.msus_aktif,'
				 			.'ms_usergroup.msug_nm,'
				 			.'ms_usergroup.msug_hakakses,'
				 			.'ms_cabang.*';
				 			

				 			// .'ms_cabang.mscb_nm,'
				 			// .'ms_cabang.mscb_alamat,'
				 			// .'ms_cabang.mscb_prshn_nm,'
				 			// .'ms_cabang.mscb_logo,'
				 			// .'ms_cabang.mscb_line1,'
				 			// .'ms_cabang.mscb_line2';

		$this->db->select($field_user_aktif);
		$this->db->from('ms_user');
		$this->db->join('ms_usergroup', 'ms_user.msus_msug_no = ms_usergroup.msug_no','inner');
		$this->db->join('ms_cabang', 'ms_user.msus_mscb_no = ms_cabang.mscb_no','inner');
		$this->db->where('msus_nm', $msus_nm);
		$this->db->where('msus_pswd',$msus_pswd);
		$this->db->where('msus_aktif',1);
		$query = $this->db->get();				
		return $query->result_array();
	}		

	public function user_kode_auto(){
		$this->db->select_max("msus_no");
		$query = $this->db->get("ms_user");
		if ($query->num_rows() == 0){
			return "U001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['msus_no'];
			$nomor = ((int) substr($kode, 1)) + 1;
			return "U".sprintf("%'.03d", $nomor);
		}
	}

	public function user_new_simpan($data){						
		try{			
			$this->db->insert('ms_user',$data);			
			if($this->db->affected_rows() > 0){
				return true;			 					
			} 								
		}catch (Exception $e) {
			return false;
		}		
	}

	public function user_edit_simpan($data){						
		try{
			$this->db->where('msus_no', $data['msus_no']);
			$this->db->update('ms_user', $data);
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	

	public function user_aktif_simpan($data){						
		try{
			$msus_aktif = ($data['msus_aktif'] == 0) ? 1 : 0;
			$this->db->where(array('msus_no' => $data['msus_no']));
			$this->db->update('ms_user', array('msus_aktif' => $msus_aktif));
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	
	
	public function get_user_byotoritas($user_otorisasi, $kode_hak_akses){		
		$this->db->select('ms_user.msus_no');
		$this->db->from('ms_user');
		$this->db->join('ms_usergroup', 'ms_usergroup.msug_no = ms_user.msus_msug_no','left');				
		$this->db->where('msus_nm', $user_otorisasi);
		$this->db->like('msug_hakakses',$kode_hak_akses);
		$query = $this->db->get();		
		return $query->result_array();
	}
}
