<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_usergroup extends MY_Model {

	public function get_usergroup_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'msug_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];	

		$this->db->select('*');
		$this->db->from('ms_usergroup');		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function usergroup_count($arr_filter){		
		$this->db->select('*');
		$this->db->from('ms_usergroup');		
		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$query = $this->db->get();
		return $query->num_rows();				
	}

	public function get_usergroup($msug_no){		
		$this->db->select('*');
		$this->db->from('ms_usergroup');		
		$this->db->where('msug_no',$msug_no);		
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}	

	public function usergroup_kode_auto(){
		$this->db->select_max("msug_no");
		$query = $this->db->get("ms_usergroup");
		if ($query->num_rows() == 0){
			return "G001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['msug_no'];
			$nomor = ((int) substr($kode, 1)) + 1;
			return "G".sprintf("%'.03d", $nomor);
		}
	}	

	public function usergroup_simpan($data){						
		try{			
			$this->db->insert('ms_usergroup',$data);			
			if($this->db->affected_rows() > 0){
				return true;			 					
			} 								
		}catch (Exception $e) {
			return false;
		}		
	}

	public function usergroup_edit_simpan($data){						
		try{
			$this->db->where('msug_no', $data['msug_no']);
			$this->db->update('ms_usergroup', $data);
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}	

	public function get_all_usergroup(){		
		$query = $this->db->get('ms_usergroup');
		return $query->result_array(); 					
	}	

	public function usergroup_aktif_simpan($data){						
		try{
			$msug_aktif = ($data['msug_aktif'] == 0) ? 1 : 0;
			$this->db->where(array('msug_no' => $data['msug_no']));
			$this->db->update('ms_usergroup', array('msug_aktif' => $msug_aktif));
			return true;
		}catch (Exception $e) {
			return false;
		}		
	}

	public function get_gudang($num, $offset){
		// $this->db->from('ms_gudang');
		$this->db->order_by("msgd_listmscb" , "asc");
		$query = $this->db->get('ms_gudang', $num, $offset);
		return $query->result_array();
	}	
}
