<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_giro_keluar extends MY_Model {

	function __construct(){
		parent::__construct();		
		$this->load->model('setting/m_user_log');		
	}

	public function get_giro_keluar_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trgk_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('trgk.*, msap1.msap_nm as msap_nm_bgk, msap2.msap_nm as msap_nm_slh, msus_nm, mssp_nm');
		$this->db->from('tr_giro_keluar trgk');
		$this->db->join('ms_accper msap1','msap1.msap_no = trgk_msap_no_bgk', 'left');				
		$this->db->join('ms_accper msap2','msap2.msap_no = trgk_msap_no_slh', 'left');				
		$this->db->join('ms_user', 'msus_no = trgk_msus_no', 'left');
		$this->db->join('ms_supplier', 'mssp_no = trgk_mssp_no', 'left');		
		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}				
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_giro_keluar($trgk_no){		
		$data = array();
		
		$this->db->select('tr_giro_keluar.*, msap1.msap_nm as msap_nm_bgk, msap2.msap_nm as msap_nm_slh, msus_no, msus_nm, mssp_nm');
		$this->db->from('tr_giro_keluar');		
		$this->db->join('ms_user','msus_no = trgk_msus_no', 'left');				
		$this->db->join('ms_accper msap1','msap1.msap_no = trgk_msap_no_bgk', 'left');				
		$this->db->join('ms_accper msap2','msap2.msap_no = trgk_msap_no_slh', 'left');				
		$this->db->join('ms_supplier','mssp_no = trgk_mssp_no', 'left');				
		$this->db->where('trgk_no',$trgk_no);		
		$query = $this->db->get();

		if($query->num_rows() > 0){
			$result = $query->result_array();			
			$data['header'] = $result[0];
		}					

		return $data;	
	}	

	public function cek_exists_cekint($trgk_no, $trgk_cekint){		
		$query = $this->db->get_where('tr_giro_keluar', array('trgk_no' => $trgk_no, 'trgk_cekint' => $trgk_cekint));				 
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function set_giro_keluar_cekint($trgk_no){				
		$this->db->where('trgk_no', $trgk_no);
		$this->db->update('tr_giro_keluar', array('trgk_cekint' => rand(0,10000)));
	}

	public function giro_keluar_simpan($data){
		try{						
			if($data['action'] == 'NEW' || $data['action'] == 'EDIT'){								

				if($data['action'] == 'NEW'){
					// Insert data
					$this->db->insert('tr_giro_keluar',$data['tr']);
				}
			
				if($data['action'] == 'EDIT'){								
					// Update data trgk
					$this->db->where('trgk_no', $data['trgk_no_lama']);
					$this->db->update('tr_giro_keluar', $data['tr']);								

					// void pembayaran pbpo
					$this->void_pbpo_bypbpo_refnopbyr($data['trgk_no_lama']);					

					// Delete data used giro keluar 
					$this->db->delete('used_giro_keluar', array('usgk_no' => $data['trgk_no_lama']));
				}							

				// SIMPAN PEMBAYARAN PO -------------------------------------------------------------------------
				if(isset($data['pbpo'])){
					foreach ($data['pbpo'] as $key => $value) {					
						// set trid_cekint
						$this->m_incoming_delivery->set_incoming_delivery_cekint($data['pbpo'][$key]['pbpo_refno']);

						// insert pby_po
						$this->db->insert('pby_po', $data['pbpo'][$key]);	

						// update trid_terbayar
						$this->m_po_payment->update_trid_terbayar($data['pbpo'][$key]['pbpo_refno']);

						// update trpo_terbayar
						$this->m_po_payment->recalc_trpo_terbayar(substr($data['pbpo'][$key]['pbpo_no'], 0, 12));

						// simpan jurnal pbpo
						$this->jurnal_simpan_pbyr_po($data['pbpo'][$key]['pbpo_no'], $data['pbpo'][$key]['pbpo_tgl']);

						// set data used_giro_keluar
						$data_usgk['usgk_no'] = $data['pbpo'][$key]['pbpo_refnopbyr'];					
						$data_usgk['usgk_refno'] = $data['pbpo'][$key]['pbpo_no'];						
						$data_usgk['usgk_refseq'] = $data['pbpo'][$key]['pbpo_seq'];
						$data_usgk['usgk_total'] = $data['pbpo'][$key]['pbpo_jlhbayar'];

						// insert used_giro_keluar
						$this->db->insert('used_giro_keluar', $data_usgk);															
					}
				}

				// update trgk_used
				$this->update_trgk_used($data['tr']['trgk_no']);

				// Simpan jurnal giro keluar			
				$this->jurnal_simpan_tk($data['tr']['trgk_no'], $data['trgk_no_lama'], $data['tr']['trgk_tglbayar'], $data['tr']['trgk_msap_no_bgk'], $data['tr']['trgk_msap_no_slh'], $data['action']);
			}

			if($data['action'] == 'VOID'){
				// void pembayaran
				$this->void_pbpo_bypbpo_refnopbyr($data['trgk_no_lama']);				

				// void giro keluar
				$this->db->where(array('trgk_no' => $data['trgk_no_lama']));
				$this->db->update('tr_giro_keluar', array('trgk_void'=>1, 'trgk_used'=>0));

				// Delete used_giro_keluar
				$this->db->delete('used_giro_keluar', array('usgk_no' => $data['trgk_no_lama']));						

				// delete jurnal giro keluar
				$query = "DELETE dtju
							FROM dt_jurnal dtju
							LEFT JOIN tr_jurnal trju ON trju.trju_no = dtju.dtju_no
							WHERE trju_refno ='".$data['trgk_no_lama']."' AND trju_reftipe = 'GK'";
				$this->db->simple_query($query);

				$query = "DELETE trju FROM tr_jurnal trju 
							WHERE trju_refno ='".$data['trgk_no_lama']."' AND trju_reftipe = 'GK'";
				$this->db->simple_query($query);
							
				// $query = "DELETE trju, dtju
				// 			FROM dt_jurnal dtju
				// 			LEFT JOIN tr_jurnal trju ON trju.trju_no = dtju.dtju_no
				// 			WHERE trju_refno ='".$data['trgk_no_lama']."' AND trju_reftipe = 'GK'";

				// if($this->db->simple_query($query)){	
				// 	$this->db->delete('tr_jurnal', array('trju_refno'=>$data['trgk_no_lama'], 'trju_reftipe'=>'GK'));						
				// }
			}
			
			return 1;			 								
		}catch (Exception $e) {
			return 0;
		}		
	}

	private function void_pbpo_bypbpo_refnopbyr($trgk_no){
		$query = $this->db->get_where('pby_po', array('pbpo_refnopbyr' => $trgk_no, 'pbpo_void'=>0));
		if($query->num_rows() > 0){
			$data_pbpo = $query->result_array();

			foreach ($data_pbpo as $key => $value) {																	
				// void pembayaran
				$this->db->where(array('pbpo_no' => $value['pbpo_no'], 'pbpo_seq' => $value['pbpo_seq']));
				$this->db->update('pby_po', array('pbpo_void'=>1));

				// update trid_terbayar
				$this->m_po_payment->update_trid_terbayar($value['pbpo_refno']);

				// update trpo_terbayar
				$this->m_po_payment->recalc_trpo_terbayar(substr($value['pbpo_no'], 0, 12));

				// delete jurnal pbpo
				$this->jurnal_hapus($value['pbpo_no'], 'PP');				
			}					
		}
	}	

	private function jurnal_hapus($trju_refno, $trju_reftipe){
		$query = "DELETE dtju
					FROM dt_jurnal dtju
					LEFT JOIN tr_jurnal trju ON trju.trju_no = dtju.dtju_no
					WHERE trju_refno ='".$trju_refno.$trju_reftipe."' AND trju_reftipe = '".$trju_reftipe."'";
		$this->db->simple_query($query);

		$query = "DELETE trju FROM tr_jurnal trju 
					WHERE trju_refno ='".$trju_refno.$trju_reftipe."' AND trju_reftipe = '".$trju_reftipe."'";
		$this->db->simple_query($query);

		// $query = "DELETE trju, dtju
		// 					FROM dt_jurnal dtju
		// 					LEFT JOIN tr_jurnal trju ON trju.trju_no = dtju.dtju_no
		// 					WHERE trju_refno ='".$trju_refno.$trju_reftipe."' AND trju_reftipe = '".$trju_reftipe."'";

		// if($this->db->simple_query($query)){	
		// 	$this->db->delete('tr_jurnal', array('trju_refno'=>$trju_refno.$trju_reftipe, 'trju_reftipe'=>$trju_reftipe));						
		// }
	}

	public function update_trgk_used($trgk_no){		
		$query = "UPDATE tr_giro_keluar					
					SET trgk_used = (
										SELECT IFNULL(SUM(usgk_total), 0)
										FROM used_giro_keluar										
										WHERE usgk_no = '".$trgk_no."'										
									)
					WHERE trgk_no = '".$trgk_no."'";
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}		
	}		

	public function jurnal_simpan_pbyr_po($pbpo_no, $pbpo_tgl){
		$vok = true;				

		// Generate kode jurnal
		$bulan = substr($pbpo_tgl, 5, 2);			
		$tahun = substr($pbpo_tgl, 2, 2);
		$kd_depan = "JA".$tahun.$bulan.'-';
		$trju_no = $this->m_jurnal->jurnal_kode_auto($kd_depan);		

		// Insert header jurnal
		if($vok){
			$str_query = "INSERT INTO tr_jurnal(
							trju_no,
							trju_tgl,
							trju_tipe,
							trju_catatan,
							trju_refno,
							trju_reftipe,
							trju_void,
							trju_lsupd,
							trju_lsusr,
							trju_cekint,
							trju_msus_no,
							trju_mscb_no,
							trju_fin,
							trju_stcopy,
							trju_lscopy,
							trju_tag)
						(SELECT '".$trju_no."',
								pbpo_tgl,
								'A',
								SUBSTRING(CONCAT(pbpo_tag,' ', pbpo_no, '/', trpo_mssp_no, ' - ', mssp_nm), 1, 250),								
								CONCAT(pbpo_no,'PP'),
								'PP',
								0,
								pbpo_lsupd,
								pbpo_lsusr,
								1,
								pbpo_msus_no,
								pbpo_mscb_no,
								'F',
								'R',
								0,
								''
						FROM pby_po
						LEFT JOIN tr_po ON trpo_no = SUBSTRING(pbpo_no, 1, 12)
						LEFT JOIN ms_supplier ON mssp_no = trpo_mssp_no
						WHERE pbpo_no = '".$pbpo_no."'
						LIMIT 1)";

			if(!$this->db->simple_query($str_query)){					
				echo $str_query; 
				die('Error create header jurnal. '. $pbpo_no);
			}
		}

		// Insert jurnal debet
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq, 
								IF(mssp_jenis = 'L', (SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'HUTL'),
													(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'HUTI')),
								pbpo_jlhbayar,
								0,
								'',
								''
								FROM pby_po
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r								
								LEFT JOIN tr_po ON trpo_no = SUBSTRING(pbpo_no, 1, 12)
								LEFT JOIN tr_in_dlv ON trid_no = pbpo_refno
								LEFT JOIN ms_supplier ON mssp_no = trpo_mssp_no
								WHERE pbpo_no = '".$pbpo_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $pbpo_no);
			}
		}

		// Insert jurnal kredit
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'HUGI'),
								0,
								pbpo_jlhbayar,
								'',
								''
								FROM pby_po
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r
								WHERE pbpo_no = '".$pbpo_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $pbpo_no);
			}
		}				
	}	

	public function jurnal_simpan_tk($trgk_no, $trgk_no_lama, $trgk_tglbayar, $trgk_msap_no_bgk, $trgk_msap_no_slh, $action){
		$vok = true;		
		$trju_no = '';		

		if($vok && $action == 'NEW'){
			// Generate kode jurnal
			$bulan = substr($trgk_tglbayar, 5, 2);			
			$tahun = substr($trgk_tglbayar, 2, 2);
			$kd_depan = "JA".$tahun.$bulan.'-';
			$trju_no = $this->m_jurnal->jurnal_kode_auto($kd_depan);		

			// Insert header jurnal
			$str_query = "INSERT INTO tr_jurnal(
							trju_no,
							trju_tgl,
							trju_tipe,
							trju_catatan,
							trju_refno,
							trju_reftipe,
							trju_void,
							trju_lsupd,
							trju_lsusr,
							trju_cekint,
							trju_msus_no,
							trju_mscb_no,
							trju_fin,
							trju_stcopy,
							trju_lscopy,
							trju_tag)
						(SELECT '".$trju_no."',
								'".$trgk_tglbayar."',
								'A',
								SUBSTRING(CONCAT(trgk_tag,' ', trgk_catatan), 1, 250),								
								trgk_no,
								'GK',
								0,
								'".date('Y-m-d H:i:s')."',
								'".$this->session->userdata('user_aktif')['msus_no']."',								
								1,
								'".$this->session->userdata('user_aktif')['msus_no']."',
								'".$this->session->userdata('user_aktif')['msus_mscb_no']."',
								'F',
								'R',
								0,
								''
						FROM tr_giro_keluar						
						WHERE trgk_no = '".$trgk_no."')";

			if(!$this->db->simple_query($str_query)){					
				echo $str_query; 
				die('Error create header jurnal. '. $trgk_no);
			}
		}

		if($vok && $action == 'EDIT'){
			$trju_no = $this->get_trju_no_byrefno($trgk_no_lama, 'GK');

			$str_query = "UPDATE tr_jurnal
							LEFT JOIN tr_giro_keluar ON trgk_no = '".$trgk_no."'
							SET trju_catatan = SUBSTRING(CONCAT(trgk_tag,' ', trgk_catatan), 1, 250),
								trju_refno = trgk_no,
								trju_lsupd = trgk_lsupd,
								trju_lsusr = trgk_lsusr
							WHERE trju_no = '".$trju_no."'";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error update tr_jurnal. '. $trgk_no);
			}
		}

		if($vok){
			// Delete dt_jurnal giro keluar
			$str_query = "DELETE FROM dt_jurnal WHERE dtju_no ='".$trju_no."'";		
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error delete dt_jurnal. '. $trgk_no);
			}
		}		

		// Insert jurnal debet
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'HUGI'),
								trgk_used,
								0,
								'',
								''
								FROM tr_giro_keluar
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r								
								WHERE trgk_no = '".$trgk_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $trgk_no);
			}
		}

		// Insert jurnal debet
		if($vok){			
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								'".$trgk_msap_no_slh."',
								trgk_total - trgk_used,
								0,
								'',
								''
								FROM tr_giro_keluar
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r																
								WHERE trgk_no = '".$trgk_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $trgk_no);
			}			
		}

		// Insert jurnal kredit
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								'".$trgk_msap_no_bgk."',
								0,
								trgk_total,
								'',
								''
								FROM tr_giro_keluar
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r
								WHERE trgk_no = '".$trgk_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $trgk_no);
			}
		}	

		// delete akun selisih jika tidak ada selisih
		if($vok){
			$str_query = "DELETE FROM dt_jurnal WHERE dtju_no = '".$trju_no."' AND dtju_seq = 2 AND dtju_debet = 0";

			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error delete akun. '. $trgk_no);
			}			
		}
	}

	public function get_trju_no_byrefno($trju_refno, $trju_reftipe){
		$query = $this->db->get_where('tr_jurnal', array('trju_refno'=>$trju_refno, 'trju_reftipe'=>$trju_reftipe));
		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result[0]['trju_no'];
		}else{
			return '';
		}
	}

	public function is_trgk_no_exists($trgk_no, $trgk_no_lama = null){										
		$this->db->select('trgk_no');
		$this->db->from('tr_giro_keluar');			
		$this->db->where('trgk_no',$trgk_no);		

		if($trgk_no_lama != null){
			$this->db->where('trgk_no !=',$trgk_no_lama);			
		}

		$query = $this->db->get();		
		if($query->num_rows() > 0){			
			return true;			
		}else{			
			return false;			
		}		
	}
	
}
