<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_giro_masuk extends MY_Model {

	function __construct(){
		parent::__construct();		
		$this->load->model('setting/m_user_log');		
	}

	public function get_giro_masuk_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trgm_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('trgm.*, msus_nm, mscs_nm');
		$this->db->from('tr_giro_masuk trgm');
		$this->db->join('ms_user', 'msus_no = trgm_msus_no', 'left');
		$this->db->join('ms_customer', 'mscs_no = trgm_mscs_no', 'left');

		$query_string = '';

		//Status Pencairan
		//1. Sudah Cair
		//2. Belum Cair
		if(isset($arr_filter['st_cair'])){			
			if($arr_filter['st_cair'] == 1){				
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= ' trgm_tglcair != "0000-00-00"';
			}elseif($arr_filter['st_cair'] == 2){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= ' trgm_tglcair = "0000-00-00"';
			}
			unset($arr_filter['st_cair']);
		}

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}
		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}				
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_giro_masuk($trgm_no){		
		$data = array();
		
		$this->db->select('tr_giro_masuk.*, msus_no, msus_nm, mscs_nm, a.msap_nm as msap_nm_bgm, b.msap_nm as msap_nm_slh');
		$this->db->from('tr_giro_masuk');		
		$this->db->join('ms_user','msus_no = trgm_msus_no', 'left');				
		$this->db->join('ms_accper a','a.msap_no = trgm_msap_no_bgm', 'left');				
		$this->db->join('ms_accper b','b.msap_no = trgm_msap_no_slh', 'left');				
		$this->db->join('ms_customer','mscs_no = trgm_mscs_no', 'left');				
		$this->db->where('trgm_no',$trgm_no);		
		$query = $this->db->get();

		if($query->num_rows() > 0){
			$result = $query->result_array();			
			$data['header'] = $result[0];
		}	

		$this->db->select('pby_so.*');
		$this->db->from('pby_so');				
		$this->db->where('pbso_refnopbyr',$trgm_no);		
		$this->db->where('pbso_void',0);		
		$query = $this->db->get();

		if($query->num_rows() > 0){			
			$data['pbso'] = $query->result_array();			
		}			

		$this->db->select('pby_spk.*');
		$this->db->from('pby_spk');				
		$this->db->where('pbspk_refnopbyr',$trgm_no);		
		$this->db->where('pbspk_void',0);		
		$query = $this->db->get();

		if($query->num_rows() > 0){			
			$data['pbspk'] = $query->result_array();			
		}			

		return $data;	
	}

	public function is_trgm_no_exists($trgm_no, $trgm_no_lama = null){										
		$this->db->select('trgm_no');
		$this->db->from('tr_giro_masuk');			
		$this->db->where('trgm_no',$trgm_no);		

		if($trgm_no_lama != null){
			$this->db->where('trgm_no !=',$trgm_no_lama);			
		}

		$query = $this->db->get();		
		if($query->num_rows() > 0){			
			return true;			
		}else{			
			return false;			
		}		
	}

	public function cek_exists_cekint($trgm_no, $trgm_cekint){		
		$query = $this->db->get_where('tr_giro_masuk', array('trgm_no' => $trgm_no, 'trgm_cekint' => $trgm_cekint));				 
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function set_giro_masuk_cekint($trgm_no){				
		$this->db->where('trgm_no', $trgm_no);
		$this->db->update('tr_giro_masuk', array('trgm_cekint' => rand(0,10000)));
	}

	public function giro_masuk_simpan($data){
		try{						
			if($data['action'] == 'NEW'){								
				// Insert data
				$this->db->insert('tr_giro_masuk',$data['tr']);			
			}

			if($data['action'] == 'EDIT'){								
				// Update data
				$this->db->where('trgm_no', $data['trgm_no_lama']);
				$this->db->update('tr_giro_masuk', $data['tr']);				
			}

			if($data['action'] == 'PENCAIRAN_GIRO'){								
				// Update data
				$this->db->where('trgm_no', $data['trgm_no_lama']);
				$this->db->update('tr_giro_masuk', $data['tr']);

				// Simpan jurnal
				$this->jurnal_simpan_giro_cair($data['trgm_no_lama'], $data['tr']['trgm_tglcair'], $data['tr']['trgm_msap_no_bgm'], $data['tr']['trgm_msap_no_slh']);
			}

			if($data['action'] == 'BATAL_PENCAIRAN_GIRO'){
				// Update data
				$this->db->where('trgm_no', $data['trgm_no_lama']);
				$this->db->update('tr_giro_masuk', $data['tr']);

				// hapus jurnal
				$query = "DELETE dtju
							FROM dt_jurnal dtju
							LEFT JOIN tr_jurnal trju ON trju.trju_no = dtju.dtju_no
							WHERE trju_refno ='".$data['trgm_no_lama']."' AND trju_reftipe = 'GM'";
				$this->db->simple_query($query);

				$query = "DELETE trju FROM tr_jurnal trju 
							WHERE trju_refno ='".$data['trgm_no_lama']."' AND trju_reftipe = 'GM'";
				$this->db->simple_query($query);
				
				// $query = "DELETE trju, dtju
				// 			FROM dt_jurnal dtju
				// 			LEFT JOIN tr_jurnal trju ON trju.trju_no = dtju.dtju_no
				// 			WHERE trju_refno ='".$data['trgm_no_lama']."' AND trju_reftipe = 'GM'";

				// if($this->db->simple_query($query)){
				// 	$this->db->delete('tr_jurnal', array('trju_refno'=>$data['trgm_no_lama'], 'trju_reftipe'=>'GM'));
				// }
			}		

			if($data['action'] == 'VOID'){								
				// void data
				$this->db->where('trgm_no', $data['tr']['trgm_no']);
				$this->db->update('tr_giro_masuk', array('trgm_void'=>1));
			}
			
			return 1;			 								
		}catch (Exception $e) {
			return 0;
		}		
	}

	public function update_trgm_used($trgm_no){		
		$query = "UPDATE tr_giro_masuk					
					SET trgm_used = (
										SELECT IFNULL(SUM(usgm_total), 0)
										FROM used_giro_masuk										
										WHERE usgm_no = '".$trgm_no."'										
									)
					WHERE trgm_no = '".$trgm_no."'";
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}		
	}	

	public function giro_masuk_payment_simpan($data){
		try{
			
			// SIMPAN PEMBAYARAN SO -------------------------------------------------------------------------
			if(isset($data['pbso'])){
				foreach ($data['pbso'] as $key => $value) {					
					// set trsd_cekint
					$this->m_sales_delivery->set_sales_delivery_cekint($data['pbso'][$key]['pbso_refno']);

					// insert pby_so
					$this->db->insert('pby_so', $data['pbso'][$key]);					

					// update trsd_terbayar
					$this->m_so_payment->update_trsd_terbayar($data['pbso'][$key]['pbso_refno']);

					// update trso_terbayar
					$this->m_so_payment->recalc_trso_terbayar(substr($data['pbso'][$key]['pbso_no'], 0, 12));

					// simpan jurnal
					$this->jurnal_simpan_pbyr($data['pbso'][$key]['pbso_no'], $data['pbso'][$key]['pbso_tglterima']);

					// set data used_giro_masuk
					$data_usgm['usgm_no'] = $data['pbso'][$key]['pbso_refnopbyr'];					
					$data_usgm['usgm_refno'] = $data['pbso'][$key]['pbso_no'];
					$data_usgm['usgm_refjenis'] = 'S';
					$data_usgm['usgm_refseq'] = $data['pbso'][$key]['pbso_seq'];
					$data_usgm['usgm_total'] = $data['pbso'][$key]['pbso_jlhbayar'];

					// insert used_giro_masuk
					$this->db->insert('used_giro_masuk', $data_usgm);															
				}
			}					

			// SIMPAN PEMBAYARAN SPK -------------------------------------------------------------------------
			if(isset($data['pbspk'])){
				foreach ($data['pbspk'] as $key => $value) {					
					// set trspk_cekint
					$this->m_spk->set_spk_cekint(substr($data['pbspk'][$key]['pbspk_no'],0,12));

					// insert pby_spk
					$this->db->insert('pby_spk', $data['pbspk'][$key]);							

					// simpan jurnal pbspk
					$this->m_spk->jurnal_simpan_pbyr_spk($data['pbspk'][$key]['pbspk_no'], $data['pbspk'][$key]['pbspk_tglterima'], 'PUGI');

					// set data used_transfer_masuk
					$data_usgm['usgm_no'] = $data['pbspk'][$key]['pbspk_refnopbyr'];					
					$data_usgm['usgm_refno'] = $data['pbspk'][$key]['pbspk_no'];
					$data_usgm['usgm_refjenis'] = 'K';
					$data_usgm['usgm_refseq'] = 0;
					$data_usgm['usgm_total'] = $data['pbspk'][$key]['pbspk_jlhbayar'];

					// insert used_giro_masuk
					$this->db->insert('used_giro_masuk', $data_usgm);															
				}
			}

			// update trgm_used
			$this->update_trgm_used($data['trgm_no']);			

			return 1;
		}catch (Exception $e) {
			return 0;
		}	
	}	

	public function status_pencairan_giro($trgm_no){
		$query = $this->db->get_where('tr_giro_masuk', array('trgm_tglcair !=' => '0000-00-00', 'trgm_no' => $trgm_no));

		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function jurnal_simpan_pbyr($pbso_no, $pbso_tglterima){
		$vok = true;		

		// Generate kode jurnal
		$bulan = substr($pbso_tglterima, 5, 2);			
		$tahun = substr($pbso_tglterima, 2, 2);
		$kd_depan = "JA".$tahun.$bulan.'-';
		$trju_no = $this->m_jurnal->jurnal_kode_auto($kd_depan);		

		// Insert header jurnal
		if($vok){
			$str_query = "INSERT INTO tr_jurnal(
							trju_no,
							trju_tgl,
							trju_tipe,
							trju_catatan,
							trju_refno,
							trju_reftipe,
							trju_void,
							trju_lsupd,
							trju_lsusr,
							trju_cekint,
							trju_msus_no,
							trju_mscb_no,
							trju_fin,
							trju_stcopy,
							trju_lscopy,
							trju_tag)
						(SELECT '".$trju_no."',
								pbso_tglterima,
								'A',
								SUBSTRING(CONCAT(pbso_tag,' ', pbso_no, '/', trso_mscs_no, ' - ', mscs_nm), 1, 250),								
								CONCAT(pbso_no,'PY'),
								'PY',
								0,
								pbso_lsupd,
								pbso_lsusr,
								1,
								pbso_msus_no,
								pbso_mscb_no,
								'F',
								'R',
								0,
								''
						FROM pby_so
						LEFT JOIN tr_so ON trso_no = SUBSTRING(pbso_no, 1, 12)
						LEFT JOIN ms_customer ON mscs_no = trso_mscs_no
						WHERE pbso_no = '".$pbso_no."'
						LIMIT 1)";

			if(!$this->db->simple_query($str_query)){					
				echo $str_query; 
				die('Error create header jurnal. '. $pbso_no);
			}
		}

		// Insert jurnal debet
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PUGI'),
								pbso_jlhbayar,
								0,
								'',
								''
								FROM pby_so
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r
								WHERE pbso_no = '".$pbso_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $pbso_no);
			}
		}

		// Insert jurnal kredit
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq, 
								IF(mscs_jenis = 'A', (SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUA'),
													(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUR')),
								0,
								pbso_jlhbayar,
								'',
								''
								FROM pby_so
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r								
								LEFT JOIN tr_so ON trso_no = SUBSTRING(pbso_no, 1, 12)
								LEFT JOIN ms_customer ON mscs_no = trso_mscs_no
								WHERE pbso_no = '".$pbso_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $pbso_no);
			}
		}
	}

	public function jurnal_simpan_giro_cair($trgm_no, $trgm_tglcair, $trgm_msap_no_bgm, $trgm_msap_no_slh){
		$vok = true;		

		// Generate kode jurnal
		$bulan = substr($trgm_tglcair, 5, 2);			
		$tahun = substr($trgm_tglcair, 2, 2);
		$kd_depan = "JA".$tahun.$bulan.'-';
		$trju_no = $this->m_jurnal->jurnal_kode_auto($kd_depan);		

		// Insert header jurnal
		if($vok){
			$str_query = "INSERT INTO tr_jurnal(
							trju_no,
							trju_tgl,
							trju_tipe,
							trju_catatan,
							trju_refno,
							trju_reftipe,
							trju_void,
							trju_lsupd,
							trju_lsusr,
							trju_cekint,
							trju_msus_no,
							trju_mscb_no,
							trju_fin,
							trju_stcopy,
							trju_lscopy,
							trju_tag)
						(SELECT '".$trju_no."',
								'".$trgm_tglcair. ' ' .date('H:i:s')."',
								'A',
								SUBSTRING(CONCAT(trgm_tag,' ', trgm_catatan), 1, 250),
								trgm_no,
								'GM',
								0,
								'".date('Y-m-d H:i:s')."',
								'".$this->session->userdata('user_aktif')['msus_no']."',								
								1,
								'".$this->session->userdata('user_aktif')['msus_no']."',
								'".$this->session->userdata('user_aktif')['msus_mscb_no']."',
								'F',
								'R',
								0,
								''
						FROM tr_giro_masuk						
						WHERE trgm_no = '".$trgm_no."')";

			if(!$this->db->simple_query($str_query)){					
				echo $str_query; 
				die('Error create header jurnal. '. $trgm_no);
			}
		}

		// Insert jurnal debet
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								'".$trgm_msap_no_bgm."',
								trgm_total,
								0,
								'',
								''
								FROM tr_giro_masuk
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r
								WHERE trgm_no = '".$trgm_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $trgm_no);
			}
		}		

		// Insert jurnal kredit
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PUGI'),
								0,
								trgm_used,
								'',
								''
								FROM tr_giro_masuk
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r
								WHERE trgm_no = '".$trgm_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $trgm_no);
			}
		}

		// Insert jurnal kredit
		if($vok){			
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								'".$trgm_msap_no_slh."',
								0,
								trgm_total - trgm_used,
								'',
								''
								FROM tr_giro_masuk
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r
								WHERE trgm_no = '".$trgm_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $trgm_no);
			}			
		}

		// delete akun selisih jika tidak ada selisih
		if($vok){
			$str_query = "DELETE FROM dt_jurnal WHERE dtju_no = '".$trju_no."' AND dtju_seq = 3 AND dtju_kredit = 0";

			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error delete akun. '. $trgm_no);
			}			
		}
	}
	
}
