<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_transfer_keluar extends MY_Model {

	function __construct(){
		parent::__construct();		
		$this->load->model('setting/m_user_log');		
	}

	public function get_transfer_keluar_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trfk_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('trfk.*, msap1.msap_nm as msap_nm_tfk, msap2.msap_nm as msap_nm_slh, msus_nm, mssp_nm');
		$this->db->from('tr_transfer_keluar trfk');
		$this->db->join('ms_accper msap1','msap1.msap_no = trfk_msap_no_tfk', 'left');				
		$this->db->join('ms_accper msap2','msap2.msap_no = trfk_msap_no_slh', 'left');				
		$this->db->join('ms_user', 'msus_no = trfk_msus_no', 'left');
		$this->db->join('ms_supplier', 'mssp_no = trfk_mssp_no', 'left');		
		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}				
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_transfer_keluar($trfk_no){		
		$data = array();
		
		$this->db->select('tr_transfer_keluar.*, msap1.msap_nm as msap_nm_tfk, msap2.msap_nm as msap_nm_slh, msus_no, msus_nm, mssp_nm');
		$this->db->from('tr_transfer_keluar');		
		$this->db->join('ms_user','msus_no = trfk_msus_no', 'left');				
		$this->db->join('ms_accper msap1','msap1.msap_no = trfk_msap_no_tfk', 'left');				
		$this->db->join('ms_accper msap2','msap2.msap_no = trfk_msap_no_slh', 'left');				
		$this->db->join('ms_supplier','mssp_no = trfk_mssp_no', 'left');				
		$this->db->where('trfk_no',$trfk_no);		
		$query = $this->db->get();

		if($query->num_rows() > 0){
			$result = $query->result_array();			
			$data['header'] = $result[0];
		}					

		return $data;	
	}

	public function transfer_keluar_kode_auto($kode_depan){
		$this->db->select_max("trfk_no");
		$this->db->like("trfk_no", $kode_depan, "after");
		$query = $this->db->get("tr_transfer_keluar");
		if ($query->num_rows() == 0){
			return $kode_depan. "0001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['trfk_no'];
			$nomor = ((int) substr($kode, 8)) + 1;			
			return $kode_depan. sprintf("%'.04d", $nomor);
		}
	}

	public function cek_exists_cekint($trfk_no, $trfk_cekint){		
		$query = $this->db->get_where('tr_transfer_keluar', array('trfk_no' => $trfk_no, 'trfk_cekint' => $trfk_cekint));				 
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function set_transfer_keluar_cekint($trfk_no){				
		$this->db->where('trfk_no', $trfk_no);
		$this->db->update('tr_transfer_keluar', array('trfk_cekint' => rand(0,10000)));
	}

	public function transfer_keluar_simpan($data){
		try{						
			if($data['action'] == 'NEW' || $data['action'] == 'EDIT'){								

				if($data['action'] == 'NEW'){
					// Insert data
					$this->db->insert('tr_transfer_keluar',$data['tr']);
				}
			
				if($data['action'] == 'EDIT'){								
					// Update data trfk
					$this->db->where('trfk_no', $data['tr']['trfk_no']);
					$this->db->update('tr_transfer_keluar', $data['tr']);								

					// void pembayaran pbpo
					$this->void_pbpo_bypbpo_refnopbyr($data['tr']['trfk_no']);					

					// Delete data used transfer keluar 
					$this->db->delete('used_transfer_keluar', array('usfk_no' => $data['tr']['trfk_no']));
				}							

				// SIMPAN PEMBAYARAN PO -------------------------------------------------------------------------
				if(isset($data['pbpo'])){
					foreach ($data['pbpo'] as $key => $value) {					
						// set trid_cekint
						$this->m_incoming_delivery->set_incoming_delivery_cekint($data['pbpo'][$key]['pbpo_refno']);

						// insert pby_po
						$this->db->insert('pby_po', $data['pbpo'][$key]);	

						// update trid_terbayar
						$this->m_po_payment->update_trid_terbayar($data['pbpo'][$key]['pbpo_refno']);

						// update trpo_terbayar
						$this->m_po_payment->recalc_trpo_terbayar(substr($data['pbpo'][$key]['pbpo_no'], 0, 12));

						// simpan jurnal pbpo
						$this->jurnal_simpan_pbyr_po($data['pbpo'][$key]['pbpo_no'], $data['pbpo'][$key]['pbpo_tgl']);

						// set data used_transfer_keluar
						$data_usfk['usfk_no'] = $data['pbpo'][$key]['pbpo_refnopbyr'];					
						$data_usfk['usfk_refno'] = $data['pbpo'][$key]['pbpo_no'];						
						$data_usfk['usfk_refseq'] = $data['pbpo'][$key]['pbpo_seq'];
						$data_usfk['usfk_total'] = $data['pbpo'][$key]['pbpo_jlhbayar'];

						// insert used_transfer_keluar
						$this->db->insert('used_transfer_keluar', $data_usfk);															
					}
				}

				// update trfk_used
				$this->update_trfk_used($data['tr']['trfk_no']);

				// Simpan jurnal transfer keluar			
				$this->jurnal_simpan_tk($data['tr']['trfk_no'], $data['tr']['trfk_tgltransfer'], $data['tr']['trfk_msap_no_tfk'], $data['tr']['trfk_msap_no_slh'], $data['action']);
			}

			if($data['action'] == 'VOID'){
				// void pembayaran
				$this->void_pbpo_bypbpo_refnopbyr($data['tr']['trfk_no']);				

				// void transfer keluar
				$this->db->where(array('trfk_no' => $data['tr']['trfk_no']));
				$this->db->update('tr_transfer_keluar', array('trfk_void'=>1, 'trfk_used'=>0));

				// Delete used_trasfer_keluar
				$this->db->delete('used_transfer_keluar', array('usfk_no' => $data['tr']['trfk_no']));						

				// delete jurnal transfer keluar
				$this->jurnal_hapus($data['tr']['trfk_no'], 'TK');				
			}
			
			return 1;			 								
		}catch (Exception $e) {
			return 0;
		}		
	}

	private function void_pbpo_bypbpo_refnopbyr($trfk_no){
		$query = $this->db->get_where('pby_po', array('pbpo_refnopbyr' => $trfk_no, 'pbpo_void'=>0));
		if($query->num_rows() > 0){
			$data_pbpo = $query->result_array();

			foreach ($data_pbpo as $key => $value) {																	
				// void pembayaran
				$this->db->where(array('pbpo_no' => $value['pbpo_no'], 'pbpo_seq' => $value['pbpo_seq']));
				$this->db->update('pby_po', array('pbpo_void'=>1));

				// update trid_terbayar
				$this->m_po_payment->update_trid_terbayar($value['pbpo_refno']);

				// update trpo_terbayar
				$this->m_po_payment->recalc_trpo_terbayar(substr($value['pbpo_no'], 0, 12));

				// delete jurnal pbpo
				$this->jurnal_hapus($value['pbpo_no'], 'PP');				
			}					
		}
	}	

	private function jurnal_hapus($trju_refno, $trju_reftipe){
		$query = "DELETE dtju
					FROM dt_jurnal dtju
					LEFT JOIN tr_jurnal trju ON trju.trju_no = dtju.dtju_no
					WHERE trju_refno ='".$trju_refno.$trju_reftipe."' AND trju_reftipe = '".$trju_reftipe."'";
		$this->db->simple_query($query);

		$query = "DELETE trju FROM tr_jurnal trju 
					WHERE trju_refno ='".$trju_refno.$trju_reftipe."' AND trju_reftipe = '".$trju_reftipe."'";
		$this->db->simple_query($query);

		// $query = "DELETE trju, dtju
		// 					FROM dt_jurnal dtju
		// 					LEFT JOIN tr_jurnal trju ON trju.trju_no = dtju.dtju_no
		// 					WHERE trju_refno ='".$trju_refno.$trju_reftipe."' AND trju_reftipe = '".$trju_reftipe."'";

		// if($this->db->simple_query($query)){	
		// 	$this->db->delete('tr_jurnal', array('trju_refno'=>$trju_refno.$trju_reftipe, 'trju_reftipe'=>$trju_refno));						
		// }
	}

	public function update_trfk_used($trfk_no){		
		$query = "UPDATE tr_transfer_keluar					
					SET trfk_used = (
										SELECT IFNULL(SUM(usfk_total), 0)
										FROM used_transfer_keluar										
										WHERE usfk_no = '".$trfk_no."'										
									)
					WHERE trfk_no = '".$trfk_no."'";
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}		
	}		

	public function jurnal_simpan_pbyr_po($pbpo_no, $pbpo_tgl){
		$vok = true;				

		// Generate kode jurnal
		$bulan = substr($pbpo_tgl, 5, 2);			
		$tahun = substr($pbpo_tgl, 2, 2);
		$kd_depan = "JA".$tahun.$bulan.'-';
		$trju_no = $this->m_jurnal->jurnal_kode_auto($kd_depan);		

		// Insert header jurnal
		if($vok){
			$str_query = "INSERT INTO tr_jurnal(
							trju_no,
							trju_tgl,
							trju_tipe,
							trju_catatan,
							trju_refno,
							trju_reftipe,
							trju_void,
							trju_lsupd,
							trju_lsusr,
							trju_cekint,
							trju_msus_no,
							trju_mscb_no,
							trju_fin,
							trju_stcopy,
							trju_lscopy,
							trju_tag)
						(SELECT '".$trju_no."',
								pbpo_tgl,
								'A',
								SUBSTRING(CONCAT(pbpo_tag,' ', pbpo_no, '/', trpo_mssp_no, ' - ', mssp_nm), 1, 250),								
								CONCAT(pbpo_no,'PP'),
								'PP',
								0,
								pbpo_lsupd,
								pbpo_lsusr,
								1,
								pbpo_msus_no,
								pbpo_mscb_no,
								'F',
								'R',
								0,
								''
						FROM pby_po
						LEFT JOIN tr_po ON trpo_no = SUBSTRING(pbpo_no, 1, 12)
						LEFT JOIN ms_supplier ON mssp_no = trpo_mssp_no
						WHERE pbpo_no = '".$pbpo_no."'
						LIMIT 1)";

			if(!$this->db->simple_query($str_query)){					
				echo $str_query; 
				die('Error create header jurnal. '. $pbpo_no);
			}
		}

		// Insert jurnal debet
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq, 
								IF(mssp_jenis = 'L', (SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'HUTL'),
													(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'HUTI')),
								round(pbpo_jlhbayar * trid_kurs, 4),
								0,
								'',
								''
								FROM pby_po
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r								
								LEFT JOIN tr_po ON trpo_no = SUBSTRING(pbpo_no, 1, 12)
								LEFT JOIN tr_in_dlv ON trid_no = pbpo_refno
								LEFT JOIN ms_supplier ON mssp_no = trpo_mssp_no
								WHERE pbpo_no = '".$pbpo_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $pbpo_no);
			}
		}

		// Insert jurnal kredit
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'BINT'),
								0,
								round(pbpo_jlhbayar * pbpo_kurs, 4),
								'',
								''
								FROM pby_po
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r
								WHERE pbpo_no = '".$pbpo_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $pbpo_no);
			}
		}		

		// Insert jurnal debet/kredit selisih kurs
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'SLHK'),
								IF(round(pbpo_jlhbayar * trid_kurs, 4) > round(pbpo_jlhbayar * pbpo_kurs, 4), 
										0, round(pbpo_jlhbayar * pbpo_kurs, 4) - round(pbpo_jlhbayar * trid_kurs, 4)),
								IF(round(round(pbpo_jlhbayar * pbpo_kurs, 4) > pbpo_jlhbayar * trid_kurs, 4), 
										0, round(pbpo_jlhbayar * trid_kurs, 4) - round(pbpo_jlhbayar * pbpo_kurs, 4)),
								'',
								''
								FROM pby_po
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r
								LEFT JOIN tr_po ON trpo_no = SUBSTRING(pbpo_no, 1, 12)
								LEFT JOIN tr_in_dlv ON trid_no = pbpo_refno
								WHERE round(pbpo_jlhbayar * trid_kurs, 4) <> round(pbpo_jlhbayar * pbpo_kurs, 4)
								AND pbpo_no = '".$pbpo_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $pbpo_no);
			}
		}		
	}	

	public function jurnal_simpan_tk($trfk_no, $trfk_tgltransfer, $trfk_msap_no_tfk, $trfk_msap_no_slh, $action){
		$vok = true;		
		$trju_no = '';		

		if($vok && $action == 'NEW'){
			// Generate kode jurnal
			$bulan = substr($trfk_tgltransfer, 5, 2);			
			$tahun = substr($trfk_tgltransfer, 2, 2);
			$kd_depan = "JA".$tahun.$bulan.'-';
			$trju_no = $this->m_jurnal->jurnal_kode_auto($kd_depan);		

			// Insert header jurnal
			$str_query = "INSERT INTO tr_jurnal(
							trju_no,
							trju_tgl,
							trju_tipe,
							trju_catatan,
							trju_refno,
							trju_reftipe,
							trju_void,
							trju_lsupd,
							trju_lsusr,
							trju_cekint,
							trju_msus_no,
							trju_mscb_no,
							trju_fin,
							trju_stcopy,
							trju_lscopy,
							trju_tag)
						(SELECT '".$trju_no."',
								'".$trfk_tgltransfer."',
								'A',
								SUBSTRING(CONCAT(trfk_tag,' ', trfk_catatan), 1, 250),								
								CONCAT(trfk_no,'TK'),
								'TK',
								0,
								'".date('Y-m-d H:i:s')."',
								'".$this->session->userdata('user_aktif')['msus_no']."',								
								1,
								'".$this->session->userdata('user_aktif')['msus_no']."',
								'".$this->session->userdata('user_aktif')['msus_mscb_no']."',
								'F',
								'R',
								0,
								''
						FROM tr_transfer_keluar						
						WHERE trfk_no = '".$trfk_no."')";

			if(!$this->db->simple_query($str_query)){					
				echo $str_query; 
				die('Error create header jurnal. '. $trfk_no);
			}
		}

		if($vok && $action == 'EDIT'){
			$trju_no = $this->get_trju_no_byrefno($trfk_no, 'TK');

			$str_query = "UPDATE tr_jurnal
							LEFT JOIN tr_transfer_keluar ON trfk_no = SUBSTRING(trju_refno, 1, 12)
							SET trju_catatan = SUBSTRING(CONCAT(trfk_tag,' ', trfk_catatan), 1, 250),
								trju_lsupd = trfk_lsupd,
								trju_lsusr = trfk_lsusr
							WHERE trju_no = '".$trju_no."'";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error update tr_jurnal. '. $trfk_no);
			}
		}

		if($vok){
			// Delete dt_jurnal transfer keluar
			$str_query = "DELETE FROM dt_jurnal WHERE dtju_no ='".$trju_no."'";		
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error delete dt_jurnal. '. $trfk_no);
			}
		}		

		// Insert jurnal debet
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'BINT'),
								round(trfk_used * trfk_kurs, 4),
								0,
								'',
								''
								FROM tr_transfer_keluar
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r								
								WHERE trfk_no = '".$trfk_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $trfk_no);
			}
		}

		// Insert jurnal debet
		if($vok){			
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								'".$trfk_msap_no_slh."',
								round(trfk_total * trfk_kurs, 4) - round(trfk_used * trfk_kurs, 4),
								0,
								'',
								''
								FROM tr_transfer_keluar
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r																
								WHERE trfk_no = '".$trfk_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $trfk_no);
			}			
		}

		// Insert jurnal kredit
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								'".$trfk_msap_no_tfk."',
								0,
								round(trfk_total * trfk_kurs, 4),
								'',
								''
								FROM tr_transfer_keluar
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r
								WHERE trfk_no = '".$trfk_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $trfk_no);
			}
		}	

		// delete akun selisih jika tidak ada selisih
		if($vok){
			$str_query = "DELETE FROM dt_jurnal WHERE dtju_no = '".$trju_no."' AND dtju_seq = 2 AND dtju_debet = 0";

			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error delete akun. '. $trfk_no);
			}			
		}
	}

	private function get_trju_no_byrefno($trju_refno, $trju_reftipe){
		$query = $this->db->get_where('tr_jurnal', array('trju_refno'=>$trju_refno.$trju_reftipe, 'trju_reftipe'=>$trju_reftipe));
		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result[0]['trju_no'];
		}else{
			return '';
		}
	}
	
}
