<?php
defined('BASEPATH') OR exit('No direct script access allowed');

//include_once(APPPATH.'core\Backup_Model.php');

class m_backup_data extends MY_Model {

	public function backup_data_master($tablename,$primarykey){							
		// Get data from internal server
		$query = $this->dc->get($tablename);
		$data = $query->result_array();		

		// Insert data to financial server
		$nsukses = 0;
		$err = 0;
		$err_msg = '';
		foreach ($data as $key => $value) {				
			$this->db->delete($tablename, array($primarykey => $data[$key][$primarykey]));
			if($this->db->insert($tablename, $data[$key])==False){
				$err = 1;
				$err_msg = 'ERROR ON '.$data[$key][$primarykey];
				break;			
			}else{
				$nsukses += 1;					
			}			
		}	

		return array('err'=>$err, 'err_msg' => $err_msg, 'nsukses'=>$nsukses, 'ndata'=>count($data));
	}	

	public function backup_data_master_notexists($tablename, $primarykey){							
		// Get data from internal server		
		$query = $this->dc->get($tablename);				
		$data = $query->result_array();		

		// Insert data to financial server
		$nsukses = 0;
		$err = 0;
		$err_msg = '';
		foreach ($data as $key => $value) {							
			if(!$this->cek_data_exists($tablename, $primarykey, $data[$key][$primarykey])){
				if($this->db->insert($tablename, $data[$key])==False){
					$err = 1;
					$err_msg = 'ERROR ON '.$data[$key][$primarykey];
					break;			
				}else{
					$nsukses += 1;					
				}
			}
		}	

		return array('err'=>$err, 'err_msg' => $err_msg, 'nsukses'=>$nsukses, 'ndata'=>count($data));
	}

	private function cek_data_exists($tablename, $primarykey, $no){
		$query = $this->db->get_where($tablename, array($primarykey => $no));
		if($query->num_rows() > 0){
			return  true;
		}else{
			return false;
		}
	}

	public function backup_data_master_produk(){
		// Get data from internal server		
		$query = $this->dc->get_where('ms_produk', array('mspd_fin' => 'F'));					
		$data = $query->result_array();		

		// Insert data to financial server
		$nsukses = 0;
		$err = 0;
		$err_msg = '';
		foreach ($data as $key => $value) {							
			if(!$this->cek_data_exists('ms_produk', 'mspd_no', $data[$key]['mspd_no'])){
				if($this->db->insert('ms_produk', $data[$key])==False){
					$err = 1;
					$err_msg = 'ERROR ON '.$data[$key]['mspd_no'];
					break;			
				}else{					
					$nsukses += 1;

					if($data[$key]['mspd_paket'] == 'Y'){		
						// Get data master detail produk from internal server
						$query = $this->dc->get_where('md_paket_prod', array('mdpp_no' => $data[$key]['mspd_no']));
						$data_md = $query->result_array();

						// Insert data master detail produk to financial server
						foreach ($data_md as $key_md => $value_md) {
							if($this->db->insert('md_paket_prod', $data_md[$key_md])==false){
								$err = 1;
								$err_msg .= ', DETAIL PAKET '.$data_md[$key_md]['mdpp_mspd_no'];
								break;
							}
						}
					}					
				}
			}
		}	

		return array('err'=>$err, 'err_msg' => $err_msg, 'nsukses'=>$nsukses, 'ndata'=>count($data));
	}

	public function backup_data_master_aktiva($data){
		// Get data from internal server				
		$sql = "SELECT * FROM ms_aktiva_tetap WHERE msat_void = 0 AND msat_stcopy ='R' AND msat_fin = 'F'";

		if($data['filter'] == 'periode'){
			$sql .= " AND msat_tgl BETWEEN '".$data['fromdate']." 00:00:00' AND '". $data['todate']. " 23:59:59'";
		}
		
		$query = $this->dc->query($sql);		
		$data = $query->result_array();			

		// Insert data to financial server
		$nsukses = 0;
		$err = 0;
		$err_msg = '';
		$result = true;
		$msat_lscopy = date('Y-m-d H:i:s');

		foreach ($data as $key => $value) {
			if($result){
				$data[$key]['msat_lscopy'] = $msat_lscopy;
				$data[$key]['msat_stcopy'] = 'A';

				if(!$this->cek_data_exists('ms_aktiva_tetap', 'msat_no', $data[$key]['msat_no'])){
					if($this->db->insert('ms_aktiva_tetap', $data[$key])==False){
						$err = 1;
						$result = false;
						$err_msg = 'ERROR ON '.$data[$key]['msat_no'];
						break;			
					}
					$nsukses += 1;
				}else{
					$err = 1;
					$result = false;
					$err_msg = ', AKTIVA TETAP # '. $data[$key]['msat_no']. ' SUDAH ADA DI DATABASE FINANCIAL ';
					break;
				}
			}

			if($result){			
				// Get data master detail aktiva tetap from internal server
				$query = $this->dc->get_where('md_aktiva_tetap', array('mdat_no' => $data[$key]['msat_no']));
				$data_md = $query->result_array();

				// Clear md_aktiva_tetap di financial server
				$this->db->delete('md_aktiva_tetap', array('mdat_no' => $data[$key]['msat_no']));

				// Insert data master detail aktiva tetap to financial server
				foreach ($data_md as $key_md => $value_md) {
					if($this->db->insert('md_aktiva_tetap', $data_md[$key_md])==false){
						$err = 1;
						$result = false;
						$err_msg .= ', DETAIL AKTIVA TETAP '.$data_md[$key_md]['mdat_msap_no'];
						break;
					}
				}					
			}

			if($result){			
				// Get tr_jurnal aktiva_tetap from internal server
				$query = $this->dc->get_where('tr_jurnal', array('SUBSTRING(trju_refno, 1, LENGTH(trju_refno)-2) =' => $data[$key]['msat_no']));
				$jurnal_h = $query->result_array();

				// Insert tr_jurnal aktiva tetap to financial server
				foreach ($jurnal_h as $key_jh => $value_jh) {
					$jurnal_h[$key_jh]['trju_lscopy'] = $msat_lscopy;
					$jurnal_h[$key_jh]['trju_stcopy'] = 'A';

					if(!$this->cek_data_exists('tr_jurnal', 'trju_no', $jurnal_h[$key_jh]['trju_no'])){
						if($this->db->insert('tr_jurnal', $jurnal_h[$key_jh])==false){
							$err = 1;
							$result = false;
							$err_msg .= ', JURNAL AKTIVA TETAP '.$jurnal_h[$key_jh]['trju_no'];
							break;
						}
					}else{
						$err = 1;
						$result = false;
						$err_msg = ', JURNAL # '. $jurnal_h[$key_jh]['trju_no']. ' SUDAH ADA DI DATABASE FINANCIAL ';
						break;
					}

					// Get dt_jurnal aktiva_tetap from internal server
					$query = $this->dc->get_where('dt_jurnal', array('dtju_no' => $jurnal_h[$key_jh]['trju_no']));
					$jurnal_d = $query->result_array();

					// Clear dt_jurnal di financial server
					$this->db->delete('dt_jurnal', array('dtju_no' => $jurnal_h[$key_jh]['trju_no']));

					// Insert dt_jurnal aktiva tetap to financial server
					foreach ($jurnal_d as $key_jd => $value_jd) {
						if($this->db->insert('dt_jurnal', $jurnal_d[$key_jd])==false){
							$err = 1;
							$result = false;
							$err_msg .= ', DETAIL JURNAL AKTIVA TETAP '.$jurnal_d[$key_jd]['trju_msap_no'];
							break;
						}
					}
				}					
			}							

			// Update status copy A
			$this->update_msat_stcopy($data[$key]['msat_no'], 'A', $msat_lscopy);			

		}

		// Update status copy F
		if($result == false){			
			$this->update_msat_stcopy($data[$key]['msat_no'], 'F', $msat_lscopy);
		}

		return array('err'=>$err, 'err_msg' => $err_msg, 'nsukses'=>$nsukses, 'ndata'=>count($data));
	}

	public function backup_trans_adjstok($data){
		$this->load->model('stok_kontrol/m_adjstok');

		// Get data from internal server				
		$sql = "SELECT * FROM tr_adjstok WHERE tras_void = 0 AND tras_stcopy ='R' AND tras_fin = 'F'";

		if($data['filter'] == 'periode'){
			$sql .= " AND tras_tgl BETWEEN '".$data['fromdate']." 00:00:00' AND '". $data['todate']. " 23:59:59'";
		}
		
		$query = $this->dc->query($sql);		
		$data = $query->result_array();		

		// Insert data to financial server
		$nsukses = 0;
		$err = 0;
		$err_msg = '';
		$result = true;
		$tras_lscopy = date('Y-m-d H:i:s');

		foreach ($data as $key => $value) {			
			if($result){
				$data[$key]['tras_lscopy'] = $tras_lscopy;
				$data[$key]['tras_stcopy'] = 'A';

				// Insert data tr_adjstok to financial server
				if(!$this->cek_data_exists('tr_adjstok', 'tras_no', $data[$key]['tras_no'])){
					if($this->db->insert('tr_adjstok', $data[$key])==False){
						$err = 1;
						$result = false;
						$err_msg = 'ERROR ON '.$data[$key]['tras_no'];
						break;			
					}
					$nsukses += 1;
				}else{
					$err = 1;
					$result = false;
					$err_msg = ', STOCK ADJUSTMENT # '. $data[$key]['tras_no']. ' SUDAH ADA DI DATABASE FINANCIAL ';
					break;
				}
			}				
			
			if($result){
				// Get data dt_adjstok from internal server
				$query = $this->dc->get_where('dt_adjstok', array('dtas_no' => $data[$key]['tras_no']));
				$data_dt = $query->result_array();

				// Clear dt_adjstok di financial server
				$this->db->delete('dt_adjstok', array('dtas_no' => $data[$key]['tras_no']));			

				// Insert data dt_adjstok to financial server
				foreach ($data_dt as $key_dt => $value_dt) {
					if($this->db->insert('dt_adjstok', $data_dt[$key_dt]) == false){
						$err = 1;
						$result = false;
						$err_msg .= ', DETAIL STOCK ADJUSTMENT '.$data[$key_dt]['dtas_mspd_no'];
						break;
					}					
				}

				// Update stok di server financial
				$this->m_adjstok->update_stok($data[$key]['tras_no'], 1);							
			}			

			if($result){			
				// Get tr_jurnal from internal server
				$query = $this->dc->get_where('tr_jurnal', array('SUBSTRING(trju_refno, 1, 12) =' => $data[$key]['tras_no']));
				$jurnal_h = $query->result_array();

				// Insert tr_jurnal to financial server
				foreach ($jurnal_h as $key_jh => $value_jh) {
					$jurnal_h[$key_jh]['trju_lscopy'] = $tras_lscopy;
					$jurnal_h[$key_jh]['trju_stcopy'] = 'A';

					if(!$this->cek_data_exists('tr_jurnal', 'trju_no', $jurnal_h[$key_jh]['trju_no'])){
						if($this->db->insert('tr_jurnal', $jurnal_h[$key_jh])==false){
							$err = 1;
							$result = false;
							$err_msg .= ', JURNAL STOCK ADJUSTMENT '.$jurnal_h[$key_jh]['trju_no'];
							break;
						}
					}else{
						$err = 1;
						$result = false;
						$err_msg = ', JURNAL # '. $jurnal_h[$key_jh]['trju_no']. ' SUDAH ADA DI DATABASE FINANCIAL ';
						break;
					}

					// Get dt_jurnal from internal server
					$query = $this->dc->get_where('dt_jurnal', array('dtju_no' => $jurnal_h[$key_jh]['trju_no']));
					$jurnal_d = $query->result_array();

					// Clear dt_jurnal di financial server
					$this->db->delete('dt_jurnal', array('dtju_no' => $jurnal_h[$key_jh]['trju_no']));

					// Insert dt_jurnal to financial server
					foreach ($jurnal_d as $key_jd => $value_jd) {
						if($this->db->insert('dt_jurnal', $jurnal_d[$key_jd])==false){
							$err = 1;
							$result = false;
							$err_msg .= ', DETAIL JURNAL STOCK ADJUSTMENT '.$jurnal_d[$key_jd]['trju_msap_no'];
							break;
						}
					}
				}					
			}			

			// Update status copy A
			$this->update_tras_stcopy($data[$key]['tras_no'], 'A', $tras_lscopy);			
		}

		// Update status copy F
		if($result == false){			
			$this->update_tras_stcopy($data[$key]['tras_no'], 'F', $tras_lscopy);
		}

		return array('err'=>$err, 'err_msg' => $err_msg, 'nsukses'=>$nsukses, 'ndata'=>count($data));
	}

	public function backup_trans_goods_transformation($data){
		$this->load->model('stok_kontrol/m_goods_transformation');

		// Get data from internal server				
		$sql = "SELECT * FROM tr_tfmgoods WHERE trts_void = 0 AND trts_stcopy ='R' AND trts_fin = 'F'";

		if($data['filter'] == 'periode'){
			$sql .= " AND trts_tgl BETWEEN '".$data['fromdate']." 00:00:00' AND '". $data['todate']. " 23:59:59'";
		}
		
		$query = $this->dc->query($sql);		
		$data = $query->result_array();		

		// Insert data to financial server
		$nsukses = 0;
		$err = 0;
		$err_msg = '';
		$result = true;
		$trts_lscopy = date('Y-m-d H:i:s');

		foreach ($data as $key => $value) {	
			if($result){
				$data[$key]['trts_lscopy'] = $trts_lscopy;
				$data[$key]['trts_stcopy'] = 'A';

				// Insert data tr_tfmgoods to financial server
				if(!$this->cek_data_exists('tr_tfmgoods', 'trts_no', $data[$key]['trts_no'])){
					if($this->db->insert('tr_tfmgoods', $data[$key])==False){
						$err = 1;
						$result = false;
						$err_msg = 'ERROR ON '.$data[$key]['trts_no'];
						break;			
					}
					$nsukses += 1;
				}else{
					$err = 1;
					$result = false;
					$err_msg = ', GOODS TRASFORMATION # '. $data[$key]['trts_no']. ' SUDAH ADA DI DATABASE FINANCIAL ';
					break;
				}
			}				
			
			// Get data dt_tfmgoods_accper from internal server
			if($result){
				$query = $this->dc->get_where('dt_tfmgoods_accper', array('dttsap_no' => $data[$key]['trts_no']));
				$data_dt = $query->result_array();

				// Insert data dt_tfmgoods_accper to financial server
				foreach ($data_dt as $key_dt => $value_dt) {					
					if($this->db->insert('dt_tfmgoods_accper', $data_dt[$key_dt]) == false){
						$err = 1;
						$result = false;
						$err_msg .= ', DETAIL GOODS TRASFORMATION (ACCOUNT) '.$data[$key_dt]['dttsap_msap_no'];
						break;
					}					
				}
			}

			// Get data dt_tfmgoods from internal server
			if($result){
				$query = $this->dc->get_where('dt_tfmgoods', array('dtts_no' => $data[$key]['trts_no']));
				$data_dt = $query->result_array();

				// Clear dt_tfmgoods di financial server
				$this->db->delete('dt_tfmgoods', array('dtts_no' => $data[$key]['trts_no']));

				// Insert data dt_tfmgoods to financial server
				foreach ($data_dt as $key_dt => $value_dt) {
					if($this->db->insert('dt_tfmgoods', $data_dt[$key_dt]) == false){
						$err = 1;
						$result = false;
						$err_msg .= ', DETAIL GOODS TRASFORMATION (PRODUCT) '.$data[$key_dt]['dtts_mspd_no'];
						break;
					}					
				}

				// Update stok di server financial
				$this->m_goods_transformation->update_stok($data[$key]['trts_no'], -1, 1);
			}

			if($result){			
				// Get tr_jurnal from internal server
				$query = $this->dc->get_where('tr_jurnal', array('SUBSTRING(trju_refno, 1, 12) =' => $data[$key]['trts_no']));
				$jurnal_h = $query->result_array();

				// Insert tr_jurnal to financial server
				foreach ($jurnal_h as $key_jh => $value_jh) {
					$jurnal_h[$key_jh]['trju_lscopy'] = $trts_lscopy;
					$jurnal_h[$key_jh]['trju_stcopy'] = 'A';

					if(!$this->cek_data_exists('tr_jurnal', 'trju_no', $jurnal_h[$key_jh]['trju_no'])){
						if($this->db->insert('tr_jurnal', $jurnal_h[$key_jh])==false){
							$err = 1;
							$result = false;
							$err_msg .= ', JURNAL GOODS TRASFORMATION '.$jurnal_h[$key_jh]['trju_no'];
							break;
						}
					}else{
						$err = 1;
						$result = false;
						$err_msg = ', JURNAL # '. $jurnal_h[$key_jh]['trju_no']. ' SUDAH ADA DI DATABASE FINANCIAL ';
						break;
					}

					// Get dt_jurnal from internal server
					$query = $this->dc->get_where('dt_jurnal', array('dtju_no' => $jurnal_h[$key_jh]['trju_no']));
					$jurnal_d = $query->result_array();

					// Clear dt_jurnal di financial server
					$this->db->delete('dt_jurnal', array('dtju_no' => $jurnal_h[$key_jh]['trju_no']));

					// Insert dt_jurnal to financial server
					foreach ($jurnal_d as $key_jd => $value_jd) {
						if($this->db->insert('dt_jurnal', $jurnal_d[$key_jd])==false){
							$err = 1;
							$result = false;
							$err_msg .= ', DETAIL JURNAL GOODS TRASFORMATION '.$jurnal_d[$key_jd]['trju_msap_no'];
							break;
						}
					}
				}					
			}			

			// Update status copy A
			$this->update_trts_stcopy($data[$key]['trts_no'], 'A', $trts_lscopy);
		}

		// Update status copy F
		if($result == false){			
			$this->update_trts_stcopy($data[$key]['trts_no'], 'F', $trts_lscopy);
		}

		return array('err'=>$err, 'err_msg' => $err_msg, 'nsukses'=>$nsukses, 'ndata'=>count($data));
	}

	public function backup_trans_mutasi($data){
		$this->load->model('stok_kontrol/m_mutasi');

		// Get data from internal server				
		$sql = "SELECT * FROM tr_mutasi WHERE trmt_void = 0 AND trmt_stcopy ='R' AND trmt_fin = 'F'";

		if($data['filter'] == 'periode'){
			$sql .= " AND trmt_tgl BETWEEN '".$data['fromdate']." 00:00:00' AND '". $data['todate']. " 23:59:59'";
		}
		
		$query = $this->dc->query($sql);		
		$data = $query->result_array();		

		// Insert data to financial server
		$nsukses = 0;
		$err = 0;
		$err_msg = '';
		$result = true;
		$trmt_lscopy = date('Y-m-d H:i:s');

		foreach ($data as $key => $value) {			
			if($result){
				$data[$key]['trmt_lscopy'] = $trmt_lscopy;
				$data[$key]['trmt_stcopy'] = 'A';

				// Insert data tr_mutasi to financial server
				if(!$this->cek_data_exists('tr_mutasi', 'trmt_no', $data[$key]['trmt_no'])){
					if($this->db->insert('tr_mutasi', $data[$key])==False){
						$err = 1;
						$result = false;
						$err_msg = 'ERROR ON '.$data[$key]['trmt_no'];
						break;
					}
					$nsukses += 1;
				}else{
					$err = 1;
					$result = false;
					$err_msg = ', MUTASI # '. $data[$key]['trmt_no']. ' SUDAH ADA DI DATABASE FINANCIAL ';
					break;
				}
			}							

			// Get data dt_mutasi from internal server
			if($result){
				$query = $this->dc->get_where('dt_mutasi', array('dtmt_no' => $data[$key]['trmt_no']));
				$data_dt = $query->result_array();

				// Clear dt_mutasi di financial server
				$this->db->delete('dt_mutasi', array('dtmt_no' => $data[$key]['trmt_no']));

				// Insert data dt_mutasi to financial server
				foreach ($data_dt as $key_dt => $value_dt) {
					if($this->db->insert('dt_mutasi', $data_dt[$key_dt]) == false){
						$err = 1;
						$result = false;
						$err_msg .= ', DETAIL MUTASI '.$data[$key_dt]['dtmt_mspd_no'];
						break;
					}					
				}

				// Update stok di server financial				
				$this->m_mutasi->update_stok('DELIVERYNOW', $data[$key]['trmt_no'], -1);
				$this->m_mutasi->update_stok('RECEIVE_GOODS', $data[$key]['trmt_no'], 1);
			}

			// Get data apv_mutasi from internal server
			if($result){
				$query = $this->dc->get_where('apv_mutasi', array('apmt_no' => $data[$key]['trmt_no']));
				$data_dt = $query->result_array();

				// Clear apv_mutasi di financial server
				$this->db->delete('apv_mutasi', array('apmt_no' => $data[$key]['trmt_no']));

				// Insert data apv_mutasi to financial server
				foreach ($data_dt as $key_dt => $value_dt) {
					if($this->db->insert('apv_mutasi', $data_dt[$key_dt]) == false){
						$err = 1;
						$result = false;
						$err_msg .= ', DETAIL APPROVAL MUTASI '.$data[$key_dt]['apmt_msus_no'];
						break;
					}					
				}
			}

			if($result){			
				// Get tr_jurnal from internal server
				$query = $this->dc->get_where('tr_jurnal', array('SUBSTRING(trju_refno, 1, 12) =' => $data[$key]['trmt_no']));
				$jurnal_h = $query->result_array();

				// Insert tr_jurnal to financial server
				foreach ($jurnal_h as $key_jh => $value_jh) {
					$jurnal_h[$key_jh]['trju_lscopy'] = $trmt_lscopy;
					$jurnal_h[$key_jh]['trju_stcopy'] = 'A';

					if(!$this->cek_data_exists('tr_jurnal', 'trju_no', $jurnal_h[$key_jh]['trju_no'])){
						if($this->db->insert('tr_jurnal', $jurnal_h[$key_jh])==false){
							$err = 1;
							$result = false;
							$err_msg .= ', JURNAL MUTASI '.$jurnal_h[$key_jh]['trju_no'];
							break;
						}
					}else{
						$err = 1;
						$result = false;
						$err_msg = ', JURNAL # '. $jurnal_h[$key_jh]['trju_no']. ' SUDAH ADA DI DATABASE FINANCIAL ';
						break;
					}

					// Get dt_jurnal from internal server
					$query = $this->dc->get_where('dt_jurnal', array('dtju_no' => $jurnal_h[$key_jh]['trju_no']));
					$jurnal_d = $query->result_array();

					// Clear dt_jurnal di financial server
					$this->db->delete('dt_jurnal', array('dtju_no' => $jurnal_h[$key_jh]['trju_no']));

					// Insert dt_jurnal to financial server
					foreach ($jurnal_d as $key_jd => $value_jd) {
						if($this->db->insert('dt_jurnal', $jurnal_d[$key_jd])==false){
							$err = 1;
							$result = false;
							$err_msg .= ', DETAIL JURNAL MUTASI '.$jurnal_d[$key_jd]['trju_msap_no'];
							break;
						}
					}
				}					
			}			

			// Update status copy A
			$this->update_trmt_stcopy($data[$key]['trmt_no'], 'A', $trmt_lscopy);			
		}

		// Update status copy F
		if($result == false){			
			$this->update_trmt_stcopy($data[$key]['trmt_no'], 'F', $trmt_lscopy);
		}

		return array('err'=>$err, 'err_msg' => $err_msg, 'nsukses'=>$nsukses, 'ndata'=>count($data));
	}

	public function backup_trans_sales_order($data){
		$this->load->model('stok_kontrol/m_sales_delivery');

		// Get data from internal server				
		$sql = "SELECT * FROM tr_so WHERE trso_void = 0 AND trso_stcopy ='R' AND trso_fin = 'F'";

		if($data['filter'] == 'periode'){
			$sql .= " AND trso_tgl BETWEEN '".$data['fromdate']." 00:00:00' AND '". $data['todate']. " 23:59:59'";
		}
		
		$query = $this->dc->query($sql);		
		$data = $query->result_array();		

		// Insert data to financial server
		$nsukses = 0;
		$err = 0;
		$err_msg = '';
		$result = true;
		$trso_lscopy = date('Y-m-d H:i:s');

		foreach ($data as $key => $value) {			
			if($result){
				$data[$key]['trso_lscopy'] = $trso_lscopy;
				$data[$key]['trso_stcopy'] = 'A';
				$data[$key]['trso_terbayar'] = 0;
				$data[$key]['trso_sisadp'] = 0;

				// Insert data tr_so to financial server
				if(!$this->cek_data_exists('tr_so', 'trso_no', $data[$key]['trso_no'])){
					if($this->db->insert('tr_so', $data[$key])==False){
						$err = 1;
						$result = false;
						$err_msg = 'ERROR ON '.$data[$key]['trso_no'];
						break;
					}
					$nsukses += 1;
				}else{
					$err = 1;
					$result = false;
					$err_msg = ', SO # '. $data[$key]['trso_no']. ' SUDAH ADA DI DATABASE FINANCIAL ';
					break;
				}
			}							
			
			if($result){
				// Get data dt_so from internal server
				$query = $this->dc->get_where('dt_so', array('dtso_no' => $data[$key]['trso_no']));
				$data_dt = $query->result_array();

				// Clear dt_so di financial server
				$this->db->delete('dt_so', array('dtso_no' => $data[$key]['trso_no']));

				// Insert data dt_so to financial server
				foreach ($data_dt as $key_dt => $value_dt) {
					$data_dt[$key_dt]['dtso_qtyretur'] = 0;
					if($this->db->insert('dt_so', $data_dt[$key_dt]) == false){
						$err = 1;
						$result = false;
						$err_msg .= ', DETAIL SO '.$data[$key_dt]['dtso_mspd_no'];
						break;
					}					
				}
			}
			
			if($result){
				// Get data tr_sales_dlv from internal server
				$query = $this->dc->get_where('tr_sales_dlv', array('SUBSTRING(trsd_no, 1, 12) =' => $data[$key]['trso_no']));
				$data_sd = $query->result_array();

				// Clear tr_sales_dlv di financial server
				$this->db->delete('tr_sales_dlv', array('SUBSTRING(trsd_no, 1, 12) =' => $data[$key]['trso_no']));
				// Clear dt_sales_dlv di financial server
				$this->db->delete('dt_sales_dlv', array('SUBSTRING(dtsd_no, 1, 12) =' => $data[$key]['trso_no']));

				// Insert data tr_sales_dlv to financial server
				foreach ($data_sd as $key_sd => $value_sd) {
					$data_sd[$key_sd]['trsd_terbayar'] = 0;
					if($this->db->insert('tr_sales_dlv', $data_sd[$key_sd]) == false){
						$err = 1;
						$result = false;
						$err_msg .= ', SALES DELIVERY '.$data_sd[$key_sd]['trsd_no'];
						break;
					}					

					// Get data dt_sales_dlv from internal server
					$query = $this->dc->get_where('dt_sales_dlv', array('dtsd_no' => $data_sd[$key_sd]['trsd_no']));
					$data_dt = $query->result_array();

					// Insert data dt_sales_dlv to financial server
					foreach ($data_dt as $key_dt => $value_dt) {
						if($this->db->insert('dt_sales_dlv', $data_dt[$key_dt]) == false){
							$err = 1;
							$result = false;
							$err_msg .= ', DETAIL SALES DELIVERY '.$data_dt[$key_dt]['dtsd_mspd_no'];
							break;
						}					
					}

					// Update stok di server financial	
					$this->m_sales_delivery->update_stok('DELIVERYNOW', $data_sd[$key]['trsd_no'], -1);
					$this->m_sales_delivery->update_stok('CONFDELIVERY', $data_sd[$key]['trsd_no'], 1);
				}

				// Get tr_jurnal from internal server
				$query = $this->dc->get_where('tr_jurnal', array('SUBSTRING(trju_refno, 1, 15) =' => substr($data_sd[$key_sd]['trsd_no'], 0, 15)));
				$jurnal_h = $query->result_array();		

				// Insert tr_jurnal to financial server
				foreach ($jurnal_h as $key_jh => $value_jh) {
					$jurnal_h[$key_jh]['trju_lscopy'] = $trso_lscopy;
					$jurnal_h[$key_jh]['trju_stcopy'] = 'A';

					if(!$this->cek_data_exists('tr_jurnal', 'trju_no', $jurnal_h[$key_jh]['trju_no'])){
						if($this->db->insert('tr_jurnal', $jurnal_h[$key_jh])==false){
							$err = 1;
							$result = false;
							$err_msg .= ', JURNAL SALES DELIVERY '.$jurnal_h[$key_jh]['trju_no'];
							break;
						}
					}else{
						$err = 1;
						$result = false;
						$err_msg = ', JURNAL # '. $jurnal_h[$key_jh]['trju_no']. ' SUDAH ADA DI DATABASE FINANCIAL ';
						break;
					}

					// Get dt_jurnal from internal server
					$query = $this->dc->get_where('dt_jurnal', array('dtju_no' => $jurnal_h[$key_jh]['trju_no']));
					$jurnal_d = $query->result_array();

					// Clear dt_jurnal di financial server
					$this->db->delete('dt_jurnal', array('dtju_no' => $jurnal_h[$key_jh]['trju_no']));

					// Insert dt_jurnal to financial server
					foreach ($jurnal_d as $key_jd => $value_jd) {
						if($this->db->insert('dt_jurnal', $jurnal_d[$key_jd])==false){
							$err = 1;
							$result = false;
							$err_msg .= ', DETAIL JURNAL SALES DELIVERY '.$jurnal_d[$key_jd]['trju_msap_no'];
							break;
						}
					}
				}									
			}						

			// Update status copy A
			$this->update_trso_stcopy($data[$key]['trso_no'], 'A', $trso_lscopy);			
		}	

		// Update status copy F
		if($result == false){			
			$this->update_trso_stcopy($data[$key]['trso_no'], 'F', $trso_lscopy);
		}

		return array('err'=>$err, 'err_msg' => $err_msg, 'nsukses'=>$nsukses, 'ndata'=>count($data));
	}

	public function backup_trans_purchase_order($data){
		$this->load->model('purchase/m_incoming_delivery');

		// Get data from internal server				
		$sql = "SELECT * FROM tr_po WHERE trpo_void = 0 AND trpo_stcopy ='R' AND trpo_fin = 'F'";

		if($data['filter'] == 'periode'){
			$sql .= " AND trpo_tgl BETWEEN '".$data['fromdate']." 00:00:00' AND '". $data['todate']. " 23:59:59'";
		}
		
		$query = $this->dc->query($sql);		
		$data = $query->result_array();		

		// Insert data to financial server
		$nsukses = 0;
		$err = 0;
		$err_msg = '';
		$result = true;
		$trpo_lscopy = date('Y-m-d H:i:s');

		foreach ($data as $key => $value) {			
			if($result){
				$data[$key]['trpo_lscopy'] = $trpo_lscopy;
				$data[$key]['trpo_stcopy'] = 'A';
				$data[$key]['trpo_terbayar'] = 0;
				$data[$key]['trpo_sisadp'] = 0;

				// Insert data tr_po to financial server
				if(!$this->cek_data_exists('tr_po', 'trpo_no', $data[$key]['trpo_no'])){
					if($this->db->insert('tr_po', $data[$key])==False){
						$err = 1;
						$result = false;
						$err_msg = 'ERROR ON '.$data[$key]['trpo_no'];
						break;
					}
					$nsukses += 1;
				}else{
					$err = 1;
					$result = false;
					$err_msg = ', PO # '. $data[$key]['trpo_no']. ' SUDAH ADA DI DATABASE FINANCIAL ';
					break;
				}
			}							
			
			if($result){
				// Get data dt_po from internal server
				$query = $this->dc->get_where('dt_po', array('dtpo_no' => $data[$key]['trpo_no']));
				$data_dt = $query->result_array();

				// Clear dt_po di financial server
				$this->db->delete('dt_po', array('dtpo_no' => $data[$key]['trpo_no']));

				// Insert data dt_po to financial server
				foreach ($data_dt as $key_dt => $value_dt) {
					$data_dt[$key_dt]['dtpo_qtyretur'] = 0;
					if($this->db->insert('dt_po', $data_dt[$key_dt]) == false){
						$err = 1;
						$result = false;
						$err_msg .= ', DETAIL PO '.$data[$key_dt]['dtpo_mspd_no'];
						break;
					}					
				}
			}
			
			if($result){
				// Get data tr_in_dlv from internal server
				$query = $this->dc->get_where('tr_in_dlv', array('SUBSTRING(trid_no, 1, 12) =' => $data[$key]['trpo_no']));
				$data_id = $query->result_array();

				// Clear tr_in_dlv di financial server
				$this->db->delete('tr_in_dlv', array('SUBSTRING(trid_no, 1, 12) =' => $data[$key]['trpo_no']));
				// Clear dt_in_dlv di financial server
				$this->db->delete('dt_in_dlv', array('SUBSTRING(dtid_no, 1, 12) =' => $data[$key]['trpo_no']));

				// Insert data tr_in_dlv to financial server
				foreach ($data_id as $key_id => $value_id) {
					$data_id[$key_id]['trid_terbayar'] = 0;
					if($this->db->insert('tr_in_dlv', $data_id[$key_id]) == false){
						$err = 1;
						$result = false;
						$err_msg .= ', INCOMING DELIVERY '.$data_id[$key_id]['trid_no'];
						break;
					}					

					// Get data dt_in_dlv from internal server
					$query = $this->dc->get_where('dt_in_dlv', array('dtid_no' => $data_id[$key_id]['trid_no']));
					$data_dt = $query->result_array();

					// Insert data dt_in_dlv to financial server
					foreach ($data_dt as $key_dt => $value_dt) {
						if($this->db->insert('dt_in_dlv', $data_dt[$key_dt]) == false){
							$err = 1;
							$result = false;
							$err_msg .= ', DETAIL INCOMING DELIVERY '.$data_dt[$key_dt]['dtid_mspd_no'];
							break;
						}					
					}

					// Update stok di server financial	
					$this->m_incoming_delivery->update_stok($data_id[$key]['trid_no'], 1);
				}

				// Get tr_jurnal from internal server
				$query = $this->dc->get_where('tr_jurnal', array('SUBSTRING(trju_refno, 1, 15) =' => substr($data_id[$key_id]['trid_no'], 0, 15)));
				$jurnal_h = $query->result_array();		

				// Insert tr_jurnal to financial server
				foreach ($jurnal_h as $key_jh => $value_jh) {
					$jurnal_h[$key_jh]['trju_lscopy'] = $trpo_lscopy;
					$jurnal_h[$key_jh]['trju_stcopy'] = 'A';

					if(!$this->cek_data_exists('tr_jurnal', 'trju_no', $jurnal_h[$key_jh]['trju_no'])){
						if($this->db->insert('tr_jurnal', $jurnal_h[$key_jh])==false){
							$err = 1;
							$result = false;
							$err_msg .= ', JURNAL INCOMING DELIVERY '.$jurnal_h[$key_jh]['trju_no'];
							break;
						}
					}else{
						$err = 1;
						$result = false;
						$err_msg = ', JURNAL # '. $jurnal_h[$key_jh]['trju_no']. ' SUDAH ADA DI DATABASE FINANCIAL ';
						break;
					}

					// Get dt_jurnal from internal server
					$query = $this->dc->get_where('dt_jurnal', array('dtju_no' => $jurnal_h[$key_jh]['trju_no']));
					$jurnal_d = $query->result_array();

					// Clear dt_jurnal di financial server
					$this->db->delete('dt_jurnal', array('dtju_no' => $jurnal_h[$key_jh]['trju_no']));

					// Insert dt_jurnal to financial server
					foreach ($jurnal_d as $key_jd => $value_jd) {
						if($this->db->insert('dt_jurnal', $jurnal_d[$key_jd])==false){
							$err = 1;
							$result = false;
							$err_msg .= ', DETAIL JURNAL INCOMING DELIVERY '.$jurnal_d[$key_jd]['trju_msap_no'];
							break;
						}
					}
				}	
			}						

			// Update status copy A
			$this->update_trpo_stcopy($data[$key]['trpo_no'], 'A', $trpo_lscopy);			
		}	
		
		// Update status copy F
		if($result == false){			
			$this->update_trpo_stcopy($data[$key]['trpo_no'], 'F', $trpo_lscopy);
		}

		return array('err'=>$err, 'err_msg' => $err_msg, 'nsukses'=>$nsukses, 'ndata'=>count($data));
	}

	public function backup_trans_spk($data){
		$this->load->model('spk/m_spk');

		// Get data from internal server				
		$sql = "SELECT * FROM tr_spk WHERE trspk_void = 0 AND trspk_stcopy ='R' AND trspk_fin = 'F'";

		if($data['filter'] == 'periode'){
			$sql .= " AND trspk_tgl BETWEEN '".$data['fromdate']." 00:00:00' AND '". $data['todate']. " 23:59:59'";
		}
		
		$query = $this->dc->query($sql);
		$data = $query->result_array();		

		// Insert data to financial server
		$nsukses = 0;
		$err = 0;
		$err_msg = '';
		$result = true;
		$trspk_lscopy = date('Y-m-d H:i:s');

		foreach ($data as $key => $value) {			
			if($result){
				$data[$key]['trspk_lscopy'] = $trspk_lscopy;
				$data[$key]['trspk_stcopy'] = 'A';		

				// Insert data tr_spk to financial server
				if(!$this->cek_data_exists('tr_spk', 'trspk_no', $data[$key]['trspk_no'])){
					if($this->db->insert('tr_spk', $data[$key])==False){
						$err = 1;
						$result = false;
						$err_msg = 'ERROR ON '.$data[$key]['trspk_no'];
						break;
					}
					$nsukses += 1;
				}else{
					$err = 1;
					$result = false;
					$err_msg = ', SPK # '. $data[$key]['trspk_no']. ' SUDAH ADA DI DATABASE FINANCIAL ';
					break;
				}
			}							
			
			if($result){
				// Get data dt_spk_sp from internal server
				$query = $this->dc->get_where('dt_spk_sp', array('dtspk_no' => $data[$key]['trspk_no']));
				$data_dt = $query->result_array();

				// Clear dt_spk_sp di financial server
				$this->db->delete('dt_spk_sp', array('dtspk_no' => $data[$key]['trspk_no']));

				// Insert data dt_spk_sp to financial server
				foreach ($data_dt as $key_dt => $value_dt) {					
					if($this->db->insert('dt_spk_sp', $data_dt[$key_dt]) == false){
						$err = 1;
						$result = false;
						$err_msg .= ', ITEM SERVICE/SPAREPART '.$data[$key_dt]['dtspk_mspd_no'];
						break;
					}
				}

				// Update stok di server financial
				$this->m_spk->update_stok($data[$key]['trspk_no'], -1);
			}
			
			if($result){
				// Get data dt_spk_accper from internal server
				$query = $this->dc->get_where('dt_spk_accper', array('dtspkap_no' => $data[$key]['trspk_no']));
				$data_dt = $query->result_array();

				// Clear dt_spk_accper di financial server
				$this->db->delete('dt_spk_accper', array('dtspkap_no' => $data[$key]['trspk_no']));

				// Insert data dt_spk_accper to financial server
				foreach ($data_dt as $key_dt => $value_dt) {
					if($this->db->insert('dt_spk_accper', $data_dt[$key_dt]) == false){
						$err = 1;
						$result = false;
						$err_msg .= ', AKUN PERKIRAAN '.$data[$key_dt]['dtspkap_msap_no'];
						break;
					}					
				}
			}

			if($result){
				// Get data tr_spk_visit from internal server
				$query = $this->dc->get_where('tr_spk_visit', array('SUBSTRING(trsv_no, 1, 12) =' => $data[$key]['trspk_no']));
				$data_sv = $query->result_array();

				// Clear tr_spk_visit di financial server
				$this->db->delete('tr_spk_visit', array('SUBSTRING(trsv_no, 1, 12) =' => $data[$key]['trspk_no']));

				// Insert data tr_spk_visit to financial server
				foreach ($data_sv as $key_sv => $value_sv) {
					if($this->db->insert('tr_spk_visit', $data_sv[$key_sv]) == false){
						$err = 1;
						$result = false;
						$err_msg .= ', SPK VISIT '.$data[$key_sv]['trsv_no'];
						break;
					}					
				}
			}

			if($result){
				// Get tr_jurnal from internal server
				$query = $this->dc->get_where('tr_jurnal', array('SUBSTRING(trju_refno, 1, 12) =' => $data[$key]['trspk_no']));
				$jurnal_h = $query->result_array();		

				// Insert tr_jurnal to financial server
				foreach ($jurnal_h as $key_jh => $value_jh) {
					$jurnal_h[$key_jh]['trju_lscopy'] = $trspk_lscopy;
					$jurnal_h[$key_jh]['trju_stcopy'] = 'A';

					if(!$this->cek_data_exists('tr_jurnal', 'trju_no', $jurnal_h[$key_jh]['trju_no'])){
						if($this->db->insert('tr_jurnal', $jurnal_h[$key_jh])==false){
							$err = 1;
							$result = false;
							$err_msg .= ', JURNAL SPK '.$jurnal_h[$key_jh]['trju_no'];
							break;
						}
					}else{
						$err = 1;
						$result = false;
						$err_msg = ', JURNAL # '. $jurnal_h[$key_jh]['trju_no']. ' SUDAH ADA DI DATABASE FINANCIAL ';
						break;
					}

					// Get dt_jurnal from internal server
					$query = $this->dc->get_where('dt_jurnal', array('dtju_no' => $jurnal_h[$key_jh]['trju_no']));
					$jurnal_d = $query->result_array();

					// Clear dt_jurnal di financial server
					$this->db->delete('dt_jurnal', array('dtju_no' => $jurnal_h[$key_jh]['trju_no']));

					// Insert dt_jurnal to financial server
					foreach ($jurnal_d as $key_jd => $value_jd) {
						if($this->db->insert('dt_jurnal', $jurnal_d[$key_jd])==false){
							$err = 1;
							$result = false;
							$err_msg .= ', DETAIL JURNAL SPK '.$jurnal_d[$key_jd]['trju_msap_no'];
							break;
						}
					}
				}
			}	

			// Update status copy A			
			$this->update_trspk_stcopy($data[$key]['trspk_no'], 'A', $trspk_lscopy);								
		}

		// Update status copy F
		if($result == false){
			$this->update_trspk_stcopy($data[$key]['trspk_no'], 'F', $trspk_lscopy);
		}

		return array('err'=>$err, 'err_msg' => $err_msg, 'nsukses'=>$nsukses, 'ndata'=>count($data));
	}

	public function backup_trans_jurnal_manual($data){

		// Get data from internal server				
		$sql = "SELECT * FROM tr_jurnal WHERE trju_void = 0 AND trju_stcopy ='R' AND trju_fin = 'F' AND trju_tipe = 'M'";

		if($data['filter'] == 'periode'){
			$sql .= " AND trju_tgl BETWEEN '".$data['fromdate']." 00:00:00' AND '". $data['todate']. " 23:59:59'";
		}
		
		$query = $this->dc->query($sql);		
		$data = $query->result_array();		

		// Insert data to financial server
		$nsukses = 0;
		$err = 0;
		$err_msg = '';
		$result = true;
		$trju_lscopy = date('Y-m-d H:i:s');

		foreach ($data as $key => $value) {		
			if($result){
				$data[$key]['trju_lscopy'] = $trju_lscopy;
				$data[$key]['trju_stcopy'] = 'A';

				// Insert data tr_jurnal to financial server
				if(!$this->cek_data_exists('tr_spk', 'trspk_no', $data[$key]['trspk_no'])){
					if($this->db->insert('tr_jurnal', $data[$key])==False){
						$err = 1;
						$result = false;
						$err_msg = 'ERROR ON '.$data[$key]['trju_no'];
						break;			
					}
					$nsukses += 1;
				}else{
					$err = 1;
					$result = false;
					$err_msg = ', JURNAL # '. $data[$key]['trju_no']. ' SUDAH ADA DI DATABASE FINANCIAL ';
					break;
				}
			}				
			
			if($result){
				// Get data dt_jurnal from internal server
				$query = $this->dc->get_where('dt_jurnal', array('dtju_no' => $data[$key]['trju_no']));
				$data_dt = $query->result_array();

				// Clear dt_jurnal di financial server
				$this->db->delete('dt_jurnal', array('dtju_no' => $data[$key]['trju_no']));

				// Insert data dt_jurnal to financial server
				foreach ($data_dt as $key_dt => $value_dt) {
					if($this->db->insert('dt_jurnal', $data_dt[$key_dt]) == false){
						$err = 1;
						$result = false;
						$err_msg .= ', DETAIL JURNAL '.$data[$key_dt]['dtju_msap_no'];
						break;
					}					
				}						
			}

			// Update status copy A			
			$this->update_trju_stcopy($data[$key]['trju_no'], 'A', $trju_lscopy);
				
		}

		// Update status copy F
		if($result == false){			
			$this->update_trju_stcopy($data[$key]['trju_no'], 'F', $trju_lscopy);
		}

		return array('err'=>$err, 'err_msg' => $err_msg, 'nsukses'=>$nsukses, 'ndata'=>count($data));
	}

	public function backup_trans_goods_convertion($data){
		$this->load->model('stok_kontrol/m_adjstok');
		$this->load->model('data_master/m_kategori');
		$this->load->model('setting/m_setting_account');
		$this->load->model('data_master/m_gudang');
			
		// Get data tr_cvtgoods from internal server				
		$sql = "SELECT tr_cvtgoods.*, trju_no FROM tr_cvtgoods "
				." LEFT JOIN tr_jurnal trju ON SUBSTRING(trju.trju_refno, 1, 12) = tr_cvtgoods.trcv_no"
				." WHERE trcv_void = 0 AND trcv_stcopy ='R'";

		if($data['filter'] == 'periode'){
			$sql .= " AND trcv_tgl BETWEEN '".$data['fromdate']." 00:00:00' AND '". $data['todate']. " 23:59:59'";
		}
		
		$query = $this->dc->query($sql);		
		$data = $query->result_array();		

		// Insert data to financial server
		$nsukses = 0;
		$err = 0;
		$err_msg = '';
		$result = true;
		$trcv_lscopy = date('Y-m-d H:i:s');

		foreach ($data as $key => $value) {					
			// set data header tr_adjstok									
			if($result){
				$data_tras['header']['tras_no'] = $data[$key]['trcv_no'];
				$data_tras['header']['tras_msgd_no'] = $data[$key]['trcv_msgd_no'];
				$data_tras['header']['tras_msus_no'] = $data[$key]['trcv_msus_no']; 
				$data_tras['header']['tras_mscb_no'] = $data[$key]['trcv_mscb_no'];
				$data_tras['header']['tras_fin'] = 'F';
				$data_tras['header']['tras_manual'] = 'N';
				$data_tras['header']['tras_stcopy'] = 'A';
				$data_tras['header']['tras_catatan'] = '';
				$data_tras['header']['tras_tag'] = '';
				$data_tras['header']['tras_tgl'] = $trcv_lscopy;
				$data_tras['header']['tras_cekint'] = rand(0,10000);
				$data_tras['header']['tras_void'] = 0;
				$data_tras['header']['tras_lsupd'] = $trcv_lscopy;
				$data_tras['header']['tras_lsusr'] = $data[$key]['trcv_lsusr'];
				$data_tras['header']['tras_lscopy'] = $trcv_lscopy;
			}

			// insert data tr_adjstok ke server financial
			if($result){
				if($this->db->insert('tr_adjstok',$data_tras['header']) == false){
					$err = 1;
					$result = false;
					$err_msg = 'ERROR ON '.$data[$key]['trcv_no'];
					break;
				}
				$nsukses += 1;
			}

			if($result){
				// Get data dt_cvtgoods dari server internal
				$sql = "SELECT * FROM dt_cvtgoods dtcv LEFT JOIN ms_produk mspd ON mspd.mspd_no = dtcv.dtcv_mspd_no"						
						." WHERE dtcv_no = '".$data[$key]['trcv_no']."' AND mspd_fin = 'F'";

				$query = $this->dc->query($sql);		
				$data_dtcv = $query->result_array();

				foreach ($data_dtcv as $key_dtcv => $value_dtcv) {			
					// set data header dt_adjstok
					$data_dtas['detail']["dtas_no"] = $data[$key]['trcv_no'];
				    $data_dtas['detail']["dtas_seq"] = $data_dtcv[$key_dtcv]['dtcv_seq'];
				    $data_dtas['detail']["dtas_mspd_no"] = $data_dtcv[$key_dtcv]['dtcv_mspd_no'];
					$data_dtas['detail']["dtas_hpp"]= $data_dtcv[$key_dtcv]['dtcv_hpp'];
				    
				    if($data_dtcv[$key_dtcv]['dtcv_jenis'] == 'F'){
					    $data_dtas['detail']["dtas_qty"] = -$data_dtcv[$key_dtcv]['dtcv_qty'];
					}else{
						$data_dtas['detail']["dtas_qty"] = $data_dtcv[$key_dtcv]['dtcv_qty'];
					}

				    // insert data dt_adjstok ke server financial
					if($this->db->insert('dt_adjstok',$data_dtas['detail']) == false){
						$err = 1;
						$result = false;
						$err_msg = ', DETAIL GOODS CONVERTION '.$data_dtcv[$key_dtcv]['mspd_no'];
						break;
					}					
				}

				// Update stok di server financial
				$this->m_adjstok->update_stok($data[$key]['trcv_no'], 1);
			}

			if($result){
				//Header jurnal
				$gudang = $this->m_gudang->get_gudang($data[$key]['trcv_msgd_no']);
				$data_trju['jurnal_h']['trju_no'] = $data[$key]['trju_no'];
				$data_trju['jurnal_h']['trju_refno'] = $data[$key]['trcv_no'].'AS';
				$data_trju['jurnal_h']['trju_reftipe'] = 'AS';
				$data_trju['jurnal_h']['trju_msus_no'] = $data[$key]['trcv_msus_no'];
				$data_trju['jurnal_h']['trju_mscb_no'] = $data[$key]['trcv_mscb_no'];
				$data_trju['jurnal_h']['trju_tgl'] = $trcv_lscopy;
				$data_trju['jurnal_h']['trju_tipe'] = 'A';				
				$data_trju['jurnal_h']['trju_void'] = 0;
				$data_trju['jurnal_h']['trju_catatan'] = $data[$key]['trcv_no'].'/'.$data[$key]['trcv_msgd_no'].' - '.$gudang['msgd_nm'];
				$data_trju['jurnal_h']['trju_stcopy'] = 'A';
				$data_trju['jurnal_h']['trju_lscopy'] = $trcv_lscopy;
				$data_trju['jurnal_h']['trju_fin'] = 'F';										
				$data_trju['jurnal_h']['trju_lsupd'] = $trcv_lscopy;
				$data_trju['jurnal_h']['trju_lsusr'] = $data[$key]['trcv_lsusr'];

				// Insert data jurnal ke financial server
				if($this->db->insert('tr_jurnal',$data_trju['jurnal_h']) == false){
					$err = 1;
					$result = false;
					$err_msg = ', JURNAL '.$data_trju[$key]['trju_no'];
					break;
				}

				// Get dt_adjstok from financial server
				$query = $this->db->get_where('dt_adjstok', array('dtas_no' => $data[$key]['trcv_no']));
				$data_dtas = $query->result_array();	
				
				$seq = 1;
				foreach ($data_dtas as $key_dtas => $value_dtas) {										 					 					 		
					$mskt_no = substr($data_dtas[$key_dtas]['dtas_mspd_no'], 0, 1);
				 	$saldo = $data_dtas[$key_dtas]['dtas_hpp'] * $data_dtas[$key_dtas]['dtas_qty'];

			 		// Account Adjustment Stok (Debet)
			 		$acc = $this->m_setting_account->get_setting_account_byid('GCVT');
			 		$array['dtju_no'] = $data[$key]['trju_no'];
			 		$array['dtju_seq'] = $seq;
					$array['dtju_msap_no'] = $acc['mssa_msap_no'];
					$array['dtju_debet'] = $saldo;
					$array['dtju_kredit'] = 0;					

					// Insert data detail jurnal ke financial server
					if($this->db->insert('dt_jurnal',$array) == false){
						$err = 1;
						$result = false;
						$err_msg = ', DETAIL JURNAL ';
						break;
					}

					$seq += 1;

					// Account Inventory (Kredit)
					$array['dtju_no'] = $data[$key]['trju_no'];
			 		$array['dtju_seq'] = $seq;
					$array['dtju_msap_no'] = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
					$array['dtju_debet'] = 0;
					$array['dtju_kredit'] = $saldo;					

					// Insert data detail jurnal ke financial server
					if($this->db->insert('dt_jurnal',$array) == false){
						$err = 1;
						$result = false;
						$err_msg = ', DETAIL JURNAL ';
						break;
					}

					$seq += 1;
				}				
			}

			// Update status copy A			
			$this->update_trcv_stcopy($data[$key]['trcv_no'], 'A', $trcv_lscopy);			
		}

		// Update status copy F
		if($result == false){
			$this->update_trcv_stcopy($data[$key]['trcv_no'], 'F', $trcv_lscopy);
		}	

		return array('err'=>$err, 'err_msg' => $err_msg, 'nsukses'=>$nsukses, 'ndata'=>count($data));		
	}

	private function update_trcv_stcopy($primarykey, $stcopy, $lscopy){
		$this->dc->where('trcv_no', $primarykey);
		$this->dc->update('tr_cvtgoods', array('trcv_stcopy'=>$stcopy, 'trcv_lscopy'=>$lscopy));
	}

	private function update_tras_stcopy($primarykey, $stcopy, $lscopy){
		$this->dc->where('tras_no', $primarykey);
		$this->dc->update('tr_adjstok', array('tras_stcopy'=>$stcopy, 'tras_lscopy'=>$lscopy));
	}

	private function update_trts_stcopy($primarykey, $stcopy, $lscopy){
		$this->dc->where('trts_no', $primarykey);
		$this->dc->update('tr_tfmgoods', array('trts_stcopy'=>$stcopy, 'trts_lscopy'=>$lscopy));
	}

	private function update_trmt_stcopy($primarykey, $stcopy, $lscopy){
		$this->dc->where('trmt_no', $primarykey);
		$this->dc->update('tr_mutasi', array('trmt_stcopy'=>$stcopy, 'trmt_lscopy'=>$lscopy));
	}

	private function update_trso_stcopy($primarykey, $stcopy, $lscopy){
		$this->dc->where('trso_no', $primarykey);
		$this->dc->update('tr_so', array('trso_stcopy'=>$stcopy, 'trso_lscopy'=>$lscopy));
	}

	private function update_trpo_stcopy($primarykey, $stcopy, $lscopy){
		$this->dc->where('trpo_no', $primarykey);
		$this->dc->update('tr_po', array('trpo_stcopy'=>$stcopy, 'trpo_lscopy'=>$lscopy));
	}

	private function update_trspk_stcopy($primarykey, $stcopy, $lscopy){
		$this->dc->where('trspk_no', $primarykey);
		$this->dc->update('tr_spk', array('trspk_stcopy'=>$stcopy, 'trspk_lscopy'=>$lscopy));
	}

	private function update_trju_stcopy($primarykey, $stcopy, $lscopy){
		$this->dc->where('trju_no', $primarykey);
		$this->dc->update('tr_jurnal', array('trju_stcopy'=>$stcopy, 'trju_lscopy'=>$lscopy));
	}

	private function update_msat_stcopy($primarykey, $stcopy, $lscopy){
		$this->dc->where('msat_no', $primarykey);
		$this->dc->update('ms_aktiva_tetap', array('msat_stcopy'=>$stcopy, 'msat_lscopy'=>$lscopy));
	}

	public function cek_versidb(){		
		// Get versi db di server internal 
		$this->dc->select('simr_int1');
		$query = $this->dc->get_where('simrel', array('simr_no' => 'ver','simr_seq' => 1));		
		
		if ($query->num_rows() > 0) {
			$result = $query->result_array();
			$verc =  $result[0]['simr_int1'];
		}else{
			$verc = 0;
		}

		// Get versi db di server finansial 
		$this->db->select('simr_int1');
		$query = $this->db->get_where('simrel', array('simr_no' => 'ver','simr_seq' => 1));		
		
		if ($query->num_rows() > 0) {
			$result = $query->result_array();
			$verf = $result[0]['simr_int1'];
		}else{
			$verf = 0;
		}

		if($verc == $verf){
			return true;
		}else{
			return false;
		}
	}
	
}	