<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_purchase_order extends MY_Model {

	function __construct(){
		parent::__construct();				
		$this->load->model('setting/m_user_log');
	}

	public function get_purchase_order_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trpo_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('*');
		$this->db->from('tr_po');
		$this->db->join('ms_cabang', 'mscb_no = trpo_mscb_no', 'left');
		$this->db->join('ms_supplier', 'mssp_no = trpo_mssp_no', 'left');
		$this->db->join('ms_user', 'msus_no = trpo_msus_no', 'left');

		$query_string = '';

		if(isset($arr_filter['mspd_no'])){			
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x1.* FROM dt_po x1 WHERE x1.dtpo_no = trpo_no AND x1.dtpo_mspd_no LIKE "%'. $arr_filter['mspd_no']. '%")';							
			unset($arr_filter['mspd_no']);
		}

		if(isset($arr_filter['mspd_nm'])){
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x2.*, a.mspd_nm AS mspd_nm FROM dt_po x2 LEFT JOIN ms_produk AS a ON a.mspd_no = x2.dtpo_mspd_no WHERE x2.dtpo_no = trpo_no AND a.mspd_nm LIKE "%'. $arr_filter['mspd_nm']. '%")';
			unset($arr_filter['mspd_nm']);
		}

		//Payment status
		//1. PAYMENT-SETTLED
		//2. PAYMENT-UNSETTLED

		if(isset($arr_filter['payment_status'])){
			if($arr_filter['payment_status'] == '1'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'round(trpo_terbayar, 4) >= round(trpo_total, 4)';
			}elseif($arr_filter['payment_status'] == '2'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'round(trpo_terbayar, 4) < round(trpo_total, 4)';
			}		
			unset($arr_filter['payment_status']);	
		}

		//Finalize status
		//1. PO : Ready To Finalize		

		if(isset($arr_filter['finalize_status'])){
			if($arr_filter['finalize_status'] == '1'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'trpo_terbayar >= trpo_total AND trpo_sisadp <= 0 AND trpo_final = "N"';
			}
			unset($arr_filter['finalize_status']);	
		}

		//Incoming delivery status
		//1. INCOMING DELIVERY-COMPLETE
		//2. INCOMING DELIVERY-INCOMPLETE

		if(isset($arr_filter['incoming_delivery_status'])){
			if($arr_filter['incoming_delivery_status'] == '1'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				
				$query_string .= '(((SELECT SUM(a.dtpo_qty - a.dtpo_qtyid) FROM dt_po a WHERE a.dtpo_no = trpo_no AND trpo_lock = "N") <= 0) OR (trpo_lock = "Y"))';
				
			}elseif($arr_filter['incoming_delivery_status'] == '2'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}

				$query_string .= '(SELECT SUM(a.dtpo_qty - a.dtpo_qtyid) FROM dt_po a WHERE a.dtpo_no = trpo_no AND trpo_lock = "N") > 0';			
			}
			unset($arr_filter['incoming_delivery_status']);
		}			

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}

		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}	
	}

	public function get_purchase_order_toplist($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'tppo_tgljatuhtempo', $sort = 'DESC'){
		if(!$is_count){
			$this->db->limit($per_page, $offset);		
		}
		$this->db->select('*');
		$this->db->from('top_po');		
		$this->db->join('tr_po','trpo_no = tppo_no', 'left');
		$this->db->join('ms_supplier', 'ms_supplier.mssp_no = tr_po.trpo_mssp_no','left');				

		//TOP Status
		//1. Current Date
		//2. Late Date

		if(isset($arr_filter['topdate_status'])){					
			if($arr_filter['topdate_status'] == 1){
				// $this->db->where(array('tppo_tgljatuhtempo' => date('Y-m-d'), 'trpo_void'=>0));
				$query_string = ' (DATEDIFF(tppo_tgljatuhtempo, "'.date('Y-m-d').'") <= 3) AND (DATEDIFF(tppo_tgljatuhtempo, "'.date('Y-m-d').'") >= 0) AND (tppo_aktif ="Y") ';
				$this->db->where($query_string, null, false);
			}

			if($arr_filter['topdate_status'] == 2){				
				$query_string = ' (tppo_tgljatuhtempo < CURDATE()) AND (trpo_terbayar < trpo_total) AND (tppo_aktif ="Y") ';
				$this->db->where($query_string, null, false);
			}
			unset($arr_filter['topdate_status']);
		}		

		$this->db->where(array('trpo_void'=>0));

		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);
		}

		$this->db->order_by($fn, $sort);
		$query = $this->db->get();
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_purchase_order($trpo_no){		
		$data = array();		

		//Get purchase order header berdasarkan trpo_no	
		$this->db->select('*, IFNULL((SELECT SUM(dtpo_qty) FROM dt_po LEFT JOIN tr_po ON tr_po.trpo_no=dt_po.dtpo_no WHERE dtpo_no = "'. $trpo_no .'"),0) AS trpo_totalqty,
							IFNULL((SELECT SUM(dtpo_qtyid) FROM dt_po LEFT JOIN tr_po ON tr_po.trpo_no=dt_po.dtpo_no WHERE dtpo_no = "'. $trpo_no .'" AND trpo_void = 0),0) AS trpo_totalqtyid,
							  IFNULL((SELECT SUM(dtpo_qtyterima) FROM dt_po LEFT JOIN tr_po ON tr_po.trpo_no=dt_po.dtpo_no WHERE dtpo_no = "'. $trpo_no .'" AND trpo_void = 0),0) AS trpo_totalqtyterima,
							EXISTS(SELECT trid_no FROM tr_in_dlv WHERE SUBSTRING(trid_no, 1, 12) = "'.$trpo_no.'" AND trid_void = 0) AS is_idcreated,
							EXISTS(SELECT pbpo_no FROM pby_po WHERE SUBSTRING(pbpo_no, 1, 12) = "'.$trpo_no.'" AND pbpo_void = 0) AS is_ppcreated, mssp_nm');
		$this->db->from('tr_po');
		$this->db->join('ms_cabang', 'ms_cabang.mscb_no = tr_po.trpo_mscb_no','left');
		$this->db->join('ms_user', 'ms_user.msus_no = tr_po.trpo_msus_no','left');
		$this->db->join('ms_supplier', 'ms_supplier.mssp_no = tr_po.trpo_mssp_no','left');
		$this->db->where('tr_po.trpo_no',$trpo_no);
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$result = $query->result_array();	
			$data['header'] = $result[0];
		}

		//Get top po berdasarkan trpo_no
		$query = $this->db->get_where('top_po', array('tppo_no' => $trpo_no));
		if($query->num_rows() > 0){
			$data['top_po'] = $query->result_array();
		}
		
		//Get approval PR detail berdasarkan trpo_no
		$this->db->select("dt_po.*, ms_produk.*, dt_apv_purcreq.*, 
							IFNULL((SELECT SUM(dtpt_qtyretur) FROM dt_purcret LEFT JOIN tr_purcret ON trpt_no = dtpt_no WHERE SUBSTRING(dtpt_no,1,12) = dtpo_no AND dtpt_seq = dtpo_seq AND dtpt_no <> '' AND trpt_void = 0),0) AS calc_qty_retur,
							IFNULL((SELECT SUM(dtid_qtyterima) FROM dt_in_dlv LEFT JOIN tr_in_dlv ON trid_no = dtid_no WHERE SUBSTRING(dtid_no,1,12) = dtpo_no AND dtid_seq = dtpo_seq AND dtid_no <> '' AND trid_void = 0),0) AS calc_qty_id");
		$this->db->from('dt_po');
		$this->db->join('dt_apv_purcreq', 'dt_apv_purcreq.dappr_no = dt_po.dtpo_dappr_no AND dt_apv_purcreq.dappr_seq = dt_po.dtpo_dappr_seq','left');
		$this->db->join('ms_produk', 'ms_produk.mspd_no = dt_po.dtpo_mspd_no','left');		
		$this->db->where('dt_po.dtpo_no',$trpo_no);
		$this->db->order_by('dtpo_seq', 'ASC');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail'] = $detail;			
		}

		return $data;

		// if(count($data) > 0){
		// 	return $data;
		// }else{
		// 	return array();
		// }
	}

	public function get_dtpo_bymspdno($mspd_no){		
		$this->db->select("dt_po.*, trpo_tgl, trpo_no, mssp_nm");
		$this->db->from('dt_po');		
		$this->db->join('tr_po', 'trpo_no = dtpo_no','left');		
		$this->db->join('ms_supplier', 'trpo_mssp_no = mssp_no','left');		
		$this->db->where('dtpo_mspd_no',$mspd_no);
		$this->db->where('trpo_void',0);
		$this->db->order_by('trpo_tgl', 'DESC');
		$this->db->limit(10);
		$query = $this->db->get();	
		return $query->result_array();				
	}

	public function purchase_order_kode_auto($trpo_kode_depan){
		$this->db->select_max("trpo_no");
		$this->db->like("trpo_no", $trpo_kode_depan, "after");
		$query = $this->db->get("tr_po");
		if ($query->num_rows() == 0){
			return $trpo_kode_depan. "0001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['trpo_no'];
			$nomor = ((int) substr($kode, 8)) + 1;			
			return $trpo_kode_depan. sprintf("%'.04d", $nomor);
		}
	}	

	public function get_purchase_order_cekint($trpo_no, $trpo_cekint){		
		$query = $this->db->get_where('tr_po', array('trpo_no' => $trpo_no,
													 'trpo_cekint' => $trpo_cekint));		
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}	
	}

	public function set_purchase_order_cekint($trpo_no){
		//Update trpo_cekint di tabel tr_po
		$this->db->where('trpo_no', $trpo_no);
		$this->db->update('tr_po', array('trpo_cekint' => rand(0,10000)));
	}

	public function purchase_order_simpan($data){
		try {			
				if($data['action'] == 'NEW'){
					// Insert data PO
					$this->insert_data($data);
					// Insert data detail approval PR
					$this->update_dt_apv_purcreq($data);
				}
				
				if($data['action'] == 'EDIT'){
					// Update data
					$this->update_data($data);
					// Insert data detail approval PR
					$this->update_dt_apv_purcreq($data);
					// Simpan userlog
					// $this->m_user_log->user_log_simpan($data['userlog']);
				}

				if($data['action'] == 'VOID'){
					// Void data
					$this->void_data($data);
					// Simpan userlog
					// $this->m_user_log->user_log_simpan($data['userlog']);
				}

				// Simpan userlog
				$this->user_log_simpan($data);

				if($data['action'] == 'STCOPY'){
					$this->db->where('trpo_no', $data['header']['trpo_no']);
					$this->db->update('tr_po', array('trpo_stcopy'=>$data['header']['trpo_stcopy']));
				}				
			return 1;
		} catch (Exception $e) {
			return 0;
		}		
	}

	private function user_log_simpan($data){		
		//Insert user log
		if(isset($data['userlog'])){			
			foreach ($data['userlog'] as $key => $value) {				
				$this->db->insert('ms_userlog',$data['userlog'][$key]);
			}
		}
	}		

	private function insert_data($data){
		//Insert data header PO
		$this->db->insert('tr_po',$data['header']);
	
		//Insert data detail PO
		if(isset($data['detail'])){
			foreach ($data['detail'] as $key => $value) {																
			    $this->db->insert('dt_po',$data['detail'][$key]);
			}		
		}				

		//Insert data top po
		if(isset($data['top_po'])){			
			foreach ($data['top_po'] as $key => $value) {
				$this->db->insert('top_po',$data['top_po'][$key]);
			}
		}				
	}

	private function update_data($data){
		//Update data header PO		
		$this->db->where('trpo_no', $data['header']['trpo_no']);
		$this->db->update('tr_po', $data['header']);
		
		//Delete data detail PO
		$this->db->where(array('dtpo_no' => $data['header']['trpo_no']));
		$this->db->delete('dt_po');

		//Insert data detail PO
		if(isset($data['detail'])){
			foreach ($data['detail'] as $key => $value) {																
			    $this->db->insert('dt_po',$data['detail'][$key]);
			}		
		}

		//Delete data top PO
		$this->db->where(array('tppo_no' => $data['header']['trpo_no']));
		$this->db->delete('top_po');

		//Insert data top PO
		if(isset($data['top_po'])){			
			foreach ($data['top_po'] as $key => $value) {
				$this->db->insert('top_po',$data['top_po'][$key]);
			}
		}
	}

	public function top_po_simpan($data){		
		try{
			//Delete data top PO
			$this->db->where(array('tppo_no' => $data['header']['trpo_no']));
			$this->db->delete('top_po');

			//Insert data top PO
			if(isset($data['top_po'])){			
				foreach ($data['top_po'] as $key => $value) {
					$data['top_po'][$key]['tppo_no'] = $data['header']['trpo_no'];					
					$this->db->insert('top_po',$data['top_po'][$key]);
				}
			}			
			return 1;
		}catch (Exception $e) {
			return 0;
		}
	}

	private function update_dt_apv_purcreq($data){				
		//Update data detail approval PR
		if(isset($data['detail'])){
			//Reset/Update data detail approval PR				
			$this->db->where('dappr_trpo_no', $data['header']['trpo_no']);
			$this->db->update('dt_apv_purcreq', array('dappr_trpo_no' => ''));

			//Update dappr_trpo_no di table dt_apv_purcreq
			foreach ($data['detail'] as $key => $value) {																
				$this->db->where(array('dappr_no' => $data['detail'][$key]['dtpo_dappr_no'],
										'dappr_seq' => $data['detail'][$key]['dtpo_dappr_seq']));

				$this->db->update('dt_apv_purcreq', array('dappr_trpo_no' => $data['detail'][$key]['dtpo_no'],
																	'dappr_cekint' => rand(0,10000)));
			}
		}				
	}

	private function void_data($data){
		//Void data
		$this->db->where('trpo_no', $data['header']['trpo_no']);
		$this->db->update('tr_po', array('trpo_void' => 1));

		// Update dappr_trpo_no di table dt_apv_purcreq
		$this->db->where('dappr_trpo_no', $data['header']['trpo_no']);
		$this->db->update('dt_apv_purcreq', array('dappr_trpo_no' => '', 
														'dappr_cekint'=>rand(0,10000)));

		// //Update dappr_trpo_no di table dt_apv_purcreq
		// foreach ($data['detail'] as $key => $value) {			
		// 	$this->db->where(array('dappr_no' => $data['detail'][$key]['dtpo_dappr_no'], 
		// 							'dappr_seq' => $data['detail'][$key]['dtpo_dappr_seq']));

		// 	$this->db->update('dt_apv_purcreq', array('dappr_trpo_no' => '', 
		// 												'dappr_cekint'=>rand(0,10000)));
		// }					
	}

	// public function get_trid_total($trpo_no){
	// 	$sql = 'SELECT IFNULL(SUM(trid_total), 0) AS trid_total FROM tr_in_dlv WHERE SUBSTRING(trid_no, 1,12) = "'. $trpo_no .'" AND trid_void = 0';
	// 	$query = $this->db->query($sql);		

	// 	if($query->num_rows() > 0){
	// 		$result = $query->result_array();
	// 		return $result[0]['trid_total'];
	// 	}
	// }

	// public function purchase_order_lockpo($data){
	// 	try {								
	// 			$trid_total = $this->get_trid_total($data['header']['trpo_no']);

	// 			$this->db->where('trpo_no', $data['header']['trpo_no']);
	// 			$this->db->update('tr_po', array('trpo_lock' => 'Y', 'trpo_cekint' => rand(0,10000), 'trpo_total' => $trid_total));
	// 			$this->update_stcopy('LOCKPO', $data['header']['trpo_no']);
	// 			return 1;				
	// 	} catch (Exception $e) {
	// 		return 0;
	// 	}		
	// }

	public function purchase_order_lockpo($trpo_no){
		$query = "UPDATE tr_po SET trpo_lock = 'Y', trpo_total = IFNULL((
									SELECT SUM(A.trid_total) 
									FROM tr_in_dlv A															
									WHERE SUBSTRING(A.trid_no,1,12) = tr_po.trpo_no
									AND trid_void = 0
									),0)
					WHERE trpo_no= '".$trpo_no."'";		

		if($this->db->simple_query($query)){			
			$this->update_stcopy('LOCKPO', $trpo_no);
			return 1;
		}else{
			return 0;
		}
	}	

	public function purchase_order_cancellockpo($data){
		try {												
				$this->db->where('trpo_no', $data['header']['trpo_no']);
				$this->db->update('tr_po', array('trpo_lock' => 'N', 'trpo_total' => $data['header']['trpo_total']));
				$this->update_stcopy('CANCEL_LOCKPO', $data['header']['trpo_no']);
				return 1;				
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function update_stcopy($action,$trpo_no){
		$query = $this->db->query('SELECT trpo_stcopy FROM tr_po WHERE trpo_no ="'. $trpo_no.'" AND (trpo_stcopy = "A" OR trpo_stcopy = "F")');
	
		if($query->num_rows() <= 0){							
			$proses = false;
			if($action == 'CONF_RECEIVING_GOODS' || $action == 'LOCKPO'){			
				$query = $this->db->query('SELECT trpo_lock FROM tr_po WHERE trpo_no ="'. $trpo_no.'" AND trpo_lock = "Y"');	
				$status = 'R';
				if($query->num_rows() > 0){
					$query = $this->db->query('SELECT dtpo_qty FROM dt_po WHERE SUBSTRING(dtpo_no, 1, 12) ="'. $trpo_no. '" HAVING SUM(dtpo_qtyterima) >= SUM(dtpo_qtyid)');
					if($query->num_rows() > 0){						
						$proses = true;
					}						
				}else{
					$query = $this->db->query('SELECT dtpo_qty FROM dt_po WHERE SUBSTRING(dtpo_no, 1, 12) ="'. $trpo_no. '" HAVING SUM(dtpo_qtyterima) >= SUM(dtpo_qty)');
					if($query->num_rows() > 0){
						$proses = true;												
					}					
				}				
			}elseif ($action == 'CANCEL_RECEIVING_GOODS' || $action == 'CANCEL_LOCKPO') {
				$proses = true;
				$status = 'W';
			}

			if($proses){				
				$this->db->where('trpo_no', $trpo_no);
				$this->db->update('tr_po', array('trpo_stcopy'=>$status));
			}
		}		
	}	

	public function purchase_order_finalize($data){
		try {
			// set trpo_final = Y
			$this->db->where('trpo_no', $data['header']['trpo_no']);
			$this->db->update('tr_po', array('trpo_final' => 'Y'));

			// simpan jurnal
			$this->jurnal_simpan($data);			
			return 1;			
		} catch (Exception $e) {
			return 0;
		}
	}

	public function purchase_order_cancel_finalize($data){
		try {
			// set trpo_final = N
			$this->db->where('trpo_no', $data['header']['trpo_no']);
			$this->db->update('tr_po', array('trpo_final' => 'N'));

			// hapus jurnal
			if(isset($data['jurnal_h']['trju_no']) && strlen($data['jurnal_h']['trju_no']) > 0){
				$this->db->delete('tr_jurnal', array('trju_no' => $data['jurnal_h']['trju_no']));
				$this->db->delete('dt_jurnal', array('dtju_no' => $data['jurnal_h']['trju_no']));
			}			

			return 1;			
		} catch (Exception $e) {
			return 0;
		}
	}

	private function jurnal_simpan($data){				
		if(isset($data['jurnal_d'])){
			// Generate CekInt
			$data['jurnal_h']['trju_cekint'] = rand(0,10000);						
			// Insert data header jurnal
			$this->db->insert('tr_jurnal',$data['jurnal_h']);			
		
			$seq = 1;
			foreach ($data['jurnal_d'] as $key => $value) {														
				$data['jurnal_d'][$key]['dtju_no'] = $data['jurnal_h']['trju_no'];
				$data['jurnal_d'][$key]['dtju_seq'] = $seq;
				$this->db->insert('dt_jurnal',$data['jurnal_d'][$key]);
				$seq += 1;
			}		
		}		
	}	

	public function cek_trpo_no_exists($trpo_no){		
		$query = $this->db->get_where('tr_po', array('trpo_no' => $trpo_no));
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function get_limit_price_dt($dtpo_mspd_no){
		$data = array();
		for ($i = 0; $i < count($dtpo_mspd_no); $i++){

			$this->db->select('dtpo_mspd_no, dtpo_bftax, trpo_curr, trpo_no');
			$this->db->from('dt_po');			
			$this->db->join('tr_po', 'dtpo_no = trpo_no','left');					
			$this->db->where(array('trpo_void' => 0, 'dtpo_mspd_no' => $dtpo_mspd_no[$i]));
			$this->db->order_by('trpo_tgl', 'DESC');
			$this->db->limit(1);

			$result = $this->db->get()->row();
			if($result == null){
				$result = array(
					'dtpo_mspd_no' => $dtpo_mspd_no[$i],
					'dtpo_bftax' => '',
					'trpo_curr' => '',
					'trpo_no' => '-',
				);
			}

			array_push($data, $result);	
		}
		
		return $data;
	}
}
