<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_purchase_request extends MY_Model {

	function __construct(){
		parent::__construct();		
		$this->load->model('setting/m_user_log');		
	}

	public function get_purchase_request_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trpr_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('tr_purcreq.*, msus_nm, mscb_nm');
		$this->db->from('tr_purcreq');
		$this->db->join('ms_user','msus_no = trpr_msus_no', 'left');
		$this->db->join('ms_cabang','mscb_no = trpr_mscb_no', 'left');

		$query_string = '';

		if(isset($arr_filter['mspd_no'])){			
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x1.* FROM dt_purcreq x1 WHERE x1.dtpr_no = trpr_no AND x1.dtpr_mspd_no LIKE "%'. $arr_filter['mspd_no']. '%")';
			unset($arr_filter['mspd_no']);
		}

		if(isset($arr_filter['mspd_nm'])){
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x2.*, a.mspd_nm AS mspd_nm FROM dt_purcreq x2 LEFT JOIN ms_produk AS a ON a.mspd_no = x2.dtpr_mspd_no WHERE x2.dtpr_no = trpr_no AND a.mspd_nm LIKE "%'. $arr_filter['mspd_nm']. '%")';
			unset($arr_filter['mspd_nm']);
		}		

		//Approval Satus
		//1. APPROVAL-COMPLETE
		//2. APPROVAL-INCOMPLETE

		if(isset($arr_filter['approval_status'])){
			if($arr_filter['approval_status'] == '1'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'NOT EXISTS(SELECT x3.* FROM dt_purcreq x3 WHERE x3.dtpr_no = trpr_no AND x3.dtpr_appr_no = "")';
				//$query_string .= 'EXISTS(SELECT x4.* FROM dt_purcreq x4 WHERE x4.dtpr_no = trpr_no AND x4.dtpr_appr_no <> "")';				
			}elseif($arr_filter['approval_status'] == '2'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'EXISTS(SELECT x3.* FROM dt_purcreq x3 WHERE x3.dtpr_no = trpr_no AND x3.dtpr_appr_no = "")';				
			}
			unset($arr_filter['approval_status']);
		}		

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}

		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		

		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}		
	}	

	public function get_purchase_request($trpr_no){		
		$data = array();		

		//Get purchase request header berdasarkan trpr_no	
		$this->db->select('*, 
							EXISTS(SELECT * FROM dt_purcreq WHERE dtpr_no = "'. $trpr_no .'" AND dtpr_appr_no = "") AS trpr_apvstat,
							NOT EXISTS(SELECT * FROM dt_purcreq WHERE dtpr_no = "'. $trpr_no .'" AND dtpr_appr_no != "") AS is_editable');
		$this->db->from('tr_purcreq');
		$this->db->join('ms_cabang', 'mscb_no = trpr_mscb_no','inner');
		$this->db->join('ms_user', 'msus_no = trpr_msus_no','inner');
		$this->db->where('tr_purcreq.trpr_no',$trpr_no);
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$result = $query->result_array();	
			$data['header'] = $result[0];
		}
		
		//Get purchase request detail berdasarkan trpr_no	
		$this->db->select('*, IFNULL((SELECT SUM(dtpo_qtyterima) FROM dt_po LEFT JOIN tr_po ON trpo_no = dtpo_no WHERE dtpo_no = dappr_trpo_no AND dtpo_seq = dappr_seq AND trpo_void = 0), 0) AS dtpo_ig');
		$this->db->from('dt_purcreq');
		$this->db->join('ms_produk', 'dt_purcreq.dtpr_mspd_no = ms_produk.mspd_no','left');				
		$this->db->join('dt_apv_purcreq', 'dt_apv_purcreq.dappr_no = dt_purcreq.dtpr_appr_no AND dt_apv_purcreq.dappr_dtpr_no = dt_purcreq.dtpr_no AND dt_apv_purcreq.dappr_dtpr_seq = dt_purcreq.dtpr_seq','left');
		$this->db->where('dt_purcreq.dtpr_no',$trpr_no);
		$this->db->order_by('dtpr_seq', 'ASC');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail'] = $detail;			
		}

		if(count($data) > 0){
			return $data;
		}else{
			return array();
		}
	}	

	private function avaliable_stock_query(){
		$this->db->select('*');
		$this->db->from('ms_gudang');		
		$this->db->like(array('msgd_listmscb' => $this->session->userdata('user_aktif')['msus_mscb_no'], 'msgd_aktif'=>1));
		$query = $this->db->get();
		$gudang = $query->result_array(); 
				
		$total_query_y = "";		

		if(count($gudang) > 0){
			foreach ($gudang as $key => $value) {
				if($gudang[$key]['msgd_avl'] == 'Y'){
					$gudang_query = " IFNULL((SELECT SUM(msst_qty) FROM ms_stok INNER JOIN ms_gudang ON msgd_no = msst_msgd_no AND msgd_avl = 'Y' WHERE msst_mspd_no = mspd_no AND msst_msgd_no = '". $gudang[$key]['msgd_no'] ."'),0)";

					if($total_query_y != ""){
						$total_query_y .= " + ";
					}

					$total_query_y .= $gudang_query;
				}
			}				
		}else{
			$total_query_y .= " IFNULL((SELECT SUM(msst_qty) FROM ms_stok INNER JOIN ms_gudang ON msgd_no = msst_msgd_no AND msgd_avl = 'Y' WHERE msst_mspd_no = mspd_no AND msst_msgd_no = 'GUDANG_BELUM_ADA'),0)";
		}							

		$so_dekat_locky = " IFNULL((SELECT SUM(dtso_qtysd - dtso_qtykirim) FROM dt_so LEFT JOIN tr_so ON trso_no = dtso_no WHERE trso_void = 0 AND trso_lock='Y' AND trso_mscb_no LIKE '%". $this->session->userdata('user_aktif')['msus_mscb_no'] ."%' AND DATEDIFF(trso_tglestkirim,'". date('Y-m-d') ."') <= 120 AND dtso_mspd_no = mspd_no),0)";
		$so_dekat_lockn = " IFNULL((SELECT SUM(dtso_qty - dtso_qtykirim) FROM dt_so LEFT JOIN tr_so ON trso_no = dtso_no WHERE trso_void = 0 AND trso_lock='N' AND trso_mscb_no LIKE '%". $this->session->userdata('user_aktif')['msus_mscb_no'] ."%' AND DATEDIFF(trso_tglestkirim,'". date('Y-m-d') ."') <= 120 AND dtso_mspd_no = mspd_no),0)";
		$so_dekat_query = $so_dekat_lockn. '+'. $so_dekat_locky;
		
		$mutasi_out_query = " IFNULL((SELECT SUM(dtmt_qtyout - dtmt_qtyin)"
								 ." FROM dt_mutasi"
								 ." LEFT JOIN tr_mutasi ON trmt_no = dtmt_no"
								 ." LEFT JOIN ms_gudang ON msgd_no = trmt_msgd_no1"
								 ." WHERE trmt_void = 0"
								 ." AND trmt_tglkirim = '0000-00-00'"
								 ." AND dtmt_mspd_no = mspd_no"
								 ." AND dtmt_stapv = 'N'" 
								 ." AND msgd_listmscb LIKE '%".$this->session->userdata('user_aktif')['msus_mscb_no']."%'), 0) ";			

		//query field avaliable stock
		return $avaliable_stock_query = $total_query_y. " - (". $so_dekat_query. " + ". $mutasi_out_query. ") ";
	}

	public function pr_detail_list($arr_filter, $per_page, $offset, $fn, $sort, $is_combo){		
		// $avaliable_stock_query = $this->avaliable_stock_query();

		// $sql = 'dt_purcreq.*, mspd_nm, msmr_nm, mskt_nm, msfm_nm, msmd_nm, trpr_tag, trpr_tgl, ';		
		$sql = 'dt_purcreq.*, mspd_nm, msmr_nm, mskt_nm, msfm_nm, msmd_nm, trpr_tag, trpr_tgl ';		

		// $sql .= $avaliable_stock_query." AS 'mspd_qtyavl'";

		if($is_combo === false){
			$this->db->limit($per_page, $offset);
		}

		$this->db->select($sql);
		$this->db->from('dt_purcreq');		
		$this->db->join('tr_purcreq', 'tr_purcreq.trpr_no = dt_purcreq.dtpr_no','left');
		$this->db->join('ms_produk', 'ms_produk.mspd_no = dt_purcreq.dtpr_mspd_no','left');
		$this->db->join('ms_merk', 'ms_merk.msmr_no = ms_produk.mspd_msmr_no','left');
		$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(dt_purcreq.dtpr_mspd_no,1,1)','left');
		$this->db->join('ms_famili', 'ms_famili.msfm_no = SUBSTRING(dt_purcreq.dtpr_mspd_no,1,3)','left');
		$this->db->join('ms_model', 'ms_model.msmd_no = SUBSTRING(dt_purcreq.dtpr_mspd_no,1,6)','left');		

		if(count($arr_filter) != 0){
			// foreach ($arr_filter as $key => $value) {
			// 	if ($key == 'mspd_qtyavl') {
			// 		unset($arr_filter['mspd_qtyavl']);
			// 		$arr_filter[$avaliable_stock_query] = $value;
			// 		break;
			// 	}
			// }

			$this->db->like($arr_filter);
		}		
		$this->db->where(array('dtpr_appr_no'=>'', 'trpr_void'=> 0));
		$this->db->order_by($fn, $sort);
		$query = $this->db->get();
		return $query->result_array();
	}	

	public function get_pr_detail($arr_filter){
		// $avaliable_stock_query = $this->avaliable_stock_query();
		// $sql = 'dt_purcreq.*, mspd_nm, msmr_nm, mskt_nm, msfm_nm, msmd_nm, trpr_tag, trpr_tgl, trpr_catatan, ';
		$sql = 'dt_purcreq.*, mspd_nm, msmr_nm, mskt_nm, msfm_nm, msmd_nm, trpr_tag, trpr_tgl, trpr_catatan ';

		// $sql .= $avaliable_stock_query." AS 'mspd_qtyavl'";

		$this->db->select($sql);
		$this->db->from('dt_purcreq');
		$this->db->join('tr_purcreq', 'tr_purcreq.trpr_no = dt_purcreq.dtpr_no','left');
		$this->db->join('ms_produk', 'ms_produk.mspd_no = dt_purcreq.dtpr_mspd_no','left');
		$this->db->join('ms_merk', 'ms_merk.msmr_no = ms_produk.mspd_msmr_no','left');
		$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(dt_purcreq.dtpr_mspd_no,1,1)','left');
		$this->db->join('ms_famili', 'ms_famili.msfm_no = SUBSTRING(dt_purcreq.dtpr_mspd_no,1,3)','left');
		$this->db->join('ms_model', 'ms_model.msmd_no = SUBSTRING(dt_purcreq.dtpr_mspd_no,1,6)','left');		

		if(count($arr_filter) != 0){
			// foreach ($arr_filter as $key => $value) {
			// 	if ($key == 'mspd_qtyavl') {
			// 		unset($arr_filter['mspd_qtyavl']);
			// 		$arr_filter[$avaliable_stock_query] = $value;
			// 		break;
			// 	}
			// }

			$this->db->like($arr_filter);
		}
		// if(count($arr_filter) != 0){
		// 	$this->db->like($arr_filter);			
		// }		
		$this->db->where(array('dtpr_appr_no'=>'', 'trpr_void'=> 0));
		$query = $this->db->get();				
		return $query->result_array();
	}	

	public function purchase_request_kode_auto($trpr_kode_depan){
		$this->db->select_max("trpr_no");
		$this->db->like("trpr_no", $trpr_kode_depan, "after");
		$query = $this->db->get("tr_purcreq");
		if ($query->num_rows() == 0){
			return $trpr_kode_depan. "0001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['trpr_no'];
			$nomor = ((int) substr($kode, 7)) + 1;			
			return $trpr_kode_depan. sprintf("%'.04d", $nomor);
		}
	}	

	public function get_purchase_request_cekint($dtpr_no, $dtpr_seq, $dtpr_cekint){
		$query = $this->db->get_where('dt_purcreq', array('dtpr_no' => $dtpr_no, 'dtpr_seq' => $dtpr_seq, 'dtpr_cekint' => $dtpr_cekint));			
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}	
	}

	public function set_purchase_request_cekint($dtpr_no, $dtpr_seq){
		$this->db->where(array('dtpr_no' => $dtpr_no, 'dtpr_seq' => $dtpr_seq));
		$this->db->update('dt_purcreq', array('dtpr_cekint' => rand(0, 10000)));
	}
	
	public function purchase_request_simpan($data){
		try {						
				if($data['action'] == 'NEW'){
					// Insert data
					$this->insert_data($data);
				}
				
				if($data['action'] == 'EDIT'){
					// Update data
					$this->update_data($data);
					// Simpan userlog
					$this->m_user_log->user_log_simpan($data['userlog']);
				}

				if($data['action'] == 'VOID'){
					// Void data
					$this->void_data($data);
					// Simpan userlog
					$this->m_user_log->user_log_simpan($data['userlog']);
				}				
				return 1;
		} catch (Exception $e) {
			return 0;
		}		
	}				

	private function insert_data($data){
		//Insert data header purchase request
		$this->db->insert('tr_purcreq',$data['header']);
	
		//Insert data detail purchase request
		if(isset($data['detail'])){
			foreach ($data['detail'] as $key => $value) {				
				// Generate CekInt			
				$data['detail'][$key]['dtpr_cekint'] = rand(0,10000);
			    $this->db->insert('dt_purcreq',$data['detail'][$key]);
			}		
		}				
	}

	private function update_data($data){
		//Update data header purchase request	
		$this->db->where('trpr_no', $data['header']['trpr_no']);
		$this->db->update('tr_purcreq', $data['header']);
		
		//Delete data detail purchase request
		$this->db->where(array('dtpr_no' => $data['header']['trpr_no']));
		$this->db->delete('dt_purcreq');

		//Insert data detail purchase request
		if(isset($data['detail'])){
			foreach ($data['detail'] as $key => $value) {			
				$data['detail'][$key]['dtpr_cekint'] = rand(0,10000);				
				$this->db->insert('dt_purcreq', $data['detail'][$key]);
			}						
		}
	}

	private function void_data($data){
		//Void data
		$this->db->where('trpr_no', $data['header']['trpr_no']);
		$this->db->update('tr_purcreq', array('trpr_void' => 1));

		//Update dtpr_cekint di table dt_purcreq	
		$this->db->where('dtpr_no', $data['header']['trpr_no']);
		$this->db->update('dt_purcreq', array('dtpr_cekint' => rand(0,10000)));
	}
	
	public function cek_trpr_no_exists($trpr_no){		
		$query = $this->db->get_where('tr_purcreq', array('trpr_no' => $trpr_no));
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}
}
