<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_purchase_return extends MY_Model {

	function __construct(){
		parent::__construct();		
		$this->load->model('setting/m_user_log');		
	}

	public function get_purchase_return_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trpt_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('tr_purcret.*, msus_nm, mssp_nm, msgd_nm');
		$this->db->from('tr_purcret');
		$this->db->join('ms_user','msus_no = trpt_msus_no', 'left');
		$this->db->join('ms_supplier', 'ms_supplier.mssp_no = tr_purcret.trpt_mssp_no','left');
		$this->db->join('ms_gudang', 'ms_gudang.msgd_no = tr_purcret.trpt_msgd_no','left');

		$query_string = '';

		//Return delivery status
		//1. Confirmed
		//2. Not yet confirmed

		if(isset($arr_filter['confirm_ptdlv_status'])){
			if($arr_filter['confirm_ptdlv_status'] == '1'){			
				$query_string .= ' trpt_tglkeluar != "0000-00-00"';
			}elseif($arr_filter['confirm_ptdlv_status'] == '2'){			
				$query_string .= ' trpt_tglkeluar = "0000-00-00"';			
			}		
			unset($arr_filter['confirm_ptdlv_status']);
		}

		//Return voucher status
		//1. Settled
		//2. Unsettled

		if(isset($arr_filter['voucher_status'])){
			if($arr_filter['voucher_status'] == '1'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'NOT(trpt_jenis = "V" AND trpt_pbpo_no = "")';
			}elseif($arr_filter['voucher_status'] == '2'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'trpt_jenis = "V" AND trpt_pbpo_no = ""';
			}
			unset($arr_filter['voucher_status']);
		}			

		if(isset($arr_filter['mspd_no'])){			
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x1.* FROM dt_po x1 WHERE x1.dtpo_no = SUBSTRING(trpt_no, 1, 12) AND x1.dtpo_mspd_no LIKE "%'. $arr_filter['mspd_no']. '%")';							
			unset($arr_filter['mspd_no']);
		}

		if(isset($arr_filter['mspd_nm'])){
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x2.*, a.mspd_nm AS mspd_nm FROM dt_po x2 LEFT JOIN ms_produk AS a ON a.mspd_no = x2.dtpo_mspd_no WHERE x2.dtpo_no = SUBSTRING(trpt_no, 1, 12) AND a.mspd_nm LIKE "%'. $arr_filter['mspd_nm']. '%")';
			unset($arr_filter['mspd_nm']);
		}		

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}

		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}	
	}	

	/*public function purchase_return_count($arr_filter){		
		$this->db->select('*');
		$this->db->from('tr_purcret');		
		$this->db->join('ms_user','msus_no = trpt_msus_no', 'left');
		$this->db->join('ms_supplier', 'ms_supplier.mssp_no = tr_purcret.trpt_mssp_no','left');
		$this->db->join('ms_gudang', 'ms_gudang.msgd_no = tr_purcret.trpt_msgd_no','left');

		$query_string = '';

		//Return delivery status
		//1. Delivered
		//2. Not yet delivered

		if($arr_filter['return_delivery_status'] == '1'){			
			$query_string .= 'trpt_tglkeluar != 0000-00-00';
		}elseif($arr_filter['return_delivery_status'] == '2'){			
			$query_string .= 'trpt_tglkeluar = 0000-00-00';			
		}		

		unset($arr_filter['return_delivery_status']);

		if(isset($arr_filter['mspd_no'])){			
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x1.* FROM dt_purcret x1 WHERE x1.dtpt_no = trpt_no AND x1.dtpt_mspd_no LIKE "%'. $arr_filter['mspd_no']. '%")';							
			unset($arr_filter['mspd_no']);
		}

		if(isset($arr_filter['mspd_nm'])){
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x2.*, a.mspd_nm AS mspd_nm FROM dt_purcret x2 LEFT JOIN ms_produk AS a ON a.mspd_no = x2.dtpt_mspd_no WHERE x2.dtpt_no = trpt_no AND a.mspd_nm LIKE "%'. $arr_filter['mspd_nm']. '%")';
			unset($arr_filter['mspd_nm']);
		}		

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}

		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);			
		}		
		$query = $this->db->get();
		return $query->num_rows();				
	}*/

	public function purchase_return_kode_auto($trpt_no){
		$this->db->select_max("trpt_no");
		$this->db->like("trpt_no", $trpt_no, "after");
		$query = $this->db->get("tr_purcret");
		if ($query->num_rows() == 0){
			return $trpo_no. "-RT01";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['trpt_no'];
			$nomor = ((int) substr($kode, 15)) + 1;			
			return $trpt_no. '-RT'. sprintf("%'.02d", $nomor);
		}
	}

	public function get_purchase_return($trpt_no){		
		$data = array();		
		
		//Get sales retur header berdasarkan trpt_no	
		$this->db->select('tr_purcret.*, trpo_no, trpo_cekint, mssp_nm, msus_nm, mssp_cp, mssp_almt_jln, trpo_fin, 
							EXISTS(SELECT pbpo_trpt_no FROM pby_po WHERE pbpo_trpt_no = "'.$trpt_no.'" AND pbpo_void = 0) AS is_pthaspaid');
		$this->db->from('tr_purcret');
		$this->db->join('tr_po', 'tr_po.trpo_no = SUBSTRING(tr_purcret.trpt_no, 1, 12)','inner');
		$this->db->join('ms_supplier', 'ms_supplier.mssp_no = tr_purcret.trpt_mssp_no','inner');
		$this->db->join('ms_user', 'ms_user.msus_no = tr_purcret.trpt_msus_no','inner');
		$this->db->where('tr_purcret.trpt_no',$trpt_no);
		$query = $this->db->get();

		if($query->num_rows() > 0){
			$result = $query->result_array();	
			$data['header'] = $result[0];			
		}

		//Get dt_purcret
		$sql = 'SELECT dt_po.*,'
					.' IFNULL(dt_purcret.dtpt_no,"") AS dtpt_no,'
					.' IFNULL(dt_purcret.dtpt_seq,"") AS dtpt_seq,'
					.' IFNULL(dt_purcret.dtpt_mspd_no,"") AS dtpt_mspd_no,'
					.' IFNULL(dt_purcret.dtpt_qtyretur,0) AS dtpt_qtyretur,'
					.' IFNULL(dt_purcret.dtpt_nettpo,dt_po.dtpo_nett) AS dtpt_nettpo,'
					.' IFNULL(dt_purcret.dtpt_bftaxrp,0) AS dtpt_bftaxrp,'
					.' IFNULL(dt_purcret.dtpt_taxrp,0) AS dtpt_taxrp,'
					.' IFNULL(dt_purcret.dtpt_nett,0) AS dtpt_nett,'
					.' IFNULL(dt_purcret.dtpt_hpp,0) AS dtpt_hpp,'
					.' IFNULL(ms_produk.mspd_nm,"") AS mspd_nm,'
					.' IFNULL(ms_produk.mspd_hpp,"") AS mspd_hpp,'
					.' IFNULL((SELECT SUM(dtpt_qtyretur) FROM dt_purcret LEFT JOIN tr_purcret ON trpt_no = dtpt_no WHERE SUBSTRING(dtpt_no,1,12) = dtpo_no AND dtpt_seq = dtpo_seq AND dtpt_no <> ? AND trpt_void = 0),0) AS calc_qty_retur'
					.' FROM dt_po'
					.' LEFT JOIN dt_purcret'
					.' ON dtpt_no=?'
					.' AND dt_po.dtpo_seq = dt_purcret.dtpt_seq'
					.' LEFT JOIN ms_produk'
					.' ON dt_po.dtpo_mspd_no=ms_produk.mspd_no'					
					.' WHERE dt_po.dtpo_no =? ORDER BY dtpo_seq ASC';

		$query = $this->db->query($sql, array($trpt_no, $trpt_no, substr($trpt_no, 0, 12)));
	
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail'] = $detail;
		}
		if(count($data) > 0){
			return $data;
		}else{
			return false;
		}
	}		

	public function get_purchase_return_cekint($trpt_no, $trpt_cekint){
		$query = $this->db->get_where('tr_purcret', array('trpt_no' => $trpt_no, 'trpt_cekint' => $trpt_cekint));		
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}	

	public function set_purchase_return_cekint($trpt_no){		
		//Update trpt_cekint di tabel tr_purcret
		$this->db->where('trpt_no', $trpt_no);
		$this->db->update('tr_purcret', array('trpt_cekint' => rand(0,10000)));
	}

	public function purchase_return_simpan($data){
		try{
			if($data['action'] == 'NEW'){
				// Insert data Purchase Return
				$this->insert_data($data);
			}

			if($data['action'] == 'EDIT'){
				// Update data Purchase Return					
				$this->update_data($data);
				// Simpan userlog
				$this->m_user_log->user_log_simpan($data['userlog']);					
			}

			if($data['action'] == 'CONF_EXIT_GOODS'){
				//todo list
				//1. Update data purchase return header/detail					
				//2. Update hpp (-)
				//3. Update stok (-)
				//4. Create jurnal

				//1. Update data purchase return header/detail
				$this->update_data($data);					
				//2. Update hpp (-)
				$this->save_update_hpp($data['header']['trpt_no'], -1, 'PTE');
				// $this->update_hpp($data['header']['trpt_no'], -1);
				//3. Update stok (-)
				$this->update_stok($data['header']['trpt_no'], -1);
				//4. Create jurnal
				$this->jurnal_simpan($data);
			}

			if($data['action'] == 'CANCEL_EXIT_GOODS'){
				//todo list
				//1. Update hpp (+)
				//2. Update stok (+)
				//3. Update data purchase return header/detail					
				//4. Delete jurnal

				//1. Update hpp (+)
				$this->save_update_hpp($data['header']['trpt_no'], 1, 'PTC');
				// $this->update_hpp($data['header']['trpt_no'], 1);
				//2. Update stok (+)
				$this->update_stok($data['header']['trpt_no'], 1);
				//3. Update data purchase return header/detail
				$this->update_data($data);							
				//4. Delete jurnal
				$this->jurnal_hapus($data);
			}

			//Update dtpo_qtyretur di detail po
			if($data['action'] != 'NEW'){			
				$this->update_qtyretur($data['header']['trpt_no']);
			}

			if($data['action'] == 'VOID'){
				// Void data
				$this->void_data($data);
				// Simpan userlog
				$this->m_user_log->user_log_simpan($data['userlog']);
			}
			return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}

	private function insert_data($data){
		//todo list
		//1. Insert header purchase return
		//2. Insert detail purchase return

		//1. Insert header purchase return
		//Generate CekInt
		$data['header']['trpt_cekint'] = rand(0,10000);			
		$this->db->insert('tr_purcret',$data['header']);

		//2. Insert detail purchase return
		if(isset($data['detail'])){
			foreach ($data['detail'] as $key => $detail) {					
				$this->db->insert('dt_purcret',$data['detail'][$key]);
			}		
		}
	}

	private function update_data($data){		
		$this->db->where('trpt_no', $data['header']['trpt_no']);
		$this->db->update('tr_purcret', $data['header']);
		
		$this->db->where(array('dtpt_no' => $data['header']['trpt_no']));
		$this->db->delete('dt_purcret');

		if(isset($data['detail'])){
			foreach ($data['detail'] as $key => $value) {							
				$this->db->insert('dt_purcret', $data['detail'][$key]);
			}						
		}
	}

	private function update_qtyretur($trpt_no){
		$query = "UPDATE dt_po SET dtpo_qtyretur ="
					."IFNULL(("
					." SELECT SUM(A.dtpt_qtyretur) FROM dt_purcret A"
					." LEFT JOIN tr_purcret B ON B.trpt_no = A.dtpt_no"
					." WHERE SUBSTRING(A.dtpt_no,1,12) = dt_po.dtpo_no"
					." AND A.dtpt_seq = dt_po.dtpo_seq"
					." AND B.trpt_void = 0"
					." AND B.trpt_tglkeluar <> '0000-00-00'"
					."),0)"
				." WHERE dt_po.dtpo_no = '".substr($trpt_no, 0, 12)."'";
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}		
	}

	private function save_update_hpp($trpt_no, $i, $trhpp_refjenis){
		$trhpp_tgl = date('Y-m-d H:i:s');

		$query = "INSERT INTO tr_his_hpp(trhpp_tgl, trhpp_refjenis, trhpp_refno, trhpp_mspd_no, trhpp_qtyawal, trhpp_hppawal, trhpp_qtytrans, trhpp_totaltrans)
							(SELECT '".$trhpp_tgl."',
									'".$trhpp_refjenis."',
									'".$trpt_no."',
									D.dtpt_mspd_no, 
									(SELECT SUM(S.msst_qty) FROM ms_stok S WHERE S.msst_mspd_no = D.dtpt_mspd_no),
									 P.mspd_hpp,
									 SUM(".$i." * D.dtpt_qtyretur),
									ROUND(SUM((".$i." * D.dtpt_qtyretur) * D.dtpt_hpp), 4)
							FROM dt_purcret D 
							LEFT JOIN ms_produk P 
							ON P.mspd_no = D.dtpt_mspd_no 
							LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtpt_mspd_no,1,1)
							WHERE D.dtpt_no = '".$trpt_no."'
							AND D.dtpt_qtyretur > 0
							AND KT.mskt_statusinv = 'Y'
							GROUP BY D.dtpt_mspd_no, D.dtpt_hpp)";

		$this->db->simple_query($query);

		$query = "UPDATE tr_his_hpp 
					SET trhpp_totalawal = ROUND((trhpp_qtyawal * trhpp_hppawal), 4),
						trhpp_hppakhir = IF(
							(trhpp_qtyawal + (trhpp_qtytrans)) <> 0,
							ROUND(
								((trhpp_qtyawal * trhpp_hppawal) + (trhpp_totaltrans))
								 /
								 (trhpp_qtyawal + (trhpp_qtytrans)), 4), trhpp_hppawal)
					WHERE trhpp_tgl = '".$trhpp_tgl."'
					AND trhpp_refjenis = '".$trhpp_refjenis."'
					AND trhpp_refno = '".$trpt_no."'";

		$this->db->simple_query($query);

		$query = "UPDATE ms_produk P 
							SET P.mspd_hpp = IFNULL((SELECT trhpp_hppakhir FROM tr_his_hpp 
										WHERE trhpp_tgl = '".$trhpp_tgl."'
										AND trhpp_refjenis = '".$trhpp_refjenis."'
										AND trhpp_refno = '".$trpt_no."'
										AND trhpp_mspd_no = P.mspd_no), P.mspd_hpp)
				WHERE P.mspd_no IN
				(SELECT dtpt_mspd_no FROM dt_purcret D
				LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtpt_mspd_no,1,1)
				WHERE D.dtpt_no = '".$trpt_no."'
				AND D.dtpt_qtyretur > 0
				AND KT.mskt_statusinv = 'Y')";

		$this->db->simple_query($query);
	}

	private function update_hpp($trpt_no, $i){		
		$query = "UPDATE ms_produk SET mspd_hpp =ROUND("
									."((mspd_hpp * (SELECT SUM(A.msst_qty) FROM ms_stok A WHERE A.msst_mspd_no = ms_produk.mspd_no))"
									." +"
									." (SELECT (".$i." * SUM(B.dtpt_qtyretur * B.dtpt_hpp)) FROM dt_purcret B"
										." WHERE B.dtpt_no = '".$trpt_no."'"
										." AND B.dtpt_mspd_no = ms_produk.mspd_no))"
									." /"
									." ((SELECT SUM(C.msst_qty) FROM ms_stok C WHERE C.msst_mspd_no = ms_produk.mspd_no)"
									 ." +"
									 ." (SELECT (".$i." * SUM(D.dtpt_qtyretur)) FROM dt_purcret D"
										." WHERE D.dtpt_no = '".$trpt_no."'"
										." AND D.dtpt_mspd_no= ms_produk.mspd_no)), 4)"
									 
									." WHERE ms_produk.mspd_no IN"
										." (SELECT E.dtpt_mspd_no FROM dt_purcret E"
										." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(E.dtpt_mspd_no,1,1)"
										." WHERE E.dtpt_no = '".$trpt_no."'"
										." AND KT.mskt_statusinv = 'Y')"
									
									." AND ((SELECT SUM(F.msst_qty) FROM ms_stok F WHERE F.msst_mspd_no = ms_produk.mspd_no)"
										." +"
										." (SELECT (".$i." * SUM(G.dtpt_qtyretur)) FROM dt_purcret G"
										." WHERE G.dtpt_no = '".$trpt_no."'"
										." AND G.dtpt_mspd_no= ms_produk.mspd_no)) <> 0";

		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}		
		
	}

	private function update_stok($trpt_no, $i){
		$query = "INSERT INTO ms_stok(msst_mspd_no, msst_msgd_no, msst_qty)"
						." (SELECT DISTINCT A.dtpt_mspd_no, B.trpt_msgd_no, 0 FROM dt_purcret A"
						." LEFT JOIN tr_purcret B ON B.trpt_no = A.dtpt_no"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(A.dtpt_mspd_no, 1,1)"
						." WHERE A.dtpt_no = '".$trpt_no."'"
						." AND KT.mskt_statusinv = 'Y'"
						." AND NOT EXISTS(SELECT C.* FROM ms_stok C"
								." WHERE C.msst_mspd_no = A.dtpt_mspd_no"
								." AND C.msst_msgd_no= B.trpt_msgd_no))";

		$this->db->simple_query($query);		

		$query = "UPDATE ms_stok SET msst_qty = msst_qty +"
						." (".$i." * (SELECT SUM(A.dtpt_qtyretur) FROM dt_purcret A"
						." WHERE A.dtpt_no = '".$trpt_no."'"
						." AND A.dtpt_mspd_no = ms_stok.msst_mspd_no))"
				." WHERE ms_stok.msst_mspd_no IN"
						." (SELECT B.dtpt_mspd_no FROM dt_purcret B"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(B.dtpt_mspd_no,1,1)"
						." WHERE B.dtpt_no = '".$trpt_no."'"
						." AND KT.mskt_statusinv = 'Y'"
						." AND B.dtpt_qtyretur <> 0)"
				." AND ms_stok.msst_msgd_no ="
						." (SELECT C.trpt_msgd_no FROM tr_purcret C"
						." WHERE C.trpt_no = '".$trpt_no."')";		
			
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}					
	}		

	private function void_data($data){
		//Set dtpo_qtyretur = 0 di tabel dt_po
		$this->db->where(array('dtpo_no' => substr($data['header']['trpt_no'], 0, 12)));
		$this->db->update('dt_po', array('dtpo_qtyretur' => 0));
		//void purchase return
		$this->db->where('trpt_no', $data['header']['trpt_no']);
		$this->db->update('tr_purcret', array('trpt_void'=>1));					
	}

	private function jurnal_simpan($data){
		// Generate CekInt
		$data['jurnal_h']['trju_cekint'] = rand(0,10000);			
		// Insert data header jurnal
		$this->db->insert('tr_jurnal',$data['jurnal_h']);
		
		//Insert data detail jurnal
		if(isset($data['jurnal_d'])){
			$seq = 1;
			foreach ($data['jurnal_d'] as $key => $detail) {														
				$data['jurnal_d'][$key]['dtju_no'] = $data['jurnal_h']['trju_no'];
				$data['jurnal_d'][$key]['dtju_seq'] = $seq;
				$this->db->insert('dt_jurnal',$data['jurnal_d'][$key]);
				$seq += 1;
			}		
		}		
	}

	private function jurnal_hapus($data){		
		if(isset($data['jurnal_h']['trju_no']) && strlen($data['jurnal_h']['trju_no']) > 0){
			$this->db->delete('tr_jurnal', array('trju_no' => $data['jurnal_h']['trju_no']));
			$this->db->delete('dt_jurnal', array('dtju_no' => $data['jurnal_h']['trju_no']));
		}
	}

}	