<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_sales_inquery extends MY_Model {

	function __construct(){
		parent::__construct();		
		$this->load->model('setting/m_user_log');		
	}

	public function get_sales_inquery_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trsi_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('tr_sales_inquery.*, mscb_nm, mscs_nm, mssl_nm');
		$this->db->from('tr_sales_inquery');		
		$this->db->join('ms_cabang','mscb_no = trsi_mscb_no', 'left');
		$this->db->join('ms_customer', 'ms_customer.mscs_no = tr_sales_inquery.trsi_mscs_no','left');
		$this->db->join('ms_sales', 'ms_sales.mssl_no = tr_sales_inquery.trsi_mssl_no','left');

		$query_string = '';

		if(isset($arr_filter['mspd_no'])){			
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x1.* FROM dt_sales_inquery x1 WHERE x1.dtsi_no = trsi_no AND x1.dtsi_mspd_no LIKE "%'. $arr_filter['mspd_no']. '%")';							
			unset($arr_filter['mspd_no']);
		}

		if(isset($arr_filter['mspd_nm'])){
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x2.*, a.mspd_nm AS mspd_nm FROM dt_sales_inquery x2 LEFT JOIN ms_produk AS a ON a.mspd_no = x2.dtsi_mspd_no WHERE x2.dtsi_no = trsi_no AND a.mspd_nm LIKE "%'. $arr_filter['mspd_nm']. '%")';
			unset($arr_filter['mspd_nm']);
		}		

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}

		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}	

	public function get_sales_inquery($trsi_no){		
		$data = array();
		
		//Get sales inquery header berdasarkan trsi_no	
		$this->db->select('*, IFNULL((SELECT mscsda_kirim_jln FROM ms_cust_dlvyadd WHERE mscsda_no = mscs_no LIMIT 1), "") AS mscsda_kirim_jln,
								IFNULL((SELECT mscsda_kirim_kota FROM ms_cust_dlvyadd WHERE mscsda_no = mscs_no LIMIT 1), "") AS mscsda_kirim_kota,
								IFNULL((SELECT mscsda_kirim_provinsi FROM ms_cust_dlvyadd WHERE mscsda_no = mscs_no LIMIT 1), "") AS mscsda_kirim_provinsi');
		$this->db->from('tr_sales_inquery');
		$this->db->join('ms_customer', 'mscs_no = trsi_mscs_no','inner');
		$this->db->join('ms_cabang', 'mscb_no = trsi_mscb_no','inner');		
		$this->db->join('ms_user', 'msus_no = trsi_msus_no','inner');		
		$this->db->where('trsi_no',$trsi_no);
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$result = $query->result_array();	
			$data['header'] = $result[0];
		}
		
		//Get sales inquery detail berdasarkan trsi_no	
		$this->db->select('*');
		$this->db->from('dt_sales_inquery');
		$this->db->join('ms_produk', 'ms_produk.mspd_no = dt_sales_inquery.dtsi_mspd_no','left');		
		$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(ms_produk.mspd_no,1,1)','left');
		$this->db->join('md_paket_prod', 'md_paket_prod.mdpp_no = dt_sales_inquery.dtsi_mdpp_no AND md_paket_prod.mdpp_mspd_no = dt_sales_inquery.dtsi_mspd_no','left');
		$this->db->where('dt_sales_inquery.dtsi_no',$trsi_no);
		$this->db->order_by('dtsi_seq', 'ASC');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail'] = $detail;
		}
		if(count($data) > 0){
			return $data;
		}else{
			return false;
		}
	}	

	public function sales_inquery_kode_auto($trsi_kode_depan){
		$this->db->select_max("trsi_no");
		$this->db->like("trsi_no", $trsi_kode_depan, "after");
		$query = $this->db->get("tr_sales_inquery");
		if ($query->num_rows() == 0){
			return $trsi_kode_depan. "0001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['trsi_no'];
			$nomor = ((int) substr($kode, 8)) + 1;
			return $trsi_kode_depan. sprintf("%'.04d", $nomor);
		}
	}

	public function get_sales_inquery_cekint($trsi_no, $trsi_cekint){		
		$query = $this->db->get_where('tr_sales_inquery', array('trsi_no' => $trsi_no, 'trsi_cekint' => $trsi_cekint));		
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}	

	public function set_sales_inquery_cekint($trsi_no){
		$this->db->where(array('trsi_no' => $trsi_no));
		$this->db->update('tr_sales_inquery', array('trsi_cekint' => rand(0, 10000)));
	}

	public function sales_inquery_simpan($data){
		try {													
				if($data['action'] == 'NEW'){
					// Insert data
					$this->insert_data($data);
				}
				
				if($data['action'] == 'EDIT'){
					// Update data
					$this->update_data($data);					
				}

				if($data['action'] == 'VOID'){
					// Void data
					$this->void_data($data);					
				}

				// Simpan userlog
				$this->user_log_simpan($data);

				if($data['action'] == 'STCOPY'){
					$this->db->where('trsi_no', $data['header']['trsi_no']);
					$this->db->update('tr_sales_inquery', array('trsi_stcopy'=>$data['header']['trsi_stcopy']));
				}
			return 1;
		} catch (Exception $e) {
			return 0;
		}		
	}

	private function user_log_simpan($data){		
		//Insert user log
		if(isset($data['userlog'])){			
			foreach ($data['userlog'] as $key => $value) {				
				$this->db->insert('ms_userlog',$data['userlog'][$key]);
			}
		}
	}

	private function insert_data($data){
		//Insert data header sales inquery
		$this->db->insert('tr_sales_inquery',$data['header']);
	
		//Insert data detail sales inquery
		if(isset($data['detail'])){
			for ($i=0; $i < count($data['detail']) ; $i++) {										
			    $this->db->insert('dt_sales_inquery',$data['detail'][$i]);											
			}			
		}
	}

	private function update_data($data){						
		try {	
				//Update data header sales inquery
				$this->db->where('trsi_no', $data['header']['trsi_no']);
				$this->db->update('tr_sales_inquery', $data['header']);		

				//Delete data detail sales inquery
				$this->db->delete('dt_sales_inquery', array('dtsi_no' => $data['header']['trsi_no']));								
				
				//Insert data detail sales inquery
				if(isset($data['detail'])){
					for ($i=0; $i < count($data['detail']) ; $i++) {									
					    $this->db->insert('dt_sales_inquery',$data['detail'][$i]);													
					}
				}
			return 1;			
		} catch (Exception $e) {
			return 0;
		}		
	}

	private function void_data($data){
		$this->db->where('trsi_no', $data['header']['trsi_no']);
		$this->db->update('tr_sales_inquery', array('trsi_void'=>1));
	}
	
}
