<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_sales_order extends MY_Model {

	function __construct(){
		parent::__construct();		
		$this->load->model('setting/m_user_log');		
	}

	public function get_sales_order_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trso_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('tr_so.*, mscb_nm, mscs_nm, mssl_nm');
		$this->db->from('tr_so');		
		$this->db->join('ms_cabang','mscb_no = trso_mscb_no', 'left');
		$this->db->join('ms_customer', 'ms_customer.mscs_no = tr_so.trso_mscs_no','left');
		$this->db->join('ms_sales', 'ms_sales.mssl_no = tr_so.trso_mssl_no','left');					
		
		$query_string = '';

		//Payment status
		//1. SETTLED
		//2. UNSETTLED

		if(isset($arr_filter['payment_status'])){
			if($arr_filter['payment_status'] == '1'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'trso_terbayar >= trso_total';
			}elseif($arr_filter['payment_status'] == '2'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'trso_terbayar < trso_total';
			}		
			unset($arr_filter['payment_status']);	
		}	

		//Sales Delivery status
		//1. COMPLETE
		//2. INCOMPLETE
		//3. NO DELIVERY AT ALL
		//4. PARTIAL DELIVERY
		
		if(isset($arr_filter['delivery_status'])){
			if($arr_filter['delivery_status'] == '1'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= '(((SELECT SUM(a.dtso_qty - a.dtso_qtysd) FROM dt_so a WHERE a.dtso_no = trso_no AND trso_lock = "N") <= 0) OR (trso_lock = "Y"))';
			}elseif($arr_filter['delivery_status'] == '2'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= '(SELECT SUM(a.dtso_qty - a.dtso_qtysd) FROM dt_so a WHERE a.dtso_no = trso_no AND trso_lock = "N") > 0';
			}elseif($arr_filter['delivery_status'] == '3'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= '(SELECT SUM(a.dtso_qtysd) FROM dt_so a WHERE a.dtso_no = trso_no AND trso_lock = "N") <= 0';
			}elseif($arr_filter['delivery_status'] == '4'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= '((SELECT SUM(a.dtso_qtysd) FROM dt_so a WHERE a.dtso_no = trso_no AND trso_lock = "N") > 0 AND (SELECT SUM(a.dtso_qty - a.dtso_qtysd) FROM dt_so a WHERE a.dtso_no = trso_no AND trso_lock = "N") > 0)';
			}
			unset($arr_filter['delivery_status']);
		}					

		// Menjelang closing SO				
		if(isset($arr_filter['closing_status'])){						
			if($arr_filter['closing_status'] == '1'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= ' EXISTS(SELECT DISTINCT dtso_no FROM dt_so WHERE dtso_no = trso_no AND (dtso_qty > dtso_qtysd) AND (DATEDIFF(trso_tglbataslock, "'.date('Y-m-d').'") < 3) AND (DATEDIFF(trso_tglbataslock, "'.date('Y-m-d').'") >= 0))';			
			}
			unset($arr_filter['closing_status']);
		}

		//SO status
		//1. SO-DEKAT
		//2. SO-JAUH
		
		// if(isset($arr_filter['so_status'])){
		// 	if($arr_filter['so_status'] == '1'){
		// 		if($query_string != ''){
		// 			$query_string .= ' AND ';
		// 		}
		// 		$query_string .= 'DATEDIFF("'. date('Y-m-d') .'", trso_tglestkirim) < 120';
		// 	}elseif($arr_filter['so_status'] == '2'){
		// 		if($query_string != ''){
		// 			$query_string .= ' AND ';
		// 		}
		// 		$query_string .= 'NOT(DATEDIFF("'. date('Y-m-d') .'", trso_tglestkirim) < 120)';
		// 	}
		// 	unset($arr_filter['so_status']);
		// }						

		if(isset($arr_filter['mspd_no'])){			
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x1.* FROM dt_so x1 WHERE x1.dtso_no = trso_no AND x1.dtso_mspd_no LIKE "%'. $arr_filter['mspd_no']. '%")';							
			unset($arr_filter['mspd_no']);
		}

		if(isset($arr_filter['mspd_nm'])){
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x2.*, a.mspd_nm AS mspd_nm FROM dt_so x2 LEFT JOIN ms_produk AS a ON a.mspd_no = x2.dtso_mspd_no WHERE x2.dtso_no = trso_no AND a.mspd_nm LIKE "%'. $arr_filter['mspd_nm']. '%")';
			unset($arr_filter['mspd_nm']);
		}

		if(isset($arr_filter['mskt_no'])){
			if($arr_filter['mskt_no'] != 'all'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'EXISTS(SELECT x3.*, mskt_no FROM dt_so x3 LEFT JOIN ms_produk AS b ON b.mspd_no = x3.dtso_mspd_no LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(b.mspd_no, 1, 1) WHERE x3.dtso_no = trso_no AND mskt_no ="'. $arr_filter['mskt_no']. '")';
			}	
			unset($arr_filter['mskt_no']);
		}

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}

		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}

		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_sales_order_toplist($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'tpso_tgljatuhtempo', $sort = 'DESC'){
		if(!$is_count){
			$this->db->limit($per_page, $offset);		
		}
		$this->db->select('*');
		$this->db->from('top_so');		
		$this->db->join('tr_so','trso_no = tpso_no', 'left');
		$this->db->join('ms_customer', 'ms_customer.mscs_no = tr_so.trso_mscs_no','left');				

		//TOP Status
		//1. Current Date
		//2. Late Date

		if(isset($arr_filter['topdate_status'])){					
			if($arr_filter['topdate_status'] == 1){
				// $this->db->where(array('tpso_tgljatuhtempo' => date('Y-m-d'), 'trso_void'=>0));
				$query_string = ' (DATEDIFF(tpso_tgljatuhtempo, "'.date('Y-m-d').'") <= 3) AND (DATEDIFF(tpso_tgljatuhtempo, "'.date('Y-m-d').'") >= 0) AND (tpso_aktif ="Y") ';
				$this->db->where($query_string, null, false);
			}

			if($arr_filter['topdate_status'] == 2){				
				//$query = 'DATEDIFF(tpso_tgljatuhtempo,"'. date('Y-m-d') .'") < 0 AND trso_terbayar < trso_total';
				$query = ' (tpso_tgljatuhtempo < CURDATE()) AND (trso_terbayar < trso_total) AND (tpso_aktif ="Y") ';
				$this->db->where($query, null, false);
			}
			unset($arr_filter['topdate_status']);
		}

		$this->db->where(array('trso_void'=>0));

		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);
		}

		$this->db->order_by($fn, $sort);
		$query = $this->db->get();
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_sales_order($trso_no){		
		$data = array();
		
		//Get sales order header berdasarkan trso_no			
		$this->db->select("tr_so.*, mscs_no,mscs_nm, mscs_almt_jln, mscs_almt_kota, mscs_almt_provinsi, mscs_jenis, mscs_catatan, mscs_cp,
							mscb_no, mscb_nm, mssl_no, mssl_nm, msus_no, msus_nm, msus_mscb_no,							
							IFNULL((SELECT SUM(dtso_qty) FROM dt_so LEFT JOIN tr_so ON tr_so.trso_no=dt_so.dtso_no WHERE dtso_no = '". $trso_no ."'),0) AS trso_totalqty,
							IFNULL((SELECT SUM(dtso_qtysd) FROM dt_so LEFT JOIN tr_so ON tr_so.trso_no=dt_so.dtso_no WHERE dtso_no = '". $trso_no ."' AND trso_void = 0),0) AS trso_totalqtysd,
							IFNULL((SELECT SUM(dtsd_qtykrm) FROM dt_sales_dlv LEFT JOIN tr_sales_dlv ON tr_sales_dlv.trsd_no=dt_sales_dlv.dtsd_no WHERE SUBSTRING(dtsd_no, 1,12) = '". $trso_no ."' AND trsd_void = 0),0) AS trsd_totalqtykirim,
							EXISTS(SELECT trsd_no FROM tr_sales_dlv WHERE SUBSTRING(trsd_no, 1, 12) = '".$trso_no."' AND trsd_void = 0) AS is_sdcreated,							
							EXISTS(SELECT pbso_no FROM pby_so WHERE SUBSTRING(pbso_no, 1, 12) = '".$trso_no."' AND pbso_void = 0) AS is_spcreated");
		$this->db->from('tr_so');
		$this->db->join('ms_customer', 'tr_so.trso_mscs_no = ms_customer.mscs_no','inner');
		$this->db->join('ms_cabang', 'tr_so.trso_mscb_no = ms_cabang.mscb_no','inner');		
		$this->db->join('ms_sales', 'tr_so.trso_mssl_no = ms_sales.mssl_no','inner');		
		$this->db->join('ms_user', 'tr_so.trso_msus_no = ms_user.msus_no','inner');		
		$this->db->where('tr_so.trso_no',$trso_no);
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$result = $query->result_array();	
			$data['header'] = $result[0];
		}

		//Get top so berdasarkan trso_no	
		$query = $this->db->get_where('top_so', array('tpso_no' => $trso_no));
		if($query->num_rows() > 0){
			$data['top_so'] = $query->result_array();
		}

		//IFNULL((SELECT SUM(dtsd_qtykrm - dtsd_qtyrej) FROM dt_sales_dlv LEFT JOIN tr_sales_dlv ON tr_sales_dlv.trsd_no=dt_sales_dlv.dtsd_no WHERE SUBSTRING(dtsd_no,1,12) = dtso_no AND dtsd_seq = dtso_seq AND dtsd_no <> '' AND trsd_void = 0),0) AS calc_qty_sd
		//IFNULL((SELECT SUM(dtsr_qtyretur) FROM dt_salesret LEFT JOIN tr_salesret ON tr_salesret.trsr_no=dt_salesret.dtsr_no WHERE SUBSTRING(dtsr_no,1,12) = dtso_no AND dtsr_seq = dtso_seq AND dtsr_no <> '' AND trsr_void = 0),0) AS calc_qty_retur

		// tidak dipakai
		// IFNULL((SELECT SUM(dtsd_qtykrm - dtsd_qtyrej) FROM dt_sales_dlv LEFT JOIN tr_sales_dlv ON tr_sales_dlv.trsd_no=dt_sales_dlv.dtsd_no WHERE SUBSTRING(dtsd_no,1,12) = dtso_no AND dtsd_seq = dtso_seq AND dtsd_no <> '' AND trsd_void = 0),0) AS calc_qty_sd,
		// IFNULL((SELECT SUM(dtsr_qtyretur) FROM dt_salesret LEFT JOIN tr_salesret ON tr_salesret.trsr_no=dt_salesret.dtsr_no WHERE SUBSTRING(dtsr_no,1,12) = dtso_no AND dtsr_seq = dtso_seq AND dtsr_no <> '' AND trsr_void = 0),0) AS calc_qty_retur
		
		//Get sales order detail berdasarkan trso_no			
		$this->db->select("dt_so.*,
							mspd_no, mspd_nm, mspd_reqserialno,
							mskt_discnonagen1, mskt_discnonagen2, mskt_discnonagen3, mskt_discagen1, mskt_discagen2, mskt_discagen3, mskt_statusinv,
							mdpp_no, mdpp_qty");
		$this->db->from('dt_so');
		$this->db->join('ms_produk', 'dt_so.dtso_mspd_no = ms_produk.mspd_no','inner');		
		$this->db->join('ms_kategori', 'ms_kategori.mskt_no = SUBSTRING(ms_produk.mspd_no,1,1)','left');
		$this->db->join('md_paket_prod', 'md_paket_prod.mdpp_no = dt_so.dtso_mdpp_no AND md_paket_prod.mdpp_mspd_no = dt_so.dtso_mspd_no','left');
		$this->db->where('dt_so.dtso_no',$trso_no);
		$this->db->order_by('dtso_seq', 'ASC');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail'] = $detail;
		}
		
		return $data;		
	}		

	public function sales_order_kode_auto($trso_kode_depan){
		$this->db->select_max("trso_no");
		$this->db->like("trso_no", $trso_kode_depan, "after");
		$query = $this->db->get("tr_so");
		if ($query->num_rows() == 0){
			return $trso_kode_depan. "0001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['trso_no'];
			$nomor = ((int) substr($kode, 8)) + 1;
			return $trso_kode_depan. sprintf("%'.04d", $nomor);
		}
	}

	public function get_sales_order_cekint($trso_no, $trso_cekint){		
		$query = $this->db->get_where('tr_so', array('trso_no' => $trso_no, 'trso_cekint' => $trso_cekint));	
		
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function set_sales_order_cekint($trso_no){
		$this->db->where(array('trso_no' => $trso_no));
		$this->db->update('tr_so', array('trso_cekint' => rand(0, 10000)));
	}

	public function cek_trso_no_exists($trso_no){		
		$query = $this->db->get_where('tr_so', array('trso_no' => $trso_no));	
		
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function sales_order_simpan($data){
		try {					
				if($data['action'] == 'NEW'){
					// Insert data
					$this->insert_data($data);
				}
				
				if($data['action'] == 'EDIT'){
					// Update data
					$this->update_data($data);					
				}

				if($data['action'] == 'VOID'){
					// Void data
					$this->void_data($data);					
				}	

				// Simpan userlog
				$this->user_log_simpan($data);

				if($data['action'] == 'STCOPY'){
					$this->db->where('trso_no', $data['header']['trso_no']);
					$this->db->update('tr_so', array('trso_stcopy'=>$data['header']['trso_stcopy']));
				}				
			return 1;
		} catch (Exception $e) {
			return 0;
		}		
	}

	private function user_log_simpan($data){		
		//Insert user log
		if(isset($data['userlog'])){			
			foreach ($data['userlog'] as $key => $value) {				
				$this->db->insert('ms_userlog',$data['userlog'][$key]);
			}
		}
	}	

	private function insert_data($data){		
		//Insert data header sales order
		$this->db->insert('tr_so',$data['header']);

		//Insert data detail sales order
		if(isset($data['detail'])){
			for ($i=0; $i < count($data['detail']) ; $i++) {										
			    $this->db->insert('dt_so',$data['detail'][$i]);											
			}			
		}
	
		//Insert data top so
		if(isset($data['top_so'])){
			for ($i=0; $i < count($data['top_so']) ; $i++) {										
			    $this->db->insert('top_so',$data['top_so'][$i]);											
			}			
		}
	}

	private function update_data($data){						
		try {	
				//Update data header sales order
				$this->db->where('trso_no', $data['header']['trso_no']);
				$this->db->update('tr_so', $data['header']);
				
				//Delete data detail sales inquery
				$this->db->delete('dt_so', array('dtso_no' => $data['header']['trso_no']));
				
				//Insert data baru ke tabel dt_so
				if(isset($data['detail'])){
					for ($i=0; $i < count($data['detail']) ; $i++) {									
					    $this->db->insert('dt_so',$data['detail'][$i]);													
					}
				}

				//Delete data detail top so
				$this->db->delete('top_so', array('tpso_no' => $data['header']['trso_no']));								

				//Insert data top so
				if(isset($data['top_so'])){
					for ($i=0; $i < count($data['top_so']) ; $i++) {										
					    $this->db->insert('top_so',$data['top_so'][$i]);											
					}			
				}											
			return 1;			
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function top_so_simpan($data){		
		try{
			//Delete data top SO
			$this->db->where(array('tpso_no' => $data['header']['trso_no']));
			$this->db->delete('top_so');

			//Insert data top PO
			if(isset($data['top_so'])){			
				foreach ($data['top_so'] as $key => $value) {
					$data['top_so'][$key]['tpso_no'] = $data['header']['trso_no'];
					$this->db->insert('top_so',$data['top_so'][$key]);
				}
			}
			return 1;
		}catch (Exception $e) {
			return 0;
		}
	}

	private function void_data($data){
		$this->db->where('trso_no', $data['header']['trso_no']);
		$this->db->update('tr_so', array('trso_void'=>1));
	}

	// public function get_trsd_total($trso_no){
	// 	$sql = 'SELECT IFNULL(SUM(trsd_total), 0) AS trsd_total FROM tr_sales_dlv WHERE SUBSTRING(trsd_no, 1,12) = "'. $trso_no .'" AND trsd_void = 0';
	// 	$query = $this->db->query($sql);		

	// 	if($query->num_rows() > 0){
	// 		$result = $query->result_array();
	// 		return $result[0]['trsd_total'];
	// 	}
	// }

	public function sales_order_edit_catatan($data){
		try {																
				$this->db->where('trso_no', $data['header']['trso_no']);
				$this->db->update('tr_so', array('trso_catatan' => $data['header']['trso_catatan']));				
				return 1;				
		} catch (Exception $e) {
			return 0;
		}		
	}

	// public function sales_order_lockso($data){
	// 	try {												
	// 			$trsd_total = $this->get_trsd_total($data['header']['trso_no']);

	// 			$this->db->where('trso_no', $data['header']['trso_no']);
	// 			$this->db->update('tr_so', array('trso_lock' => 'Y', 'trso_total' => $trsd_total));
	// 			$this->update_stcopy('LOCKSO', $data['header']['trso_no']);
	// 			return 1;				
	// 	} catch (Exception $e) {
	// 		return 0;
	// 	}		
	// }	

	public function sales_order_cancellockso($data){
		try {																
				$this->db->where('trso_no', $data['header']['trso_no']);				
				$this->db->update('tr_so', array('trso_lock' => 'N', 'trso_total' => $data['header']['trso_total']));				
				$this->update_stcopy('CANCEL_LOCKSO', $data['header']['trso_no']);
				return 1;				
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function update_stcopy($action,$trso_no){
		$query = $this->db->query('SELECT trso_stcopy FROM tr_so WHERE trso_no ="'. $trso_no.'" AND (trso_stcopy = "A" OR trso_stcopy = "F")');
	
		if($query->num_rows() <= 0){							
			$proses = false;
			if($action == 'CONFDELIVERY' || $action == 'LOCKSO'){			
				$query = $this->db->query('SELECT trso_lock FROM tr_so WHERE trso_no ="'. $trso_no.'" AND trso_lock = "Y"');	
				$status = 'R';
				if($query->num_rows() > 0){
					$query = $this->db->query('SELECT dtso_qty FROM dt_so WHERE SUBSTRING(dtso_no, 1, 12) ="'. $trso_no. '" HAVING SUM(dtso_qtykirim) >= SUM(dtso_qtysd)');
					if($query->num_rows() > 0){
						$proses = true;
					}		
				}else{
					$query = $this->db->query('SELECT dtso_qty FROM dt_so WHERE SUBSTRING(dtso_no, 1, 12) ="'. $trso_no. '" HAVING SUM(dtso_qtykirim) >= SUM(dtso_qty)');
					if($query->num_rows() > 0){
						$proses = true;												
					}
				}
			}elseif ($action == 'CANCEL_CONFDELIVERY' || $action == 'CANCEL_LOCKSO') {
				$proses = true;
				$status = 'W';
			}

			if($proses){				
				$this->db->where('trso_no', $trso_no);
				$this->db->update('tr_so', array('trso_stcopy'=>$status));						
			}
		}		
	}

	public function get_trso_total_currmonth($trso_klas, $trso_no = ''){
		$query = $this->db->query('SELECT IFNULL(SUM(trso_total), 0) AS trso_total FROM tr_so WHERE trso_no !="'. $trso_no.'" AND trso_klas = "'.$trso_klas.'" AND MONTH(trso_tgl) = MONTH(CURRENT_DATE) AND trso_void = 0');
		$result = $query->result_array();
		return $result[0]['trso_total'];
	}
	
	public function sales_order_lockso($date = null, $trso_no = null){
		$query = "UPDATE tr_so SET trso_lock = 'Y', trso_total = IFNULL((
									SELECT SUM(A.trsd_total) 
									FROM tr_sales_dlv A															
									WHERE SUBSTRING(A.trsd_no,1,12) = tr_so.trso_no
									AND trsd_void = 0
									),0)";

		if($trso_no != null){
			$query .= " WHERE trso_no= '".$trso_no."'";
		}else{
			$query .= " WHERE trso_tglbataslock < '". $date. "'
						AND trso_lock = 'N'
						AND trso_void = 0";
		}				

		if($this->db->simple_query($query)){
			if($trso_no != null){
				$this->update_stcopy('LOCKSO', $trso_no);
			}
			return 1;
		}else{
			return 0;
		}
	}

	public function cek_trso_mscs_no_exists($trso_mscs_no){		
		$query = $this->db->get_where('ms_customer', array('mscs_no' => $trso_mscs_no));	
		
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function get_trso_tophari($trso_no){		
		$query = $this->db->get_where('tr_so', array('trso_no' => $trso_no));	
		
		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result[0]['trso_tophari'];
		}else{
			return 0;
		}
	}
}
