<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_auto_set_hpp extends MY_Model {

	function __construct(){
		parent::__construct();
		$this->load->model('stok_kontrol/m_mutasi');		
		$this->load->model('stok_kontrol/m_stok');		
		$this->load->model('finance_and_acc/m_jurnal');
		$this->load->model('data_master/m_kategori');
		$this->load->model('setting/m_setting_account');
		$this->load->model('stok_kontrol/m_goods_transformation');				
		$this->load->model('data_master/m_produk');	
		$this->load->model('data_master/m_gudang');	
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function proses_auto_set_hpp($data){	
		$err = false;
		$err_msg = '';
		$vok = true;

		/*
		------------------------------------------------------------------------------------
		| PROSES AUTO SET HPP
		------------------------------------------------------------------------------------
		*/

		// Insert data ke tr_auto_set_hpp		
		$this->db->insert('tr_auto_set_hpp',$data);

		$this->db->where('mspd_no', $data['trash_mspd_no']);
		$this->db->update('ms_produk', array('mspd_hpp' => $data['trash_hpp']));

		/* START SKIP >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
		>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
		>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

		// GLOBAL VARIABEL-------------------------------------------------------------------
		// kode depan mutasi				
		$bulan = substr($data['trash_tgl'], 5, 2);			
		$tahun = substr($data['trash_tgl'], 2, 2);				
		$trmt_kode_depan = $data['trash_mscb_no']."MT".$tahun.$bulan.'-';
		
		// kode depan jurnal
		$bulan = substr($data['trash_tgl'], 5, 2);			
		$tahun = substr($data['trash_tgl'], 2, 2);						
		$trju_kode_depan = "JA".$tahun.$bulan.'-';	
		$seq = 0;		

		// 1. PROSES MUTASI PRODUK KE GUDANG PENAMPUNG
		// ---------------------------------------------------------------------------------
		// Get data produk di ms_stok (all gudang)								
		$this->db->select('msst.*, msgd.msgd_listmscb, mspd.mspd_hpp, msgd.msgd_nm');				
		$this->db->join('ms_gudang as msgd','msgd.msgd_no = msst.msst_msgd_no', 'left');		
		$this->db->join('ms_produk as mspd','mspd.mspd_no = msst.msst_mspd_no', 'left');				
		$this->db->from('ms_stok msst');
		$this->db->where('msst_mspd_no', $data['trash_mspd_no']);
		$this->db->where('msst_msgd_no !=', $data['trash_msgd_no']);
		$this->db->where('msst_qty !=', 0);		
		$query = $this->db->get();						

		$data_msst = array();	

		if($query->num_rows() > 0){
			$data_msst = $query->result_array();
			foreach ($data_msst as $key => $value) {
				if($vok){
					// Set data header mutasi					
					$data_trmt['trmt_no'] 			= $this->m_mutasi->mutasi_kode_auto($trmt_kode_depan);
					$data_trmt['trmt_msgd_no1'] 	= $data_msst[$key]['msst_msgd_no'];
					$data_trmt['trmt_msgd_no2'] 	= $data['trash_msgd_no'];
					$data_trmt['trmt_mscb_no1'] 	= $data_msst[$key]['msgd_listmscb'];
					$data_trmt['trmt_mscb_no2'] 	= $data['trash_mscb_no']; 
					$data_trmt['trmt_tgl'] 			= $data['trash_tgl'];
					$data_trmt['trmt_msus_no'] 		= $data['trash_msus_no'];
					$data_trmt['trmt_catatan'] 		= 'AUTO SETTING HPP';
					$data_trmt['trmt_tag'] 			= '';
					$data_trmt['trmt_nprint'] 		= 0;
					$data_trmt['trmt_void'] 		= 0;
					$data_trmt['trmt_cekint'] 		= 1;
					$data_trmt['trmt_lsupd'] 		= date('Y-m-d H:i:s');
					$data_trmt['trmt_lsusr'] 		= $data['trash_msus_no'];
					$data_trmt['trmt_ekspedisi'] 	= '';
					$data_trmt['trmt_noekspedisi'] 	= '';
					$data_trmt['trmt_tglkirim'] 	= substr($data['trash_tgl'], 0, 10);
					$data_trmt['trmt_tglterima'] 	= substr($data['trash_tgl'], 0, 10);
					$data_trmt['trmt_mscb_no'] 		= $data['trash_mscb_no'];
					$data_trmt['trmt_fin'] 			= 'F';
					$data_trmt['trmt_stcopy'] 		= 'R';
					$data_trmt['trmt_lscopy'] 		= '';			

					// Insert data header mutasi
					if(!$this->db->insert('tr_mutasi',$data_trmt)){
						$vok = false;
						$err = true;
						$err_msg = 'Error create header mutasi';
					}	
				}			    

				if($vok){
					// Set data detail mutasi
					$data_dtmt['dtmt_no'] 		= $data_trmt['trmt_no'];
					$data_dtmt['dtmt_seq'] 		= 1;
					$data_dtmt['dtmt_mspd_no'] 	= $data['trash_mspd_no'];
					$data_dtmt['dtmt_qtyout'] 	= $data_msst[$key]['msst_qty'];
					$data_dtmt['dtmt_qtyin'] 	= $data_msst[$key]['msst_qty'];
					$data_dtmt['dtmt_stapv'] 	= 'Y';
					$data_dtmt['dtmt_hpp'] 		= $data['trash_hpp'];
					$data_dtmt['dtmt_catatan'] 	= '';

					// Insert data header mutasi
					if(!$this->db->insert('dt_mutasi',$data_dtmt)){
						$vok = false;
						$err = true;
						$err_msg = 'Error create detail mutasi';
					}
				}

				if($vok){					
					// Update stok (-)
					$this->m_mutasi->update_stok('DELIVERYNOW', $data_trmt['trmt_no'], -1);					
					// Update stok (+)
					$this->m_mutasi->update_stok('RECEIVE_GOODS', $data_trmt['trmt_no'], 1);	
				}

				// JURNAL MUTASI OUT-----------------------------------------------
				if($vok){					
					// Set data header jurnal					
					$trju_catatan = $data_trmt['trmt_no'].'/From '. $data_msst[$key]['msst_msgd_no']. ' - '. $data_msst[$key]['msgd_nm']. '/To '.$data['trash_msgd_no']. ' - '. $this->m_gudang->get_nama_gudang($data['trash_msgd_no']);
					$data_trju['trju_no'] 		= $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);
					$data_trju['trju_tgl'] 		= $data['trash_tgl'];
					$data_trju['trju_tipe'] 	= 'A';
					$data_trju['trju_catatan'] 	= trim(substr($trju_catatan, 0, 250));
					$data_trju['trju_refno'] 	= $data_trmt['trmt_no'].'MD';	
					$data_trju['trju_reftipe'] 	= 'MD';
					$data_trju['trju_void'] 	= 0;
					$data_trju['trju_lsupd'] 	= date('Y-m-d H:i:s');
					$data_trju['trju_lsusr'] 	= $data['trash_msus_no'];
					$data_trju['trju_cekint'] 	= 1;
					$data_trju['trju_msus_no'] 	= $data['trash_msus_no'];
					$data_trju['trju_mscb_no'] 	= $data['trash_mscb_no'];
					$data_trju['trju_fin'] 		= 'F';
					$data_trju['trju_stcopy'] 	= 'R';
					$data_trju['trju_lscopy'] 	= '';
					$data_trju['trju_tag'] 		= '';

					// Insert data header jurnal
					if(!$this->db->insert('tr_jurnal',$data_trju)){
						$vok = false;
						$err = true;
						$err_msg = 'Error create header jurnal (Mutasi Out)';
					}
				}

				$saldo = round($data_dtmt['dtmt_hpp'] * $data_msst[$key]['msst_qty'], 4);
				
				if($vok){
					// Set data detail jurnal					
					// Account WIP Mutasi (Debet)
					$acc = $this->m_setting_account->get_setting_account_byid('MWIP');				
					$data_dtju['dtju_no'] 		= $data_trju['trju_no'];
					$data_dtju['dtju_seq'] 		= 1;
					$data_dtju['dtju_msap_no'] 	= $acc['mssa_msap_no'];
					$data_dtju['dtju_debet'] 	= $saldo;
					$data_dtju['dtju_kredit'] 	= 0; 
					$data_dtju['dtju_catatan'] 	= ''; 
					$data_dtju['dtju_cek'] 		= '';

					// Insert data detail jurnal (Debet)
					if(!$this->db->insert('dt_jurnal',$data_dtju)){
						$vok = false;
						$err = true;
						$err_msg = 'Error create detail jurnal (Mutasi Out)';
					}
				}

				if($vok){
					// Account Inventory (Kredit)
					$mskt_no = substr($data['trash_mspd_no'], 0, 1);
					$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
					$data_dtju['dtju_no'] 		= $data_trju['trju_no'];
					$data_dtju['dtju_seq'] 		= 2;
					$data_dtju['dtju_msap_no'] 	= $acc;
					$data_dtju['dtju_debet'] 	= 0;
					$data_dtju['dtju_kredit'] 	= $saldo;
					$data_dtju['dtju_catatan'] 	= '';
					$data_dtju['dtju_cek'] 		= '';

					// insert data detail jurnal (Kredit)
					if(!$this->db->insert('dt_jurnal',$data_dtju)){
						$vok = false;
						$err = true;
						$err_msg = 'Error create detail jurnal (Mutasi Out)';
					}
				}				

				// JURNAL MUTASI IN-----------------------------------------------
				if($vok){					
					// Set data header jurnal					
					$trju_catatan = $data_trmt['trmt_no'].'/From '. $data_msst[$key]['msst_msgd_no']. ' - '. $data_msst[$key]['msgd_nm']. '/To '.$data['trash_msgd_no']. ' - '. $this->m_gudang->get_nama_gudang($data['trash_msgd_no']);
					$data_trju['trju_no'] 		= $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);
					$data_trju['trju_tgl'] 		= $data['trash_tgl'];
					$data_trju['trju_tipe'] 	= 'A';
					$data_trju['trju_catatan'] 	= trim(substr($trju_catatan, 0, 250));
					$data_trju['trju_refno'] 	= $data_trmt['trmt_no'].'MR';	
					$data_trju['trju_reftipe'] 	= 'MR';
					$data_trju['trju_void'] 	= 0;
					$data_trju['trju_lsupd'] 	= date('Y-m-d H:i:s');
					$data_trju['trju_lsusr'] 	= $data['trash_msus_no'];
					$data_trju['trju_cekint'] 	= 1;
					$data_trju['trju_msus_no'] 	= $data['trash_msus_no'];
					$data_trju['trju_mscb_no'] 	= $data['trash_mscb_no'];
					$data_trju['trju_fin'] 		= 'F';
					$data_trju['trju_stcopy'] 	= 'R';
					$data_trju['trju_lscopy'] 	= '';
					$data_trju['trju_tag'] 		= '';

					// Insert data header jurnal
					if(!$this->db->insert('tr_jurnal',$data_trju)){
						$vok = false;
						$err = true;
						$err_msg = 'Error create header jurnal (Mutasi In)';
					}
				}

				if($vok){
					// Account Inventory (Debet)
					$mskt_no = substr($data['trash_mspd_no'], 0, 1);
					$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
					$data_dtju['dtju_no'] 		= $data_trju['trju_no'];
					$data_dtju['dtju_seq'] 		= 1;
					$data_dtju['dtju_msap_no'] 	= $acc;
					$data_dtju['dtju_debet'] 	= $saldo;
					$data_dtju['dtju_kredit'] 	= 0;
					$data_dtju['dtju_catatan'] 	= '';
					$data_dtju['dtju_cek'] 		= '';

					// insert data detail jurnal (Debet)
					if(!$this->db->insert('dt_jurnal',$data_dtju)){
						$vok = false;
						$err = true;
						$err_msg = 'Error create detail jurnal (Mutasi In)';
					}
				}

				if($vok){
					// Set data detail jurnal					
					// Account WIP Mutasi (Kredit)
					$acc = $this->m_setting_account->get_setting_account_byid('MWIP');				
					$data_dtju['dtju_no'] 		= $data_trju['trju_no'];
					$data_dtju['dtju_seq'] 		= 2;
					$data_dtju['dtju_msap_no'] 	= $acc['mssa_msap_no'];
					$data_dtju['dtju_debet'] 	= 0;
					$data_dtju['dtju_kredit'] 	= $saldo; 
					$data_dtju['dtju_catatan'] 	= ''; 
					$data_dtju['dtju_cek'] 		= '';

					// Insert data detail jurnal (Kredit)
					if(!$this->db->insert('dt_jurnal',$data_dtju)){
						$vok = false;
						$err = true;
						$err_msg = 'Error create detail jurnal (Mutasi In)';
					}
				}

				if($vok){
					// Set data detail auto set hpp
					$seq += 1;
					$data_dtash['dtash_no'] 			= $data['trash_no'];
					$data_dtash['dtash_seq'] 			= $seq;
					$data_dtash['dtash_trans_jenis'] 	= '1MT';
					$data_dtash['dtash_trans_no'] 		= $data_trmt['trmt_no'];

					// Insert data detail auto set hpp
					if(!$this->db->insert('dt_auto_set_hpp',$data_dtash)){
						$vok = false;
						$err = true;
						$err_msg = 'Error create detail auto set hpp';
					}
				}				
			}	
		}

		// 2. PROSES JOB COSTING (UNTUK MERUBAH/MERESET HPP LAMA KE HPP BARU)
		// ---------------------------------------------------------------------------------

		// Get data produk di ms_stok (all gudang)								
		$this->db->select('msst.*');						
		$this->db->from('ms_stok msst');
		$this->db->where('msst_mspd_no', $data['trash_mspd_no']);				
		$this->db->where('msst_qty !=', 0);
		$query = $this->db->get();

		// Hanya yang ada stoknya yang akan diproses
		if($query->num_rows() > 0){
			$mspd_hpp = $this->m_produk->get_hpp($data['trash_mspd_no']);			
			$stok = $this->m_stok->get_stok($data['trash_mspd_no'], $data['trash_msgd_no']);					
			$hpp_total_result = round(($data['trash_hpp'] * $stok), 4);
			$hpp_total_from = round($mspd_hpp * $stok, 4);
			$dttsap_total =  $hpp_total_result - $hpp_total_from;

			if($vok){
				// Set data header job costing
				$trts_mscb_no = $data['trash_mscb_no'];
				$trts_tgl = $data['trash_tgl'];
				$bulan = substr($trts_tgl, 5, 2);			
				$tahun = substr($trts_tgl, 2, 2);								
				$trts_kode_depan = $trts_mscb_no."GT".$tahun.$bulan.$separator.'-';					
				$data_trts['trts_no'] 		= $this->m_goods_transformation->goods_transformation_kode_auto($trts_kode_depan);
				$data_trts['trts_tgl'] 		= $trts_tgl;
				$data_trts['trts_msgd_no'] 	= $data['trash_msgd_no'];
				$data_trts['trts_msus_no'] 	= $data['trash_msus_no'];
				$data_trts['trts_mscb_no'] 	= $trts_mscb_no;
				$data_trts['trts_catatan'] 	= 'AUTO SETTING HPP';
				$data_trts['trts_tag'] 		= '';
				$data_trts['trts_lsupd'] 	= date('Y-m-d H:i:s');
				$data_trts['trts_lsusr'] 	= $data['trash_msus_no'];
				$data_trts['trts_cekint'] 	= 1;
				$data_trts['trts_void'] 	= 0;
				$data_trts['trts_fin'] 		= 'F';
				$data_trts['trts_stcopy'] 	= 'R';
				$data_trts['trts_lscopy'] 	= '';

				// Insert data header job costing
				if(!$this->db->insert('tr_tfmgoods',$data_trts)){
					$vok = false;
					$err = true;
					$err_msg = 'Error create header Job Costing';
				}
			}

			if($vok){
				// Set data detail job costing (From)			
				$data_dtts['dtts_no'] 		= $data_trts['trts_no'];
				$data_dtts['dtts_seq'] 		= 1;
				$data_dtts['dtts_jenis'] 	= 'F';
				$data_dtts['dtts_mspd_no'] 	= $data['trash_mspd_no'];
				$data_dtts['dtts_qty'] 		= $stok;
				$data_dtts['dtts_hpp'] 		= $mspd_hpp;

				// Insert data detail job costing (From)
				if(!$this->db->insert('dt_tfmgoods',$data_dtts)){
					$vok = false;
					$err = true;
					$err_msg = 'Error create detail Job Costing (From)';
				}
			}

			if($vok){
				// Set data detail akun perkiraan job costing (From)			
				$data_dttsap['dttsap_no'] 		= $data_trts['trts_no'];
				$data_dttsap['dttsap_seq'] 		= 1;
				$data_dttsap['dttsap_jenis'] 	= 'F';
				$data_dttsap['dttsap_msap_no'] 	= $data['trash_msap_no'];
				$data_dttsap['dttsap_total'] 	= $dttsap_total;

				// Insert data detail akun perkiraan job costing (From)
				if(!$this->db->insert('dt_tfmgoods_accper',$data_dttsap)){
					$vok = false;
					$err = true;
					$err_msg = 'Error create detail akun perkiraan Job Costing (From)';
				}
			}

			if($vok){
				// Set data detail job costing (Result)					
				$data_dtts['dtts_no'] 		= $data_trts['trts_no'];
				$data_dtts['dtts_seq'] 		= 2;
				$data_dtts['dtts_jenis'] 	= 'R';
				$data_dtts['dtts_mspd_no'] 	= $data['trash_mspd_no'];
				$data_dtts['dtts_qty'] 		= $stok;
				$data_dtts['dtts_hpp'] 		= $data['trash_hpp'];

				// Insert data detail job costing (Result)
				if(!$this->db->insert('dt_tfmgoods',$data_dtts)){
					$vok = false;
					$err = true;
					$err_msg = 'Error create detail Job Costing (Result)';
				}
			}

			if($vok){
				// Update hpp produk from
				$this->m_goods_transformation->save_update_hpp_from($data_trts['trts_no'], -1, 'TFN');
				// Update Stok from
				$this->m_goods_transformation->save_update_stok_from($data_trts['trts_no'], -1);
				// Update hpp produk result
				$this->m_goods_transformation->save_update_hpp_result($data_trts['trts_no'], 1, 'TRN');
				// Update Stok result
				$this->m_goods_transformation->save_update_stok_result($data_trts['trts_no'], 1);
			}

			if($vok){			
				// Set data header jurnal			
				$trju_catatan 				= $data_trts['trts_no'].'/'.$data['trash_msgd_no']. ' - '. $this->m_gudang->get_nama_gudang($data['trash_msgd_no']);
				$data_trju['trju_no'] 		= $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);
				$data_trju['trju_tgl'] 		= $data['trash_tgl'];
				$data_trju['trju_tipe'] 	= 'A';
				$data_trju['trju_catatan'] 	= trim(substr($trju_catatan, 0, 250));
				$data_trju['trju_refno'] 	= $data_trts['trts_no'].'GT';	
				$data_trju['trju_reftipe'] 	= 'GT';
				$data_trju['trju_void'] 	= 0;
				$data_trju['trju_lsupd'] 	= date('Y-m-d H:i:s');
				$data_trju['trju_lsusr'] 	= $data['trash_msus_no'];
				$data_trju['trju_cekint'] 	= 1;
				$data_trju['trju_msus_no'] 	= $data['trash_msus_no'];
				$data_trju['trju_mscb_no'] 	= $data['trash_mscb_no'];
				$data_trju['trju_fin'] 		= 'F';
				$data_trju['trju_stcopy'] 	= 'R';
				$data_trju['trju_lscopy'] 	= '';
				$data_trju['trju_tag'] 		= '';

				// Insert data header jurnal
				if(!$this->db->insert('tr_jurnal',$data_trju)){
					$vok = false;
					$err = true;
					$err_msg = 'Error create header jurnal (Job Costing)';
				}
			}		

			if($vok){						
				// Account Inventory (Debet)
				$mskt_no = substr($data['trash_mspd_no'], 0, 1);
				$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
				$data_dtju['dtju_no'] 		= $data_trju['trju_no'];
				$data_dtju['dtju_seq'] 		= 1;
				$data_dtju['dtju_msap_no'] 	= $acc;
				$data_dtju['dtju_debet'] 	= $hpp_total_result;
				$data_dtju['dtju_kredit'] 	= 0; 
				$data_dtju['dtju_catatan'] 	= ''; 
				$data_dtju['dtju_cek'] 		= '';

				// Insert data detail jurnal (Debet)
				if(!$this->db->insert('dt_jurnal',$data_dtju)){
					$vok = false;
					$err = true;
					$err_msg = 'Error create detail jurnal (Job Costing)';
				}
			}

			if($vok){					
				// Account Inventory (Kredit)
				$mskt_no = substr($data['trash_mspd_no'], 0, 1);
				$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
				$data_dtju['dtju_no'] 		= $data_trju['trju_no'];
				$data_dtju['dtju_seq'] 		= 2;
				$data_dtju['dtju_msap_no'] 	= $acc;
				$data_dtju['dtju_debet'] 	= 0;
				$data_dtju['dtju_kredit'] 	= $hpp_total_from;
				$data_dtju['dtju_catatan'] 	= ''; 
				$data_dtju['dtju_cek'] 		= '';

				// Insert data detail jurnal (Kredit)
				if(!$this->db->insert('dt_jurnal',$data_dtju)){
					$vok = false;
					$err = true;
					$err_msg = 'Error create detail jurnal (Job Costing)';
				}
			}

			if($vok){						
				// Account Selisih (Kredit)					
				$data_dtju['dtju_no'] 		= $data_trju['trju_no'];
				$data_dtju['dtju_seq'] 		= 3;
				$data_dtju['dtju_msap_no'] 	= $data['trash_msap_no'];
				$data_dtju['dtju_debet'] 	= 0;
				$data_dtju['dtju_kredit'] 	= $dttsap_total;
				$data_dtju['dtju_catatan'] 	= ''; 
				$data_dtju['dtju_cek'] 		= '';

				// Insert data detail jurnal (Kredit)
				if(!$this->db->insert('dt_jurnal',$data_dtju)){
					$vok = false;
					$err = true;
					$err_msg = 'Error create detail jurnal (Job Costing)';
				}
			}				

			if($vok){
				$seq += 1;
				// Set data detail auto set hpp
				$data_dtash['dtash_no'] 			= $data['trash_no'];
				$data_dtash['dtash_seq'] 			= $seq;
				$data_dtash['dtash_trans_jenis'] 	= '2JC';
				$data_dtash['dtash_trans_no'] 		= $data_trts['trts_no'];

				// Insert data detail auto set hpp
				if(!$this->db->insert('dt_auto_set_hpp',$data_dtash)){
					$vok = false;
					$err = true;
					$err_msg = 'Error create detail auto set hpp';
				}
			}
		}else{
			// jika stoknya nol langsung update hpp dimaster produk
			$this->db->where('mspd_no', $data['trash_mspd_no']);
			$this->db->update('ms_produk', array('mspd_hpp' => $data['trash_hpp']));
		}


		// 3. PROSES MUTASI BALIK DARI GUDANG PENAMPUNG KE GUDANG ASAL
		// ---------------------------------------------------------------------------------
		
		$data_mt = array();						
		$this->db->select('*');
		$this->db->join('tr_mutasi as trmt','trmt.trmt_no = dtash.dtash_trans_no', 'left');
		$this->db->join('dt_mutasi as dtmt','dtmt.dtmt_no = dtash.dtash_trans_no', 'left');
		$this->db->from('dt_auto_set_hpp dtash');
		$this->db->where('dtash_no', $data['trash_no']);
		$this->db->where('dtash_trans_jenis', '1MT');
		$this->db->order_by('dtash_seq', 'ASC');
		
		$query = $this->db->get();		

		if($query->num_rows() > 0){
			$data_mt = $query->result_array();
		}		

		if(count($data_mt) > 0){
			foreach ($data_mt as $key => $value) {								
				if($vok){
					// Set data header mutasi									
					$data_trmt['trmt_no'] 			= $this->m_mutasi->mutasi_kode_auto($trmt_kode_depan);
					$data_trmt['trmt_msgd_no1'] 	= $data_mt[$key]['trmt_msgd_no2'];
					$data_trmt['trmt_msgd_no2'] 	= $data_mt[$key]['trmt_msgd_no1'];
					$data_trmt['trmt_mscb_no1'] 	= $data_mt[$key]['trmt_mscb_no2'];
					$data_trmt['trmt_mscb_no2'] 	= $data_mt[$key]['trmt_mscb_no1'];
					$data_trmt['trmt_tgl'] 			= $data_mt[$key]['trmt_tgl'];
					$data_trmt['trmt_msus_no'] 		= $data_mt[$key]['trmt_msus_no'];
					$data_trmt['trmt_catatan'] 		= $data_mt[$key]['trmt_catatan'];
					$data_trmt['trmt_tag'] 			= $data_mt[$key]['trmt_tag'];
					$data_trmt['trmt_nprint'] 		= $data_mt[$key]['trmt_nprint'];
					$data_trmt['trmt_void'] 		= $data_mt[$key]['trmt_void'];
					$data_trmt['trmt_cekint']		= $data_mt[$key]['trmt_cekint'];
					$data_trmt['trmt_lsupd'] 		= date('Y-m-d H:i:s');
					$data_trmt['trmt_lsusr'] 		= $data_mt[$key]['trmt_lsusr'];
					$data_trmt['trmt_ekspedisi'] 	= $data_mt[$key]['trmt_ekspedisi'];
					$data_trmt['trmt_noekspedisi'] 	= $data_mt[$key]['trmt_noekspedisi'];
					$data_trmt['trmt_tglkirim'] 	= $data_mt[$key]['trmt_tglkirim'];
					$data_trmt['trmt_tglterima'] 	= $data_mt[$key]['trmt_tglterima'];
					$data_trmt['trmt_mscb_no']		= $data_mt[$key]['trmt_mscb_no'];
					$data_trmt['trmt_fin'] 			= $data_mt[$key]['trmt_fin'];
					$data_trmt['trmt_stcopy'] 		= $data_mt[$key]['trmt_stcopy'];
					$data_trmt['trmt_lscopy'] 		= $data_mt[$key]['trmt_lscopy'];

					// Insert data header mutasi
					if(!$this->db->insert('tr_mutasi',$data_trmt)){
						$vok = false;
						$err = true;
						$err_msg = 'Error create header mutasi';
					}	
				}			    

				if($vok){
					// Set data detail mutasi
					$data_dtmt['dtmt_no'] 		= $data_trmt['trmt_no'];
					$data_dtmt['dtmt_seq'] 		= $data_mt[$key]['dtmt_seq'];
					$data_dtmt['dtmt_mspd_no'] 	= $data_mt[$key]['dtmt_mspd_no'];
					$data_dtmt['dtmt_qtyout'] 	= $data_mt[$key]['dtmt_qtyout'];
					$data_dtmt['dtmt_qtyin'] 	= $data_mt[$key]['dtmt_qtyin'];
					$data_dtmt['dtmt_stapv'] 	= $data_mt[$key]['dtmt_stapv'];
					$data_dtmt['dtmt_hpp'] 		= $data['trash_hpp'];
					$data_dtmt['dtmt_catatan'] 	= $data_mt[$key]['dtmt_catatan'];

					// Insert data header mutasi
					if(!$this->db->insert('dt_mutasi',$data_dtmt)){
						$vok = false;
						$err = true;
						$err_msg = 'Error create detail mutasi';
					}
				}

				if($vok){					
					// Update stok (-)
					$this->m_mutasi->update_stok('DELIVERYNOW', $data_trmt['trmt_no'], -1);					
					// Update stok (+)
					$this->m_mutasi->update_stok('RECEIVE_GOODS', $data_trmt['trmt_no'], 1);	
				}

				// JURNAL MUTASI OUT---------------------------------------------
				if($vok){
					// Set data header jurnal					
					$trju_catatan = $data_trmt['trmt_no'].'/From '. $data_trmt['trmt_msgd_no1']. ' - '. $this->m_gudang->get_nama_gudang($data_trmt['trmt_msgd_no1']). '/To '.$data_trmt['trmt_msgd_no2']. ' - '. $this->m_gudang->get_nama_gudang($data_trmt['trmt_msgd_no2']);
					$data_trju['trju_no'] 		= $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);
					$data_trju['trju_tgl'] 		= $data['trash_tgl'];
					$data_trju['trju_tipe'] 	= 'A';
					$data_trju['trju_catatan'] 	= trim(substr($trju_catatan, 0, 250));
					$data_trju['trju_refno'] 	= $data_trmt['trmt_no'].'MD';	
					$data_trju['trju_reftipe'] 	= 'MD';
					$data_trju['trju_void'] 	= 0;
					$data_trju['trju_lsupd'] 	= date('Y-m-d H:i:s');
					$data_trju['trju_lsusr'] 	= $data['trash_msus_no'];
					$data_trju['trju_cekint'] 	= 1;
					$data_trju['trju_msus_no'] 	= $data['trash_msus_no'];
					$data_trju['trju_mscb_no'] 	= $data['trash_mscb_no'];
					$data_trju['trju_fin'] 		= 'F';
					$data_trju['trju_stcopy'] 	= 'R';
					$data_trju['trju_lscopy'] 	= '';
					$data_trju['trju_tag'] 		= '';

					// Insert data header jurnal
					if(!$this->db->insert('tr_jurnal',$data_trju)){
						$vok = false;
						$err = true;
						$err_msg = 'Error create header jurnal (Mutasi Out)';
					}
				}
				
				$saldo = round($data_dtmt['dtmt_hpp'] * $data_dtmt['dtmt_qtyout'], 4);

				if($vok){
					// Set data detail jurnal
					// Account WIP Mutasi (Debet)
					$acc = $this->m_setting_account->get_setting_account_byid('MWIP');				
					$data_dtju['dtju_no'] 		= $data_trju['trju_no'];
					$data_dtju['dtju_seq'] 		= 1;
					$data_dtju['dtju_msap_no'] 	= $acc['mssa_msap_no'];
					$data_dtju['dtju_debet'] 	= $saldo;
					$data_dtju['dtju_kredit'] 	= 0; 
					$data_dtju['dtju_catatan'] 	= ''; 
					$data_dtju['dtju_cek'] 		= '';

					// Insert data detail jurnal (Debet)
					if(!$this->db->insert('dt_jurnal',$data_dtju)){
						$vok = false;
						$err = true;
						$err_msg = 'Error create detail jurnal (Mutasi Out)';
					}
				}

				if($vok){
					// Account Inventory (Kredit)
					$mskt_no = substr($data['trash_mspd_no'], 0, 1);
					$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
					$data_dtju['dtju_no'] 		= $data_trju['trju_no'];
					$data_dtju['dtju_seq'] 		= 2;
					$data_dtju['dtju_msap_no'] 	= $acc;
					$data_dtju['dtju_debet'] 	= 0;
					$data_dtju['dtju_kredit'] 	= $saldo;
					$data_dtju['dtju_catatan'] 	= '';
					$data_dtju['dtju_cek'] 		= '';	

					// insert data detail jurnal (Kredit)
					if(!$this->db->insert('dt_jurnal',$data_dtju)){
						$vok = false;
						$err = true;
						$err_msg = 'Error create detail jurnal (Mutasi Out)';
					}
				}

				// JURNAL MUTASI IN---------------------------------------------
				if($vok){
					// Set data header jurnal					
					$trju_catatan = $data_trmt['trmt_no'].'/From '. $data_trmt['trmt_msgd_no1']. ' - '. $this->m_gudang->get_nama_gudang($data_trmt['trmt_msgd_no1']). '/To '.$data_trmt['trmt_msgd_no2']. ' - '. $this->m_gudang->get_nama_gudang($data_trmt['trmt_msgd_no2']);
					$data_trju['trju_no'] 		= $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);
					$data_trju['trju_tgl'] 		= $data['trash_tgl'];
					$data_trju['trju_tipe'] 	= 'A';
					$data_trju['trju_catatan'] 	= trim(substr($trju_catatan, 0, 250));
					$data_trju['trju_refno'] 	= $data_trmt['trmt_no'].'MR';	
					$data_trju['trju_reftipe'] 	= 'MR';
					$data_trju['trju_void'] 	= 0;
					$data_trju['trju_lsupd'] 	= date('Y-m-d H:i:s');
					$data_trju['trju_lsusr'] 	= $data['trash_msus_no'];
					$data_trju['trju_cekint'] 	= 1;
					$data_trju['trju_msus_no'] 	= $data['trash_msus_no'];
					$data_trju['trju_mscb_no'] 	= $data['trash_mscb_no'];
					$data_trju['trju_fin'] 		= 'F';
					$data_trju['trju_stcopy'] 	= 'R';
					$data_trju['trju_lscopy'] 	= '';
					$data_trju['trju_tag'] 		= '';

					// Insert data header jurnal
					if(!$this->db->insert('tr_jurnal',$data_trju)){
						$vok = false;
						$err = true;
						$err_msg = 'Error create header jurnal (Mutasi In)';
					}
				}

				if($vok){
					// Account Inventory (Debet)
					$mskt_no = substr($data['trash_mspd_no'], 0, 1);
					$acc = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
					$data_dtju['dtju_no'] 		= $data_trju['trju_no'];
					$data_dtju['dtju_seq'] 		= 1;
					$data_dtju['dtju_msap_no'] 	= $acc;
					$data_dtju['dtju_debet'] 	= $saldo;
					$data_dtju['dtju_kredit'] 	= 0;
					$data_dtju['dtju_catatan'] 	= '';
					$data_dtju['dtju_cek'] 		= '';	

					// insert data detail jurnal (Debet)
					if(!$this->db->insert('dt_jurnal',$data_dtju)){
						$vok = false;
						$err = true;
						$err_msg = 'Error create detail jurnal (Mutasi In)';
					}
				}

				if($vok){
					// Set data detail jurnal
					// Account WIP Mutasi (Kredit)
					$acc = $this->m_setting_account->get_setting_account_byid('MWIP');				
					$data_dtju['dtju_no'] 		= $data_trju['trju_no'];
					$data_dtju['dtju_seq'] 		= 2;
					$data_dtju['dtju_msap_no'] 	= $acc['mssa_msap_no'];
					$data_dtju['dtju_debet'] 	= 0;
					$data_dtju['dtju_kredit'] 	= $saldo; 
					$data_dtju['dtju_catatan'] 	= ''; 
					$data_dtju['dtju_cek'] 		= '';

					// Insert data detail jurnal (Kredit)
					if(!$this->db->insert('dt_jurnal',$data_dtju)){
						$vok = false;
						$err = true;
						$err_msg = 'Error create detail jurnal (Mutasi In)';
					}
				}

				if($vok){
					// Set data detail auto set hpp
					$seq += 1;
					$data_dtash['dtash_no'] 			= $data['trash_no'];
					$data_dtash['dtash_seq'] 			= $seq;
					$data_dtash['dtash_trans_jenis'] 	= '2MT';
					$data_dtash['dtash_trans_no'] 		= $data_trmt['trmt_no'];

					// Insert data detail auto set hpp
					if(!$this->db->insert('dt_auto_set_hpp',$data_dtash)){
						$vok = false;
						$err = true;
						$err_msg = 'Error create detail auto set hpp';
					}
				}	
			}
		}

		END SKIP >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
		>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
		>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */ 

		
		/*
		----------------------------------------------------------------------------------------------
		| PROSES UPDATE/REVISI JURNAL TRANSAKSI YANG BERKAITAN DENGAN HPP
		----------------------------------------------------------------------------------------------
		*/

		$data['trash_tgl'] = substr($data['trash_tgl'], 0, 10);

		// PROSES UPDATE HPP (DETAIL STOCK ADJUSTMENT)----------------------------------------------------------
		if($vok){
			// SET dtas_hpp 
			$str_query = "UPDATE dt_adjstok
							LEFT JOIN ms_produk ON mspd_no = dtas_mspd_no
							LEFT JOIN tr_adjstok ON tras_no = dtas_no
							SET dtas_hpp = mspd_hpp
							WHERE dtas_mspd_no = '".$data['trash_mspd_no']."'
							AND CONVERT(tras_tgl, DATE) > '".$data['trash_tgl']."'";
			
			if(!$this->db->simple_query($str_query)){								
				$vok = false;
				$err = true;
				$err_msg = 'Error set dtas_hpp';
			}		
		}

		// PROSES UPDATE JURNAL STOCK ADJUSTMENT----------------------------------------------------------
		if($vok){
			$str_query = "SELECT DISTINCT tras_no, trju_no 
							FROM dt_adjstok
							LEFT JOIN tr_adjstok ON tras_no = dtas_no 
							LEFT JOIN tr_jurnal ON trju_tipe = 'A'
													AND trju_reftipe = 'AS'
													AND trju_refno = CONCAT(tras_no, 'AS')
						WHERE dtas_mspd_no = '".$data['trash_mspd_no']."'
						AND tras_void = 0
						AND trju_no IS NOT NULL
						AND CONVERT(tras_tgl, DATE) > '".$data['trash_tgl']."'";

			$query = $this->db->query($str_query);
			$data_dtas = array();			

			if($query->num_rows() > 0){
				$data_dtas = $query->result_array();												
				foreach ($data_dtas as $key => $value) {
					
					// Delete detail jurnal
					if($vok){
						$str_query = "DELETE FROM dt_jurnal
										WHERE dtju_no = '".$data_dtas[$key]['trju_no']."'";					

						if(!$this->db->simple_query($str_query)){										
							$vok = false;
							$err = true;
							$err_msg = 'Error delete detail jurnal (Stock Adjustment)';
						}	
					}

					// Insert data detail jurnal tahap 1
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
										(SELECT '".
											$data_dtas[$key]['trju_no']."',
											(dtas_seq * 2) - 1, 
											mskt_msap_no_inv,
											ROUND((dtas_qty * dtas_hpp), 4),
											0,
											'',
											''
											FROM dt_adjstok
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtas_mspd_no, 1, 1)
											WHERE dtas_no = '".$data_dtas[$key]['tras_no']."')";
						if(!$this->db->simple_query($str_query)){							
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Stock Adjustment (tahap 1)';
						}
					}

					// Insert data detail jurnal tahap 2
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
										(SELECT '".
											$data_dtas[$key]['trju_no']."',
											(dtas_seq * 2), 
											(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'ADJS'),
											0,
											ROUND((dtas_qty * dtas_hpp), 4),
											'',
											''
											FROM dt_adjstok										
											WHERE dtas_no = '".$data_dtas[$key]['tras_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Stock Adjustment (tahap 2)';
						}	
					}
				}				
			}
		}

		// PROSES UPDATE HPP (DETAIL MUTASI)----------------------------------------------------------
		if($vok){
			// SET dtmt_hpp 			
			$str_query = "UPDATE dt_mutasi
							LEFT JOIN ms_produk ON mspd_no = dtmt_mspd_no
							LEFT JOIN tr_mutasi ON trmt_no = dtmt_no
							SET dtmt_hpp = mspd_hpp
							WHERE dtmt_mspd_no = '".$data['trash_mspd_no']."'
							AND trmt_tglkirim > '".$data['trash_tgl']."'";
			
			if(!$this->db->simple_query($str_query)){
				$vok = false;
				$err = true;
				$err_msg = 'Error set dtmt_hpp';
			}			
		}

		// PROSES UPDATE JURNAL MUTASI OUT----------------------------------------------------------
		if($vok){
			$str_query = "SELECT DISTINCT trmt_no, trju_no 
							FROM dt_mutasi
							LEFT JOIN tr_mutasi ON trmt_no = dtmt_no 
							LEFT JOIN tr_jurnal ON trju_tipe = 'A'
													AND trju_reftipe = 'MD'
													AND trju_refno = CONCAT(trmt_no, 'MD')
						WHERE dtmt_mspd_no = '".$data['trash_mspd_no']."'
						AND trmt_void = 0
						AND trju_no IS NOT NULL
						AND trmt_tglkirim > '".$data['trash_tgl']."'";

			$query = $this->db->query($str_query);
			$data_dtmt = array();			

			if($query->num_rows() > 0){
				$data_dtmt = $query->result_array();												
				foreach ($data_dtmt as $key => $value) {
					
					// Delete detail jurnal
					if($vok){
						$str_query = "DELETE FROM dt_jurnal
										WHERE dtju_no = '".$data_dtmt[$key]['trju_no']."'";					

						if(!$this->db->simple_query($str_query)){											
							$vok = false;
							$err = true;
							$err_msg = 'Error delete detail jurnal (Mutasi Out)';
						}
					}

					// Insert data detail jurnal tahap 1
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
										(SELECT '".
											$data_dtmt[$key]['trju_no']."',
											(dtmt_seq * 2) - 1, 
											(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'MWIP'),
											ROUND((dtmt_qtyout * dtmt_hpp), 4),
											0,
											'',
											''
											FROM dt_mutasi										
											WHERE dtmt_no = '".$data_dtmt[$key]['trmt_no']."')";
						if(!$this->db->simple_query($str_query)){							
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Mutasi Out (Tahap 1)';
						}
					}

					// Insert data detail jurnal tahap 2
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtmt[$key]['trju_no']."',
											(dtmt_seq * 2), 
											mskt_msap_no_inv,
											0,
											ROUND((dtmt_qtyout * dtmt_hpp), 4),
											'',
											''
											FROM dt_mutasi										
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtmt_mspd_no, 1, 1)
											WHERE dtmt_no = '".$data_dtmt[$key]['trmt_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Mutasi Out (Tahap 2)';
						}
					}
				}				
			}
		}

		// PROSES UPDATE JURNAL MUTASI IN----------------------------------------------------------
		if($vok){
			$str_query = "SELECT DISTINCT trmt_no, trju_no 
							FROM dt_mutasi
							LEFT JOIN tr_mutasi ON trmt_no = dtmt_no 
							LEFT JOIN tr_jurnal ON trju_tipe = 'A'
													AND trju_reftipe = 'MR'
													AND trju_refno = CONCAT(trmt_no, 'MR')
						WHERE dtmt_mspd_no = '".$data['trash_mspd_no']."'
						AND trmt_void = 0
						AND trju_no IS NOT NULL
						AND trmt_tglterima > '".$data['trash_tgl']."'";

			$query = $this->db->query($str_query);
			$data_dtmt = array();			

			if($query->num_rows() > 0){
				$data_dtmt = $query->result_array();												
				foreach ($data_dtmt as $key => $value) {
					
					// Delete detail jurnal
					if($vok){
						$str_query = "DELETE FROM dt_jurnal
										WHERE dtju_no = '".$data_dtmt[$key]['trju_no']."'";					

						if(!$this->db->simple_query($str_query)){				
							$vok = false;
							$err = true;
							$err_msg = 'Error delete detail jurnal (Mutasi In)';
						}	
					}

					// Insert data detail jurnal tahap 1
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtmt[$key]['trju_no']."',
											(dtmt_seq * 3) - 2, 
											mskt_msap_no_inv,
											ROUND((dtmt_qtyin * dtmt_hpp), 4),
											0,
											'',
											''
											FROM dt_mutasi						
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtmt_mspd_no, 1, 1)				
											WHERE dtmt_no = '".$data_dtmt[$key]['trmt_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Mutasi In (Tahap 1)';
						}
					}

					// Insert data detail jurnal tahap 3
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtmt[$key]['trju_no']."',
											(dtmt_seq * 3), 
											(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'MWIP'),
											0,
											ROUND((dtmt_qtyout * dtmt_hpp), 4),
											'',
											''
											FROM dt_mutasi																				
											WHERE dtmt_no = '".$data_dtmt[$key]['trmt_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Mutasi In (Tahap 3)';
						}
					}

					// Insert data detail jurnal tahap 2
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtmt[$key]['trju_no']."',
											(dtmt_seq * 3) - 1, 
											(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'MTRS'),
											round(
											(SELECT IFNULL(dtju_kredit, 0) FROM dt_jurnal WHERE dtju_no = '".$data_dtmt[$key]['trju_no']. "' AND dtju_seq = (dtmt_seq * 3))
											-
											(SELECT IFNULL(dtju_debet, 0) FROM dt_jurnal WHERE dtju_no = '".$data_dtmt[$key]['trju_no']. "' AND dtju_seq = (dtmt_seq * 3) - 2)
											, 4),
											0,
											'',
											''
											FROM dt_mutasi										
											WHERE dtmt_no = '".$data_dtmt[$key]['trmt_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Mutasi In (Tahap 2)';
						}
					}					
				}				
			}
		}		

		// PROSES UPDATE HPP (DETAIL SALES DELIVERY)----------------------------------------------------------
		if($vok){
			// SET dtsd_hpp 
			$str_query = "UPDATE dt_sales_dlv
							LEFT JOIN ms_produk ON mspd_no = dtsd_mspd_no
							LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
							SET dtsd_hpp = mspd_hpp
							WHERE dtsd_mspd_no = '".$data['trash_mspd_no']."'
							AND trsd_tglkirim > '".$data['trash_tgl']."'";
			
			if(!$this->db->simple_query($str_query)){				
				$vok = false;
				$err = true;
				$err_msg = 'Error set dtsd_hpp';
			}		
		}

		// PROSES UPDATE JURNAL SALES DELIVERY (DELIVERY NOW)----------------------------------------------------------
		if($vok){
			$str_query = "SELECT DISTINCT trsd_no, trju_no 
							FROM dt_sales_dlv
							LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no 
							LEFT JOIN tr_jurnal ON trju_tipe = 'A'
													AND trju_reftipe = 'SD'
													AND trju_refno = CONCAT(trsd_no, 'SD')
						WHERE dtsd_mspd_no = '".$data['trash_mspd_no']."'
						AND trsd_void = 0
						AND trju_no IS NOT NULL
						AND trsd_tglkirim > '".$data['trash_tgl']."'";

			$query = $this->db->query($str_query);
			$data_dtsd = array();			

			if($query->num_rows() > 0){
				$data_dtsd = $query->result_array();												
				foreach ($data_dtsd as $key => $value) {
					
					// Delete detail jurnal
					if($vok){
						$str_query = "DELETE FROM dt_jurnal
										WHERE dtju_no = '".$data_dtsd[$key]['trju_no']."'";					

						if(!$this->db->simple_query($str_query)){				
							$vok = false;
							$err = true;
							$err_msg = 'Error delete detail jurnal (Sales Delivery / Delivery Now)';
						}
					}
					
					// Insert data detail jurnal tahap 1
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5) - 4, 
											IF(mscs_jenis = 'A', (SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUA'),
													(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUR')),
											ROUND((dtsd_nett * dtsd_qtykrm), 4),
											0,
											'',
											''
											FROM dt_sales_dlv						
											LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
											LEFT JOIN ms_customer ON mscs_no = trsd_mscs_no										
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Sales Delivery / Delivery Now (Tahap 1)';
						}
					}

					// Insert data detail jurnal tahap 2
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5) - 3, 
											IF(mscs_jenis = 'A', mskt_msap_no_pja, mskt_msap_no_pjr),
											0,
											ROUND((dtsd_bftax * dtsd_qtykrm), 4),
											'',
											''
											FROM dt_sales_dlv						
											LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
											LEFT JOIN ms_customer ON mscs_no = trsd_mscs_no										
											LEFT JOIN ms_kategori ON mskt_no = substr(dtsd_mspd_no, 1, 1)
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Sales Delivery / Delivery Now (Tahap 2)';
						}
					}

					// Insert data detail jurnal tahap 3
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5) - 2, 
											(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PPNK'),
											0,
											round(
											(SELECT IFNULL(dtju_debet, 0) FROM dt_jurnal WHERE dtju_no = '".$data_dtsd[$key]['trju_no']. "' AND dtju_seq = (dtsd_seq * 5) - 4)
											-
											(SELECT IFNULL(dtju_kredit, 0) FROM dt_jurnal WHERE dtju_no = '".$data_dtsd[$key]['trju_no']. "' AND dtju_seq = (dtsd_seq * 5) - 3)
											, 4),										
											'',
											''
											FROM dt_sales_dlv																
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Sales Delivery / Delivery Now (Tahap 3)';
						}
					}

					// Insert data detail jurnal tahap 4
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5) - 1, 
											IF(mscs_jenis = 'A', mskt_msap_no_hpa, mskt_msap_no_hpr),
											ROUND((dtsd_hpp * dtsd_qtykrm), 4),
											0,
											'',
											''
											FROM dt_sales_dlv
											LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
											LEFT JOIN ms_customer ON mscs_no = trsd_mscs_no
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtsd_mspd_no, 1, 1)				
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Sales Delivery / Delivery Now (Tahap 4)';
						}
					}

					// Insert data detail jurnal tahap 5
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5), 
											mskt_msap_no_inv,
											0,
											ROUND((dtsd_hpp * dtsd_qtykrm), 4),
											'',
											''
											FROM dt_sales_dlv						
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtsd_mspd_no, 1, 1)				
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Sales Delivery / Delivery Now (Tahap 5)';
						}	
					}				
				}				
			}
		}

		// PROSES UPDATE JURNAL SALES DELIVERY (CONFIRM DELIVERY)----------------------------------------------------------
		if($vok){
			$str_query = "SELECT DISTINCT trsd_no, trju_no 
							FROM dt_sales_dlv
							LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no 
							LEFT JOIN tr_jurnal ON trju_tipe = 'A'
													AND trju_reftipe = 'DR'
													AND trju_refno = CONCAT(trsd_no, 'DR')
						WHERE dtsd_mspd_no = '".$data['trash_mspd_no']."'
						AND trsd_void = 0
						AND trju_no IS NOT NULL
						AND dtsd_qtyrej <> 0
						AND trsd_tglbalik > '".$data['trash_tgl']."'";

			$query = $this->db->query($str_query);
			$data_dtsd = array();			

			if($query->num_rows() > 0){
				$data_dtsd = $query->result_array();												
				foreach ($data_dtsd as $key => $value) {
					
					// Delete detail jurnal
					if($vok){
						$str_query = "DELETE FROM dt_jurnal
										WHERE dtju_no = '".$data_dtsd[$key]['trju_no']."'";					

						if(!$this->db->simple_query($str_query)){				
							$vok = false;
							$err = true;
							$err_msg = 'Error delete detail jurnal (Sales Delivery / Confirm Delivery)';
						}	
					}

					// Insert data detail jurnal tahap 1
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5) - 4, 
											IF(mscs_jenis = 'A', mskt_msap_no_pja, mskt_msap_no_pjr),
											ROUND((dtsd_bftax * dtsd_qtyrej), 4),
											0,
											'',
											''
											FROM dt_sales_dlv						
											LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
											LEFT JOIN ms_customer ON mscs_no = trsd_mscs_no										
											LEFT JOIN ms_kategori ON mskt_no = substr(dtsd_mspd_no, 1, 1)
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."'
											AND dtsd_qtyrej <> 0)";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Sales Delivery / Confirm Delivery (Tahap 1)';
						}
					}

					// Insert data detail jurnal tahap 3
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5) - 2, 
											IF(mscs_jenis = 'A', (SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUA'),
													(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUR')),
											0,
											ROUND((dtsd_nett * dtsd_qtyrej), 4),
											'',
											''
											FROM dt_sales_dlv						
											LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
											LEFT JOIN ms_customer ON mscs_no = trsd_mscs_no										
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."'
											AND dtsd_qtyrej <> 0)";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Sales Delivery / Confirm Delivery (Tahap 3)';
						}
					}

					// Insert data detail jurnal tahap 2
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5) - 3, 
											(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PPNK'),
											round(
											(SELECT IFNULL(dtju_kredit, 0) FROM dt_jurnal WHERE dtju_no = '".$data_dtsd[$key]['trju_no']. "' AND dtju_seq = (dtsd_seq * 5) - 2)
											-
											(SELECT IFNULL(dtju_debet, 0) FROM dt_jurnal WHERE dtju_no = '".$data_dtsd[$key]['trju_no']. "' AND dtju_seq = (dtsd_seq * 5) - 4)
											, 4),										
											0,
											'',
											''
											FROM dt_sales_dlv																
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."'
											AND dtsd_qtyrej <> 0)";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Sales Delivery / Confirm Delivery (Tahap 2)';
						}
					}
										

					// Insert data detail jurnal tahap 4
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5) - 1, 
											mskt_msap_no_inv,
											ROUND((dtsd_hpp * dtsd_qtyrej), 4),
											0,
											'',
											''
											FROM dt_sales_dlv						
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtsd_mspd_no, 1, 1)				
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."'
											AND dtsd_qtyrej <> 0)";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Sales Delivery / Confirm Delivery (Tahap 4)';
						}
					}

					// Insert data detail jurnal tahap 5
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5), 
											IF(mscs_jenis = 'A', mskt_msap_no_hpa, mskt_msap_no_hpr),
											0,
											ROUND((dtsd_hpp * dtsd_qtyrej), 4),
											'',
											''
											FROM dt_sales_dlv
											LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
											LEFT JOIN ms_customer ON mscs_no = trsd_mscs_no
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtsd_mspd_no, 1, 1)				
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."'
											AND dtsd_qtyrej <> 0)";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Sales Delivery / Confirm Delivery (Tahap 5)';
						}
					}
				}				
			}
		}				

		// PROSES UPDATE HPP (DETAIL SALES RETUR)----------------------------------------------------------
		if($vok){
			// SET dtsr_hpp 
			$str_query = "UPDATE dt_salesret
							LEFT JOIN ms_produk ON mspd_no = dtsr_mspd_no
							LEFT JOIN tr_salesret ON trsr_no = dtsr_no
							SET dtsr_hpp = mspd_hpp
							WHERE dtsr_mspd_no = '".$data['trash_mspd_no']."'
							AND trsr_tglterima > '".$data['trash_tgl']."'";
			
			if(!$this->db->simple_query($str_query)){				
				die('Error set dtsr_hpp.');
			}		
		}

		// PROSES UPDATE JURNAL SALES RETUR----------------------------------------------------------
		if($vok){
			$str_query = "SELECT DISTINCT trsr_no, trju_no 
							FROM dt_salesret
							LEFT JOIN tr_salesret ON trsr_no = dtsr_no 
							LEFT JOIN tr_jurnal ON trju_tipe = 'A'
													AND trju_reftipe = 'SR'
													AND trju_refno = trsr_no
						WHERE dtsr_mspd_no = '".$data['trash_mspd_no']."'
						AND trsr_void = 0
						AND trju_no IS NOT NULL
						AND trsr_tglterima > '".$data['trash_tgl']."'";

			$query = $this->db->query($str_query);
			$data_dtsr = array();			

			if($query->num_rows() > 0){
				$data_dtsr = $query->result_array();												
				foreach ($data_dtsr as $key => $value) {
					
					// Delete detail jurnal
					if($vok){
						$str_query = "DELETE FROM dt_jurnal
										WHERE dtju_no = '".$data_dtsr[$key]['trju_no']."'";					

						if(!$this->db->simple_query($str_query)){				
							$vok = false;
							$err = true;
							$err_msg = 'Error delete detail jurnal (Sales Retur)';
						}	
					}

					// Insert data detail jurnal tahap 1
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsr[$key]['trju_no']."',
											(dtsr_seq * 5) - 4, 
											mskt_msap_no_inv,
											ROUND((dtsr_qtyretur * dtsr_hpp), 4),
											0,
											'',
											''
											FROM dt_salesret						
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtsr_mspd_no, 1, 1)				
											WHERE dtsr_no = '".$data_dtsr[$key]['trsr_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Sales Retur (Tahap 1)';
						}
					}

					// Insert data detail jurnal tahap 2
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsr[$key]['trju_no']."',
											(dtsr_seq * 5) - 3, 
											IF(mscs_jenis = 'A', mskt_msap_no_hpa, mskt_msap_no_hpr),
											0,
											ROUND((dtsr_qtyretur * dtsr_hpp), 4),
											'',
											''
											FROM dt_salesret						
											LEFT JOIN tr_salesret ON trsr_no = dtsr_no
											LEFT JOIN ms_customer ON mscs_no = trsr_mscs_no
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtsr_mspd_no, 1, 1)				
											WHERE dtsr_no = '".$data_dtsr[$key]['trsr_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Sales Retur (Tahap 2)';
						}
					}

					// Insert data detail jurnal tahap 3
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsr[$key]['trju_no']."',
											(dtsr_seq * 5) - 2, 
											IF(mscs_jenis = 'A', mskt_msap_no_sra, mskt_msap_no_srr),
											ROUND((dtsr_qtyretur * dtsr_bftax), 4),
											0,
											'',
											''
											FROM dt_salesret						
											LEFT JOIN tr_salesret ON trsr_no = dtsr_no
											LEFT JOIN ms_customer ON mscs_no = trsr_mscs_no
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtsr_mspd_no, 1, 1)				
											WHERE dtsr_no = '".$data_dtsr[$key]['trsr_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Sales Retur (Tahap 3)';
						}
					}

					// Insert data detail jurnal tahap 5
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsr[$key]['trju_no']."',
											(dtsr_seq * 5), 
											IF(mscs_jenis = 'A' AND trsr_jenis = 'C', (SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'SRCA'),
												IF(mscs_jenis = 'R' AND trsr_jenis = 'C', (SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'SRCR'),
													IF(mscs_jenis = 'A' AND trsr_jenis = 'V', (SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'SRVA'),
														(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'SRVR')
													)	
												)
											),
											0,
											ROUND((dtsr_qtyretur * dtsr_nett), 4),
											'',
											''
											FROM dt_salesret						
											LEFT JOIN tr_salesret ON trsr_no = dtsr_no
											LEFT JOIN ms_customer ON mscs_no = trsr_mscs_no										
											WHERE dtsr_no = '".$data_dtsr[$key]['trsr_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Sales Retur (Tahap 5)';
						}					
					}

					// Insert data detail jurnal tahap 4
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsr[$key]['trju_no']."',
											(dtsr_seq * 5) - 1, 
											(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PPNK'),
											round(
											(SELECT IFNULL(dtju_kredit, 0) FROM dt_jurnal WHERE dtju_no = '".$data_dtsr[$key]['trju_no']. "' AND dtju_seq = (dtsr_seq * 5))
											-
											(SELECT IFNULL(dtju_debet, 0) FROM dt_jurnal WHERE dtju_no = '".$data_dtsr[$key]['trju_no']. "' AND dtju_seq = (dtsr_seq * 5) - 2)
											, 4),
											0,
											'',
											''
											FROM dt_salesret																
											WHERE dtsr_no = '".$data_dtsr[$key]['trsr_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal Sales Retur (Tahap 4)';
						}
					}					
				}				
			}
		}	

		// PROSES UPDATE HPP (DETAIL SPK)----------------------------------------------------------
		if($vok){
			// SET dtspk_hpp 
			$str_query = "UPDATE dt_spk_sp
							LEFT JOIN ms_produk ON mspd_no = dtspk_mspd_no
							LEFT JOIN tr_spk ON trspk_no = dtspk_no
							SET dtspk_hpp = mspd_hpp
							WHERE dtspk_mspd_no = '".$data['trash_mspd_no']."'
							AND trspk_tglselesai > '".$data['trash_tgl']."'";
			
			if(!$this->db->simple_query($str_query)){				
				$vok = false;
				$err = true;
				$err_msg = 'Error set dtspk_hpp';
			}		
		}

		// PROSES UPDATE JURNAL SPK (SPK FINISH)----------------------------------------------------------
		if($vok){
			$str_query = "SELECT DISTINCT trspk_no, trju_no 
							FROM dt_spk_sp
							LEFT JOIN tr_spk ON trspk_no = dtspk_no 
							LEFT JOIN tr_jurnal ON trju_tipe = 'A'
													AND trju_reftipe = 'SP'
													AND trju_refno = CONCAT(trspk_no, 'SP')
						WHERE dtspk_mspd_no = '".$data['trash_mspd_no']."'
						AND trspk_void = 0
						AND trju_no IS NOT NULL
						AND trspk_tglselesai > '".$data['trash_tgl']."'";

			$query = $this->db->query($str_query);
			$data_dtspk = array();			

			if($query->num_rows() > 0){
				$data_dtspk = $query->result_array();												
				foreach ($data_dtspk as $key => $value) {
					
					// Delete detail jurnal
					if($vok){
						$str_query = "DELETE FROM dt_jurnal
										WHERE dtju_no = '".$data_dtspk[$key]['trju_no']."'";					

						if(!$this->db->simple_query($str_query)){				
							$vok = false;
							$err = true;
							$err_msg = 'Error delete detail jurnal (SPK / SPK Finish)';
						}
					}
					
					// Insert data detail jurnal tahap 1
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtspk[$key]['trju_no']."',
											(dtspk_seq * 5) - 4, 
											IF(mscs_jenis = 'A', (SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUA'),
													(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUR')),
											ROUND((dtspk_nett * dtspk_qty), 4),
											0,
											'',
											''
											FROM dt_spk_sp						
											LEFT JOIN tr_spk ON trspk_no = dtspk_no
											LEFT JOIN ms_customer ON mscs_no = trspk_mscs_no										
											WHERE dtspk_no = '".$data_dtspk[$key]['trspk_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal SPK Tahap 1';
						}
					}

					// Insert data detail jurnal tahap 2
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtspk[$key]['trju_no']."',
											(dtspk_seq * 5) - 3, 
											IF(mscs_jenis = 'A', mskt_msap_no_spa, mskt_msap_no_spr),
											0,
											ROUND((dtspk_bftax * dtspk_qty), 4),
											'',
											''
											FROM dt_spk_sp
											LEFT JOIN tr_spk ON trspk_no = dtspk_no
											LEFT JOIN ms_customer ON mscs_no = trspk_mscs_no										
											LEFT JOIN ms_kategori ON mskt_no = substr(dtspk_mspd_no, 1, 1)
											WHERE dtspk_no = '".$data_dtspk[$key]['trspk_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal SPK Tahap 2';
						}
					}

					// Insert data detail jurnal tahap 3
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtspk[$key]['trju_no']."',
											(dtspk_seq * 5) - 2, 
											(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PPNK'),
											0,
											round(
											(SELECT IFNULL(dtju_debet, 0) FROM dt_jurnal WHERE dtju_no = '".$data_dtspk[$key]['trju_no']. "' AND dtju_seq = (dtspk_seq * 5) - 4)
											-
											(SELECT IFNULL(dtju_kredit, 0) FROM dt_jurnal WHERE dtju_no = '".$data_dtspk[$key]['trju_no']. "' AND dtju_seq = (dtspk_seq * 5) - 3)
											, 4),										
											'',
											''
											FROM dt_spk_sp
											WHERE dtspk_no = '".$data_dtspk[$key]['trspk_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal SPK Tahap 3';
						}
					}

					// Insert data detail jurnal tahap 4
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtspk[$key]['trju_no']."',
											(dtspk_seq * 5) - 1, 
											IF(mscs_jenis = 'A', mskt_msap_no_hpa, mskt_msap_no_hpr),
											ROUND((dtspk_hpp * dtspk_qty), 4),
											0,
											'',
											''
											FROM dt_spk_sp
											LEFT JOIN tr_spk ON trspk_no = dtspk_no
											LEFT JOIN ms_customer ON mscs_no = trspk_mscs_no
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtspk_mspd_no, 1, 1)				
											WHERE dtspk_no = '".$data_dtspk[$key]['trspk_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal SPK Tahap 4';
						}
					}

					// Insert data detail jurnal tahap 5
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtspk[$key]['trju_no']."',
											(dtspk_seq * 5), 
											mskt_msap_no_inv,
											0,
											ROUND((dtspk_hpp * dtspk_qty), 4),
											'',
											''
											FROM dt_spk_sp
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtspk_mspd_no, 1, 1)				
											WHERE dtspk_no = '".$data_dtspk[$key]['trspk_no']."')";
						if(!$this->db->simple_query($str_query)){
							$vok = false;
							$err = true;
							$err_msg = 'Error create detail jurnal SPK Tahap 5';
						}	
					}				
				}				
			}
		}

		return array('err' => $err, 'err_msg' => $err_msg);
	}

	public function get_trash_no_auto(){		
		$this->db->select_max("trash_no");		
		$query = $this->db->get("tr_auto_set_hpp");
		if ($query->num_rows() == 0){
			return 1;
		}else {
			$result = $query->result_array();
			return $result[0]['trash_no'] + 1;						
		}
	}
}
