<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_revisi_jurnal_pp extends MY_Model {

	function __construct(){
		parent::__construct();				
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function revisi_jurnal_pp(){		

		/*
		----------------------------------------------------------------------------------------------
		| PROSES UPDATE/REVISI JURNAL TRANSAKSI YANG ADA PRODUK PAKETNYA
		----------------------------------------------------------------------------------------------
		*/	

		$vok = true;	

		
		// Update mspd_hpp = 0 (Produk Paket)
		$str_query = "UPDATE ms_produk 
						SET mspd_hpp = 0
						WHERE mspd_paket = 'Y'";

		if($this->db->simple_query($str_query)){								
			echo 'Berhasil update mspd_hpp = 0';
			echo '<br>';
		}else{
			die('Error set mspd_hpp');
		}

		// PROSES UPDATE HPP (DETAIL SALES DELIVERY)----------------------------------------------------------
		if($vok){
			// SET dtsd_hpp 
			$str_query = "UPDATE dt_sales_dlv
							LEFT JOIN ms_produk ON mspd_no = dtsd_mspd_no
							LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
							SET dtsd_hpp = 0							
							WHERE mspd_paket = 'Y'
							AND dtsd_hpp <> 0";		

			if($this->db->simple_query($str_query)){								
				echo 'Berhasil update dtsd_hpp = 0';
				echo '<br>';
			}else{
				die('Error set dtsd_hpp');
			}		
		}

		// PROSES UPDATE JURNAL SALES DELIVERY (DELIVERY NOW)----------------------------------------------------------
		if($vok){
			$str_query = "SELECT DISTINCT trsd_no, trju_no FROM dt_sales_dlv
							LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
							LEFT JOIN ms_produk ON mspd_no = dtsd_mspd_no
							LEFT JOIN tr_jurnal ON trju_tipe = 'A' AND trju_reftipe = 'SD' AND trju_refno = CONCAT(trsd_no, 'SD')
							WHERE trsd_void = 0
							AND trsd_tglkirim <> '0000-00-00'
							AND trju_no IS NOT NULL
							AND mspd_paket = 'Y'";

			$query = $this->db->query($str_query);
			$data_dtsd = array();			

			if($query->num_rows() > 0){
				$data_dtsd = $query->result_array();												

				echo '<br>';
				echo 'DELIVERY NOW -----------------';
				echo '<br>';
				echo $query->num_rows(). ' DATA';
				echo '<br>';

				foreach ($data_dtsd as $key => $value) {
					
					// Delete detail jurnal
					if($vok){
						$str_query = "DELETE FROM dt_jurnal
										WHERE dtju_no = '".$data_dtsd[$key]['trju_no']."'";					

						if(!$this->db->simple_query($str_query)){				
							die('Error delete detail jurnal (Sales Delivery / Delivery Now)');
						}
					}
					
					// Insert data detail jurnal tahap 1
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5) - 4, 
											IF(mscs_jenis = 'A', (SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUA'),
													(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUR')),
											ROUND((dtsd_nett * dtsd_qtykrm), 4),
											0,
											'',
											''
											FROM dt_sales_dlv						
											LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
											LEFT JOIN ms_customer ON mscs_no = trsd_mscs_no										
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."')";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal Sales Delivery / Delivery Now (Tahap 1)');
						}
					}

					// Insert data detail jurnal tahap 2
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5) - 3, 
											IF(mscs_jenis = 'A', mskt_msap_no_pja, mskt_msap_no_pjr),
											0,
											ROUND((dtsd_bftax * dtsd_qtykrm), 4),
											'',
											''
											FROM dt_sales_dlv						
											LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
											LEFT JOIN ms_customer ON mscs_no = trsd_mscs_no										
											LEFT JOIN ms_kategori ON mskt_no = substr(dtsd_mspd_no, 1, 1)
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."')";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal Sales Delivery / Delivery Now (Tahap 2)');
						}
					}

					// Insert data detail jurnal tahap 3
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5) - 2, 
											(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PPNK'),
											0,
											round(
											(SELECT IFNULL(dtju_debet, 0) FROM dt_jurnal WHERE dtju_no = '".$data_dtsd[$key]['trju_no']. "' AND dtju_seq = (dtsd_seq * 5) - 4)
											-
											(SELECT IFNULL(dtju_kredit, 0) FROM dt_jurnal WHERE dtju_no = '".$data_dtsd[$key]['trju_no']. "' AND dtju_seq = (dtsd_seq * 5) - 3)
											, 4),										
											'',
											''
											FROM dt_sales_dlv																
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."')";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal Sales Delivery / Delivery Now (Tahap 3)');
						}
					}

					// Insert data detail jurnal tahap 4
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5) - 1, 
											IF(mscs_jenis = 'A', mskt_msap_no_hpa, mskt_msap_no_hpr),
											ROUND((dtsd_hpp * dtsd_qtykrm), 4),
											0,
											'',
											''
											FROM dt_sales_dlv
											LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
											LEFT JOIN ms_customer ON mscs_no = trsd_mscs_no
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtsd_mspd_no, 1, 1)				
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."')";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal Sales Delivery / Delivery Now (Tahap 4)');
						}
					}

					// Insert data detail jurnal tahap 5
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5), 
											mskt_msap_no_inv,
											0,
											ROUND((dtsd_hpp * dtsd_qtykrm), 4),
											'',
											''
											FROM dt_sales_dlv						
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtsd_mspd_no, 1, 1)				
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."')";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal Sales Delivery / Delivery Now (Tahap 5)');
						}	
					}

					echo ($key + 1). ' - Berhasil update jurnal (Delivery Now) SD # '. $data_dtsd[$key]['trsd_no'];
					echo '<br>';			
				}				
			}
		}

		// PROSES UPDATE JURNAL SALES DELIVERY (CONFIRM DELIVERY)----------------------------------------------------------		
		if($vok){
			$str_query = "SELECT DISTINCT trsd_no, trju_no FROM dt_sales_dlv
							LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
							LEFT JOIN ms_produk ON mspd_no = dtsd_mspd_no
							LEFT JOIN tr_jurnal ON trju_tipe = 'A' AND trju_reftipe = 'DR' AND trju_refno = CONCAT(trsd_no, 'DR')
							WHERE trsd_void = 0
							AND trsd_tglbalik <> '0000-00-00'
							AND mspd_paket = 'Y'
							AND trju_no IS NOT NULL
							AND dtsd_qtyrej <> 0";

			$query = $this->db->query($str_query);
			$data_dtsd = array();			

			if($query->num_rows() > 0){
				$data_dtsd = $query->result_array();												

				echo '<br>';
				echo 'CONFIRM DELIVERY -----------------';
				echo '<br>';
				echo $query->num_rows(). ' DATA';
				echo '<br>';

				foreach ($data_dtsd as $key => $value) {
					
					// Delete detail jurnal
					if($vok){
						$str_query = "DELETE FROM dt_jurnal
										WHERE dtju_no = '".$data_dtsd[$key]['trju_no']."'";					

						if(!$this->db->simple_query($str_query)){											
							die('Error delete detail jurnal (Sales Delivery / Confirm Delivery)');
						}	
					}

					// Insert data detail jurnal tahap 1
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5) - 4, 
											IF(mscs_jenis = 'A', mskt_msap_no_pja, mskt_msap_no_pjr),
											ROUND((dtsd_bftax * dtsd_qtyrej), 4),
											0,
											'',
											''
											FROM dt_sales_dlv						
											LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
											LEFT JOIN ms_customer ON mscs_no = trsd_mscs_no										
											LEFT JOIN ms_kategori ON mskt_no = substr(dtsd_mspd_no, 1, 1)
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."'
											AND dtsd_qtyrej <> 0)";
						if(!$this->db->simple_query($str_query)){							
							die('Error create detail jurnal Sales Delivery / Confirm Delivery (Tahap 1)');
						}
					}

					// Insert data detail jurnal tahap 3
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5) - 2, 
											IF(mscs_jenis = 'A', (SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUA'),
													(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUR')),
											0,
											ROUND((dtsd_nett * dtsd_qtyrej), 4),
											'',
											''
											FROM dt_sales_dlv						
											LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
											LEFT JOIN ms_customer ON mscs_no = trsd_mscs_no										
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."'
											AND dtsd_qtyrej <> 0)";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal Sales Delivery / Confirm Delivery (Tahap 3)');
						}
					}

					// Insert data detail jurnal tahap 2
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5) - 3, 
											(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PPNK'),
											round(
											(SELECT IFNULL(dtju_kredit, 0) FROM dt_jurnal WHERE dtju_no = '".$data_dtsd[$key]['trju_no']. "' AND dtju_seq = (dtsd_seq * 5) - 2)
											-
											(SELECT IFNULL(dtju_debet, 0) FROM dt_jurnal WHERE dtju_no = '".$data_dtsd[$key]['trju_no']. "' AND dtju_seq = (dtsd_seq * 5) - 4)
											, 4),										
											0,
											'',
											''
											FROM dt_sales_dlv																
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."'
											AND dtsd_qtyrej <> 0)";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal Sales Delivery / Confirm Delivery (Tahap 2)');
						}
					}
										

					// Insert data detail jurnal tahap 4
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5) - 1, 
											mskt_msap_no_inv,
											ROUND((dtsd_hpp * dtsd_qtyrej), 4),
											0,
											'',
											''
											FROM dt_sales_dlv						
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtsd_mspd_no, 1, 1)				
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."'
											AND dtsd_qtyrej <> 0)";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal Sales Delivery / Confirm Delivery (Tahap 4)');
						}
					}

					// Insert data detail jurnal tahap 5
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsd[$key]['trju_no']."',
											(dtsd_seq * 5), 
											IF(mscs_jenis = 'A', mskt_msap_no_hpa, mskt_msap_no_hpr),
											0,
											ROUND((dtsd_hpp * dtsd_qtyrej), 4),
											'',
											''
											FROM dt_sales_dlv
											LEFT JOIN tr_sales_dlv ON trsd_no = dtsd_no
											LEFT JOIN ms_customer ON mscs_no = trsd_mscs_no
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtsd_mspd_no, 1, 1)				
											WHERE dtsd_no = '".$data_dtsd[$key]['trsd_no']."'
											AND dtsd_qtyrej <> 0)";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal Sales Delivery / Confirm Delivery (Tahap 5)');
						}
					}

					echo ($key + 1).  ' - Berhasil update jurnal (Confirm Delivery) SD # '. $data_dtsd[$key]['trsd_no'];
					echo '<br>';	
				}				
			}
		}		


		// PROSES UPDATE HPP (DETAIL SALES RETUR)----------------------------------------------------------		
		if($vok){
			// SET dtsr_hpp 
			$str_query = "UPDATE dt_salesret
							LEFT JOIN ms_produk ON mspd_no = dtsr_mspd_no
							LEFT JOIN tr_salesret ON trsr_no = dtsr_no
							SET dtsr_hpp = 0
							WHERE mspd_paket = 'Y'";
			
			if($this->db->simple_query($str_query)){								
				echo '<br>';
				echo '<br>';
				echo 'Berhasil update dtsr_hpp = 0';
				echo '<br>';
			}else{
				die('Error set dtsr_hpp');
			}	
		}

		// PROSES UPDATE JURNAL SALES RETUR----------------------------------------------------------
		if($vok){
			$str_query = "SELECT DISTINCT trsr_no, trju_no 
							FROM dt_salesret
							LEFT JOIN tr_salesret ON trsr_no = dtsr_no 
							LEFT JOIN ms_produk ON mspd_no = dtsr_mspd_no
							LEFT JOIN tr_jurnal ON trju_tipe = 'A'
													AND trju_reftipe = 'SR'
													AND trju_refno = trsr_no						
						WHERE trsr_void = 0
						AND mspd_paket = 'Y'
						AND trju_no IS NOT NULL
						AND trsr_tglterima <> '0000-00-00'";

			$query = $this->db->query($str_query);
			$data_dtsr = array();			

			if($query->num_rows() > 0){
				$data_dtsr = $query->result_array();												

				echo '<br>';
				echo 'SALES RETURN -----------------';
				echo '<br>';
				echo $query->num_rows(). ' DATA';
				echo '<br>';

				foreach ($data_dtsr as $key => $value) {
					
					// Delete detail jurnal
					if($vok){
						$str_query = "DELETE FROM dt_jurnal
										WHERE dtju_no = '".$data_dtsr[$key]['trju_no']."'";					

						if(!$this->db->simple_query($str_query)){				
							die('Error delete detail jurnal (Sales Retur)');
						}	
					}

					// Insert data detail jurnal tahap 1
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsr[$key]['trju_no']."',
											(dtsr_seq * 5) - 4, 
											mskt_msap_no_inv,
											ROUND((dtsr_qtyretur * dtsr_hpp), 4),
											0,
											'',
											''
											FROM dt_salesret						
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtsr_mspd_no, 1, 1)				
											WHERE dtsr_no = '".$data_dtsr[$key]['trsr_no']."')";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal Sales Retur (Tahap 1)');
						}
					}

					// Insert data detail jurnal tahap 2
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsr[$key]['trju_no']."',
											(dtsr_seq * 5) - 3, 
											IF(mscs_jenis = 'A', mskt_msap_no_hpa, mskt_msap_no_hpr),
											0,
											ROUND((dtsr_qtyretur * dtsr_hpp), 4),
											'',
											''
											FROM dt_salesret						
											LEFT JOIN tr_salesret ON trsr_no = dtsr_no
											LEFT JOIN ms_customer ON mscs_no = trsr_mscs_no
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtsr_mspd_no, 1, 1)				
											WHERE dtsr_no = '".$data_dtsr[$key]['trsr_no']."')";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal Sales Retur (Tahap 2)');
						}
					}

					// Insert data detail jurnal tahap 3
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsr[$key]['trju_no']."',
											(dtsr_seq * 5) - 2, 
											IF(mscs_jenis = 'A', mskt_msap_no_sra, mskt_msap_no_srr),
											ROUND((dtsr_qtyretur * dtsr_bftax), 4),
											0,
											'',
											''
											FROM dt_salesret						
											LEFT JOIN tr_salesret ON trsr_no = dtsr_no
											LEFT JOIN ms_customer ON mscs_no = trsr_mscs_no
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtsr_mspd_no, 1, 1)				
											WHERE dtsr_no = '".$data_dtsr[$key]['trsr_no']."')";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal Sales Retur (Tahap 3)');
						}
					}

					// Insert data detail jurnal tahap 5
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsr[$key]['trju_no']."',
											(dtsr_seq * 5), 
											IF(mscs_jenis = 'A' AND trsr_jenis = 'C', (SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'SRCA'),
												IF(mscs_jenis = 'R' AND trsr_jenis = 'C', (SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'SRCR'),
													IF(mscs_jenis = 'A' AND trsr_jenis = 'V', (SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'SRVA'),
														(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'SRVR')
													)	
												)
											),
											0,
											ROUND((dtsr_qtyretur * dtsr_nett), 4),
											'',
											''
											FROM dt_salesret						
											LEFT JOIN tr_salesret ON trsr_no = dtsr_no
											LEFT JOIN ms_customer ON mscs_no = trsr_mscs_no										
											WHERE dtsr_no = '".$data_dtsr[$key]['trsr_no']."')";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal Sales Retur (Tahap 5)');
						}					
					}

					// Insert data detail jurnal tahap 4
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtsr[$key]['trju_no']."',
											(dtsr_seq * 5) - 1, 
											(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PPNK'),
											round(
											(SELECT IFNULL(dtju_kredit, 0) FROM dt_jurnal WHERE dtju_no = '".$data_dtsr[$key]['trju_no']. "' AND dtju_seq = (dtsr_seq * 5))
											-
											(SELECT IFNULL(dtju_debet, 0) FROM dt_jurnal WHERE dtju_no = '".$data_dtsr[$key]['trju_no']. "' AND dtju_seq = (dtsr_seq * 5) - 2)
											, 4),
											0,
											'',
											''
											FROM dt_salesret																
											WHERE dtsr_no = '".$data_dtsr[$key]['trsr_no']."')";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal Sales Retur (Tahap 4)');
						}
					}		

					echo ($key + 1).  ' - Berhasil update jurnal (Sales Return) SR # '. $data_dtsr[$key]['trsr_no'];
					echo '<br>';				
				}				
			}
		}	
		

		// PROSES UPDATE HPP (DETAIL SPK)----------------------------------------------------------		
		if($vok){
			// SET dtspk_hpp 
			$str_query = "UPDATE dt_spk_sp
							LEFT JOIN ms_produk ON mspd_no = dtspk_mspd_no
							LEFT JOIN tr_spk ON trspk_no = dtspk_no
							SET dtspk_hpp = 0							
							WHERE mspd_paket = 'Y'";					

			if($this->db->simple_query($str_query)){								
				echo '<br>';
				echo '<br>';
				echo 'Berhasil update dtspk_hpp = 0';
				echo '<br>';
			}else{
				die('Error set dtspk_hpp');
			}		
		}

		// PROSES UPDATE JURNAL SPK (SPK FINISH)----------------------------------------------------------
		if($vok){
			$str_query = "SELECT DISTINCT trspk_no, trju_no 
							FROM dt_spk_sp
							LEFT JOIN tr_spk ON trspk_no = dtspk_no 
							LEFT JOIN ms_produk ON mspd_no = dtspk_mspd_no
							LEFT JOIN tr_jurnal ON trju_tipe = 'A'
													AND trju_reftipe = 'SP'
													AND trju_refno = CONCAT(trspk_no, 'SP')						
						WHERE trspk_void = 0
						AND trju_no IS NOT NULL
						AND mspd_paket = 'Y'
						AND trspk_tglselesai <> '0000-00-00'";

			$query = $this->db->query($str_query);
			$data_dtspk = array();			

			if($query->num_rows() > 0){
				$data_dtspk = $query->result_array();												

				echo '<br>';
				echo 'SPK -----------------';
				echo '<br>';
				echo $query->num_rows(). ' DATA';
				echo '<br>';

				foreach ($data_dtspk as $key => $value) {
					
					// Delete detail jurnal
					if($vok){
						$str_query = "DELETE FROM dt_jurnal
										WHERE dtju_no = '".$data_dtspk[$key]['trju_no']."'";					

						if(!$this->db->simple_query($str_query)){				
							die('Error delete detail jurnal (SPK / SPK Finish)');
						}
					}
					
					// Insert data detail jurnal tahap 1
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtspk[$key]['trju_no']."',
											(dtspk_seq * 5) - 4, 
											IF(mscs_jenis = 'A', (SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUA'),
													(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUR')),
											ROUND((dtspk_nett * dtspk_qty), 4),
											0,
											'',
											''
											FROM dt_spk_sp						
											LEFT JOIN tr_spk ON trspk_no = dtspk_no
											LEFT JOIN ms_customer ON mscs_no = trspk_mscs_no										
											WHERE dtspk_no = '".$data_dtspk[$key]['trspk_no']."')";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal SPK Tahap 1');
						}
					}

					// Insert data detail jurnal tahap 2
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtspk[$key]['trju_no']."',
											(dtspk_seq * 5) - 3, 
											IF(mscs_jenis = 'A', mskt_msap_no_spa, mskt_msap_no_spr),
											0,
											ROUND((dtspk_bftax * dtspk_qty), 4),
											'',
											''
											FROM dt_spk_sp
											LEFT JOIN tr_spk ON trspk_no = dtspk_no
											LEFT JOIN ms_customer ON mscs_no = trspk_mscs_no										
											LEFT JOIN ms_kategori ON mskt_no = substr(dtspk_mspd_no, 1, 1)
											WHERE dtspk_no = '".$data_dtspk[$key]['trspk_no']."')";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal SPK Tahap 2');
						}
					}

					// Insert data detail jurnal tahap 3
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtspk[$key]['trju_no']."',
											(dtspk_seq * 5) - 2, 
											(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PPNK'),
											0,
											round(
											(SELECT IFNULL(dtju_debet, 0) FROM dt_jurnal WHERE dtju_no = '".$data_dtspk[$key]['trju_no']. "' AND dtju_seq = (dtspk_seq * 5) - 4)
											-
											(SELECT IFNULL(dtju_kredit, 0) FROM dt_jurnal WHERE dtju_no = '".$data_dtspk[$key]['trju_no']. "' AND dtju_seq = (dtspk_seq * 5) - 3)
											, 4),										
											'',
											''
											FROM dt_spk_sp
											WHERE dtspk_no = '".$data_dtspk[$key]['trspk_no']."')";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal SPK Tahap 3');
						}
					}

					// Insert data detail jurnal tahap 4
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtspk[$key]['trju_no']."',
											(dtspk_seq * 5) - 1, 
											IF(mscs_jenis = 'A', mskt_msap_no_hpa, mskt_msap_no_hpr),
											ROUND((dtspk_hpp * dtspk_qty), 4),
											0,
											'',
											''
											FROM dt_spk_sp
											LEFT JOIN tr_spk ON trspk_no = dtspk_no
											LEFT JOIN ms_customer ON mscs_no = trspk_mscs_no
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtspk_mspd_no, 1, 1)				
											WHERE dtspk_no = '".$data_dtspk[$key]['trspk_no']."')";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal SPK Tahap 4');
						}
					}

					// Insert data detail jurnal tahap 5
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek) 
										(SELECT '".
											$data_dtspk[$key]['trju_no']."',
											(dtspk_seq * 5), 
											mskt_msap_no_inv,
											0,
											ROUND((dtspk_hpp * dtspk_qty), 4),
											'',
											''
											FROM dt_spk_sp
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtspk_mspd_no, 1, 1)				
											WHERE dtspk_no = '".$data_dtspk[$key]['trspk_no']."')";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal SPK Tahap 5');
						}	
					}	

					echo ($key + 1).  ' - Berhasil update jurnal (SPK) SPK # '. $data_dtspk[$key]['trspk_no'];
					echo '<br>';							
				}				
			}
		}

		

		// PROSES UPDATE HPP (DETAIL STOCK ADJUSTMENT)----------------------------------------------------------
		if($vok){
			// SET dtas_hpp 
			$str_query = "UPDATE dt_adjstok
							LEFT JOIN ms_produk ON mspd_no = dtas_mspd_no
							LEFT JOIN tr_adjstok ON tras_no = dtas_no
							SET dtas_hpp = 0
							WHERE mspd_paket = 'Y'";				

			if($this->db->simple_query($str_query)){								
				echo '<br>';
				echo '<br>';
				echo 'Berhasil update dtas_hpp = 0';
				echo '<br>';
			}else{
				die('Error set dtas_hpp');
			}		
		}

		// PROSES UPDATE JURNAL STOCK ADJUSTMENT----------------------------------------------------------
		if($vok){
			$str_query = "SELECT DISTINCT tras_no, trju_no 
							FROM dt_adjstok
							LEFT JOIN tr_adjstok ON tras_no = dtas_no 
							LEFT JOIN ms_produk ON mspd_no = dtas_mspd_no 
							LEFT JOIN tr_jurnal ON trju_tipe = 'A'
													AND trju_reftipe = 'AS'
													AND trju_refno = CONCAT(tras_no, 'AS')
						WHERE tras_void = 0						
						AND trju_no IS NOT NULL
						AND mspd_paket = 'Y'
						AND CONVERT(tras_tgl, DATE) <> '0000-00-00'";

			$query = $this->db->query($str_query);
			$data_dtas = array();			

			if($query->num_rows() > 0){
				$data_dtas = $query->result_array();												

				echo '<br>';
				echo 'Stock Adjustment -----------------';
				echo '<br>';
				echo $query->num_rows(). ' DATA';
				echo '<br>';

				foreach ($data_dtas as $key => $value) {
					
					// Delete detail jurnal
					if($vok){
						$str_query = "DELETE FROM dt_jurnal
										WHERE dtju_no = '".$data_dtas[$key]['trju_no']."'";					

						if(!$this->db->simple_query($str_query)){										
							die('Error delete detail jurnal (Stock Adjustment)');
						}	
					}

					// Insert data detail jurnal tahap 1
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
										(SELECT '".
											$data_dtas[$key]['trju_no']."',
											(dtas_seq * 2) - 1, 
											mskt_msap_no_inv,
											ROUND((dtas_qty * dtas_hpp), 4),
											0,
											'',
											''
											FROM dt_adjstok
											LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(dtas_mspd_no, 1, 1)
											WHERE dtas_no = '".$data_dtas[$key]['tras_no']."')";
						if(!$this->db->simple_query($str_query)){							
							die('Error create detail jurnal Stock Adjustment (tahap 1)');
						}
					}

					// Insert data detail jurnal tahap 2
					if($vok){
						$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
										(SELECT '".
											$data_dtas[$key]['trju_no']."',
											(dtas_seq * 2), 
											(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'ADJS'),
											0,
											ROUND((dtas_qty * dtas_hpp), 4),
											'',
											''
											FROM dt_adjstok										
											WHERE dtas_no = '".$data_dtas[$key]['tras_no']."')";
						if(!$this->db->simple_query($str_query)){
							die('Error create detail jurnal Stock Adjustment (tahap 2)');
						}	
					}

					echo ($key + 1).  ' - Berhasil update jurnal (Stock Adjustment) ID # '. $data_dtas[$key]['tras_no'];
					echo '<br>';
				}				
			}
		}

	}	
}
