<?php
defined('BASEPATH') or exit  ('No Direct script allowed');

class m_user_log extends MY_Model{

	public function get_user_log_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'msul_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('ms_userlog.*, msus_nm');
		$this->db->from('ms_userlog');		
		$this->db->join('ms_user', 'msus_no = msul_msus_no', 'left');		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function user_log_simpan($data){						
		try{							
			$this->db->insert('ms_userlog', $data);
			return 1;		
		}catch (Exception $e) {
			return 0;
		}		
	}

}