<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_spk extends MY_Model {

	function __construct(){
		parent::__construct();		
		$this->load->model('data_master/m_produk');		
		$this->load->model('setting/m_user_log');
	}

	public function get_spk_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trspk_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('tr_spk.*, mscs_nm, mspd_nm, mscs_npwp, mscs_almt_jln, mscs_almt_kota, mscs_almt_kota');
		$this->db->from('tr_spk');		
		$this->db->join('ms_produk','mspd_no = trspk_mspd_no', 'left');		
		$this->db->join('ms_customer','mscs_no = trspk_mscs_no', 'left');				

		$query_string = '';

		//SPK status
		//1. SPK-FINISH
		//2. SPK-UNFINISHED

		if(isset($arr_filter['spk_status'])){
			if($arr_filter['spk_status'] == '1'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'trspk_tglselesai != "0000-00-00"';
			}elseif($arr_filter['spk_status'] == '2'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'trspk_tglselesai = "0000-00-00"';
			}		
			unset($arr_filter['spk_status']);	
		}

		//SPK payment status
		//1. SPK-SETTLED
		//2. SPK-UNSETTLED
		if(isset($arr_filter['spk_payment_status'])){
			if($arr_filter['spk_payment_status'] == '1'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'IFNULL((SELECT SUM(pbspk_jlhbayar) FROM pby_spk WHERE SUBSTRING(pbspk_no,1,12) = trspk_no AND pbspk_void = 0), 0) >= IFNULL((SELECT SUM(dtspk_nett * dtspk_qty) FROM dt_spk_sp WHERE SUBSTRING(dtspk_no,1,12) = trspk_no), 0)';
			}elseif($arr_filter['spk_payment_status'] == '2'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'NOT(IFNULL((SELECT SUM(pbspk_jlhbayar) FROM pby_spk WHERE SUBSTRING(pbspk_no,1,12) = trspk_no AND pbspk_void = 0), 0) >= IFNULL((SELECT SUM(dtspk_nett * dtspk_qty) FROM dt_spk_sp WHERE SUBSTRING(dtspk_no,1,12) = trspk_no), 0))';
			}		
			unset($arr_filter['spk_payment_status']);	
		}

		//TOP status:
		//1. TOP Due Date
		//2. TOP Late Date

		// if(isset($arr_filter['top_status'])){
		// 	if($arr_filter['top_status'] == 1){			
		// 		if($query_string != ''){
		// 			$query_string .= ' AND ';
		// 		}
		// 		$query_string .= ' trspk_toptgl <> 0
		// 							AND (
		// 								IFNULL((SELECT SUM(pbspk_jlhbayar) FROM pby_spk WHERE SUBSTRING(pbspk_no,1,12) = trspk_no AND pbspk_void = 0), 0) 
		// 								< IFNULL((SELECT SUM(dtspk_nett * dtspk_qty) FROM dt_spk_sp WHERE SUBSTRING(dtspk_no,1,12) = trspk_no), 0)
		// 								)
		// 							AND (DATEDIFF(trspk_toptgl, CURDATE()) <= 10
		// 							AND DATEDIFF(trspk_toptgl, CURDATE()) >= 0) ';
		// 	}elseif($arr_filter['top_status'] == 2){
		// 		if($query_string != ''){
		// 			$query_string .= ' AND ';
		// 		}
		// 		$query_string .= ' trspk_toptgl <> 0
		// 							AND (
		// 								IFNULL((SELECT SUM(pbspk_jlhbayar) FROM pby_spk WHERE SUBSTRING(pbspk_no,1,12) = trspk_no AND pbspk_void = 0), 0) 
		// 								< IFNULL((SELECT SUM(dtspk_nett * dtspk_qty) FROM dt_spk_sp WHERE SUBSTRING(dtspk_no,1,12) = trspk_no), 0)
		// 								)
		// 							AND trspk_toptgl < CURDATE()';
		// 	}
		// 	unset($arr_filter['top_status']);	
		// }								

		if(isset($arr_filter['mspd_no'])){			
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x1.* FROM dt_spk_sp x1 WHERE x1.dtspk_no = trspk_no AND x1.dtspk_mspd_no LIKE "%'. $arr_filter['mspd_no']. '%")';							
			unset($arr_filter['mspd_no']);
		}

		if(isset($arr_filter['mspd_nm'])){
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x2.*, a.mspd_nm AS mspd_nm FROM dt_spk_sp x2 LEFT JOIN ms_produk AS a ON a.mspd_no = x2.dtspk_mspd_no WHERE x2.dtspk_no = trspk_no AND a.mspd_nm LIKE "%'. $arr_filter['mspd_nm']. '%")';
			unset($arr_filter['mspd_nm']);
		}

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}

		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			foreach ($arr_filter as $key => $value) {
				if($key == 'trspk_mspd_nm') {
					unset($arr_filter['trspk_mspd_nm']);
					$arr_filter['mspd_nm'] = $value;
				}
			}

			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_spk_dashboard_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trspk_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('tr_spk.*, mscs_nm, mspd_nm, SUM(dtspk_nett * dtspk_qty) as trspk_total');
		$this->db->from('dt_spk_sp');		
		$this->db->join('tr_spk','trspk_no = dtspk_no', 'left');		
		$this->db->join('ms_produk','mspd_no = trspk_mspd_no', 'left');		
		$this->db->join('ms_customer','mscs_no = trspk_mscs_no', 'left');				

		if(isset($arr_filter['spk_status'])){
			if($arr_filter['spk_status'] == 1){
				$this->db->where('trspk_tglselesai !=', '0000-00-00');				
			}

			if($arr_filter['spk_status'] == 2){
				$this->db->where('trspk_tglselesai', '0000-00-00');				
			}
			unset($arr_filter['spk_status']);
		}

		if(isset($arr_filter['top_status'])){
			if($arr_filter['top_status'] == 1){
				$query_string = '(trspk_toptgl <> 0) AND (DATEDIFF(trspk_toptgl, CURDATE()) <= 10 AND DATEDIFF(trspk_toptgl, CURDATE()) >= 0)';
				$this->db->where($query_string, null, false);				
			}

			if($arr_filter['top_status'] == 2){
				$query_string = '(trspk_toptgl <> 0) AND (trspk_toptgl < CURDATE())';
				$this->db->where($query_string, null, false);				
			}			
			unset($arr_filter['top_status']);
		}		

		$query_string = '';								

		if(isset($arr_filter['mspd_no'])){			
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x1.* FROM dt_spk_sp x1 WHERE x1.dtspk_no = trspk_no AND x1.dtspk_mspd_no LIKE "%'. $arr_filter['mspd_no']. '%")';							
			unset($arr_filter['mspd_no']);
		}

		if(isset($arr_filter['mspd_nm'])){
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x2.*, a.mspd_nm AS mspd_nm FROM dt_spk_sp x2 LEFT JOIN ms_produk AS a ON a.mspd_no = x2.dtspk_mspd_no WHERE x2.dtspk_no = trspk_no AND a.mspd_nm LIKE "%'. $arr_filter['mspd_nm']. '%")';
			unset($arr_filter['mspd_nm']);
		}

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}

		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			foreach ($arr_filter as $key => $value) {
				if($key == 'trspk_mspd_nm') {
					unset($arr_filter['trspk_mspd_nm']);
					$arr_filter['mspd_nm'] = $value;
				}
			}

			$this->db->like($arr_filter);			
		}	

		$this->db->group_by('dtspk_no'); 	
		$this->db->having('(SELECT IFNULL(SUM(pbspk_jlhbayar), 0) FROM pby_spk WHERE SUBSTRING(pbspk_no,1,12) = trspk_no AND pbspk_void = 0) < SUM(dtspk_nett * dtspk_qty)'); 	
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_spk_toplist($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'tpspk_tgljatuhtempo', $sort = 'DESC'){
		if(!$is_count){
			$this->db->limit($per_page, $offset);		
		}
		$this->db->select('*');
		$this->db->from('top_spk');		
		$this->db->join('tr_spk','trspk_no = tpspk_no', 'left');
		$this->db->join('ms_customer', 'ms_customer.mscs_no = tr_spk.trspk_mscs_no','left');				

		//TOP Status
		//1. Current Date
		//2. Late Date

		if(isset($arr_filter['topdate_status'])){					
			if($arr_filter['topdate_status'] == 1){
				// $this->db->where(array('tpspk_tgljatuhtempo' => date('Y-m-d'), 'trspk_void'=>0));
				$query_string = ' (DATEDIFF(tpspk_tgljatuhtempo, "'.date('Y-m-d').'") <= 3) AND (DATEDIFF(tpspk_tgljatuhtempo, "'.date('Y-m-d').'") >= 0) AND (IFNULL((SELECT SUM(pbspk_jlhbayar) FROM pby_spk WHERE SUBSTRING(pbspk_no,1,12) = tpspk_no AND pbspk_void = 0), 0) < IFNULL((SELECT SUM(dtspk_nett * dtspk_qty) FROM dt_spk_sp WHERE SUBSTRING(dtspk_no,1,12) = tpspk_no), 0)) AND (tpspk_aktif ="Y") ';
				$this->db->where($query_string, null, false);
			}

			if($arr_filter['topdate_status'] == 2){				
				$query = ' (tpspk_tgljatuhtempo < CURDATE()) AND (IFNULL((SELECT SUM(pbspk_jlhbayar) FROM pby_spk WHERE SUBSTRING(pbspk_no,1,12) = tpspk_no AND pbspk_void = 0), 0) < IFNULL((SELECT SUM(dtspk_nett * dtspk_qty) FROM dt_spk_sp WHERE SUBSTRING(dtspk_no,1,12) = tpspk_no), 0)) AND (tpspk_aktif ="Y") ';
				$this->db->where($query, null, false);
			}
			unset($arr_filter['topdate_status']);
		}

		$this->db->where(array('trspk_void'=>0));

		if(count($arr_filter) != 0){
			$this->db->like($arr_filter);
		}

		$this->db->order_by($fn, $sort);
		$query = $this->db->get();
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_spk($trspk_no){		
		$data = array();

		//Get jurnal header berdasarkan trju_no	
		$this->db->select('*, tr_sales_dlv.*, dt_sales_dlv.*, mscb_no, mscb_nm, mspd_nm, mscs_nm, mscs_jenis, u1.msus_nm as msus_nm, u2.msus_nm as finishusr_nm,
							EXISTS(SELECT trsv_no FROM tr_spk_visit WHERE SUBSTRING(trsv_no, 1, 12) = "'.$trspk_no.'" AND trsv_void = 0) AS is_spkvisitcreated,
							EXISTS(SELECT trsv_tglvisituntil FROM tr_spk_visit WHERE SUBSTRING(trsv_no, 1, 12) = "'.$trspk_no.'" AND trsv_tglvisituntil = "0000-00-00" AND trsv_void = 0) AS is_notconfvisit, 
							IFNULL((SELECT SUM(dtspk_nett * dtspk_qty) FROM dt_spk_sp WHERE SUBSTRING(dtspk_no,1,12) = "'.$trspk_no.'"),0) AS total_spk,
							IFNULL((SELECT SUM(pbspk_jlhbayar) FROM pby_spk WHERE SUBSTRING(pbspk_no,1,12) = "'.$trspk_no.'" AND pbspk_void = 0),0) AS total_bayar');
		$this->db->from('tr_spk');		
		// $this->db->join('dt_sales_dlv','dtsd_noserial = trspk_noserial', 'left');
		$this->db->join('dt_sales_dlv','dtsd_no = trspk_dtsd_no and dtsd_seq = trspk_dtsd_seq', 'left');
		$this->db->join('tr_sales_dlv','trsd_no = dtsd_no', 'left');
		$this->db->join('ms_user u1','u1.msus_no = trspk_msus_no', 'left');
		$this->db->join('ms_user u2','u2.msus_no = trspk_finishusr', 'left');
		$this->db->join('ms_cabang','mscb_no = trspk_mscb_no', 'left');
		$this->db->join('ms_produk','mspd_no = trspk_mspd_no', 'left');
		$this->db->join('ms_customer','mscs_no = trspk_mscs_no', 'left');
		// $this->db->join('tr_jurnal AS a', 'a.trju_refno = CONCAT(tr_spk.trspk_no, "SP")','left');
		// $this->db->join('tr_jurnal AS b', 'b.trju_refno = CONCAT(tr_spk.trspk_no, "SC")','left');
		$this->db->where('trspk_no',$trspk_no);
		
		$query = $this->db->get();

		if($query->num_rows() > 0){
			$result = $query->result_array();	
			$data['header'] = $result[0];
		}

		//Get top SPK berdasarkan trspk_no	
		$query = $this->db->get_where('top_spk', array('tpspk_no' => $trspk_no));
		if($query->num_rows() > 0){
			$data['top_spk'] = $query->result_array();
		}
		
		//Get spk detail berdasarkan dtspk_no	
		$this->db->select('dt_spk_sp.*, mskt_statusinv, mspd_nm, mspd_reqserialno, msst_qty, mskt_msap_no_inv, mskt_msap_no_pjr, mskt_msap_no_hpr, mskt_msap_no_pja, mskt_msap_no_hpa, mspd_hpp,
							mskt_discnonagen1, mskt_discnonagen2, mskt_discnonagen3, mskt_discagen1, mskt_discagen2, mskt_discagen3, mdpp_qty');
		$this->db->from('dt_spk_sp');
		$this->db->join('ms_produk', 'mspd_no = dtspk_mspd_no','left');
		$this->db->join('tr_spk', 'trspk_no = dtspk_no','left');					
		$this->db->join('ms_stok', 'msst_mspd_no = dtspk_mspd_no AND msst_msgd_no = trspk_msgd_no','left');
		$this->db->join('ms_kategori', 'mskt_no = SUBSTRING(dtspk_mspd_no, 1,1)','left');
		$this->db->join('md_paket_prod', 'md_paket_prod.mdpp_no = dt_spk_sp.dtspk_mdpp_no AND md_paket_prod.mdpp_mspd_no = dt_spk_sp.dtspk_mspd_no','left');
		$this->db->where('dtspk_no',$trspk_no);
		$this->db->order_by('dtspk_seq', 'ASC');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail_prod'] = $detail;
		}

		//Get spk account detail berdasarkan trspk_no
		$this->db->select('dt_spk_accper.*, msap_nm');
		$this->db->from('dt_spk_accper');
		$this->db->join('ms_accper', 'msap_no = dtspkap_msap_no','left');
		$this->db->where('dtspkap_no',$trspk_no);
		$this->db->order_by('dtspkap_seq', 'ASC');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail_acc'] = $detail;
		}

		//Get spk payment berdasarkan trspk_no
		$this->db->select('*');
		$this->db->from('pby_spk');		
		$this->db->where('SUBSTRING(pbspk_no, 1, 12) =',$trspk_no);
		$this->db->where('pbspk_void',0);
		$this->db->order_by('pbspk_no', 'ASC');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['pby_spk'] = $detail;
		}

		if(count($data) > 0){
			return $data;
		}else{
			return false;
		}
	}

	public function spk_kode_auto($trspk_kode_depan){
		$this->db->select_max("trspk_no");
		$this->db->like("trspk_no", $trspk_kode_depan, "after");
		$query = $this->db->get("tr_spk");
		if ($query->num_rows() == 0){
			return $trspk_kode_depan. "0001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['trspk_no'];
			$nomor = ((int) substr($kode, 8)) + 1;			
			return $trspk_kode_depan. sprintf("%'.04d", $nomor);
		}
	}

	public function spk_payment_kode_auto($trspk_no){
		$this->db->select_max("pbspk_no");
		$this->db->like("pbspk_no", $trspk_no, "after");
		$query = $this->db->get("pby_spk");
		if ($query->num_rows() == 0){
			return $trspk_no. "-BY01";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['pbspk_no'];
			$nomor = ((int) substr($kode, 15)) + 1;			
			return $trspk_no. '-BY'. sprintf("%'.02d", $nomor);
		}
	}

	public function get_spk_cekint($trspk_no, $trspk_cekint){
		$query = $this->db->get_where('tr_spk', array('trspk_no' => $trspk_no, 'trspk_cekint' => $trspk_cekint));
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}		
	}		

	public function set_spk_cekint($trspk_no){		
		//Update trspk_cekint di tabel tr_spk
		$this->db->where('trspk_no', $trspk_no);
		$this->db->update('tr_spk', array('trspk_cekint' => rand(0,10000)));
	}		

	private function insert_data($data){
		// Generate CekInt
		//Insert data header spk
		$data['header']['trspk_cekint'] = rand(0,10000);
		$this->db->insert('tr_spk',$data['header']);

		//Insert data top SPK
		if(isset($data['top_spk'])){
			for ($i=0; $i < count($data['top_spk']) ; $i++) {										
			    $this->db->insert('top_spk',$data['top_spk'][$i]);											
			}			
		}
		
		//Insert data detail spk
		if(isset($data['detail'])){				
			foreach ($data['detail'] as $key => $value) {
				$data['detail'][$key]['dtspk_hpp'] = $this->m_produk->get_hpp($data['detail'][$key]['dtspk_mspd_no']);											    
			    $this->db->insert('dt_spk_sp',$data['detail'][$key]);				    
			}									
		}		

		//Insert data detail account spk
		if(isset($data['detail_acc'])){
			$seq = 1;
			foreach ($data['detail_acc'] as $key => $value) {
				$data['detail_acc'][$key]['dtspkap_seq'] = $seq;					
			   	$this->db->insert('dt_spk_accper',$data['detail_acc'][$key]);	
			   	$seq += 1;
			}
		}		
	}

	private function update_data($data){				
		// Generate CekInt
		//Update data header spk
		$data['header']['trspk_cekint'] = rand(0,10000);
		$this->db->where('trspk_no', $data['header']['trspk_no']);
		$this->db->update('tr_spk', $data['header']);

		//Delete data detail top SPK
		$this->db->delete('top_spk', array('tpspk_no' => $data['header']['trspk_no']));								

		//Insert data top SPK
		if(isset($data['top_spk'])){
			for ($i=0; $i < count($data['top_spk']) ; $i++) {										
			    $this->db->insert('top_spk',$data['top_spk'][$i]);											
			}			
		}			

		// Delete data dt_spk_sp lama
		$this->db->delete('dt_spk_sp', array('dtspk_no' => $data['header']['trspk_no']));

		// Insert data ke dt_spk_sp		
		if(isset($data['detail'])){	
			foreach ($data['detail'] as $key => $value) {
				$data['detail'][$key]['dtspk_hpp'] = $this->m_produk->get_hpp($data['detail'][$key]['dtspk_mspd_no']);
			    $this->db->insert('dt_spk_sp',$data['detail'][$key]);				    
			}									
		}							

		// Delete data dt_spk_accper lama
		$this->db->delete('dt_spk_accper', array('dtspkap_no' => $data['header']['trspk_no']));

		//Insert data detail account spk
		if(isset($data['detail_acc'])){
			$seq = 1;
			foreach ($data['detail_acc'] as $key => $value) {
				$data['detail_acc'][$key]['dtspkap_seq'] = $seq;					
			   	$this->db->insert('dt_spk_accper',$data['detail_acc'][$key]);	
			   	$seq += 1;
			}
		}		
	}

	private function save_update_hpp($trspk_no, $i, $trhpp_refjenis){
		$trhpp_tgl = date('Y-m-d H:i:s');

		$query = "INSERT INTO tr_his_hpp(trhpp_tgl, trhpp_refjenis, trhpp_refno, trhpp_mspd_no, trhpp_qtyawal, trhpp_hppawal, trhpp_qtytrans, trhpp_totaltrans)
							(SELECT '".$trhpp_tgl."',
									'".$trhpp_refjenis."',
									'".$trspk_no."',
									D.dtspk_mspd_no, 
									(SELECT SUM(S.msst_qty) FROM ms_stok S WHERE S.msst_mspd_no = D.dtspk_mspd_no),
									 P.mspd_hpp,
									 SUM(".$i." * D.dtspk_qty),
									ROUND(SUM((".$i." * D.dtspk_qty) * D.dtspk_hpp), 4)
							FROM dt_spk_sp D 
							LEFT JOIN ms_produk P 
							ON P.mspd_no = D.dtspk_mspd_no 
							LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtspk_mspd_no,1,1)
							WHERE D.dtspk_no = '".$trspk_no."'
							AND D.dtspk_statuspaket <> 'P'
							AND D.dtspk_qty <> 0
							AND KT.mskt_statusinv = 'Y'
							GROUP BY D.dtspk_mspd_no, D.dtspk_hpp)";

		$this->db->simple_query($query);

		$query = "UPDATE tr_his_hpp 
					SET trhpp_totalawal = ROUND((trhpp_qtyawal * trhpp_hppawal), 4),
						trhpp_hppakhir = IF(
							(trhpp_qtyawal + (trhpp_qtytrans)) <> 0,
							ROUND(
								((trhpp_qtyawal * trhpp_hppawal) + (trhpp_totaltrans))
								 /
								 (trhpp_qtyawal + (trhpp_qtytrans)), 4), trhpp_hppawal)
					WHERE trhpp_tgl = '".$trhpp_tgl."'
					AND trhpp_refjenis = '".$trhpp_refjenis."'
					AND trhpp_refno = '".$trspk_no."'";

		$this->db->simple_query($query);

		$query = "UPDATE ms_produk P 
							SET P.mspd_hpp = IFNULL((SELECT trhpp_hppakhir FROM tr_his_hpp 
										WHERE trhpp_tgl = '".$trhpp_tgl."'
										AND trhpp_refjenis = '".$trhpp_refjenis."'
										AND trhpp_refno = '".$trspk_no."'
										AND trhpp_mspd_no = P.mspd_no), P.mspd_hpp)
				WHERE P.mspd_no IN
				(SELECT dtspk_mspd_no FROM dt_spk_sp D
				LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtspk_mspd_no,1,1)
				WHERE D.dtspk_no = '".$trspk_no."'
				AND D.dtspk_qty <> 0
				AND D.dtspk_statuspaket <> 'P'
				AND KT.mskt_statusinv = 'Y')";

		$this->db->simple_query($query);
	}

	private function update_hpp($trspk_no, $i){
		$query = "UPDATE ms_produk SET mspd_hpp =ROUND("
									."((mspd_hpp * (SELECT SUM(A.msst_qty) FROM ms_stok A WHERE A.msst_mspd_no = ms_produk.mspd_no))"
									." +"
									." (SELECT (".$i." * SUM(B.dtspk_qty * B.dtspk_hpp)) FROM dt_spk_sp B"
										." WHERE B.dtspk_no = '".$trspk_no."'"
										." AND B.dtspk_mspd_no = ms_produk.mspd_no))"
									." /"
									." ((SELECT SUM(C.msst_qty) FROM ms_stok C WHERE C.msst_mspd_no = ms_produk.mspd_no)"
									 ." +"
									 ." (SELECT (".$i." * SUM(D.dtspk_qty)) FROM dt_spk_sp D"
										." WHERE D.dtspk_no = '".$trspk_no."'"
										." AND D.dtspk_mspd_no= ms_produk.mspd_no)), 4)"
									 
									." WHERE ms_produk.mspd_no IN"
										." (SELECT E.dtspk_mspd_no FROM dt_spk_sp E"
										." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(E.dtspk_mspd_no,1,1)"
										." WHERE E.dtspk_no = '".$trspk_no."'"
										." AND KT.mskt_statusinv = 'Y')"
									
									." AND ((SELECT SUM(F.msst_qty) FROM ms_stok F WHERE F.msst_mspd_no = ms_produk.mspd_no)"
										." +"
										." (SELECT (".$i." * SUM(G.dtspk_qty)) FROM dt_spk_sp G"
										." WHERE G.dtspk_no = '".$trspk_no."'"
										." AND G.dtspk_mspd_no= ms_produk.mspd_no)) <> 0";

		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}		
		
	}

	public function update_stok($trspk_no, $i){
		$query = "INSERT INTO ms_stok(msst_mspd_no, msst_msgd_no, msst_qty)"
						." (SELECT DISTINCT A.dtspk_mspd_no, B.trspk_msgd_no, 0 FROM dt_spk_sp A"
						." LEFT JOIN tr_spk B ON B.trspk_no = A.dtspk_no"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(A.dtspk_mspd_no, 1,1)"						
						." WHERE A.dtspk_no = '".$trspk_no."'"
						." AND A.dtspk_statuspaket <> 'P'"
						." AND KT.mskt_statusinv = 'Y'"
						." AND NOT EXISTS(SELECT C.* FROM ms_stok C"
								." WHERE C.msst_mspd_no = A.dtspk_mspd_no"
								." AND C.msst_msgd_no= B.trspk_msgd_no))";

		$this->db->simple_query($query);		

		$query = "UPDATE ms_stok SET msst_qty = msst_qty +"
						." (".$i." * (SELECT SUM(A.dtspk_qty) FROM dt_spk_sp A"
						." WHERE A.dtspk_no = '".$trspk_no."'"
						." AND A.dtspk_mspd_no = ms_stok.msst_mspd_no))"
				." WHERE ms_stok.msst_mspd_no IN"
						." (SELECT B.dtspk_mspd_no FROM dt_spk_sp B"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(B.dtspk_mspd_no,1,1)"
						." WHERE B.dtspk_no = '".$trspk_no."'"
						." AND B.dtspk_statuspaket <> 'P'"
						." AND KT.mskt_statusinv = 'Y')"
				." AND ms_stok.msst_msgd_no ="
						." (SELECT C.trspk_msgd_no FROM tr_spk C"
						." WHERE C.trspk_no = '".$trspk_no."')";				
			
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}							
	}		

	public function spk_simpan($data){
		try{
			if($data['action'] == 'NEW'){
				$this->insert_data($data);
				$this->save_update_hpp($data['header']['trspk_no'], -1, 'SPN');
				// $this->update_hpp($data['header']['trspk_no'], -1);
				$this->update_stok($data['header']['trspk_no'], -1);
			}

			if($data['action'] == 'EDIT'){
				$this->save_update_hpp($data['header']['trspk_no'], 1, 'SE1');
				// $this->update_hpp($data['header']['trspk_no'], 1);
				$this->update_stok($data['header']['trspk_no'], 1);
				$this->update_data($data);
				$this->save_update_hpp($data['header']['trspk_no'], -1, 'SE2');
				// $this->update_hpp($data['header']['trspk_no'], -1);
				$this->update_stok($data['header']['trspk_no'], -1);				
			}

			if($data['action'] == 'FINISH_SPK'){
				$this->finish_spk($data);
				$this->jurnal_simpan($data);
			}

			if($data['action'] == 'CANCEL_FINISH_SPK'){
				$this->cancel_finish_spk($data);
				$this->jurnal_hapus($data);
			}

			if($data['action'] == 'VOID'){				
				$this->save_update_hpp($data['header']['trspk_no'], 1, 'SPV');	
				// $this->update_hpp($data['header']['trspk_no'], 1);	
				$this->update_stok($data['header']['trspk_no'], 1);				
				$this->void_spk($data);
				$this->jurnal_spk_hapus($data);				
			}

			// Simpan userlog
			$this->user_log_simpan($data);

			if($data['action'] == 'STCOPY'){					
				$this->db->where('trspk_no', $data['header']['trspk_no']);
				$this->db->update('tr_spk', array('trspk_stcopy'=>$data['header']['trspk_stcopy']));
			}

			return 1;
		} catch (Exception $e) {
			return 0;
		}	
	}

	private function user_log_simpan($data){		
		//Insert user log
		if(isset($data['userlog'])){			
			foreach ($data['userlog'] as $key => $value) {				
				$this->db->insert('ms_userlog',$data['userlog'][$key]);
			}
		}
	}

	private function void_spk($data){
		$this->db->where('trspk_no', $data['header']['trspk_no']);
		$this->db->update('tr_spk', array('trspk_void'=>1));
	}

	private function finish_spk($data){		
		$this->db->where('trspk_no', $data['header']['trspk_no']);
		$this->db->update('tr_spk', $data['header']);
	}

	private function cancel_finish_spk($data){
		$this->db->where('trspk_no', $data['header']['trspk_no']);
		$this->db->update('tr_spk', array('trspk_tglselesai'=>0, 'trspk_finishusr'=>'', 'trspk_toptgl'=>0, 'trspk_stcopy'=>$data['header']['trspk_stcopy']));
	}	

	private function jurnal_simpan($data){							
		$trju_tgl = $data['header']['trspk_tglselesai'];
		$trju_tipe = 'A';
		$bulan = substr($trju_tgl, 5, 2);			
		$tahun = substr($trju_tgl, 2, 2);			
		$separator = ($data['temp_fin'] == 'F') ? '-' : '_';
		$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;		

		if(isset($data['jurnal_pj_d'])){
			// Insert data header jurnal
			// Generate CekInt
			$data['jurnal_pj_h']['trju_cekint'] = rand(0,10000);				
			$data['jurnal_pj_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);	
			$this->db->insert('tr_jurnal',$data['jurnal_pj_h']);

			//Insert data detail jurnal		
			$seq = 1;
			foreach ($data['jurnal_pj_d'] as $key => $value) {														
				$data['jurnal_pj_d'][$key]['dtju_no'] = $data['jurnal_pj_h']['trju_no'];
				$data['jurnal_pj_d'][$key]['dtju_seq'] = $seq;
				$this->db->insert('dt_jurnal',$data['jurnal_pj_d'][$key]);
				$seq += 1;
			}				
		}

		if(isset($data['jurnal_acc_d'])){
			// Insert data header jurnal
			// Generate CekInt
			$data['jurnal_acc_h']['trju_cekint'] = rand(0,10000);	
			$data['jurnal_acc_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);
			$this->db->insert('tr_jurnal',$data['jurnal_acc_h']);

			//Insert data detail jurnal		
			$seq = 1;
			foreach ($data['jurnal_acc_d'] as $key => $value) {														
				$data['jurnal_acc_d'][$key]['dtju_no'] = $data['jurnal_acc_h']['trju_no'];
				$data['jurnal_acc_d'][$key]['dtju_seq'] = $seq;
				$this->db->insert('dt_jurnal',$data['jurnal_acc_d'][$key]);
				$seq += 1;
			}				
		}
	}	

	private function jurnal_pembayaran_simpan($data){		

		if($data['action'] == 'SPK_PAYMENT_NEW'){
			// Generate CekInt
			$data['jurnal_h']['trju_cekint'] = rand(0,10000);
			// Insert data header jurnal			
			$this->db->insert('tr_jurnal',$data['jurnal_h']);			
		}

		if($data['action'] == 'SPK_PAYMENT_EDIT'){
			// Update data header jurnal
			$this->db->where('trju_no',$data['jurnal_h']['trju_no']);
			$this->db->update('tr_jurnal',$data['jurnal_h']);
		}

		$this->db->delete('dt_jurnal',array('dtju_no' => $data['jurnal_h']['trju_no']));

		//Insert data detail jurnal
		if(count($data['jurnal_d']) > 0){
			$seq = 1;
			foreach ($data['jurnal_d'] as $key => $detail) {														
				$data['jurnal_d'][$key]['dtju_no'] = $data['jurnal_h']['trju_no'];
				$data['jurnal_d'][$key]['dtju_seq'] = $seq;
				$this->db->insert('dt_jurnal',$data['jurnal_d'][$key]);
				$seq += 1;
			}		
		}		
	}

	public function get_jurnal_pembayaranspk($trspk_no){		
		$this->db->select('*');
		$this->db->from('dt_jurnal');		
		$this->db->join('tr_jurnal','trju_no = dtju_no', 'left');		
		$this->db->join('ms_accper','msap_no = dtju_msap_no', 'left');		
		$this->db->where('SUBSTRING(trju_refno, 1, 12) =', $trspk_no);
		$this->db->where('trju_reftipe', 'PK');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$result['pby_spk'] = $query->result_array();
			return $result['pby_spk'];
		}else{
			return false;
		}
	}	

	public function get_spk_payment($pbspk_no){		
		$this->db->select('pby_spk.*, msus_nm, mscb_nm, IFNULL(trgm_total,0) as trgm_total, IFNULL(trgm_used,0) as trgm_used, trgm_cekint');
		$this->db->from('pby_spk');		
		$this->db->join('ms_user', 'ms_user.msus_no = pby_spk.pbspk_msus_no','left');
		$this->db->join('ms_cabang', 'ms_cabang.mscb_no = pby_spk.pbspk_mscb_no','left');
		$this->db->join('tr_giro_masuk', 'tr_giro_masuk.trgm_no = pby_spk.pbspk_refnopbyr','left');
		$this->db->where(array('pbspk_no' => $pbspk_no));
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}

	public function spk_payment_simpan($data){
		try {					
				if($data['action'] == 'SPK_PAYMENT_NEW'){					
					//Insert data 
					$this->db->insert('pby_spk',$data['header']);
				}

				if($data['action'] == 'SPK_PAYMENT_EDIT'){						
					$pbspk_jenis = $this->get_pbspk_jenis($data['header']['pbspk_no']);

					if($pbspk_jenis == 'G'){
						// Delete used_giro_masuk
						$this->db->delete('used_giro_masuk', array('usgm_refno' => $data['header']['pbspk_no']));					

						// update trgm_used
						$pbspk_refnopbyr = $this->get_pbspk_refnopbyr($data['header']['pbspk_no']);
						$this->m_giro_masuk->update_trgm_used($pbspk_refnopbyr);
					}

					//update pby_spk
					$this->db->where('pbspk_no',$data['header']['pbspk_no']);
					$this->db->update('pby_spk',$data['header']);					
				}

				if($data['header']['pbspk_jenis'] == 'G'){
			    	$data_usgm['usgm_no'] = $data['header']['pbspk_refnopbyr'];						
					$data_usgm['usgm_refno'] = $data['header']['pbspk_no'];
					$data_usgm['usgm_refjenis'] = 'K';
					$data_usgm['usgm_refseq'] = 0;
					$data_usgm['usgm_total'] = $data['header']['pbspk_jlhbayar'];

					$this->db->insert('used_giro_masuk', $data_usgm);				

					// update trgm_used
					$this->m_giro_masuk->update_trgm_used($data['header']['pbspk_refnopbyr']);
					// update cekint
					$this->m_giro_masuk->set_giro_masuk_cekint($data['header']['pbspk_refnopbyr']);
			    }

				$this->jurnal_pembayaran_simpan($data);
				return 1;											
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function spk_payment_void($data){
		try {											
				$this->void_pbyspk($data);
				$this->jurnal_pbyspk_hapus($data);

				if($data['header']['pbspk_jenis'] == 'G'){
					// Delete used_giro_masuk
					$this->db->delete('used_giro_masuk', array('usgm_refno' => $data['header']['pbspk_no']));						

					// update trgm_used
					$pbspk_refnopbyr = $this->get_pbspk_refnopbyr($data['header']['pbspk_no']);
					$this->m_giro_masuk->update_trgm_used($pbspk_refnopbyr);

					// update cekint
					$this->m_giro_masuk->set_giro_masuk_cekint($pbspk_refnopbyr);
				}
			return 1;
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function get_pbspk_jenis($pbspk_no){
		$query = $this->db->get_where('pby_spk', array('pbspk_no' => $pbspk_no));				 
		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result[0]['pbspk_jenis'];
		}
	}

	public function get_pbspk_refnopbyr($pbspk_no){
		$query = $this->db->get_where('pby_spk', array('pbspk_no' => $pbspk_no));				 
		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result[0]['pbspk_refnopbyr'];
		}
	}

	public function get_spk_bycust($mscs_no){		
		$where_sql = "NOT(IFNULL((SELECT SUM(pbspk_jlhbayar) FROM pby_spk WHERE SUBSTRING(pbspk_no,1,12) = trspk_no AND pbspk_void = 0), 0) >= IFNULL((SELECT SUM(dtspk_nett * dtspk_qty) FROM dt_spk_sp WHERE SUBSTRING(dtspk_no,1,12) = trspk_no), 0))";
		$this->db->select('tr_spk.*, mscs_nm, DATE_FORMAT(trspk_tgl, "%Y-%m-%d") as trspk_tgl,
							IFNULL((SELECT SUM(dtspk_nett * dtspk_qty) FROM dt_spk_sp WHERE SUBSTRING(dtspk_no,1,12) = trspk_no), 0) as trspk_total,
							IFNULL((SELECT SUM(pbspk_jlhbayar) FROM pby_spk WHERE SUBSTRING(pbspk_no,1,12) = trspk_no AND pbspk_void = 0), 0) as trspk_terbayar');
		$this->db->from('tr_spk');
		$this->db->join('ms_customer', 'mscs_no = trspk_mscs_no', 'left');
		$this->db->where('trspk_mscs_no', $mscs_no);
		$this->db->where($where_sql, null, false);
		$query = $this->db->get();
				
		return $query->result_array();		
	}

	public function get_spk_payment_bytrfmno($trfm_no){
		$data = array();

		$this->db->select('pby_spk.*, trspk_no, trspk_tgl, trspk_cekint,
							IFNULL((SELECT SUM(dtspk_nett * dtspk_qty) FROM dt_spk_sp WHERE SUBSTRING(dtspk_no,1,12) = trspk_no), 0) as trspk_total,
							IFNULL((SELECT SUM(pbspk_jlhbayar) FROM pby_spk WHERE SUBSTRING(pbspk_no,1,12) = trspk_no AND pbspk_void = 0), 0) as trspk_terbayar');
		$this->db->from('pby_spk');				
		$this->db->join('tr_spk', 'trspk_no = SUBSTRING(pbspk_no, 1, 12)', 'left');				
		$this->db->where('pbspk_refnopbyr',$trfm_no);		
		$this->db->where('pbspk_void',0);		
		$query = $this->db->get();

		if($query->num_rows() > 0){			
			$data = $query->result_array();			
		}	

		return $data;
	}

	private function jurnal_pbyspk_hapus($data){
		if(isset($data['jurnal_h']['trju_no']) && strlen($data['jurnal_h']['trju_no']) > 0){
			$this->db->delete('tr_jurnal', array('trju_no' => $data['jurnal_h']['trju_no']));
			$this->db->delete('dt_jurnal', array('dtju_no' => $data['jurnal_h']['trju_no']));
		}
	}

	private function jurnal_hapus($data){
		$query = "DELETE dtju FROM dt_jurnal dtju
					LEFT JOIN tr_jurnal trju ON trju.trju_no = dtju.dtju_no
					WHERE trju_refno IN ('".$data['header']['trspk_no']."SP','".$data['header']['trspk_no']."SC')";
		$this->db->simple_query($query);

		$query = "DELETE trju FROM tr_jurnal trju 
					WHERE trju_refno IN ('".$data['header']['trspk_no']."SP','".$data['header']['trspk_no']."SC')";
		$this->db->simple_query($query);

		return 1;

		// $query = "DELETE trju, dtju
		// 			FROM dt_jurnal dtju
		// 			LEFT JOIN tr_jurnal trju ON trju.trju_no = dtju.dtju_no
		// 			WHERE trju_refno IN ('".$data['header']['trspk_no']."SP','".$data['header']['trspk_no']."SC')";

		// if($this->db->simple_query($query)){	
		// 	$this->db->delete('tr_jurnal', array('trju_refno'=>$data['header']['trspk_no'].'SP'));
		// 	$this->db->delete('tr_jurnal', array('trju_refno'=>$data['header']['trspk_no'].'SC'));	
		// 	return 1;
		// }else{
		// 	return 0;
		// }		
	}

	private function jurnal_spk_hapus($data){		
		$data = $this->get_jurnal_spk($data['header']['trspk_no']);
		if(isset($data)){
			foreach ($data as $key => $value) {
				if(isset($data[$key]['trju_no']) && strlen($data[$key]['trju_no']) > 0){
					$this->db->delete('tr_jurnal', array('trju_no' => $data[$key]['trju_no']));
					$this->db->delete('dt_jurnal', array('dtju_no' => $data[$key]['trju_no']));
				}		
			}
		} 
		
	}

	private function get_jurnal_spk($trspk_no){
		$this->db->select('trju_no');
		$this->db->from('tr_jurnal');					
		$this->db->where('SUBSTRING(trju_refno, 1, 12) =', $trspk_no);		
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result;
		}
	}

	private function void_pbyspk($data){
		$this->db->where('pbspk_no', $data['header']['pbspk_no']);
		$this->db->update('pby_spk', array('pbspk_void'=>1));
	}

	public function get_dtspk_hpp($dtspk_no, $dtspk_seq){
		$query = $this->db->get_where('dt_spk_sp', array('dtspk_no'=>$dtspk_no, 'dtspk_seq'=>$dtspk_seq));
		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result[0]['dtspk_hpp'];
		}else{
			return 0;
		}
	}

	public function cek_pby_spk_exists($trspk_no){		
		$query = $this->db->get_where('pby_spk', array('substring(pbspk_no, 1, 12) =' => $trspk_no, 'pbspk_void' => 0));
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function top_spk_simpan($data){		
		try{
			//Delete data top SPK
			$this->db->where(array('tpspk_no' => $data['header']['trspk_no']));
			$this->db->delete('top_spk');

			//Insert data top SPK
			if(isset($data['top_spk'])){			
				foreach ($data['top_spk'] as $key => $value) {
					$data['top_spk'][$key]['tpspk_no'] = $data['header']['trspk_no'];
					$this->db->insert('top_spk',$data['top_spk'][$key]);
				}
			}
			return 1;
		}catch (Exception $e) {
			return 0;
		}
	}

	public function get_eksport_csv_efaktur_details($trspk_no){
		$query = 'select dtspk_no, dtspk_mspd_no, dtspk_qty, mspd_nm, 
						 dtspk_bftax, dtspk_tax
					FROM dt_spk_sp
					LEFT JOIN ms_produk ON mspd_no = dtspk_mspd_no
					WHERE dtspk_no = "'.$trspk_no.'" AND dtspk_statuspaket != "K"
					AND dtspk_qty > 0
					order BY dtspk_seq ASC';
		$result = $this->db->query($query)->result_array();			

		return $result;			
	}

	public function get_eksport_csv_efaktur_header($trspk_no){
		$query = 'select trspk_no, trspk_catatan, trspk_alamatnpwp, mscs_nm, mscs_npwp, mscs_almt_jln, mscs_almt_kota, 
					mscs_almt_provinsi, mscs_cp, mscs_telp, trspk_fakturno, trspk_fakturtgl, trspk_tophari,
					IFNULL((SELECT SUM(dtspk_bftax * dtspk_qty) FROM dt_spk_sp WHERE dtspk_no = trspk_no),0) AS dpp_total,
                    IFNULL((SELECT SUM(dtspk_tax * dtspk_qty) FROM dt_spk_sp WHERE dtspk_no = trspk_no),0) AS ppn_total
				  From tr_spk
				  LEFT JOIN ms_customer on mscs_no = trspk_mscs_no
				  WHERE trspk_no = "'.$trspk_no.'" and trspk_void = 0';

		$result = $this->db->query($query)->result_array();			

		return $result;			
	}

	public function get_trspk_terbayar($trspk_no){
		$query = $this->db->query('SELECT IFNULL(SUM(pbspk_jlhbayar), 0) as trspk_terbayar FROM pby_spk WHERE SUBSTRING(pbspk_no,1,12) = "'.$trspk_no.'" AND pbspk_void = 0');
		
		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result[0]['trspk_terbayar'];
		}else{
			return 0;
		}
	}

	public function jurnal_simpan_pbyr_spk($pbspk_no, $pbspk_tglterima, $mssa_kode){
		$vok = true;				

		// Generate kode jurnal
		$bulan = substr($pbspk_tglterima, 5, 2);			
		$tahun = substr($pbspk_tglterima, 2, 2);
		$kd_depan = "JA".$tahun.$bulan.'-';
		$trju_no = $this->m_jurnal->jurnal_kode_auto($kd_depan);		

		// Insert header jurnal
		if($vok){
			$str_query = "INSERT INTO tr_jurnal(
							trju_no,
							trju_tgl,
							trju_tipe,
							trju_catatan,
							trju_refno,
							trju_reftipe,
							trju_void,
							trju_lsupd,
							trju_lsusr,
							trju_cekint,
							trju_msus_no,
							trju_mscb_no,
							trju_fin,
							trju_stcopy,
							trju_lscopy,
							trju_tag)
						(SELECT '".$trju_no."',
								pbspk_tglterima,
								'A',
								SUBSTRING(CONCAT(pbspk_no, '/', trspk_mscs_no, ' - ', mscs_nm), 1, 250),								
								CONCAT(pbspk_no,'PK'),
								'PK',
								0,
								pbspk_lsupd,
								pbspk_lsusr,
								1,
								pbspk_msus_no,
								pbspk_mscb_no,
								'F',
								'R',
								0,
								''
						FROM pby_spk
						LEFT JOIN tr_spk ON trspk_no = SUBSTRING(pbspk_no, 1, 12)
						LEFT JOIN ms_customer ON mscs_no = trspk_mscs_no
						WHERE pbspk_no = '".$pbspk_no."'
						LIMIT 1)";

			if(!$this->db->simple_query($str_query)){					
				echo $str_query; 
				die('Error create header jurnal. '. $pbspk_no);
			}
		}

		// Insert jurnal debet
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq,
								(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = '".$mssa_kode."'),
								pbspk_jlhbayar,
								0,
								'',
								''
								FROM pby_spk
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r
								WHERE pbspk_no = '".$pbspk_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $pbspk_no);
			}
		}

		// Insert jurnal kredit
		if($vok){
			$str_query = "INSERT INTO dt_jurnal(dtju_no,dtju_seq,dtju_msap_no,dtju_debet,dtju_kredit,dtju_catatan,dtju_cek)
							(SELECT '".
								$trju_no."',
								@rownum := @rownum + 1 AS dtju_seq, 
								IF(mscs_jenis = 'A', (SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUA'),
													(SELECT mssa_msap_no FROM ms_set_acc WHERE mssa_kode = 'PIUR')),
								0,
								pbspk_jlhbayar,
								'',
								''
								FROM pby_spk
								CROSS JOIN (SELECT @rownum := (SELECT IFNULL(MAX(dtju_seq), 0) FROM dt_jurnal WHERE dtju_no = '".$trju_no."')) r								
								LEFT JOIN tr_spk ON trspk_no = SUBSTRING(pbspk_no, 1, 12)
								LEFT JOIN ms_customer ON mscs_no = trspk_mscs_no
								WHERE pbspk_no = '".$pbspk_no."')";
			if(!$this->db->simple_query($str_query)){																	
				echo $str_query; 
				die('Error create detail jurnal. '. $pbspk_no);
			}
		}
	}

}