<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_adjstok extends MY_Model {
	private $data_j = array();
	private $data = array();

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_produk');	
		$this->load->model('setting/m_user_log');
	}

	public function get_adjstok_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'tras_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('tr_adjstok.*, msgd_nm, msus_nm, mscb_nm');
		$this->db->join('ms_gudang','ms_gudang.msgd_no = tr_adjstok.tras_msgd_no', 'left');
		$this->db->join('ms_user','ms_user.msus_no = tr_adjstok.tras_msus_no', 'left');
		$this->db->join('ms_cabang','ms_cabang.mscb_no = tr_adjstok.tras_mscb_no', 'left');		
		$this->db->from('tr_adjstok');		

		$query_string = '';

		if(isset($arr_filter['mspd_no'])){			
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x1.* FROM dt_adjstok x1 WHERE x1.dtas_no = tras_no AND x1.dtas_mspd_no LIKE "%'. $arr_filter['mspd_no']. '%")';							
			unset($arr_filter['mspd_no']);
		}

		if(isset($arr_filter['mspd_nm'])){
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x2.*, a.mspd_nm AS mspd_nm FROM dt_adjstok x2 LEFT JOIN ms_produk AS a ON a.mspd_no = x2.dtas_mspd_no WHERE x2.dtas_no = tras_no AND a.mspd_nm LIKE "%'. $arr_filter['mspd_nm']. '%")';
			unset($arr_filter['mspd_nm']);
		}		

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}
		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}	

	public function get_adjstok($tras_no){		
		$data = array();

		//Get adjstok header berdasarkan tras_no	
		$this->db->select('tr_adjstok.*, msus_no, msus_nm, mscb_no, mscb_nm');
		$this->db->from('tr_adjstok');		
		$this->db->join('ms_user','msus_no = tras_msus_no', 'left');
		$this->db->join('ms_cabang','mscb_no = tras_mscb_no', 'left');				
		$this->db->where('tras_no',$tras_no);
		
		$query = $this->db->get();

		if($query->num_rows() > 0){
			$result = $query->result_array();	
			$data['header'] = $result[0];
		}
		
		//Get adjstok detail berdasarkan tras_no	
		$this->db->select('dt_adjstok.*, mspd_nm, tras_msgd_no, msst_qty, mskt_msap_no_inv, mspd_hpp');
		$this->db->from('dt_adjstok');
		$this->db->join('ms_produk', 'mspd_no = dtas_mspd_no','left');		
		$this->db->join('ms_kategori', 'mskt_no = SUBSTRING(dtas_mspd_no,1,1)','left');
		$this->db->join('tr_adjstok', 'tras_no = dtas_no','left');		
		$this->db->join('ms_stok', 'msst_mspd_no = dtas_mspd_no AND msst_msgd_no = tras_msgd_no','left');
		$this->db->where('dtas_no',$tras_no);
		$this->db->order_by('dtas_seq', 'ASC');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail'] = $detail;
		}
		if(count($data) > 0){
			return $data;
		}else{
			return false;
		}
	}

	// public function get_dt_adjstok($dtas_no){

	// 	//Get adjstok detail berdasarkan tras_no	
	// 	$this->db->select('*');
	// 	$this->db->from('dt_adjstok');
	// 	$this->db->join('ms_produk', 'dt_adjstok.dtas_mspd_no = ms_produk.mspd_no','inner');		
	// 	$this->db->where('dtas_no',$dtas_no);
	// 	$query = $this->db->get();				
	// 	return $query->result_array();						
	// }

	public function adjstok_kode_auto($tras_kode_depan){
		$this->db->select_max("tras_no");
		$this->db->like("tras_no", $tras_kode_depan, "after");
		$query = $this->db->get("tr_adjstok");
		if ($query->num_rows() == 0){
			return $tras_kode_depan. "0001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['tras_no'];
			$nomor = ((int) substr($kode, 8)) + 1;			
			return $tras_kode_depan. sprintf("%'.04d", $nomor);
		}
	}

	public function get_adjstok_cekint($tras_no, $tras_cekint){		
		$query = $this->db->get_where('tr_adjstok', array('tras_no' => $tras_no, 'tras_cekint' => $tras_cekint));				 
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}	
	
	public function adjstok_simpan($data){						
		try {									
			$data['header']['tras_cekint'] = rand(0,10000);

			if($data['action'] == 'NEW'){
					//todo list
					//1. Insert header adjstok
					//2. Insert detail adjstok
					//3. Update hpp (+/-)
					//4. Update stok (+/-)
					//5. Set data jurnal
					//6. Create jurnal

					//1. Insert header adjstok										
					$this->db->insert('tr_adjstok',$data['header']);
					//2. Insert detail adjstok
					if(isset($data['detail'])){
						$this->data['detail'] = $data['detail'];
						foreach ($data['detail'] as $key => $value){
							$this->db->insert('dt_adjstok',$data['detail'][$key]);
						}
					}
					//3. Update hpp (+/-)
					$this->save_update_hpp($data['header']['tras_no'], 1, 'ASN');
					// $this->update_hpp($data['header']['tras_no'], 1);
					//4. Update stok (+/-)
					$this->update_stok($data['header']['tras_no'], 1);
					//5. Set data jurnal
					$this->set_data_jurnal($data);
					//6. Create jurnal
					$this->jurnal_simpan($this->data_j);
			}

			if($data['action'] == 'EDIT'){
				//todo list				
				//1. Undo hpp (+/-)
				//2. Undo stok (+/-)
				//3. Update data adjstok header/detail
				//4. Update hpp (+/-)
				//5. Update stok (+/-)
				//6. Set data jurnal
				//7. Update jurnal

				//1. Undo hpp (+/-)
				$this->save_update_hpp($data['header']['tras_no'], -1, 'AE1');
				// $this->update_hpp($data['header']['tras_no'], -1);
				//2. Update stok (+/-)
				$this->update_stok($data['header']['tras_no'], -1);
				//3. Update data adjstok header/detail
				$this->update_data($data);
				//4. Update hpp (+/-)
				$this->save_update_hpp($data['header']['tras_no'], 1, 'AE2');
				// $this->update_hpp($data['header']['tras_no'], 1);
				//5. Update stok (+/-)
				$this->update_stok($data['header']['tras_no'], 1);
				//6. Set data jurnal
				$this->set_data_jurnal($data);
				//7. Update jurnal
				$this->jurnal_simpan($this->data_j);
				// Simpan userlog
				$this->m_user_log->user_log_simpan($data['userlog']);					
			}					

			if($data['action'] == 'VOID'){
				//todo list
				//1. Undo hpp (+/-)
				//2. Undo stok (+/-)
				//3. Void data				
				//4. Delete jurnal

				//1. Undo hpp (+/-)
				$this->save_update_hpp($data['header']['tras_no'], -1, 'ASV');
				// $this->update_hpp($data['header']['tras_no'], -1);
				//2. Update stok (+/-)
				$this->update_stok($data['header']['tras_no'], -1);
				//3. Void data
				$this->db->where('tras_no', $data['header']['tras_no']);
				$this->db->update('tr_adjstok', array('tras_void'=>1, 'tras_cekint' => rand(0, 10000)));
				//4. Delete jurnal
				$this->jurnal_hapus($data);
				// Simpan userlog
				$this->m_user_log->user_log_simpan($data['userlog']);					
			}

			if($data['action'] == 'STCOPY'){
				$this->db->where('tras_no', $data['header']['tras_no']);
				$this->db->update('tr_adjstok', array('tras_stcopy'=>$data['header']['tras_stcopy'], 'tras_cekint' => rand(0, 10000)));
			}						

			return 1;									
		} catch (Exception $e) {
			return 0;
		}		
	}	

	private function update_data($data){		
		$this->db->where('tras_no', $data['header']['tras_no']);
		$this->db->update('tr_adjstok', $data['header']);
		
		$this->db->where(array('dtas_no' => $data['header']['tras_no']));
		$this->db->delete('dt_adjstok');

		if(isset($data['detail'])){
			$this->data['detail'] = $data['detail'];
			foreach ($data['detail'] as $key => $value) {							
				$hpp = $this->m_produk->get_hpp($data['detail'][$key]['dtas_mspd_no']);
				$data['detail'][$key]['dtas_hpp'] = $hpp;
				$this->data['detail'][$key]['dtas_hpp'] = $hpp;
				$this->db->insert('dt_adjstok', $data['detail'][$key]);
			}						
		}
	}

	private function save_update_hpp($tras_no, $i, $trhpp_refjenis){
		$trhpp_tgl = date('Y-m-d H:i:s');

		$query = "INSERT INTO tr_his_hpp(trhpp_tgl, trhpp_refjenis, trhpp_refno, trhpp_mspd_no, trhpp_qtyawal, trhpp_hppawal, trhpp_qtytrans, trhpp_totaltrans)
							(SELECT '".$trhpp_tgl."',
									'".$trhpp_refjenis."',
									'".$tras_no."',
									D.dtas_mspd_no, 
									(SELECT SUM(S.msst_qty) FROM ms_stok S WHERE S.msst_mspd_no = D.dtas_mspd_no),
									 P.mspd_hpp,
									 SUM(".$i." * D.dtas_qty),
									ROUND(SUM((".$i." * D.dtas_qty) * D.dtas_hpp), 4)
							FROM dt_adjstok D 
							LEFT JOIN ms_produk P 
							ON P.mspd_no = D.dtas_mspd_no 
							LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtas_mspd_no,1,1)
							WHERE D.dtas_no = '".$tras_no."'
							AND D.dtas_qty <> 0
							AND KT.mskt_statusinv = 'Y'
							GROUP BY D.dtas_mspd_no, D.dtas_hpp)";

		$this->db->simple_query($query);

		$query = "UPDATE tr_his_hpp 
					SET trhpp_totalawal = ROUND((trhpp_qtyawal * trhpp_hppawal), 4),
						trhpp_hppakhir = IF(
							(trhpp_qtyawal + (trhpp_qtytrans)) <> 0,
							ROUND(
								((trhpp_qtyawal * trhpp_hppawal) + (trhpp_totaltrans))
								 /
								 (trhpp_qtyawal + (trhpp_qtytrans)), 4), trhpp_hppawal)
					WHERE trhpp_tgl = '".$trhpp_tgl."'
					AND trhpp_refjenis = '".$trhpp_refjenis."'
					AND trhpp_refno = '".$tras_no."'";

		$this->db->simple_query($query);

		$query = "UPDATE ms_produk P 
							SET P.mspd_hpp = IFNULL((SELECT trhpp_hppakhir FROM tr_his_hpp 
										WHERE trhpp_tgl = '".$trhpp_tgl."'
										AND trhpp_refjenis = '".$trhpp_refjenis."'
										AND trhpp_refno = '".$tras_no."'
										AND trhpp_mspd_no = P.mspd_no), P.mspd_hpp)
				WHERE P.mspd_no IN
				(SELECT dtas_mspd_no FROM dt_adjstok D
				LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtas_mspd_no,1,1)
				WHERE D.dtas_no = '".$tras_no."'
				AND D.dtas_qty <> 0
				AND KT.mskt_statusinv = 'Y')";

		$this->db->simple_query($query);
	}

	private function update_hpp($tras_no, $i){		
		$query = "UPDATE ms_produk SET mspd_hpp =ROUND("
									."((mspd_hpp * (SELECT SUM(A.msst_qty) FROM ms_stok A WHERE A.msst_mspd_no = ms_produk.mspd_no))"
									." +"
									." (SELECT (".$i." * SUM(B.dtas_qty * B.dtas_hpp)) FROM dt_adjstok B"
										." WHERE B.dtas_no = '".$tras_no."'"
										." AND B.dtas_mspd_no = ms_produk.mspd_no))"
									." /"
									." ((SELECT SUM(C.msst_qty) FROM ms_stok C WHERE C.msst_mspd_no = ms_produk.mspd_no)"
									 ." +"
									 ." (SELECT (".$i." * SUM(D.dtas_qty)) FROM dt_adjstok D"
										." WHERE D.dtas_no = '".$tras_no."'"
										." AND D.dtas_mspd_no= ms_produk.mspd_no)), 4)"
									 
									." WHERE ms_produk.mspd_no IN"
										." (SELECT E.dtas_mspd_no FROM dt_adjstok E"
										." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(E.dtas_mspd_no,1,1)"
										." WHERE E.dtas_no = '".$tras_no."'"
										." AND KT.mskt_statusinv = 'Y')"
									
									." AND ((SELECT SUM(F.msst_qty) FROM ms_stok F WHERE F.msst_mspd_no = ms_produk.mspd_no)"
										." +"
										." (SELECT (".$i." * SUM(G.dtas_qty)) FROM dt_adjstok G"
										." WHERE G.dtas_no = '".$tras_no."'"
										." AND G.dtas_mspd_no= ms_produk.mspd_no)) <> 0";

		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}		
		
	}

	public function update_stok($tras_no, $i){
		$query = "INSERT INTO ms_stok(msst_mspd_no, msst_msgd_no, msst_qty)"
						." (SELECT DISTINCT A.dtas_mspd_no, B.tras_msgd_no, 0 FROM dt_adjstok A"
						." LEFT JOIN tr_adjstok B ON B.tras_no = A.dtas_no"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(A.dtas_mspd_no, 1,1)"
						." WHERE A.dtas_no = '".$tras_no."'"
						." AND KT.mskt_statusinv = 'Y'"
						." AND NOT EXISTS(SELECT C.* FROM ms_stok C"
								." WHERE C.msst_mspd_no = A.dtas_mspd_no"
								." AND C.msst_msgd_no= B.tras_msgd_no))";

		$this->db->simple_query($query);		

		$query = "UPDATE ms_stok SET msst_qty = msst_qty +"
						." (".$i." * (SELECT SUM(A.dtas_qty) FROM dt_adjstok A"
						." WHERE A.dtas_no = '".$tras_no."'"
						." AND A.dtas_mspd_no = ms_stok.msst_mspd_no))"
				." WHERE ms_stok.msst_mspd_no IN"
						." (SELECT B.dtas_mspd_no FROM dt_adjstok B"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(B.dtas_mspd_no,1,1)"
						." WHERE B.dtas_no = '".$tras_no."'"
						." AND KT.mskt_statusinv = 'Y')"
				." AND ms_stok.msst_msgd_no ="
						." (SELECT C.tras_msgd_no FROM tr_adjstok C"
						." WHERE C.tras_no = '".$tras_no."')";		
			
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}							
	}		

	private function jurnal_simpan($data){				
		// Generate CekInt
		$data['jurnal_h']['trju_cekint'] = rand(0,10000);			

		if($data['action'] == 'NEW'){
			// Insert data header jurnal
			$this->db->insert('tr_jurnal',$data['jurnal_h']);
		}

		if($data['action'] == 'EDIT'){
			// Update data header jurnal
			$this->db->where('trju_no',$data['jurnal_h']['trju_no']);
			$this->db->update('tr_jurnal',$data['jurnal_h']);
			$this->db->delete('dt_jurnal',array('dtju_no' => $data['jurnal_h']['trju_no']));
		}			

		//Insert data detail jurnal
		if(isset($data['jurnal_d'])){
			$seq = 1;
			foreach ($data['jurnal_d'] as $key => $value) {
				$data['jurnal_d'][$key]['dtju_no'] = $data['jurnal_h']['trju_no'];
				$data['jurnal_d'][$key]['dtju_seq'] = $seq;
				$this->db->insert('dt_jurnal',$data['jurnal_d'][$key]);
				$seq += 1;
			}		
		}		
	}

	private function jurnal_hapus($data){		

		if(isset($data['jurnal_h']['trju_no']) && strlen($data['jurnal_h']['trju_no']) > 0){
			$this->db->delete('tr_jurnal', array('trju_no' => $data['jurnal_h']['trju_no']));
			$this->db->delete('dt_jurnal', array('dtju_no' => $data['jurnal_h']['trju_no']));
		}

	}

	private function set_data_jurnal($data){
		$this->load->model('data_master/m_gudang');
		$this->load->model('finance_and_acc/m_jurnal');
		$this->load->model('setting/m_setting_account');
		$this->load->model('data_master/m_kategori');
		$this->data_j['action'] = $data['action'];

		//Header jurnal			
		if($data['action'] == 'NEW'){
			$trju_tgl = $data['header']['tras_tgl'];
			$trju_tipe = 'A';
			$bulan = substr($trju_tgl, 5, 2);			
			$tahun = substr($trju_tgl, 2, 2);			
			$separator = ($data['header']['tras_fin'] == 'F') ? '-' : '_';
			$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;
			$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);
			$data['jurnal_h']['trju_refno'] = $data['header']['tras_no'].'AS';
			$data['jurnal_h']['trju_reftipe'] = 'AS';
			$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
			$data['jurnal_h']['trju_tgl'] = $trju_tgl;
			$data['jurnal_h']['trju_tipe'] = $trju_tipe;				
			$data['jurnal_h']['trju_void'] = 0;
			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $data['header']['tras_fin'] == 'C') ? 'A' : 'R';
			$data['jurnal_h']['trju_fin'] = $data['header']['tras_fin'];
		}

		if($data['action'] != 'NEW'){
			$data['jurnal_h']['trju_no'] = $data['jurnal_h']['trju_no'];
		}
					
		$gudang = $this->m_gudang->get_gudang($data['header']['tras_msgd_no']);				
		$trju_catatan = $data['header']['tras_tag'].' '.$data['header']['tras_no'].'/'.$gudang['msgd_no'].' - '.$gudang['msgd_nm'];
		$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));
		$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
		$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];						
			
		// Set account
		//-----------------------------------------------------------------------------------						
		if(isset($this->data['detail'])){								
			$array = array();
			$data['jurnal_d'] = array();
			foreach ($this->data['detail'] as $key => $value) {										 					 					 		
				$mskt_no = substr($this->data['detail'][$key]['dtas_mspd_no'], 0, 1);				
				 $saldo = round(ftodouble($this->data['detail'][$key]['dtas_hpp']) * ftodouble($this->data['detail'][$key]['dtas_qty']), 4);
				
		 		// Account Inventory (Debet)
				$array['dtju_msap_no'] = $this->m_kategori->get_kategori_settacc($mskt_no, 'mskt_msap_no_inv');
				$array['dtju_debet'] = $saldo;
				$array['dtju_kredit'] = 0;
				array_push($data['jurnal_d'], $array);				 		

		 		// Account Adjustment Stok (Kredit)
		 		$acc = $this->m_setting_account->get_setting_account_byid('ADJS');
				$array['dtju_msap_no'] = $acc['mssa_msap_no'];
				$array['dtju_debet'] = 0;
				$array['dtju_kredit'] = $saldo;
				array_push($data['jurnal_d'], $array);				
			}
			$this->data_j['jurnal_d'] = $data['jurnal_d'];
		}		
		//--------------------------------------------------------------------------------
		$this->data_j['jurnal_h'] = $data['jurnal_h'];
	}
}		