<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_goods_transformation extends MY_Model {
	function __construct(){
		parent::__construct();						
		$this->load->model('setting/m_user_log');
	}

	public function get_goods_transformation_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trts_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('tr_tfmgoods.*, msgd_nm, msus_nm, mscb_nm');
		$this->db->join('ms_gudang','ms_gudang.msgd_no = tr_tfmgoods.trts_msgd_no', 'left');
		$this->db->join('ms_user','ms_user.msus_no = tr_tfmgoods.trts_msus_no', 'left');
		$this->db->join('ms_cabang','ms_cabang.mscb_no = tr_tfmgoods.trts_mscb_no', 'left');		
		$this->db->from('tr_tfmgoods');		

		$query_string = '';

		if(isset($arr_filter['mspd_no'])){			
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x1.* FROM dt_tfmgoods x1 WHERE x1.dtts_no = trts_no AND x1.dtts_mspd_no LIKE "%'. $arr_filter['mspd_no']. '%")';							
			unset($arr_filter['mspd_no']);
		}

		if(isset($arr_filter['mspd_nm'])){
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x2.*, a.mspd_nm AS mspd_nm FROM dt_tfmgoods x2 LEFT JOIN ms_produk AS a ON a.mspd_no = x2.dtts_mspd_no WHERE x2.dtts_no = trts_no AND a.mspd_nm LIKE "%'. $arr_filter['mspd_nm']. '%")';
			unset($arr_filter['mspd_nm']);
		}		

		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}
		
		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			$this->db->like($arr_filter);			
		}		
		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}

	public function get_goods_transformation($trts_no){		
		$data = array();

		//Get goods_transformation header berdasarkan trts_no	
		$this->db->select('tr_tfmgoods.*, msus_no, msus_nm, mscb_no, mscb_nm');
		$this->db->from('tr_tfmgoods');		
		$this->db->join('ms_user','msus_no = trts_msus_no', 'left');
		$this->db->join('ms_cabang','mscb_no = trts_mscb_no', 'left');				
		$this->db->where('trts_no',$trts_no);
		
		$query = $this->db->get();

		if($query->num_rows() > 0){
			$result = $query->result_array();
			$data['header'] = $result[0];
		}
		
		//Get goods transformation produk detail berdasarkan trts_no
		$this->db->select('dt_tfmgoods.*, mspd_nm, mskt_msap_no_inv');
		$this->db->from('dt_tfmgoods');
		$this->db->join('ms_produk', 'mspd_no = dtts_mspd_no','left');
		$this->db->join('ms_kategori', 'mskt_no = SUBSTRING(dtts_mspd_no,1,1)','left');
		$this->db->where('dtts_no',$trts_no);
		$this->db->order_by('dtts_seq', 'ASC');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail_prod'] = $detail;
		}

		//Get goods transformation account detail berdasarkan trts_no
		$this->db->select('dt_tfmgoods_accper.*, msap_nm');
		$this->db->from('dt_tfmgoods_accper');
		$this->db->join('ms_accper', 'msap_no = dttsap_msap_no','left');
		$this->db->where('dttsap_no',$trts_no);
		$this->db->order_by('dttsap_seq', 'ASC');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail_acc'] = $detail;
		}

		if(count($data) > 0){
			return $data;
		}else{
			return false;
		}
	}

	public function goods_transformation_kode_auto($trts_kode_depan){
		$this->db->select_max("trts_no");
		$this->db->like("trts_no", $trts_kode_depan, "after");
		$query = $this->db->get("tr_tfmgoods");
		if ($query->num_rows() == 0){
			return $trts_kode_depan. "0001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['trts_no'];
			$nomor = ((int) substr($kode, 8)) + 1;
			return $trts_kode_depan. sprintf("%'.04d", $nomor);
		}
	}

	public function get_goods_transformation_cekint($trts_no, $trts_cekint){		
		$query = $this->db->get_where('tr_tfmgoods', array('trts_no' => $trts_no, 'trts_cekint' => $trts_cekint));				 
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function set_goods_transformation_cekint($trts_no){				
		$this->db->where('trts_no', $trts_no);
		$this->db->update('tr_tfmgoods', array('trts_cekint' => rand(0,10000)));
	}
	
	public function goods_transformation_simpan($data){
		try {
				if($data['action'] == 'NEW'){
					// Simpan Data
					$this->insert_data($data);

					// Revisi 2018-03-20 CL -----------------------------------------------------------------------------
					// 1. Revisi urutan proses Update : HPP From -> Stok From -> HPP Result -> Stok Result
					// 2. Pemisahan fungsi update_stok antara proses FROM dengan RESULT
					// --------------------------------------------------------------------------------------------------

					// Update hpp produk from
					$this->save_update_hpp_from($data['header']['trts_no'], -1, 'TFN');
					// Update Stok from
					$this->save_update_stok_from($data['header']['trts_no'], -1);
					// Update hpp produk result
					$this->save_update_hpp_result($data['header']['trts_no'], 1, 'TRN');
					// Update Stok result
					$this->save_update_stok_result($data['header']['trts_no'], 1);

					// Create jurnal
					$this->jurnal_simpan($data);
				}

				if($data['action'] == 'EDIT'){

					// Revisi 2018-03-20 CL -----------------------------------------------------------------------------
					// 1. Pemisahan fungsi update_stok antara proses FROM dengan RESULT
					// 2. Urutan secara garis besar: seperti VOID -> Update -> seperti NEW
					// --------------------------------------------------------------------------------------------------

					// Update hpp produk result
					$this->save_update_hpp_result($data['header']['trts_no'], -1, 'TR1');
					// Update Stok result
					$this->save_update_stok_result($data['header']['trts_no'], -1);
					// Update hpp produk from
					$this->save_update_hpp_from($data['header']['trts_no'], 1, 'TF1');
					// Update Stok result
					$this->save_update_stok_from($data['header']['trts_no'], 1);

					// Update Data
					$this->update_data($data);

					// Update hpp produk from
					$this->save_update_hpp_from($data['header']['trts_no'], -1, 'TF2');
					// Update Stok from
					$this->save_update_stok_from($data['header']['trts_no'], -1);
					// Update hpp produk result
					$this->save_update_hpp_result($data['header']['trts_no'], 1, 'TR2');
					// Update Stok result
					$this->save_update_stok_result($data['header']['trts_no'], 1);

					// Create jurnal
					$this->jurnal_simpan($data);
					// Simpan userlog
					$this->m_user_log->user_log_simpan($data['userlog']);
				}

				if($data['action'] == 'VOID'){
					
					// Revisi 2018-03-20 CL -----------------------------------------------------------------------------
					// 1. Ingat! Void urutan harus terbalik. Maka, revisi urutan proses Update : HPP Result -> Stok Result - > HPP From -> Stok From
					// 2. Pemisahan fungsi update_stok antara proses FROM dengan RESULT
					// --------------------------------------------------------------------------------------------------

					// Update hpp produk result
					$this->save_update_hpp_result($data['header']['trts_no'], -1, 'TRV');
					// Update Stok result
					$this->save_update_stok_result($data['header']['trts_no'], -1);
					// Update hpp produk from
					$this->save_update_hpp_from($data['header']['trts_no'], 1, 'TFV');
					// Update Stok result
					$this->save_update_stok_from($data['header']['trts_no'], 1);

					// Update Data
					$this->void_data($data);	
					// Hapus jurnal
					$this->jurnal_hapus($data);
					// Simpan userlog
					$this->m_user_log->user_log_simpan($data['userlog']);			
				}
								
			return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}

	private function void_data($data){
		$this->db->where('trts_no', $data['header']['trts_no']);
		$this->db->update('tr_tfmgoods', array('trts_void'=>1));
	}

	private function insert_data($data){
		// Generate CekInt
		$data['header']['trts_cekint'] = rand(0,10000);			

		//Insert data header goods transformation
		$this->db->insert('tr_tfmgoods',$data['header']);
	
		//Insert data detail produk goods transformation
		if(isset($data['detail_prod'])){
			$seq = 1;
			foreach ($data['detail_prod'] as $key => $value) {
				$data['detail_prod'][$key]['dtts_seq'] = $seq;					
			    $this->db->insert('dt_tfmgoods', $data['detail_prod'][$key]);											
				$seq += 1;
			}									
		}			

		//Insert data detail account goods transformation
		if(isset($data['detail_acc'])){
			$seq = 1;
			foreach ($data['detail_acc'] as $key => $value) {
				$data['detail_acc'][$key]['dttsap_seq'] = $seq;					
			   	$this->db->insert('dt_tfmgoods_accper',$data['detail_acc'][$key]);	
			   	$seq += 1;
			}
		}	
	}

	private function update_data($data){
		// Generate CekInt
		$data['header']['trts_cekint'] = rand(0,10000);			

		// Update data header goods transformation
		$this->db->where('trts_no', $data['header']['trts_no']);
		$this->db->update('tr_tfmgoods', $data['header']);
	
		// Delete data dt_tfmgoods lama
		$this->db->delete('dt_tfmgoods', array('dtts_no' => $data['header']['trts_no']));

		//Insert data detail produk goods transformation
		if(isset($data['detail_prod'])){
			$seq = 1;
			foreach ($data['detail_prod'] as $key => $value) {
				$data['detail_prod'][$key]['dtts_seq'] = $seq;				
			    $this->db->insert('dt_tfmgoods', $data['detail_prod'][$key]);											
				$seq += 1;
			}									
		}

		// Delete data dt_tfmgoods_accper lama
		$this->db->delete('dt_tfmgoods_accper', array('dttsap_no' => $data['header']['trts_no']));			

		//Insert data detail account goods transformation
		if(isset($data['detail_acc'])){
			$seq = 1;
			foreach ($data['detail_acc'] as $key => $value) {
				$data['detail_acc'][$key]['dttsap_seq'] = $seq;					
			   	$this->db->insert('dt_tfmgoods_accper',$data['detail_acc'][$key]);	
			   	$seq += 1;
			}
		}	
	}

	public function save_update_hpp_from($trts_no, $i, $trhpp_refjenis){
		$trhpp_tgl = date('Y-m-d H:i:s');

		$query = "INSERT INTO tr_his_hpp(trhpp_tgl, trhpp_refjenis, trhpp_refno, trhpp_mspd_no, trhpp_qtyawal, trhpp_hppawal, trhpp_qtytrans, trhpp_totaltrans)
							(SELECT '".$trhpp_tgl."',
									'".$trhpp_refjenis."',
									'".$trts_no."',
									D.dtts_mspd_no, 
									(SELECT SUM(S.msst_qty) FROM ms_stok S WHERE S.msst_mspd_no = D.dtts_mspd_no),
									 P.mspd_hpp,
									 SUM(".$i." * D.dtts_qty),
									ROUND(SUM((".$i." * D.dtts_qty) * D.dtts_hpp), 4)
							FROM dt_tfmgoods D 
							LEFT JOIN ms_produk P 
							ON P.mspd_no = D.dtts_mspd_no 
							LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtts_mspd_no,1,1)
							WHERE D.dtts_no = '".$trts_no."'
							AND D.dtts_qty <> 0
							AND KT.mskt_statusinv = 'Y'
							AND D.dtts_jenis = 'F'
							GROUP BY D.dtts_mspd_no, D.dtts_hpp)";

		$this->db->simple_query($query);

		$query = "UPDATE tr_his_hpp 
					SET trhpp_totalawal = ROUND((trhpp_qtyawal * trhpp_hppawal), 4),
						trhpp_hppakhir = IF(
							(trhpp_qtyawal + (trhpp_qtytrans)) <> 0,
							ROUND(
								((trhpp_qtyawal * trhpp_hppawal) + (trhpp_totaltrans))
								 /
								 (trhpp_qtyawal + (trhpp_qtytrans)), 4), trhpp_hppawal)
					WHERE trhpp_tgl = '".$trhpp_tgl."'
					AND trhpp_refjenis = '".$trhpp_refjenis."'
					AND trhpp_refno = '".$trts_no."'";

		$this->db->simple_query($query);

		$query = "UPDATE ms_produk P 
							SET P.mspd_hpp = IFNULL((SELECT trhpp_hppakhir FROM tr_his_hpp 
										WHERE trhpp_tgl = '".$trhpp_tgl."'
										AND trhpp_refjenis = '".$trhpp_refjenis."'
										AND trhpp_refno = '".$trts_no."'
										AND trhpp_mspd_no = P.mspd_no), P.mspd_hpp)
				WHERE P.mspd_no IN
				(SELECT dtts_mspd_no FROM dt_tfmgoods D
				LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtts_mspd_no,1,1)
				WHERE D.dtts_no = '".$trts_no."'
				AND D.dtts_qty <> 0
				AND KT.mskt_statusinv = 'Y'
				AND D.dtts_jenis = 'F')";

		$this->db->simple_query($query);
	}

	public function save_update_hpp_result($trts_no, $i, $trhpp_refjenis){
		$trhpp_tgl = date('Y-m-d H:i:s');

		$query = "INSERT INTO tr_his_hpp(trhpp_tgl, trhpp_refjenis, trhpp_refno, trhpp_mspd_no, trhpp_qtyawal, trhpp_hppawal, trhpp_qtytrans, trhpp_totaltrans)
							(SELECT '".$trhpp_tgl."',
									'".$trhpp_refjenis."',
									'".$trts_no."',
									D.dtts_mspd_no, 
									(SELECT SUM(S.msst_qty) FROM ms_stok S WHERE S.msst_mspd_no = D.dtts_mspd_no),
									 P.mspd_hpp,
									 SUM(".$i." * D.dtts_qty),
									ROUND(SUM((".$i." * D.dtts_qty) * D.dtts_hpp), 4)
							FROM dt_tfmgoods D 
							LEFT JOIN ms_produk P 
							ON P.mspd_no = D.dtts_mspd_no 
							LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtts_mspd_no,1,1)
							WHERE D.dtts_no = '".$trts_no."'
							AND D.dtts_qty <> 0
							AND KT.mskt_statusinv = 'Y'
							AND D.dtts_jenis = 'R'
							GROUP BY D.dtts_mspd_no, D.dtts_hpp)";

		$this->db->simple_query($query);

		$query = "UPDATE tr_his_hpp 
					SET trhpp_totalawal = ROUND((trhpp_qtyawal * trhpp_hppawal), 4),
						trhpp_hppakhir = IF(
							(trhpp_qtyawal + (trhpp_qtytrans)) <> 0,
							ROUND(
								((trhpp_qtyawal * trhpp_hppawal) + (trhpp_totaltrans))
								 /
								 (trhpp_qtyawal + (trhpp_qtytrans)), 4), trhpp_hppawal)
					WHERE trhpp_tgl = '".$trhpp_tgl."'
					AND trhpp_refjenis = '".$trhpp_refjenis."'
					AND trhpp_refno = '".$trts_no."'";

		$this->db->simple_query($query);

		$query = "UPDATE ms_produk P 
							SET P.mspd_hpp = IFNULL((SELECT trhpp_hppakhir FROM tr_his_hpp 
										WHERE trhpp_tgl = '".$trhpp_tgl."'
										AND trhpp_refjenis = '".$trhpp_refjenis."'
										AND trhpp_refno = '".$trts_no."'
										AND trhpp_mspd_no = P.mspd_no), P.mspd_hpp)
				WHERE P.mspd_no IN
				(SELECT dtts_mspd_no FROM dt_tfmgoods D
				LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtts_mspd_no,1,1)
				WHERE D.dtts_no = '".$trts_no."'
				AND D.dtts_qty <> 0
				AND KT.mskt_statusinv = 'Y'
				AND D.dtts_jenis = 'R')";

		$this->db->simple_query($query);
	}

	// private function update_hpp_produk_from($trts_no, $i){		
	// 	$query = "UPDATE ms_produk SET mspd_hpp =ROUND("
	// 								."((mspd_hpp * (SELECT SUM(A.msst_qty) FROM ms_stok A WHERE A.msst_mspd_no = ms_produk.mspd_no))"
	// 								." +"
	// 								." (SELECT (".$i." * SUM(B.dtts_qty * B.dtts_hpp)) FROM dt_tfmgoods B"
	// 									." WHERE B.dtts_no = '".$trts_no."'"
	// 									." AND B.dtts_mspd_no = ms_produk.mspd_no"
	// 									." AND B.dtts_jenis = 'F'))"
	// 								." /"
	// 								." ((SELECT SUM(C.msst_qty) FROM ms_stok C WHERE C.msst_mspd_no = ms_produk.mspd_no)"
	// 								." +"
	// 								." (SELECT (".$i." * SUM(D.dtts_qty)) FROM dt_tfmgoods D"
	// 									." WHERE D.dtts_no = '".$trts_no."'"
	// 									." AND D.dtts_mspd_no= ms_produk.mspd_no"
	// 									." AND D.dtts_jenis = 'F')), 4)"
									 
	// 								." WHERE ms_produk.mspd_no IN"
	// 									." (SELECT E.dtts_mspd_no FROM dt_tfmgoods E"
	// 									." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(E.dtts_mspd_no,1,1)"
	// 									." WHERE E.dtts_no = '".$trts_no."'"
	// 									." AND KT.mskt_statusinv = 'Y'"
	// 									." AND E.dtts_jenis = 'F')"
									
	// 								." AND ((SELECT SUM(F.msst_qty) FROM ms_stok F WHERE F.msst_mspd_no = ms_produk.mspd_no)"
	// 									." +"
	// 									." (SELECT (".$i." * SUM(G.dtts_qty)) FROM dt_tfmgoods G"
	// 									." WHERE G.dtts_no = '".$trts_no."'"
	// 									." AND G.dtts_mspd_no= ms_produk.mspd_no AND G.dtts_jenis = 'F')) <> 0";

	// 	if($this->db->simple_query($query)){		
	// 		return 1;
	// 	}else{
	// 		return 0;
	// 	}				
	// }

	// private function update_hpp_produk_result($trts_no, $i){		
	// 	$query = "UPDATE ms_produk SET mspd_hpp =ROUND("
	// 								."((mspd_hpp * (SELECT SUM(A.msst_qty) FROM ms_stok A WHERE A.msst_mspd_no = ms_produk.mspd_no))"
	// 								." +"
	// 								." (SELECT (".$i." * SUM(B.dtts_qty * B.dtts_hpp)) FROM dt_tfmgoods B"
	// 									." WHERE B.dtts_no = '".$trts_no."'"
	// 									." AND B.dtts_mspd_no = ms_produk.mspd_no"
	// 									." AND B.dtts_jenis = 'R'))"
	// 								." /"
	// 								." ((SELECT SUM(C.msst_qty) FROM ms_stok C WHERE C.msst_mspd_no = ms_produk.mspd_no)"
	// 								." +"
	// 								." (SELECT (".$i." * SUM(D.dtts_qty)) FROM dt_tfmgoods D"
	// 									." WHERE D.dtts_no = '".$trts_no."'"
	// 									." AND D.dtts_mspd_no= ms_produk.mspd_no"
	// 									." AND D.dtts_jenis = 'R')), 4)"
									 
	// 								." WHERE ms_produk.mspd_no IN"
	// 									." (SELECT E.dtts_mspd_no FROM dt_tfmgoods E"
	// 									." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(E.dtts_mspd_no,1,1)"
	// 									." WHERE E.dtts_no = '".$trts_no."'"
	// 									." AND KT.mskt_statusinv = 'Y'"
	// 									." AND E.dtts_jenis = 'R')"
									
	// 								." AND ((SELECT SUM(F.msst_qty) FROM ms_stok F WHERE F.msst_mspd_no = ms_produk.mspd_no)"
	// 									." +"
	// 									." (SELECT (".$i." * SUM(G.dtts_qty)) FROM dt_tfmgoods G"
	// 									." WHERE G.dtts_no = '".$trts_no."'"
	// 									." AND G.dtts_mspd_no= ms_produk.mspd_no AND G.dtts_jenis = 'R')) <> 0";

	// 	if($this->db->simple_query($query)){		
	// 		return 1;
	// 	}else{
	// 		return 0;
	// 	}				
	// }

	// Revisi 2018-03-20 CL -----------------------------------------------------------------------------
	// pemisahan fungsi update_stok antara proses FROM dengan RESULT, dan revisi rumus qty update
	// --------------------------------------------------------------------------------------------------
	public function save_update_stok_from($trts_no, $i){
		$query = "INSERT INTO ms_stok(msst_mspd_no, msst_msgd_no, msst_qty)"
						." (SELECT DISTINCT A.dtts_mspd_no, B.trts_msgd_no, 0 FROM dt_tfmgoods A"
						." LEFT JOIN tr_tfmgoods B ON B.trts_no = A.dtts_no"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(A.dtts_mspd_no, 1,1)"
						." WHERE A.dtts_no = '".$trts_no."'"
						." AND A.dtts_jenis = 'F'"
						." AND KT.mskt_statusinv = 'Y'"
						." AND NOT EXISTS(SELECT C.* FROM ms_stok C"
								." WHERE C.msst_mspd_no = A.dtts_mspd_no"
								." AND C.msst_msgd_no= B.trts_msgd_no))";

		$this->db->simple_query($query);

		$query = "UPDATE ms_stok SET msst_qty = msst_qty +"
						." (".$i." * (SELECT SUM(A.dtts_qty) FROM dt_tfmgoods A"
						." WHERE A.dtts_no = '".$trts_no."'"
						." AND A.dtts_mspd_no = ms_stok.msst_mspd_no"
						." AND A.dtts_jenis = 'F'" // <-- Penting !!!
						." ))"
				." WHERE ms_stok.msst_mspd_no IN"
						." (SELECT B.dtts_mspd_no FROM dt_tfmgoods B"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(B.dtts_mspd_no,1,1)"
						." WHERE B.dtts_no = '".$trts_no."'"
						." AND B.dtts_jenis = 'F'"
						." AND KT.mskt_statusinv = 'Y')"
				." AND ms_stok.msst_msgd_no ="
						." (SELECT C.trts_msgd_no FROM tr_tfmgoods C"
						." WHERE C.trts_no = '".$trts_no."')";

		$this->db->simple_query($query);								
	}		

	// Revisi 2018-03-20 CL -----------------------------------------------------------------------------
	// pemisahan fungsi update_stok antara proses FROM dengan RESULT, dan revisi rumus qty update
	// --------------------------------------------------------------------------------------------------
	public function save_update_stok_result($trts_no, $i){
		$query = "INSERT INTO ms_stok(msst_mspd_no, msst_msgd_no, msst_qty)"
						." (SELECT DISTINCT A.dtts_mspd_no, B.trts_msgd_no, 0 FROM dt_tfmgoods A"
						." LEFT JOIN tr_tfmgoods B ON B.trts_no = A.dtts_no"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(A.dtts_mspd_no, 1,1)"
						." WHERE A.dtts_no = '".$trts_no."'"
						." AND A.dtts_jenis = 'R'" 
						." AND KT.mskt_statusinv = 'Y'"
						." AND NOT EXISTS(SELECT C.* FROM ms_stok C"
								." WHERE C.msst_mspd_no = A.dtts_mspd_no"
								." AND C.msst_msgd_no= B.trts_msgd_no))";

		$this->db->simple_query($query);

		$query = "UPDATE ms_stok SET msst_qty = msst_qty +"
						." (".$i." * (SELECT SUM(A.dtts_qty) FROM dt_tfmgoods A"
						." WHERE A.dtts_no = '".$trts_no."'"
						." AND A.dtts_mspd_no = ms_stok.msst_mspd_no"
						." AND A.dtts_jenis = 'R'" // <-- Penting !!!						
						." ))"
				." WHERE ms_stok.msst_mspd_no IN"
						." (SELECT B.dtts_mspd_no FROM dt_tfmgoods B"
						." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(B.dtts_mspd_no,1,1)"
						." WHERE B.dtts_no = '".$trts_no."'"
						." AND B.dtts_jenis = 'R'"
						." AND KT.mskt_statusinv = 'Y')"
				." AND ms_stok.msst_msgd_no ="
						." (SELECT C.trts_msgd_no FROM tr_tfmgoods C"
						." WHERE C.trts_no = '".$trts_no."')";

		$this->db->simple_query($query);									
	}		

	// public function update_stok($trts_no, $i, $x){
	// 	$query = "INSERT INTO ms_stok(msst_mspd_no, msst_msgd_no, msst_qty)"
	// 					." (SELECT DISTINCT A.dtts_mspd_no, B.trts_msgd_no, 0 FROM dt_tfmgoods A"
	// 					." LEFT JOIN tr_tfmgoods B ON B.trts_no = A.dtts_no"
	// 					." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(A.dtts_mspd_no, 1,1)"
	// 					." WHERE A.dtts_no = '".$trts_no."'"
	// 					." AND KT.mskt_statusinv = 'Y'"
	// 					." AND NOT EXISTS(SELECT C.* FROM ms_stok C"
	// 							." WHERE C.msst_mspd_no = A.dtts_mspd_no"
	// 							." AND C.msst_msgd_no= B.trts_msgd_no))";

	// 	$this->db->simple_query($query);

	// 	$query = "UPDATE ms_stok SET msst_qty = msst_qty +"
	// 					." (".$i." * (SELECT SUM(A.dtts_qty) FROM dt_tfmgoods A"
	// 					." WHERE A.dtts_no = '".$trts_no."'"
	// 					." AND A.dtts_mspd_no = ms_stok.msst_mspd_no))"
	// 			." WHERE ms_stok.msst_mspd_no IN"
	// 					." (SELECT B.dtts_mspd_no FROM dt_tfmgoods B"
	// 					." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(B.dtts_mspd_no,1,1)"
	// 					." WHERE B.dtts_no = '".$trts_no."'"
	// 					." AND KT.mskt_statusinv = 'Y'"
	// 					." AND B.dtts_jenis = 'F')"
	// 			." AND ms_stok.msst_msgd_no ="
	// 					." (SELECT C.trts_msgd_no FROM tr_tfmgoods C"
	// 					." WHERE C.trts_no = '".$trts_no."')";

	// 	$this->db->simple_query($query);

	// 	$query = "UPDATE ms_stok SET msst_qty = msst_qty +"
	// 					." (".$x." * (SELECT SUM(A.dtts_qty) FROM dt_tfmgoods A"
	// 					." WHERE A.dtts_no = '".$trts_no."'"
	// 					." AND A.dtts_mspd_no = ms_stok.msst_mspd_no))"
	// 			." WHERE ms_stok.msst_mspd_no IN"
	// 					." (SELECT B.dtts_mspd_no FROM dt_tfmgoods B"
	// 					." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(B.dtts_mspd_no,1,1)"
	// 					." WHERE B.dtts_no = '".$trts_no."'"
	// 					." AND KT.mskt_statusinv = 'Y'"
	// 					." AND B.dtts_jenis = 'R')"
	// 			." AND ms_stok.msst_msgd_no ="
	// 					." (SELECT C.trts_msgd_no FROM tr_tfmgoods C"
	// 					." WHERE C.trts_no = '".$trts_no."')";

	// 	$this->db->simple_query($query);									
	// }	

	private function jurnal_simpan($data){				
		// Generate CekInt
		$data['jurnal_h']['trju_cekint'] = rand(0,10000);			

		if($data['action'] == 'NEW'){
			// Insert data header jurnal
			$this->db->insert('tr_jurnal',$data['jurnal_h']);
		}

		if($data['action'] == 'EDIT'){
			// Update data header jurnal
			$this->db->where('trju_no',$data['jurnal_h']['trju_no']);
			$this->db->update('tr_jurnal',$data['jurnal_h']);
			$this->db->delete('dt_jurnal',array('dtju_no' => $data['jurnal_h']['trju_no']));
		}			

		//Insert data detail jurnal
		if(isset($data['jurnal_d'])){
			$seq = 1;
			foreach ($data['jurnal_d'] as $key => $value) {														
				$data['jurnal_d'][$key]['dtju_no'] = $data['jurnal_h']['trju_no'];
				$data['jurnal_d'][$key]['dtju_seq'] = $seq;
				$this->db->insert('dt_jurnal',$data['jurnal_d'][$key]);
				$seq += 1;
			}		
		}		
	}

	private function jurnal_hapus($data){		
		if(isset($data['jurnal_h']['trju_no']) && strlen($data['jurnal_h']['trju_no']) > 0){
			$this->db->delete('tr_jurnal', array('trju_no' => $data['jurnal_h']['trju_no']));
			$this->db->delete('dt_jurnal', array('dtju_no' => $data['jurnal_h']['trju_no']));
		}
	}

}