<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_mutasi extends MY_Model {

	function __construct(){
		parent::__construct();				
		$this->load->model('setting/m_user_log');
	}

	public function get_mutasi_list($arr_filter, $is_count = false, $per_page = 15, $offset = 0, $fn = 'trmt_no', $sort = 'DESC'){
		$nlimit = $arr_filter['nlimit'];

		$this->db->select('tr_mutasi.*,
							a.mscb_nm AS mscb_nm1,
							b.mscb_nm AS mscb_nm2,
							x.msgd_nm AS msgd_nm1,
							y.msgd_nm AS msgd_nm2,
							crt.msus_nm'
						);
		$this->db->join('ms_cabang as a','a.mscb_no = tr_mutasi.trmt_mscb_no1', 'left');
		$this->db->join('ms_cabang as b','b.mscb_no = tr_mutasi.trmt_mscb_no2', 'left');
		$this->db->join('ms_gudang as x','x.msgd_no = tr_mutasi.trmt_msgd_no1', 'left');
		$this->db->join('ms_gudang as y','y.msgd_no = tr_mutasi.trmt_msgd_no2', 'left');
		$this->db->join('ms_user as crt','crt.msus_no = tr_mutasi.trmt_msus_no', 'left');		
		$this->db->from('tr_mutasi');

		$query_string = '';

		//Mutation status:
		//1. DELIVERY-COMPLETE
		//2. DELIVERY-NOT YET DELIVERED
		//3. DELIVERY-DELIVERED (UNRECEIVED)

		if(isset($arr_filter['mutation_status'])){
			if($arr_filter['mutation_status'] == '1'){			
				$query_string .= 'trmt_tglterima != 0000-00-00';
			}elseif($arr_filter['mutation_status'] == '2'){			
				$query_string .= 'trmt_tglkirim = 0000-00-00';
			}elseif($arr_filter['mutation_status'] == '3'){			
				$query_string .= 'trmt_tglkirim != 0000-00-00 AND trmt_tglterima = 0000-00-00';
			}
			unset($arr_filter['mutation_status']);	
		}

		//Delivery accuracy:
		//1. DELIVERY-ACCURATE
		//2. DELIVERY-INACCURATE (APPROVED)
		//3. DELIVERY-INACCURATE (UNAPPROVED)

		if(isset($arr_filter['dlv_accur_stat'])){
			if($arr_filter['dlv_accur_stat'] == '1'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'NOT EXISTS(SELECT x1.* FROM dt_mutasi x1 WHERE x1.dtmt_no = trmt_no AND x1.dtmt_qtyout <> x1.dtmt_qtyin)';
			}elseif($arr_filter['dlv_accur_stat'] == '2'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'EXISTS(SELECT x1.* FROM dt_mutasi x1 WHERE x1.dtmt_no = trmt_no AND x1.dtmt_qtyout <> x1.dtmt_qtyin) AND NOT EXISTS(SELECT x2.* FROM dt_mutasi x2 WHERE x2.dtmt_no = trmt_no AND x2.dtmt_stapv = "N")';				
			}elseif($arr_filter['dlv_accur_stat'] == '3'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'EXISTS(SELECT x1.* FROM dt_mutasi x1 WHERE x1.dtmt_no = trmt_no AND x1.dtmt_qtyout <> x1.dtmt_qtyin AND x1.dtmt_stapv = "N" AND trmt_tglterima <> "0000-00-00")';
			}
			unset($arr_filter['dlv_accur_stat']);
		}						

		//In/Out status:
		//1. Mutasi In
		//2. Mutasi Out

		// if(isset($arr_filter['inout_status'])){
		// 	if($arr_filter['inout_status'] == '1'){			
		// 		$query_string .= 'EXISTS(SELECT x1.* FROM dt_mutasi x1 LEFT JOIN tr_mutasi ON x1.dtmt_no = trmt_no WHERE trmt_mscb_no2 LIKE "%'.$this->session->userdata('user_aktif')['msus_mscb_no'].'%" AND trmt_void=0 AND x1.dtmt_stapv="N")';
		// 	}elseif ($arr_filter['inout_status'] == '2') {
		// 		$query_string .= 'EXISTS(SELECT x1.* FROM dt_mutasi x1 WHERE x1.dtmt_no = trmt_no AND trmt_mscb_no1 ="'.$this->session->userdata('user_aktif')['msus_mscb_no'].'" AND trmt_tglterima!="0000-00-00" AND trmt_void=0 AND x1.dtmt_stapv="N")';
		// 	}
		// 	unset($arr_filter['inout_status']);	
		// }

		if(isset($arr_filter['mspd_no'])){			
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x1.* FROM dt_mutasi x1 WHERE x1.dtmt_no = trmt_no AND x1.dtmt_mspd_no LIKE "%'. $arr_filter['mspd_no']. '%")';							
			unset($arr_filter['mspd_no']);
		}

		if(isset($arr_filter['mspd_nm'])){
			if($query_string != ''){
				$query_string .= ' AND ';
			}
			$query_string .= 'EXISTS(SELECT x2.*, a.mspd_nm AS mspd_nm FROM dt_mutasi x2 LEFT JOIN ms_produk AS a ON a.mspd_no = x2.dtmt_mspd_no WHERE x2.dtmt_no = trmt_no AND a.mspd_nm LIKE "%'. $arr_filter['mspd_nm']. '%")';
			unset($arr_filter['mspd_nm']);
		}

		if(isset($arr_filter['mskt_no'])){
			if($arr_filter['mskt_no'] != 'all'){
				if($query_string != ''){
					$query_string .= ' AND ';
				}
				$query_string .= 'EXISTS(SELECT dt_mutasi.*, mskt_no FROM dt_mutasi LEFT JOIN ms_produk AS b ON b.mspd_no = dtmt_mspd_no LEFT JOIN ms_kategori ON mskt_no = SUBSTRING(b.mspd_no, 1, 1) WHERE dtmt_no = SUBSTRING(trmt_no, 1, 12) AND mskt_no ="'. $arr_filter['mskt_no']. '")';
			}	
			unset($arr_filter['mskt_no']);
		}


		if($query_string != ''){
			$this->db->where($query_string, null, false);
		}

		if(count($arr_filter) != 0){
			unset($arr_filter['nlimit']);
			foreach ($arr_filter as $key => $value) {
				if($key == 'msgd_nm1') {
					unset($arr_filter['msgd_nm1']);
					$arr_filter['x.msgd_nm'] = $value;
				}elseif ($key == 'msgd_nm2') {
					unset($arr_filter['msgd_nm2']);
					$arr_filter['y.msgd_nm'] = $value;
				}elseif ($key == 'mscb_nm1') {
					unset($arr_filter['mscb_nm1']);
					$arr_filter['a.mscb_nm'] = $value;
				}elseif ($key == 'mscb_nm2') {
					unset($arr_filter['mscb_nm2']);
					$arr_filter['b.mscb_nm'] = $value;
				}				
			}

			
			// unset($arr_filter['trmt_mscb_no']);
			// unset($arr_filter['trmt_mscb_no2']);

			$this->db->like($arr_filter);

			// $query_string = '((trmt_mscb_no2="'.$this->session->userdata('user_aktif')['msus_mscb_no'].'") OR (trmt_mscb_no="'.$this->session->userdata('user_aktif')['msus_mscb_no'].'")) ';
			// $this->db->where($query_string, null, false);
		}

		$this->db->order_by($fn, $sort);

		if($nlimit > 0){
			$this->db->limit($nlimit);
		}else{			
			if(!$is_count){
				$this->db->limit($per_page, $offset);		
			}
		}
		
		$query = $this->db->get();				
		if(!$is_count){
			return $query->result_array();
		}else{
			return $query->num_rows();				
		}
	}	

	public function get_mutasi($trmt_no){		
		$data = array();

		//Get mutasi header berdasarkan trmt_no	
		$this->db->select('tr_mutasi.*, 
							crt.msus_no as crt_msus_no, crt.msus_nm as crt_msus_nm, 
							kirim.msus_nm as kirim_usr,
							terima.msus_nm as terima_usr,
							mscb_nm,
							NOT EXISTS(SELECT x1.* FROM dt_mutasi x1 WHERE x1.dtmt_no = trmt_no AND x1.dtmt_qtyout <> x1.dtmt_qtyin) AS dlv_accurate,
							EXISTS(SELECT x1.* FROM dt_mutasi x1 WHERE x1.dtmt_no = trmt_no AND x1.dtmt_qtyout <> x1.dtmt_qtyin) AND NOT EXISTS(SELECT x2.* FROM dt_mutasi x2 WHERE x2.dtmt_no = trmt_no AND x2.dtmt_stapv = "N") AS dlv_inacc_approved,
							EXISTS(SELECT x1.* FROM dt_mutasi x1 WHERE x1.dtmt_no = trmt_no AND x1.dtmt_qtyout <> x1.dtmt_qtyin AND x1.dtmt_stapv = "N" AND trmt_tglterima <> "0000-00-00") AS dlv_inacc_unapproved');
		$this->db->from('tr_mutasi');		
		$this->db->join('ms_user as crt','crt.msus_no = tr_mutasi.trmt_msus_no', 'left');
		$this->db->join('ms_user as kirim','kirim.msus_no = tr_mutasi.trmt_usrkirim', 'left');
		$this->db->join('ms_user as terima','terima.msus_no = tr_mutasi.trmt_usrterima', 'left');
		$this->db->join('ms_cabang','ms_cabang.mscb_no = tr_mutasi.trmt_mscb_no1', 'left');
		$this->db->where('tr_mutasi.trmt_no',$trmt_no);
		
		$query = $this->db->get();

		if($query->num_rows() > 0){
			$result = $query->result_array();	
			$data['header'] = $result[0];
		}
		
		//Get mutasi detail berdasarkan trmt_no	
		$this->db->select('*, EXISTS(SELECT apmt_no FROM apv_mutasi WHERE apmt_no = dtmt_no AND apmt_seq = dtmt_seq) AS is_hasapproved');
		$this->db->from('dt_mutasi');
		$this->db->join('ms_produk', 'dt_mutasi.dtmt_mspd_no = ms_produk.mspd_no','left');		
		$this->db->join('tr_mutasi', 'trmt_no = dtmt_no','left');
		$this->db->join('ms_stok', 'msst_mspd_no = dtmt_mspd_no AND msst_msgd_no = trmt_msgd_no1','left');
		$this->db->where('dt_mutasi.dtmt_no',$trmt_no);
		$this->db->order_by('dtmt_seq', 'ASC');
		$query = $this->db->get();
		if($query->num_rows() > 0){
			$detail = $query->result_array();	
			$data['detail'] = $detail;
		}
		if(count($data) > 0){
			return $data;
		}else{
			return false;
		}
	}

	public function get_dt_mutasi($dtmt_no){

		//Get mutasi detail berdasarkan trmt_no	
		$this->db->select('*');
		$this->db->from('dt_mutasi');
		$this->db->join('ms_produk', 'dt_mutasi.dtmt_mspd_no = ms_produk.mspd_no','inner');
		$this->db->where('dtmt_no',$dtmt_no);
		$query = $this->db->get();				
		return $query->result_array();						
	}

	public function get_approval_mutasi($apmt_no, $apmt_seq){		
		$this->db->select('apv_mutasi.*, msus_nm, mscb_nm');
		$this->db->from('apv_mutasi');		
		$this->db->join('ms_user', 'ms_user.msus_no = apv_mutasi.apmt_msus_no','inner');
		$this->db->join('ms_cabang', 'ms_cabang.mscb_no = apv_mutasi.apmt_mscb_no','inner');
		$this->db->where(array('apmt_no' => $apmt_no, 'apmt_seq' => $apmt_seq));		
		$query = $this->db->get();				
		$result = $query->result_array();
		return $result[0];
	}

	public function mutasi_kode_auto($trmt_kode_depan){
		$this->db->select_max("trmt_no");
		$this->db->like("trmt_no", $trmt_kode_depan, "after");
		$query = $this->db->get("tr_mutasi");
		if ($query->num_rows() == 0){
			return $trmt_kode_depan. "0001";
		}else {
			$result = $query->result_array();
			$kode = $result[0]['trmt_no'];
			$nomor = ((int) substr($kode, 8)) + 1;			
			return $trmt_kode_depan. sprintf("%'.04d", $nomor);
		}
	}

	public function get_mutasi_cekint($trmt_no, $trmt_cekint){		
		$query = $this->db->get_where('tr_mutasi', array('trmt_no' => $trmt_no, 'trmt_cekint' => $trmt_cekint));				 
		if($query->num_rows() > 0){
			return true;
		}else{
			return false;
		}
	}

	public function set_mutasi_cekint($trmt_no){		
		//Update trmt_cekint di tabel tr_mutasi
		$this->db->where('trmt_no', $trmt_no);
		$this->db->update('tr_mutasi', array('trmt_cekint' => rand(0,10000)));
	}

	public function mutasi_simpan($data){	
		try {			
				if($data['action'] == 'NEW'){
					//todo list
					//1. Insert header mutasi
					//2. Insert detail mutasi

					//1. Insert header mutasi
					// Generate CekInt
					$data['header']['trmt_cekint'] = rand(0,10000);
					$this->db->insert('tr_mutasi',$data['header']);
					//2. Insert detail mutasi
					if(isset($data['detail'])){
						for ($i=0; $i < count($data['detail']) ; $i++) {										
						    $this->db->insert('dt_mutasi',$data['detail'][$i]);				    
						}			
					}			
				}		

				if($data['action'] == 'EDIT'){					
					$this->update_data($data);
					// Simpan userlog
					$this->m_user_log->user_log_simpan($data['userlog']);					
				}

				if($data['action'] == 'DELIVERYNOW'){
					//todo list
					//1. Update data mutasi header/detail					
					//2. Update hpp (-)
					//3. Update stok (-)
					//4. Create jurnal

					//1. Update data mutasi header/detail
					$this->update_data($data);					
					//2. Update hpp (-)
					$this->save_update_hpp('DELIVERYNOW', $data['header']['trmt_no'], -1, 'MDN');
					// $this->update_hpp('DELIVERYNOW', $data['header']['trmt_no'], -1);
					//3. Update stok (-)
					$this->update_stok('DELIVERYNOW', $data['header']['trmt_no'], -1);
					//4. Create jurnal
					$this->jurnal_simpan($data);
				}

				if($data['action'] == 'CANCEL_DELIVERYNOW'){
					//todo list
					//1. Update hpp (+)
					//2. Update stok (+)
					//3. Update data mutasi header/detail					
					//4. Delete jurnal

					//1. Update hpp (+)
					$this->save_update_hpp('CANCEL_DELIVERYNOW', $data['header']['trmt_no'], 1, 'MCD');
					// $this->update_hpp('CANCEL_DELIVERYNOW', $data['header']['trmt_no'], 1);
					//2. Update stok (+)
					$this->update_stok('CANCEL_DELIVERYNOW', $data['header']['trmt_no'], 1);
					//3. Update data mutasi header/detail
					$this->update_data($data);							
					//4. Delete jurnal
					$this->jurnal_hapus($data);
				}

				if($data['action'] == 'RECEIVE_GOODS'){
					//todo list
					//1. Update data mutasi header/detail										
					//2. Update hpp (+)
					//3. Update stok (+)										
					//4. Create jurnal
					//5. Update status copy

					//1. Update data mutasi header/detail
					$this->update_data($data);					
					//2. Update hpp (+)
					$this->save_update_hpp('RECEIVE_GOODS', $data['header']['trmt_no'], 1, 'MRG');
					// $this->update_hpp('RECEIVE_GOODS', $data['header']['trmt_no'], 1);
					//3. Update stok (+)
					$this->update_stok('RECEIVE_GOODS', $data['header']['trmt_no'], 1);					
					//4. Create jurnal
					$this->jurnal_simpan($data);
					//5. Update status copy
					$this->update_stcopy($data);
				}

				if($data['action'] == 'CANCEL_RECEIVE_GOODS'){
					//todo list
					//1. Update hpp (-)
					//2. Update stok (-)
					//3. Update data mutasi header/detail										
					//4. Delete jurnal
					//5. Update status copy
					
					//1. Update hpp (-)
					$this->save_update_hpp('CANCEL_RECEIVE_GOODS', $data['header']['trmt_no'], -1, 'MCR');
					// $this->update_hpp('CANCEL_RECEIVE_GOODS', $data['header']['trmt_no'], -1);
					//2. Update stok (-)
					$this->update_stok('CANCEL_RECEIVE_GOODS', $data['header']['trmt_no'], -1);					
					//3. Update data mutasi header/detail
					$this->update_data($data);														
					//4. Delete jurnal
					$this->jurnal_hapus($data);
					//5. Update status copy
					$this->update_stcopy($data);
				}

				if($data['action'] == 'VOID'){									
					//void mutasi									
					$this->db->where('trmt_no', $data['header']['trmt_no']);
					$this->db->update('tr_mutasi', array('trmt_void'=>1));
					// Simpan userlog
					$this->m_user_log->user_log_simpan($data['userlog']);					
				}

				if($data['action'] == 'STCOPY'){					
					$this->db->where('trmt_no', $data['header']['trmt_no']);
					$this->db->update('tr_mutasi', array('trmt_stcopy'=>$data['header']['trmt_stcopy']));
				}
				return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}	

	// private function update_dtmt_hpp($trmt_no){		
	// 	$query = "UPDATE dt_mutasi"
	// 				." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(dt_mutasi.dtmt_mspd_no,1,1)"
	// 				." SET dtmt_hpp ="
	// 				." (SELECT mspd_hpp FROM ms_produk A WHERE A.mspd_no = dt_mutasi.dtmt_mspd_no)"
	// 				." WHERE dt_mutasi.dtmt_no = '".$trmt_no."'"
	// 				." AND KT.mskt_statusinv = 'Y'"
	// 				." AND dt_mutasi.dtmt_qtyin > 0";

	// 	if($this->db->simple_query($query)){		
	// 		return 1;
	// 	}else{
	// 		return 0;
	// 	}		
	// }

	private function update_dtmt_qtyin($trmt_no){
		$this->db->where('dtmt_no', $trmt_no);
		$this->db->update('dt_mutasi', array('dtmt_qtyin' => 0));
	}

	private function update_stcopy($data){
		$query = $this->db->query('SELECT trmt_stcopy FROM tr_mutasi WHERE trmt_no ="'. $data['header']['trmt_no'].'" AND (trmt_stcopy = "A" OR trmt_stcopy = "F")');
		
		if($query->num_rows() <= 0){
			$proses = false;		
			if($data['action'] == 'RECEIVE_GOODS' || $data['action'] == 'APPROVAL' || $data['action'] == 'CANCEL_APPROVAL'){			
				$query = $this->db->get_where('dt_mutasi', array('dtmt_no' => $data['header']['trmt_no'], 'dtmt_stapv' => 'N'));			
				if($query->num_rows() <= 0){
					if($data['action'] == 'CANCEL_APPROVAL'){
						$status = 'W';
					}else{
						$status = 'R';
					}
					$proses = true;
				}
			}elseif($data['action'] == 'CANCEL_RECEIVE_GOODS'){		
				$status = 'W';
				$proses = true;			
			}		

			if($proses){
				$this->db->where('trmt_no', $data['header']['trmt_no']);
				$this->db->update('tr_mutasi', array('trmt_stcopy'=>$status));			
			}
		}
	}

	private function update_data($data){		
		$this->db->where('trmt_no', $data['header']['trmt_no']);
		$this->db->update('tr_mutasi', $data['header']);
		
		$this->db->where(array('dtmt_no' => $data['header']['trmt_no']));
		$this->db->delete('dt_mutasi');

		if(isset($data['detail'])){
			foreach ($data['detail'] as $key => $value) {							
				$this->db->insert('dt_mutasi', $data['detail'][$key]);
			}						
		}
	}

	public function mutasi_edit_ekspedisi($data){
		try {																
				$this->db->where('trmt_no', $data['header']['trmt_no']);
				$this->db->update('tr_mutasi', array('trmt_ekspedisi' => $data['header']['trmt_ekspedisi'], 'trmt_noekspedisi' => $data['header']['trmt_noekspedisi']));				
				return 1;				
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function save_update_hpp($menu, $trmt_no, $i, $trhpp_refjenis){
		$trhpp_tgl = date('Y-m-d H:i:s');

		if($menu == 'DELIVERYNOW' || $menu == 'CANCEL_DELIVERYNOW') {
			$jenisqtymutasi = 'dtmt_qtyout';
		}
		else if($menu == 'RECEIVE_GOODS' || $menu == 'CANCEL_RECEIVE_GOODS'){
			$jenisqtymutasi = 'dtmt_qtyin';
		}

		$query = "INSERT INTO tr_his_hpp(trhpp_tgl, trhpp_refjenis, trhpp_refno, trhpp_mspd_no, trhpp_qtyawal, trhpp_hppawal, trhpp_qtytrans, trhpp_totaltrans)
							(SELECT '".$trhpp_tgl."',
									'".$trhpp_refjenis."',
									'".$trmt_no."',
									D.dtmt_mspd_no, 
									(SELECT SUM(S.msst_qty) FROM ms_stok S WHERE S.msst_mspd_no = D.dtmt_mspd_no),
									 P.mspd_hpp,
									 SUM(".$i." * D.".$jenisqtymutasi."),
									ROUND(SUM((".$i." * D.".$jenisqtymutasi.") * D.dtmt_hpp), 4)
							FROM dt_mutasi D 
							LEFT JOIN ms_produk P 
							ON P.mspd_no = D.dtmt_mspd_no
							LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtmt_mspd_no,1,1)
							WHERE D.dtmt_no = '".$trmt_no."'
							AND D.".$jenisqtymutasi." <> 0
							AND KT.mskt_statusinv = 'Y'
							GROUP BY D.dtmt_mspd_no, D.dtmt_hpp)";

		$this->db->simple_query($query);

		// if($menu == 'DELIVERYNOW' || $menu == 'CANCEL_DELIVERYNOW'){
		// 		$query = "INSERT INTO tr_his_hpp(trhpp_tgl, trhpp_refjenis, trhpp_refno, trhpp_mspd_no, trhpp_qtyawal, trhpp_hppawal, trhpp_qtytrans, trhpp_totaltrans)
		// 							(SELECT '".$trhpp_tgl."',
		// 									'".$trhpp_refjenis."',
		// 									'".$trmt_no."',
		// 									D.dtmt_mspd_no, 
		// 									(SELECT SUM(S.msst_qty) FROM ms_stok S WHERE S.msst_mspd_no = D.dtmt_mspd_no),
		// 									 P.mspd_hpp,
		// 									 SUM(".$i." * D.dtmt_qtyout),
		// 									ROUND(SUM((".$i." * D.dtmt_qtyout) * D.dtmt_hpp), 4)
		// 							FROM dt_mutasi D 
		// 							LEFT JOIN ms_produk P 
		// 							ON P.mspd_no = D.dtmt_mspd_no
		// 							LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtmt_mspd_no,1,1)
		// 							WHERE D.dtmt_no = '".$trmt_no."'
		// 							AND D.dtmt_qtyout > 0
		// 							AND KT.mskt_statusinv = 'Y'
		// 							GROUP BY D.dtmt_mspd_no, D.dtmt_hpp)";
		// }

		// if($menu == 'RECEIVE_GOODS' || $menu == 'CANCEL_RECEIVE_GOODS'){
		// 		$query = "INSERT INTO tr_his_hpp(trhpp_tgl, trhpp_refjenis, trhpp_refno, trhpp_mspd_no, trhpp_qtyawal, trhpp_hppawal, trhpp_qtytrans, trhpp_totaltrans)
		// 							(SELECT '".$trhpp_tgl."',
		// 									'".$trhpp_refjenis."',
		// 									'".$trmt_no."',
		// 									D.dtmt_mspd_no, 

		// 									(SELECT SUM(S.msst_qty) FROM ms_stok S WHERE S.msst_mspd_no = D.dtmt_mspd_no),
		// 									 P.mspd_hpp,
		// 									 SUM(".$i." * D.dtmt_qtyin),
		// 									ROUND(SUM((".$i." * D.dtmt_qtyin) * D.dtmt_hpp), 4)
		// 							FROM dt_mutasi D 
		// 							LEFT JOIN ms_produk P 
		// 							ON P.mspd_no = D.dtmt_mspd_no 
		// 							LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtmt_mspd_no,1,1)
		// 							WHERE D.dtmt_no = '".$trmt_no."'
		// 							AND D.dtmt_qtyin > 0
		// 							AND KT.mskt_statusinv = 'Y'
		// 							GROUP BY D.dtmt_mspd_no, D.dtmt_hpp)";
		// }

		// $this->db->simple_query($query);

		$query = "UPDATE tr_his_hpp 
					SET trhpp_totalawal = ROUND((trhpp_qtyawal * trhpp_hppawal), 4),
						trhpp_hppakhir = IF(
							(trhpp_qtyawal + (trhpp_qtytrans)) <> 0,
							ROUND(
								((trhpp_qtyawal * trhpp_hppawal) + (trhpp_totaltrans))
								 /
								 (trhpp_qtyawal + (trhpp_qtytrans)), 4), trhpp_hppawal)
					WHERE trhpp_tgl = '".$trhpp_tgl."'
					AND trhpp_refjenis = '".$trhpp_refjenis."'
					AND trhpp_refno = '".$trmt_no."'";

		$this->db->simple_query($query);

		$query = "UPDATE ms_produk P 
							SET P.mspd_hpp = IFNULL((SELECT trhpp_hppakhir FROM tr_his_hpp 
										WHERE trhpp_tgl = '".$trhpp_tgl."'
										AND trhpp_refjenis = '".$trhpp_refjenis."'
										AND trhpp_refno = '".$trmt_no."'
										AND trhpp_mspd_no = P.mspd_no), P.mspd_hpp)
				WHERE P.mspd_no IN
				(SELECT dtmt_mspd_no FROM dt_mutasi D
				LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(D.dtmt_mspd_no,1,1)
				WHERE D.dtmt_no = '".$trmt_no."'
				AND KT.mskt_statusinv = 'Y'";

		if($menu == 'DELIVERYNOW' || $menu == 'CANCEL_DELIVERYNOW'){
			$query .= ' AND D.dtmt_qtyout <> 0)';
		}

		if($menu == 'RECEIVE_GOODS' || $menu == 'CANCEL_RECEIVE_GOODS'){
			$query .= ' AND D.dtmt_qtyin <> 0)';
		}

		$this->db->simple_query($query);
	}

	// private function update_hpp($menu, $trmt_no, $i){

	// 	if($menu == 'DELIVERYNOW' || $menu == 'CANCEL_DELIVERYNOW'){
	// 			$query = "UPDATE ms_produk SET mspd_hpp =ROUND("
	// 										."((mspd_hpp * (SELECT SUM(A.msst_qty) FROM ms_stok A WHERE A.msst_mspd_no = ms_produk.mspd_no))"
	// 										." +"
	// 										." (SELECT (".$i." * SUM(B.dtmt_qtyout * B.dtmt_hpp)) FROM dt_mutasi B"
	// 											." WHERE B.dtmt_no = '".$trmt_no."'"
	// 											." AND B.dtmt_mspd_no = ms_produk.mspd_no))"
	// 										." /"
	// 										." ((SELECT SUM(C.msst_qty) FROM ms_stok C WHERE C.msst_mspd_no = ms_produk.mspd_no)"
	// 										 ." +"
	// 										 ." (SELECT (".$i." * SUM(D.dtmt_qtyout)) FROM dt_mutasi D"
	// 											." WHERE D.dtmt_no = '".$trmt_no."'"
	// 											." AND D.dtmt_mspd_no= ms_produk.mspd_no)), 4)"
											 
	// 										." WHERE ms_produk.mspd_no IN"
	// 											." (SELECT E.dtmt_mspd_no FROM dt_mutasi E"
	// 											." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(E.dtmt_mspd_no,1,1)"
	// 											." WHERE E.dtmt_no = '".$trmt_no."'"
	// 											." AND KT.mskt_statusinv = 'Y')"
											
	// 										." AND ((SELECT SUM(F.msst_qty) FROM ms_stok F WHERE F.msst_mspd_no = ms_produk.mspd_no)"
	// 											." +"
	// 											." (SELECT (".$i." * SUM(G.dtmt_qtyout)) FROM dt_mutasi G"
	// 											." WHERE G.dtmt_no = '".$trmt_no."'"
	// 											." AND G.dtmt_mspd_no= ms_produk.mspd_no)) <> 0";
	// 	}


	// 	if($menu == 'RECEIVE_GOODS' || $menu == 'CANCEL_RECEIVE_GOODS'){
	// 			$query = "UPDATE ms_produk SET mspd_hpp =ROUND("
	// 										." ((mspd_hpp * (SELECT SUM(A.msst_qty) FROM ms_stok A WHERE A.msst_mspd_no = ms_produk.mspd_no))"
	// 										." +"
	// 										." (SELECT (".$i." * SUM(B.dtmt_qtyin * B.dtmt_hpp)) FROM dt_mutasi B"
	// 											." WHERE B.dtmt_no = '".$trmt_no."'"
	// 											." AND B.dtmt_mspd_no = ms_produk.mspd_no))"
	// 										." /"
	// 										." ((SELECT SUM(C.msst_qty) FROM ms_stok C WHERE C.msst_mspd_no = ms_produk.mspd_no)"
	// 										 ." +"
	// 										 ." (SELECT (".$i." * SUM(D.dtmt_qtyin)) FROM dt_mutasi D"
	// 											." WHERE D.dtmt_no = '".$trmt_no."'"
	// 											." AND D.dtmt_mspd_no= ms_produk.mspd_no)),4)"
											 
	// 										." WHERE ms_produk.mspd_no IN"
	// 											." (SELECT E.dtmt_mspd_no FROM dt_mutasi E"
	// 											." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(E.dtmt_mspd_no,1,1)"
	// 											." WHERE E.dtmt_no = '".$trmt_no."'"
	// 											." AND KT.mskt_statusinv = 'Y'"
	// 											." AND E.dtmt_qtyin <> 0)"
											
	// 										." AND ((SELECT SUM(F.msst_qty) FROM ms_stok F WHERE F.msst_mspd_no = ms_produk.mspd_no)"
	// 											." +"
	// 											." (SELECT (".$i." * SUM(G.dtmt_qtyin)) FROM dt_mutasi G"
	// 											." WHERE G.dtmt_no = '".$trmt_no."'"
	// 											." AND G.dtmt_mspd_no= ms_produk.mspd_no)) <> 0";
	// 	}

	// 	if($this->db->simple_query($query)){		
	// 		return 1;
	// 	}else{
	// 		return 0;
	// 	}		
		
	// }

	public function update_stok($menu, $trmt_no, $i){
		if($menu == 'DELIVERYNOW' || $menu == 'CANCEL_DELIVERYNOW'){
				$query = "INSERT INTO ms_stok(msst_mspd_no, msst_msgd_no, msst_qty)"
								." (SELECT DISTINCT A.dtmt_mspd_no, B.trmt_msgd_no1, 0 FROM dt_mutasi A"
								." LEFT JOIN tr_mutasi B ON B.trmt_no = A.dtmt_no"
								." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(A.dtmt_mspd_no, 1,1)"
								." WHERE A.dtmt_no = '".$trmt_no."'"
								." AND KT.mskt_statusinv = 'Y'"
								." AND NOT EXISTS(SELECT C.* FROM ms_stok C"
										." WHERE C.msst_mspd_no = A.dtmt_mspd_no"
										." AND C.msst_msgd_no= B.trmt_msgd_no1))";
				$this->db->simple_query($query);

				$query = "UPDATE ms_stok SET msst_qty = msst_qty +"
								." (".$i." * (SELECT SUM(A.dtmt_qtyout) FROM dt_mutasi A"
								." WHERE A.dtmt_no = '".$trmt_no."'"
								." AND A.dtmt_mspd_no = ms_stok.msst_mspd_no))"
						." WHERE ms_stok.msst_mspd_no IN"
								." (SELECT B.dtmt_mspd_no FROM dt_mutasi B"
								." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(B.dtmt_mspd_no,1,1)"
								." WHERE B.dtmt_no = '".$trmt_no."'"
								." AND KT.mskt_statusinv = 'Y'"
								." AND B.dtmt_qtyout <> 0)"
						." AND ms_stok.msst_msgd_no ="
								." (SELECT C.trmt_msgd_no1 FROM tr_mutasi C"
								." WHERE C.trmt_no = '".$trmt_no."')";
		}
		
		if($menu == 'RECEIVE_GOODS' || $menu == 'CANCEL_RECEIVE_GOODS'){
				$query = "INSERT INTO ms_stok(msst_mspd_no, msst_msgd_no, msst_qty)"
								." (SELECT DISTINCT A.dtmt_mspd_no, B.trmt_msgd_no2, 0 FROM dt_mutasi A"
								." LEFT JOIN tr_mutasi B ON B.trmt_no = A.dtmt_no"
								." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(A.dtmt_mspd_no, 1,1)"
								." WHERE A.dtmt_no = '".$trmt_no."'"
								." AND KT.mskt_statusinv = 'Y'"
								." AND NOT EXISTS(SELECT C.* FROM ms_stok C"
										." WHERE C.msst_mspd_no = A.dtmt_mspd_no"
										." AND C.msst_msgd_no= B.trmt_msgd_no2))";
				$this->db->simple_query($query);			

				$query = "UPDATE ms_stok SET msst_qty = msst_qty +"
								." (".$i." * (SELECT SUM(A.dtmt_qtyin) FROM dt_mutasi A"
								." WHERE A.dtmt_no = '".$trmt_no."'"
								." AND A.dtmt_mspd_no = ms_stok.msst_mspd_no))"
							." WHERE ms_stok.msst_mspd_no IN"
								." (SELECT B.dtmt_mspd_no FROM dt_mutasi B"
								." LEFT JOIN ms_kategori KT ON KT.mskt_no = SUBSTRING(B.dtmt_mspd_no,1,1)"
								." WHERE B.dtmt_no = '".$trmt_no."'"
								." AND KT.mskt_statusinv = 'Y'"
								." AND B.dtmt_qtyin <> 0)"
							." AND ms_stok.msst_msgd_no =" 
								." (SELECT C.trmt_msgd_no2 FROM tr_mutasi C"
								." WHERE C.trmt_no = '".$trmt_no."')";
		}
			
		if($this->db->simple_query($query)){		
			return 1;
		}else{
			return 0;
		}					
	}

	public function approval_mutasi_simpan($data){
		try {														
				$this->db->set('dtmt_stapv', 'Y');
				$this->db->where(array('dtmt_no' => $data['header']['apmt_no'], 'dtmt_seq' => $data['header']['apmt_seq']));
				$this->db->update('dt_mutasi');
				
				// Update status copy
				$this->update_stcopy($data);				
								
				unset($data['header']['trmt_no']);

				//Insert data approval mutasi
				$this->db->insert('apv_mutasi',$data['header']);

				return 1;				
		} catch (Exception $e) {
			return 0;
		}		
	}

	public function approval_mutasi_cancel($data){
		try {									
			
			// Update status copy
			$this->update_stcopy($data);

			$this->db->delete('apv_mutasi', array('apmt_no' => $data['header']['apmt_no'], 'apmt_seq' => $data['header']['apmt_seq']));

			$this->db->set('dtmt_stapv', 'N');
			$this->db->where(array('dtmt_no' => $data['header']['apmt_no'], 'dtmt_seq' => $data['header']['apmt_seq']));
			$this->db->update('dt_mutasi');			
				
			return 1;	
		} catch (Exception $e) {
			return 0;
		}		
	}	

	public function get_dtmt_hpp($dtmt_no, $dtmt_seq){
		$query = $this->db->get_where('dt_mutasi', array('dtmt_no'=>$dtmt_no, 'dtmt_seq'=>$dtmt_seq));
		if($query->num_rows() > 0){
			$result = $query->result_array();
			return $result[0]['dtmt_hpp'];
		}
	}

	private function jurnal_simpan($data){										
		// Insert data header jurnal
		// Generate CekInt
		$data['jurnal_h']['trju_cekint'] = rand(0,10000);	
		$this->db->insert('tr_jurnal',$data['jurnal_h']);		

		//Insert data detail jurnal
		if(isset($data['jurnal_d'])){
			$seq = 1;
			foreach ($data['jurnal_d'] as $key => $value) {														
				$data['jurnal_d'][$key]['dtju_no'] = $data['jurnal_h']['trju_no'];
				$data['jurnal_d'][$key]['dtju_seq'] = $seq;
				$this->db->insert('dt_jurnal',$data['jurnal_d'][$key]);
				$seq += 1;
			}		
		}		
	}

	private function jurnal_hapus($data){		
		if(isset($data['jurnal_h']['trju_no']) && strlen($data['jurnal_h']['trju_no']) > 0){
			$this->db->delete('tr_jurnal', array('trju_no' => $data['jurnal_h']['trju_no']));
			$this->db->delete('dt_jurnal', array('dtju_no' => $data['jurnal_h']['trju_no']));
		}
	}

}