
<!-- ========================================== Delivery Address List ==================================== -->        
<div class="row clearfix">
	<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">

        <div class="tablelist-container col-md-12 col-sm-12 col-xs-12">
			<div class="srstyle-list-title list-title">
				<span>Delivery Address List<span>
				<button class="btn btn-default btn-xs btn-filter pull-right srstyle-btnfilter"><span class="glyphicon glyphicon-filter"></span> Filter</button>
			</div>

		    <div class="srstyle-col-content">
		        <table class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
		            <thead>
		                <tr class="filters">                			             	
        	                <th><span class="title-filter srstyle-cursor" sortby="ASC" id="mscs_no">Customer # <i class="fa fa-sort-alpha-desc" aria-hidden="true"></i></span><input type="text" class="form-control input-sm data-input-filter" name="mscs_no" id="mscs_no" style="display: none;"></th>
        	                <th><span class="title-filter srstyle-cursor" sortby="ASC" id="mscs_nm">Customer Name <i class="fa fa-sort-alpha-desc" aria-hidden="true"></i></span><input type="text" class="form-control input-sm data-input-filter" name="mscs_nm" id="mscs_nm" style="display: none;"></th>
        	                <th><span class="title-filter srstyle-cursor" sortby="ASC" id="mscsda_kirim_jln">Address <i class="fa fa-sort-alpha-desc" aria-hidden="true"></i></span><input type="text" class="form-control input-sm data-input-filter" name="mscsda_kirim_jln" id="mscsda_kirim_jln" style="display: none;"></th>
        	                <th><span class="title-filter srstyle-cursor" sortby="ASC" id="mscsda_kirim_kota">City <i class="fa fa-sort-alpha-desc" aria-hidden="true"></i></span><input type="text" class="form-control input-sm data-input-filter" name="mscsda_kirim_kota" id="mscsda_kirim_kota" style="display: none;"></th>
        	                <th><span class="title-filter srstyle-cursor" sortby="ASC" id="mscsda_kirim_provinsi">Province <i class="fa fa-sort-alpha-desc" aria-hidden="true"></i></span><input type="text" class="form-control input-sm data-input-filter" name="mscsda_kirim_provinsi" id="mscsda_kirim_provinsi" style="display: none;"></th>
			            </tr>
		            </thead>
		            <tbody id="mscsda-datalist-tbody">
		                
		            </tbody>
		        </table>

		    </div>
		</div>

		<div class="col-md-12 col-sm-12 col-xs-12 srstyle-nopadding">
			<div class="pull-right pagination-container"></div>	
			<div id="info-list" class="pull-right srstyle-infolist"></div>
		</div>        
	    
    </div>
</div> 
<!-- ========================================== End Delivery Address List ==================================== -->

<script type="text/javascript">

	$(document).ready(function(){				                     
		
		//function untuk mengambil value textbox filter			
		function fobjFilter(){
			var objFilter = {};						

			$(".data-input-filter").each(function(){
				if($(this).val() !== "" ){					
					var vinput_name = $(this).attr("name");
					objFilter[vinput_name] = $(this).val();                           							
				}				
			});
			return objFilter;
		}

		//Ajax POST untuk menampilkan delivery address list (inisial)
		var vper_page = 15;
		var vcurr_page = 1;
		$.ajax({
			method:"POST",
			data:{per_page:vper_page, offset:(vcurr_page - 1) * vper_page, curr_page: vcurr_page, sort:'ASC',fn:'mscsda_seq', arr_filter: fobjFilter(), key:$("#key").val(), hash_key:$("#hash_key").val()},
			url:"<?php echo base_url('customer/customer_dalist'); ?>",
			dataType:"json",
			success:function(r){				
				$("#mscsda-datalist-tbody").html(r.customer_dalist);												                               
				$(".pagination-container").html(r.pagination);
				vcurr_page = (r.total_list > 0) ? vcurr_page : 0;															
				$("#info-list").html("Pages: " + vcurr_page + " of " + Math.ceil(r.total_list / vper_page) + " (" + r.total_list + " Data)");
			}	
		});					

		//Ajak POST untuk pagination
		$(document).on('click','.page-number',function(){			
			vcurr_page = $(this).attr("id");
			vsort = $(this).attr("sortby");
			vfn = $(this).attr("fn");						
			$.ajax({
				method:"POST",
				data:{per_page:vper_page, offset:(vcurr_page - 1) * vper_page, curr_page: vcurr_page, sort:vsort, fn:'mscsda_seq', arr_filter: fobjFilter(), key:$("#key").val(), hash_key:$("#hash_key").val()},
				url:"<?php echo base_url('customer/customer_dalist'); ?>",
				dataType:"json",
				success:function(r){												
					$("#mscsda-datalist-tbody").html(r.customer_dalist);														                	                				
					$(".pagination-container").html(r.pagination);
					vcurr_page = (r.total_list > 0) ? vcurr_page : 0;															
					$("#info-list").html("Pages: " + vcurr_page + " of " + Math.ceil(r.total_list / vper_page) + " (" + r.total_list + " Data)");
				}	
			});			
		});

		//Ajak POST untuk filter
		$(document).on("input", ".data-input-filter", function(){
			vcurr_page = 1;					
			$.ajax({
				method:"POST",
				data:{per_page:vper_page, offset:(vcurr_page - 1) * vper_page, curr_page: vcurr_page, sort:"ASC",fn:"mscsda_seq", arr_filter: fobjFilter(), key:$("#key").val(), hash_key:$("#hash_key").val()},
				url:"<?php echo base_url('customer/customer_dalist'); ?>",
				dataType:"json",
				success:function(r){
					$("#mscsda-datalist-tbody").html(r.customer_dalist);														                               
					$(".pagination-container").html(r.pagination);
					vcurr_page = (r.total_list > 0) ? vcurr_page : 0;															
					$("#info-list").html("Pages: " + vcurr_page + " of " + Math.ceil(r.total_list / vper_page) + " (" + r.total_list + " Data)");																		
				}	
			});		
			$(".title-filter, .title-filter > i").removeClass("srstyle-fa-active");	
        });

		//Ajak POST untuk sort
		$(document).on("click", ".title-filter", function(){			
			vcurr_page = 1;			
			var vsort = $(this).attr("sortby");
			var vfn = $(this).attr("id");

			$.ajax({
				method:"POST",
				data:{per_page:vper_page, offset:(vcurr_page - 1) * vper_page, curr_page: vcurr_page, sort:vsort,fn:'mscsda_seq', arr_filter: fobjFilter(), key:$("#key").val(), hash_key:$("#hash_key").val()},
				url:"<?php echo base_url('customer/customer_dalist'); ?>",
				dataType:"json",
				success:function(r){
					$("#mscsda-datalist-tbody").html(r.customer_dalist);														                               		
					$(".pagination-container").html(r.pagination);
					vcurr_page = (r.total_list > 0) ? vcurr_page : 0;															
					$("#info-list").html("Pages: " + vcurr_page + " of " + Math.ceil(r.total_list / vper_page) + " (" + r.total_list + " Data)");																		
				}	
			});

			if (vsort == "ASC") {
				$(this).attr("sortby","DESC");
				$(this).find("i").removeClass("fa-sort-alpha-desc").addClass("fa fa-sort-alpha-asc");
			}else{
				$(this).attr("sortby","ASC");
				$(this).find("i").removeClass("fa-sort-alpha-asc").addClass("fa-sort-alpha-desc");
			}

			$(".title-filter").not($(this)).attr("sortby","ASC");
			$(".title-filter, .title-filter > i").not($(this)).removeClass("srstyle-fa-active");			
			$(this, this + " > i").addClass("srstyle-fa-active");

		});		

	});


</script> 
